/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.regtests;

import org.mariuszgromada.math.janetsudoku.SudokuStore;
import org.mariuszgromada.math.janetsudoku.regtests.RegTestsApi;
import org.mariuszgromada.math.janetsudoku.regtests.RegTestsGenerator;
import org.mariuszgromada.math.janetsudoku.regtests.RegTestsSolver;
import org.mariuszgromada.math.janetsudoku.regtests.RegTestsStore;
import org.mariuszgromada.math.janetsudoku.utils.DateTimeX;

public class RegTests {
    public static int start(int threadsNumber) {
        SudokuStore.consolePrintln("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        SudokuStore.consolePrintln("All regression tests - starting.");
        SudokuStore.consolePrintln("  - RegTestsSolver.start()");
        SudokuStore.consolePrintln("  - RegTestsGenerator.start()");
        SudokuStore.consolePrintln("  - RegTestsStore.start()");
        SudokuStore.consolePrintln("  - RegTestsApi.start()");
        SudokuStore.consolePrintln("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        long startTime = DateTimeX.currentTimeMillis();
        int solverErrors = RegTestsSolver.start(threadsNumber);
        int generatorErrors = RegTestsGenerator.start(threadsNumber);
        int storeErrors = RegTestsStore.start(threadsNumber);
        int apiErrors = RegTestsApi.start(threadsNumber);
        long endTime = DateTimeX.currentTimeMillis();
        double computingTime = (double)(endTime - startTime) / 1000.0;
        int totalErrors = solverErrors + generatorErrors + storeErrors + apiErrors;
        SudokuStore.consolePrintln("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        SudokuStore.consolePrintln("All regression tests - finished.");
        SudokuStore.consolePrintln("Errors: " + totalErrors);
        SudokuStore.consolePrintln("  - RegTestsSolver errors: " + solverErrors);
        SudokuStore.consolePrintln("  - RegTestsGenerator errors: " + generatorErrors);
        SudokuStore.consolePrintln("  - RegTestsStore errors: " + storeErrors);
        SudokuStore.consolePrintln("  - RegTestsApi errors: " + apiErrors);
        SudokuStore.consolePrintln("");
        SudokuStore.consolePrintln("Computing time: " + computingTime + " s.");
        SudokuStore.consolePrintln("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        return totalErrors;
    }

    public static int start() {
        return RegTests.start(Runtime.getRuntime().availableProcessors());
    }

    public static void main(String[] args) {
        int threadsNumber;
        if (args != null && args.length > 0 && args[0] != null && (threadsNumber = Integer.parseInt(args[0])) > 0) {
            RegTests.start(threadsNumber);
            return;
        }
        RegTests.start();
    }
}

