/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.regtests;

import org.mariuszgromada.math.janetsudoku.SudokuStore;
import org.mariuszgromada.math.janetsudoku.regtests.SolverTests;
import org.mariuszgromada.math.janetsudoku.utils.DateTimeX;

public class RegTestsSolver {
    public static int start() {
        return RegTestsSolver.start(SudokuStore.THREADS_NUMBER);
    }

    public static int start(int threadsNumber) {
        int numberOfTests = 18;
        int resultsError = 0;
        int resultsOk = 0;
        long startTime = DateTimeX.currentTimeMillis();
        SolverTests st = new SolverTests(threadsNumber);
        st.start();
        boolean[] testResults = st.testsResults;
        int t = 0;
        while (t < numberOfTests) {
            if (testResults[t]) {
                ++resultsOk;
            } else {
                ++resultsError;
            }
            ++t;
        }
        long endtTime = DateTimeX.currentTimeMillis();
        double computingTime = (double)(endtTime - startTime) / 1000.0;
        SudokuStore.consolePrintln("=============================================================");
        SudokuStore.consolePrintln("Number of SudokuSolver test: " + numberOfTests + ", OK: " + resultsOk + ", ERRORS: " + resultsError + ", computing time: " + computingTime);
        int t2 = 0;
        while (t2 < numberOfTests) {
            if (!testResults[t2]) {
                SudokuStore.consolePrintln("ERROR: " + t2);
            }
            ++t2;
        }
        SudokuStore.consolePrintln("=============================================================");
        return resultsError;
    }

    public static void main(String[] args) {
        int threadsNumber;
        if (args != null && args.length > 0 && args[0] != null && (threadsNumber = Integer.parseInt(args[0])) > 0) {
            RegTestsSolver.start(threadsNumber);
            return;
        }
        RegTestsSolver.start();
    }
}

