/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.regtests;

import org.mariuszgromada.math.janetsudoku.ErrorCodes;
import org.mariuszgromada.math.janetsudoku.SudokuPuzzles;
import org.mariuszgromada.math.janetsudoku.SudokuSolver;
import org.mariuszgromada.math.janetsudoku.SudokuStore;

class SolverTests {
    private static int THREADS_NUMBER;
    private TestRunner[] runners;
    private Thread[] threads;
    boolean[] testsResults;
    static final int NUMBER_OF_TESTS = 18;

    SolverTests(int threadsNumber) {
        THREADS_NUMBER = threadsNumber;
        this.threads = new Thread[THREADS_NUMBER];
        this.runners = new TestRunner[THREADS_NUMBER];
        this.testsResults = new boolean[18];
        int[] testsIds = new int[18];
        int i = 0;
        while (i < 18) {
            testsIds[i] = i;
            ++i;
        }
        i = 0;
        while (i < 18) {
            int lastIndex = 18 - i - 1;
            int j = SudokuStore.randomIndex(18 - i);
            if (j != lastIndex) {
                int l = testsIds[lastIndex];
                testsIds[lastIndex] = testsIds[j];
                testsIds[j] = l;
            }
            ++i;
        }
        int defThreadSize = 18 / THREADS_NUMBER;
        int remaining = 18 - defThreadSize * THREADS_NUMBER;
        int t = 0;
        int i2 = 0;
        while (i2 < THREADS_NUMBER) {
            int threadSize = defThreadSize;
            if (i2 < remaining) {
                ++threadSize;
            }
            int[] assigments = new int[threadSize];
            int j = 0;
            while (j < threadSize) {
                assigments[j] = testsIds[t];
                ++t;
                ++j;
            }
            this.runners[i2] = new TestRunner(i2, assigments);
            this.threads[i2] = new Thread(this.runners[i2]);
            ++i2;
        }
    }

    public void start() {
        int i = 0;
        while (i < THREADS_NUMBER) {
            this.threads[i].start();
            ++i;
        }
        i = 0;
        while (i < THREADS_NUMBER) {
            try {
                this.threads[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    static boolean runTest(int testId, int threadId) {
        boolean testResult = true;
        switch (testId) {
            case 0: {
                int example = 0;
                while (example < 161) {
                    SudokuSolver s = new SudokuSolver(example);
                    int solNum = s.findAllSolutions();
                    ErrorCodes.consolePrintlnIfError(solNum);
                    if (solNum != 1) {
                        testResult = false;
                    }
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", findAllSolutions, example: " + example + ", solutions: " + solNum + ", time: " + s.getComputingTime() + " s.");
                    ++example;
                }
                break;
            }
            case 1: {
                int example = 0;
                while (example < 161) {
                    SudokuSolver s = new SudokuSolver(example);
                    int solUnq = s.checkIfUniqueSolution();
                    ErrorCodes.consolePrintlnIfError(solUnq);
                    if (solUnq != 1) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", checkIfUniqueSolution, example: " + example + ", is solution unique: NO, time: " + s.getComputingTime() + " s.");
                    } else {
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", checkIfUniqueSolution, example: " + example + ", is solution unique: YES, time: " + s.getComputingTime() + " s.");
                    }
                    ++example;
                }
                break;
            }
            case 2: {
                int example = 0;
                while (example < 161) {
                    SudokuSolver s = new SudokuSolver(example);
                    int sol = s.solve();
                    ErrorCodes.consolePrintlnIfError(sol);
                    int[][] solution = s.getSolvedBoard();
                    boolean solCorr = SudokuStore.checkSolvedBoard(solution);
                    if (!solCorr) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: " + example + ", is solution correct: NO, time: " + s.getComputingTime() + " s.");
                    } else {
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: " + example + ", is solution correct: YES, time: " + s.getComputingTime() + " s.");
                    }
                    ++example;
                }
                break;
            }
            case 3: {
                int example = 0;
                while (example < 161) {
                    int[][] puzzle = SudokuStore.seqOfRandomBoardTransf(SudokuStore.getPuzzleExample(example));
                    SudokuSolver s = new SudokuSolver(puzzle);
                    int solNum = s.findAllSolutions();
                    ErrorCodes.consolePrintlnIfError(solNum);
                    if (solNum != 1) {
                        testResult = false;
                    }
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + findAllSolutions, example: " + example + ", solutions: " + solNum + ", time: " + s.getComputingTime() + " s.");
                    ++example;
                }
                break;
            }
            case 4: {
                int example = 0;
                while (example < 161) {
                    int[][] puzzle = SudokuStore.seqOfRandomBoardTransf(SudokuStore.getPuzzleExample(example));
                    SudokuSolver s = new SudokuSolver(puzzle);
                    int solUnq = s.checkIfUniqueSolution();
                    ErrorCodes.consolePrintlnIfError(solUnq);
                    if (solUnq != 1) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + checkIfUniqueSolution, example: " + example + ", is solution unique: NO, time: " + s.getComputingTime() + " s.");
                    } else {
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + checkIfUniqueSolution, example: " + example + ", is solution unique: YES, time: " + s.getComputingTime() + " s.");
                    }
                    ++example;
                }
                break;
            }
            case 5: {
                int example = 0;
                while (example < 161) {
                    int[][] puzzle = SudokuStore.seqOfRandomBoardTransf(SudokuStore.getPuzzleExample(example));
                    SudokuSolver s = new SudokuSolver(puzzle);
                    int sol = s.solve();
                    ErrorCodes.consolePrintlnIfError(sol);
                    int[][] solution = s.getSolvedBoard();
                    boolean solCorr = SudokuStore.checkSolvedBoard(solution);
                    if (!solCorr) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + solve, example: " + example + ", is solution correct: NO, time: " + s.getComputingTime() + " s.");
                    } else {
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + solve, example: " + example + ", is solution correct: YES, time: " + s.getComputingTime() + " s.");
                    }
                    ++example;
                }
                break;
            }
            case 6: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION);
                int solNum = s.findAllSolutions();
                ErrorCodes.consolePrintlnIfError(solNum);
                if (solNum <= 1) {
                    testResult = false;
                }
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", findAllSolutions, example: non unique, solutions: " + solNum + ", time: " + s.getComputingTime() + " s.");
                break;
            }
            case 7: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION);
                int solUnq = s.checkIfUniqueSolution();
                ErrorCodes.consolePrintlnIfError(solUnq);
                if (solUnq != 2) {
                    testResult = false;
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", checkIfUniqueSolution, example: non unique, is solution unique: YES, time: " + s.getComputingTime() + " s.");
                    break;
                }
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", checkIfUniqueSolution, example: non unique, is solution unique: NO, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 8: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION);
                int sol = s.solve();
                ErrorCodes.consolePrintlnIfError(sol);
                int[][] solution = s.getSolvedBoard();
                boolean solCorr = SudokuStore.checkSolvedBoard(solution);
                if (!solCorr) {
                    testResult = false;
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: non unique, is solution correct: NO, time: " + s.getComputingTime() + " s.");
                    break;
                }
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: non unique, is solution correct: YES, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 9: {
                int[][] puzzle = SudokuStore.seqOfRandomBoardTransf(SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION);
                SudokuSolver s = new SudokuSolver(puzzle);
                int solNum = s.findAllSolutions();
                ErrorCodes.consolePrintlnIfError(solNum);
                if (solNum <= 1) {
                    testResult = false;
                }
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + findAllSolutions, example: non unique, solutions: " + solNum + ", time: " + s.getComputingTime() + " s.");
                break;
            }
            case 10: {
                int[][] puzzle = SudokuStore.seqOfRandomBoardTransf(SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION);
                SudokuSolver s = new SudokuSolver(puzzle);
                int solUnq = s.checkIfUniqueSolution();
                ErrorCodes.consolePrintlnIfError(solUnq);
                if (solUnq != 2) {
                    testResult = false;
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + checkIfUniqueSolution, example: non unique, is solution unique: YES, time: " + s.getComputingTime() + " s.");
                    break;
                }
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + checkIfUniqueSolution, example: non unique, is solution unique: NO, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 11: {
                int[][] puzzle = SudokuStore.seqOfRandomBoardTransf(SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION);
                SudokuSolver s = new SudokuSolver(puzzle);
                int sol = s.solve();
                ErrorCodes.consolePrintlnIfError(sol);
                int[][] solution = s.getSolvedBoard();
                boolean solCorr = SudokuStore.checkSolvedBoard(solution);
                if (!solCorr) {
                    testResult = false;
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + solve, example: non unique, is solution correct: NO, time: " + s.getComputingTime() + " s.");
                    break;
                }
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", seqOfRandomBoardTransf + solve, example: non unique, is solution correct: YES, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 12: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_NO_SOLUTION);
                int solNum = s.findAllSolutions();
                ErrorCodes.consolePrintlnIfError(solNum);
                if (solNum != 0) {
                    testResult = false;
                }
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", findAllSolutions, example: no solution, solutions: " + solNum + ", time: " + s.getComputingTime() + " s.");
                break;
            }
            case 13: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_NO_SOLUTION);
                int solUnq = s.checkIfUniqueSolution();
                ErrorCodes.consolePrintlnIfError(solUnq);
                if (solUnq == -1) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", checkIfUniqueSolution, example: no solution, no solutions found: YES, time: " + s.getComputingTime() + " s.");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", checkIfUniqueSolution, example: no solution, no solutions found: NO, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 14: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_NO_SOLUTION);
                int sol = s.solve();
                int[][] solution = s.getSolvedBoard();
                if (s.getSolvingState() == -102) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: no solution, solving failed: YES, time: " + s.getComputingTime() + " s.");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: no solution, solving failed: NO, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 15: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_ERROR);
                int solvingState = s.solve();
                int boardState = s.getBoardState();
                if (boardState == -110 && solvingState == -101) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: board with error, board state error and solving not started: YES, time: " + s.getComputingTime() + " s.");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: board with error, board state error and solving not started: NO, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 16: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_REGTESTS);
                int sol = s.solve();
                ErrorCodes.consolePrintlnIfError(sol);
                if (SudokuStore.boardsAreEqual(s.getSolvedBoard(), SudokuPuzzles.PUZZLE_REGTESTS_SOLUTION)) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: with solution, solutions are equal: YES, time: " + s.getComputingTime() + " s.");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: with solution, solutions are equal: NO, time: " + s.getComputingTime() + " s.");
                break;
            }
            case 17: {
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_EMPTY);
                int sol = s.solve();
                int solUnq = s.checkIfUniqueSolution();
                ErrorCodes.consolePrintlnIfError(sol);
                ErrorCodes.consolePrintlnIfError(solUnq);
                if (SudokuStore.checkSolvedBoard(s.getSolvedBoard()) & solUnq == 2) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: empty puzzle, found solution and solution non unique: YES, time: " + s.getComputingTime() + " s.");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", solve, example: empty puzzle, found solution and solution non unique: NO, time: " + s.getComputingTime() + " s.");
            }
        }
        if (testResult) {
            SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + " >>>>>>>>>>>>>>>>>>>>>> SudokuSolver, result: OK");
        } else {
            SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + " >>>>>>>>>>>>>>>>>>>>>> SudokuSolver, result: ERROR");
        }
        return testResult;
    }

    class TestRunner
    implements Runnable {
        int threadId;
        int[] assigments;

        TestRunner(int threadId, int[] assigments) {
            this.assigments = assigments;
            this.threadId = threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTestResult(int t, boolean result) {
            boolean[] blArray = SolverTests.this.testsResults;
            synchronized (SolverTests.this.testsResults) {
                SolverTests.this.testsResults[t] = result;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public void run() {
            int[] nArray = this.assigments;
            int n = this.assigments.length;
            int n2 = 0;
            while (n2 < n) {
                int t = nArray[n2];
                this.setTestResult(t, SolverTests.runTest(t, this.threadId));
                ++n2;
            }
        }
    }
}

