/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.tutorial;

import org.mariuszgromada.math.janetsudoku.SudokuGenerator;
import org.mariuszgromada.math.janetsudoku.SudokuPuzzles;
import org.mariuszgromada.math.janetsudoku.SudokuSolver;
import org.mariuszgromada.math.janetsudoku.SudokuStore;
import org.mariuszgromada.math.janetsudoku.utils.FileX;

public class Tutorial {
    public static void main(String[] args) {
        String tmpDir = FileX.getTmpDir();
        SudokuStore.consolePrintln("----------------------------------------------------");
        SudokuStore.consolePrintln(">>>>>>>> Simple sudoku generation.");
        SudokuStore.consolePrintln("");
        SudokuStore.consolePrintln(">>>>>>>>>>>>>> Code:");
        SudokuStore.consolePrintln("");
        SudokuStore.consolePrintln("                 SudokuGenerator sg = new SudokuGenerator();");
        SudokuStore.consolePrintln("                 SudokuStore.consolePrintBoard(puzzle);");
        SudokuStore.consolePrintln("                 SudokuStore.consolePrintBoard(puzzle);");
        SudokuStore.consolePrintln("");
        SudokuStore.consolePrintln(">>>>>>>>>>>>>> Results:");
        SudokuStore.consolePrintln("");
        SudokuGenerator sg = new SudokuGenerator(new char[0]);
        int[][] puzzle = sg.generate();
        SudokuStore.consolePrintBoard(puzzle);
        SudokuStore.consolePrintln("");
        SudokuStore.consolePrintln("----------------------------------------------------");
        SudokuStore.consolePrintln(">>>>>>>> Simple sudoku generation + parameters.");
        sg = new SudokuGenerator('1');
        puzzle = sg.generate();
        SudokuStore.consolePrintBoard(puzzle);
        SudokuStore.consolePrintln("----------------------------------------------------");
        SudokuStore.consolePrintln(">>>>>>>> Simple sudoku generation + puzzle rating.");
        sg = new SudokuGenerator(new char[0]);
        puzzle = sg.generate();
        int rating = SudokuStore.calculatePuzzleRating(puzzle);
        SudokuStore.consolePrintBoard(puzzle);
        SudokuStore.consolePrintln("Puzzle rating: " + rating);
        SudokuStore.consolePrintln("----------------------------------------------------");
        SudokuStore.consolePrintln(">>>>>>>> Solving sudoku example.");
        SudokuSolver ss = new SudokuSolver(SudokuPuzzles.PUZZLE_EXAMPLE_001);
        SudokuStore.consolePrintBoard(ss.getBoard());
        ss.solve();
        SudokuStore.consolePrintBoard(ss.getSolvedBoard());
        SudokuStore.consolePrintln("----------------------------------------------------");
        SudokuStore.consolePrintln(">>>>>>>> Saving board examples " + tmpDir);
        SudokuStore.saveBoard(SudokuPuzzles.PUZZLE_EXAMPLE_001, String.valueOf(tmpDir) + "sudoku-board-ex-1.txt");
        SudokuStore.saveBoard(SudokuPuzzles.PUZZLE_EXAMPLE_001, String.valueOf(tmpDir) + "sudoku-board-ex-2.txt", "This is a head comment");
        SudokuStore.saveBoard(SudokuPuzzles.PUZZLE_EXAMPLE_001, String.valueOf(tmpDir) + "sudoku-board-ex-3.txt", "This is a head comment", "And a tail comment");
        ss = new SudokuSolver(1);
        ss.solve();
        ss.saveSolvedBoard(String.valueOf(tmpDir) + "sudoku-board-ex-sol.txt", "Solution for the PUZZLE_EXAMPLE_001");
        SudokuStore.consolePrintln("----------------------------------------------------");
        SudokuStore.consolePrintln(">>>>>>>> Puzzle modification");
        int[][] puzzle2 = SudokuStore.getPuzzleExample(0);
        int[][] puzzleRotated = SudokuStore.rotateClockWise(puzzle2);
        SudokuStore.consolePrintBoard(puzzle2);
        SudokuStore.consolePrintBoard(puzzleRotated);
    }
}

