/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.mariuszgromada.math.janetsudoku.SudokuStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileX {
    public static final ArrayList<String> readFileLines2ArraList(File file) {
        ArrayList<String> fileContent = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                fileContent = new ArrayList<String>();
                String line = null;
                while ((line = br.readLine()) != null) {
                    fileContent.add(line);
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fileContent;
    }

    public static final ArrayList<String> readFileLines2ArraList(String filePath) {
        return FileX.readFileLines2ArraList(new File(filePath));
    }

    public static boolean writeFile(File file, String content) {
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(content);
            fw.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writeFile(String filePath, String content) {
        return FileX.writeFile(new File(filePath), content);
    }

    public static final boolean removeFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        if (filePath.length() == 0) {
            return false;
        }
        File file = new File(filePath);
        if (!file.isFile()) {
            return false;
        }
        return file.delete();
    }

    public static final String getTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmp = new File(tmpDir);
        return String.valueOf(tmp.getAbsolutePath()) + File.separator;
    }

    public static final String genRndFileName(int length, String fileExt) {
        if (length <= 0) {
            return null;
        }
        if (fileExt == null) {
            return null;
        }
        return String.valueOf(FileX.randomString(length)) + "." + fileExt;
    }

    public static final String randomString(int length) {
        if (length < 1) {
            return "";
        }
        char[] chars = new char[]{'z', 'x', 'c', 'v', 'b', 'n', 'm', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        String rndStr = "";
        int i = 0;
        while (i < length) {
            rndStr = String.valueOf(rndStr) + chars[SudokuStore.randomIndex(chars.length)];
            ++i;
        }
        return rndStr;
    }
}

