/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;

public final class MathFunctions {
    public static final double bellNumber(int n) {
        double result = Double.NaN;
        if (n > 1) {
            long[][] bellTriangle = new long[--n + 1][n + 1];
            bellTriangle[0][0] = 1L;
            bellTriangle[1][0] = 1L;
            for (int r = 1; r <= n; ++r) {
                for (int k = 0; k < r; ++k) {
                    bellTriangle[r][k + 1] = bellTriangle[r - 1][k] + bellTriangle[r][k];
                }
                if (r >= n) continue;
                bellTriangle[r + 1][0] = bellTriangle[r][r];
            }
            result = bellTriangle[n][n];
        } else if (n >= 0) {
            result = 1.0;
        }
        return result;
    }

    public static final double bellNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.bellNumber((int)Math.round(n));
    }

    public static final double eulerNumber(int n, int k) {
        if (n < 0) {
            return Double.NaN;
        }
        if (k < 0) {
            return 0.0;
        }
        if (n == 0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)(k + 1) * MathFunctions.eulerNumber(n - 1, k) + (double)(n - k) * MathFunctions.eulerNumber(n - 1, k - 1);
    }

    public static final double eulerNumber(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.eulerNumber((int)Math.round(n), (int)Math.round(k));
    }

    public static final double factorial(int n) {
        double f = Double.NaN;
        if (n >= 0) {
            if (n < 2) {
                f = 1.0;
            } else {
                f = 1.0;
                for (int i = 1; i <= n; ++i) {
                    f *= (double)i;
                }
            }
        }
        return f;
    }

    public static final double factorial(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.factorial((int)Math.round(n));
    }

    public static final double binomCoeff(double n, int k) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (k >= 0) {
            double numerator = 1.0;
            if (k > 0) {
                for (int i = 0; i <= k - 1; ++i) {
                    numerator *= n - (double)i;
                }
            }
            double denominator = 1.0;
            if (k > 1) {
                for (int i = 1; i <= k; ++i) {
                    denominator *= (double)i;
                }
            }
            result = numerator / denominator;
        }
        return result;
    }

    public static final double binomCoeff(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.binomCoeff(n, (int)Math.round(k));
    }

    public static final double bernoulliNumber(int m, int n) {
        double result = Double.NaN;
        if (m >= 0 && n >= 0) {
            result = 0.0;
            for (int k = 0; k <= m; ++k) {
                for (int v = 0; v <= k; ++v) {
                    result += Math.pow(-1.0, v) * MathFunctions.binomCoeff((double)k, v) * (Math.pow(n + v, m) / (double)(k + 1));
                }
            }
        }
        return result;
    }

    public static final double bernoulliNumber(double m, double n) {
        if (Double.isNaN(m) || Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.bernoulliNumber((int)Math.round(m), (int)Math.round(n));
    }

    public static final double Stirling1Number(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (n == 0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (k == 0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)(n - 1) * MathFunctions.Stirling1Number(n - 1, k) + MathFunctions.Stirling1Number(n - 1, k - 1);
    }

    public static final double Stirling1Number(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.Stirling1Number((int)Math.round(n), (int)Math.round(k));
    }

    public static final double Stirling2Number(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (n == 0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (k == 0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)k * MathFunctions.Stirling2Number(n - 1, k) + MathFunctions.Stirling2Number(n - 1, k - 1);
    }

    public static final double Stirling2Number(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.Stirling2Number((int)Math.round(n), (int)Math.round(k));
    }

    public static final double worpitzkyNumber(int n, int k) {
        double result = Double.NaN;
        if (n >= 0 && k >= 0 && k <= n) {
            result = 0.0;
            for (int v = 0; v <= k; ++v) {
                result += Math.pow(-1.0, v + k) * Math.pow(v + 1, n) * MathFunctions.binomCoeff((double)k, v);
            }
        }
        return result;
    }

    public static final double worpitzkyNumber(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.worpitzkyNumber((int)Math.round(n), (int)Math.round(k));
    }

    public static final double harmonicNumber(int n) {
        if (n <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0;
        }
        double h = 1.0;
        for (double k = 2.0; k <= (double)n; k += 1.0) {
            h += 1.0 / k;
        }
        return h;
    }

    public static final double harmonicNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.harmonicNumber((int)Math.round(n));
    }

    public static final double harmonicNumber(double x, int n) {
        if (Double.isNaN(x) || x < 0.0) {
            return Double.NaN;
        }
        if (n <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return x;
        }
        double h = 1.0;
        for (double k = 2.0; k <= (double)n; k += 1.0) {
            h += 1.0 / MathFunctions.power(k, x);
        }
        return h;
    }

    public static final double harmonicNumber(double x, double n) {
        if (Double.isNaN(x) || Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.harmonicNumber(x, (int)Math.round(n));
    }

    public static final double catalanNumber(int n) {
        return MathFunctions.binomCoeff((double)(2 * n), n) * MathFunctions.div(1.0, n + 1);
    }

    public static final double catalanNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.catalanNumber((int)Math.round(n));
    }

    public static final double fibonacciNumber(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0;
        }
        return MathFunctions.fibonacciNumber(n - 1) + MathFunctions.fibonacciNumber(n - 2);
    }

    public static final double fibonacciNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.fibonacciNumber((int)Math.round(n));
    }

    public static final double lucasNumber(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 2.0;
        }
        if (n == 1) {
            return 1.0;
        }
        return MathFunctions.lucasNumber(n - 1) + MathFunctions.lucasNumber(n - 2);
    }

    public static final double lucasNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.lucasNumber((int)Math.round(n));
    }

    public static final double kroneckerDelta(double i, double j) {
        if (Double.isNaN(i) || Double.isNaN(j)) {
            return Double.NaN;
        }
        if (i == j) {
            return 1.0;
        }
        return 0.0;
    }

    public static final double kroneckerDelta(int i, int j) {
        if (i == j) {
            return 1.0;
        }
        return 0.0;
    }

    public static final double continuedFraction(double ... sequence) {
        int lastIndex;
        if (sequence == null) {
            return Double.NaN;
        }
        if (sequence.length == 0) {
            return Double.NaN;
        }
        double cf = 0.0;
        if (sequence.length == 1) {
            return sequence[0];
        }
        for (int i = lastIndex = sequence.length - 1; i >= 0; --i) {
            double a = sequence[i];
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (i == lastIndex) {
                cf = a;
                continue;
            }
            if (cf == 0.0) {
                return Double.NaN;
            }
            cf = a + 1.0 / cf;
        }
        return cf;
    }

    private static final double continuedPolynomial(int n, double[] x) {
        if (x == null) {
            return Double.NaN;
        }
        if (x.length == 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 1.0;
        }
        if (n == 1) {
            return x[0];
        }
        return x[n - 1] * MathFunctions.continuedPolynomial(n - 1, x) + MathFunctions.continuedPolynomial(n - 2, x);
    }

    public static final double continuedPolynomial(double ... x) {
        if (x == null) {
            return Double.NaN;
        }
        if (x.length == 0) {
            return Double.NaN;
        }
        for (double d : x) {
            if (!Double.isNaN(d)) continue;
            return Double.NaN;
        }
        return MathFunctions.continuedPolynomial(x.length, x);
    }

    public static final double eulerPolynomial(int m, double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (m >= 0) {
            result = 0.0;
            for (int n = 0; n <= m; ++n) {
                for (int k = 0; k <= n; ++k) {
                    result += Math.pow(-1.0, k) * MathFunctions.binomCoeff((double)n, k) * Math.pow(x + (double)k, m);
                }
                result /= Math.pow(2.0, n);
            }
        }
        return result;
    }

    public static final double eulerPolynomial(double m, double x) {
        if (Double.isNaN(m) || Double.isNaN(x)) {
            return Double.NaN;
        }
        return MathFunctions.eulerPolynomial((int)Math.round(m), (double)((int)Math.round(x)));
    }

    public static final double chi(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x > a && x < b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double chi_LR(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x >= a && x <= b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double chi_L(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x >= a && x < b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double chi_R(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x > a && x <= b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double power(double a, double b) {
        double nint;
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        if (a >= 0.0) {
            return Math.pow(a, b);
        }
        if (MathFunctions.abs(b) >= 1.0) {
            return Math.pow(a, b);
        }
        if (b == 0.0) {
            return Math.pow(a, b);
        }
        double ndob = 1.0 / MathFunctions.abs(b);
        if (MathFunctions.abs(ndob - (nint = (double)Math.round(ndob))) <= BinaryRelations.getEpsilon()) {
            long n = (long)nint;
            if (n % 2L == 1L) {
                if (b > 0.0) {
                    return -Math.pow(MathFunctions.abs(a), 1.0 / ndob);
                }
                return -Math.pow(MathFunctions.abs(a), -1.0 / ndob);
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public static final double root(double n, double x) {
        if (Double.isNaN(n) || Double.isNaN(n)) {
            return Double.NaN;
        }
        if (Double.isInfinite(n) || Double.isInfinite(n)) {
            return Double.NaN;
        }
        if (n < -1.0E-14) {
            return Double.NaN;
        }
        if (MathFunctions.abs(n) <= 1.0E-14) {
            if (MathFunctions.abs(x) <= 1.0E-14) {
                return 0.0;
            }
            if (MathFunctions.abs(x - 1.0) <= 1.0E-14) {
                return 1.0;
            }
            return Double.NaN;
        }
        long nint = (long)MathFunctions.floor(n);
        if (nint == 1L) {
            return x;
        }
        if (nint == 2L) {
            return MathFunctions.sqrt(x);
        }
        if (nint % 2L == 1L) {
            if (x >= 0.0) {
                return Math.pow(x, 1.0 / (double)nint);
            }
            return -Math.pow(MathFunctions.abs(x), 1.0 / (double)nint);
        }
        if (x >= 0.0) {
            return Math.pow(x, 1.0 / (double)nint);
        }
        return Double.NaN;
    }

    public static final double mod(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        return a % b;
    }

    public static final double div(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (b != 0.0) {
            result = a / b;
        }
        return result;
    }

    public static final double sin(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.sin(a);
    }

    public static final double cos(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.cos(a);
    }

    public static final double tan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.tan(a);
    }

    public static final double ctan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double tg = Math.tan(a);
        if (tg != 0.0) {
            result = 1.0 / tg;
        }
        return result;
    }

    public static final double sec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double cos = Math.cos(a);
        if (cos != 0.0) {
            result = 1.0 / cos;
        }
        return result;
    }

    public static final double cosec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double sin = Math.sin(a);
        if (sin != 0.0) {
            result = 1.0 / sin;
        }
        return result;
    }

    public static final double asin(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.asin(a);
    }

    public static final double acos(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.acos(a);
    }

    public static final double atan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.atan(a);
    }

    public static final double actan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.atan(1.0 / a);
    }

    public static final double asec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.acos(1.0 / a);
    }

    public static final double acosec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.asin(1.0 / a);
    }

    public static final double ln(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a);
    }

    public static final double log2(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a) / Math.log(2.0);
    }

    public static final double log10(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log10(a);
    }

    public static final double rad(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.toRadians(a);
    }

    public static final double exp(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.exp(a);
    }

    public static final double sqrt(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.sqrt(a);
    }

    public static final double sinh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.sinh(a);
    }

    public static final double cosh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.cosh(a);
    }

    public static final double tanh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.tanh(a);
    }

    public static final double coth(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double tanh = Math.tanh(a);
        if (tanh != 0.0) {
            result = 1.0 / tanh;
        }
        return result;
    }

    public static final double sech(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double cosh = Math.cosh(a);
        if (cosh != 0.0) {
            result = 1.0 / cosh;
        }
        return result;
    }

    public static final double csch(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double sinh = Math.sinh(a);
        if (sinh != 0.0) {
            result = 1.0 / sinh;
        }
        return result;
    }

    public static final double deg(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.toDegrees(a);
    }

    public static final double abs(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.abs(a);
    }

    public static final double sgn(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.signum(a);
    }

    public static final double floor(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.floor(a);
    }

    public static final double ceil(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.ceil(a);
    }

    public static final double arsinh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a + Math.sqrt(a * a + 1.0));
    }

    public static final double arcosh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static final double artanh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (1.0 - a != 0.0) {
            result = 0.5 * Math.log((1.0 + a) / (1.0 - a));
        }
        return result;
    }

    public static final double arcoth(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (a - 1.0 != 0.0) {
            result = 0.5 * Math.log((a + 1.0) / (a - 1.0));
        }
        return result;
    }

    public static final double arsech(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (a != 0.0) {
            result = Math.log((1.0 + Math.sqrt(1.0 - a * a)) / a);
        }
        return result;
    }

    public static final double arcsch(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (a != 0.0) {
            result = Math.log(1.0 / a + Math.sqrt(1.0 + a * a) / Math.abs(a));
        }
        return result;
    }

    public static final double sa(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double x = Math.PI * a;
        double result = Double.NaN;
        if (x != 0.0) {
            result = Math.sin(x) / x;
        }
        return result;
    }

    public static final double sinc(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (a != 0.0) {
            result = Math.sin(a) / a;
        }
        return result;
    }

    public static final double log(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double logb = Math.log(b);
        if (logb != 0.0) {
            result = Math.log(a) / logb;
        }
        return result;
    }

    public static final double round(double value, int places) {
        if (Double.isNaN(value)) {
            return Double.NaN;
        }
        if (places < 0) {
            return Double.NaN;
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static final int decimalDigitsBefore(double value) {
        if (value <= 1.0E-90) {
            if (value <= 1.0E-99) {
                return 99;
            }
            if (value <= 1.0E-98) {
                return 98;
            }
            if (value <= 1.0E-97) {
                return 97;
            }
            if (value <= 1.0E-96) {
                return 96;
            }
            if (value <= 1.0E-95) {
                return 95;
            }
            if (value <= 1.0E-94) {
                return 94;
            }
            if (value <= 1.0E-93) {
                return 93;
            }
            if (value <= 1.0E-92) {
                return 92;
            }
            if (value <= 1.0E-91) {
                return 91;
            }
            return 90;
        }
        if (value <= 1.0E-80) {
            if (value <= 1.0E-89) {
                return 89;
            }
            if (value <= 1.0E-88) {
                return 88;
            }
            if (value <= 1.0E-87) {
                return 87;
            }
            if (value <= 1.0E-86) {
                return 86;
            }
            if (value <= 1.0E-85) {
                return 85;
            }
            if (value <= 1.0E-84) {
                return 84;
            }
            if (value <= 1.0E-83) {
                return 83;
            }
            if (value <= 1.0E-82) {
                return 82;
            }
            if (value <= 1.0E-81) {
                return 81;
            }
            return 80;
        }
        if (value <= 1.0E-70) {
            if (value <= 1.0E-79) {
                return 79;
            }
            if (value <= 1.0E-78) {
                return 78;
            }
            if (value <= 1.0E-77) {
                return 77;
            }
            if (value <= 1.0E-76) {
                return 76;
            }
            if (value <= 1.0E-75) {
                return 75;
            }
            if (value <= 1.0E-74) {
                return 74;
            }
            if (value <= 1.0E-73) {
                return 73;
            }
            if (value <= 1.0E-72) {
                return 72;
            }
            if (value <= 1.0E-71) {
                return 71;
            }
            return 70;
        }
        if (value <= 1.0E-60) {
            if (value <= 1.0E-69) {
                return 69;
            }
            if (value <= 1.0E-68) {
                return 68;
            }
            if (value <= 1.0E-67) {
                return 67;
            }
            if (value <= 1.0E-66) {
                return 66;
            }
            if (value <= 1.0E-65) {
                return 65;
            }
            if (value <= 1.0E-64) {
                return 64;
            }
            if (value <= 1.0E-63) {
                return 63;
            }
            if (value <= 1.0E-62) {
                return 62;
            }
            if (value <= 1.0E-61) {
                return 61;
            }
            return 60;
        }
        if (value <= 1.0E-50) {
            if (value <= 1.0E-59) {
                return 59;
            }
            if (value <= 1.0E-58) {
                return 58;
            }
            if (value <= 1.0E-57) {
                return 57;
            }
            if (value <= 1.0E-56) {
                return 56;
            }
            if (value <= 1.0E-55) {
                return 55;
            }
            if (value <= 1.0E-54) {
                return 54;
            }
            if (value <= 1.0E-53) {
                return 53;
            }
            if (value <= 1.0E-52) {
                return 52;
            }
            if (value <= 1.0E-51) {
                return 51;
            }
            return 50;
        }
        if (value <= 1.0E-40) {
            if (value <= 1.0E-49) {
                return 49;
            }
            if (value <= 1.0E-48) {
                return 48;
            }
            if (value <= 1.0E-47) {
                return 47;
            }
            if (value <= 1.0E-46) {
                return 46;
            }
            if (value <= 1.0E-45) {
                return 45;
            }
            if (value <= 1.0E-44) {
                return 44;
            }
            if (value <= 1.0E-43) {
                return 43;
            }
            if (value <= 1.0E-42) {
                return 42;
            }
            if (value <= 1.0E-41) {
                return 41;
            }
            return 40;
        }
        if (value <= 1.0E-40) {
            if (value <= 1.0E-49) {
                return 49;
            }
            if (value <= 1.0E-48) {
                return 48;
            }
            if (value <= 1.0E-47) {
                return 47;
            }
            if (value <= 1.0E-46) {
                return 46;
            }
            if (value <= 1.0E-45) {
                return 45;
            }
            if (value <= 1.0E-44) {
                return 44;
            }
            if (value <= 1.0E-43) {
                return 43;
            }
            if (value <= 1.0E-42) {
                return 42;
            }
            if (value <= 1.0E-41) {
                return 41;
            }
            return 40;
        }
        if (value <= 1.0E-30) {
            if (value <= 1.0E-39) {
                return 39;
            }
            if (value <= 1.0E-38) {
                return 38;
            }
            if (value <= 1.0E-37) {
                return 37;
            }
            if (value <= 1.0E-36) {
                return 36;
            }
            if (value <= 1.0E-35) {
                return 35;
            }
            if (value <= 1.0E-34) {
                return 34;
            }
            if (value <= 1.0E-33) {
                return 33;
            }
            if (value <= 1.0E-32) {
                return 32;
            }
            if (value <= 1.0E-31) {
                return 31;
            }
            return 30;
        }
        if (value <= 1.0E-20) {
            if (value <= 1.0E-29) {
                return 29;
            }
            if (value <= 1.0E-28) {
                return 28;
            }
            if (value <= 1.0E-27) {
                return 27;
            }
            if (value <= 1.0E-26) {
                return 26;
            }
            if (value <= 1.0E-25) {
                return 25;
            }
            if (value <= 1.0E-24) {
                return 24;
            }
            if (value <= 1.0E-23) {
                return 23;
            }
            if (value <= 1.0E-22) {
                return 22;
            }
            if (value <= 1.0E-21) {
                return 21;
            }
            return 20;
        }
        if (value <= 1.0E-10) {
            if (value <= 1.0E-19) {
                return 19;
            }
            if (value <= 1.0E-18) {
                return 18;
            }
            if (value <= 1.0E-17) {
                return 17;
            }
            if (value <= 1.0E-16) {
                return 16;
            }
            if (value <= 1.0E-15) {
                return 15;
            }
            if (value <= 1.0E-14) {
                return 14;
            }
            if (value <= 1.0E-13) {
                return 13;
            }
            if (value <= 1.0E-12) {
                return 12;
            }
            if (value <= 1.0E-11) {
                return 11;
            }
            return 10;
        }
        if (value <= 1.0E-9) {
            return 9;
        }
        if (value <= 1.0E-8) {
            return 8;
        }
        if (value <= 1.0E-7) {
            return 7;
        }
        if (value <= 1.0E-6) {
            return 6;
        }
        if (value <= 1.0E-5) {
            return 5;
        }
        if (value <= 1.0E-4) {
            return 4;
        }
        if (value <= 0.001) {
            return 3;
        }
        if (value <= 0.01) {
            return 2;
        }
        if (value <= 0.1) {
            return 1;
        }
        if (value <= 1.0) {
            return 0;
        }
        return -1;
    }

    public static final double ulp(double value) {
        return Math.ulp(value);
    }

    public static final int ulpDecimalDigitsBefore(double value) {
        if (Double.isNaN(value)) {
            return -2;
        }
        double u = MathFunctions.ulp(value);
        return MathFunctions.decimalDigitsBefore(u);
    }

    public static final double coalesce(double[] values) {
        if (values == null) {
            return Double.NaN;
        }
        if (values.length == 0) {
            return Double.NaN;
        }
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            return v;
        }
        return Double.NaN;
    }
}

