/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.util.ArrayList;
import java.util.Arrays;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class NumberTheory {
    public static final double min(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        return Math.min(a, b);
    }

    public static final double min(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        double min = Double.POSITIVE_INFINITY;
        for (double number : numbers) {
            if (Double.isNaN(number)) {
                return Double.NaN;
            }
            if (!(number < min)) continue;
            min = number;
        }
        return min;
    }

    public static final double argmin(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        double min = Double.POSITIVE_INFINITY;
        double minIndex = -1.0;
        for (int i = 0; i < numbers.length; ++i) {
            double number = numbers[i];
            if (Double.isNaN(number)) {
                return Double.NaN;
            }
            if (BinaryRelations.lt(number, min) != 1.0) continue;
            min = number;
            minIndex = i;
        }
        return minIndex + 1.0;
    }

    public static final double max(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        return Math.max(a, b);
    }

    public static final double max(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (double number : numbers) {
            if (Double.isNaN(number)) {
                return Double.NaN;
            }
            if (!(number > max)) continue;
            max = number;
        }
        return max;
    }

    public static final double argmax(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        double max = Double.NEGATIVE_INFINITY;
        double maxIndex = -1.0;
        for (int i = 0; i < numbers.length; ++i) {
            double number = numbers[i];
            if (Double.isNaN(number)) {
                return Double.NaN;
            }
            if (BinaryRelations.gt(number, max) != 1.0) continue;
            max = number;
            maxIndex = i;
        }
        return maxIndex + 1.0;
    }

    private static final void sortAsc(double[] array, int[] initOrder, int leftIndex, int rightIndex) {
        int i = leftIndex;
        int j = rightIndex;
        double x = array[(leftIndex + rightIndex) / 2];
        while (true) {
            if (BinaryRelations.lt(array[i], x) == 1.0) {
                ++i;
                continue;
            }
            while (BinaryRelations.gt(array[j], x) == 1.0) {
                --j;
            }
            if (i <= j) {
                double w = array[i];
                array[i] = array[j];
                array[j] = w;
                int v = initOrder[i];
                initOrder[i] = initOrder[j];
                initOrder[j] = v;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (leftIndex < j) {
            NumberTheory.sortAsc(array, initOrder, leftIndex, j);
        }
        if (i < rightIndex) {
            NumberTheory.sortAsc(array, initOrder, i, rightIndex);
        }
    }

    public static final int[] sortAsc(double[] array) {
        if (array == null) {
            return null;
        }
        int[] initOrder = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            initOrder[i] = i;
        }
        if (array.length < 2) {
            return initOrder;
        }
        NumberTheory.sortAsc(array, initOrder, 0, array.length - 1);
        return initOrder;
    }

    public static final double[][] getDistValues(double[] array, boolean returnOrderByDescFreqAndAscOrigPos) {
        if (array == null) {
            return null;
        }
        boolean value = false;
        boolean count = true;
        int initPosFirst = 2;
        double[][] distVal = new double[array.length][3];
        if (array.length == 0) {
            return distVal;
        }
        if (array.length == 1) {
            distVal[0][0] = array[0];
            distVal[0][1] = 1.0;
            distVal[0][2] = 0.0;
            return distVal;
        }
        int[] initPos = NumberTheory.sortAsc(array);
        double unqValue = array[0];
        int unqValCnt = 1;
        int unqValMinPos = initPos[0];
        int unqCnt = 0;
        for (int i = 1; i < array.length; ++i) {
            if (BinaryRelations.eq(unqValue, array[i]) == 1.0) {
                ++unqValCnt;
                if (initPos[i] < unqValMinPos) {
                    unqValMinPos = initPos[i];
                }
            }
            if (BinaryRelations.eq(unqValue, array[i]) == 0.0 && i < array.length - 1) {
                distVal[unqCnt][0] = unqValue;
                distVal[unqCnt][1] = unqValCnt;
                distVal[unqCnt][2] = unqValMinPos;
                ++unqCnt;
                unqValue = array[i];
                unqValCnt = 1;
                unqValMinPos = initPos[i];
                continue;
            }
            if (BinaryRelations.eq(unqValue, array[i]) == 0.0 && i == array.length - 1) {
                distVal[unqCnt][0] = unqValue;
                distVal[unqCnt][1] = unqValCnt;
                distVal[unqCnt][2] = unqValMinPos;
                distVal[++unqCnt][0] = array[i];
                distVal[unqCnt][1] = 1.0;
                distVal[unqCnt][2] = initPos[i];
                ++unqCnt;
                continue;
            }
            if (i != array.length - 1) continue;
            distVal[unqCnt][0] = unqValue;
            distVal[unqCnt][1] = unqValCnt;
            distVal[unqCnt][2] = unqValMinPos;
            ++unqCnt;
        }
        double[][] distValFinal = new double[unqCnt][3];
        double maxBase = 0.0;
        for (int i = 0; i < unqCnt; ++i) {
            distValFinal[i][0] = distVal[i][0];
            distValFinal[i][1] = distVal[i][1];
            distValFinal[i][2] = distVal[i][2];
            if (distVal[i][1] > maxBase) {
                maxBase = distVal[i][1];
            }
            if (!(distVal[i][2] > maxBase)) continue;
            maxBase = distVal[i][2];
        }
        if (!returnOrderByDescFreqAndAscOrigPos) {
            return distValFinal;
        }
        maxBase += 1.0;
        double[] key = new double[unqCnt];
        for (int i = 0; i < unqCnt; ++i) {
            key[i] = (maxBase - distVal[i][1] - 1.0) * maxBase + distVal[i][2];
        }
        int[] keyInitOrder = NumberTheory.sortAsc(key);
        for (int i = 0; i < unqCnt; ++i) {
            distValFinal[i][0] = distVal[keyInitOrder[i]][0];
            distValFinal[i][1] = distVal[keyInitOrder[i]][1];
            distValFinal[i][2] = distVal[keyInitOrder[i]][2];
        }
        return distValFinal;
    }

    public static final double numberOfDistValues(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return 0.0;
        }
        for (double v : numbers) {
            if (!Double.isNaN(v)) continue;
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return 1.0;
        }
        return NumberTheory.getDistValues(numbers, false).length;
    }

    public static final long gcd(long a, long b) {
        a = Math.abs(a);
        b = Math.abs(b);
        if (a == 0L) {
            return b;
        }
        while (b != 0L) {
            if (a > b) {
                a -= b;
                continue;
            }
            b -= a;
        }
        return a;
    }

    public static final double gcd(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(a)) {
            return Double.NaN;
        }
        a = MathFunctions.floor(MathFunctions.abs(a));
        b = MathFunctions.floor(MathFunctions.abs(b));
        if (a == 0.0) {
            return b;
        }
        while (b != 0.0) {
            if (a > b) {
                a = MathFunctions.floor(a - b);
                continue;
            }
            b = MathFunctions.floor(b - a);
        }
        return a;
    }

    public static final long gcd(long ... numbers) {
        if (numbers == null) {
            return -1L;
        }
        if (numbers.length == 0) {
            return -1L;
        }
        if (numbers.length == 1) {
            if (numbers[0] >= 0L) {
                return numbers[0];
            }
            return -numbers[0];
        }
        if (numbers.length == 2) {
            return NumberTheory.gcd(numbers[0], numbers[1]);
        }
        for (int i = 1; i < numbers.length; ++i) {
            numbers[i] = NumberTheory.gcd(numbers[i - 1], numbers[i]);
        }
        return numbers[numbers.length - 1];
    }

    public static final double gcd(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return MathFunctions.floor(MathFunctions.abs(numbers[0]));
        }
        if (numbers.length == 2) {
            return NumberTheory.gcd(numbers[0], numbers[1]);
        }
        for (int i = 1; i < numbers.length; ++i) {
            numbers[i] = NumberTheory.gcd(numbers[i - 1], numbers[i]);
        }
        return numbers[numbers.length - 1];
    }

    public static final long lcm(long a, long b) {
        a = Math.abs(a);
        b = Math.abs(b);
        if (a == 0L || b == 0L) {
            return 0L;
        }
        return a * b / NumberTheory.gcd(a, b);
    }

    public static final double lcm(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(a)) {
            return Double.NaN;
        }
        a = MathFunctions.floor(MathFunctions.abs(a));
        b = MathFunctions.floor(MathFunctions.abs(b));
        return a * b / NumberTheory.gcd(a, b);
    }

    public static final long lcm(long ... numbers) {
        if (numbers == null) {
            return -1L;
        }
        if (numbers.length == 0) {
            return -1L;
        }
        if (numbers.length == 1) {
            if (numbers[0] >= 0L) {
                return numbers[0];
            }
            return -numbers[0];
        }
        if (numbers.length == 2) {
            return NumberTheory.lcm(numbers[0], numbers[1]);
        }
        for (int i = 1; i < numbers.length; ++i) {
            numbers[i] = NumberTheory.lcm(numbers[i - 1], numbers[i]);
        }
        return numbers[numbers.length - 1];
    }

    public static final double lcm(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            MathFunctions.floor(MathFunctions.abs(numbers[0]));
        }
        if (numbers.length == 2) {
            return NumberTheory.lcm(numbers[0], numbers[1]);
        }
        for (int i = 1; i < numbers.length; ++i) {
            numbers[i] = NumberTheory.lcm(numbers[i - 1], numbers[i]);
        }
        return numbers[numbers.length - 1];
    }

    public static final double sum(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        double sum = 0.0;
        for (double xi : numbers) {
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            sum += xi;
        }
        return sum;
    }

    public static final double prod(double ... numbers) {
        if (numbers == null) {
            return Double.NaN;
        }
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        double prod = 1.0;
        for (double xi : numbers) {
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            prod *= xi;
        }
        return prod;
    }

    public static final boolean primeTest(long n) {
        if (n == 2L) {
            return true;
        }
        if (n % 2L == 0L) {
            return false;
        }
        if (n <= 1L) {
            return false;
        }
        long top = (long)Math.sqrt(n);
        long primesCacheOddEnd = 3L;
        if (mXparser.primesCache != null && mXparser.primesCache.cacheStatus) {
            long i;
            if (n <= (long)mXparser.primesCache.maxNumInCache) {
                return mXparser.primesCache.isPrime[(int)n];
            }
            long topCache = Math.min(top, (long)mXparser.primesCache.maxNumInCache);
            for (i = 3L; i <= topCache; i += 2L) {
                if (!mXparser.primesCache.isPrime[(int)i] || n % i != 0L) continue;
                return false;
            }
            primesCacheOddEnd = i;
        }
        for (long i = primesCacheOddEnd; i <= top; i += 2L) {
            if (n % i != 0L) continue;
            return false;
        }
        return true;
    }

    public static final double primeTest(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        boolean isPrime = NumberTheory.primeTest((long)n);
        if (isPrime) {
            return 1.0;
        }
        return 0.0;
    }

    public static final long primeCount(long n) {
        if (n <= 1L) {
            return 0L;
        }
        if (n == 2L) {
            return 1L;
        }
        long numberOfPrimes = 1L;
        for (long i = 3L; i <= n; ++i) {
            if (!NumberTheory.primeTest(i)) continue;
            ++numberOfPrimes;
        }
        return numberOfPrimes;
    }

    public static final double primeCount(double n) {
        return NumberTheory.primeCount((long)n);
    }

    public static final double sigmaSummation(Expression f, Argument index, double from, double to, double delta) {
        double result = 0.0;
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        if (to >= from && delta > 0.0) {
            double i;
            for (i = from; i < to; i += delta) {
                result += mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (i - to) > 0.5 * delta) {
                result += mXparser.getFunctionValue(f, index, to);
            }
        } else if (to <= from && delta < 0.0) {
            double i;
            for (i = from; i > to; i += delta) {
                result += mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (to - i) > 0.5 * delta) {
                result += mXparser.getFunctionValue(f, index, to);
            }
        } else if (from == to) {
            result += mXparser.getFunctionValue(f, index, from);
        }
        return result;
    }

    public static final double piProduct(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double result = 1.0;
        if (to >= from && delta > 0.0) {
            double i;
            for (i = from; i < to; i += delta) {
                result *= mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (i - to) > 0.5 * delta) {
                result *= mXparser.getFunctionValue(f, index, to);
            }
        } else if (to <= from && delta < 0.0) {
            double i;
            for (i = from; i > to; i += delta) {
                result *= mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (to - i) > 0.5 * delta) {
                result *= mXparser.getFunctionValue(f, index, to);
            }
        } else if (from == to) {
            result *= mXparser.getFunctionValue(f, index, from);
        }
        return result;
    }

    public static final double min(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double min = Double.POSITIVE_INFINITY;
        if (to >= from && delta > 0.0) {
            double v;
            for (double i = from; i < to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v < min)) continue;
                min = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v < min) {
                min = v;
            }
        } else if (to <= from && delta < 0.0) {
            double v;
            for (double i = from; i > to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v < min)) continue;
                min = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v < min) {
                min = v;
            }
        } else if (from == to) {
            min = mXparser.getFunctionValue(f, index, from);
        }
        return min;
    }

    public static final double max(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double max = Double.NEGATIVE_INFINITY;
        if (to >= from && delta > 0.0) {
            double v;
            for (double i = from; i < to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v > max)) continue;
                max = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v > max) {
                max = v;
            }
        } else if (to <= from && delta < 0.0) {
            double v;
            for (double i = from; i > to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v > max)) continue;
                max = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v > max) {
                max = v;
            }
        } else if (from == to) {
            max = mXparser.getFunctionValue(f, index, from);
        }
        return max;
    }

    private static final String getRegExpForNumeralSystem(int numeralSystemBase) {
        switch (numeralSystemBase) {
            case 1: {
                return "[+-]?[bB]1\\.(1)*";
            }
            case 2: {
                return "[+-]?[bB][2]?\\.[01]([01])*";
            }
            case 3: {
                return "[+-]?[bB]3\\.[0-2]([0-2])*";
            }
            case 4: {
                return "[+-]?[bB]4\\.[0-3]([0-3])*";
            }
            case 5: {
                return "[+-]?[bB]5\\.[0-4]([0-4])*";
            }
            case 6: {
                return "[+-]?[bB]6\\.[0-5]([0-5])*";
            }
            case 7: {
                return "[+-]?[bB]7\\.[0-6]([0-6])*";
            }
            case 8: {
                return "[+-]?([bB]8|[oO])\\.[0-7]([0-7])*";
            }
            case 9: {
                return "[+-]?[bB]9\\.[0-8]([0-8])*";
            }
            case 10: {
                return "[+-]?[bB]10\\.[0-9]([0-9])*";
            }
            case 11: {
                return "[+-]?[bB]11\\.[0-9aA]([0-9aA])*";
            }
            case 12: {
                return "[+-]?[bB]12\\.[0-9a-bA-B]([0-9a-bA-B])*";
            }
            case 13: {
                return "[+-]?[bB]13\\.[0-9a-cA-C]([0-9a-cA-C])*";
            }
            case 14: {
                return "[+-]?[bB]14\\.[0-9a-dA-D]([0-9a-dA-D])*";
            }
            case 15: {
                return "[+-]?[bB]15\\.[0-9a-eA-E]([0-9a-eA-E])*";
            }
            case 16: {
                return "[+-]?([bB]16|[hH])\\.[0-9a-fA-F]([0-9a-fA-F])*";
            }
            case 17: {
                return "[+-]?[bB]17\\.[0-9a-gA-G]([0-9a-gA-G])*";
            }
            case 18: {
                return "[+-]?[bB]18\\.[0-9a-hA-H]([0-9a-hA-H])*";
            }
            case 19: {
                return "[+-]?[bB]19\\.[0-9a-iA-I]([0-9a-iA-I])*";
            }
            case 20: {
                return "[+-]?[bB]20\\.[0-9a-jA-J]([0-9a-jA-J])*";
            }
            case 21: {
                return "[+-]?[bB]21\\.[0-9a-kA-K]([0-9a-kA-K])*";
            }
            case 22: {
                return "[+-]?[bB]22\\.[0-9a-lA-L]([0-9a-lA-L])*";
            }
            case 23: {
                return "[+-]?[bB]23\\.[0-9a-mA-M]([0-9a-mA-M])*";
            }
            case 24: {
                return "[+-]?[bB]24\\.[0-9a-nA-N]([0-9a-nA-N])*";
            }
            case 25: {
                return "[+-]?[bB]25\\.[0-9a-oA-O]([0-9a-oA-O])*";
            }
            case 26: {
                return "[+-]?[bB]26\\.[0-9a-pA-P]([0-9a-pA-P])*";
            }
            case 27: {
                return "[+-]?[bB]27\\.[0-9a-qA-Q]([0-9a-qA-Q])*";
            }
            case 28: {
                return "[+-]?[bB]28\\.[0-9a-rA-R]([0-9a-rA-R])*";
            }
            case 29: {
                return "[+-]?[bB]29\\.[0-9a-sA-S]([0-9a-sA-S])*";
            }
            case 30: {
                return "[+-]?[bB]30\\.[0-9a-tA-T]([0-9a-tA-T])*";
            }
            case 31: {
                return "[+-]?[bB]31\\.[0-9a-uA-U]([0-9a-uA-U])*";
            }
            case 32: {
                return "[+-]?[bB]32\\.[0-9a-vA-V]([0-9a-vA-V])*";
            }
            case 33: {
                return "[+-]?[bB]33\\.[0-9a-wA-W]([0-9a-wA-W])*";
            }
            case 34: {
                return "[+-]?[bB]34\\.[0-9a-xA-X]([0-9a-xA-X])*";
            }
            case 35: {
                return "[+-]?[bB]35\\.[0-9a-yA-Y]([0-9a-yA-Y])*";
            }
            case 36: {
                return "[+-]?[bB]36\\.[0-9a-zA-Z]([0-9a-zA-Z])*";
            }
        }
        return "\\b\\B";
    }

    public static final int digitIndex(char digitChar) {
        switch (digitChar) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
            case 'G': {
                return 16;
            }
            case 'H': {
                return 17;
            }
            case 'I': {
                return 18;
            }
            case 'J': {
                return 19;
            }
            case 'K': {
                return 20;
            }
            case 'L': {
                return 21;
            }
            case 'M': {
                return 22;
            }
            case 'N': {
                return 23;
            }
            case 'O': {
                return 24;
            }
            case 'P': {
                return 25;
            }
            case 'Q': {
                return 26;
            }
            case 'R': {
                return 27;
            }
            case 'S': {
                return 28;
            }
            case 'T': {
                return 29;
            }
            case 'U': {
                return 30;
            }
            case 'V': {
                return 31;
            }
            case 'W': {
                return 32;
            }
            case 'X': {
                return 33;
            }
            case 'Y': {
                return 34;
            }
            case 'Z': {
                return 35;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
            case 'g': {
                return 16;
            }
            case 'h': {
                return 17;
            }
            case 'i': {
                return 18;
            }
            case 'j': {
                return 19;
            }
            case 'k': {
                return 20;
            }
            case 'l': {
                return 21;
            }
            case 'm': {
                return 22;
            }
            case 'n': {
                return 23;
            }
            case 'o': {
                return 24;
            }
            case 'p': {
                return 25;
            }
            case 'q': {
                return 26;
            }
            case 'r': {
                return 27;
            }
            case 's': {
                return 28;
            }
            case 't': {
                return 29;
            }
            case 'u': {
                return 30;
            }
            case 'v': {
                return 31;
            }
            case 'w': {
                return 32;
            }
            case 'x': {
                return 33;
            }
            case 'y': {
                return 34;
            }
            case 'z': {
                return 35;
            }
        }
        return -1;
    }

    public static final char digitChar(int digitIndex) {
        switch (digitIndex) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
            case 16: {
                return 'G';
            }
            case 17: {
                return 'H';
            }
            case 18: {
                return 'I';
            }
            case 19: {
                return 'J';
            }
            case 20: {
                return 'K';
            }
            case 21: {
                return 'L';
            }
            case 22: {
                return 'M';
            }
            case 23: {
                return 'N';
            }
            case 24: {
                return 'O';
            }
            case 25: {
                return 'P';
            }
            case 26: {
                return 'Q';
            }
            case 27: {
                return 'R';
            }
            case 28: {
                return 'S';
            }
            case 29: {
                return 'T';
            }
            case 30: {
                return 'U';
            }
            case 31: {
                return 'V';
            }
            case 32: {
                return 'W';
            }
            case 33: {
                return 'X';
            }
            case 34: {
                return 'Y';
            }
            case 35: {
                return 'Z';
            }
        }
        return '?';
    }

    public static final int getNumeralSystemBase(String numberLiteral) {
        for (int b = 0; b <= 36; ++b) {
            if (!mXparser.regexMatch(numberLiteral, NumberTheory.getRegExpForNumeralSystem(b))) continue;
            return b;
        }
        return -1;
    }

    public static final double convOthBase2Decimal(String numberLiteral, int numeralSystemBase) {
        if (numberLiteral == null) {
            return Double.NaN;
        }
        if ((numberLiteral = numberLiteral.trim()).length() == 0) {
            if (numeralSystemBase == 1) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (numeralSystemBase < 1) {
            return Double.NaN;
        }
        if (numeralSystemBase > 36) {
            return Double.NaN;
        }
        char signChar = numberLiteral.charAt(0);
        double sign = 1.0;
        if (signChar == '-') {
            sign = -1.0;
            numberLiteral = numberLiteral.substring(1);
        } else if (signChar == '+') {
            sign = 1.0;
            numberLiteral = numberLiteral.substring(1);
        }
        int length = numberLiteral.length();
        double decValue = 0.0;
        for (int i = 0; i < length; ++i) {
            int digit = NumberTheory.digitIndex(numberLiteral.charAt(i));
            if (numeralSystemBase > 1) {
                if (digit >= 0 && digit < numeralSystemBase) {
                    decValue = (double)numeralSystemBase * decValue + (double)digit;
                    continue;
                }
                return Double.NaN;
            }
            if (digit == 1) {
                decValue = (double)numeralSystemBase * decValue + (double)digit;
                continue;
            }
            return Double.NaN;
        }
        return sign * decValue;
    }

    public static final double convOthBase2Decimal(String numberLiteral) {
        if (numberLiteral == null) {
            return Double.NaN;
        }
        int numberLiteralStrLenght = (numberLiteral = numberLiteral.trim()).length();
        if (numberLiteralStrLenght < 2) {
            return Double.NaN;
        }
        int numeralSystemBase = NumberTheory.getNumeralSystemBase(numberLiteral);
        if (numeralSystemBase == -1) {
            return Double.NaN;
        }
        int dotPos = numberLiteral.indexOf(46);
        if (dotPos == 0) {
            return Double.NaN;
        }
        char signChar = numberLiteral.charAt(0);
        double sign = 1.0;
        if (signChar == '-') {
            sign = -1.0;
        }
        String finalLiteral = "";
        if (numberLiteralStrLenght > dotPos + 1) {
            finalLiteral = numberLiteral.substring(dotPos + 1);
        }
        return sign * NumberTheory.convOthBase2Decimal(finalLiteral, numeralSystemBase);
    }

    public static final double convOthBase2Decimal(int numeralSystemBase, int ... digits) {
        if (numeralSystemBase < 1) {
            return Double.NaN;
        }
        if (digits == null) {
            return Double.NaN;
        }
        int length = digits.length;
        if (length == 0) {
            if (numeralSystemBase == 1) {
                return 0.0;
            }
            return Double.NaN;
        }
        double decValue = 0.0;
        for (int i = 0; i < length; ++i) {
            int digit = digits[i];
            if (numeralSystemBase > 1) {
                if (digit >= 0 && digit < numeralSystemBase) {
                    decValue = (double)numeralSystemBase * decValue + (double)digit;
                    continue;
                }
                return Double.NaN;
            }
            if (digit == 1) {
                decValue = (double)numeralSystemBase * decValue + (double)digit;
                continue;
            }
            return Double.NaN;
        }
        return decValue;
    }

    public static final double convOthBase2Decimal(double numeralSystemBase, double ... digits) {
        if (numeralSystemBase < 0.0) {
            return Double.NaN;
        }
        if (Double.isNaN(numeralSystemBase)) {
            return Double.NaN;
        }
        int numeralSystemBaseInt = (int)MathFunctions.floor(numeralSystemBase);
        if (digits == null) {
            return Double.NaN;
        }
        int length = digits.length;
        if (length == 0) {
            if (numeralSystemBaseInt == 1) {
                return 0.0;
            }
            return Double.NaN;
        }
        int[] digitsInt = new int[length];
        for (int i = 0; i < length; ++i) {
            double digit = digits[i];
            if (Double.isNaN(digit)) {
                return Double.NaN;
            }
            digitsInt[i] = (int)digit;
        }
        return NumberTheory.convOthBase2Decimal(numeralSystemBaseInt, digitsInt);
    }

    public static final double convOthBase2Decimal(int[] baseAndDigits) {
        if (baseAndDigits == null) {
            return Double.NaN;
        }
        if (baseAndDigits.length == 0) {
            return Double.NaN;
        }
        int numeralSystemBase = baseAndDigits[0];
        int[] digits = new int[baseAndDigits.length - 1];
        for (int i = 1; i < baseAndDigits.length; ++i) {
            digits[i - 1] = baseAndDigits[i];
        }
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static final double convOthBase2Decimal(double[] baseAndDigits) {
        if (baseAndDigits == null) {
            return Double.NaN;
        }
        if (baseAndDigits.length == 0) {
            return Double.NaN;
        }
        double numeralSystemBase = baseAndDigits[0];
        double[] digits = new double[baseAndDigits.length - 1];
        for (int i = 1; i < baseAndDigits.length; ++i) {
            digits[i - 1] = baseAndDigits[i];
        }
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static final String convDecimal2OthBase(double decimalNumber, int numeralSystemBase) {
        if (Double.isNaN(decimalNumber)) {
            return "NaN";
        }
        if (numeralSystemBase < 1) {
            return "NaN";
        }
        if (numeralSystemBase > 36) {
            return "NaN";
        }
        if (decimalNumber == 0.0) {
            if (numeralSystemBase > 1) {
                return "0";
            }
            return "";
        }
        double intPart = MathFunctions.floor(MathFunctions.abs(decimalNumber));
        double sign = MathFunctions.sgn(decimalNumber);
        String signChar = "";
        if (sign < 0.0) {
            signChar = "-";
        }
        if (intPart < (double)numeralSystemBase) {
            return signChar + NumberTheory.digitChar((int)intPart);
        }
        String numberLiteral = "";
        double quotient = intPart;
        if (numeralSystemBase > 1) {
            while (quotient >= 1.0) {
                int reminder = (int)(quotient % (double)numeralSystemBase);
                quotient = MathFunctions.floor(quotient / (double)numeralSystemBase);
                numberLiteral = NumberTheory.digitChar(reminder) + numberLiteral;
            }
        } else {
            char[] repeat = new char[(int)intPart];
            Arrays.fill(repeat, '1');
            numberLiteral = new String(repeat);
        }
        return signChar + numberLiteral;
    }

    public static final String convDecimal2OthBase(double decimalNumber, int numeralSystemBase, int format) {
        if (Double.isNaN(decimalNumber)) {
            return "NaN";
        }
        if (numeralSystemBase < 1) {
            return "NaN";
        }
        if (numeralSystemBase > 36) {
            return "NaN";
        }
        String prefix = "";
        if (format == 1 || format == 2) {
            prefix = "b" + numeralSystemBase + ".";
        }
        if (format == 2) {
            if (numeralSystemBase == 2) {
                prefix = "b.";
            }
            if (numeralSystemBase == 8) {
                prefix = "o.";
            }
            if (numeralSystemBase == 16) {
                prefix = "h.";
            }
        }
        String sign = "";
        if (decimalNumber < 0.0) {
            sign = "-";
        }
        return sign + prefix + NumberTheory.convDecimal2OthBase(MathFunctions.abs(decimalNumber), numeralSystemBase);
    }

    public static final int numberOfDigits(long number) {
        if (number < 0L) {
            number = -number;
        }
        if (number < 10L) {
            return 1;
        }
        if (number < 100L) {
            return 2;
        }
        if (number < 1000L) {
            return 3;
        }
        if (number < 10000L) {
            return 4;
        }
        if (number < 100000L) {
            return 5;
        }
        if (number < 1000000L) {
            return 6;
        }
        if (number < 10000000L) {
            return 7;
        }
        if (number < 100000000L) {
            return 8;
        }
        if (number < 1000000000L) {
            return 9;
        }
        return 10;
    }

    public static final double numberOfDigits(double number) {
        if (Double.isNaN(number)) {
            return Double.NaN;
        }
        if (Double.isInfinite(number)) {
            return Double.POSITIVE_INFINITY;
        }
        if (number < 0.0) {
            number = -number;
        }
        if ((number = MathFunctions.floor(number)) < 10.0) {
            return 1.0;
        }
        if (number < 100.0) {
            return 2.0;
        }
        if (number < 1000.0) {
            return 3.0;
        }
        if (number < 10000.0) {
            return 4.0;
        }
        if (number < 100000.0) {
            return 5.0;
        }
        if (number < 1000000.0) {
            return 6.0;
        }
        if (number < 1.0E7) {
            return 7.0;
        }
        if (number < 1.0E8) {
            return 8.0;
        }
        if (number < 1.0E9) {
            return 9.0;
        }
        if (number < 1.0E10) {
            return 10.0;
        }
        if (number < 1.0E11) {
            return 11.0;
        }
        if (number < 1.0E12) {
            return 12.0;
        }
        if (number < 1.0E13) {
            return 13.0;
        }
        if (number < 1.0E14) {
            return 14.0;
        }
        if (number < 1.0E15) {
            return 15.0;
        }
        if (number < 1.0E16) {
            return 16.0;
        }
        if (number < 1.0E17) {
            return 17.0;
        }
        if (number < 1.0E18) {
            return 18.0;
        }
        if (number < 1.0E19) {
            return 19.0;
        }
        if (number < 1.0E20) {
            return 20.0;
        }
        if (number < 1.0E21) {
            return 21.0;
        }
        if (number < 1.0E22) {
            return 22.0;
        }
        if (number < 1.0E23) {
            return 23.0;
        }
        if (number < 1.0E24) {
            return 24.0;
        }
        if (number < 1.0E25) {
            return 25.0;
        }
        if (number < 1.0E26) {
            return 26.0;
        }
        if (number < 1.0E27) {
            return 27.0;
        }
        if (number < 1.0E28) {
            return 28.0;
        }
        if (number < 1.0E29) {
            return 29.0;
        }
        if (number < 1.0E30) {
            return 30.0;
        }
        if (number < 1.0E31) {
            return 31.0;
        }
        if (number < 1.0E32) {
            return 32.0;
        }
        if (number < 1.0E33) {
            return 33.0;
        }
        if (number < 1.0E34) {
            return 34.0;
        }
        if (number < 1.0E35) {
            return 35.0;
        }
        if (number < 1.0E36) {
            return 36.0;
        }
        if (number < 1.0E37) {
            return 37.0;
        }
        if (number < 1.0E38) {
            return 38.0;
        }
        if (number < 1.0E39) {
            return 39.0;
        }
        if (number < 1.0E40) {
            return 40.0;
        }
        if (number < 1.0E41) {
            return 41.0;
        }
        if (number < 1.0E42) {
            return 42.0;
        }
        if (number < 1.0E43) {
            return 43.0;
        }
        if (number < 1.0E44) {
            return 44.0;
        }
        if (number < 1.0E45) {
            return 45.0;
        }
        if (number < 1.0E46) {
            return 46.0;
        }
        if (number < 1.0E47) {
            return 47.0;
        }
        if (number < 1.0E48) {
            return 48.0;
        }
        if (number < 1.0E49) {
            return 49.0;
        }
        if (number < 1.0E50) {
            return 50.0;
        }
        if (number < 1.0E51) {
            return 51.0;
        }
        if (number < 1.0E52) {
            return 52.0;
        }
        if (number < 1.0E53) {
            return 53.0;
        }
        if (number < 1.0E54) {
            return 54.0;
        }
        if (number < 1.0E55) {
            return 55.0;
        }
        if (number < 1.0E56) {
            return 56.0;
        }
        if (number < 1.0E57) {
            return 57.0;
        }
        if (number < 1.0E58) {
            return 58.0;
        }
        if (number < 1.0E59) {
            return 59.0;
        }
        if (number < 1.0E60) {
            return 60.0;
        }
        if (number < 1.0E61) {
            return 61.0;
        }
        if (number < 1.0E62) {
            return 62.0;
        }
        if (number < 1.0E63) {
            return 63.0;
        }
        if (number < 1.0E64) {
            return 64.0;
        }
        if (number < 1.0E65) {
            return 65.0;
        }
        if (number < 1.0E66) {
            return 66.0;
        }
        if (number < 1.0E67) {
            return 67.0;
        }
        if (number < 1.0E68) {
            return 68.0;
        }
        if (number < 1.0E69) {
            return 69.0;
        }
        if (number < 1.0E70) {
            return 70.0;
        }
        if (number < 1.0E71) {
            return 71.0;
        }
        if (number < 1.0E72) {
            return 72.0;
        }
        if (number < 1.0E73) {
            return 73.0;
        }
        if (number < 1.0E74) {
            return 74.0;
        }
        if (number < 1.0E75) {
            return 75.0;
        }
        if (number < 1.0E76) {
            return 76.0;
        }
        if (number < 1.0E77) {
            return 77.0;
        }
        if (number < 1.0E78) {
            return 78.0;
        }
        if (number < 1.0E79) {
            return 79.0;
        }
        if (number < 1.0E80) {
            return 80.0;
        }
        if (number < 1.0E81) {
            return 81.0;
        }
        if (number < 1.0E82) {
            return 82.0;
        }
        if (number < 1.0E83) {
            return 83.0;
        }
        if (number < 1.0E84) {
            return 84.0;
        }
        if (number < 1.0E85) {
            return 85.0;
        }
        if (number < 1.0E86) {
            return 86.0;
        }
        if (number < 1.0E87) {
            return 87.0;
        }
        if (number < 1.0E88) {
            return 88.0;
        }
        if (number < 1.0E89) {
            return 89.0;
        }
        if (number < 1.0E90) {
            return 90.0;
        }
        if (number < 1.0E91) {
            return 91.0;
        }
        if (number < 1.0E92) {
            return 92.0;
        }
        if (number < 1.0E93) {
            return 93.0;
        }
        if (number < 1.0E94) {
            return 94.0;
        }
        if (number < 1.0E95) {
            return 95.0;
        }
        if (number < 1.0E96) {
            return 96.0;
        }
        if (number < 1.0E97) {
            return 97.0;
        }
        if (number < 1.0E98) {
            return 98.0;
        }
        if (number < 1.0E99) {
            return 99.0;
        }
        if (number < 1.0E100) {
            return 100.0;
        }
        if (number < 1.0E101) {
            return 101.0;
        }
        if (number < 1.0E102) {
            return 102.0;
        }
        if (number < 1.0E103) {
            return 103.0;
        }
        if (number < 1.0E104) {
            return 104.0;
        }
        if (number < 1.0E105) {
            return 105.0;
        }
        if (number < 1.0E106) {
            return 106.0;
        }
        if (number < 1.0E107) {
            return 107.0;
        }
        if (number < 1.0E108) {
            return 108.0;
        }
        if (number < 1.0E109) {
            return 109.0;
        }
        if (number < 1.0E110) {
            return 110.0;
        }
        if (number < 1.0E111) {
            return 111.0;
        }
        if (number < 1.0E112) {
            return 112.0;
        }
        if (number < 1.0E113) {
            return 113.0;
        }
        if (number < 1.0E114) {
            return 114.0;
        }
        if (number < 1.0E115) {
            return 115.0;
        }
        if (number < 1.0E116) {
            return 116.0;
        }
        if (number < 1.0E117) {
            return 117.0;
        }
        if (number < 1.0E118) {
            return 118.0;
        }
        if (number < 1.0E119) {
            return 119.0;
        }
        if (number < 1.0E120) {
            return 120.0;
        }
        if (number < 1.0E121) {
            return 121.0;
        }
        if (number < 1.0E122) {
            return 122.0;
        }
        if (number < 1.0E123) {
            return 123.0;
        }
        if (number < 1.0E124) {
            return 124.0;
        }
        if (number < 1.0E125) {
            return 125.0;
        }
        if (number < 1.0E126) {
            return 126.0;
        }
        if (number < 1.0E127) {
            return 127.0;
        }
        if (number < 1.0E128) {
            return 128.0;
        }
        if (number < 1.0E129) {
            return 129.0;
        }
        if (number < 1.0E130) {
            return 130.0;
        }
        if (number < 1.0E131) {
            return 131.0;
        }
        if (number < 1.0E132) {
            return 132.0;
        }
        if (number < 1.0E133) {
            return 133.0;
        }
        if (number < 1.0E134) {
            return 134.0;
        }
        if (number < 1.0E135) {
            return 135.0;
        }
        if (number < 1.0E136) {
            return 136.0;
        }
        if (number < 1.0E137) {
            return 137.0;
        }
        if (number < 1.0E138) {
            return 138.0;
        }
        if (number < 1.0E139) {
            return 139.0;
        }
        if (number < 1.0E140) {
            return 140.0;
        }
        if (number < 1.0E141) {
            return 141.0;
        }
        if (number < 1.0E142) {
            return 142.0;
        }
        if (number < 1.0E143) {
            return 143.0;
        }
        if (number < 1.0E144) {
            return 144.0;
        }
        if (number < 1.0E145) {
            return 145.0;
        }
        if (number < 1.0E146) {
            return 146.0;
        }
        if (number < 1.0E147) {
            return 147.0;
        }
        if (number < 1.0E148) {
            return 148.0;
        }
        if (number < 1.0E149) {
            return 149.0;
        }
        if (number < 1.0E150) {
            return 150.0;
        }
        if (number < 1.0E151) {
            return 151.0;
        }
        if (number < 1.0E152) {
            return 152.0;
        }
        if (number < 1.0E153) {
            return 153.0;
        }
        if (number < 1.0E154) {
            return 154.0;
        }
        if (number < 1.0E155) {
            return 155.0;
        }
        if (number < 1.0E156) {
            return 156.0;
        }
        if (number < 1.0E157) {
            return 157.0;
        }
        if (number < 1.0E158) {
            return 158.0;
        }
        if (number < 1.0E159) {
            return 159.0;
        }
        if (number < 1.0E160) {
            return 160.0;
        }
        if (number < 1.0E161) {
            return 161.0;
        }
        if (number < 1.0E162) {
            return 162.0;
        }
        if (number < 1.0E163) {
            return 163.0;
        }
        if (number < 1.0E164) {
            return 164.0;
        }
        if (number < 1.0E165) {
            return 165.0;
        }
        if (number < 1.0E166) {
            return 166.0;
        }
        if (number < 1.0E167) {
            return 167.0;
        }
        if (number < 1.0E168) {
            return 168.0;
        }
        if (number < 1.0E169) {
            return 169.0;
        }
        if (number < 1.0E170) {
            return 170.0;
        }
        if (number < 1.0E171) {
            return 171.0;
        }
        if (number < 1.0E172) {
            return 172.0;
        }
        if (number < 1.0E173) {
            return 173.0;
        }
        if (number < 1.0E174) {
            return 174.0;
        }
        if (number < 1.0E175) {
            return 175.0;
        }
        if (number < 1.0E176) {
            return 176.0;
        }
        if (number < 1.0E177) {
            return 177.0;
        }
        if (number < 1.0E178) {
            return 178.0;
        }
        if (number < 1.0E179) {
            return 179.0;
        }
        if (number < 1.0E180) {
            return 180.0;
        }
        if (number < 1.0E181) {
            return 181.0;
        }
        if (number < 1.0E182) {
            return 182.0;
        }
        if (number < 1.0E183) {
            return 183.0;
        }
        if (number < 1.0E184) {
            return 184.0;
        }
        if (number < 1.0E185) {
            return 185.0;
        }
        if (number < 1.0E186) {
            return 186.0;
        }
        if (number < 1.0E187) {
            return 187.0;
        }
        if (number < 1.0E188) {
            return 188.0;
        }
        if (number < 1.0E189) {
            return 189.0;
        }
        if (number < 1.0E190) {
            return 190.0;
        }
        if (number < 1.0E191) {
            return 191.0;
        }
        if (number < 1.0E192) {
            return 192.0;
        }
        if (number < 1.0E193) {
            return 193.0;
        }
        if (number < 1.0E194) {
            return 194.0;
        }
        if (number < 1.0E195) {
            return 195.0;
        }
        if (number < 1.0E196) {
            return 196.0;
        }
        if (number < 1.0E197) {
            return 197.0;
        }
        if (number < 1.0E198) {
            return 198.0;
        }
        if (number < 1.0E199) {
            return 199.0;
        }
        if (number < 1.0E200) {
            return 200.0;
        }
        if (number < 1.0E201) {
            return 201.0;
        }
        if (number < 1.0E202) {
            return 202.0;
        }
        if (number < 1.0E203) {
            return 203.0;
        }
        if (number < 1.0E204) {
            return 204.0;
        }
        if (number < 1.0E205) {
            return 205.0;
        }
        if (number < 1.0E206) {
            return 206.0;
        }
        if (number < 1.0E207) {
            return 207.0;
        }
        if (number < 1.0E208) {
            return 208.0;
        }
        if (number < 1.0E209) {
            return 209.0;
        }
        if (number < 1.0E210) {
            return 210.0;
        }
        if (number < 1.0E211) {
            return 211.0;
        }
        if (number < 1.0E212) {
            return 212.0;
        }
        if (number < 1.0E213) {
            return 213.0;
        }
        if (number < 1.0E214) {
            return 214.0;
        }
        if (number < 1.0E215) {
            return 215.0;
        }
        if (number < 1.0E216) {
            return 216.0;
        }
        if (number < 1.0E217) {
            return 217.0;
        }
        if (number < 1.0E218) {
            return 218.0;
        }
        if (number < 1.0E219) {
            return 219.0;
        }
        if (number < 1.0E220) {
            return 220.0;
        }
        if (number < 1.0E221) {
            return 221.0;
        }
        if (number < 1.0E222) {
            return 222.0;
        }
        if (number < 1.0E223) {
            return 223.0;
        }
        if (number < 1.0E224) {
            return 224.0;
        }
        if (number < 1.0E225) {
            return 225.0;
        }
        if (number < 1.0E226) {
            return 226.0;
        }
        if (number < 1.0E227) {
            return 227.0;
        }
        if (number < 1.0E228) {
            return 228.0;
        }
        if (number < 1.0E229) {
            return 229.0;
        }
        if (number < 1.0E230) {
            return 230.0;
        }
        if (number < 1.0E231) {
            return 231.0;
        }
        if (number < 1.0E232) {
            return 232.0;
        }
        if (number < 1.0E233) {
            return 233.0;
        }
        if (number < 1.0E234) {
            return 234.0;
        }
        if (number < 1.0E235) {
            return 235.0;
        }
        if (number < 1.0E236) {
            return 236.0;
        }
        if (number < 1.0E237) {
            return 237.0;
        }
        if (number < 1.0E238) {
            return 238.0;
        }
        if (number < 1.0E239) {
            return 239.0;
        }
        if (number < 1.0E240) {
            return 240.0;
        }
        if (number < 1.0E241) {
            return 241.0;
        }
        if (number < 1.0E242) {
            return 242.0;
        }
        if (number < 1.0E243) {
            return 243.0;
        }
        if (number < 1.0E244) {
            return 244.0;
        }
        if (number < 1.0E245) {
            return 245.0;
        }
        if (number < 1.0E246) {
            return 246.0;
        }
        if (number < 1.0E247) {
            return 247.0;
        }
        if (number < 1.0E248) {
            return 248.0;
        }
        if (number < 1.0E249) {
            return 249.0;
        }
        if (number < 1.0E250) {
            return 250.0;
        }
        if (number < 1.0E251) {
            return 251.0;
        }
        if (number < 1.0E252) {
            return 252.0;
        }
        if (number < 1.0E253) {
            return 253.0;
        }
        if (number < 1.0E254) {
            return 254.0;
        }
        if (number < 1.0E255) {
            return 255.0;
        }
        if (number < 1.0E256) {
            return 256.0;
        }
        if (number < 1.0E257) {
            return 257.0;
        }
        if (number < 1.0E258) {
            return 258.0;
        }
        if (number < 1.0E259) {
            return 259.0;
        }
        if (number < 1.0E260) {
            return 260.0;
        }
        if (number < 1.0E261) {
            return 261.0;
        }
        if (number < 1.0E262) {
            return 262.0;
        }
        if (number < 1.0E263) {
            return 263.0;
        }
        if (number < 1.0E264) {
            return 264.0;
        }
        if (number < 1.0E265) {
            return 265.0;
        }
        if (number < 1.0E266) {
            return 266.0;
        }
        if (number < 1.0E267) {
            return 267.0;
        }
        if (number < 1.0E268) {
            return 268.0;
        }
        if (number < 1.0E269) {
            return 269.0;
        }
        if (number < 1.0E270) {
            return 270.0;
        }
        if (number < 1.0E271) {
            return 271.0;
        }
        if (number < 1.0E272) {
            return 272.0;
        }
        if (number < 1.0E273) {
            return 273.0;
        }
        if (number < 1.0E274) {
            return 274.0;
        }
        if (number < 1.0E275) {
            return 275.0;
        }
        if (number < 1.0E276) {
            return 276.0;
        }
        if (number < 1.0E277) {
            return 277.0;
        }
        if (number < 1.0E278) {
            return 278.0;
        }
        if (number < 1.0E279) {
            return 279.0;
        }
        if (number < 1.0E280) {
            return 280.0;
        }
        if (number < 1.0E281) {
            return 281.0;
        }
        if (number < 1.0E282) {
            return 282.0;
        }
        if (number < 1.0E283) {
            return 283.0;
        }
        if (number < 1.0E284) {
            return 284.0;
        }
        if (number < 1.0E285) {
            return 285.0;
        }
        if (number < 1.0E286) {
            return 286.0;
        }
        if (number < 1.0E287) {
            return 287.0;
        }
        if (number < 1.0E288) {
            return 288.0;
        }
        if (number < 1.0E289) {
            return 289.0;
        }
        if (number < 1.0E290) {
            return 290.0;
        }
        if (number < 1.0E291) {
            return 291.0;
        }
        if (number < 1.0E292) {
            return 292.0;
        }
        if (number < 1.0E293) {
            return 293.0;
        }
        if (number < 1.0E294) {
            return 294.0;
        }
        if (number < 1.0E295) {
            return 295.0;
        }
        if (number < 1.0E296) {
            return 296.0;
        }
        if (number < 1.0E297) {
            return 297.0;
        }
        if (number < 1.0E298) {
            return 298.0;
        }
        if (number < 1.0E299) {
            return 299.0;
        }
        if (number < 1.0E300) {
            return 300.0;
        }
        if (number < 1.0E301) {
            return 301.0;
        }
        if (number < 1.0E302) {
            return 302.0;
        }
        if (number < 1.0E303) {
            return 303.0;
        }
        if (number < 1.0E304) {
            return 304.0;
        }
        if (number < 1.0E305) {
            return 305.0;
        }
        if (number < 1.0E306) {
            return 306.0;
        }
        if (number < 1.0E307) {
            return 307.0;
        }
        if (number < 1.0E308) {
            return 308.0;
        }
        return 309.0;
    }

    public static final long numberOfDigits(long number, long numeralSystemBase) {
        if (numeralSystemBase < 1L) {
            return -1L;
        }
        if (number < 0L) {
            number = -number;
        }
        if (numeralSystemBase == 10L) {
            return NumberTheory.numberOfDigits(number);
        }
        if (numeralSystemBase == 1L) {
            return (int)number;
        }
        if (number < numeralSystemBase) {
            return 1L;
        }
        long quotient = number;
        long digitsNum = 0L;
        while (quotient >= 1L) {
            quotient /= numeralSystemBase;
            ++digitsNum;
        }
        return digitsNum;
    }

    public static final double numberOfDigits(double number, double numeralSystemBase) {
        if (Double.isNaN(number)) {
            return Double.NaN;
        }
        if (Double.isNaN(numeralSystemBase)) {
            return Double.NaN;
        }
        if (Double.isInfinite(numeralSystemBase)) {
            return Double.NaN;
        }
        if (numeralSystemBase < 1.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(number)) {
            return Double.POSITIVE_INFINITY;
        }
        if (number < 0.0) {
            number = -number;
        }
        number = MathFunctions.floor(number);
        if ((numeralSystemBase = MathFunctions.floor(numeralSystemBase)) == 10.0) {
            return NumberTheory.numberOfDigits(number);
        }
        if (numeralSystemBase == 1.0) {
            return (int)number;
        }
        if (number < numeralSystemBase) {
            return 1.0;
        }
        double quotient = number;
        double digitsNum = 0.0;
        while (quotient >= 1.0) {
            quotient = MathFunctions.floor(quotient / numeralSystemBase);
            digitsNum += 1.0;
        }
        return digitsNum;
    }

    public static final int digitAtPosition(long number, int position, int numeralSystemBase) {
        int digitsNum;
        if (numeralSystemBase < 1) {
            return -1;
        }
        if (number < 0L) {
            number = -number;
        }
        if (position <= -(digitsNum = (int)NumberTheory.numberOfDigits(number, numeralSystemBase))) {
            if (numeralSystemBase > 1) {
                return 0;
            }
            return -1;
        }
        if (position > digitsNum) {
            return -1;
        }
        if (numeralSystemBase == 1) {
            return 1;
        }
        int[] digits = new int[digitsNum];
        int digitIndex = digitsNum;
        for (long quotient = number; quotient >= 1L; quotient /= (long)numeralSystemBase) {
            int digit = (int)quotient % numeralSystemBase;
            digits[--digitIndex] = digit;
        }
        if (position >= 1) {
            return digits[position - 1];
        }
        return digits[digitsNum + position - 1];
    }

    public static final int digitAtPosition(long number, int position) {
        return NumberTheory.digitAtPosition(number, position, 10);
    }

    public static final double digitAtPosition(double number, double position, double numeralSystemBase) {
        int digitsNum;
        if (Double.isNaN(number)) {
            return Double.NaN;
        }
        if (Double.isNaN(position)) {
            return Double.NaN;
        }
        if (Double.isNaN(numeralSystemBase)) {
            return Double.NaN;
        }
        if (Double.isInfinite(number)) {
            return Double.NaN;
        }
        if (Double.isInfinite(position)) {
            return Double.NaN;
        }
        if (Double.isInfinite(numeralSystemBase)) {
            return Double.NaN;
        }
        if (numeralSystemBase < 1.0) {
            return Double.NaN;
        }
        if (number < 0.0) {
            number = -number;
        }
        if (position <= (double)(-(digitsNum = (int)NumberTheory.numberOfDigits(number = MathFunctions.floor(number), numeralSystemBase = MathFunctions.floor(numeralSystemBase))))) {
            if (numeralSystemBase > 1.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (position > (double)digitsNum) {
            return Double.NaN;
        }
        if (numeralSystemBase == 1.0) {
            return 1.0;
        }
        double[] digits = new double[digitsNum];
        double quotient = number;
        int digitIndex = digitsNum;
        while (quotient >= 1.0) {
            double digit = MathFunctions.floor(quotient % numeralSystemBase);
            quotient = MathFunctions.floor(quotient / numeralSystemBase);
            digits[--digitIndex] = digit;
        }
        if (position >= 1.0) {
            return digits[(int)(position - 1.0)];
        }
        return digits[(int)((double)digitsNum + position - 1.0)];
    }

    public static final double digitAtPosition(double number, double position) {
        return NumberTheory.digitAtPosition(number, position, 10.0);
    }

    public static final long[] primeFactors(long number) {
        long[] longZeroArray = new long[]{};
        if (number == 0L) {
            return longZeroArray;
        }
        if (number < 0L) {
            number = -number;
        }
        if (number == 1L) {
            long[] factors = new long[]{1L};
            return factors;
        }
        if (mXparser.primesCache != null && mXparser.primesCache.getCacheStatus() && number <= Integer.MAX_VALUE && mXparser.primesCache.primeTest((int)number) == 1) {
            long[] factors = new long[]{number};
            return factors;
        }
        long n = number;
        ArrayList<Long> factorsList = new ArrayList<Long>();
        for (long i = 2L; i <= n / i; ++i) {
            while (n % i == 0L) {
                factorsList.add(i);
                n /= i;
            }
        }
        if (n > 1L) {
            factorsList.add(n);
        }
        int nfact = factorsList.size();
        long[] factors = new long[nfact];
        for (int i = 0; i < nfact; ++i) {
            factors[i] = (Long)factorsList.get(i);
        }
        return factors;
    }

    public static final double[] primeFactors(double number) {
        double[] doubleZeroArray = new double[]{};
        if (Double.isNaN(number)) {
            return doubleZeroArray;
        }
        if (Double.isInfinite(number)) {
            return doubleZeroArray;
        }
        if ((number = MathFunctions.floor(MathFunctions.abs(number))) == 0.0) {
            return doubleZeroArray;
        }
        if (number == 1.0) {
            double[] factors = new double[]{1.0};
            return factors;
        }
        if (mXparser.primesCache != null && mXparser.primesCache.getCacheStatus() && number <= 2.147483647E9 && mXparser.primesCache.primeTest((int)number) == 1) {
            double[] factors = new double[]{number};
            return factors;
        }
        double n = number;
        ArrayList<Double> factorsList = new ArrayList<Double>();
        double i = 2.0;
        while (i <= MathFunctions.floor(n / i)) {
            while (n % i == 0.0) {
                factorsList.add(i);
                n = MathFunctions.floor(n / i);
            }
            double d = i;
            i = d + 1.0;
            MathFunctions.floor(d);
        }
        if (n > 1.0) {
            factorsList.add(n);
        }
        int nfact = factorsList.size();
        double[] factors = new double[nfact];
        for (int i2 = 0; i2 < nfact; ++i2) {
            factors[i2] = (Double)factorsList.get(i2);
        }
        return factors;
    }

    public static final double numberOfPrimeFactors(double number) {
        if (Double.isNaN(number)) {
            return Double.NaN;
        }
        double[] factors = NumberTheory.primeFactors(number);
        if (factors.length <= 1) {
            return factors.length;
        }
        double[][] factorsDist = NumberTheory.getDistValues(factors, false);
        return factorsDist.length;
    }

    public static final double primeFactorValue(double number, double id) {
        if (Double.isNaN(number)) {
            return Double.NaN;
        }
        if (Double.isNaN(id)) {
            return Double.NaN;
        }
        if (Double.isInfinite(number)) {
            return Double.NaN;
        }
        if (Double.isInfinite(id)) {
            return Double.NaN;
        }
        if ((number = MathFunctions.floor(MathFunctions.abs(number))) == 0.0) {
            return Double.NaN;
        }
        if (id < 1.0) {
            return 1.0;
        }
        if ((id = MathFunctions.floor(id)) > 2.147483647E9) {
            return 1.0;
        }
        double[] factors = NumberTheory.primeFactors(number);
        double[][] factorsDist = NumberTheory.getDistValues(factors, false);
        int nfact = factorsDist.length;
        if (id > (double)nfact) {
            return 1.0;
        }
        return factorsDist[(int)(id - 1.0)][0];
    }

    public static final double primeFactorExponent(double number, double id) {
        if (Double.isNaN(number)) {
            return Double.NaN;
        }
        if (Double.isNaN(id)) {
            return Double.NaN;
        }
        if (Double.isInfinite(number)) {
            return Double.NaN;
        }
        if (Double.isInfinite(id)) {
            return Double.NaN;
        }
        if ((number = MathFunctions.floor(MathFunctions.abs(number))) == 0.0) {
            return Double.NaN;
        }
        if (id < 1.0) {
            return 0.0;
        }
        if ((id = MathFunctions.floor(id)) > 2.147483647E9) {
            return 0.0;
        }
        double[] factors = NumberTheory.primeFactors(number);
        double[][] factorsDist = NumberTheory.getDistValues(factors, false);
        int nfact = factorsDist.length;
        if (id > (double)nfact) {
            return 0.0;
        }
        return factorsDist[(int)(id - 1.0)][1];
    }
}

