/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathConstants;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;

public final class MathFunctions {
    public static final double bellNumber(int n) {
        double result = Double.NaN;
        if (n > 1) {
            long[][] bellTriangle = new long[--n + 1][n + 1];
            bellTriangle[0][0] = 1L;
            bellTriangle[1][0] = 1L;
            for (int r = 1; r <= n; ++r) {
                for (int k = 0; k < r; ++k) {
                    bellTriangle[r][k + 1] = bellTriangle[r - 1][k] + bellTriangle[r][k];
                }
                if (r >= n) continue;
                bellTriangle[r + 1][0] = bellTriangle[r][r];
            }
            result = bellTriangle[n][n];
        } else if (n >= 0) {
            result = 1.0;
        }
        return result;
    }

    public static final double bellNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.bellNumber((int)Math.round(n));
    }

    public static final double eulerNumber(int n, int k) {
        if (n < 0) {
            return Double.NaN;
        }
        if (k < 0) {
            return 0.0;
        }
        if (n == 0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)(k + 1) * MathFunctions.eulerNumber(n - 1, k) + (double)(n - k) * MathFunctions.eulerNumber(n - 1, k - 1);
    }

    public static final double eulerNumber(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.eulerNumber((int)Math.round(n), (int)Math.round(k));
    }

    public static final double factorial(int n) {
        double f = Double.NaN;
        if (n >= 0) {
            if (n < 2) {
                f = 1.0;
            } else {
                f = 1.0;
                for (int i = 1; i <= n; ++i) {
                    f *= (double)i;
                }
            }
        }
        return f;
    }

    public static final double factorial(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.factorial((int)Math.round(n));
    }

    public static final double binomCoeff(double n, long k) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (k >= 0L) {
            double numerator = 1.0;
            if (k > 0L) {
                for (long i = 0L; i <= k - 1L; ++i) {
                    numerator *= n - (double)i;
                }
            }
            double denominator = 1.0;
            if (k > 1L) {
                for (long i = 1L; i <= k; ++i) {
                    denominator *= (double)i;
                }
            }
            result = numerator / denominator;
        }
        return result;
    }

    public static final double binomCoeff(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.binomCoeff(n, Math.round(k));
    }

    public static final double numberOfPermutations(double n, long k) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (k >= 0L) {
            double numerator = 1.0;
            if (k > 0L) {
                for (long i = 0L; i <= k - 1L; ++i) {
                    numerator *= n - (double)i;
                }
            }
            result = numerator;
        }
        return result;
    }

    public static final double numberOfPermutations(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.numberOfPermutations(n, Math.round(k));
    }

    public static final double bernoulliNumber(int m, int n) {
        double result = Double.NaN;
        if (m >= 0 && n >= 0) {
            result = 0.0;
            for (int k = 0; k <= m; ++k) {
                for (int v = 0; v <= k; ++v) {
                    result += Math.pow(-1.0, v) * MathFunctions.binomCoeff((double)k, v) * (Math.pow(n + v, m) / (double)(k + 1));
                }
            }
        }
        return result;
    }

    public static final double bernoulliNumber(double m, double n) {
        if (Double.isNaN(m) || Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.bernoulliNumber((int)Math.round(m), (int)Math.round(n));
    }

    public static final double Stirling1Number(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (n == 0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (k == 0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)(n - 1) * MathFunctions.Stirling1Number(n - 1, k) + MathFunctions.Stirling1Number(n - 1, k - 1);
    }

    public static final double Stirling1Number(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.Stirling1Number((int)Math.round(n), (int)Math.round(k));
    }

    public static final double Stirling2Number(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (n == 0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (k == 0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)k * MathFunctions.Stirling2Number(n - 1, k) + MathFunctions.Stirling2Number(n - 1, k - 1);
    }

    public static final double Stirling2Number(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.Stirling2Number((int)Math.round(n), (int)Math.round(k));
    }

    public static final double worpitzkyNumber(int n, int k) {
        double result = Double.NaN;
        if (n >= 0 && k >= 0 && k <= n) {
            result = 0.0;
            for (int v = 0; v <= k; ++v) {
                result += Math.pow(-1.0, v + k) * Math.pow(v + 1, n) * MathFunctions.binomCoeff((double)k, v);
            }
        }
        return result;
    }

    public static final double worpitzkyNumber(double n, double k) {
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return Double.NaN;
        }
        return MathFunctions.worpitzkyNumber((int)Math.round(n), (int)Math.round(k));
    }

    public static final double harmonicNumber(int n) {
        if (n <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0;
        }
        double h = 1.0;
        for (double k = 2.0; k <= (double)n; k += 1.0) {
            h += 1.0 / k;
        }
        return h;
    }

    public static final double harmonicNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.harmonicNumber((int)Math.round(n));
    }

    public static final double harmonicNumber(double x, int n) {
        if (Double.isNaN(x) || x < 0.0) {
            return Double.NaN;
        }
        if (n <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return x;
        }
        double h = 1.0;
        for (double k = 2.0; k <= (double)n; k += 1.0) {
            h += 1.0 / MathFunctions.power(k, x);
        }
        return h;
    }

    public static final double harmonicNumber(double x, double n) {
        if (Double.isNaN(x) || Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.harmonicNumber(x, (int)Math.round(n));
    }

    public static final double catalanNumber(int n) {
        return MathFunctions.binomCoeff((double)(2 * n), n) * MathFunctions.div(1.0, n + 1);
    }

    public static final double catalanNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.catalanNumber((int)Math.round(n));
    }

    public static final double fibonacciNumber(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0;
        }
        return MathFunctions.fibonacciNumber(n - 1) + MathFunctions.fibonacciNumber(n - 2);
    }

    public static final double fibonacciNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.fibonacciNumber((int)Math.round(n));
    }

    public static final double lucasNumber(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 2.0;
        }
        if (n == 1) {
            return 1.0;
        }
        return MathFunctions.lucasNumber(n - 1) + MathFunctions.lucasNumber(n - 2);
    }

    public static final double lucasNumber(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        return MathFunctions.lucasNumber((int)Math.round(n));
    }

    public static final double kroneckerDelta(double i, double j) {
        if (Double.isNaN(i) || Double.isNaN(j)) {
            return Double.NaN;
        }
        if (i == j) {
            return 1.0;
        }
        return 0.0;
    }

    public static final double kroneckerDelta(int i, int j) {
        if (i == j) {
            return 1.0;
        }
        return 0.0;
    }

    public static final double continuedFraction(double ... sequence) {
        int lastIndex;
        if (sequence == null) {
            return Double.NaN;
        }
        if (sequence.length == 0) {
            return Double.NaN;
        }
        double cf = 0.0;
        if (sequence.length == 1) {
            return sequence[0];
        }
        for (int i = lastIndex = sequence.length - 1; i >= 0; --i) {
            double a = sequence[i];
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (i == lastIndex) {
                cf = a;
                continue;
            }
            if (cf == 0.0) {
                return Double.NaN;
            }
            cf = a + 1.0 / cf;
        }
        return cf;
    }

    private static final double continuedPolynomial(int n, double[] x) {
        if (x == null) {
            return Double.NaN;
        }
        if (x.length == 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 1.0;
        }
        if (n == 1) {
            return x[0];
        }
        return x[n - 1] * MathFunctions.continuedPolynomial(n - 1, x) + MathFunctions.continuedPolynomial(n - 2, x);
    }

    public static final double continuedPolynomial(double ... x) {
        if (x == null) {
            return Double.NaN;
        }
        if (x.length == 0) {
            return Double.NaN;
        }
        for (double d : x) {
            if (!Double.isNaN(d)) continue;
            return Double.NaN;
        }
        return MathFunctions.continuedPolynomial(x.length, x);
    }

    public static final double eulerPolynomial(int m, double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (m >= 0) {
            result = 0.0;
            for (int n = 0; n <= m; ++n) {
                for (int k = 0; k <= n; ++k) {
                    result += Math.pow(-1.0, k) * MathFunctions.binomCoeff((double)n, k) * Math.pow(x + (double)k, m);
                }
                result /= Math.pow(2.0, n);
            }
        }
        return result;
    }

    public static final double eulerPolynomial(double m, double x) {
        if (Double.isNaN(m) || Double.isNaN(x)) {
            return Double.NaN;
        }
        return MathFunctions.eulerPolynomial((int)Math.round(m), (double)((int)Math.round(x)));
    }

    public static final double chi(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x > a && x < b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double chi_LR(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x >= a && x <= b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double chi_L(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x >= a && x < b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double chi_R(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (!(Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))) {
            result = x > a && x <= b ? 1.0 : 0.0;
        }
        return result;
    }

    public static final double power(double a, double b) {
        double nint;
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        if (a >= 0.0) {
            return Math.pow(a, b);
        }
        if (MathFunctions.abs(b) >= 1.0) {
            return Math.pow(a, b);
        }
        if (b == 0.0) {
            return Math.pow(a, b);
        }
        double ndob = 1.0 / MathFunctions.abs(b);
        if (MathFunctions.abs(ndob - (nint = (double)Math.round(ndob))) <= 1.0E-14) {
            long n = (long)nint;
            if (n % 2L == 1L) {
                if (b > 0.0) {
                    return -Math.pow(MathFunctions.abs(a), 1.0 / ndob);
                }
                return -Math.pow(MathFunctions.abs(a), -1.0 / ndob);
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public static final double root(double n, double x) {
        if (Double.isNaN(n) || Double.isNaN(n)) {
            return Double.NaN;
        }
        if (Double.isInfinite(n) || Double.isInfinite(n)) {
            return Double.NaN;
        }
        if (n < -1.0E-14) {
            return Double.NaN;
        }
        if (MathFunctions.abs(n) <= 1.0E-14) {
            if (MathFunctions.abs(x) <= 1.0E-14) {
                return 0.0;
            }
            if (MathFunctions.abs(x - 1.0) <= 1.0E-14) {
                return 1.0;
            }
            return Double.NaN;
        }
        long nint = (long)MathFunctions.floor(n);
        if (nint == 1L) {
            return x;
        }
        if (nint == 2L) {
            return MathFunctions.sqrt(x);
        }
        if (nint % 2L == 1L) {
            if (x >= 0.0) {
                return Math.pow(x, 1.0 / (double)nint);
            }
            return -Math.pow(MathFunctions.abs(x), 1.0 / (double)nint);
        }
        if (x >= 0.0) {
            return Math.pow(x, 1.0 / (double)nint);
        }
        return Double.NaN;
    }

    public static final double tetration(double a, double n) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        if (n == Double.POSITIVE_INFINITY) {
            if (MathFunctions.abs(a - MathConstants.EXP_MINUS_E) <= 1.0E-14) {
                return 0.36787944117144233;
            }
            if (MathFunctions.abs(a - MathConstants.EXP_1_OVER_E) <= 1.0E-14) {
                return Math.E;
            }
            if (a > MathConstants.EXP_MINUS_E && a < MathConstants.EXP_1_OVER_E) {
                return SpecialFunctions.lambertW(-MathFunctions.ln(a), 0.0) / -MathFunctions.ln(a);
            }
            if (a > MathConstants.EXP_1_OVER_E) {
                return Double.POSITIVE_INFINITY;
            }
            if (a < MathConstants.EXP_MINUS_E) {
                return Double.NaN;
            }
        }
        if (n < -1.0E-14) {
            return Double.NaN;
        }
        if (MathFunctions.abs(n) <= 1.0E-14) {
            if (MathFunctions.abs(a) > 1.0E-14) {
                return 1.0;
            }
            return Double.NaN;
        }
        if ((n = MathFunctions.floor(n)) == 0.0) {
            if (MathFunctions.abs(a) > 1.0E-14) {
                return 1.0;
            }
            return Double.NaN;
        }
        if (MathFunctions.abs(a) <= 1.0E-14) {
            return 0.0;
        }
        if (n == 1.0) {
            return a;
        }
        double r = a;
        for (double i = 2.0; i <= n; i += 1.0) {
            r = Math.pow(a, r);
        }
        return r;
    }

    public static final double mod(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        return a % b;
    }

    public static final double div(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (b != 0.0) {
            result = a / b;
        }
        return result;
    }

    public static final double sin(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            a *= Math.PI / 180;
        }
        return Math.sin(a);
    }

    public static final double cos(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            a *= Math.PI / 180;
        }
        return Math.cos(a);
    }

    public static final double tan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            a *= Math.PI / 180;
        }
        return Math.tan(a);
    }

    public static final double ctan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            a *= Math.PI / 180;
        }
        double result = Double.NaN;
        double tg = Math.tan(a);
        if (tg != 0.0) {
            result = 1.0 / tg;
        }
        return result;
    }

    public static final double sec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            a *= Math.PI / 180;
        }
        double result = Double.NaN;
        double cos = Math.cos(a);
        if (cos != 0.0) {
            result = 1.0 / cos;
        }
        return result;
    }

    public static final double cosec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            a *= Math.PI / 180;
        }
        double result = Double.NaN;
        double sin = Math.sin(a);
        if (sin != 0.0) {
            result = 1.0 / sin;
        }
        return result;
    }

    public static final double asin(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double r = Math.asin(a);
        if (mXparser.checkIfDegreesMode()) {
            return r / (Math.PI / 180);
        }
        return r;
    }

    public static final double acos(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double r = Math.acos(a);
        if (mXparser.checkIfDegreesMode()) {
            return r / (Math.PI / 180);
        }
        return r;
    }

    public static final double atan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double r = Math.atan(a);
        if (mXparser.checkIfDegreesMode()) {
            return r / (Math.PI / 180);
        }
        return r;
    }

    public static final double actan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double r = Math.atan(1.0 / a);
        if (mXparser.checkIfDegreesMode()) {
            return r / (Math.PI / 180);
        }
        return r;
    }

    public static final double asec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double r = Math.acos(1.0 / a);
        if (mXparser.checkIfDegreesMode()) {
            return r / (Math.PI / 180);
        }
        return r;
    }

    public static final double acosec(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double r = Math.asin(1.0 / a);
        if (mXparser.checkIfDegreesMode()) {
            return r / (Math.PI / 180);
        }
        return r;
    }

    public static final double ln(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a);
    }

    public static final double log2(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a) / Math.log(2.0);
    }

    public static final double log10(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log10(a);
    }

    public static final double rad(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.toRadians(a);
    }

    public static final double exp(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.exp(a);
    }

    public static final double sqrt(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.sqrt(a);
    }

    public static final double sinh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.sinh(a);
    }

    public static final double cosh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.cosh(a);
    }

    public static final double tanh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.tanh(a);
    }

    public static final double coth(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double tanh = Math.tanh(a);
        if (tanh != 0.0) {
            result = 1.0 / tanh;
        }
        return result;
    }

    public static final double sech(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double cosh = Math.cosh(a);
        if (cosh != 0.0) {
            result = 1.0 / cosh;
        }
        return result;
    }

    public static final double csch(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double sinh = Math.sinh(a);
        if (sinh != 0.0) {
            result = 1.0 / sinh;
        }
        return result;
    }

    public static final double deg(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.toDegrees(a);
    }

    public static final double abs(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.abs(a);
    }

    public static final double sgn(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.signum(a);
    }

    public static final double floor(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.floor(a);
    }

    public static final double ceil(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.ceil(a);
    }

    public static final double arsinh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a + Math.sqrt(a * a + 1.0));
    }

    public static final double arcosh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static final double artanh(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (1.0 - a != 0.0) {
            result = 0.5 * Math.log((1.0 + a) / (1.0 - a));
        }
        return result;
    }

    public static final double arcoth(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (a - 1.0 != 0.0) {
            result = 0.5 * Math.log((a + 1.0) / (a - 1.0));
        }
        return result;
    }

    public static final double arsech(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (a != 0.0) {
            result = Math.log((1.0 + Math.sqrt(1.0 - a * a)) / a);
        }
        return result;
    }

    public static final double arcsch(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        if (a != 0.0) {
            result = Math.log(1.0 / a + Math.sqrt(1.0 + a * a) / Math.abs(a));
        }
        return result;
    }

    public static final double sa(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double x = Math.PI * a;
        double result = Double.NaN;
        result = x != 0.0 ? Math.sin(x) / x : 1.0;
        return result;
    }

    public static final double sinc(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        result = a != 0.0 ? (mXparser.checkIfDegreesMode() ? Math.sin(a * (Math.PI / 180)) / a : Math.sin(a) / a) : 1.0;
        return result;
    }

    public static final double log(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double result = Double.NaN;
        double logb = Math.log(b);
        if (logb != 0.0) {
            result = Math.log(a) / logb;
        }
        return result;
    }

    public static final double round(double value, int places) {
        if (Double.isNaN(value)) {
            return Double.NaN;
        }
        if (places < 0) {
            return Double.NaN;
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static final double roundHalfUp(double value, int places) {
        int ulpPosition;
        if (Double.isNaN(value)) {
            return Double.NaN;
        }
        if (places < 0) {
            return Double.NaN;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (value == 0.0) {
            return 0.0;
        }
        double sign = 1.0;
        double origValue = value;
        if (value < 0.0) {
            sign = -1.0;
            value = -value;
        }
        if ((ulpPosition = MathFunctions.ulpDecimalDigitsBefore(value)) <= 0) {
            return sign * Math.floor(value);
        }
        if (places > ulpPosition) {
            return origValue;
        }
        double multiplier = 1.0;
        for (int place = 0; place < places; ++place) {
            multiplier = Math.floor(multiplier * 10.0);
        }
        double valueMultiplied = value * multiplier;
        double valueFloor = Math.floor(valueMultiplied);
        if (Math.abs(valueMultiplied - valueFloor) >= 0.5) {
            valueFloor = Math.floor(valueFloor + 1.0);
        }
        return Math.floor(sign * valueFloor) / multiplier;
    }

    public static final double integerPart(double x) {
        if (x > 0.0) {
            return Math.floor(x);
        }
        if (x < 0.0) {
            return -Math.floor(-x);
        }
        return 0.0;
    }

    public static final int decimalDigitsBefore(double value) {
        if (value == 0.0) {
            return -1;
        }
        if (value <= 9.9E-323) {
            return 322;
        }
        if (value <= 1.0E-321) {
            return 321;
        }
        if (value <= 1.0E-320) {
            return 320;
        }
        if (value <= 1.0E-319) {
            return 319;
        }
        if (value <= 1.0E-318) {
            return 318;
        }
        if (value <= 1.0E-317) {
            return 317;
        }
        if (value <= 1.0E-316) {
            return 316;
        }
        if (value <= 1.0E-315) {
            return 315;
        }
        if (value <= 1.0E-314) {
            return 314;
        }
        if (value <= 1.0E-313) {
            return 313;
        }
        if (value <= 1.0E-312) {
            return 312;
        }
        if (value <= 1.0E-311) {
            return 311;
        }
        if (value <= 1.0E-310) {
            return 310;
        }
        if (value <= 1.0E-309) {
            return 309;
        }
        if (value <= 1.0E-308) {
            return 308;
        }
        if (value <= 1.0E-307) {
            return 307;
        }
        if (value <= 1.0E-306) {
            return 306;
        }
        if (value <= 1.0E-305) {
            return 305;
        }
        if (value <= 1.0E-304) {
            return 304;
        }
        if (value <= 1.0E-303) {
            return 303;
        }
        if (value <= 1.0E-302) {
            return 302;
        }
        if (value <= 1.0E-301) {
            return 301;
        }
        if (value <= 1.0E-300) {
            return 300;
        }
        if (value <= 1.0E-299) {
            return 299;
        }
        if (value <= 1.0E-298) {
            return 298;
        }
        if (value <= 1.0E-297) {
            return 297;
        }
        if (value <= 1.0E-296) {
            return 296;
        }
        if (value <= 1.0E-295) {
            return 295;
        }
        if (value <= 1.0E-294) {
            return 294;
        }
        if (value <= 1.0E-293) {
            return 293;
        }
        if (value <= 1.0E-292) {
            return 292;
        }
        if (value <= 1.0E-291) {
            return 291;
        }
        if (value <= 1.0E-290) {
            return 290;
        }
        if (value <= 1.0E-289) {
            return 289;
        }
        if (value <= 1.0E-288) {
            return 288;
        }
        if (value <= 1.0E-287) {
            return 287;
        }
        if (value <= 1.0E-286) {
            return 286;
        }
        if (value <= 1.0E-285) {
            return 285;
        }
        if (value <= 1.0E-284) {
            return 284;
        }
        if (value <= 1.0E-283) {
            return 283;
        }
        if (value <= 1.0E-282) {
            return 282;
        }
        if (value <= 1.0E-281) {
            return 281;
        }
        if (value <= 1.0E-280) {
            return 280;
        }
        if (value <= 1.0E-279) {
            return 279;
        }
        if (value <= 1.0E-278) {
            return 278;
        }
        if (value <= 1.0E-277) {
            return 277;
        }
        if (value <= 1.0E-276) {
            return 276;
        }
        if (value <= 1.0E-275) {
            return 275;
        }
        if (value <= 1.0E-274) {
            return 274;
        }
        if (value <= 1.0E-273) {
            return 273;
        }
        if (value <= 1.0E-272) {
            return 272;
        }
        if (value <= 1.0E-271) {
            return 271;
        }
        if (value <= 1.0E-270) {
            return 270;
        }
        if (value <= 1.0E-269) {
            return 269;
        }
        if (value <= 1.0E-268) {
            return 268;
        }
        if (value <= 1.0E-267) {
            return 267;
        }
        if (value <= 1.0E-266) {
            return 266;
        }
        if (value <= 1.0E-265) {
            return 265;
        }
        if (value <= 1.0E-264) {
            return 264;
        }
        if (value <= 1.0E-263) {
            return 263;
        }
        if (value <= 1.0E-262) {
            return 262;
        }
        if (value <= 1.0E-261) {
            return 261;
        }
        if (value <= 1.0E-260) {
            return 260;
        }
        if (value <= 1.0E-259) {
            return 259;
        }
        if (value <= 1.0E-258) {
            return 258;
        }
        if (value <= 1.0E-257) {
            return 257;
        }
        if (value <= 1.0E-256) {
            return 256;
        }
        if (value <= 1.0E-255) {
            return 255;
        }
        if (value <= 1.0E-254) {
            return 254;
        }
        if (value <= 1.0E-253) {
            return 253;
        }
        if (value <= 1.0E-252) {
            return 252;
        }
        if (value <= 1.0E-251) {
            return 251;
        }
        if (value <= 1.0E-250) {
            return 250;
        }
        if (value <= 1.0E-249) {
            return 249;
        }
        if (value <= 1.0E-248) {
            return 248;
        }
        if (value <= 1.0E-247) {
            return 247;
        }
        if (value <= 1.0E-246) {
            return 246;
        }
        if (value <= 1.0E-245) {
            return 245;
        }
        if (value <= 1.0E-244) {
            return 244;
        }
        if (value <= 1.0E-243) {
            return 243;
        }
        if (value <= 1.0E-242) {
            return 242;
        }
        if (value <= 1.0E-241) {
            return 241;
        }
        if (value <= 1.0E-240) {
            return 240;
        }
        if (value <= 1.0E-239) {
            return 239;
        }
        if (value <= 1.0E-238) {
            return 238;
        }
        if (value <= 1.0E-237) {
            return 237;
        }
        if (value <= 1.0E-236) {
            return 236;
        }
        if (value <= 1.0E-235) {
            return 235;
        }
        if (value <= 1.0E-234) {
            return 234;
        }
        if (value <= 1.0E-233) {
            return 233;
        }
        if (value <= 1.0E-232) {
            return 232;
        }
        if (value <= 1.0E-231) {
            return 231;
        }
        if (value <= 1.0E-230) {
            return 230;
        }
        if (value <= 1.0E-229) {
            return 229;
        }
        if (value <= 1.0E-228) {
            return 228;
        }
        if (value <= 1.0E-227) {
            return 227;
        }
        if (value <= 1.0E-226) {
            return 226;
        }
        if (value <= 1.0E-225) {
            return 225;
        }
        if (value <= 1.0E-224) {
            return 224;
        }
        if (value <= 1.0E-223) {
            return 223;
        }
        if (value <= 1.0E-222) {
            return 222;
        }
        if (value <= 1.0E-221) {
            return 221;
        }
        if (value <= 1.0E-220) {
            return 220;
        }
        if (value <= 1.0E-219) {
            return 219;
        }
        if (value <= 1.0E-218) {
            return 218;
        }
        if (value <= 1.0E-217) {
            return 217;
        }
        if (value <= 1.0E-216) {
            return 216;
        }
        if (value <= 1.0E-215) {
            return 215;
        }
        if (value <= 1.0E-214) {
            return 214;
        }
        if (value <= 1.0E-213) {
            return 213;
        }
        if (value <= 1.0E-212) {
            return 212;
        }
        if (value <= 1.0E-211) {
            return 211;
        }
        if (value <= 1.0E-210) {
            return 210;
        }
        if (value <= 1.0E-209) {
            return 209;
        }
        if (value <= 1.0E-208) {
            return 208;
        }
        if (value <= 1.0E-207) {
            return 207;
        }
        if (value <= 1.0E-206) {
            return 206;
        }
        if (value <= 1.0E-205) {
            return 205;
        }
        if (value <= 1.0E-204) {
            return 204;
        }
        if (value <= 1.0E-203) {
            return 203;
        }
        if (value <= 1.0E-202) {
            return 202;
        }
        if (value <= 1.0E-201) {
            return 201;
        }
        if (value <= 1.0E-200) {
            return 200;
        }
        if (value <= 1.0E-199) {
            return 199;
        }
        if (value <= 1.0E-198) {
            return 198;
        }
        if (value <= 1.0E-197) {
            return 197;
        }
        if (value <= 1.0E-196) {
            return 196;
        }
        if (value <= 1.0E-195) {
            return 195;
        }
        if (value <= 1.0E-194) {
            return 194;
        }
        if (value <= 1.0E-193) {
            return 193;
        }
        if (value <= 1.0E-192) {
            return 192;
        }
        if (value <= 1.0E-191) {
            return 191;
        }
        if (value <= 1.0E-190) {
            return 190;
        }
        if (value <= 1.0E-189) {
            return 189;
        }
        if (value <= 1.0E-188) {
            return 188;
        }
        if (value <= 1.0E-187) {
            return 187;
        }
        if (value <= 1.0E-186) {
            return 186;
        }
        if (value <= 1.0E-185) {
            return 185;
        }
        if (value <= 1.0E-184) {
            return 184;
        }
        if (value <= 1.0E-183) {
            return 183;
        }
        if (value <= 1.0E-182) {
            return 182;
        }
        if (value <= 1.0E-181) {
            return 181;
        }
        if (value <= 1.0E-180) {
            return 180;
        }
        if (value <= 1.0E-179) {
            return 179;
        }
        if (value <= 1.0E-178) {
            return 178;
        }
        if (value <= 1.0E-177) {
            return 177;
        }
        if (value <= 1.0E-176) {
            return 176;
        }
        if (value <= 1.0E-175) {
            return 175;
        }
        if (value <= 1.0E-174) {
            return 174;
        }
        if (value <= 1.0E-173) {
            return 173;
        }
        if (value <= 1.0E-172) {
            return 172;
        }
        if (value <= 1.0E-171) {
            return 171;
        }
        if (value <= 1.0E-170) {
            return 170;
        }
        if (value <= 1.0E-169) {
            return 169;
        }
        if (value <= 1.0E-168) {
            return 168;
        }
        if (value <= 1.0E-167) {
            return 167;
        }
        if (value <= 1.0E-166) {
            return 166;
        }
        if (value <= 1.0E-165) {
            return 165;
        }
        if (value <= 1.0E-164) {
            return 164;
        }
        if (value <= 1.0E-163) {
            return 163;
        }
        if (value <= 1.0E-162) {
            return 162;
        }
        if (value <= 1.0E-161) {
            return 161;
        }
        if (value <= 1.0E-160) {
            return 160;
        }
        if (value <= 1.0E-159) {
            return 159;
        }
        if (value <= 1.0E-158) {
            return 158;
        }
        if (value <= 1.0E-157) {
            return 157;
        }
        if (value <= 1.0E-156) {
            return 156;
        }
        if (value <= 1.0E-155) {
            return 155;
        }
        if (value <= 1.0E-154) {
            return 154;
        }
        if (value <= 1.0E-153) {
            return 153;
        }
        if (value <= 1.0E-152) {
            return 152;
        }
        if (value <= 1.0E-151) {
            return 151;
        }
        if (value <= 1.0E-150) {
            return 150;
        }
        if (value <= 1.0E-149) {
            return 149;
        }
        if (value <= 1.0E-148) {
            return 148;
        }
        if (value <= 1.0E-147) {
            return 147;
        }
        if (value <= 1.0E-146) {
            return 146;
        }
        if (value <= 1.0E-145) {
            return 145;
        }
        if (value <= 1.0E-144) {
            return 144;
        }
        if (value <= 1.0E-143) {
            return 143;
        }
        if (value <= 1.0E-142) {
            return 142;
        }
        if (value <= 1.0E-141) {
            return 141;
        }
        if (value <= 1.0E-140) {
            return 140;
        }
        if (value <= 1.0E-139) {
            return 139;
        }
        if (value <= 1.0E-138) {
            return 138;
        }
        if (value <= 1.0E-137) {
            return 137;
        }
        if (value <= 1.0E-136) {
            return 136;
        }
        if (value <= 1.0E-135) {
            return 135;
        }
        if (value <= 1.0E-134) {
            return 134;
        }
        if (value <= 1.0E-133) {
            return 133;
        }
        if (value <= 1.0E-132) {
            return 132;
        }
        if (value <= 1.0E-131) {
            return 131;
        }
        if (value <= 1.0E-130) {
            return 130;
        }
        if (value <= 1.0E-129) {
            return 129;
        }
        if (value <= 1.0E-128) {
            return 128;
        }
        if (value <= 1.0E-127) {
            return 127;
        }
        if (value <= 1.0E-126) {
            return 126;
        }
        if (value <= 1.0E-125) {
            return 125;
        }
        if (value <= 1.0E-124) {
            return 124;
        }
        if (value <= 1.0E-123) {
            return 123;
        }
        if (value <= 1.0E-122) {
            return 122;
        }
        if (value <= 1.0E-121) {
            return 121;
        }
        if (value <= 1.0E-120) {
            return 120;
        }
        if (value <= 1.0E-119) {
            return 119;
        }
        if (value <= 1.0E-118) {
            return 118;
        }
        if (value <= 1.0E-117) {
            return 117;
        }
        if (value <= 1.0E-116) {
            return 116;
        }
        if (value <= 1.0E-115) {
            return 115;
        }
        if (value <= 1.0E-114) {
            return 114;
        }
        if (value <= 1.0E-113) {
            return 113;
        }
        if (value <= 1.0E-112) {
            return 112;
        }
        if (value <= 1.0E-111) {
            return 111;
        }
        if (value <= 1.0E-110) {
            return 110;
        }
        if (value <= 1.0E-109) {
            return 109;
        }
        if (value <= 1.0E-108) {
            return 108;
        }
        if (value <= 1.0E-107) {
            return 107;
        }
        if (value <= 1.0E-106) {
            return 106;
        }
        if (value <= 1.0E-105) {
            return 105;
        }
        if (value <= 1.0E-104) {
            return 104;
        }
        if (value <= 1.0E-103) {
            return 103;
        }
        if (value <= 1.0E-102) {
            return 102;
        }
        if (value <= 1.0E-101) {
            return 101;
        }
        if (value <= 1.0E-100) {
            return 100;
        }
        if (value <= 1.0E-99) {
            return 99;
        }
        if (value <= 1.0E-98) {
            return 98;
        }
        if (value <= 1.0E-97) {
            return 97;
        }
        if (value <= 1.0E-96) {
            return 96;
        }
        if (value <= 1.0E-95) {
            return 95;
        }
        if (value <= 1.0E-94) {
            return 94;
        }
        if (value <= 1.0E-93) {
            return 93;
        }
        if (value <= 1.0E-92) {
            return 92;
        }
        if (value <= 1.0E-91) {
            return 91;
        }
        if (value <= 1.0E-90) {
            return 90;
        }
        if (value <= 1.0E-89) {
            return 89;
        }
        if (value <= 1.0E-88) {
            return 88;
        }
        if (value <= 1.0E-87) {
            return 87;
        }
        if (value <= 1.0E-86) {
            return 86;
        }
        if (value <= 1.0E-85) {
            return 85;
        }
        if (value <= 1.0E-84) {
            return 84;
        }
        if (value <= 1.0E-83) {
            return 83;
        }
        if (value <= 1.0E-82) {
            return 82;
        }
        if (value <= 1.0E-81) {
            return 81;
        }
        if (value <= 1.0E-80) {
            return 80;
        }
        if (value <= 1.0E-79) {
            return 79;
        }
        if (value <= 1.0E-78) {
            return 78;
        }
        if (value <= 1.0E-77) {
            return 77;
        }
        if (value <= 1.0E-76) {
            return 76;
        }
        if (value <= 1.0E-75) {
            return 75;
        }
        if (value <= 1.0E-74) {
            return 74;
        }
        if (value <= 1.0E-73) {
            return 73;
        }
        if (value <= 1.0E-72) {
            return 72;
        }
        if (value <= 1.0E-71) {
            return 71;
        }
        if (value <= 1.0E-70) {
            return 70;
        }
        if (value <= 1.0E-69) {
            return 69;
        }
        if (value <= 1.0E-68) {
            return 68;
        }
        if (value <= 1.0E-67) {
            return 67;
        }
        if (value <= 1.0E-66) {
            return 66;
        }
        if (value <= 1.0E-65) {
            return 65;
        }
        if (value <= 1.0E-64) {
            return 64;
        }
        if (value <= 1.0E-63) {
            return 63;
        }
        if (value <= 1.0E-62) {
            return 62;
        }
        if (value <= 1.0E-61) {
            return 61;
        }
        if (value <= 1.0E-60) {
            return 60;
        }
        if (value <= 1.0E-59) {
            return 59;
        }
        if (value <= 1.0E-58) {
            return 58;
        }
        if (value <= 1.0E-57) {
            return 57;
        }
        if (value <= 1.0E-56) {
            return 56;
        }
        if (value <= 1.0E-55) {
            return 55;
        }
        if (value <= 1.0E-54) {
            return 54;
        }
        if (value <= 1.0E-53) {
            return 53;
        }
        if (value <= 1.0E-52) {
            return 52;
        }
        if (value <= 1.0E-51) {
            return 51;
        }
        if (value <= 1.0E-50) {
            return 50;
        }
        if (value <= 1.0E-49) {
            return 49;
        }
        if (value <= 1.0E-48) {
            return 48;
        }
        if (value <= 1.0E-47) {
            return 47;
        }
        if (value <= 1.0E-46) {
            return 46;
        }
        if (value <= 1.0E-45) {
            return 45;
        }
        if (value <= 1.0E-44) {
            return 44;
        }
        if (value <= 1.0E-43) {
            return 43;
        }
        if (value <= 1.0E-42) {
            return 42;
        }
        if (value <= 1.0E-41) {
            return 41;
        }
        if (value <= 1.0E-40) {
            return 40;
        }
        if (value <= 1.0E-39) {
            return 39;
        }
        if (value <= 1.0E-38) {
            return 38;
        }
        if (value <= 1.0E-37) {
            return 37;
        }
        if (value <= 1.0E-36) {
            return 36;
        }
        if (value <= 1.0E-35) {
            return 35;
        }
        if (value <= 1.0E-34) {
            return 34;
        }
        if (value <= 1.0E-33) {
            return 33;
        }
        if (value <= 1.0E-32) {
            return 32;
        }
        if (value <= 1.0E-31) {
            return 31;
        }
        if (value <= 1.0E-30) {
            return 30;
        }
        if (value <= 1.0E-29) {
            return 29;
        }
        if (value <= 1.0E-28) {
            return 28;
        }
        if (value <= 1.0E-27) {
            return 27;
        }
        if (value <= 1.0E-26) {
            return 26;
        }
        if (value <= 1.0E-25) {
            return 25;
        }
        if (value <= 1.0E-24) {
            return 24;
        }
        if (value <= 1.0E-23) {
            return 23;
        }
        if (value <= 1.0E-22) {
            return 22;
        }
        if (value <= 1.0E-21) {
            return 21;
        }
        if (value <= 1.0E-20) {
            return 20;
        }
        if (value <= 1.0E-19) {
            return 19;
        }
        if (value <= 1.0E-18) {
            return 18;
        }
        if (value <= 1.0E-17) {
            return 17;
        }
        if (value <= 1.0E-16) {
            return 16;
        }
        if (value <= 1.0E-15) {
            return 15;
        }
        if (value <= 1.0E-14) {
            return 14;
        }
        if (value <= 1.0E-13) {
            return 13;
        }
        if (value <= 1.0E-12) {
            return 12;
        }
        if (value <= 1.0E-11) {
            return 11;
        }
        if (value <= 1.0E-10) {
            return 10;
        }
        if (value <= 1.0E-9) {
            return 9;
        }
        if (value <= 1.0E-8) {
            return 8;
        }
        if (value <= 1.0E-7) {
            return 7;
        }
        if (value <= 1.0E-6) {
            return 6;
        }
        if (value <= 1.0E-5) {
            return 5;
        }
        if (value <= 1.0E-4) {
            return 4;
        }
        if (value <= 0.001) {
            return 3;
        }
        if (value <= 0.01) {
            return 2;
        }
        if (value <= 0.1) {
            return 1;
        }
        if (value <= 1.0) {
            return 0;
        }
        return -1;
    }

    public static final double ulp(double value) {
        return Math.ulp(value);
    }

    public static final int ulpDecimalDigitsBefore(double value) {
        if (Double.isNaN(value)) {
            return -2;
        }
        double u = MathFunctions.ulp(value);
        return MathFunctions.decimalDigitsBefore(u);
    }

    public static final double coalesce(double[] values) {
        if (values == null) {
            return Double.NaN;
        }
        if (values.length == 0) {
            return Double.NaN;
        }
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            return v;
        }
        return Double.NaN;
    }

    public static final boolean isInteger(double x) {
        double round;
        if (Double.isNaN(x)) {
            return false;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return false;
        }
        if (x < 0.0) {
            x = -x;
        }
        return Math.abs(x - (round = (double)Math.round(x))) < 1.0E-14;
    }

    public static final boolean almostEqual(double a, double b) {
        if (Double.isNaN(a)) {
            return false;
        }
        if (Double.isNaN(b)) {
            return false;
        }
        if (a == b) {
            return true;
        }
        return Math.abs(a - b) <= 1.0E-14;
    }
}

