/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.util.Random;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;

public final class ProbabilityDistributions {
    public static Random randomGenerator = new Random();

    public static final double rndUniformContinuous(double a, double b, Random rnd) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            return a;
        }
        double r = a + rnd.nextDouble() * (b - a);
        return r;
    }

    public static final double rndUniformContinuous(double a, double b) {
        return ProbabilityDistributions.rndUniformContinuous(a, b, randomGenerator);
    }

    public static final double rndUniformContinuous(Random rnd) {
        return rnd.nextDouble();
    }

    public static final double randomUniformContinuous() {
        return ProbabilityDistributions.rndUniformContinuous(randomGenerator);
    }

    public static final double pdfUniformContinuous(double x, double a, double b) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            if (x == a) {
                return 1.0;
            }
            return 0.0;
        }
        if (x < a || x > b) {
            return 0.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return 1.0 / (b - a);
    }

    public static final double cdfUniformContinuous(double x, double a, double b) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            if (x < a) {
                return 0.0;
            }
            return 1.0;
        }
        if (x < a) {
            return 0.0;
        }
        if (x >= b) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return (x - a) / (b - a);
    }

    public static final double qntUniformContinuous(double q, double a, double b) {
        if (Double.isNaN(q)) {
            return Double.NaN;
        }
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (q < 0.0 || q > 1.0) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            if (q == 1.0) {
                return b;
            }
            return Double.NaN;
        }
        if (q == 0.0) {
            return a;
        }
        if (q == 1.0) {
            return b;
        }
        return a + q * (b - a);
    }

    public static final double rndInteger(int a, int b, Random rnd) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            return a;
        }
        int n = b - a + 1;
        int r = a + rnd.nextInt(n);
        return r;
    }

    public static final double rndInteger(int a, int b) {
        return ProbabilityDistributions.rndInteger(a, b, randomGenerator);
    }

    public static final int rndInteger(Random rnd) {
        return rnd.nextInt();
    }

    public static final int rndIndex(int n, Random rnd) {
        if (n < 0) {
            return -1;
        }
        return rnd.nextInt(n);
    }

    public static final int rndIndex(int n) {
        if (n < 0) {
            return -1;
        }
        return randomGenerator.nextInt(n);
    }

    public static final int rndInteger() {
        return ProbabilityDistributions.rndInteger(randomGenerator);
    }

    public static final double rndNormal(double mean, double stddev, Random rnd) {
        double x;
        boolean polarTransform;
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (rnd == null) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            return mean;
        }
        do {
            double b;
            double v2;
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            double a = rnd.nextDouble();
            double v1 = 2.0 * a - 1.0;
            double r = v1 * v1 + (v2 = 2.0 * (b = rnd.nextDouble()) - 1.0) * v2;
            if (r >= 1.0 || r == 0.0) {
                x = 0.0;
                polarTransform = false;
                continue;
            }
            double fac = MathFunctions.sqrt(-2.0 * MathFunctions.ln(r) / r);
            x = v1 * fac;
            polarTransform = true;
        } while (!polarTransform);
        return mean + stddev * x;
    }

    public static final double rndNormal(double mean, double stddev) {
        return ProbabilityDistributions.rndNormal(mean, stddev, randomGenerator);
    }

    public static final double pdfNormal(double x, double mean, double stddev) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            if (x == mean) {
                return 1.0;
            }
            return 0.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double d = (x - mean) / stddev;
        return MathFunctions.exp(-0.5 * d * d) / (2.5066282746310007 * stddev);
    }

    public static final double cdfNormal(double x, double mean, double stddev) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            if (x < mean) {
                return 0.0;
            }
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return 0.5 * SpecialFunctions.erfc((mean - x) / (stddev * 1.4142135623730951));
    }

    public static final double qntNormal(double q, double mean, double stddev) {
        if (Double.isNaN(q)) {
            return Double.NaN;
        }
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (q < 0.0 || q > 1.0) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            if (q == 1.0) {
                return mean;
            }
            return Double.NaN;
        }
        if (q == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (q == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return mean - stddev * 1.4142135623730951 * SpecialFunctions.erfcInv(2.0 * q);
    }
}

