/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public final class SerializationUtils {
    private static boolean binarySerializationEnabled = false;
    private static boolean lastOperationWasSuccessful = false;
    private static String lastOperationMessage = "";
    private static final String INFO_SERIALIZATION_PERFORMED = "Serialization has been performed:";
    private static final String INFO_DESERIALIZATION_PERFORMED = "Deserialization has been performed:";
    private static final String ERROR_NULL_OBJECT = "Null object passed in the parameter.";
    private static final String ERROR_NULL_FILE_PATH = "Null file passed in the parameter.";
    private static final String ERROR_FILE_PATH_ZERO_LENGTH = "The file path does not contain any characters.";
    private static final String ERROR_IS_NOT_A_FILE = "The file path is not a file:";
    private static final String ERROR_FILE_NOT_EXISTS = "The file path does not exits:";
    private static final String ERROR_NULL_DATA = "Null data passed in the parameter.";
    private static final String ERROR_NULL_TYPE = "Null type passed in the parameter.";
    private static final String INFO_EXCEPTION = "Exception: ";
    private static final String INFO_BINARY_SERIALIZATION_ENABLED = "Binary serialization is enabled. Use it only in a conscious and limited way.";
    private static final String INFO_BINARY_SERIALIZATION_DISABLED = "Binary serialization is disabled. You can enable it if you are aware of security risks.";
    private static final String WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "SECURITY WARNING:\nDeserializing data from an untrusted source can introduce security vulnerabilities\nto your application. Depending on the settings used during deserialization,\nuntrusted data may be able to execute arbitrary code or cause a denial of service\nattack. Untrusted data can come from over the network from an untrusted source\n(e.g. any network client), or it can be manipulated/tampered by an intermediary while\nin transit over an unauthenticated connection, or from local storage where it may\nhave been compromised/tampered, or from many other sources. MathParser.org-mXparser\ndoes not provide any means to authenticate data or secure it from tampering. Use an\nappropriate data authentication method before deserializing. Be very mindful of these\nattack scenarios; many projects and companies and users of serialization libraries in\ngeneral have been bitten by untrusted deserialization of user data in the past.";

    public static void enableBinarySerializationIamAwareOfSecurityRisks() {
        binarySerializationEnabled = true;
        lastOperationWasSuccessful = true;
        SerializationUtils.logLastOperationMessage(INFO_BINARY_SERIALIZATION_ENABLED);
    }

    public static void disableBinarySerialization() {
        binarySerializationEnabled = false;
        lastOperationWasSuccessful = true;
        SerializationUtils.logLastOperationMessage(INFO_BINARY_SERIALIZATION_DISABLED);
    }

    public static boolean isBinarySerializationEnabled() {
        return binarySerializationEnabled;
    }

    public static boolean checkLastOperationWasSuccessful() {
        return lastOperationWasSuccessful;
    }

    public static String getLastOperationMessage() {
        return lastOperationMessage;
    }

    private static void logLastOperationMessage(String message) {
        lastOperationMessage = message + "\n" + WARNING_BINARY_SERIALIZATION_SECURITY_RISKS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeToBytes(Serializable objectToSerialize) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(INFO_BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (objectToSerialize == null) {
            SerializationUtils.logLastOperationMessage(ERROR_NULL_OBJECT);
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            oos = new ObjectOutputStream(baos);
            Serializable serializable = objectToSerialize;
            synchronized (serializable) {
                oos.writeObject(objectToSerialize);
                oos.close();
            }
            SerializationUtils.logLastOperationMessage("Serialization has been performed: " + SerializationUtils.getSimpleName(objectToSerialize));
            lastOperationWasSuccessful = true;
            return baos.toByteArray();
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage("Exception:  " + SerializationUtils.getSimpleName(e) + ", " + e.getMessage());
            return null;
        }
    }

    public static String serializeToString(Serializable objectToSerialize) {
        lastOperationWasSuccessful = false;
        byte[] data = SerializationUtils.serializeToBytes(objectToSerialize);
        if (data == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serializeToFile(Serializable objectToSerialize, String filePath) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(INFO_BINARY_SERIALIZATION_DISABLED);
            return false;
        }
        if (filePath == null) {
            SerializationUtils.logLastOperationMessage(ERROR_NULL_FILE_PATH);
            return false;
        }
        if (filePath.length() == 0) {
            SerializationUtils.logLastOperationMessage(ERROR_FILE_PATH_ZERO_LENGTH);
            return false;
        }
        if (objectToSerialize == null) {
            SerializationUtils.logLastOperationMessage(ERROR_NULL_OBJECT);
            return false;
        }
        File file = new File(filePath);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            Serializable serializable = objectToSerialize;
            synchronized (serializable) {
                oos.writeObject(objectToSerialize);
                oos.close();
            }
            SerializationUtils.logLastOperationMessage("Serialization has been performed: " + SerializationUtils.getSimpleName(objectToSerialize) + ", " + filePath);
            lastOperationWasSuccessful = true;
            return true;
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage("Exception:  " + SerializationUtils.getSimpleName(e) + ", " + e.getMessage());
            return false;
        }
    }

    public static <T> T deserializeFromBytes(byte[] data) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(INFO_BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (data == null) {
            SerializationUtils.logLastOperationMessage(ERROR_NULL_DATA);
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object deserializedObject = ois.readObject();
            ois.close();
            lastOperationWasSuccessful = true;
            SerializationUtils.logLastOperationMessage("Deserialization has been performed: " + SerializationUtils.getSimpleName(deserializedObject));
            return (T)deserializedObject;
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage("Exception:  " + SerializationUtils.getSimpleName(e) + ", " + e.getMessage());
            return null;
        }
    }

    public static <T> T deserializeFromString(String data) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(INFO_BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (data == null) {
            SerializationUtils.logLastOperationMessage(ERROR_NULL_DATA);
            return null;
        }
        return SerializationUtils.deserializeFromBytes(Base64.getDecoder().decode(data));
    }

    public static <T> T deserializeFromFile(String filePath) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(INFO_BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (filePath == null) {
            SerializationUtils.logLastOperationMessage(ERROR_NULL_FILE_PATH);
            return null;
        }
        if (filePath.length() == 0) {
            SerializationUtils.logLastOperationMessage(ERROR_FILE_PATH_ZERO_LENGTH);
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            SerializationUtils.logLastOperationMessage("The file path does not exits: " + filePath);
            return null;
        }
        if (!file.isFile()) {
            SerializationUtils.logLastOperationMessage("The file path is not a file: " + filePath);
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object deserializedObject = ois.readObject();
            ois.close();
            lastOperationWasSuccessful = true;
            SerializationUtils.logLastOperationMessage("Deserialization has been performed: " + SerializationUtils.getSimpleName(deserializedObject) + ", " + filePath);
            return (T)deserializedObject;
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage("Exception:  " + SerializationUtils.getSimpleName(e) + ", " + e.getMessage());
            return null;
        }
    }

    private static String getSimpleName(Object obj) {
        if (obj == null) {
            return "<UNKNOWN>";
        }
        return obj.getClass().getSimpleName();
    }

    public static long getSerialVersionUID(int classId) {
        return 5010000L + 1L * (long)classId;
    }
}

