/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.CalcStepRecord;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.SerializationUtils;
import org.mariuszgromada.math.mxparser.StringModel;
import org.mariuszgromada.math.mxparser.mXparser;

public class CalcStepsRegister
implements Serializable {
    private static final int serialClassID = 8;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(8);
    public List<CalcStepRecord> calcStepRecords = new ArrayList<CalcStepRecord>();
    public String argumentNameStart = "";
    public String functionNameStart = "";
    public String expressionStringStart = "";
    public double result = Double.NaN;
    public double computingTime = Double.NaN;
    public String errorMessage = "";
    boolean isStartSet = false;
    int stepNumberGroup = 0;
    CalcStepRecord.StepType stepType = CalcStepRecord.StepType.Expression;

    public void consolePrint() {
        if (this.calcStepRecords.size() == 0) {
            mXparser.consolePrintln(StringModel.STRING_RESOURCES.CALC_STEPS_REGISTER_IS_EMPTY);
            return;
        }
        mXparser.consolePrint(StringModel.STRING_RESOURCES.CALC_STEPS_REGISTER_FOR + " ");
        boolean toPrintEq = false;
        if (this.argumentNameStart.length() > 0) {
            mXparser.consolePrint(StringModel.STRING_RESOURCES.ARGUMENT + " " + this.argumentNameStart);
            toPrintEq = true;
        }
        if (this.functionNameStart.length() > 0) {
            mXparser.consolePrint(StringModel.STRING_RESOURCES.FUNCTION + " " + this.functionNameStart);
            toPrintEq = true;
        }
        if (toPrintEq) {
            mXparser.consolePrint(" = ");
        } else {
            mXparser.consolePrint(StringModel.STRING_RESOURCES.EXPRESSION + " ");
        }
        mXparser.consolePrintln(this.expressionStringStart + ", " + StringModel.STRING_RESOURCES.RESULT + " = " + this.result);
        for (CalcStepRecord stepRecord : this.calcStepRecords) {
            mXparser.consolePrintln(StringModel.STRING_RESOURCES.GROUP_SHORT + " = " + stepRecord.numberGroup + ", " + StringModel.STRING_RESOURCES.NUMBER_SHORT + " = " + stepRecord.numberGroupWithin + ", " + StringModel.STRING_RESOURCES.FIRST + " = " + stepRecord.firstInGroup + ", " + StringModel.STRING_RESOURCES.LAST + " = " + stepRecord.lastInGroup + ", " + StringModel.STRING_RESOURCES.TYPE + " = " + (Object)((Object)stepRecord.type) + ", " + StringModel.STRING_RESOURCES.DESCRIPTION_SHORT + " = " + stepRecord.description + ", " + StringModel.STRING_RESOURCES.STEP + " = " + stepRecord.content);
        }
        mXparser.consolePrintln(StringModel.STRING_RESOURCES.COMPUTING_TIME + " = " + this.computingTime + " s.");
    }

    void stepTypeSetExpression() {
        this.stepType = CalcStepRecord.StepType.Expression;
    }

    void stepTypeSetUserArgument() {
        this.stepType = CalcStepRecord.StepType.Argument;
    }

    void stepTypeSetUserFunction() {
        this.stepType = CalcStepRecord.StepType.Function;
    }

    static void stepTypeSetExpression(CalcStepsRegister calcStepsRegister) {
        if (calcStepsRegister == null) {
            return;
        }
        calcStepsRegister.stepTypeSetExpression();
    }

    static void setUserArgument(CalcStepsRegister calcStepsRegister, Argument argument) {
        if (calcStepsRegister == null) {
            return;
        }
        calcStepsRegister.stepTypeSetUserArgument();
        if (calcStepsRegister.isStartSet) {
            return;
        }
        calcStepsRegister.argumentNameStart = argument.getArgumentName();
        calcStepsRegister.expressionStringStart = argument.getArgumentExpressionString().trim();
        calcStepsRegister.isStartSet = true;
    }

    static void setUserFunction(CalcStepsRegister calcStepsRegister, Function function) {
        if (calcStepsRegister == null) {
            return;
        }
        calcStepsRegister.stepTypeSetUserFunction();
        if (calcStepsRegister.isStartSet) {
            return;
        }
        calcStepsRegister.functionNameStart = function.getFunctionName();
        calcStepsRegister.expressionStringStart = function.getFunctionExpressionString().trim();
        calcStepsRegister.isStartSet = true;
    }

    static void stepNumberGroupIncrease(CalcStepsRegister calcStepsRegister, Expression expression) {
        if (calcStepsRegister == null) {
            return;
        }
        ++calcStepsRegister.stepNumberGroup;
        if (calcStepsRegister.isStartSet) {
            return;
        }
        calcStepsRegister.expressionStringStart = expression.getExpressionString().trim();
        calcStepsRegister.isStartSet = true;
    }
}

