/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import org.mariuszgromada.math.mxparser.StringInvariant;
import org.mariuszgromada.math.mxparser.StringModel;

public final class SerializationUtils {
    private static boolean binarySerializationEnabled = false;
    private static boolean lastOperationWasSuccessful = false;
    private static String lastOperationMessage = "";

    public static void enableBinarySerializationIamAwareOfSecurityRisks() {
        binarySerializationEnabled = true;
        lastOperationWasSuccessful = true;
        SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.BINARY_SERIALIZATION_ENABLED);
    }

    public static void disableBinarySerialization() {
        binarySerializationEnabled = false;
        lastOperationWasSuccessful = true;
        SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.BINARY_SERIALIZATION_DISABLED);
    }

    public static boolean isBinarySerializationEnabled() {
        return binarySerializationEnabled;
    }

    public static boolean checkLastOperationWasSuccessful() {
        return lastOperationWasSuccessful;
    }

    public static String getLastOperationMessage() {
        return lastOperationMessage;
    }

    private static void logLastOperationMessage(String message) {
        lastOperationMessage = message + StringInvariant.NEW_LINE + StringModel.STRING_RESOURCES.WARNING_BINARY_SERIALIZATION_SECURITY_RISKS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeToBytes(Serializable objectToSerialize) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (objectToSerialize == null) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.NULL_OBJECT_PROVIDED);
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            oos = new ObjectOutputStream(baos);
            Serializable serializable = objectToSerialize;
            synchronized (serializable) {
                oos.writeObject(objectToSerialize);
                oos.close();
            }
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.SERIALIZATION_PERFORMED + " " + SerializationUtils.getSimpleName(objectToSerialize));
            lastOperationWasSuccessful = true;
            return baos.toByteArray();
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.EXCEPTION + ": " + SerializationUtils.getSimpleName(e) + ": " + e.getMessage());
            return null;
        }
    }

    public static String serializeToString(Serializable objectToSerialize) {
        lastOperationWasSuccessful = false;
        byte[] data = SerializationUtils.serializeToBytes(objectToSerialize);
        if (data == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serializeToFile(Serializable objectToSerialize, String filePath) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.BINARY_SERIALIZATION_DISABLED);
            return false;
        }
        if (filePath == null) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.NULL_FILE_PATH_PROVIDED);
            return false;
        }
        if (filePath.length() == 0) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.FILE_PATH_ZERO_LENGTH_PROVIDED);
            return false;
        }
        if (objectToSerialize == null) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.NULL_OBJECT_PROVIDED);
            return false;
        }
        File file = new File(filePath);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            Serializable serializable = objectToSerialize;
            synchronized (serializable) {
                oos.writeObject(objectToSerialize);
                oos.close();
            }
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.SERIALIZATION_PERFORMED + " " + SerializationUtils.getSimpleName(objectToSerialize) + ": " + filePath);
            lastOperationWasSuccessful = true;
            return true;
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.EXCEPTION + ": " + SerializationUtils.getSimpleName(e) + ": " + e.getMessage());
            return false;
        }
    }

    public static <T> T deserializeFromBytes(byte[] data) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (data == null) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.NULL_DATA_PROVIDED);
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object deserializedObject = ois.readObject();
            ois.close();
            lastOperationWasSuccessful = true;
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.DESERIALIZATION_PERFORMED + " " + SerializationUtils.getSimpleName(deserializedObject));
            return (T)deserializedObject;
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.EXCEPTION + ": " + SerializationUtils.getSimpleName(e) + ": " + e.getMessage());
            return null;
        }
    }

    public static <T> T deserializeFromString(String data) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (data == null) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.NULL_DATA_PROVIDED);
            return null;
        }
        return SerializationUtils.deserializeFromBytes(Base64.getDecoder().decode(data));
    }

    public static <T> T deserializeFromFile(String filePath) {
        lastOperationWasSuccessful = false;
        if (!binarySerializationEnabled) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.BINARY_SERIALIZATION_DISABLED);
            return null;
        }
        if (filePath == null) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.NULL_FILE_PATH_PROVIDED);
            return null;
        }
        if (filePath.length() == 0) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.FILE_PATH_ZERO_LENGTH_PROVIDED);
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.FILE_PATH_NOT_EXISTS + " " + filePath);
            return null;
        }
        if (!file.isFile()) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.FILE_PATH_IS_NOT_A_FILE + " " + filePath);
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object deserializedObject = ois.readObject();
            ois.close();
            lastOperationWasSuccessful = true;
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.DESERIALIZATION_PERFORMED + " " + SerializationUtils.getSimpleName(deserializedObject) + ": " + filePath);
            return (T)deserializedObject;
        }
        catch (Exception e) {
            SerializationUtils.logLastOperationMessage(StringModel.STRING_RESOURCES.EXCEPTION + ": " + SerializationUtils.getSimpleName(e) + ": " + e.getMessage());
            return null;
        }
    }

    private static String getSimpleName(Object obj) {
        if (obj == null) {
            return "<UNKNOWN>";
        }
        return obj.getClass().getSimpleName();
    }

    public static long getSerialVersionUID(int classId) {
        return 5020000L + 1L * (long)classId;
    }
}

