/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.License;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.StringInvariant;
import org.mariuszgromada.math.mxparser.StringUtils;
import org.mariuszgromada.math.mxparser.TokenModification;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.PrimesCache;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Token;

public final class mXparser {
    public static final int VERSION_MAJOR = 5;
    public static final int VERSION_MINOR = 2;
    public static final int VERSION_PATCH = 0;
    public static final String VERSION = "5.2.0";
    public static final String VERSION_CODE_NAME = "Orion";
    public static final String VERSION_NAME = "5.2.0 Orion";
    public static final String BUIT_FOR = "JDK8";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    private static volatile StringBuilder CONSOLE_OUTPUT = new StringBuilder();
    private static volatile String CONSOLE_PREFIX;
    private static volatile String CONSOLE_OUTPUT_PREFIX;
    private static volatile int CONSOLE_ROW_NUMBER;
    public static volatile PrimesCache primesCache;
    public static final int PRIMES_CACHE_NOT_INITIALIZED = -1;
    private static int THREADS_NUMBER;
    static volatile boolean ulpRounding;
    static volatile boolean canonicalRounding;
    static volatile boolean almostIntRounding;
    static final int DEFAULT_MAX_RECURSION_CALLS = 200;
    static volatile int MAX_RECURSION_CALLS;
    static volatile int ERROR_MESSAGE_MAXIMUM_LENGTH;
    static volatile int ERROR_MESSAGE_MAXIMUM_NUMBER_OF_EXPECTED_TOKENS;
    static volatile List<String> tokensToRemove;
    static volatile List<TokenModification> tokensToModify;
    static volatile boolean degreesMode;
    static volatile boolean overrideBuiltinTokens;
    static volatile boolean impliedMultiplicationMode;
    static volatile boolean unicodeKeyWordsEnabled;
    static volatile boolean attemptToFixExpStrEnabled;
    static volatile int optionsChangesetNumber;
    private static volatile boolean cancelCurrentCalculationFlag;
    static volatile Expression HELP_EXPRESSION;
    public static final String LICENSE = "mXparser - version 5.2.0\nMathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2023-01-29\nThe most up-to-date license is available at the below link:\n- https://mathparser.org/mxparser-license\n\nAUTHOR: Copyright 2010 - 2023 Mariusz Gromada - All rights reserved\nPUBLISHER: INFIMA - https://payhip.com/infima\n\nSOFTWARE means source code and/or binary form and/or documentation.\nPRODUCT: MathParser.org-mXparser SOFTWARE\nLICENSE: DUAL LICENSE AGREEMENT\n\nBY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE\nBOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.\n\nAUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT\nmodel designed to meet the needs of both non-commercial use as well as\ncommercial use.\n\nNON-COMMERCIAL USE means any use or activity where a fee is not charged\nand the purpose is not the sale of a good or service, and the use or\nactivity is not intended to produce a profit. NON-COMMERCIAL USE examples:\n\n1. Free Open-Source Software (\"FOSS\").\n2. Non-commercial use in research, scholarly and education.\n\nCOMMERCIAL USE means any use or activity where a fee is charged or the\npurpose is the sale of a good or service, or the use or activity is\nintended to produce a profit. COMMERCIAL USE examples:\n\n1. OEMs (Original Equipment Manufacturers).\n2. ISVs (Independent Software Vendors).\n3. VARs (Value Added Resellers).\n4. Other distributors that combine and distribute commercially licensed\n   software.\n\nIN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE\nAPPROPRIATE LICENSE FROM \"INFIMA\" ONLINE STORE, STORE ADDRESS:\n\n1. https://mathparser.org/order-commercial-license\n2. https://payhip.com/infima\n\nNON-COMMERCIAL LICENSE\n\nRedistribution and use of the PRODUCT in source and/or binary forms,\nwith or without modification, are permitted provided that the following\nconditions are met:\n\n1. Redistributions of source code must retain unmodified content of the\n   entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including\n   definition of NON-COMMERCIAL USE, definition of COMMERCIAL USE,\n   NON-COMMERCIAL LICENSE conditions, COMMERCIAL LICENSE conditions, and\n   the following DISCLAIMER.\n2. Redistributions in binary form must reproduce the entire content of\n   MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation\n   and/or other materials provided with the distribution, including\n   definition of NON-COMMERCIAL USE, definition of COMMERCIAL USE,\n   NON-COMMERCIAL LICENSE conditions, COMMERCIAL LICENSE conditions, and\n   the following DISCLAIMER.\n3. Any form of redistribution requires confirmation and signature of\n   the NON-COMMERCIAL USE by successfully calling the method:\n      License.iConfirmNonCommercialUse(...)\n   The method call takes place only internally for logging purposes and\n   there is no connection with other external services and no data is\n   sent or collected. The lack of a method call (or its successful call)\n   does not affect the operation of the PRODUCT in any way. Please see\n   the API documentation.\n\nCOMMERCIAL LICENSE\n\n 1. Before purchasing a commercial license, AUTHOR & PUBLISHER allow you\n    to download, install and use up to three copies of the PRODUCT to\n    perform integration tests, confirm the quality of the PRODUCT and\n    its suitability. The testing period should be limited to fourteen\n    days. Tests should be performed under the conditions of test\n    environments. The purpose of the tests must not be to generate profit.\n 2. Provided that you purchased a license from \"INFIMA\" online store\n    (store address: https://mathparser.org/order-commercial-license or\n    https://payhip.com/infima), and you comply with all below terms and\n    conditions, and you have acknowledged and understood the following\n    DISCLAIMER, AUTHOR & PUBLISHER grant you a nonexclusive license\n    including the following rights:\n 3. The license has been granted only to you, i.e., the person or entity\n    that made the purchase, who is identified and confirmed by the data\n    provided during the purchase.\n 4. In case you purchased a license in the \"ONE-TIME PURCHASE\" model,\n    the license has been granted only for the PRODUCT version specified\n    in the purchase. The upgrade policy gives you additional rights and\n    is described in the dedicated section below.\n 5. In case you purchased a license in the \"SUBSCRIPTION\" model, you can\n    install and use any version of the PRODUCT, but only during the\n    subscription validity period.\n 6. In case you purchased a \"SINGLE LICENSE\" you can install and use the\n    PRODUCT from one workstation.\n 7. Additional copies of the PRODUCT can be installed and used from more\n    than one workstation; however, this number is limited to the number\n    of workstations purchased as per order.\n 8. In case you purchased a \"SITE LICENSE \", the PRODUCT can be installed\n    and used from all workstations located at your premises.\n 9. You may incorporate the unmodified PRODUCT into your own products\n    and software.\n10. If you purchased a license with the \"SOURCE CODE\" option, you may\n    modify the PRODUCT's source code and incorporate the modified source\n    code into your own products and/or software.\n11. Provided that the license validity period has not expired, you may\n    distribute your product and/or software with the incorporated\n    PRODUCT royalty-free.\n12. You may make copies of the PRODUCT for backup and archival purposes.\n13. Any form of redistribution requires confirmation and signature of\n    the COMMERCIAL USE by successfully calling the method:\n       License.iConfirmCommercialUse(...)\n    The method call takes place only internally for logging purposes and\n    there is no connection with other external services and no data is\n    sent or collected. The lack of a method call (or its successful call)\n    does not affect the operation of the PRODUCT in any way. Please see\n    the API documentation.\n14. AUTHOR & PUBLISHER reserve all rights not expressly granted to you\n    in this agreement.\n\nADDITIONAL CLARIFICATION ON WORKSTATION\n\nA workstation is a device, a remote device, or a virtual device, used by\nyou, your employees, or other entities to whom you have commissioned the\ntasks. For example, the number of workstations may refer to the number\nof software developers, engineers, architects, scientists, and other\nprofessionals who use the PRODUCT on your behalf. The number of\nworkstations is not the number of copies of your end-product that you\ndistribute to your end-users.\n\nBy purchasing the COMMERCIAL LICENSE, you only pay for the number of\nworkstations, while the number of copies/users of your final product\n(delivered to your end-users) is not limited.\n\nUPGRADE POLICY\n\nThe PRODUCT is versioned according to the following convention:\n\n   [MAJOR].[MINOR].[PATCH]\n\n1. COMMERCIAL LICENSE holders can install and use the updated version\n   for bug fixes free of charge, i.e. if you have purchased a license\n   for the [MAJOR].[MINOR] version (e.g.: 5.0), you can freely install\n   all the various releases specified in the [PATCH] version (e.g.: 5.0.2).\n   The license terms remain unchanged after the update.\n2. COMMERCIAL LICENSE holders for [MAJOR].[MINOR] version (e.g.: 5.0)\n   can install and use the updated version [MAJOR].[MINOR + 1] free of\n   charge, i.e., plus one release in the [MINOR] range (e.g.: 5.1). The\n   license terms remain unchanged after the update.\n3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are\n   not eligible for the free upgrade, can claim a discount when\n   purchasing the upgrade. For this purpose, please contact us via e-mail.\n\nDISCLAIMER\n\nTHIS PRODUCT IS PROVIDED BY AUTHOR & PUBLISHER \"AS IS\" AND ANY EXPRESS\nOR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE\nLIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\nSUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\nINTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\nCONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\nARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF\nTHE POSSIBILITY OF SUCH DAMAGE.\n\nTHE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE\nTHOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING\nOFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF AUTHOR OR PUBLISHER.\n\nCONTACT\n\n- e-mail: info@mathparser.org\n- website: https://mathparser.org\n- source code: https://github.com/mariuszgromada/MathParser.org-mXparser\n- online store: https://mathparser.org/order-commercial-license\n- online store: https://payhip.com/infima\n";
    public static final String NAMEv10 = "1.0";
    public static final String NAMEv20 = "2.0";
    public static final String NAMEv23 = "2.3";
    public static final String NAMEv24 = "2.4";
    public static final String NAMEv30 = "3.0";
    public static final String NAMEv40 = "4.0";
    public static final String NAMEv41 = "4.1";
    public static final String NAMEv42 = "4.2";
    public static final String NAMEv43 = "4.3";
    public static final String NAMEv44 = "4.4";
    public static final String NAMEv50 = "5.0";
    public static final String NAMEv51 = "5.1";
    public static final String NAMEv52 = "5.2";

    static void refreshHelp() {
        HELP_EXPRESSION = new Expression(new PrimitiveElement[0]);
    }

    public static void initPrimesCache() {
        primesCache = new PrimesCache();
    }

    public static void initPrimesCache(int mximumNumberInCache) {
        primesCache = new PrimesCache(mximumNumberInCache);
    }

    public static void initPrimesCache(PrimesCache primesCache) {
        mXparser.primesCache = primesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitPrimesCacheSuccessful() {
        if (primesCache == null) {
            return false;
        }
        PrimesCache primesCache = mXparser.primesCache;
        synchronized (primesCache) {
            return mXparser.primesCache.isInitSuccessful();
        }
    }

    public static void setNoPrimesCache() {
        primesCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxNumInPrimesCache() {
        if (primesCache != null) {
            PrimesCache primesCache = mXparser.primesCache;
            synchronized (primesCache) {
                return mXparser.primesCache.getMaxNumInCache();
            }
        }
        return -1;
    }

    public static int getThreadsNumber() {
        return THREADS_NUMBER;
    }

    public static void setDefaultThreadsNumber() {
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
    }

    public static void setThreadsNumber(int threadsNumber) {
        if (threadsNumber > 0) {
            THREADS_NUMBER = threadsNumber;
        }
    }

    @Deprecated
    public static double getFunctionValue(Expression f, Argument x, double x0) {
        return MathFunctions.getFunctionValue(f, x, x0);
    }

    public static double[] arrayList2double(List<Double> numbers) {
        if (numbers == null) {
            return null;
        }
        int size = numbers.size();
        double[] newNumbers = new double[size];
        for (int i = 0; i < size; ++i) {
            newNumbers[i] = numbers.get(i);
        }
        return newNumbers;
    }

    @Deprecated
    public static double[] getFunctionValues(Expression f, Argument index, double from, double to, double delta) {
        return MathFunctions.getFunctionValues(f, index, from, to, delta);
    }

    public static void setRandomGenerator(Random randomGenerator) {
        if (randomGenerator != null) {
            ProbabilityDistributions.randomGenerator = randomGenerator;
        }
    }

    public static void setExactComparison() {
        BinaryRelations.setExactComparison();
    }

    public static void setEpsilonComparison() {
        BinaryRelations.setEpsilonComparison();
    }

    public static void setEpsilon(double epsilon) {
        BinaryRelations.setEpsilon(epsilon);
    }

    public static void setDefaultEpsilon() {
        BinaryRelations.setDefaultEpsilon();
    }

    public static double getEpsilon() {
        return BinaryRelations.getEpsilon();
    }

    public static boolean checkIfEpsilonMode() {
        return BinaryRelations.checkIfEpsilonMode();
    }

    public static boolean checkIfExactMode() {
        return BinaryRelations.checkIfExactMode();
    }

    public static void enableUlpRounding() {
        ulpRounding = true;
    }

    public static void disableUlpRounding() {
        ulpRounding = false;
    }

    public static void setUlpRounding(boolean ulpRoundingState) {
        ulpRounding = ulpRoundingState;
    }

    public static boolean checkIfUlpRounding() {
        return ulpRounding;
    }

    public static void enableCanonicalRounding() {
        canonicalRounding = true;
    }

    public static void disableCanonicalRounding() {
        canonicalRounding = false;
    }

    public static void setCanonicalRounding(boolean canonicalRoundingState) {
        canonicalRounding = canonicalRoundingState;
    }

    public static boolean checkIfCanonicalRounding() {
        return canonicalRounding;
    }

    public static void enableAlmostIntRounding() {
        almostIntRounding = true;
    }

    public static void disableAlmostIntRounding() {
        almostIntRounding = false;
    }

    public static void setAlmostIntRounding(boolean almostIntRoundingState) {
        almostIntRounding = almostIntRoundingState;
    }

    public static boolean checkIfAlmostIntRounding() {
        return almostIntRounding;
    }

    public static void setMaxAllowedRecursionDepth(int maxAllowedRecursionDepth) {
        MAX_RECURSION_CALLS = maxAllowedRecursionDepth;
        Argument.refreshMaxAllowedRecursionDepth();
    }

    public static int getMaxAllowedRecursionDepth() {
        return MAX_RECURSION_CALLS;
    }

    public static void setRadiansMode() {
        degreesMode = false;
    }

    public static void setDegreesMode() {
        degreesMode = true;
    }

    public static boolean checkIfRadiansMode() {
        return !degreesMode;
    }

    public static boolean checkIfDegreesMode() {
        return degreesMode;
    }

    public static void enableImpliedMultiplicationMode() {
        impliedMultiplicationMode = true;
        HELP_EXPRESSION.enableImpliedMultiplicationMode();
    }

    public static void disableImpliedMultiplicationMode() {
        impliedMultiplicationMode = false;
        HELP_EXPRESSION.disableImpliedMultiplicationMode();
    }

    public static boolean checkIfImpliedMultiplicationMode() {
        return impliedMultiplicationMode;
    }

    public static void enableUnicodeBuiltinKeyWordsMode() {
        unicodeKeyWordsEnabled = true;
        HELP_EXPRESSION.enableUnicodeBuiltinKeyWordsMode();
    }

    public static void disableUnicodeBuiltinKeyWordsMode() {
        unicodeKeyWordsEnabled = false;
        HELP_EXPRESSION.disableUnicodeBuiltinKeyWordsMode();
    }

    public static boolean checkIfUnicodeBuiltinKeyWordsMode() {
        return unicodeKeyWordsEnabled;
    }

    public static void enableAttemptToFixExpStrMode() {
        attemptToFixExpStrEnabled = true;
    }

    public static void disableAttemptToFixExpStrMode() {
        attemptToFixExpStrEnabled = false;
    }

    public static boolean checkIfAttemptToFixExpStrMode() {
        return attemptToFixExpStrEnabled;
    }

    public static void setToFractionInitSearchSize(long n) {
        NumberTheory.setToFractionInitSearchSize(n);
    }

    public static long getToFractionInitSearchSize() {
        return NumberTheory.getToFractionInitSearchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBuiltinTokens(String ... tokens) {
        if (tokens == null) {
            return;
        }
        List<String> list = tokensToRemove;
        synchronized (list) {
            for (String token : tokens) {
                if (token == null || token.length() <= 0 || tokensToRemove.contains(token)) continue;
                tokensToRemove.add(token);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unremoveBuiltinTokens(String ... tokens) {
        if (tokens == null) {
            return;
        }
        if (tokens.length == 0) {
            return;
        }
        if (tokensToRemove.size() == 0) {
            return;
        }
        List<String> list = tokensToRemove;
        synchronized (list) {
            for (String token : tokens) {
                if (token == null) continue;
                tokensToRemove.remove(token);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unremoveAllBuiltinTokens() {
        List<String> list = tokensToRemove;
        synchronized (list) {
            tokensToRemove.clear();
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getBuiltinTokensToRemove() {
        List<String> list = tokensToRemove;
        synchronized (list) {
            int tokensNum = tokensToRemove.size();
            String[] tokensToRemoveArray = new String[tokensNum];
            for (int i = 0; i < tokensNum; ++i) {
                tokensToRemoveArray[i] = tokensToRemove.get(i);
            }
            return tokensToRemoveArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyBuiltinToken(String currentToken, String newToken) {
        if (currentToken == null) {
            return;
        }
        if (currentToken.length() == 0) {
            return;
        }
        if (newToken == null) {
            return;
        }
        if (newToken.length() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            for (TokenModification tm : tokensToModify) {
                if (!tm.currentToken.equals(currentToken)) continue;
                return;
            }
            TokenModification tma = new TokenModification();
            tma.currentToken = currentToken;
            tma.newToken = newToken;
            tma.newTokenDescription = null;
            tokensToModify.add(tma);
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyBuiltinToken(String currentToken, String newToken, String newTokenDescription) {
        if (currentToken == null) {
            return;
        }
        if (currentToken.length() == 0) {
            return;
        }
        if (newToken == null) {
            return;
        }
        if (newToken.length() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            for (TokenModification tm : tokensToModify) {
                if (!tm.currentToken.equals(currentToken)) continue;
                return;
            }
            TokenModification tma = new TokenModification();
            tma.currentToken = currentToken;
            tma.newToken = newToken;
            tma.newTokenDescription = newTokenDescription;
            tokensToModify.add(tma);
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmodifyBuiltinTokens(String ... currentOrNewTokens) {
        if (currentOrNewTokens == null) {
            return;
        }
        if (currentOrNewTokens.length == 0) {
            return;
        }
        if (tokensToModify.size() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            ArrayList<TokenModification> toRemove = new ArrayList<TokenModification>();
            for (String token : currentOrNewTokens) {
                if (token == null || token.length() <= 0) continue;
                for (TokenModification tm : tokensToModify) {
                    if (!token.equals(tm.currentToken) && !token.equals(tm.newToken)) continue;
                    toRemove.add(tm);
                }
            }
            for (TokenModification tm : toRemove) {
                tokensToModify.remove(tm);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmodifyAllBuiltinTokens() {
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            tokensToModify.clear();
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] getBuiltinTokensToModify() {
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            int tokensNum = tokensToModify.size();
            String[][] tokensToModifyArray = new String[tokensNum][3];
            for (int i = 0; i < tokensNum; ++i) {
                TokenModification tm = tokensToModify.get(i);
                tokensToModifyArray[i][0] = tm.currentToken;
                tokensToModifyArray[i][1] = tm.newToken;
                tokensToModifyArray[i][2] = tm.newTokenDescription;
            }
            return tokensToModifyArray;
        }
    }

    public static synchronized void setToOverrideBuiltinTokens() {
        overrideBuiltinTokens = true;
        ++optionsChangesetNumber;
    }

    public static synchronized void setNotToOverrideBuiltinTokens() {
        overrideBuiltinTokens = false;
        ++optionsChangesetNumber;
    }

    public static boolean checkIfsetToOverrideBuiltinTokens() {
        return overrideBuiltinTokens;
    }

    public static synchronized void setDefaultOptions() {
        mXparser.enableUlpRounding();
        mXparser.enableAlmostIntRounding();
        mXparser.setMaxAllowedRecursionDepth(200);
        mXparser.setNotToOverrideBuiltinTokens();
        mXparser.unmodifyAllBuiltinTokens();
        mXparser.setRadiansMode();
        mXparser.resetCancelCurrentCalculationFlag();
        mXparser.setDefaultEpsilon();
        mXparser.setEpsilonComparison();
        mXparser.setToFractionInitSearchSize(10000L);
        mXparser.enableImpliedMultiplicationMode();
        mXparser.enableUnicodeBuiltinKeyWordsMode();
        mXparser.enableAttemptToFixExpStrMode();
        ++optionsChangesetNumber;
    }

    @Deprecated
    public static String getTokenTypeDescription(int tokenTypeId) {
        return Token.getTokenTypeDescription(tokenTypeId);
    }

    @Deprecated
    public static String numberToHexString(int number) {
        return StringUtils.numberToHexString(number);
    }

    @Deprecated
    public static String numberToHexString(long number) {
        return StringUtils.numberToHexString(number);
    }

    @Deprecated
    public static String numberToHexString(double number) {
        return StringUtils.numberToHexString(number);
    }

    @Deprecated
    public static String hexString2AsciiString(String hexString) {
        return StringUtils.hexString2AsciiString(hexString);
    }

    @Deprecated
    public static String numberToAsciiString(int number) {
        return StringUtils.numberToAsciiString(number);
    }

    @Deprecated
    public static String numberToAsciiString(long number) {
        return StringUtils.numberToAsciiString(number);
    }

    @Deprecated
    public static String numberToAsciiString(double number) {
        return StringUtils.numberToAsciiString(number);
    }

    public static double convOthBase2Decimal(String numberLiteral, int numeralSystemBase) {
        return NumberTheory.convOthBase2Decimal(numberLiteral, numeralSystemBase);
    }

    public static double convOthBase2Decimal(String numberLiteral) {
        return NumberTheory.convOthBase2Decimal(numberLiteral);
    }

    public static double convOthBase2Decimal(int numeralSystemBase, int ... digits) {
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static double convOthBase2Decimal(double numeralSystemBase, double ... digits) {
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static String convDecimal2OthBase(double decimalNumber, int numeralSystemBase) {
        return NumberTheory.convDecimal2OthBase(decimalNumber, numeralSystemBase);
    }

    public static String convDecimal2OthBase(double decimalNumber, int numeralSystemBase, int format) {
        return NumberTheory.convDecimal2OthBase(decimalNumber, numeralSystemBase, format);
    }

    public static double[] toFraction(double value) {
        return NumberTheory.toFraction(value);
    }

    public static double[] toMixedFraction(double value) {
        return NumberTheory.toMixedFraction(value);
    }

    public static String fractionToString(double[] fraction) {
        return NumberTheory.fractionToString(fraction);
    }

    public static String toFractionString(double value) {
        return NumberTheory.toFractionString(value);
    }

    public static String toMixedFractionString(double value) {
        return NumberTheory.toMixedFractionString(value);
    }

    private static void initConsoleOutput() {
        if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.length() == 0) {
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT.setLength(0);
            CONSOLE_OUTPUT.append(CONSOLE_OUTPUT_PREFIX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolePrintln(Object o) {
        StringBuilder stringBuilder = CONSOLE_OUTPUT;
        synchronized (stringBuilder) {
            mXparser.initConsoleOutput();
            System.out.println(o);
            ++CONSOLE_ROW_NUMBER;
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT.append(o);
            CONSOLE_OUTPUT.append(StringInvariant.NEW_LINE);
            CONSOLE_OUTPUT.append(CONSOLE_OUTPUT_PREFIX);
        }
    }

    public static void consolePrintln(String[] stringArray) {
        if (stringArray == null) {
            mXparser.consolePrintln("null");
            return;
        }
        for (String s : stringArray) {
            mXparser.consolePrintln(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolePrintln() {
        StringBuilder stringBuilder = CONSOLE_OUTPUT;
        synchronized (stringBuilder) {
            mXparser.initConsoleOutput();
            System.out.println();
            ++CONSOLE_ROW_NUMBER;
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT.append(StringInvariant.NEW_LINE);
            CONSOLE_OUTPUT.append(CONSOLE_OUTPUT_PREFIX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolePrint(Object o) {
        StringBuilder stringBuilder = CONSOLE_OUTPUT;
        synchronized (stringBuilder) {
            mXparser.initConsoleOutput();
            System.out.print(o);
            CONSOLE_OUTPUT.append(o);
        }
    }

    public static void consolePrintSettings(String prefix) {
        mXparser.consolePrintln(prefix + "mXparser.VERSION = " + VERSION);
        mXparser.consolePrintln(prefix + "mXparser.BUIT_FOR = " + BUIT_FOR);
        mXparser.consolePrintln(prefix + "java.version = " + System.getProperty("java.version"));
        mXparser.consolePrintln(prefix + "checkIfCanonicalRounding = " + mXparser.checkIfCanonicalRounding());
        mXparser.consolePrintln(prefix + "checkIfAlmostIntRounding = " + mXparser.checkIfAlmostIntRounding());
        mXparser.consolePrintln(prefix + "checkIfUlpRounding = " + mXparser.checkIfUlpRounding());
        mXparser.consolePrintln(prefix + "checkIfRadiansMode = " + mXparser.checkIfRadiansMode());
        mXparser.consolePrintln(prefix + "checkIfDegreesMode = " + mXparser.checkIfDegreesMode());
        mXparser.consolePrintln(prefix + "checkIfExactMode = " + mXparser.checkIfExactMode());
        mXparser.consolePrintln(prefix + "checkIfEpsilonMode = " + mXparser.checkIfEpsilonMode());
        mXparser.consolePrintln(prefix + "getEpsilon = " + mXparser.getEpsilon());
        mXparser.consolePrintln(prefix + "getMaxAllowedRecursionDepth = " + mXparser.getMaxAllowedRecursionDepth());
        mXparser.consolePrintln(prefix + "getMaxNumInPrimesCache = " + mXparser.getMaxNumInPrimesCache());
        mXparser.consolePrintln(prefix + "getToFractionInitSearchSize = " + mXparser.getToFractionInitSearchSize());
        mXparser.consolePrintln(prefix + "checkIfsetToOverrideBuiltinTokens = " + mXparser.checkIfsetToOverrideBuiltinTokens());
        mXparser.consolePrintln(prefix + "Java version = " + System.getProperty("java.version"));
    }

    public static void consolePrintSettings() {
        mXparser.consolePrintSettings("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConsoleOutput() {
        StringBuilder stringBuilder = CONSOLE_OUTPUT;
        synchronized (stringBuilder) {
            CONSOLE_OUTPUT.setLength(0);
            CONSOLE_ROW_NUMBER = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConsolePrefix() {
        String string = CONSOLE_PREFIX;
        synchronized (string) {
            CONSOLE_PREFIX = "[mXparser-v.5.2.0] ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConsoleOutputPrefix() {
        String string = CONSOLE_OUTPUT_PREFIX;
        synchronized (string) {
            CONSOLE_OUTPUT_PREFIX = "[mXparser-v.5.2.0] ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConsolePrefix(String consolePrefix) {
        String string = CONSOLE_PREFIX;
        synchronized (string) {
            CONSOLE_PREFIX = consolePrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConsoleOutputPrefix(String consoleOutputPrefix) {
        String string = CONSOLE_OUTPUT_PREFIX;
        synchronized (string) {
            CONSOLE_OUTPUT_PREFIX = consoleOutputPrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConsoleOutput() {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return CONSOLE_OUTPUT.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelp() {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelp(String query) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelp(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelp(boolean addHeader, boolean addCaption, String caption) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelp(addHeader, addCaption, caption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelp(String query, boolean addHeader, boolean addCaption, String caption) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelp(query, addHeader, addCaption, caption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsCsv() {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsCsv();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsCsv(String query) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsCsv(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsCsv(String quote, String delimiter, boolean addHeader) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsCsv(quote, delimiter, addHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsCsv(String query, String quote, String delimiter, boolean addHeader) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsCsv(query, quote, delimiter, addHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsHtmlTable() {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsHtmlTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsHtmlTable(String query) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsHtmlTable(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsHtmlTable(boolean addHeader, boolean addCaption, boolean addFigure, String caption, String cssClass) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsHtmlTable(addHeader, addCaption, addFigure, caption, cssClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsHtmlTable(String query, boolean addHeader, boolean addCaption, boolean addFigure, String caption, String cssClass) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsHtmlTable(query, addHeader, addCaption, addFigure, caption, cssClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsMarkdownTable() {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsMarkdownTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsMarkdownTable(String query) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsMarkdownTable(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsMarkdownTable(boolean addHeader, boolean addCaption, String caption) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsMarkdownTable(addHeader, addCaption, caption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsMarkdownTable(String query, boolean addHeader, boolean addCaption, String caption) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsMarkdownTable(query, addHeader, addCaption, caption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsJson() {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsJson();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsJson(String query) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsJson(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsJson(boolean addCaption, String caption) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsJson(addCaption, caption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpAsJson(String query, boolean addCaption, String caption) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getHelpAsJson(query, addCaption, caption);
        }
    }

    public static void consolePrintHelp() {
        mXparser.consolePrintln(mXparser.getHelp());
    }

    public static void consolePrintHelp(String query) {
        mXparser.consolePrintln(mXparser.getHelp(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyWord> getKeyWords() {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getKeyWords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyWord> getKeyWords(String query) {
        Expression expression = HELP_EXPRESSION;
        synchronized (expression) {
            return HELP_EXPRESSION.getKeyWords(query);
        }
    }

    @Deprecated
    public static boolean regexMatch(String str, String pattern) {
        return StringUtils.regexMatch(str, pattern);
    }

    public static void consolePrintTokens(List<Token> tokens) {
        Expression.showTokens(tokens);
    }

    public static void consolePrint(List<Token> tokens) {
        mXparser.consolePrintTokens(tokens);
    }

    public static void consolePrintln(List<Token> tokens) {
        mXparser.consolePrintTokens(tokens);
        mXparser.consolePrintln();
    }

    public static void consolePrintLicense() {
        License.consolePrintLicense();
    }

    public static String getLicense() {
        return LICENSE;
    }

    public static void wait(int timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cancelCurrentCalculation() {
        cancelCurrentCalculationFlag = true;
    }

    public static void resetCancelCurrentCalculationFlag() {
        cancelCurrentCalculationFlag = false;
    }

    public static boolean isCurrentCalculationCancelled() {
        return cancelCurrentCalculationFlag;
    }

    static {
        CONSOLE_OUTPUT_PREFIX = CONSOLE_PREFIX = "[mXparser-v.5.2.0] ";
        CONSOLE_ROW_NUMBER = 1;
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
        ulpRounding = false;
        canonicalRounding = true;
        almostIntRounding = true;
        MAX_RECURSION_CALLS = 200;
        ERROR_MESSAGE_MAXIMUM_LENGTH = 10000;
        ERROR_MESSAGE_MAXIMUM_NUMBER_OF_EXPECTED_TOKENS = 5;
        tokensToRemove = new ArrayList<String>();
        tokensToModify = new ArrayList<TokenModification>();
        degreesMode = false;
        overrideBuiltinTokens = false;
        impliedMultiplicationMode = true;
        unicodeKeyWordsEnabled = true;
        attemptToFixExpStrEnabled = true;
        optionsChangesetNumber = 0;
        cancelCurrentCalculationFlag = false;
        HELP_EXPRESSION = new Expression(new PrimitiveElement[0]);
    }
}

