/*
 * @(#)StringResources.java        6.0.0    2024-05-19
 *
 * MathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19
 * The most up-to-date license is available at the below link:
 * - https://mathparser.org/mxparser-license
 *
 * AUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved
 * PUBLISHER: INFIMA - https://payhip.com/infima
 *
 * SOFTWARE means source code and/or binary form and/or documentation.
 * PRODUCT: MathParser.org-mXparser SOFTWARE
 * LICENSE: DUAL LICENSE AGREEMENT
 *
 * BY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE
 * BOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.
 *
 * The AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT
 * model designed to meet the needs of both non-commercial use and commercial
 * use.
 *
 * NON-COMMERCIAL USE means any use or activity where a fee is not charged
 * and the purpose is not the sale of a good or service, and the use or
 * activity is not intended to produce a profit. Examples of NON-COMMERCIAL USE
 * include:
 *
 * 1. Non-commercial open-source software.
 * 2. Non-commercial mobile applications.
 * 3. Non-commercial desktop software.
 * 4. Non-commercial web applications/solutions.
 * 5. Non-commercial use in research, scholarly and educational context.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * COMMERCIAL USE means any use or activity where a fee is charged or the
 * purpose is the sale of a good or service, or the use or activity is
 * intended to produce a profit. COMMERCIAL USE examples:
 *
 * 1. OEMs (Original Equipment Manufacturers).
 * 2. ISVs (Independent Software Vendors).
 * 3. VARs (Value Added Resellers).
 * 4. Other distributors that combine and distribute commercially licensed
 *    software.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * IN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE
 * APPROPRIATE LICENSE FROM "INFIMA" ONLINE STORE, STORE ADDRESS:
 *
 * 1. https://mathparser.org/order-commercial-license
 * 2. https://payhip.com/infima
 *
 * NON-COMMERCIAL LICENSE
 *
 * Redistribution and use of the PRODUCT in source and/or binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the unmodified content of
 *    the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including
 *    the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,
 *    the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 2. Redistributions in binary form must reproduce the entire content of
 *    MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation
 *    and/or other materials provided with the distribution, including the
 *    definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the
 *    NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 3. Any form of redistribution requires confirmation and signature of
 *    the NON-COMMERCIAL USE by successfully calling the method:
 *       License.iConfirmNonCommercialUse(...)
 *    The method call is used only internally for logging purposes, and
 *    there is no connection with other external services, and no data is
 *    sent or collected. The lack of a method call (or its successful call)
 *    does not affect the operation of the PRODUCT in any way. Please see
 *    the API documentation.
 *
 * COMMERCIAL LICENSE
 *
 *  1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow
 *     you to download, install, and use up to three copies of the PRODUCT to
 *     perform integration tests, confirm the quality of the PRODUCT, and
 *     its suitability. The testing period should be limited to fourteen
 *     days. Tests should be performed under the test environments conditions
 *     and not for profit generation.
 *  2. Provided that you purchased a license from "INFIMA" online store
 *     (store address: https://mathparser.org/order-commercial-license or
 *     https://payhip.com/infima), and you comply with all terms and
 *     conditions below, and you have acknowledged and understood the
 *     following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive
 *     license with the following rights:
 *  3. The license is granted only to you, the person or entity that made
 *     the purchase, identified and confirmed by the data provided during
 *     the purchase.
 *  4. If you purchased a license in the "ONE-TIME PURCHASE" model, the
 *     license is granted only for the PRODUCT version specified in the
 *     purchase. The upgrade policy gives you additional rights, described
 *     in the dedicated section below.
 *  5. If you purchased a license in the "SUBSCRIPTION" model, you may
 *     install and use any version of the PRODUCT during the subscription
 *     validity period.
 *  6. If you purchased a "SINGLE LICENSE" you may install and use the
 *     PRODUCT on/from one workstation that is located/accessible at/from
 *     any of your premises.
 *  7. Additional copies of the PRODUCT may be installed and used on/from
 *     more than one workstation, limited to the number of workstations
 *     purchased per order.
 *  8. If you purchased a "SITE LICENSE", the PRODUCT may be installed
 *     and used on/from all workstations located/accessible at/from any
 *     of your premises.
 *  9. You may incorporate the unmodified PRODUCT into your own products
 *     and software.
 * 10. If you purchased a license with the "SOURCE CODE" option, you may
 *     modify the PRODUCT's source code and incorporate the modified source
 *     code into your own products and/or software.
 * 11. Provided that the license validity period has not expired, you may
 *     distribute your product and/or software with the incorporated
 *     PRODUCT royalty-free.
 * 12. You may make copies of the PRODUCT for backup and archival purposes.
 * 13. Any form of redistribution requires confirmation and signature of
 *     the COMMERCIAL USE by successfully calling the method:
 *        License.iConfirmCommercialUse(...)
 *     The method call is used only internally for logging purposes, and
 *     there is no connection with other external services, and no data is
 *     sent or collected. The lack of a method call (or its successful call)
 *     does not affect the operation of the PRODUCT in any way. Please see
 *     the API documentation.
 * 14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to
 *     you in this agreement.
 *
 * ADDITIONAL CLARIFICATION ON WORKSTATION
 *
 * A workstation is a device, a remote device, or a virtual device, used by
 * you, your employees, or other entities to whom you have commissioned
 * tasks. For example, the number of workstations may refer to the number
 * of software developers, engineers, architects, scientists, and other
 * professionals who use the PRODUCT on your behalf. The number of
 * workstations is not the number of copies of your end-product that you
 * distribute to your end-users.
 *
 * By purchasing the COMMERCIAL LICENSE, you only pay for the number of
 * workstations, while the number of copies/users of your final product
 * (delivered to your end-users) is not limited.
 *
 * Below are some examples to help you select the right license size:
 *
 * Example 1: Single Workstation License
 * Only one developer works on the development of your application. You do
 * not use separate environments for testing, meaning you design, create,
 * test, and compile your final application on one environment. In this
 * case, you need a license for a single workstation.
 *
 * Example 2: Up to 5 Workstations License
 * Two developers are working on the development of your application.
 * Additionally, one tester conducts tests in a separate environment.
 * You use three workstations in total, so you need a license for up to
 * five workstations.
 *
 * Example 3: Up to 20 Workstations License
 * Ten developers are working on the development of your application.
 * Additionally, five testers conduct tests in separate environments.
 * You use fifteen workstations in total, so you need a license for
 * up to twenty workstations.
 *
 * Example 4: Site License
 * Several dozen developers and testers work on the development of your
 * application using multiple environments. You have a large,
 * multi-disciplinary team involved in creating your solution. As your team
 * is growing and you want to avoid licensing limitations, the best choice
 * would be a site license.
 *
 * UPGRADE POLICY
 *
 * The PRODUCT is versioned according to the following convention:
 *
 *    [MAJOR].[MINOR].[PATCH]
 *
 * 1. COMMERCIAL LICENSE holders can install and use the updated version
 *    for bug fixes free of charge, i.e. if you have purchased a license
 *    for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install
 *    all releases specified in the [PATCH] version (e.g., 5.0.2).
 *    The license terms remain unchanged after the update.
 * 2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)
 *    can install and use the updated version [MAJOR].[MINOR + 1] free of
 *    charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The
 *    license terms remain unchanged after the update.
 * 3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are
 *    not eligible for the free upgrade, can claim a discount when
 *    purchasing the upgrade. For this purpose, please contact us via e-mail.
 *
 * DISCLAIMER
 *
 * THIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE
 * THOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING
 * OFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.
 *
 * CONTACT
 *
 * - e-mail: info@mathparser.org
 * - website: https://mathparser.org
 * - source code: https://github.com/mariuszgromada/MathParser.org-mXparser
 * - online store: https://mathparser.org/order-commercial-license
 * - online store: https://payhip.com/infima
 */
package org.mariuszgromada.math.mxparser;

import java.util.Locale;

/**
 * A class containing definition of user (interface) language.
 * List of available languages:
 * English, French, German, Italian, Polish, Portuguese, Spanish.
 *
 * Class also allows a new user language definition - for instance
 * user defined translation. Translation can be done via extending
 * this class.
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="https://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="https://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser on GitHub</a><br>
 *                 <a href="https://payhip.com/INFIMA" target="_blank">INFIMA place to purchase a commercial MathParser.org-mXparser software license</a><br>
 *                 <a href="mailto:info@mathparser.org">info@mathparser.org</a><br>
 *                 <a href="https://scalarmath.org/" target="_blank">ScalarMath.org - a powerful math engine and math scripting language</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.lite" target="_blank">Scalar Lite</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.pro" target="_blank">Scalar Pro</a><br>
 *                 <a href="https://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *
 * @version        6.0.0
 *
 * @see StringModel
 * @see StringModel#setStringResources(StringResources)
 * @see StringModel#getStringResources()
 */
public class StringResources {
    /**
     * Default translations, currently English
     *
     * @return Returns a  new instance of StringResources object
     * containing Default translations, currently English.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languageDefault() { return new StringResources(); }
    /**
     * English translations
     *
     * @return Returns a  new instance of StringResources object
     * containing English translations.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languageEnglish() { return new StringResources(); }
    /**
     * French translations
     *
     * @return Returns a  new instance of StringResources object
     * containing French translations.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languageFrench() { return new StringResourcesFrench(); }
    /**
     * German translations
     *
     * @return Returns a  new instance of StringResources object
     * containing German translations.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languageGerman() { return new StringResourcesGerman(); }
    /**
     * Italian translations
     *
     * @return Returns a  new instance of StringResources object
     * containing Italian translations.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languageItalian() { return new StringResourcesItalian(); }
    /**
     * Polish translations
     *
     * @return Returns a  new instance of StringResources object
     * containing Polish translations.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languagePolish() { return new StringResourcesPolish(); }
    /**
     * Portuguese translations
     *
     * @return Returns a  new instance of StringResources object
     * containing Portuguese translations.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languagePortuguese() { return new StringResourcesPortuguese(); }
    /**
     * Spanish translations
     *
     * @return Returns a  new instance of StringResources object
     * containing Spanish translations.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources languageSpanish() { return new StringResourcesSpanish(); }

    /**
     * Returns translation that best matches to provided language code.
     * Supported languages: English, French, German, Italian, Polish, Portuguese, Spanish.
     *
     * @param language     Supported language codes: en, fr, de, it, pl, pt, es.
     * @return             Returns translation that matches the language code.
     *                     If language code does not belong to the supported language codes
     *                     English translation is returned.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources bestMatchingLanguage(String language) {
        if (language.equals("en")) return languageEnglish();
        if (language.equals("fr")) return languageFrench();
        if (language.equals("de")) return languageGerman();
        if (language.equals("it")) return languageItalian();
        if (language.equals("pl")) return languagePolish();
        if (language.equals("pt")) return languagePortuguese();
        if (language.equals("es")) return languageSpanish();
        return StringResources.languageEnglish(); // Default to English if no match is found
    }

    /**
     * Returns translation that best matches to provided locale.
     * Supported languages: English, French, German, Italian, Polish, Portuguese, Spanish.
     *
     * @param locale    Supported locale language codes: en, fr, de, it, pl, pt, es.
     * @return          Returns translation that matches the language code in locale.
     *                  If language code does not belong to the supported languages
     *                  English translation is returned.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources bestMatchingLanguage(Locale locale) {
        String lang = locale.getLanguage();
        return bestMatchingLanguage(lang);
    }

    /**
     * Returns translation that best matches to the current system locale.
     * Supported languages: English, French, German, Italian, Polish, Portuguese, Spanish.
     *
     * @return          Returns translation that matches the language code in locale.
     *                  If language code does not belong to the supported languages
     *                  English translation is returned.
     *
     * @see StringModel
     * @see StringModel#setStringResources(StringResources)
     * @see StringModel#setDefaultStringResources()
     */
    public static StringResources bestMatchingLanguage() {
        return bestMatchingLanguage(Locale.getDefault());
    }

    static final String DEFAULT_USER_LANGUAGE = "English";
    // -------------------------------------------------
    static final String DEFAULT_STARTING_SYNTAX_CHECK = "Starting syntax check...";
    static final String DEFAULT_NO_ERRORS_DETECTED = "No errors detected.";
    static final String DEFAULT_NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = "No errors detected in argument definition.";
    static final String DEFAULT_NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = "No errors detected in recursive argument definition.";
    static final String DEFAULT_NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = "No errors detected in function definition.";
    static final String DEFAULT_NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = "No errors detected in constant definition.";
    static final String DEFAULT_LEXICAL_ERROR_HAS_BEEN_FOUND = "A lexical error has been found.";
    static final String DEFAULT_ERRORS_HAVE_BEEN_FOUND = "Errors have been found.";
    static final String DEFAULT_ALREADY_CHECKED_NO_ERRORS = "The syntax has already been checked - no errors detected.";
    static final String DEFAULT_SYNTAX_STATUS_UNKNOWN = "The syntax status is unknown.";
    static final String DEFAULT_PROBLEM_WITH_EXPRESSION_SYNTAX = "There is a problem with expression syntax.";
    // -------------------------------------------------
    static final String DEFAULT_ENCOUNTERED = "Encountered";
    static final String DEFAULT_AT_INDEX = "at index";
    static final String DEFAULT_WAS_EXPECTING = "Was expecting";
    static final String DEFAULT_WAS_EXPECTING_ONE_OF = "Was expecting one of";
    static final String DEFAULT_UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = "An unexpected exception was encountered. Probably a parser error - please report it.";
    static final String DEFAULT_UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = "An unexpected token manager error was encountered. Probably a parser error - please report it.";
    // -------------------------------------------------
    static final String DEFAULT_EXPRESSION_STRING_IS_EMPTY = "The expression string is empty.";
    static final String DEFAULT_EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = "The expression does not contain any tokens.";
    static final String DEFAULT_DUPLICATED_KEYWORD = "Duplicated keywords were found. Check user-defined items. Consider using option to override built-in tokens.";
    static final String DEFAULT_ELEMENT = "Element";
    static final String DEFAULT_ERROR = "Error";
    static final String DEFAULT_EXCEPTION = "Exception";
    static final String DEFAULT_TOKEN = "Token";
    static final String DEFAULT_INDEX = "index";
    static final String DEFAULT_INVALID_TOKEN = "Invalid token.";
    static final String DEFAULT_INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = "Invalid token. Possibly missing multiplication operator - try implied multiplication mode.";
    static final String DEFAULT_EXPRESSION_TOKENS = "Expression tokens";
    static final String DEFAULT_NULL_TOKENS_LIST = "NULL tokens list";
    // -------------------------------------------------
    static final String DEFAULT_FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = "User-defined function with extended body - no errors by assumption.";
    static final String DEFAULT_ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = "User-defined argument with extended body - no errors by assumption.";
    static final String DEFAULT_PROVIDED_EXTENSION_IS_NULL = "Provided extension is null.";
    static final String DEFAULT_PROVIDED_STRING_IS_NULL = "Provided string is null.";
    static final String DEFAULT_PROVIDED_ELEMENTS_ARE_NULL = "Provided elements are null.";
    static final String DEFAULT_MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = "Possibly missing multiplication operator - try implied multiplication mode.";
    // -------------------------------------------------
    static final String DEFAULT_STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = "Starting syntax check of the dependent user-defined argument.";
    static final String DEFAULT_STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = "Starting syntax check of the user-defined recursive argument.";
    static final String DEFAULT_STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = "Starting syntax check of the user-defined function.";
    static final String DEFAULT_STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = "Starting syntax check of the variadic user-defined function.";
    // -------------------------------------------------
    static final String DEFAULT_ARGUMENT_WAS_EXPECTED = "User-defined argument was expected.";
    static final String DEFAULT_RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = "A recursive user-defined argument requires one parameter.";
    // -------------------------------------------------
    static final String DEFAULT_INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = "Incorrect number of parameters in user-defined function.";
    // -------------------------------------------------
    static final String DEFAULT_INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = "Incorrect number of function parameters.";
    static final String DEFAULT_EXPECTED = "Expected";
    static final String DEFAULT_PROVIDED = "provided";
    static final String DEFAULT_USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = "Incorrect number of parameters in user-defined function - at least one argument is expected.";
    static final String DEFAULT_EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = "Even number of arguments was expected.";
    // -------------------------------------------------
    static final String DEFAULT_INVALID_FUNCTION_NAME = "Invalid function name.";
    static final String DEFAULT_INVALID_ARGUMENT_NAME = "Invalid argument name.";
    static final String DEFAULT_INVALID_CONSTANT_NAME = "Invalid constant name.";
    static final String DEFAULT_INVALID_FUNCTION_DEFINITION = "Invalid function definition.";
    static final String DEFAULT_INVALID_ARGUMENT_DEFINITION = "Invalid argument definition.";
    static final String DEFAULT_INVALID_CONSTANT_DEFINITION = "Invalid constant definition.";
    static final String DEFAULT_PATTERN_DOES_NOT_MATCH = "Pattern does not match.";
    static final String DEFAULT_PATTERN_EXAMPLES = "Pattern examples";
    // -------------------------------------------------
    static final String DEFAULT_CONSTANT_WAS_EXPECTED = "Constant value was expected.";
    static final String DEFAULT_USER_CONSTANT_WAS_EXPECTED = "User-defined constant was expected.";
    // -------------------------------------------------
    static final String DEFAULT_UNARY_FUNCTION_EXPECTS_1_PARAMETER = "A unary function expects 1 parameter.";
    static final String DEFAULT_BINARY_FUNCTION_EXPECTS_2_PARAMETERS = "A binary function expects 2 parameters.";
    static final String DEFAULT_TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = "A ternary function expects 3 parameters.";
    // -------------------------------------------------
    static final String DEFAULT_DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = "A derivative operator expects 2 or 3 or 4 or 5 calculus parameters.";
    static final String DEFAULT_ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = "An argument was expected in a derivative operator invocation.";
    static final String DEFAULT_DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Duplicated keywords were found in the calculus operator invocation, check calculus parameters.";
    static final String DEFAULT_ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = "One token (argument or unknown) was expected in the calculus operator invocation.";
    static final String DEFAULT_NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = "N-th order derivative operator expects 3 or 5 calculus parameters.";
    static final String DEFAULT_INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = "The integral / solve operator expects 4 calculus parameters.";
    static final String DEFAULT_ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = "The iterated operator expects 4 or 5 calculus parameters.";
    static final String DEFAULT_FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = "The forward / backward difference operator expects 2 or 3 calculus parameters.";
    static final String DEFAULT_FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = "An argument was expected in the forward / backward difference operator invocation.";
    static final String DEFAULT_AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = "At least one argument was expected.";
    // -------------------------------------------------
    static final String DEFAULT_ERROR_WHILE_EXECUTING_THE_CALCULATE = "Error while executing the calculate.";
    static final String DEFAULT_RECURSION_CALLS_COUNTER_EXCEEDED = "Recursion calls counter exceeded maximum calls allowed.";
    static final String DEFAULT_RECURSION_CALLS_COUNTER = "Recursion calls counter";
    static final String DEFAULT_STARTING_CALCULATION_LOOP = "Starting calculation loop.";
    static final String DEFAULT_CANCEL_REQUEST_FINISHING = "Cancel request encountered - finishing.";
    static final String DEFAULT_INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = "Internal error / strange token level - finishing. Probably a parser error - please report it.";
    static final String DEFAULT_FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = "Fatal error, do not know what to do with the encountered token. Probably a parser error - please report it.";
    static final String DEFAULT_MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = "The maximum error message length has been exceeded.";
    // -------------------------------------------------
    static final String DEFAULT_STARTING = "Starting...";
    static final String DEFAULT_PARSING = "Parsing";
    static final String DEFAULT_FULLY_COMPILED = "Fully compiled";
    static final String DEFAULT_CALCULATED_VALUE = "Calculated value";
    static final String DEFAULT_EXITING = "Exiting.";
    static final String DEFAULT_DONE = "done.";
    // -------------------------------------------------
    static final String DEFAULT_KEYWORD = "Keyword";
    static final String DEFAULT_SYNTAX = "Syntax";
    static final String DEFAULT_NUMBER = "Number";
    static final String DEFAULT_NUMBER_LITERAL = "Number literal";
    static final String DEFAULT_TYPE = "Type";
    static final String DEFAULT_SINCE = "Since";
    static final String DEFAULT_DESCRIPTION = "Description";
    // -------------------------------------------------
    static final String DEFAULT_CALC_STEPS_REGISTER_IS_EMPTY = "CalcStepsRegister is empty";
    static final String DEFAULT_CALC_STEPS_REGISTER_FOR = "CalcStepsRegister for";
    static final String DEFAULT_ARGUMENT = "Argument";
    static final String DEFAULT_FUNCTION = "Function";
    static final String DEFAULT_EXPRESSION = "Expression";
    static final String DEFAULT_RESULT = "result";
    static final String DEFAULT_COMPUTING_TIME = "Computing time";
    static final String DEFAULT_GROUP_SHORT = "gr";
    static final String DEFAULT_NUMBER_SHORT = "nr";
    static final String DEFAULT_FIRST = "first";
    static final String DEFAULT_LAST = "last";
    static final String DEFAULT_DESCRIPTION_SHORT = "descr";
    static final String DEFAULT_STEP = "step";
    // -------------------------------------------------
    static final String DEFAULT_SERIALIZATION_PERFORMED = "Serialization has been performed:";
    static final String DEFAULT_DESERIALIZATION_PERFORMED = "Deserialization has been performed:";
    static final String DEFAULT_NULL_OBJECT_PROVIDED = "Null object passed in the parameter.";
    static final String DEFAULT_NULL_FILE_PATH_PROVIDED = "Null file passed in the parameter.";
    static final String DEFAULT_FILE_PATH_ZERO_LENGTH_PROVIDED = "The file path does not contain any characters.";
    static final String DEFAULT_FILE_PATH_IS_NOT_A_FILE = "The file path is not a file:";
    static final String DEFAULT_FILE_PATH_NOT_EXISTS = "The file path does not exist:";
    static final String DEFAULT_NULL_DATA_PROVIDED = "Null data passed in the parameter.";
    static final String DEFAULT_BINARY_SERIALIZATION_ENABLED = "Binary serialization is enabled. Use it only in a conscious and limited way.";
    static final String DEFAULT_BINARY_SERIALIZATION_DISABLED = "Binary serialization is disabled. You can enable it if you are aware of security risks.";
    // -------------------------------------------------
    static final String DEFAULT_USER_DEFINED_EXPRESSION = "User defined expression";
    static final String DEFAULT_USER_DEFINED_ARGUMENT = "User defined argument";
    static final String DEFAULT_USER_DEFINED_CONSTANT = "User defined constant";
    static final String DEFAULT_USER_DEFINED_FUNCTION = "User defined function";
    static final String DEFAULT_USER_DEFINED_RECURSIVE_ARGUMENT = "User defined recursive argument";
    // -------------------------------------------------
    static final String DEFAULT_HELP_CONTENT_LIMITED_TO_QUERY = "Help content limited to query";
    static final String DEFAULT_ALL_HELP_CONTENT = "All help content.";
    static final String DEFAULT_CAPTION = "Caption";
    // -------------------------------------------------
    static final String DEFAULT_WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "SECURITY WARNING:" + StringInvariant.NEW_LINE
                    + "Deserializing data from an untrusted source can introduce security vulnerabilities" + StringInvariant.NEW_LINE
                    + "to your application. Depending on the settings used during deserialization," + StringInvariant.NEW_LINE
                    + "untrusted data may be able to execute arbitrary code or cause a denial of service" + StringInvariant.NEW_LINE
                    + "attack. Untrusted data can come from over the network from an untrusted source" + StringInvariant.NEW_LINE
                    + "(e.g. any network client), or it can be manipulated/tampered by an intermediary while" + StringInvariant.NEW_LINE
                    + "in transit over an unauthenticated connection, or from local storage where it may" + StringInvariant.NEW_LINE
                    + "have been compromised/tampered, or from many other sources. MathParser.org-mXparser" + StringInvariant.NEW_LINE
                    + "does not provide any means to authenticate data or secure it from tampering. Use an" + StringInvariant.NEW_LINE
                    + "appropriate data authentication method before deserializing. Be very mindful of these" + StringInvariant.NEW_LINE
                    + "attack scenarios; many projects and companies and users of serialization libraries in" + StringInvariant.NEW_LINE
                    + "general have been bitten by untrusted deserialization of user data in the past." + StringInvariant.NEW_LINE
            ;
    // -------------------------------------------------
    static final String DEFAULT_BINARY_RELATION = "Binary relation";
    static final String DEFAULT_BITWISE_OPERATOR = "Bitwise operator";
    static final String DEFAULT_BOOLEAN_OPERATOR = "Boolean operator";
    static final String DEFAULT_CALCULUS_OPERATOR = "Calculus operator";
    static final String DEFAULT_CONSTANT_VALUE = "Constant value";
    static final String DEFAULT_FUNCTION_1_ARG = "Unary function";
    static final String DEFAULT_FUNCTION_2_ARG = "Binary function";
    static final String DEFAULT_FUNCTION_3_ARG = "Ternary function";
    static final String DEFAULT_FUNCTION_VARIADIC = "Variadic function";
    static final String DEFAULT_OPERATOR = "Operator";
    static final String DEFAULT_PARSER_SYMBOL = "Parser symbol";
    static final String DEFAULT_RANDOM_VARIABLE = "Random variable";
    static final String DEFAULT_UNIT = "Unit";
    static final String DEFAULT_DIMENSIONLESS_UNIT = "Dimensionless unit";
    static final String DEFAULT_ITERATED_OPERATOR = "Iterated operator";
    // -------------------------------------------------
    static final String DEFAULT_RATIO_FRACTION = "Ratio / Fraction";
    static final String DEFAULT_METRIC_PREFIX = "Metric prefix";
    static final String DEFAULT_UNIT_OF_LENGTH = "Unit of length";
    static final String DEFAULT_UNIT_OF_AREA = "Unit of area";
    static final String DEFAULT_UNIT_OF_VOLUME = "Unit of volume";
    static final String DEFAULT_UNIT_OF_TIME = "Unit of time";
    static final String DEFAULT_UNIT_OF_MASS = "Unit of mass";
    static final String DEFAULT_UNIT_OF_INFORMATION = "Unit of information";
    static final String DEFAULT_UNIT_OF_ENERGY = "Unit of energy";
    static final String DEFAULT_UNIT_OF_SPEED = "Unit of speed";
    static final String DEFAULT_UNIT_OF_ACCELERATION = "Unit of acceleration";
    static final String DEFAULT_UNIT_OF_ANGLE = "Unit of angle";
    // -------------------------------------------------
    static final String DEFAULT_PHYSICAL_CONSTANT = "Physical constant";
    static final String DEFAULT_ASTRONOMICAL_CONSTANT = "Astronomical constant";
    static final String DEFAULT_MATHEMATICAL_CONSTANT = "Mathematical constant";
    // -------------------------------------------------
    static final String DEFAULT_PROBABILITY_DISTRIBUTION_FUNCTION = "Probability distribution function";
    static final String DEFAULT_CUMULATIVE_DISTRIBUTION_FUNCTION = "Cumulative distribution function";
    static final String DEFAULT_QUANTILE_FUNCTION = "Quantile function (inverse cumulative distribution function)";
    // -------------------------------------------------
    static final String DEFAULT_STUDENTS_T_DISTRIBUTION = "Student's t-distribution";
    static final String DEFAULT_CHI_SQUARED_DISTRIBUTION = "Chi-squared distribution";
    static final String DEFAULT_SNEDECORS_F_DISTRIBUTION = "Snedecor's F distribution (F-distribution or F-ratio, also known as Fisher–Snedecor distribution)";
    static final String DEFAULT_UNIFORM_CONTINUOUS_DISTRIBUTION = "Uniform continuous distribution";
    static final String DEFAULT_UNIFORM_DISCRETE_DISTRIBUTION = "Uniform discrete distribution";
    static final String DEFAULT_NORMAL_DISTRIBUTION = "Normal distribution";
    // -------------------------------------------------
    static final String DEFAULT_RANDOM_INTEGER = "Random integer";
    static final String DEFAULT_RANDOM_NATURAL_NUMBER = "Random natural number";
    static final String DEFAULT_RANDOM_NATURAL_NUMBER_INCLUDING_0 = "Random natural number including 0";
    // -------------------------------------------------
    static final String DEFAULT_SPECIAL_FUNCTION = "Special function";
    // -------------------------------------------------
    static final String DEFAULT_SEMI_MAJOR_AXIS = "Semi major axis";
    // -------------------------------------------------
    static final String DEFAULT_BINARY_RELATION_EQ = "Equality";
    static final String DEFAULT_BINARY_RELATION_NEQ = "Inequation";
    static final String DEFAULT_BINARY_RELATION_LT = "Lower than";
    static final String DEFAULT_BINARY_RELATION_GT = "Greater than";
    static final String DEFAULT_BINARY_RELATION_LEQ = "Lower or equal";
    static final String DEFAULT_BINARY_RELATION_GEQ = "Greater or equal";
    // -------------------------------------------------
    static final String DEFAULT_BITWISE_OPERATOR_COMPL = "Bitwise unary complement (NOT)";
    static final String DEFAULT_BITWISE_OPERATOR_AND = "Bitwise and (AND)";
    static final String DEFAULT_BITWISE_OPERATOR_XOR = "Bitwise exclusive or (XOR)";
    static final String DEFAULT_BITWISE_OPERATOR_OR = "Bitwise inclusive or (OR)";
    static final String DEFAULT_BITWISE_OPERATOR_LEFT_SHIFT = "Bitwise signed left shift";
    static final String DEFAULT_BITWISE_OPERATOR_RIGHT_SHIFT = "Bitwise signed right shift";
    static final String DEFAULT_BITWISE_OPERATOR_NAND = "Bitwise not and (NAND)";
    static final String DEFAULT_BITWISE_OPERATOR_NOR = "Bitwise not or (NOR)";
    static final String DEFAULT_BITWISE_OPERATOR_XNOR = "Bitwise exclusive NOR (XNOR)";
    // -------------------------------------------------
    static final String DEFAULT_BOOLEAN_OPERATOR_AND = "Logical conjunction";
    static final String DEFAULT_BOOLEAN_OPERATOR_OR = "Logical disjunction";
    static final String DEFAULT_BOOLEAN_OPERATOR_NEG = "Negation";
    static final String DEFAULT_BOOLEAN_OPERATOR_NAND = "Sheffer stroke";
    static final String DEFAULT_BOOLEAN_OPERATOR_NOR = "Logical not or (joint denial)";
    static final String DEFAULT_BOOLEAN_OPERATOR_XOR = "Exclusive or";
    static final String DEFAULT_BOOLEAN_OPERATOR_IMP = "Implication";
    static final String DEFAULT_BOOLEAN_OPERATOR_CIMP = "Converse implication";
    static final String DEFAULT_BOOLEAN_OPERATOR_NIMP = "Material nonimplication";
    static final String DEFAULT_BOOLEAN_OPERATOR_CNIMP = "Converse nonimplication";
    static final String DEFAULT_BOOLEAN_OPERATOR_EQV = "Logical biconditional";
    // -------------------------------------------------
    static final String DEFAULT_CALCULUS_OPERATOR_SUM = "Summation SIGMA";
    static final String DEFAULT_CALCULUS_OPERATOR_PROD = "Product PI";
    static final String DEFAULT_CALCULUS_OPERATOR_INT = "Definite integral";
    static final String DEFAULT_CALCULUS_OPERATOR_DER = "Derivative";
    static final String DEFAULT_CALCULUS_OPERATOR_DER_LEFT = "Left derivative";
    static final String DEFAULT_CALCULUS_OPERATOR_DER_RIGHT = "Right derivative";
    static final String DEFAULT_CALCULUS_OPERATOR_DERN = "n-th derivative";
    static final String DEFAULT_CALCULUS_OPERATOR_FORW_DIFF = "Forward difference";
    static final String DEFAULT_CALCULUS_OPERATOR_BACKW_DIFF = "Backward difference";
    static final String DEFAULT_CALCULUS_OPERATOR_AVG = "Average";
    static final String DEFAULT_CALCULUS_OPERATOR_VAR = "Bias-corrected sample variance";
    static final String DEFAULT_CALCULUS_OPERATOR_STD = "Bias-corrected sample standard deviation";
    static final String DEFAULT_CALCULUS_OPERATOR_MIN = "Minimum value";
    static final String DEFAULT_CALCULUS_OPERATOR_MAX = "Maximum value";
    static final String DEFAULT_CALCULUS_OPERATOR_SOLVE = "Equation solving (root finding)";
    // -------------------------------------------------
    static final String DEFAULT_CONSTANT_VALUE_PI = "Pi, Archimedes' or Ludolph's number";
    static final String DEFAULT_CONSTANT_VALUE_EULER = "Napier's or Euler's number (base of Natural logarithm)";
    static final String DEFAULT_CONSTANT_VALUE_EULER_MASCHERONI = "Euler-Mascheroni constant";
    static final String DEFAULT_CONSTANT_VALUE_GOLDEN_RATIO = "Golden ratio";
    static final String DEFAULT_CONSTANT_VALUE_PLASTIC = "Plastic constant";
    static final String DEFAULT_CONSTANT_VALUE_EMBREE_TREFETHEN = "Embree-Trefethen constant";
    static final String DEFAULT_CONSTANT_VALUE_FEIGENBAUM_DELTA = "Feigenbaum delta constant";
    static final String DEFAULT_CONSTANT_VALUE_FEIGENBAUM_ALPHA = "Feigenbaum alpha constant";
    static final String DEFAULT_CONSTANT_VALUE_TWIN_PRIME = "Twin prime constant";
    static final String DEFAULT_CONSTANT_VALUE_MEISSEL_MERTEENS = "Meissel-Mertens constant";
    static final String DEFAULT_CONSTANT_VALUE_BRAUN_TWIN_PRIME = "Brun's constant for twin primes";
    static final String DEFAULT_CONSTANT_VALUE_BRAUN_PRIME_QUADR = "Brun's constant for prime quadruplets";
    static final String DEFAULT_CONSTANT_VALUE_BRUIJN_NEWMAN = "de Bruijn-Newman constant";
    static final String DEFAULT_CONSTANT_VALUE_CATALAN = "Catalan's constant";
    static final String DEFAULT_CONSTANT_VALUE_LANDAU_RAMANUJAN = "Landau-Ramanujan constant";
    static final String DEFAULT_CONSTANT_VALUE_VISWANATH = "Viswanath's constant";
    static final String DEFAULT_CONSTANT_VALUE_LEGENDRE = "Legendre's constant";
    static final String DEFAULT_CONSTANT_VALUE_RAMANUJAN_SOLDNER = "Ramanujan-Soldner constant";
    static final String DEFAULT_CONSTANT_VALUE_ERDOS_BORWEIN = "Erdos-Borwein constant";
    static final String DEFAULT_CONSTANT_VALUE_BERNSTEIN = "Bernstein's constant";
    static final String DEFAULT_CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = "Gauss-Kuzmin-Wirsing constant";
    static final String DEFAULT_CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = "Hafner-Sarnak-McCurley constant";
    static final String DEFAULT_CONSTANT_VALUE_GOLOMB_DICKMAN = "Golomb-Dickman constant";
    static final String DEFAULT_CONSTANT_VALUE_CAHEN = "Cahen's constant";
    static final String DEFAULT_CONSTANT_VALUE_LAPLACE_LIMIT = "Laplace limit constant";
    static final String DEFAULT_CONSTANT_VALUE_ALLADI_GRINSTEAD = "Alladi-Grinstead constant";
    static final String DEFAULT_CONSTANT_VALUE_LENGYEL = "Lengyel's constant";
    static final String DEFAULT_CONSTANT_VALUE_LEVY = "Levy's constant";
    static final String DEFAULT_CONSTANT_VALUE_APERY = "Apery's constant";
    static final String DEFAULT_CONSTANT_VALUE_MILLS = "Mills' constant";
    static final String DEFAULT_CONSTANT_VALUE_BACKHOUSE = "Backhouse's constant";
    static final String DEFAULT_CONSTANT_VALUE_PORTER = "Porter's constant";
    static final String DEFAULT_CONSTANT_VALUE_LIEB_QUARE_ICE = "Lieb's square ice constant";
    static final String DEFAULT_CONSTANT_VALUE_NIVEN = "Niven's constant";
    static final String DEFAULT_CONSTANT_VALUE_SIERPINSKI = "Sierpinski's constant";
    static final String DEFAULT_CONSTANT_VALUE_KHINCHIN = "Khinchin's constant";
    static final String DEFAULT_CONSTANT_VALUE_FRANSEN_ROBINSON = "Fransen-Robinson constant";
    static final String DEFAULT_CONSTANT_VALUE_LANDAU = "Landau's constant";
    static final String DEFAULT_CONSTANT_VALUE_PARABOLIC = "Parabolic constant";
    static final String DEFAULT_CONSTANT_VALUE_OMEGA = "Omega constant";
    static final String DEFAULT_CONSTANT_VALUE_MRB = "MRB constant";
    static final String DEFAULT_CONSTANT_VALUE_LI2 = "Logarithmic integral at point 2";
    static final String DEFAULT_CONSTANT_VALUE_GOMPERTZ = "Gompertz constant";
    static final String DEFAULT_CONSTANT_VALUE_LIGHT_SPEED = "Light speed in vacuum";
    static final String DEFAULT_CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = "Gravitational constant";
    static final String DEFAULT_CONSTANT_VALUE_GRAVIT_ACC_EARTH = "Gravitational acceleration on Earth";
    static final String DEFAULT_CONSTANT_VALUE_PLANCK_CONSTANT = "Planck constant";
    static final String DEFAULT_CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = "Reduced Planck constant (Dirac constant)";
    static final String DEFAULT_CONSTANT_VALUE_PLANCK_LENGTH = "Planck length";
    static final String DEFAULT_CONSTANT_VALUE_PLANCK_MASS = "Planck mass";
    static final String DEFAULT_CONSTANT_VALUE_PLANCK_TIME = "Planck time";
    static final String DEFAULT_CONSTANT_VALUE_LIGHT_YEAR = "Light year";
    static final String DEFAULT_CONSTANT_VALUE_ASTRONOMICAL_UNIT = "Astronomical unit";
    static final String DEFAULT_CONSTANT_VALUE_PARSEC = "Parsec";
    static final String DEFAULT_CONSTANT_VALUE_KILOPARSEC = "Kiloparsec";
    static final String DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = "Earth equatorial radius";
    static final String DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_POLAR = "Earth polar radius";
    static final String DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_MEAN = "Earth mean radius";
    static final String DEFAULT_CONSTANT_VALUE_EARTH_MASS = "Earth mass";
    static final String DEFAULT_CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = "Earth-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_MOON_RADIUS_MEAN = "Moon mean radius";
    static final String DEFAULT_CONSTANT_VALUE_MOON_MASS = "Moon mass";
    static final String DEFAULT_CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = "Moon-Earth distance";
    static final String DEFAULT_CONSTANT_VALUE_SOLAR_RADIUS = "Solar mean radius";
    static final String DEFAULT_CONSTANT_VALUE_SOLAR_MASS = "Solar mass";
    static final String DEFAULT_CONSTANT_VALUE_MERCURY_RADIUS_MEAN = "Mercury mean radius";
    static final String DEFAULT_CONSTANT_VALUE_MERCURY_MASS = "Mercury mass";
    static final String DEFAULT_CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = "Mercury-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_VENUS_RADIUS_MEAN = "Venus mean radius";
    static final String DEFAULT_CONSTANT_VALUE_VENUS_MASS = "Venus mass";
    static final String DEFAULT_CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = "Venus-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_MARS_RADIUS_MEAN = "Mars mean radius";
    static final String DEFAULT_CONSTANT_VALUE_MARS_MASS = "Mars mass";
    static final String DEFAULT_CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = "Mars-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_JUPITER_RADIUS_MEAN = "Jupiter mean radius";
    static final String DEFAULT_CONSTANT_VALUE_JUPITER_MASS = "Jupiter mass";
    static final String DEFAULT_CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = "Jupiter-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_SATURN_RADIUS_MEAN = "Saturn mean radius";
    static final String DEFAULT_CONSTANT_VALUE_SATURN_MASS = "Saturn mass";
    static final String DEFAULT_CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = "Saturn-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_URANUS_RADIUS_MEAN = "Uranus mean radius";
    static final String DEFAULT_CONSTANT_VALUE_URANUS_MASS = "Uranus mass";
    static final String DEFAULT_CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = "Uranus-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = "Neptune mean radius";
    static final String DEFAULT_CONSTANT_VALUE_NEPTUNE_MASS = "Neptune mass";
    static final String DEFAULT_CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = "Neptune-Sun distance";
    static final String DEFAULT_CONSTANT_VALUE_TRUE = "Boolean True represented as 1";
    static final String DEFAULT_CONSTANT_VALUE_FALSE = "Boolean False represented as 0";
    static final String DEFAULT_CONSTANT_VALUE_NPAR = "Automatically generated constant for user defined functions, returns number of given function parameters";
    static final String DEFAULT_CONSTANT_VALUE_NAN = "Not-a-Number";
    // -------------------------------------------------
    static final String DEFAULT_FUNCTION_1_ARG_SIN = "Trigonometric sine";
    static final String DEFAULT_FUNCTION_1_ARG_COS = "Trigonometric cosine";
    static final String DEFAULT_FUNCTION_1_ARG_TAN = "Trigonometric tangent";
    static final String DEFAULT_FUNCTION_1_ARG_CTAN = "Trigonometric cotangent";
    static final String DEFAULT_FUNCTION_1_ARG_SEC = "Trigonometric secant";
    static final String DEFAULT_FUNCTION_1_ARG_COSEC = "Trigonometric cosecant";
    static final String DEFAULT_FUNCTION_1_ARG_ASIN = "Inverse trigonometric sine";
    static final String DEFAULT_FUNCTION_1_ARG_ACOS = "Inverse trigonometric cosine";
    static final String DEFAULT_FUNCTION_1_ARG_ATAN = "Inverse trigonometric tangent";
    static final String DEFAULT_FUNCTION_1_ARG_ACTAN = "Inverse trigonometric cotangent";
    static final String DEFAULT_FUNCTION_1_ARG_LN = "Natural logarithm (base e)";
    static final String DEFAULT_FUNCTION_1_ARG_LOG2 = "Binary logarithm (base 2)";
    static final String DEFAULT_FUNCTION_1_ARG_LOG10 = "Common logarithm (base 10)";
    static final String DEFAULT_FUNCTION_1_ARG_RAD = "Degrees to radians";
    static final String DEFAULT_FUNCTION_1_ARG_EXP = "Exponential";
    static final String DEFAULT_FUNCTION_1_ARG_SQRT = "Square root";
    static final String DEFAULT_FUNCTION_1_ARG_SINH = "Hyperbolic sine";
    static final String DEFAULT_FUNCTION_1_ARG_COSH = "Hyperbolic cosine";
    static final String DEFAULT_FUNCTION_1_ARG_TANH = "Hyperbolic tangent";
    static final String DEFAULT_FUNCTION_1_ARG_COTH = "Hyperbolic cotangent";
    static final String DEFAULT_FUNCTION_1_ARG_SECH = "Hyperbolic secant";
    static final String DEFAULT_FUNCTION_1_ARG_CSCH = "Hyperbolic cosecant";
    static final String DEFAULT_FUNCTION_1_ARG_DEG = "Radians to degrees";
    static final String DEFAULT_FUNCTION_1_ARG_ABS = "Absolut value";
    static final String DEFAULT_FUNCTION_1_ARG_SGN = "Signum";
    static final String DEFAULT_FUNCTION_1_ARG_FLOOR = "Floor";
    static final String DEFAULT_FUNCTION_1_ARG_CEIL = "Ceiling";
    static final String DEFAULT_FUNCTION_1_ARG_NOT = "Negation";
    static final String DEFAULT_FUNCTION_1_ARG_ARSINH = "Inverse hyperbolic sine";
    static final String DEFAULT_FUNCTION_1_ARG_ARCOSH = "Inverse hyperbolic cosine";
    static final String DEFAULT_FUNCTION_1_ARG_ARTANH = "Inverse hyperbolic tangent";
    static final String DEFAULT_FUNCTION_1_ARG_ARCOTH = "Inverse hyperbolic cotangent";
    static final String DEFAULT_FUNCTION_1_ARG_ARSECH = "Inverse hyperbolic secant";
    static final String DEFAULT_FUNCTION_1_ARG_ARCSCH = "Inverse hyperbolic cosecant";
    static final String DEFAULT_FUNCTION_1_ARG_SA = "Sinc (normalized)";
    static final String DEFAULT_FUNCTION_1_ARG_SINC = "Sinc (unnormalized)";
    static final String DEFAULT_FUNCTION_1_ARG_BELL_NUMBER = "Bell number";
    static final String DEFAULT_FUNCTION_1_ARG_LUCAS_NUMBER = "Lucas number";
    static final String DEFAULT_FUNCTION_1_ARG_FIBONACCI_NUMBER = "Fibonacci number";
    static final String DEFAULT_FUNCTION_1_ARG_HARMONIC_NUMBER = "Harmonic number";
    static final String DEFAULT_FUNCTION_1_ARG_IS_PRIME = "Prime number test (is number a prime?)";
    static final String DEFAULT_FUNCTION_1_ARG_PRIME_COUNT = "Prime-counting";
    static final String DEFAULT_FUNCTION_1_ARG_EXP_INT = "Exponential integral";
    static final String DEFAULT_FUNCTION_1_ARG_LOG_INT = "Logarithmic integral";
    static final String DEFAULT_FUNCTION_1_ARG_OFF_LOG_INT = "Offset logarithmic integral";
    static final String DEFAULT_FUNCTION_1_ARG_GAUSS_ERF = "Gauss error";
    static final String DEFAULT_FUNCTION_1_ARG_GAUSS_ERFC = "Gauss complementary error";
    static final String DEFAULT_FUNCTION_1_ARG_GAUSS_ERF_INV = "Inverse Gauss error";
    static final String DEFAULT_FUNCTION_1_ARG_GAUSS_ERFC_INV = "Inverse Gauss complementary error";
    static final String DEFAULT_FUNCTION_1_ARG_ULP = "Unit in The Last Place";
    static final String DEFAULT_FUNCTION_1_ARG_ISNAN = "Returns true if value is a Not-a-Number (NaN), false otherwise";
    static final String DEFAULT_FUNCTION_1_ARG_NDIG10 = "Number of digits in numeral system with base 10";
    static final String DEFAULT_FUNCTION_1_ARG_NFACT = "Prime decomposition - number of distinct prime factors";
    static final String DEFAULT_FUNCTION_1_ARG_ARCSEC = "Inverse trigonometric secant";
    static final String DEFAULT_FUNCTION_1_ARG_ARCCSC = "Inverse trigonometric cosecant";
    static final String DEFAULT_FUNCTION_1_ARG_GAMMA = "Gamma";
    static final String DEFAULT_FUNCTION_1_ARG_LAMBERT_W0 = "Lambert-W, principal branch 0, also called the omega or product logarithm";
    static final String DEFAULT_FUNCTION_1_ARG_LAMBERT_W1 = "Lambert-W, branch -1, also called the omega or product logarithm";
    static final String DEFAULT_FUNCTION_1_ARG_SGN_GAMMA = "Signum of Gamma";
    static final String DEFAULT_FUNCTION_1_ARG_LOG_GAMMA = "Log Gamma";
    static final String DEFAULT_FUNCTION_1_ARG_DI_GAMMA = "Digamma as the logarithmic derivative of the Gamma";
    static final String DEFAULT_FUNCTION_1_ARG_PARAM = "Automatically generated function for user defined functions, returns function parameter value at index 'i'";
    // -------------------------------------------------
    static final String DEFAULT_FUNCTION_2_ARG_LOG = "Logarithm";
    static final String DEFAULT_FUNCTION_2_ARG_MOD = "Modulo";
    static final String DEFAULT_FUNCTION_2_ARG_BINOM_COEFF = "Binomial coefficient, number of k-combinations that can be drawn from n-elements set";
    static final String DEFAULT_FUNCTION_2_ARG_BERNOULLI_NUMBER = "Bernoulli numbers";
    static final String DEFAULT_FUNCTION_2_ARG_STIRLING1_NUMBER = "Stirling numbers of the first kind";
    static final String DEFAULT_FUNCTION_2_ARG_STIRLING2_NUMBER = "Stirling numbers of the second kind";
    static final String DEFAULT_FUNCTION_2_ARG_WORPITZKY_NUMBER = "Worpitzky number";
    static final String DEFAULT_FUNCTION_2_ARG_EULER_NUMBER = "Euler number";
    static final String DEFAULT_FUNCTION_2_ARG_KRONECKER_DELTA = "Kronecker delta";
    static final String DEFAULT_FUNCTION_2_ARG_EULER_POLYNOMIAL = "Euler polynomial";
    static final String DEFAULT_FUNCTION_2_ARG_HARMONIC_NUMBER = "Harmonic number";
    static final String DEFAULT_FUNCTION_2_ARG_ROUND = "Half-up rounding";
    static final String DEFAULT_FUNCTION_2_ARG_NDIG = "Number of digits representing the number in numeral system with given base";
    static final String DEFAULT_FUNCTION_2_ARG_DIGIT10 = "Digit at position 1 ... n (left -> right) or 0 ... -(n-1) (right -> left) - base 10 numeral system";
    static final String DEFAULT_FUNCTION_2_ARG_FACTVAL = "Prime decomposition - factor value at position between 1 ... nfact(n) - ascending order by factor value";
    static final String DEFAULT_FUNCTION_2_ARG_FACTEXP = "Prime decomposition - factor exponent / multiplicity at position between 1 ... nfact(n) - ascending order by factor value";
    static final String DEFAULT_FUNCTION_2_ARG_ROOT = "N-th order root of a number";
    static final String DEFAULT_FUNCTION_2_ARG_INC_GAMMA_LOWER = "Lower incomplete gamma";
    static final String DEFAULT_FUNCTION_2_ARG_INC_GAMMA_UPPER = "Upper incomplete Gamma";
    static final String DEFAULT_FUNCTION_2_ARG_REG_GAMMA_LOWER = "Lower regularized P gamma";
    static final String DEFAULT_FUNCTION_2_ARG_REG_GAMMA_UPPER = "Upper regularized Q Gamma";
    static final String DEFAULT_FUNCTION_2_ARG_PERMUTATIONS = "Number of k-permutations that can be drawn from n-elements set";
    static final String DEFAULT_FUNCTION_2_ARG_BETA = "The Beta, also called the Euler integral of the first kind";
    static final String DEFAULT_FUNCTION_2_ARG_LOG_BETA = "The Log Beta, also called the Log Euler integral of the first kind";
    // -------------------------------------------------
    static final String DEFAULT_FUNCTION_3_ARG_IF = "If";
    static final String DEFAULT_FUNCTION_3_ARG_CHI = "Characteristic function for x in (a,b)";
    static final String DEFAULT_FUNCTION_3_ARG_CHI_LR = "Characteristic function for x in [a,b]";
    static final String DEFAULT_FUNCTION_3_ARG_CHI_L = "Characteristic function for x in [a,b)";
    static final String DEFAULT_FUNCTION_3_ARG_CHI_R = "Characteristic function for x in (a,b]";
    static final String DEFAULT_FUNCTION_3_ARG_DIGIT = "Digit at position 1 ... n (left -> right) or 0 ... -(n-1) (right -> left) - numeral system with given base";
    static final String DEFAULT_FUNCTION_3_ARG_INC_BETA = "The incomplete Beta, also called the incomplete Euler integral of the first kind";
    static final String DEFAULT_FUNCTION_3_ARG_REG_BETA = "The regularized incomplete Beta (or regularized beta), also called the regularized incomplete Euler integral of the first kind";
    // -------------------------------------------------
    static final String DEFAULT_FUNCTION_VARIADIC_IFF = "If function";
    static final String DEFAULT_FUNCTION_VARIADIC_MIN = "Minimum";
    static final String DEFAULT_FUNCTION_VARIADIC_MAX = "Maximum";
    static final String DEFAULT_FUNCTION_VARIADIC_CONT_FRAC = "Continued fraction";
    static final String DEFAULT_FUNCTION_VARIADIC_CONT_POL = "Continued polynomial";
    static final String DEFAULT_FUNCTION_VARIADIC_GCD = "Greatest common divisor";
    static final String DEFAULT_FUNCTION_VARIADIC_LCM = "Least common multiple";
    static final String DEFAULT_FUNCTION_VARIADIC_SUM = "Summation";
    static final String DEFAULT_FUNCTION_VARIADIC_PROD = "Multiplication";
    static final String DEFAULT_FUNCTION_VARIADIC_AVG = "Mean / average value";
    static final String DEFAULT_FUNCTION_VARIADIC_VAR = "Bias-corrected sample variance";
    static final String DEFAULT_FUNCTION_VARIADIC_STD = "Bias-corrected sample standard deviation";
    static final String DEFAULT_FUNCTION_VARIADIC_RND_LIST = "Random number from a given list of numbers";
    static final String DEFAULT_FUNCTION_VARIADIC_COALESCE = "Returns the first non-NaN value";
    static final String DEFAULT_FUNCTION_VARIADIC_OR = "Logical disjunction (OR) - variadic";
    static final String DEFAULT_FUNCTION_VARIADIC_AND = "Logical conjunction (AND) - variadic";
    static final String DEFAULT_FUNCTION_VARIADIC_XOR = "Exclusive or (XOR) - variadic";
    static final String DEFAULT_FUNCTION_VARIADIC_ARGMIN = "Arguments / indices of the minima";
    static final String DEFAULT_FUNCTION_VARIADIC_ARGMAX = "Arguments / indices of the maxima";
    static final String DEFAULT_FUNCTION_VARIADIC_MEDIAN = "The sample median";
    static final String DEFAULT_FUNCTION_VARIADIC_MODE = "Mode - the value that appears most often";
    static final String DEFAULT_FUNCTION_VARIADIC_BASE = "Returns number in given numeral system base represented by list of digits";
    static final String DEFAULT_FUNCTION_VARIADIC_NDIST = "Number of distinct values";
    // -------------------------------------------------
    static final String DEFAULT_OPERATOR_PLUS = "Addition";
    static final String DEFAULT_OPERATOR_MINUS = "Subtraction";
    static final String DEFAULT_OPERATOR_MULTIPLY = "Multiplication";
    static final String DEFAULT_OPERATOR_DIVIDE = "Division";
    static final String DEFAULT_OPERATOR_DIVIDE_QUOTIENT = "Integer division (quotient)";
    static final String DEFAULT_OPERATOR_POWER = "Exponentiation";
    static final String DEFAULT_OPERATOR_FACT = "Factorial";
    static final String DEFAULT_OPERATOR_MOD = "Modulo";
    static final String DEFAULT_OPERATOR_PERC = "Percentage";
    static final String DEFAULT_OPERATOR_TETRATION = "Tetration (hyper-4, power tower, exponential tower)";
    static final String DEFAULT_OPERATOR_SQUARE_ROOT = "Square root";
    static final String DEFAULT_OPERATOR_CUBE_ROOT = "Cube root";
    static final String DEFAULT_OPERATOR_FOURTH_ROOT = "Fourth root";
    // -------------------------------------------------
    static final String DEFAULT_PARSER_SYMBOL_LEFT_PARENTHESES = "Left parentheses";
    static final String DEFAULT_PARSER_SYMBOL_RIGHT_PARENTHESES = "Right parentheses";
    static final String DEFAULT_PARSER_SYMBOL_COMMA = "Comma (function parameters)";
    static final String DEFAULT_PARSER_SYMBOL_SEMI = "Semicolon (function parameters)";
    static final String DEFAULT_PARSER_SYMBOL_BLANK = "Blank (whitespace) character";
    static final String DEFAULT_PARSER_SYMBOL_NUMBER_INTEGER = "Integer";
    static final String DEFAULT_PARSER_SYMBOL_NUMBER_DECIMAL = "Decimal";
    static final String DEFAULT_PARSER_SYMBOL_NUMBER_LEADING_ZERO = "Leading zero";
    static final String DEFAULT_PARSER_SYMBOL_NUMBER_SCI_NOTATION = "Scientific notation";
    static final String DEFAULT_PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = "No leading zero";
    static final String DEFAULT_PARSER_SYMBOL_NUMBER_FRACTIONS = "Fractions";
    static final String DEFAULT_PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = "Other numeral systems";
    static final String DEFAULT_PARSER_SYMBOL_UNICODE_MATH = " - Unicode math symbol";
    // -------------------------------------------------
    static final String DEFAULT_DIMENSIONLESS_UNIT_PERC = "Percentage";
    static final String DEFAULT_DIMENSIONLESS_UNIT_PERM = "Per mille";
    static final String DEFAULT_DIMENSIONLESS_UNIT_YOTTA = "Septillion / Yotta";
    static final String DEFAULT_DIMENSIONLESS_UNIT_ZETTA = "Sextillion / Zetta";
    static final String DEFAULT_DIMENSIONLESS_UNIT_EXA = "Quintillion / Exa";
    static final String DEFAULT_DIMENSIONLESS_UNIT_PETA = "Quadrillion / Peta";
    static final String DEFAULT_DIMENSIONLESS_UNIT_TERA = "Trillion / Tera";
    static final String DEFAULT_DIMENSIONLESS_UNIT_GIGA = "Billion / Giga";
    static final String DEFAULT_DIMENSIONLESS_UNIT_MEGA = "Million / Mega";
    static final String DEFAULT_DIMENSIONLESS_UNIT_KILO = "Thousand / Kilo";
    static final String DEFAULT_DIMENSIONLESS_UNIT_HECTO = "Hundred / Hecto";
    static final String DEFAULT_DIMENSIONLESS_UNIT_DECA = "Ten / Deca";
    static final String DEFAULT_DIMENSIONLESS_UNIT_DECI = "Tenth / Deci";
    static final String DEFAULT_DIMENSIONLESS_UNIT_CENTI = "Hundredth / Centi";
    static final String DEFAULT_DIMENSIONLESS_UNIT_MILLI = "Thousandth / Milli";
    static final String DEFAULT_DIMENSIONLESS_UNIT_MICRO = "Millionth / Micro";
    static final String DEFAULT_DIMENSIONLESS_UNIT_NANO = "Billionth / Nano";
    static final String DEFAULT_DIMENSIONLESS_UNIT_PICO = "Trillionth / Pico";
    static final String DEFAULT_DIMENSIONLESS_UNIT_FEMTO = "Quadrillionth / Femto";
    static final String DEFAULT_DIMENSIONLESS_UNIT_ATTO = "Quintillionth / Atto";
    static final String DEFAULT_DIMENSIONLESS_UNIT_ZEPTO = "Sextillionth / Zepto";
    static final String DEFAULT_DIMENSIONLESS_UNIT_YOCTO = "Septillionth / Yocto";
    // -------------------------------------------------
    static final String DEFAULT_UNIT_METRE = "Meter";
    static final String DEFAULT_UNIT_KILOMETRE = "Kilometer";
    static final String DEFAULT_UNIT_CENTIMETRE = "Centimeter";
    static final String DEFAULT_UNIT_MILLIMETRE = "Millimeter";
    static final String DEFAULT_UNIT_INCH = "Inch";
    static final String DEFAULT_UNIT_YARD = "Yard";
    static final String DEFAULT_UNIT_FEET = "Feet";
    static final String DEFAULT_UNIT_MILE = "Mile";
    static final String DEFAULT_UNIT_NAUTICAL_MILE = "Nautical mile";
    static final String DEFAULT_UNIT_METRE2 = "Square meter";
    static final String DEFAULT_UNIT_CENTIMETRE2 = "Square centimeter";
    static final String DEFAULT_UNIT_MILLIMETRE2 = "Square millimeter";
    static final String DEFAULT_UNIT_ARE = "Are";
    static final String DEFAULT_UNIT_HECTARE = "Hectare";
    static final String DEFAULT_UNIT_ACRE = "Acre";
    static final String DEFAULT_UNIT_KILOMETRE2 = "Square kilometer";
    static final String DEFAULT_UNIT_MILLIMETRE3 = "Cubic millimeter";
    static final String DEFAULT_UNIT_CENTIMETRE3 = "Cubic centimeter";
    static final String DEFAULT_UNIT_METRE3 = "Cubic meter";
    static final String DEFAULT_UNIT_KILOMETRE3 = "Cubic kilometer";
    static final String DEFAULT_UNIT_MILLILITRE = "Milliliter";
    static final String DEFAULT_UNIT_LITRE = "Liter";
    static final String DEFAULT_UNIT_GALLON = "Gallon";
    static final String DEFAULT_UNIT_PINT = "Pint";
    static final String DEFAULT_UNIT_SECOND = "Second";
    static final String DEFAULT_UNIT_MILLISECOND = "Millisecond";
    static final String DEFAULT_UNIT_MINUTE = "Minute";
    static final String DEFAULT_UNIT_HOUR = "Hour";
    static final String DEFAULT_UNIT_DAY = "Day";
    static final String DEFAULT_UNIT_WEEK = "Week";
    static final String DEFAULT_UNIT_JULIAN_YEAR = "Julian year = 365.25 days";
    static final String DEFAULT_UNIT_KILOGRAM = "Kilogram";
    static final String DEFAULT_UNIT_GRAM = "Gram";
    static final String DEFAULT_UNIT_MILLIGRAM = "Milligram";
    static final String DEFAULT_UNIT_DECAGRAM = "Decagram";
    static final String DEFAULT_UNIT_TONNE = "Tonne";
    static final String DEFAULT_UNIT_OUNCE = "Ounce";
    static final String DEFAULT_UNIT_POUND = "Pound";
    static final String DEFAULT_UNIT_BIT = "Bit";
    static final String DEFAULT_UNIT_KILOBIT = "Kilobit";
    static final String DEFAULT_UNIT_MEGABIT = "Megabit";
    static final String DEFAULT_UNIT_GIGABIT = "Gigabit";
    static final String DEFAULT_UNIT_TERABIT = "Terabit";
    static final String DEFAULT_UNIT_PETABIT = "Petabit";
    static final String DEFAULT_UNIT_EXABIT = "Exabit";
    static final String DEFAULT_UNIT_ZETTABIT = "Zettabit";
    static final String DEFAULT_UNIT_YOTTABIT = "Yottabit";
    static final String DEFAULT_UNIT_BYTE = "Byte";
    static final String DEFAULT_UNIT_KILOBYTE = "Kilobyte";
    static final String DEFAULT_UNIT_MEGABYTE = "Megabyte";
    static final String DEFAULT_UNIT_GIGABYTE = "Gigabyte";
    static final String DEFAULT_UNIT_TERABYTE = "Terabyte";
    static final String DEFAULT_UNIT_PETABYTE = "Petabyte";
    static final String DEFAULT_UNIT_EXABYTE = "Exabyte";
    static final String DEFAULT_UNIT_ZETTABYTE = "Zettabyte";
    static final String DEFAULT_UNIT_YOTTABYTE = "Yottabyte";
    static final String DEFAULT_UNIT_JOULE = "Joule";
    static final String DEFAULT_UNIT_ELECTRONO_VOLT = "Electronovolt";
    static final String DEFAULT_UNIT_KILO_ELECTRONO_VOLT = "Kiloelectronovolt";
    static final String DEFAULT_UNIT_MEGA_ELECTRONO_VOLT = "Megaelectronovolt";
    static final String DEFAULT_UNIT_GIGA_ELECTRONO_VOLT = "Gigaelectronovolt";
    static final String DEFAULT_UNIT_TERA_ELECTRONO_VOLT = "Teraelectronovolt";
    static final String DEFAULT_UNIT_METRE_PER_SECOND = "Meter per second";
    static final String DEFAULT_UNIT_KILOMETRE_PER_HOUR = "Kilometer per hour";
    static final String DEFAULT_UNIT_MILE_PER_HOUR = "Mile per hour";
    static final String DEFAULT_UNIT_KNOT = "Knot";
    static final String DEFAULT_UNIT_METRE_PER_SECOND2 = "Meter per square second";
    static final String DEFAULT_UNIT_KILOMETRE_PER_HOUR2 = "Kilometer per square hour";
    static final String DEFAULT_UNIT_MILE_PER_HOUR2 = "Mile per square hour";
    static final String DEFAULT_UNIT_RADIAN_ARC = "Radian";
    static final String DEFAULT_UNIT_DEGREE_ARC = "Degree of arc";
    static final String DEFAULT_UNIT_MINUTE_ARC = "Minute of arc";
    static final String DEFAULT_UNIT_SECOND_ARC = "Second of arc";

    /**
     * Default String = "English"
     */
    public String USER_LANGUAGE = DEFAULT_USER_LANGUAGE;
    // -------------------------------------------------
    /**
     * Default String = "Starting syntax check..."
     */
    public String STARTING_SYNTAX_CHECK = DEFAULT_STARTING_SYNTAX_CHECK;
    /**
     * Default String = "No errors detected."
     */
    public String NO_ERRORS_DETECTED = DEFAULT_NO_ERRORS_DETECTED;
    /**
     * Default String = "No errors detected in argument definition."
     */
    public String NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = DEFAULT_NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION;
    /**
     * Default String = "No errors detected in recursive argument definition."
     */
    public String NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = DEFAULT_NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION;
    /**
     * Default String = "No errors detected in function definition."
     */
    public String NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = DEFAULT_NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION;
    /**
     * Default String = "No errors detected in constant definition."
     */
    public String NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = DEFAULT_NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION;
    /**
     * Default String = "A lexical error has been found."
     */
    public String LEXICAL_ERROR_HAS_BEEN_FOUND = DEFAULT_LEXICAL_ERROR_HAS_BEEN_FOUND;
    /**
     * Default String = "Errors have been found."
     */
    public String ERRORS_HAVE_BEEN_FOUND = DEFAULT_ERRORS_HAVE_BEEN_FOUND;
    /**
     * Default String = "The syntax has already been checked - no errors detected."
     */
    public String ALREADY_CHECKED_NO_ERRORS = DEFAULT_ALREADY_CHECKED_NO_ERRORS;
    /**
     * Default String = "The syntax status is unknown."
     */
    public String SYNTAX_STATUS_UNKNOWN = DEFAULT_SYNTAX_STATUS_UNKNOWN;
    /**
     * Default String = "There is a problem with expression syntax."
     */
    public String PROBLEM_WITH_EXPRESSION_SYNTAX = DEFAULT_PROBLEM_WITH_EXPRESSION_SYNTAX;
    // -------------------------------------------------
    /**
     * Default String = "Encountered"
     */
    public String ENCOUNTERED = DEFAULT_ENCOUNTERED;
    /**
     * Default String = "at index"
     */
    public String AT_INDEX = DEFAULT_AT_INDEX;
    /**
     * Default String = "Was expecting"
     */
    public String WAS_EXPECTING = DEFAULT_WAS_EXPECTING;
    /**
     * Default String = "Was expecting one of"
     */
    public String WAS_EXPECTING_ONE_OF = DEFAULT_WAS_EXPECTING_ONE_OF;
    /**
     * Default String = "An unexpected exception was encountered. Probably a parser error - please report it."
     */
    public String UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = DEFAULT_UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED;
    /**
     * Default String = "An unexpected token manager error was encountered. Probably a parser error - please report it."
     */
    public String UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = DEFAULT_UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED;
    // -------------------------------------------------
    /**
     * Default String = "The expression string is empty."
     */
    public String EXPRESSION_STRING_IS_EMPTY = DEFAULT_EXPRESSION_STRING_IS_EMPTY;
    /**
     * Default String = "The expression does not contain any tokens."
     */
    public String EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = DEFAULT_EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS;
    /**
     * Default String = "Duplicated keywords were found. Check user-defined items. Consider using option to override built-in tokens."
     */
    public String DUPLICATED_KEYWORD = DEFAULT_DUPLICATED_KEYWORD;
    /**
     * Default String = "Element"
     */
    public String ELEMENT = DEFAULT_ELEMENT;
    /**
     * Default String = "Error"
     */
    public String ERROR = DEFAULT_ERROR;
    /**
     * Default String = "Exception"
     */
    public String EXCEPTION = DEFAULT_EXCEPTION;
    /**
     * Default String = "Token"
     */
    public String TOKEN = DEFAULT_TOKEN;
    /**
     * Default String = "index"
     */
    public String INDEX = DEFAULT_INDEX;
    /**
     * Default String = "Invalid token."
     */
    public String INVALID_TOKEN = DEFAULT_INVALID_TOKEN;
    /**
     * Default String = "Invalid token. Possibly missing multiplication operator - try implied multiplication mode."
     */
    public String INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = DEFAULT_INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR;
    /**
     * Default String = "Expression tokens"
     */
    public String EXPRESSION_TOKENS = DEFAULT_EXPRESSION_TOKENS;
    /**
     * Default String = "NULL tokens list"
     */
    public String NULL_TOKENS_LIST = DEFAULT_NULL_TOKENS_LIST;
    // -------------------------------------------------
    /**
     * Default String = "User-defined function with extended body - no errors by assumption."
     */
    public String FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = DEFAULT_FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS;
    /**
     * Default String = "User-defined argument with extended body - no errors by assumption."
     */
    public String ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = DEFAULT_ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS;
    /**
     * Default String = "Provided extension is null."
     */
    public String PROVIDED_EXTENSION_IS_NULL = DEFAULT_PROVIDED_EXTENSION_IS_NULL;
    /**
     * Default String = "Provided string is null."
     */
    public String PROVIDED_STRING_IS_NULL = DEFAULT_PROVIDED_STRING_IS_NULL;
    /**
     * Default String = "Provided elements are null."
     */
    public String PROVIDED_ELEMENTS_ARE_NULL = DEFAULT_PROVIDED_ELEMENTS_ARE_NULL;
    /**
     * Default String = "Possibly missing multiplication operator - try implied multiplication mode."
     */
    public String MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = DEFAULT_MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE;
    // -------------------------------------------------
    /**
     * Default String = "Starting syntax check of the dependent user-defined argument."
     */
    public String STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = DEFAULT_STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT;
    /**
     * Default String = "Starting syntax check of the user-defined recursive argument."
     */
    public String STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = DEFAULT_STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT;
    /**
     * Default String = "Starting syntax check of the user-defined function."
     */
    public String STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = DEFAULT_STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION;
    /**
     * Default String = "Starting syntax check of the variadic user-defined function."
     */
    public String STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = DEFAULT_STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION;
    // -------------------------------------------------
    /**
     * Default String = "User-defined argument was expected."
     */
    public String ARGUMENT_WAS_EXPECTED = DEFAULT_ARGUMENT_WAS_EXPECTED;
    /**
     * Default String = "A recursive user-defined argument requires one parameter."
     */
    public String RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = DEFAULT_RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER;
    // -------------------------------------------------
    /**
     * Default String = "Incorrect number of parameters in user-defined function."
     */
    public String INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = DEFAULT_INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION;
    // -------------------------------------------------
    /**
     * Default String = "Incorrect number of function parameters."
     */
    public String INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = DEFAULT_INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS;
    /**
     * Default String = "Expected"
     */
    public String EXPECTED = DEFAULT_EXPECTED;
    /**
     * Default String = "provided"
     */
    public String PROVIDED = DEFAULT_PROVIDED;
    /**
     * Default String = "Incorrect number of parameters in user-defined function - at least one argument is expected."
     */
    public String USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = DEFAULT_USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT;
    /**
     * Default String = "Even number of arguments was expected."
     */
    public String EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = DEFAULT_EXPECTED_EVEN_NUMBER_OF_ARGUMENTS;
    // -------------------------------------------------
    /**
     * Default String = "Invalid function name."
     */
    public String INVALID_FUNCTION_NAME = DEFAULT_INVALID_FUNCTION_NAME;
    /**
     * Default String = "Invalid argument name."
     */
    public String INVALID_ARGUMENT_NAME = DEFAULT_INVALID_ARGUMENT_NAME;
    /**
     * Default String = "Invalid constant name."
     */
    public String INVALID_CONSTANT_NAME = DEFAULT_INVALID_CONSTANT_NAME;
    /**
     * Default String = "Invalid function definition."
     */
    public String INVALID_FUNCTION_DEFINITION = DEFAULT_INVALID_FUNCTION_DEFINITION;
    /**
     * Default String = "Invalid argument definition."
     */
    public String INVALID_ARGUMENT_DEFINITION = DEFAULT_INVALID_ARGUMENT_DEFINITION;
    /**
     * Default String = "Invalid constant definition."
     */
    public String INVALID_CONSTANT_DEFINITION = DEFAULT_INVALID_CONSTANT_DEFINITION;
    /**
     * Default String = "Pattern does not match."
     */
    public String PATTERN_DOES_NOT_MATCH = DEFAULT_PATTERN_DOES_NOT_MATCH;
    /**
     * Default String = "Pattern examples"
     */
    public String PATTERN_EXAMPLES = DEFAULT_PATTERN_EXAMPLES;
    // -------------------------------------------------
    /**
     * Default String = "Constant value was expected."
     */
    public String CONSTANT_WAS_EXPECTED = DEFAULT_CONSTANT_WAS_EXPECTED;
    /**
     * Default String = "User-defined constant was expected."
     */
    public String USER_CONSTANT_WAS_EXPECTED = DEFAULT_USER_CONSTANT_WAS_EXPECTED;
    // -------------------------------------------------
    /**
     * Default String = "A unary function expects 1 parameter."
     */
    public String UNARY_FUNCTION_EXPECTS_1_PARAMETER = DEFAULT_UNARY_FUNCTION_EXPECTS_1_PARAMETER;
    /**
     * Default String = "A binary function expects 2 parameters."
     */
    public String BINARY_FUNCTION_EXPECTS_2_PARAMETERS = DEFAULT_BINARY_FUNCTION_EXPECTS_2_PARAMETERS;
    /**
     * Default String = "A ternary function expects 3 parameters."
     */
    public String TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = DEFAULT_TERNARY_FUNCTION_EXPECTS_3_PARAMETERS;
    // -------------------------------------------------
    /**
     * Default String = "A derivative operator expects 2 or 3 or 4 or 5 calculus parameters."
     */
    public String DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = DEFAULT_DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS;
    /**
     * Default String = "An argument was expected in a derivative operator invocation."
     */
    public String ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = DEFAULT_ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION;
    /**
     * Default String = "Duplicated keywords were found in the calculus operator invocation, check calculus parameters."
     */
    public String DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = DEFAULT_DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION;
    /**
     * Default String = "One token (argument or unknown) was expected in the calculus operator invocation."
     */
    public String ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = DEFAULT_ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION;
    /**
     * Default String = "N-th order derivative operator expects 3 or 5 calculus parameters."
     */
    public String NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = DEFAULT_NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS;
    /**
     * Default String = "The integral / solve operator expects 4 calculus parameters."
     */
    public String INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = DEFAULT_INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS;
    /**
     * Default String = "The iterated operator expects 4 or 5 calculus parameters."
     */
    public String ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = DEFAULT_ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS;
    /**
     * Default String = "The forward / backward difference operator expects 2 or 3 calculus parameters."
     */
    public String FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = DEFAULT_FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS;
    /**
     * Default String = "An argument was expected in the forward / backward difference operator invocation."
     */
    public String FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = DEFAULT_FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED;
    /**
     * Default String = "At least one argument was expected."
     */
    public String AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = DEFAULT_AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED;
    // -------------------------------------------------
    /**
     * Default String = "Error while executing the calculate."
     */
    public String ERROR_WHILE_EXECUTING_THE_CALCULATE = DEFAULT_ERROR_WHILE_EXECUTING_THE_CALCULATE;
    /**
     * Default String = "Recursion calls counter exceeded maximum calls allowed."
     */
    public String RECURSION_CALLS_COUNTER_EXCEEDED = DEFAULT_RECURSION_CALLS_COUNTER_EXCEEDED;
    /**
     * Default String = "Recursion calls counter"
     */
    public String RECURSION_CALLS_COUNTER = DEFAULT_RECURSION_CALLS_COUNTER;
    /**
     * Default String = "Starting calculation loop."
     */
    public String STARTING_CALCULATION_LOOP = DEFAULT_STARTING_CALCULATION_LOOP;
    /**
     * Default String = "Cancel request encountered - finishing."
     */
    public String CANCEL_REQUEST_FINISHING = DEFAULT_CANCEL_REQUEST_FINISHING;
    /**
     * Default String = "Internal error / strange token level - finishing. Probably a parser error - please report it."
     */
    public String INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = DEFAULT_INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING;
    /**
     * Default String = "Fatal error, do not know what to do with the encountered token. Probably a parser error - please report it."
     */
    public String FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = DEFAULT_FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN;
    /**
     * Default String = "The maximum error message length has been exceeded."
     */
    public String MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = DEFAULT_MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED;
    // -------------------------------------------------
    /**
     * Default String = "Starting..."
     */
    public String STARTING = DEFAULT_STARTING;
    /**
     * Default String = "Parsing"
     */
    public String PARSING = DEFAULT_PARSING;
    /**
     * Default String = "Fully compiled"
     */
    public String FULLY_COMPILED = DEFAULT_FULLY_COMPILED;
    /**
     * Default String = "Calculated value"
     */
    public String CALCULATED_VALUE = DEFAULT_CALCULATED_VALUE;
    /**
     * Default String = "Exiting."
     */
    public String EXITING = DEFAULT_EXITING;
    /**
     * Default String = "done."
     */
    public String DONE = DEFAULT_DONE;
    // -------------------------------------------------
    /**
     * Default String = "Keyword"
     */
    public String KEYWORD = DEFAULT_KEYWORD;
    /**
     * Default String = "Syntax"
     */
    public String SYNTAX = DEFAULT_SYNTAX;
    /**
     * Default String = "Number"
     */
    public String NUMBER = DEFAULT_NUMBER;
    /**
     * Default String = "Number literal"
     */
    public String NUMBER_LITERAL = DEFAULT_NUMBER_LITERAL;
    /**
     * Default String = "Type"
     */
    public String TYPE = DEFAULT_TYPE;
    /**
     * Default String = "Since"
     */
    public String SINCE = DEFAULT_SINCE;
    /**
     * Default String = "Description"
     */
    public String DESCRIPTION = DEFAULT_DESCRIPTION;
    // -------------------------------------------------
    /**
     * Default String = "CalcStepsRegister is empty"
     */
    public String CALC_STEPS_REGISTER_IS_EMPTY = DEFAULT_CALC_STEPS_REGISTER_IS_EMPTY;
    /**
     * Default String = "CalcStepsRegister for"
     */
    public String CALC_STEPS_REGISTER_FOR = DEFAULT_CALC_STEPS_REGISTER_FOR;
    /**
     * Default String = "Argument"
     */
    public String ARGUMENT = DEFAULT_ARGUMENT;
    /**
     * Default String = "Function"
     */
    public String FUNCTION = DEFAULT_FUNCTION;
    /**
     * Default String = "Expression"
     */
    public String EXPRESSION = DEFAULT_EXPRESSION;
    /**
     * Default String = "result"
     */
    public String RESULT = DEFAULT_RESULT;
    /**
     * Default String = "Computing time"
     */
    public String COMPUTING_TIME = DEFAULT_COMPUTING_TIME;
    /**
     * Default String = "gr"
     */
    public String GROUP_SHORT = DEFAULT_GROUP_SHORT;
    /**
     * Default String = "nr"
     */
    public String NUMBER_SHORT = DEFAULT_NUMBER_SHORT;
    /**
     * Default String = "first"
     */
    public String FIRST = DEFAULT_FIRST;
    /**
     * Default String = "last"
     */
    public String LAST = DEFAULT_LAST;
    /**
     * Default String = "descr"
     */
    public String DESCRIPTION_SHORT = DEFAULT_DESCRIPTION_SHORT;
    /**
     * Default String = "step"
     */
    public String STEP = DEFAULT_STEP;
    // -------------------------------------------------
    /**
     * Default String = "Serialization has been performed:"
     */
    public String SERIALIZATION_PERFORMED = DEFAULT_SERIALIZATION_PERFORMED;
    /**
     * Default String = "Deserialization has been performed:"
     */
    public String DESERIALIZATION_PERFORMED = DEFAULT_DESERIALIZATION_PERFORMED;
    /**
     * Default String = "Null object passed in the parameter."
     */
    public String NULL_OBJECT_PROVIDED = DEFAULT_NULL_OBJECT_PROVIDED;
    /**
     * Default String = "Null file passed in the parameter."
     */
    public String NULL_FILE_PATH_PROVIDED = DEFAULT_NULL_FILE_PATH_PROVIDED;
    /**
     * Default String = "The file path does not contain any characters."
     */
    public String FILE_PATH_ZERO_LENGTH_PROVIDED = DEFAULT_FILE_PATH_ZERO_LENGTH_PROVIDED;
    /**
     * Default String = "The file path is not a file:"
     */
    public String FILE_PATH_IS_NOT_A_FILE = DEFAULT_FILE_PATH_IS_NOT_A_FILE;
    /**
     * Default String = "The file path does not exist:"
     */
    public String FILE_PATH_NOT_EXISTS = DEFAULT_FILE_PATH_NOT_EXISTS;
    /**
     * Default String = "Null data passed in the parameter."
     */
    public String NULL_DATA_PROVIDED = DEFAULT_NULL_DATA_PROVIDED;
    /**
     * Default String = "Binary serialization is enabled. Use it only in a conscious and limited way."
     */
    public String BINARY_SERIALIZATION_ENABLED = DEFAULT_BINARY_SERIALIZATION_ENABLED;
    /**
     * Default String = "Binary serialization is disabled. You can enable it if you are aware of security risks."
     */
    public String BINARY_SERIALIZATION_DISABLED = DEFAULT_BINARY_SERIALIZATION_DISABLED;
    // -------------------------------------------------
    /**
     * Default String = "User defined expression"
     */
    public String USER_DEFINED_EXPRESSION = DEFAULT_USER_DEFINED_EXPRESSION;
    /**
     * Default String = "User defined argument"
     */
    public String USER_DEFINED_ARGUMENT = DEFAULT_USER_DEFINED_ARGUMENT;
    /**
     * Default String = "User defined constant"
     */
    public String USER_DEFINED_CONSTANT = DEFAULT_USER_DEFINED_CONSTANT;
    /**
     * Default String = "User defined function"
     */
    public String USER_DEFINED_FUNCTION = DEFAULT_USER_DEFINED_FUNCTION;
    /**
     * Default String = "User defined recursive argument"
     */
    public String USER_DEFINED_RECURSIVE_ARGUMENT = DEFAULT_USER_DEFINED_RECURSIVE_ARGUMENT;
    // -------------------------------------------------
    /**
     * Default String = "Help content limited to query"
     */
    public String HELP_CONTENT_LIMITED_TO_QUERY = DEFAULT_HELP_CONTENT_LIMITED_TO_QUERY;
    /**
     * Default String = "All help content."
     */
    public String ALL_HELP_CONTENT = DEFAULT_ALL_HELP_CONTENT;
    /**
     * Default String = "Caption"
     */
    public String CAPTION = DEFAULT_CAPTION;
    // -------------------------------------------------
    /**
     * Default String = "Deserializing data from an untrusted source can introduce security vulnerabilities to your application."
     */
    public String WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = DEFAULT_WARNING_BINARY_SERIALIZATION_SECURITY_RISKS;
    // -------------------------------------------------
    /**
     * Default String = "Binary relation"
     */
    public String BINARY_RELATION = DEFAULT_BINARY_RELATION;
    /**
     * Default String = "Bitwise operator"
     */
    public String BITWISE_OPERATOR = DEFAULT_BITWISE_OPERATOR;
    /**
     * Default String = "Boolean operator"
     */
    public String BOOLEAN_OPERATOR = DEFAULT_BOOLEAN_OPERATOR;
    /**
     * Default String = "Calculus operator"
     */
    public String CALCULUS_OPERATOR = DEFAULT_CALCULUS_OPERATOR;
    /**
     * Default String = "Constant value"
     */
    public String CONSTANT_VALUE = DEFAULT_CONSTANT_VALUE;
    /**
     * Default String = "Unary function"
     */
    public String FUNCTION_1_ARG = DEFAULT_FUNCTION_1_ARG;
    /**
     * Default String = "Binary function"
     */
    public String FUNCTION_2_ARG = DEFAULT_FUNCTION_2_ARG;
    /**
     * Default String = "Ternary function"
     */
    public String FUNCTION_3_ARG = DEFAULT_FUNCTION_3_ARG;
    /**
     * Default String = "Variadic function"
     */
    public String FUNCTION_VARIADIC = DEFAULT_FUNCTION_VARIADIC;
    /**
     * Default String = "Operator"
     */
    public String OPERATOR = DEFAULT_OPERATOR;
    /**
     * Default String = "Parser symbol"
     */
    public String PARSER_SYMBOL = DEFAULT_PARSER_SYMBOL;
    /**
     * Default String = "Random variable"
     */
    public String RANDOM_VARIABLE = DEFAULT_RANDOM_VARIABLE;
    /**
     * Default String = "Unit"
     */
    public String UNIT = DEFAULT_UNIT;
    /**
     * Default String = "Dimensionless unit"
     */
    public String DIMENSIONLESS_UNIT = DEFAULT_DIMENSIONLESS_UNIT;
    /**
     * Default String = "Iterated operator"
     */
    public String ITERATED_OPERATOR = DEFAULT_ITERATED_OPERATOR;
    // -------------------------------------------------
    /**
     * Default String = "Ratio / Fraction"
     */
    public String RATIO_FRACTION = DEFAULT_RATIO_FRACTION;
    /**
     * Default String = "Metric prefix"
     */
    public String METRIC_PREFIX = DEFAULT_METRIC_PREFIX;
    /**
     * Default String = "Unit of length"
     */
    public String UNIT_OF_LENGTH = DEFAULT_UNIT_OF_LENGTH;
    /**
     * Default String = "Unit of area"
     */
    public String UNIT_OF_AREA = DEFAULT_UNIT_OF_AREA;
    /**
     * Default String = "Unit of volume"
     */
    public String UNIT_OF_VOLUME = DEFAULT_UNIT_OF_VOLUME;
    /**
     * Default String = "Unit of time"
     */
    public String UNIT_OF_TIME = DEFAULT_UNIT_OF_TIME;
    /**
     * Default String = "Unit of mass"
     */
    public String UNIT_OF_MASS = DEFAULT_UNIT_OF_MASS;
    /**
     * Default String = "Unit of information"
     */
    public String UNIT_OF_INFORMATION = DEFAULT_UNIT_OF_INFORMATION;
    /**
     * Default String = "Unit of energy"
     */
    public String UNIT_OF_ENERGY = DEFAULT_UNIT_OF_ENERGY;
    /**
     * Default String = "Unit of speed"
     */
    public String UNIT_OF_SPEED = DEFAULT_UNIT_OF_SPEED;
    /**
     * Default String = "Unit of acceleration"
     */
    public String UNIT_OF_ACCELERATION = DEFAULT_UNIT_OF_ACCELERATION;
    /**
     * Default String = "Unit of angle"
     */
    public String UNIT_OF_ANGLE = DEFAULT_UNIT_OF_ANGLE;
    // -------------------------------------------------
    /**
     * Default String = "Physical constant"
     */
    public String PHYSICAL_CONSTANT = DEFAULT_PHYSICAL_CONSTANT;
    /**
     * Default String = "Astronomical constant"
     */
    public String ASTRONOMICAL_CONSTANT = DEFAULT_ASTRONOMICAL_CONSTANT;
    /**
     * Default String = "Mathematical constant"
     */
    public String MATHEMATICAL_CONSTANT = DEFAULT_MATHEMATICAL_CONSTANT;
    // -------------------------------------------------
    /**
     * Default String = "Probability distribution function"
     */
    public String PROBABILITY_DISTRIBUTION_FUNCTION = DEFAULT_PROBABILITY_DISTRIBUTION_FUNCTION;
    /**
     * Default String = "Cumulative distribution function"
     */
    public String CUMULATIVE_DISTRIBUTION_FUNCTION = DEFAULT_CUMULATIVE_DISTRIBUTION_FUNCTION;
    /**
     * Default String = "Quantile function (inverse cumulative distribution function)"
     */
    public String QUANTILE_FUNCTION = DEFAULT_QUANTILE_FUNCTION;
    // -------------------------------------------------
    /**
     * Default String = "Student's t-distribution"
     */
    public String STUDENTS_T_DISTRIBUTION = DEFAULT_STUDENTS_T_DISTRIBUTION;
    /**
     * Default String = "Chi-squared distribution"
     */
    public String CHI_SQUARED_DISTRIBUTION = DEFAULT_CHI_SQUARED_DISTRIBUTION;
    /**
     * Default String = "Snedecor's F distribution (F-distribution or F-ratio, also known as Fisher–Snedecor distribution)"
     */
    public String SNEDECORS_F_DISTRIBUTION = DEFAULT_SNEDECORS_F_DISTRIBUTION;
    /**
     * Default String = "Uniform continuous distribution"
     */
    public String UNIFORM_CONTINUOUS_DISTRIBUTION = DEFAULT_UNIFORM_CONTINUOUS_DISTRIBUTION;
    /**
     * Default String = "Uniform discrete distribution"
     */
    public String UNIFORM_DISCRETE_DISTRIBUTION = DEFAULT_UNIFORM_DISCRETE_DISTRIBUTION;
    /**
     * Default String = "Normal distribution"
     */
    public String NORMAL_DISTRIBUTION = DEFAULT_NORMAL_DISTRIBUTION;
    // -------------------------------------------------
    /**
     * Default String = "Random integer"
     */
    public String RANDOM_INTEGER = DEFAULT_RANDOM_INTEGER;
    /**
     * Default String = "Random natural number"
     */
    public String RANDOM_NATURAL_NUMBER = DEFAULT_RANDOM_NATURAL_NUMBER;
    /**
     * Default String = "Random natural number including 0"
     */
    public String RANDOM_NATURAL_NUMBER_INCLUDING_0 = DEFAULT_RANDOM_NATURAL_NUMBER_INCLUDING_0;
    // -------------------------------------------------
    /**
     * Default String = "Special function"
     */
    public String SPECIAL_FUNCTION = DEFAULT_SPECIAL_FUNCTION;
    // -------------------------------------------------
    /**
     * Default String = "Semi major axis"
     */
    public String SEMI_MAJOR_AXIS = DEFAULT_SEMI_MAJOR_AXIS;
    // -------------------------------------------------
    /**
     * Default String = "Equality"
     */
    public String BINARY_RELATION_EQ = DEFAULT_BINARY_RELATION_EQ;
    /**
     * Default String = "Inequation"
     */
    public String BINARY_RELATION_NEQ = DEFAULT_BINARY_RELATION_NEQ;
    /**
     * Default String = "Lower than"
     */
    public String BINARY_RELATION_LT = DEFAULT_BINARY_RELATION_LT;
    /**
     * Default String = "Greater than"
     */
    public String BINARY_RELATION_GT = DEFAULT_BINARY_RELATION_GT;
    /**
     * Default String = "Lower or equal"
     */
    public String BINARY_RELATION_LEQ = DEFAULT_BINARY_RELATION_LEQ;
    /**
     * Default String = "Greater or equal"
     */
    public String BINARY_RELATION_GEQ = DEFAULT_BINARY_RELATION_GEQ;
    // -------------------------------------------------
    /**
     * Default String = "Bitwise unary complement (NOT)"
     */
    public String BITWISE_OPERATOR_COMPL = DEFAULT_BITWISE_OPERATOR_COMPL;
    /**
     * Default String = "Bitwise and (AND)"
     */
    public String BITWISE_OPERATOR_AND = DEFAULT_BITWISE_OPERATOR_AND;
    /**
     * Default String = "Bitwise exclusive or (XOR)"
     */
    public String BITWISE_OPERATOR_XOR = DEFAULT_BITWISE_OPERATOR_XOR;
    /**
     * Default String = "Bitwise inclusive or (OR)"
     */
    public String BITWISE_OPERATOR_OR = DEFAULT_BITWISE_OPERATOR_OR;
    /**
     * Default String = "Bitwise signed left shift"
     */
    public String BITWISE_OPERATOR_LEFT_SHIFT = DEFAULT_BITWISE_OPERATOR_LEFT_SHIFT;
    /**
     * Default String = "Bitwise signed right shift"
     */
    public String BITWISE_OPERATOR_RIGHT_SHIFT = DEFAULT_BITWISE_OPERATOR_RIGHT_SHIFT;
    /**
     * Default String = "Bitwise not and (NAND)"
     */
    public String BITWISE_OPERATOR_NAND = DEFAULT_BITWISE_OPERATOR_NAND;
    /**
     * Default String = "Bitwise not or (NOR)"
     */
    public String BITWISE_OPERATOR_NOR = DEFAULT_BITWISE_OPERATOR_NOR;
    /**
     * Default String = "Bitwise exclusive NOR (XNOR)"
     */
    public String BITWISE_OPERATOR_XNOR = DEFAULT_BITWISE_OPERATOR_XNOR;
    // -------------------------------------------------
    /**
     * Default String = "Logical conjunction"
     */
    public String BOOLEAN_OPERATOR_AND = DEFAULT_BOOLEAN_OPERATOR_AND;
    /**
     * Default String = "Logical disjunction"
     */
    public String BOOLEAN_OPERATOR_OR = DEFAULT_BOOLEAN_OPERATOR_OR;
    /**
     * Default String = "Negation"
     */
    public String BOOLEAN_OPERATOR_NEG = DEFAULT_BOOLEAN_OPERATOR_NEG;
    /**
     * Default String = "Sheffer stroke"
     */
    public String BOOLEAN_OPERATOR_NAND = DEFAULT_BOOLEAN_OPERATOR_NAND;
    /**
     * Default String = "Logical not or (joint denial)"
     */
    public String BOOLEAN_OPERATOR_NOR = DEFAULT_BOOLEAN_OPERATOR_NOR;
    /**
     * Default String = "Exclusive or"
     */
    public String BOOLEAN_OPERATOR_XOR = DEFAULT_BOOLEAN_OPERATOR_XOR;
    /**
     * Default String = "Implication"
     */
    public String BOOLEAN_OPERATOR_IMP = DEFAULT_BOOLEAN_OPERATOR_IMP;
    /**
     * Default String = "Converse implication"
     */
    public String BOOLEAN_OPERATOR_CIMP = DEFAULT_BOOLEAN_OPERATOR_CIMP;
    /**
     * Default String = "Material nonimplication"
     */
    public String BOOLEAN_OPERATOR_NIMP = DEFAULT_BOOLEAN_OPERATOR_NIMP;
    /**
     * Default String = "Converse nonimplication"
     */
    public String BOOLEAN_OPERATOR_CNIMP = DEFAULT_BOOLEAN_OPERATOR_CNIMP;
    /**
     * Default String = "Logical biconditional"
     */
    public String BOOLEAN_OPERATOR_EQV = DEFAULT_BOOLEAN_OPERATOR_EQV;
    // -------------------------------------------------
    /**
     * Default String = "Summation SIGMA"
     */
    public String CALCULUS_OPERATOR_SUM = DEFAULT_CALCULUS_OPERATOR_SUM;
    /**
     * Default String = "Product PI"
     */
    public String CALCULUS_OPERATOR_PROD = DEFAULT_CALCULUS_OPERATOR_PROD;
    /**
     * Default String = "Definite integral"
     */
    public String CALCULUS_OPERATOR_INT = DEFAULT_CALCULUS_OPERATOR_INT;
    /**
     * Default String = "Derivative"
     */
    public String CALCULUS_OPERATOR_DER = DEFAULT_CALCULUS_OPERATOR_DER;
    /**
     * Default String = "Left derivative"
     */
    public String CALCULUS_OPERATOR_DER_LEFT = DEFAULT_CALCULUS_OPERATOR_DER_LEFT;
    /**
     * Default String = "Right derivative"
     */
    public String CALCULUS_OPERATOR_DER_RIGHT = DEFAULT_CALCULUS_OPERATOR_DER_RIGHT;
    /**
     * Default String = "n-th derivative"
     */
    public String CALCULUS_OPERATOR_DERN = DEFAULT_CALCULUS_OPERATOR_DERN;
    /**
     * Default String = "Forward difference"
     */
    public String CALCULUS_OPERATOR_FORW_DIFF = DEFAULT_CALCULUS_OPERATOR_FORW_DIFF;
    /**
     * Default String = "Backward difference"
     */
    public String CALCULUS_OPERATOR_BACKW_DIFF = DEFAULT_CALCULUS_OPERATOR_BACKW_DIFF;
    /**
     * Default String = "Average"
     */
    public String CALCULUS_OPERATOR_AVG = DEFAULT_CALCULUS_OPERATOR_AVG;
    /**
     * Default String = "Bias-corrected sample variance"
     */
    public String CALCULUS_OPERATOR_VAR = DEFAULT_CALCULUS_OPERATOR_VAR;
    /**
     * Default String = "Bias-corrected sample standard deviation"
     */
    public String CALCULUS_OPERATOR_STD = DEFAULT_CALCULUS_OPERATOR_STD;
    /**
     * Default String = "Minimum value"
     */
    public String CALCULUS_OPERATOR_MIN = DEFAULT_CALCULUS_OPERATOR_MIN;
    /**
     * Default String = "Maximum value"
     */
    public String CALCULUS_OPERATOR_MAX = DEFAULT_CALCULUS_OPERATOR_MAX;
    /**
     * Default String = "Equation solving (root finding)"
     */
    public String CALCULUS_OPERATOR_SOLVE = DEFAULT_CALCULUS_OPERATOR_SOLVE;
    // -------------------------------------------------
    /**
     * Default String = "Pi, Archimedes' or Ludolph's number"
     */
    public String CONSTANT_VALUE_PI = DEFAULT_CONSTANT_VALUE_PI;
    /**
     * Default String = "Napier's or Euler's number (base of Natural logarithm)"
     */
    public String CONSTANT_VALUE_EULER = DEFAULT_CONSTANT_VALUE_EULER;
    /**
     * Default String = "Euler-Mascheroni constant"
     */
    public String CONSTANT_VALUE_EULER_MASCHERONI = DEFAULT_CONSTANT_VALUE_EULER_MASCHERONI;
    /**
     * Default String = "Golden ratio"
     */
    public String CONSTANT_VALUE_GOLDEN_RATIO = DEFAULT_CONSTANT_VALUE_GOLDEN_RATIO;
    /**
     * Default String = "Plastic constant"
     */
    public String CONSTANT_VALUE_PLASTIC = DEFAULT_CONSTANT_VALUE_PLASTIC;
    /**
     * Default String = "Embree-Trefethen constant"
     */
    public String CONSTANT_VALUE_EMBREE_TREFETHEN = DEFAULT_CONSTANT_VALUE_EMBREE_TREFETHEN;
    /**
     * Default String = "Feigenbaum delta constant"
     */
    public String CONSTANT_VALUE_FEIGENBAUM_DELTA = DEFAULT_CONSTANT_VALUE_FEIGENBAUM_DELTA;
    /**
     * Default String = "Feigenbaum alpha constant"
     */
    public String CONSTANT_VALUE_FEIGENBAUM_ALPHA = DEFAULT_CONSTANT_VALUE_FEIGENBAUM_ALPHA;
    /**
     * Default String = "Twin prime constant"
     */
    public String CONSTANT_VALUE_TWIN_PRIME = DEFAULT_CONSTANT_VALUE_TWIN_PRIME;
    /**
     * Default String = "Meissel-Mertens constant"
     */
    public String CONSTANT_VALUE_MEISSEL_MERTEENS = DEFAULT_CONSTANT_VALUE_MEISSEL_MERTEENS;
    /**
     * Default String = "Brun's constant for twin primes"
     */
    public String CONSTANT_VALUE_BRAUN_TWIN_PRIME = DEFAULT_CONSTANT_VALUE_BRAUN_TWIN_PRIME;
    /**
     * Default String = "Brun's constant for prime quadruplets"
     */
    public String CONSTANT_VALUE_BRAUN_PRIME_QUADR = DEFAULT_CONSTANT_VALUE_BRAUN_PRIME_QUADR;
    /**
     * Default String = "de Bruijn-Newman constant"
     */
    public String CONSTANT_VALUE_BRUIJN_NEWMAN = DEFAULT_CONSTANT_VALUE_BRUIJN_NEWMAN;
    /**
     * Default String = "Catalan's constant"
     */
    public String CONSTANT_VALUE_CATALAN = DEFAULT_CONSTANT_VALUE_CATALAN;
    /**
     * Default String = "Landau-Ramanujan constant"
     */
    public String CONSTANT_VALUE_LANDAU_RAMANUJAN = DEFAULT_CONSTANT_VALUE_LANDAU_RAMANUJAN;
    /**
     * Default String = "Viswanath's constant"
     */
    public String CONSTANT_VALUE_VISWANATH = DEFAULT_CONSTANT_VALUE_VISWANATH;
    /**
     * Default String = "Legendre's constant"
     */
    public String CONSTANT_VALUE_LEGENDRE = DEFAULT_CONSTANT_VALUE_LEGENDRE;
    /**
     * Default String = "Ramanujan-Soldner constant"
     */
    public String CONSTANT_VALUE_RAMANUJAN_SOLDNER = DEFAULT_CONSTANT_VALUE_RAMANUJAN_SOLDNER;
    /**
     * Default String = "Erdos-Borwein constant"
     */
    public String CONSTANT_VALUE_ERDOS_BORWEIN = DEFAULT_CONSTANT_VALUE_ERDOS_BORWEIN;
    /**
     * Default String = "Bernstein's constant"
     */
    public String CONSTANT_VALUE_BERNSTEIN = DEFAULT_CONSTANT_VALUE_BERNSTEIN;
    /**
     * Default String = "Gauss-Kuzmin-Wirsing constant"
     */
    public String CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = DEFAULT_CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING;
    /**
     * Default String = "Hafner-Sarnak-McCurley constant"
     */
    public String CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = DEFAULT_CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY;
    /**
     * Default String = "Golomb-Dickman constant"
     */
    public String CONSTANT_VALUE_GOLOMB_DICKMAN = DEFAULT_CONSTANT_VALUE_GOLOMB_DICKMAN;
    /**
     * Default String = "Cahen's constant"
     */
    public String CONSTANT_VALUE_CAHEN = DEFAULT_CONSTANT_VALUE_CAHEN;
    /**
     * Default String = "Laplace limit constant"
     */
    public String CONSTANT_VALUE_LAPLACE_LIMIT = DEFAULT_CONSTANT_VALUE_LAPLACE_LIMIT;
    /**
     * Default String = "Alladi-Grinstead constant"
     */
    public String CONSTANT_VALUE_ALLADI_GRINSTEAD = DEFAULT_CONSTANT_VALUE_ALLADI_GRINSTEAD;
    /**
     * Default String = "Lengyel's constant"
     */
    public String CONSTANT_VALUE_LENGYEL = DEFAULT_CONSTANT_VALUE_LENGYEL;
    /**
     * Default String = "Levy's constant"
     */
    public String CONSTANT_VALUE_LEVY = DEFAULT_CONSTANT_VALUE_LEVY;
    /**
     * Default String = "Apery's constant"
     */
    public String CONSTANT_VALUE_APERY = DEFAULT_CONSTANT_VALUE_APERY;
    /**
     * Default String = "Mills' constant"
     */
    public String CONSTANT_VALUE_MILLS = DEFAULT_CONSTANT_VALUE_MILLS;
    /**
     * Default String = "Backhouse's constant"
     */
    public String CONSTANT_VALUE_BACKHOUSE = DEFAULT_CONSTANT_VALUE_BACKHOUSE;
    /**
     * Default String = "Porter's constant"
     */
    public String CONSTANT_VALUE_PORTER = DEFAULT_CONSTANT_VALUE_PORTER;
    /**
     * Default String = "Lieb's square ice constant"
     */
    public String CONSTANT_VALUE_LIEB_QUARE_ICE = DEFAULT_CONSTANT_VALUE_LIEB_QUARE_ICE;
    /**
     * Default String = "Niven's constant"
     */
    public String CONSTANT_VALUE_NIVEN = DEFAULT_CONSTANT_VALUE_NIVEN;
    /**
     * Default String = "Sierpinski's constant"
     */
    public String CONSTANT_VALUE_SIERPINSKI = DEFAULT_CONSTANT_VALUE_SIERPINSKI;
    /**
     * Default String = "Khinchin's constant"
     */
    public String CONSTANT_VALUE_KHINCHIN = DEFAULT_CONSTANT_VALUE_KHINCHIN;
    /**
     * Default String = "Fransen-Robinson constant"
     */
    public String CONSTANT_VALUE_FRANSEN_ROBINSON = DEFAULT_CONSTANT_VALUE_FRANSEN_ROBINSON;
    /**
     * Default String = "Landau's constant"
     */
    public String CONSTANT_VALUE_LANDAU = DEFAULT_CONSTANT_VALUE_LANDAU;
    /**
     * Default String = "Parabolic constant"
     */
    public String CONSTANT_VALUE_PARABOLIC = DEFAULT_CONSTANT_VALUE_PARABOLIC;
    /**
     * Default String = "Omega constant"
     */
    public String CONSTANT_VALUE_OMEGA = DEFAULT_CONSTANT_VALUE_OMEGA;
    /**
     * Default String = "MRB constant"
     */
    public String CONSTANT_VALUE_MRB = DEFAULT_CONSTANT_VALUE_MRB;
    /**
     * Default String = "Logarithmic integral at point 2"
     */
    public String CONSTANT_VALUE_LI2 = DEFAULT_CONSTANT_VALUE_LI2;
    /**
     * Default String = "Gompertz constant"
     */
    public String CONSTANT_VALUE_GOMPERTZ = DEFAULT_CONSTANT_VALUE_GOMPERTZ;
    /**
     * Default String = "Light speed in vacuum"
     */
    public String CONSTANT_VALUE_LIGHT_SPEED = DEFAULT_CONSTANT_VALUE_LIGHT_SPEED;
    /**
     * Default String = "Gravitational constant"
     */
    public String CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = DEFAULT_CONSTANT_VALUE_GRAVITATIONAL_CONSTANT;
    /**
     * Default String = "Gravitational acceleration on Earth"
     */
    public String CONSTANT_VALUE_GRAVIT_ACC_EARTH = DEFAULT_CONSTANT_VALUE_GRAVIT_ACC_EARTH;
    /**
     * Default String = "Planck constant"
     */
    public String CONSTANT_VALUE_PLANCK_CONSTANT = DEFAULT_CONSTANT_VALUE_PLANCK_CONSTANT;
    /**
     * Default String = "Reduced Planck constant (Dirac constant)"
     */
    public String CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = DEFAULT_CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED;
    /**
     * Default String = "Planck length"
     */
    public String CONSTANT_VALUE_PLANCK_LENGTH = DEFAULT_CONSTANT_VALUE_PLANCK_LENGTH;
    /**
     * Default String = "Planck mass"
     */
    public String CONSTANT_VALUE_PLANCK_MASS = DEFAULT_CONSTANT_VALUE_PLANCK_MASS;
    /**
     * Default String = "Planck time"
     */
    public String CONSTANT_VALUE_PLANCK_TIME = DEFAULT_CONSTANT_VALUE_PLANCK_TIME;
    /**
     * Default String = "Light year"
     */
    public String CONSTANT_VALUE_LIGHT_YEAR = DEFAULT_CONSTANT_VALUE_LIGHT_YEAR;
    /**
     * Default String = "Astronomical unit"
     */
    public String CONSTANT_VALUE_ASTRONOMICAL_UNIT = DEFAULT_CONSTANT_VALUE_ASTRONOMICAL_UNIT;
    /**
     * Default String = "Parsec"
     */
    public String CONSTANT_VALUE_PARSEC = DEFAULT_CONSTANT_VALUE_PARSEC;
    /**
     * Default String = "Kiloparsec"
     */
    public String CONSTANT_VALUE_KILOPARSEC = DEFAULT_CONSTANT_VALUE_KILOPARSEC;
    /**
     * Default String = "Earth equatorial radius"
     */
    public String CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL;
    /**
     * Default String = "Earth polar radius"
     */
    public String CONSTANT_VALUE_EARTH_RADIUS_POLAR = DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_POLAR;
    /**
     * Default String = "Earth mean radius"
     */
    public String CONSTANT_VALUE_EARTH_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_MEAN;
    /**
     * Default String = "Earth mass"
     */
    public String CONSTANT_VALUE_EARTH_MASS = DEFAULT_CONSTANT_VALUE_EARTH_MASS;
    /**
     * Default String = "Earth-Sun distance"
     */
    public String CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Moon mean radius"
     */
    public String CONSTANT_VALUE_MOON_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_MOON_RADIUS_MEAN;
    /**
     * Default String = "Moon mass"
     */
    public String CONSTANT_VALUE_MOON_MASS = DEFAULT_CONSTANT_VALUE_MOON_MASS;
    /**
     * Default String = "Moon-Earth distance"
     */
    public String CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Solar mean radius"
     */
    public String CONSTANT_VALUE_SOLAR_RADIUS = DEFAULT_CONSTANT_VALUE_SOLAR_RADIUS;
    /**
     * Default String = "Solar mass"
     */
    public String CONSTANT_VALUE_SOLAR_MASS = DEFAULT_CONSTANT_VALUE_SOLAR_MASS;
    /**
     * Default String = "Mercury mean radius"
     */
    public String CONSTANT_VALUE_MERCURY_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_MERCURY_RADIUS_MEAN;
    /**
     * Default String = "Mercury mass"
     */
    public String CONSTANT_VALUE_MERCURY_MASS = DEFAULT_CONSTANT_VALUE_MERCURY_MASS;
    /**
     * Default String = "Mercury-Sun distance"
     */
    public String CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Venus mean radius"
     */
    public String CONSTANT_VALUE_VENUS_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_VENUS_RADIUS_MEAN;
    /**
     * Default String = "Venus mass"
     */
    public String CONSTANT_VALUE_VENUS_MASS = DEFAULT_CONSTANT_VALUE_VENUS_MASS;
    /**
     * Default String = "Venus-Sun distance"
     */
    public String CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Mars mean radius"
     */
    public String CONSTANT_VALUE_MARS_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_MARS_RADIUS_MEAN;
    /**
     * Default String = "Mars mass"
     */
    public String CONSTANT_VALUE_MARS_MASS = DEFAULT_CONSTANT_VALUE_MARS_MASS;
    /**
     * Default String = "Mars-Sun distance"
     */
    public String CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Jupiter mean radius"
     */
    public String CONSTANT_VALUE_JUPITER_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_JUPITER_RADIUS_MEAN;
    /**
     * Default String = "Jupiter mass"
     */
    public String CONSTANT_VALUE_JUPITER_MASS = DEFAULT_CONSTANT_VALUE_JUPITER_MASS;
    /**
     * Default String = "Jupiter-Sun distance"
     */
    public String CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Saturn mean radius"
     */
    public String CONSTANT_VALUE_SATURN_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_SATURN_RADIUS_MEAN;
    /**
     * Default String = "Saturn mass"
     */
    public String CONSTANT_VALUE_SATURN_MASS = DEFAULT_CONSTANT_VALUE_SATURN_MASS;
    /**
     * Default String = "Saturn-Sun distance"
     */
    public String CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Uranus mean radius"
     */
    public String CONSTANT_VALUE_URANUS_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_URANUS_RADIUS_MEAN;
    /**
     * Default String = "Uranus mass"
     */
    public String CONSTANT_VALUE_URANUS_MASS = DEFAULT_CONSTANT_VALUE_URANUS_MASS;
    /**
     * Default String = "Uranus-Sun distance"
     */
    public String CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Neptune mean radius"
     */
    public String CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = DEFAULT_CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN;
    /**
     * Default String = "Neptune mass"
     */
    public String CONSTANT_VALUE_NEPTUNE_MASS = DEFAULT_CONSTANT_VALUE_NEPTUNE_MASS;
    /**
     * Default String = "Neptune-Sun distance"
     */
    public String CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = DEFAULT_CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS;
    /**
     * Default String = "Boolean True represented as 1"
     */
    public String CONSTANT_VALUE_TRUE = DEFAULT_CONSTANT_VALUE_TRUE;
    /**
     * Default String = "Boolean False represented as 0"
     */
    public String CONSTANT_VALUE_FALSE = DEFAULT_CONSTANT_VALUE_FALSE;
    /**
     * Default String = "Automatically generated constant for user defined functions, returns number of given function parameters"
     */
    public String CONSTANT_VALUE_NPAR = DEFAULT_CONSTANT_VALUE_NPAR;
    /**
     * Default String = "Not-a-Number"
     */
    public String CONSTANT_VALUE_NAN = DEFAULT_CONSTANT_VALUE_NAN;
    // -------------------------------------------------
    /**
     * Default String = "Trigonometric sine"
     */
    public String FUNCTION_1_ARG_SIN = DEFAULT_FUNCTION_1_ARG_SIN;
    /**
     * Default String = "Trigonometric cosine"
     */
    public String FUNCTION_1_ARG_COS = DEFAULT_FUNCTION_1_ARG_COS;
    /**
     * Default String = "Trigonometric tangent"
     */
    public String FUNCTION_1_ARG_TAN = DEFAULT_FUNCTION_1_ARG_TAN;
    /**
     * Default String = "Trigonometric cotangent"
     */
    public String FUNCTION_1_ARG_CTAN = DEFAULT_FUNCTION_1_ARG_CTAN;
    /**
     * Default String = "Trigonometric secant"
     */
    public String FUNCTION_1_ARG_SEC = DEFAULT_FUNCTION_1_ARG_SEC;
    /**
     * Default String = "Trigonometric cosecant"
     */
    public String FUNCTION_1_ARG_COSEC = DEFAULT_FUNCTION_1_ARG_COSEC;
    /**
     * Default String = "Inverse trigonometric sine"
     */
    public String FUNCTION_1_ARG_ASIN = DEFAULT_FUNCTION_1_ARG_ASIN;
    /**
     * Default String = "Inverse trigonometric cosine"
     */
    public String FUNCTION_1_ARG_ACOS = DEFAULT_FUNCTION_1_ARG_ACOS;
    /**
     * Default String = "Inverse trigonometric tangent"
     */
    public String FUNCTION_1_ARG_ATAN = DEFAULT_FUNCTION_1_ARG_ATAN;
    /**
     * Default String = "Inverse trigonometric cotangent"
     */
    public String FUNCTION_1_ARG_ACTAN = DEFAULT_FUNCTION_1_ARG_ACTAN;
    /**
     * Default String = "Natural logarithm (base e)"
     */
    public String FUNCTION_1_ARG_LN = DEFAULT_FUNCTION_1_ARG_LN;
    /**
     * Default String = "Binary logarithm (base 2)"
     */
    public String FUNCTION_1_ARG_LOG2 = DEFAULT_FUNCTION_1_ARG_LOG2;
    /**
     * Default String = "Common logarithm (base 10)"
     */
    public String FUNCTION_1_ARG_LOG10 = DEFAULT_FUNCTION_1_ARG_LOG10;
    /**
     * Default String = "Degrees to radians"
     */
    public String FUNCTION_1_ARG_RAD = DEFAULT_FUNCTION_1_ARG_RAD;
    /**
     * Default String = "Exponential"
     */
    public String FUNCTION_1_ARG_EXP = DEFAULT_FUNCTION_1_ARG_EXP;
    /**
     * Default String = "Square root"
     */
    public String FUNCTION_1_ARG_SQRT = DEFAULT_FUNCTION_1_ARG_SQRT;
    /**
     * Default String = "Hyperbolic sine"
     */
    public String FUNCTION_1_ARG_SINH = DEFAULT_FUNCTION_1_ARG_SINH;
    /**
     * Default String = "Hyperbolic cosine"
     */
    public String FUNCTION_1_ARG_COSH = DEFAULT_FUNCTION_1_ARG_COSH;
    /**
     * Default String = "Hyperbolic tangent"
     */
    public String FUNCTION_1_ARG_TANH = DEFAULT_FUNCTION_1_ARG_TANH;
    /**
     * Default String = "Hyperbolic cotangent"
     */
    public String FUNCTION_1_ARG_COTH = DEFAULT_FUNCTION_1_ARG_COTH;
    /**
     * Default String = "Hyperbolic secant"
     */
    public String FUNCTION_1_ARG_SECH = DEFAULT_FUNCTION_1_ARG_SECH;
    /**
     * Default String = "Hyperbolic cosecant"
     */
    public String FUNCTION_1_ARG_CSCH = DEFAULT_FUNCTION_1_ARG_CSCH;
    /**
     * Default String = "Radians to degrees"
     */
    public String FUNCTION_1_ARG_DEG = DEFAULT_FUNCTION_1_ARG_DEG;
    /**
     * Default String = "Absolut value"
     */
    public String FUNCTION_1_ARG_ABS = DEFAULT_FUNCTION_1_ARG_ABS;
    /**
     * Default String = "Signum"
     */
    public String FUNCTION_1_ARG_SGN = DEFAULT_FUNCTION_1_ARG_SGN;
    /**
     * Default String = "Floor"
     */
    public String FUNCTION_1_ARG_FLOOR = DEFAULT_FUNCTION_1_ARG_FLOOR;
    /**
     * Default String = "Ceiling"
     */
    public String FUNCTION_1_ARG_CEIL = DEFAULT_FUNCTION_1_ARG_CEIL;
    /**
     * Default String = "Negation"
     */
    public String FUNCTION_1_ARG_NOT = DEFAULT_FUNCTION_1_ARG_NOT;
    /**
     * Default String = "Inverse hyperbolic sine"
     */
    public String FUNCTION_1_ARG_ARSINH = DEFAULT_FUNCTION_1_ARG_ARSINH;
    /**
     * Default String = "Inverse hyperbolic cosine"
     */
    public String FUNCTION_1_ARG_ARCOSH = DEFAULT_FUNCTION_1_ARG_ARCOSH;
    /**
     * Default String = "Inverse hyperbolic tangent"
     */
    public String FUNCTION_1_ARG_ARTANH = DEFAULT_FUNCTION_1_ARG_ARTANH;
    /**
     * Default String = "Inverse hyperbolic cotangent"
     */
    public String FUNCTION_1_ARG_ARCOTH = DEFAULT_FUNCTION_1_ARG_ARCOTH;
    /**
     * Default String = "Inverse hyperbolic secant"
     */
    public String FUNCTION_1_ARG_ARSECH = DEFAULT_FUNCTION_1_ARG_ARSECH;
    /**
     * Default String = "Inverse hyperbolic cosecant"
     */
    public String FUNCTION_1_ARG_ARCSCH = DEFAULT_FUNCTION_1_ARG_ARCSCH;
    /**
     * Default String = "Sinc (normalized)"
     */
    public String FUNCTION_1_ARG_SA = DEFAULT_FUNCTION_1_ARG_SA;
    /**
     * Default String = "Sinc (unnormalized)"
     */
    public String FUNCTION_1_ARG_SINC = DEFAULT_FUNCTION_1_ARG_SINC;
    /**
     * Default String = "Bell number"
     */
    public String FUNCTION_1_ARG_BELL_NUMBER = DEFAULT_FUNCTION_1_ARG_BELL_NUMBER;
    /**
     * Default String = "Lucas number"
     */
    public String FUNCTION_1_ARG_LUCAS_NUMBER = DEFAULT_FUNCTION_1_ARG_LUCAS_NUMBER;
    /**
     * Default String = "Fibonacci number"
     */
    public String FUNCTION_1_ARG_FIBONACCI_NUMBER = DEFAULT_FUNCTION_1_ARG_FIBONACCI_NUMBER;
    /**
     * Default String = "Harmonic number"
     */
    public String FUNCTION_1_ARG_HARMONIC_NUMBER = DEFAULT_FUNCTION_1_ARG_HARMONIC_NUMBER;
    /**
     * Default String = "Prime number test (is number a prime?)"
     */
    public String FUNCTION_1_ARG_IS_PRIME = DEFAULT_FUNCTION_1_ARG_IS_PRIME;
    /**
     * Default String = "Prime-counting"
     */
    public String FUNCTION_1_ARG_PRIME_COUNT = DEFAULT_FUNCTION_1_ARG_PRIME_COUNT;
    /**
     * Default String = "Exponential integral"
     */
    public String FUNCTION_1_ARG_EXP_INT = DEFAULT_FUNCTION_1_ARG_EXP_INT;
    /**
     * Default String = "Logarithmic integral"
     */
    public String FUNCTION_1_ARG_LOG_INT = DEFAULT_FUNCTION_1_ARG_LOG_INT;
    /**
     * Default String = "Offset logarithmic integral"
     */
    public String FUNCTION_1_ARG_OFF_LOG_INT = DEFAULT_FUNCTION_1_ARG_OFF_LOG_INT;
    /**
     * Default String = "Gauss error"
     */
    public String FUNCTION_1_ARG_GAUSS_ERF = DEFAULT_FUNCTION_1_ARG_GAUSS_ERF;
    /**
     * Default String = "Gauss complementary error"
     */
    public String FUNCTION_1_ARG_GAUSS_ERFC = DEFAULT_FUNCTION_1_ARG_GAUSS_ERFC;
    /**
     * Default String = "Inverse Gauss error"
     */
    public String FUNCTION_1_ARG_GAUSS_ERF_INV = DEFAULT_FUNCTION_1_ARG_GAUSS_ERF_INV;
    /**
     * Default String = "Inverse Gauss complementary error"
     */
    public String FUNCTION_1_ARG_GAUSS_ERFC_INV = DEFAULT_FUNCTION_1_ARG_GAUSS_ERFC_INV;
    /**
     * Default String = "Unit in The Last Place"
     */
    public String FUNCTION_1_ARG_ULP = DEFAULT_FUNCTION_1_ARG_ULP;
    /**
     * Default String = "Returns true if value is a Not-a-Number (NaN), false otherwise"
     */
    public String FUNCTION_1_ARG_ISNAN = DEFAULT_FUNCTION_1_ARG_ISNAN;
    /**
     * Default String = "Number of digits in numeral system with base 10"
     */
    public String FUNCTION_1_ARG_NDIG10 = DEFAULT_FUNCTION_1_ARG_NDIG10;
    /**
     * Default String = "Prime decomposition - number of distinct prime factors"
     */
    public String FUNCTION_1_ARG_NFACT = DEFAULT_FUNCTION_1_ARG_NFACT;
    /**
     * Default String = "Inverse trigonometric secant"
     */
    public String FUNCTION_1_ARG_ARCSEC = DEFAULT_FUNCTION_1_ARG_ARCSEC;
    /**
     * Default String = "Inverse trigonometric cosecant"
     */
    public String FUNCTION_1_ARG_ARCCSC = DEFAULT_FUNCTION_1_ARG_ARCCSC;
    /**
     * Default String = "Gamma"
     */
    public String FUNCTION_1_ARG_GAMMA = DEFAULT_FUNCTION_1_ARG_GAMMA;
    /**
     * Default String = "Lambert-W, principal branch 0, also called the omega or product logarithm"
     */
    public String FUNCTION_1_ARG_LAMBERT_W0 = DEFAULT_FUNCTION_1_ARG_LAMBERT_W0;
    /**
     * Default String = "Lambert-W, branch -1, also called the omega or product logarithm"
     */
    public String FUNCTION_1_ARG_LAMBERT_W1 = DEFAULT_FUNCTION_1_ARG_LAMBERT_W1;
    /**
     * Default String = "Signum of Gamma"
     */
    public String FUNCTION_1_ARG_SGN_GAMMA = DEFAULT_FUNCTION_1_ARG_SGN_GAMMA;
    /**
     * Default String = "Log Gamma"
     */
    public String FUNCTION_1_ARG_LOG_GAMMA = DEFAULT_FUNCTION_1_ARG_LOG_GAMMA;
    /**
     * Default String = "Digamma as the logarithmic derivative of the Gamma"
     */
    public String FUNCTION_1_ARG_DI_GAMMA = DEFAULT_FUNCTION_1_ARG_DI_GAMMA;
    /**
     * Default String = "Automatically generated function for user defined functions, returns function parameter value at index 'i'"
     */
    public String FUNCTION_1_ARG_PARAM = DEFAULT_FUNCTION_1_ARG_PARAM;
    // -------------------------------------------------
    /**
     * Default String = "Logarithm"
     */
    public String FUNCTION_2_ARG_LOG = DEFAULT_FUNCTION_2_ARG_LOG;
    /**
     * Default String = "Modulo"
     */
    public String FUNCTION_2_ARG_MOD = DEFAULT_FUNCTION_2_ARG_MOD;
    /**
     * Default String = "Binomial coefficient, number of k-combinations that can be drawn from n-elements set"
     */
    public String FUNCTION_2_ARG_BINOM_COEFF = DEFAULT_FUNCTION_2_ARG_BINOM_COEFF;
    /**
     * Default String = "Bernoulli numbers"
     */
    public String FUNCTION_2_ARG_BERNOULLI_NUMBER = DEFAULT_FUNCTION_2_ARG_BERNOULLI_NUMBER;
    /**
     * Default String = "Stirling numbers of the first kind"
     */
    public String FUNCTION_2_ARG_STIRLING1_NUMBER = DEFAULT_FUNCTION_2_ARG_STIRLING1_NUMBER;
    /**
     * Default String = "Stirling numbers of the second kind"
     */
    public String FUNCTION_2_ARG_STIRLING2_NUMBER = DEFAULT_FUNCTION_2_ARG_STIRLING2_NUMBER;
    /**
     * Default String = "Worpitzky number"
     */
    public String FUNCTION_2_ARG_WORPITZKY_NUMBER = DEFAULT_FUNCTION_2_ARG_WORPITZKY_NUMBER;
    /**
     * Default String = "Euler number"
     */
    public String FUNCTION_2_ARG_EULER_NUMBER = DEFAULT_FUNCTION_2_ARG_EULER_NUMBER;
    /**
     * Default String = "Kronecker delta"
     */
    public String FUNCTION_2_ARG_KRONECKER_DELTA = DEFAULT_FUNCTION_2_ARG_KRONECKER_DELTA;
    /**
     * Default String = "EulerPol"
     */
    public String FUNCTION_2_ARG_EULER_POLYNOMIAL = DEFAULT_FUNCTION_2_ARG_EULER_POLYNOMIAL;
    /**
     * Default String = "Harmonic number"
     */
    public String FUNCTION_2_ARG_HARMONIC_NUMBER = DEFAULT_FUNCTION_2_ARG_HARMONIC_NUMBER;
    /**
     * Default String = "Half-up rounding"
     */
    public String FUNCTION_2_ARG_ROUND = DEFAULT_FUNCTION_2_ARG_ROUND;
    /**
     * Default String = "Number of digits representing the number in numeral system with given base"
     */
    public String FUNCTION_2_ARG_NDIG = DEFAULT_FUNCTION_2_ARG_NDIG;
    /**
     * Default String = "Digit at position 1 ... n (left -&gt; right) or 0 ... -(n-1) (right -&gt; left) - base 10 numeral system"
     */
    public String FUNCTION_2_ARG_DIGIT10 = DEFAULT_FUNCTION_2_ARG_DIGIT10;
    /**
     * Default String = "Prime decomposition - factor value at position between 1 ... nfact(n) - ascending order by factor value"
     */
    public String FUNCTION_2_ARG_FACTVAL = DEFAULT_FUNCTION_2_ARG_FACTVAL;
    /**
     * Default String = "Prime decomposition - factor exponent / multiplicity at position between 1 ... nfact(n) - ascending order by factor value"
     */
    public String FUNCTION_2_ARG_FACTEXP = DEFAULT_FUNCTION_2_ARG_FACTEXP;
    /**
     * Default String = "N-th order root of a number"
     */
    public String FUNCTION_2_ARG_ROOT = DEFAULT_FUNCTION_2_ARG_ROOT;
    /**
     * Default String = "Lower incomplete gamma"
     */
    public String FUNCTION_2_ARG_INC_GAMMA_LOWER = DEFAULT_FUNCTION_2_ARG_INC_GAMMA_LOWER;
    /**
     * Default String = "Upper incomplete Gamma"
     */
    public String FUNCTION_2_ARG_INC_GAMMA_UPPER = DEFAULT_FUNCTION_2_ARG_INC_GAMMA_UPPER;
    /**
     * Default String = "Lower regularized P gamma"
     */
    public String FUNCTION_2_ARG_REG_GAMMA_LOWER = DEFAULT_FUNCTION_2_ARG_REG_GAMMA_LOWER;
    /**
     * Default String = "Upper regularized Q Gamma"
     */
    public String FUNCTION_2_ARG_REG_GAMMA_UPPER = DEFAULT_FUNCTION_2_ARG_REG_GAMMA_UPPER;
    /**
     * Default String = "Number of k-permutations that can be drawn from n-elements set"
     */
    public String FUNCTION_2_ARG_PERMUTATIONS = DEFAULT_FUNCTION_2_ARG_PERMUTATIONS;
    /**
     * Default String = "The Beta, also called the Euler integral of the first kind"
     */
    public String FUNCTION_2_ARG_BETA = DEFAULT_FUNCTION_2_ARG_BETA;
    /**
     * Default String = "The Log Beta, also called the Log Euler integral of the first kind"
     */
    public String FUNCTION_2_ARG_LOG_BETA = DEFAULT_FUNCTION_2_ARG_LOG_BETA;
    // -------------------------------------------------
    /**
     * Default String = "If"
     */
    public String FUNCTION_3_ARG_IF = DEFAULT_FUNCTION_3_ARG_IF;
    /**
     * Default String = "Characteristic function for x in (a,b)"
     */
    public String FUNCTION_3_ARG_CHI = DEFAULT_FUNCTION_3_ARG_CHI;
    /**
     * Default String = "Characteristic function for x in [a,b]"
     */
    public String FUNCTION_3_ARG_CHI_LR = DEFAULT_FUNCTION_3_ARG_CHI_LR;
    /**
     * Default String = "Characteristic function for x in [a,b)"
     */
    public String FUNCTION_3_ARG_CHI_L = DEFAULT_FUNCTION_3_ARG_CHI_L;
    /**
     * Default String = "Characteristic function for x in (a,b]"
     */
    public String FUNCTION_3_ARG_CHI_R = DEFAULT_FUNCTION_3_ARG_CHI_R;
    /**
     * Default String = "Digit at position 1 ... n (left -&gt; right) or 0 ... -(n-1) (right -&gt; left) - numeral system with given base"
     */
    public String FUNCTION_3_ARG_DIGIT = DEFAULT_FUNCTION_3_ARG_DIGIT;
    /**
     * Default String = "The incomplete Beta, also called the incomplete Euler integral of the first kind"
     */
    public String FUNCTION_3_ARG_INC_BETA = DEFAULT_FUNCTION_3_ARG_INC_BETA;
    /**
     * Default String = "The regularized incomplete Beta (or regularized beta), also called the regularized incomplete Euler integral of the first kind"
     */
    public String FUNCTION_3_ARG_REG_BETA = DEFAULT_FUNCTION_3_ARG_REG_BETA;
    // -------------------------------------------------
    /**
     * Default String = "If function"
     */
    public String FUNCTION_VARIADIC_IFF = DEFAULT_FUNCTION_VARIADIC_IFF;
    /**
     * Default String = "Minimum"
     */
    public String FUNCTION_VARIADIC_MIN = DEFAULT_FUNCTION_VARIADIC_MIN;
    /**
     * Default String = "Maximum"
     */
    public String FUNCTION_VARIADIC_MAX = DEFAULT_FUNCTION_VARIADIC_MAX;
    /**
     * Default String = "Continued fraction"
     */
    public String FUNCTION_VARIADIC_CONT_FRAC = DEFAULT_FUNCTION_VARIADIC_CONT_FRAC;
    /**
     * Default String = "Continued polynomial"
     */
    public String FUNCTION_VARIADIC_CONT_POL = DEFAULT_FUNCTION_VARIADIC_CONT_POL;
    /**
     * Default String = "Greatest common divisor"
     */
    public String FUNCTION_VARIADIC_GCD = DEFAULT_FUNCTION_VARIADIC_GCD;
    /**
     * Default String = "Least common multiple"
     */
    public String FUNCTION_VARIADIC_LCM = DEFAULT_FUNCTION_VARIADIC_LCM;
    /**
     * Default String = "Summation"
     */
    public String FUNCTION_VARIADIC_SUM = DEFAULT_FUNCTION_VARIADIC_SUM;
    /**
     * Default String = "Multiplication"
     */
    public String FUNCTION_VARIADIC_PROD = DEFAULT_FUNCTION_VARIADIC_PROD;
    /**
     * Default String = "Mean / average value"
     */
    public String FUNCTION_VARIADIC_AVG = DEFAULT_FUNCTION_VARIADIC_AVG;
    /**
     * Default String = "Bias-corrected sample variance"
     */
    public String FUNCTION_VARIADIC_VAR = DEFAULT_FUNCTION_VARIADIC_VAR;
    /**
     * Default String = "Bias-corrected sample standard deviation"
     */
    public String FUNCTION_VARIADIC_STD = DEFAULT_FUNCTION_VARIADIC_STD;
    /**
     * Default String = "Random number from a given list of numbers"
     */
    public String FUNCTION_VARIADIC_RND_LIST = DEFAULT_FUNCTION_VARIADIC_RND_LIST;
    /**
     * Default String = "Returns the first non-NaN value"
     */
    public String FUNCTION_VARIADIC_COALESCE = DEFAULT_FUNCTION_VARIADIC_COALESCE;
    /**
     * Default String = "Logical disjunction (OR) - variadic"
     */
    public String FUNCTION_VARIADIC_OR = DEFAULT_FUNCTION_VARIADIC_OR;
    /**
     * Default String = "Logical conjunction (AND) - variadic"
     */
    public String FUNCTION_VARIADIC_AND = DEFAULT_FUNCTION_VARIADIC_AND;
    /**
     * Default String = "Exclusive or (XOR) - variadic"
     */
    public String FUNCTION_VARIADIC_XOR = DEFAULT_FUNCTION_VARIADIC_XOR;
    /**
     * Default String = "Arguments / indices of the minima"
     */
    public String FUNCTION_VARIADIC_ARGMIN = DEFAULT_FUNCTION_VARIADIC_ARGMIN;
    /**
     * Default String = "Arguments / indices of the maxima"
     */
    public String FUNCTION_VARIADIC_ARGMAX = DEFAULT_FUNCTION_VARIADIC_ARGMAX;
    /**
     * Default String = "The sample median"
     */
    public String FUNCTION_VARIADIC_MEDIAN = DEFAULT_FUNCTION_VARIADIC_MEDIAN;
    /**
     * Default String = "Mode - the value that appears most often"
     */
    public String FUNCTION_VARIADIC_MODE = DEFAULT_FUNCTION_VARIADIC_MODE;
    /**
     * Default String = "Returns number in given numeral system base represented by list of digits"
     */
    public String FUNCTION_VARIADIC_BASE = DEFAULT_FUNCTION_VARIADIC_BASE;
    /**
     * Default String = "Number of distinct values"
     */
    public String FUNCTION_VARIADIC_NDIST = DEFAULT_FUNCTION_VARIADIC_NDIST;
    // -------------------------------------------------
    /**
     * Default String = "Addition"
     */
    public String OPERATOR_PLUS = DEFAULT_OPERATOR_PLUS;
    /**
     * Default String = "Subtraction"
     */
    public String OPERATOR_MINUS = DEFAULT_OPERATOR_MINUS;
    /**
     * Default String = "Multiplication"
     */
    public String OPERATOR_MULTIPLY = DEFAULT_OPERATOR_MULTIPLY;
    /**
     * Default String = "Division"
     */
    public String OPERATOR_DIVIDE = DEFAULT_OPERATOR_DIVIDE;
    /**
     * Default String = "Integer division (quotient)"
     */
    public String OPERATOR_DIVIDE_QUOTIENT = DEFAULT_OPERATOR_DIVIDE_QUOTIENT;
    /**
     * Default String = "Exponentiation"
     */
    public String OPERATOR_POWER = DEFAULT_OPERATOR_POWER;
    /**
     * Default String = "Factorial"
     */
    public String OPERATOR_FACT = DEFAULT_OPERATOR_FACT;
    /**
     * Default String = "Modulo"
     */
    public String OPERATOR_MOD = DEFAULT_OPERATOR_MOD;
    /**
     * Default String = "Percentage"
     */
    public String OPERATOR_PERC = DEFAULT_OPERATOR_PERC;
    /**
     * Default String = "Tetration (hyper-4, power tower, exponential tower)"
     */
    public String OPERATOR_TETRATION = DEFAULT_OPERATOR_TETRATION;
    /**
     * Default String = "Square root"
     */
    public String OPERATOR_SQUARE_ROOT = DEFAULT_OPERATOR_SQUARE_ROOT;
    /**
     * Default String = "Cube root"
     */
    public String OPERATOR_CUBE_ROOT = DEFAULT_OPERATOR_CUBE_ROOT;
    /**
     * Default String = "Fourth root"
     */
    public String OPERATOR_FOURTH_ROOT = DEFAULT_OPERATOR_FOURTH_ROOT;
    // -------------------------------------------------
    /**
     * Default String = "Left parentheses"
     */
    public String PARSER_SYMBOL_LEFT_PARENTHESES = DEFAULT_PARSER_SYMBOL_LEFT_PARENTHESES;
    /**
     * Default String = "Right parentheses"
     */
    public String PARSER_SYMBOL_RIGHT_PARENTHESES = DEFAULT_PARSER_SYMBOL_RIGHT_PARENTHESES;
    /**
     * Default String = "Comma (function parameters)"
     */
    public String PARSER_SYMBOL_COMMA = DEFAULT_PARSER_SYMBOL_COMMA;
    /**
     * Default String = "Semicolon (function parameters)"
     */
    public String PARSER_SYMBOL_SEMI = DEFAULT_PARSER_SYMBOL_SEMI;
    /**
     * Default String = "Blank (whitespace) character"
     */
    public String PARSER_SYMBOL_BLANK = DEFAULT_PARSER_SYMBOL_BLANK;
    /**
     * Default String = "Integer"
     */
    public String PARSER_SYMBOL_NUMBER_INTEGER = DEFAULT_PARSER_SYMBOL_NUMBER_INTEGER;
    /**
     * Default String = "Decimal"
     */
    public String PARSER_SYMBOL_NUMBER_DECIMAL = DEFAULT_PARSER_SYMBOL_NUMBER_DECIMAL;
    /**
     * Default String = "Leading zero"
     */
    public String PARSER_SYMBOL_NUMBER_LEADING_ZERO = DEFAULT_PARSER_SYMBOL_NUMBER_LEADING_ZERO;
    /**
     * Default String = "Scientific notation"
     */
    public String PARSER_SYMBOL_NUMBER_SCI_NOTATION = DEFAULT_PARSER_SYMBOL_NUMBER_SCI_NOTATION;
    /**
     * Default String = "No leading zero"
     */
    public String PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = DEFAULT_PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO;
    /**
     * Default String = "Fractions"
     */
    public String PARSER_SYMBOL_NUMBER_FRACTIONS = DEFAULT_PARSER_SYMBOL_NUMBER_FRACTIONS;
    /**
     * Default String = "Other numeral systems"
     */
    public String PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = DEFAULT_PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS;
    /**
     * Default String = " - Unicode math symbol"
     */
    public String PARSER_SYMBOL_UNICODE_MATH = DEFAULT_PARSER_SYMBOL_UNICODE_MATH;
    // -------------------------------------------------
    /**
     * Default String = "Percentage"
     */
    public String DIMENSIONLESS_UNIT_PERC = DEFAULT_DIMENSIONLESS_UNIT_PERC;
    /**
     * Default String = "Per mille"
     */
    public String DIMENSIONLESS_UNIT_PERM = DEFAULT_DIMENSIONLESS_UNIT_PERM;
    /**
     * Default String = "Septillion / Yotta"
     */
    public String DIMENSIONLESS_UNIT_YOTTA = DEFAULT_DIMENSIONLESS_UNIT_YOTTA;
    /**
     * Default String = "Sextillion / Zetta"
     */
    public String DIMENSIONLESS_UNIT_ZETTA = DEFAULT_DIMENSIONLESS_UNIT_ZETTA;
    /**
     * Default String = "Quintillion / Exa"
     */
    public String DIMENSIONLESS_UNIT_EXA = DEFAULT_DIMENSIONLESS_UNIT_EXA;
    /**
     * Default String = "Quadrillion / Peta"
     */
    public String DIMENSIONLESS_UNIT_PETA = DEFAULT_DIMENSIONLESS_UNIT_PETA;
    /**
     * Default String = "Trillion / Tera"
     */
    public String DIMENSIONLESS_UNIT_TERA = DEFAULT_DIMENSIONLESS_UNIT_TERA;
    /**
     * Default String = "Billion / Giga"
     */
    public String DIMENSIONLESS_UNIT_GIGA = DEFAULT_DIMENSIONLESS_UNIT_GIGA;
    /**
     * Default String = "Million / Mega"
     */
    public String DIMENSIONLESS_UNIT_MEGA = DEFAULT_DIMENSIONLESS_UNIT_MEGA;
    /**
     * Default String = "Thousand / Kilo"
     */
    public String DIMENSIONLESS_UNIT_KILO = DEFAULT_DIMENSIONLESS_UNIT_KILO;
    /**
     * Default String = "Hundred / Hecto"
     */
    public String DIMENSIONLESS_UNIT_HECTO = DEFAULT_DIMENSIONLESS_UNIT_HECTO;
    /**
     * Default String = "Ten / Deca"
     */
    public String DIMENSIONLESS_UNIT_DECA = DEFAULT_DIMENSIONLESS_UNIT_DECA;
    /**
     * Default String = "Tenth / Deci"
     */
    public String DIMENSIONLESS_UNIT_DECI = DEFAULT_DIMENSIONLESS_UNIT_DECI;
    /**
     * Default String = "Hundredth / Centi"
     */
    public String DIMENSIONLESS_UNIT_CENTI = DEFAULT_DIMENSIONLESS_UNIT_CENTI;
    /**
     * Default String = "Thousandth / Milli"
     */
    public String DIMENSIONLESS_UNIT_MILLI = DEFAULT_DIMENSIONLESS_UNIT_MILLI;
    /**
     * Default String = "Millionth / Micro"
     */
    public String DIMENSIONLESS_UNIT_MICRO = DEFAULT_DIMENSIONLESS_UNIT_MICRO;
    /**
     * Default String = "Billionth / Nano"
     */
    public String DIMENSIONLESS_UNIT_NANO = DEFAULT_DIMENSIONLESS_UNIT_NANO;
    /**
     * Default String = "Trillionth / Pico"
     */
    public String DIMENSIONLESS_UNIT_PICO = DEFAULT_DIMENSIONLESS_UNIT_PICO;
    /**
     * Default String = "Quadrillionth / Femto"
     */
    public String DIMENSIONLESS_UNIT_FEMTO = DEFAULT_DIMENSIONLESS_UNIT_FEMTO;
    /**
     * Default String = "Quintillionth / Atoo"
     */
    public String DIMENSIONLESS_UNIT_ATTO = DEFAULT_DIMENSIONLESS_UNIT_ATTO;
    /**
     * Default String = "Sextillionth / Zepto"
     */
    public String DIMENSIONLESS_UNIT_ZEPTO = DEFAULT_DIMENSIONLESS_UNIT_ZEPTO;
    /**
     * Default String = "Septillionth / Yocto"
     */
    public String DIMENSIONLESS_UNIT_YOCTO = DEFAULT_DIMENSIONLESS_UNIT_YOCTO;
    // -------------------------------------------------
    /**
     * Default String = "Meter"
     */
    public String UNIT_METRE = DEFAULT_UNIT_METRE;
    /**
     * Default String = "Kilometer"
     */
    public String UNIT_KILOMETRE = DEFAULT_UNIT_KILOMETRE;
    /**
     * Default String = "Centimeter"
     */
    public String UNIT_CENTIMETRE = DEFAULT_UNIT_CENTIMETRE;
    /**
     * Default String = "Millimeter"
     */
    public String UNIT_MILLIMETRE = DEFAULT_UNIT_MILLIMETRE;
    /**
     * Default String = "Inch"
     */
    public String UNIT_INCH = DEFAULT_UNIT_INCH;
    /**
     * Default String = "Yard"
     */
    public String UNIT_YARD = DEFAULT_UNIT_YARD;
    /**
     * Default String = "Feet"
     */
    public String UNIT_FEET = DEFAULT_UNIT_FEET;
    /**
     * Default String = "Mile"
     */
    public String UNIT_MILE = DEFAULT_UNIT_MILE;
    /**
     * Default String = "Nautical mile"
     */
    public String UNIT_NAUTICAL_MILE = DEFAULT_UNIT_NAUTICAL_MILE;
    /**
     * Default String = "Square meter"
     */
    public String UNIT_METRE2 = DEFAULT_UNIT_METRE2;
    /**
     * Default String = "Square centimeter"
     */
    public String UNIT_CENTIMETRE2 = DEFAULT_UNIT_CENTIMETRE2;
    /**
     * Default String = "Square millimeter"
     */
    public String UNIT_MILLIMETRE2 = DEFAULT_UNIT_MILLIMETRE2;
    /**
     * Default String = "Are"
     */
    public String UNIT_ARE = DEFAULT_UNIT_ARE;
    /**
     * Default String = "Hectare"
     */
    public String UNIT_HECTARE = DEFAULT_UNIT_HECTARE;
    /**
     * Default String = "Acre"
     */
    public String UNIT_ACRE = DEFAULT_UNIT_ACRE;
    /**
     * Default String = "Square kilometer"
     */
    public String UNIT_KILOMETRE2 = DEFAULT_UNIT_KILOMETRE2;
    /**
     * Default String = "Cubic millimeter"
     */
    public String UNIT_MILLIMETRE3 = DEFAULT_UNIT_MILLIMETRE3;
    /**
     * Default String = "Cubic centimeter"
     */
    public String UNIT_CENTIMETRE3 = DEFAULT_UNIT_CENTIMETRE3;
    /**
     * Default String = "Cubic meter"
     */
    public String UNIT_METRE3 = DEFAULT_UNIT_METRE3;
    /**
     * Default String = "Cubic kilometer"
     */
    public String UNIT_KILOMETRE3 = DEFAULT_UNIT_KILOMETRE3;
    /**
     * Default String = "Milliliter"
     */
    public String UNIT_MILLILITRE = DEFAULT_UNIT_MILLILITRE;
    /**
     * Default String = "Liter"
     */
    public String UNIT_LITRE = DEFAULT_UNIT_LITRE;
    /**
     * Default String = "Gallon"
     */
    public String UNIT_GALLON = DEFAULT_UNIT_GALLON;
    /**
     * Default String = "Pint"
     */
    public String UNIT_PINT = DEFAULT_UNIT_PINT;
    /**
     * Default String = "Second"
     */
    public String UNIT_SECOND = DEFAULT_UNIT_SECOND;
    /**
     * Default String = "Millisecond"
     */
    public String UNIT_MILLISECOND = DEFAULT_UNIT_MILLISECOND;
    /**
     * Default String = "Minute"
     */
    public String UNIT_MINUTE = DEFAULT_UNIT_MINUTE;
    /**
     * Default String = "Hour"
     */
    public String UNIT_HOUR = DEFAULT_UNIT_HOUR;
    /**
     * Default String = "Day"
     */
    public String UNIT_DAY = DEFAULT_UNIT_DAY;
    /**
     * Default String = "Week"
     */
    public String UNIT_WEEK = DEFAULT_UNIT_WEEK;
    /**
     * Default String = "Julian year = 365.25 days"
     */
    public String UNIT_JULIAN_YEAR = DEFAULT_UNIT_JULIAN_YEAR;
    /**
     * Default String = "Kilogram"
     */
    public String UNIT_KILOGRAM = DEFAULT_UNIT_KILOGRAM;
    /**
     * Default String = "Gram"
     */
    public String UNIT_GRAM = DEFAULT_UNIT_GRAM;
    /**
     * Default String = "Milligram"
     */
    public String UNIT_MILLIGRAM = DEFAULT_UNIT_MILLIGRAM;
    /**
     * Default String = "Decagram"
     */
    public String UNIT_DECAGRAM = DEFAULT_UNIT_DECAGRAM;
    /**
     * Default String = "Tonne"
     */
    public String UNIT_TONNE = DEFAULT_UNIT_TONNE;
    /**
     * Default String = "Ounce"
     */
    public String UNIT_OUNCE = DEFAULT_UNIT_OUNCE;
    /**
     * Default String = "Pound"
     */
    public String UNIT_POUND = DEFAULT_UNIT_POUND;
    /**
     * Default String = "Bit"
     */
    public String UNIT_BIT = DEFAULT_UNIT_BIT;
    /**
     * Default String = "Kilobit"
     */
    public String UNIT_KILOBIT = DEFAULT_UNIT_KILOBIT;
    /**
     * Default String = "Megabit"
     */
    public String UNIT_MEGABIT = DEFAULT_UNIT_MEGABIT;
    /**
     * Default String = "Gigabit"
     */
    public String UNIT_GIGABIT = DEFAULT_UNIT_GIGABIT;
    /**
     * Default String = "Terabit"
     */
    public String UNIT_TERABIT = DEFAULT_UNIT_TERABIT;
    /**
     * Default String = "Petabit"
     */
    public String UNIT_PETABIT = DEFAULT_UNIT_PETABIT;
    /**
     * Default String = "Exabit"
     */
    public String UNIT_EXABIT = DEFAULT_UNIT_EXABIT;
    /**
     * Default String = "Zettabit"
     */
    public String UNIT_ZETTABIT = DEFAULT_UNIT_ZETTABIT;
    /**
     * Default String = "Yottabit"
     */
    public String UNIT_YOTTABIT = DEFAULT_UNIT_YOTTABIT;
    /**
     * Default String = "Byte"
     */
    public String UNIT_BYTE = DEFAULT_UNIT_BYTE;
    /**
     * Default String = "Kilobyte"
     */
    public String UNIT_KILOBYTE = DEFAULT_UNIT_KILOBYTE;
    /**
     * Default String = "Megabyte"
     */
    public String UNIT_MEGABYTE = DEFAULT_UNIT_MEGABYTE;
    /**
     * Default String = "Gigabyte"
     */
    public String UNIT_GIGABYTE = DEFAULT_UNIT_GIGABYTE;
    /**
     * Default String = "Terabyte"
     */
    public String UNIT_TERABYTE = DEFAULT_UNIT_TERABYTE;
    /**
     * Default String = "Petabyte"
     */
    public String UNIT_PETABYTE = DEFAULT_UNIT_PETABYTE;
    /**
     * Default String = "Exabyte"
     */
    public String UNIT_EXABYTE = DEFAULT_UNIT_EXABYTE;
    /**
     * Default String = "Zettabyte"
     */
    public String UNIT_ZETTABYTE = DEFAULT_UNIT_ZETTABYTE;
    /**
     * Default String = "Yottabyte"
     */
    public String UNIT_YOTTABYTE = DEFAULT_UNIT_YOTTABYTE;
    /**
     * Default String = "Joule"
     */
    public String UNIT_JOULE = DEFAULT_UNIT_JOULE;
    /**
     * Default String = "Electronovolt"
     */
    public String UNIT_ELECTRONO_VOLT = DEFAULT_UNIT_ELECTRONO_VOLT;
    /**
     * Default String = "Kiloelectronovolt"
     */
    public String UNIT_KILO_ELECTRONO_VOLT = DEFAULT_UNIT_KILO_ELECTRONO_VOLT;
    /**
     * Default String = "Megaelectronovolt"
     */
    public String UNIT_MEGA_ELECTRONO_VOLT = DEFAULT_UNIT_MEGA_ELECTRONO_VOLT;
    /**
     * Default String = "Gigaelectronovolt"
     */
    public String UNIT_GIGA_ELECTRONO_VOLT = DEFAULT_UNIT_GIGA_ELECTRONO_VOLT;
    /**
     * Default String = "Teraelectronovolt"
     */
    public String UNIT_TERA_ELECTRONO_VOLT = DEFAULT_UNIT_TERA_ELECTRONO_VOLT;
    /**
     * Default String = "Meter per second"
     */
    public String UNIT_METRE_PER_SECOND = DEFAULT_UNIT_METRE_PER_SECOND;
    /**
     * Default String = "Kilometer per hour"
     */
    public String UNIT_KILOMETRE_PER_HOUR = DEFAULT_UNIT_KILOMETRE_PER_HOUR;
    /**
     * Default String = "Mile per hour"
     */
    public String UNIT_MILE_PER_HOUR = DEFAULT_UNIT_MILE_PER_HOUR;
    /**
     * Default String = "Knot"
     */
    public String UNIT_KNOT = DEFAULT_UNIT_KNOT;
    /**
     * Default String = "Meter per square second"
     */
    public String UNIT_METRE_PER_SECOND2 = DEFAULT_UNIT_METRE_PER_SECOND2;
    /**
     * Default String = "Kilometer per square hour"
     */
    public String UNIT_KILOMETRE_PER_HOUR2 = DEFAULT_UNIT_KILOMETRE_PER_HOUR2;
    /**
     * Default String = "Mile per square hour"
     */
    public String UNIT_MILE_PER_HOUR2 = DEFAULT_UNIT_MILE_PER_HOUR2;
    /**
     * Default String = "Radian"
     */
    public String UNIT_RADIAN_ARC = DEFAULT_UNIT_RADIAN_ARC;
    /**
     * Default String = "Degree of arc"
     */
    public String UNIT_DEGREE_ARC = DEFAULT_UNIT_DEGREE_ARC;
    /**
     * Default String = "Minute of arc"
     */
    public String UNIT_MINUTE_ARC = DEFAULT_UNIT_MINUTE_ARC;
    /**
     * Default String = "Second of arc"
     */
    public String UNIT_SECOND_ARC = DEFAULT_UNIT_SECOND_ARC;
    // ===========================================================
    /**
     * Displays user-defined text resources in the console.
     * The default value is shown and, if the current value
     * is different from the default value, the current value
     * is also shown. The method can be very useful when
     * analyzing the correctness and completeness of defined
     * resources, especially when translating into other languages.
     */
    public void print() {
        printResources(this, true);
    }
    /**
     * Displays the initial text resource definitions
     * as source code. The method can be very useful when
     * creating your own text resources, as it can be used
     * as a basis for translation.
     */
    public void printInitSrc() {
        printResources(this, false);
    }
    // ===========================================================
    private static final String newLine = "\\n\"" + StringInvariant.NEW_LINE + "+ \"";
    private static final String endLine = newLine + "\";";
    private static String quoteString(String str) {
        String tmpStr = "\"" + str.replace(StringInvariant.NEW_LINE, "\n") + "\";";
        return tmpStr.replace("\n", newLine).replace(endLine, "\";");
    }
    private static void printCurrentVsDefault(String nameStr, String currentValue, String defaultValue, boolean printDefault) {
        String currentValueNew;
        if (!printDefault) {
            currentValueNew = quoteString(currentValue);
            StringUtils.consolePrintln(nameStr + " = " + currentValueNew);
            return;
        }
        String defaultValueNew = quoteString(defaultValue);
        if (currentValue.equals(defaultValue)) {
            StringUtils.consolePrintln(nameStr + " = [DEF]" + defaultValueNew);
            return;
        }
        currentValueNew = quoteString(currentValue);
        StringUtils.consolePrintln(nameStr + " = [VAL]" + currentValueNew + " [DEF]" + defaultValueNew);
    }
    private static final String LINE_BREAK = "// -------------------------------------------------";
    private static void printResources(StringResources stringResources, boolean printDefault) {
        printCurrentVsDefault("USER_LANGUAGE", stringResources.USER_LANGUAGE, DEFAULT_USER_LANGUAGE, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("STARTING_SYNTAX_CHECK", stringResources.STARTING_SYNTAX_CHECK, DEFAULT_STARTING_SYNTAX_CHECK, printDefault);
        printCurrentVsDefault("NO_ERRORS_DETECTED", stringResources.NO_ERRORS_DETECTED, DEFAULT_NO_ERRORS_DETECTED, printDefault);
        printCurrentVsDefault("NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION", stringResources.NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION, DEFAULT_NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION, printDefault);
        printCurrentVsDefault("NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION", stringResources.NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION, DEFAULT_NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION, printDefault);
        printCurrentVsDefault("NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION", stringResources.NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION, DEFAULT_NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION, printDefault);
        printCurrentVsDefault("NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION", stringResources.NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION, DEFAULT_NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION, printDefault);
        printCurrentVsDefault("LEXICAL_ERROR_HAS_BEEN_FOUND", stringResources.LEXICAL_ERROR_HAS_BEEN_FOUND, DEFAULT_LEXICAL_ERROR_HAS_BEEN_FOUND, printDefault);
        printCurrentVsDefault("ERRORS_HAVE_BEEN_FOUND", stringResources.ERRORS_HAVE_BEEN_FOUND, DEFAULT_ERRORS_HAVE_BEEN_FOUND, printDefault);
        printCurrentVsDefault("ALREADY_CHECKED_NO_ERRORS", stringResources.ALREADY_CHECKED_NO_ERRORS, DEFAULT_ALREADY_CHECKED_NO_ERRORS, printDefault);
        printCurrentVsDefault("SYNTAX_STATUS_UNKNOWN", stringResources.SYNTAX_STATUS_UNKNOWN, DEFAULT_SYNTAX_STATUS_UNKNOWN, printDefault);
        printCurrentVsDefault("PROBLEM_WITH_EXPRESSION_SYNTAX", stringResources.PROBLEM_WITH_EXPRESSION_SYNTAX, DEFAULT_PROBLEM_WITH_EXPRESSION_SYNTAX, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("ENCOUNTERED", stringResources.ENCOUNTERED, DEFAULT_ENCOUNTERED, printDefault);
        printCurrentVsDefault("AT_INDEX", stringResources.AT_INDEX, DEFAULT_AT_INDEX, printDefault);
        printCurrentVsDefault("WAS_EXPECTING", stringResources.WAS_EXPECTING, DEFAULT_WAS_EXPECTING, printDefault);
        printCurrentVsDefault("WAS_EXPECTING_ONE_OF", stringResources.WAS_EXPECTING_ONE_OF, DEFAULT_WAS_EXPECTING_ONE_OF, printDefault);
        printCurrentVsDefault("UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED", stringResources.UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED, DEFAULT_UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED, printDefault);
        printCurrentVsDefault("UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED", stringResources.UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED, DEFAULT_UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("EXPRESSION_STRING_IS_EMPTY", stringResources.EXPRESSION_STRING_IS_EMPTY, DEFAULT_EXPRESSION_STRING_IS_EMPTY, printDefault);
        printCurrentVsDefault("EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS", stringResources.EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS, DEFAULT_EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS, printDefault);
        printCurrentVsDefault("DUPLICATED_KEYWORD", stringResources.DUPLICATED_KEYWORD, DEFAULT_DUPLICATED_KEYWORD, printDefault);
        printCurrentVsDefault("ELEMENT", stringResources.ELEMENT, DEFAULT_ELEMENT, printDefault);
        printCurrentVsDefault("ERROR", stringResources.ERROR, DEFAULT_ERROR, printDefault);
        printCurrentVsDefault("EXCEPTION", stringResources.EXCEPTION, DEFAULT_EXCEPTION, printDefault);
        printCurrentVsDefault("TOKEN", stringResources.TOKEN, DEFAULT_TOKEN, printDefault);
        printCurrentVsDefault("INDEX", stringResources.INDEX, DEFAULT_INDEX, printDefault);
        printCurrentVsDefault("INVALID_TOKEN", stringResources.INVALID_TOKEN, DEFAULT_INVALID_TOKEN, printDefault);
        printCurrentVsDefault("INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR", stringResources.INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR, DEFAULT_INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR, printDefault);
        printCurrentVsDefault("EXPRESSION_TOKENS", stringResources.EXPRESSION_TOKENS, DEFAULT_EXPRESSION_TOKENS, printDefault);
        printCurrentVsDefault("NULL_TOKENS_LIST", stringResources.NULL_TOKENS_LIST, DEFAULT_NULL_TOKENS_LIST, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS", stringResources.FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS, DEFAULT_FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS, printDefault);
        printCurrentVsDefault("ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS", stringResources.ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS, DEFAULT_ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS, printDefault);
        printCurrentVsDefault("PROVIDED_EXTENSION_IS_NULL", stringResources.PROVIDED_EXTENSION_IS_NULL, DEFAULT_PROVIDED_EXTENSION_IS_NULL, printDefault);
        printCurrentVsDefault("PROVIDED_STRING_IS_NULL", stringResources.PROVIDED_STRING_IS_NULL, DEFAULT_PROVIDED_STRING_IS_NULL, printDefault);
        printCurrentVsDefault("PROVIDED_ELEMENTS_ARE_NULL", stringResources.PROVIDED_ELEMENTS_ARE_NULL, DEFAULT_PROVIDED_ELEMENTS_ARE_NULL, printDefault);
        printCurrentVsDefault("MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE", stringResources.MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE, DEFAULT_MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT", stringResources.STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT, DEFAULT_STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT, printDefault);
        printCurrentVsDefault("STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT", stringResources.STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT, DEFAULT_STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT, printDefault);
        printCurrentVsDefault("STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION", stringResources.STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION, DEFAULT_STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION, printDefault);
        printCurrentVsDefault("STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION", stringResources.STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION, DEFAULT_STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("ARGUMENT_WAS_EXPECTED", stringResources.ARGUMENT_WAS_EXPECTED, DEFAULT_ARGUMENT_WAS_EXPECTED, printDefault);
        printCurrentVsDefault("RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER", stringResources.RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER, DEFAULT_RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION", stringResources.INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION, DEFAULT_INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS", stringResources.INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS, DEFAULT_INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS, printDefault);
        printCurrentVsDefault("EXPECTED", stringResources.EXPECTED, DEFAULT_EXPECTED, printDefault);
        printCurrentVsDefault("PROVIDED", stringResources.PROVIDED, DEFAULT_PROVIDED, printDefault);
        printCurrentVsDefault("USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT", stringResources.USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT, DEFAULT_USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT, printDefault);
        printCurrentVsDefault("EXPECTED_EVEN_NUMBER_OF_ARGUMENTS", stringResources.EXPECTED_EVEN_NUMBER_OF_ARGUMENTS, DEFAULT_EXPECTED_EVEN_NUMBER_OF_ARGUMENTS, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("INVALID_FUNCTION_NAME", stringResources.INVALID_FUNCTION_NAME, DEFAULT_INVALID_FUNCTION_NAME, printDefault);
        printCurrentVsDefault("INVALID_ARGUMENT_NAME", stringResources.INVALID_ARGUMENT_NAME, DEFAULT_INVALID_ARGUMENT_NAME, printDefault);
        printCurrentVsDefault("INVALID_CONSTANT_NAME", stringResources.INVALID_CONSTANT_NAME, DEFAULT_INVALID_CONSTANT_NAME, printDefault);
        printCurrentVsDefault("INVALID_FUNCTION_DEFINITION", stringResources.INVALID_FUNCTION_DEFINITION, DEFAULT_INVALID_FUNCTION_DEFINITION, printDefault);
        printCurrentVsDefault("INVALID_ARGUMENT_DEFINITION", stringResources.INVALID_ARGUMENT_DEFINITION, DEFAULT_INVALID_ARGUMENT_DEFINITION, printDefault);
        printCurrentVsDefault("INVALID_CONSTANT_DEFINITION", stringResources.INVALID_CONSTANT_DEFINITION, DEFAULT_INVALID_CONSTANT_DEFINITION, printDefault);
        printCurrentVsDefault("PATTERN_DOES_NOT_MATCH", stringResources.PATTERN_DOES_NOT_MATCH, DEFAULT_PATTERN_DOES_NOT_MATCH, printDefault);
        printCurrentVsDefault("PATTERN_EXAMPLES", stringResources.PATTERN_EXAMPLES, DEFAULT_PATTERN_EXAMPLES, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("CONSTANT_WAS_EXPECTED", stringResources.CONSTANT_WAS_EXPECTED, DEFAULT_CONSTANT_WAS_EXPECTED, printDefault);
        printCurrentVsDefault("USER_CONSTANT_WAS_EXPECTED", stringResources.USER_CONSTANT_WAS_EXPECTED, DEFAULT_USER_CONSTANT_WAS_EXPECTED, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("UNARY_FUNCTION_EXPECTS_1_PARAMETER", stringResources.UNARY_FUNCTION_EXPECTS_1_PARAMETER, DEFAULT_UNARY_FUNCTION_EXPECTS_1_PARAMETER, printDefault);
        printCurrentVsDefault("BINARY_FUNCTION_EXPECTS_2_PARAMETERS", stringResources.BINARY_FUNCTION_EXPECTS_2_PARAMETERS, DEFAULT_BINARY_FUNCTION_EXPECTS_2_PARAMETERS, printDefault);
        printCurrentVsDefault("TERNARY_FUNCTION_EXPECTS_3_PARAMETERS", stringResources.TERNARY_FUNCTION_EXPECTS_3_PARAMETERS, DEFAULT_TERNARY_FUNCTION_EXPECTS_3_PARAMETERS, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS", stringResources.DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS, DEFAULT_DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS, printDefault);
        printCurrentVsDefault("ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION", stringResources.ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION, DEFAULT_ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION, printDefault);
        printCurrentVsDefault("DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION", stringResources.DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION, DEFAULT_DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION, printDefault);
        printCurrentVsDefault("ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION", stringResources.ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION, DEFAULT_ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION, printDefault);
        printCurrentVsDefault("NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS", stringResources.NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS, DEFAULT_NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS, printDefault);
        printCurrentVsDefault("INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS", stringResources.INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS, DEFAULT_INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS, printDefault);
        printCurrentVsDefault("ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS", stringResources.ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS, DEFAULT_ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS, printDefault);
        printCurrentVsDefault("FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS", stringResources.FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS, DEFAULT_FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS, printDefault);
        printCurrentVsDefault("FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED", stringResources.FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED, DEFAULT_FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED, printDefault);
        printCurrentVsDefault("AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED", stringResources.AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED, DEFAULT_AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("ERROR_WHILE_EXECUTING_THE_CALCULATE", stringResources.ERROR_WHILE_EXECUTING_THE_CALCULATE, DEFAULT_ERROR_WHILE_EXECUTING_THE_CALCULATE, printDefault);
        printCurrentVsDefault("RECURSION_CALLS_COUNTER_EXCEEDED", stringResources.RECURSION_CALLS_COUNTER_EXCEEDED, DEFAULT_RECURSION_CALLS_COUNTER_EXCEEDED, printDefault);
        printCurrentVsDefault("RECURSION_CALLS_COUNTER", stringResources.RECURSION_CALLS_COUNTER, DEFAULT_RECURSION_CALLS_COUNTER, printDefault);
        printCurrentVsDefault("STARTING_CALCULATION_LOOP", stringResources.STARTING_CALCULATION_LOOP, DEFAULT_STARTING_CALCULATION_LOOP, printDefault);
        printCurrentVsDefault("CANCEL_REQUEST_FINISHING", stringResources.CANCEL_REQUEST_FINISHING, DEFAULT_CANCEL_REQUEST_FINISHING, printDefault);
        printCurrentVsDefault("INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING", stringResources.INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING, DEFAULT_INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING, printDefault);
        printCurrentVsDefault("FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN", stringResources.FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN, DEFAULT_FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN, printDefault);
        printCurrentVsDefault("MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED", stringResources.MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED, DEFAULT_MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("STARTING", stringResources.STARTING, DEFAULT_STARTING, printDefault);
        printCurrentVsDefault("PARSING", stringResources.PARSING, DEFAULT_PARSING, printDefault);
        printCurrentVsDefault("FULLY_COMPILED", stringResources.FULLY_COMPILED, DEFAULT_FULLY_COMPILED, printDefault);
        printCurrentVsDefault("CALCULATED_VALUE", stringResources.CALCULATED_VALUE, DEFAULT_CALCULATED_VALUE, printDefault);
        printCurrentVsDefault("EXITING", stringResources.EXITING, DEFAULT_EXITING, printDefault);
        printCurrentVsDefault("DONE", stringResources.DONE, DEFAULT_DONE, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("KEYWORD", stringResources.KEYWORD, DEFAULT_KEYWORD, printDefault);
        printCurrentVsDefault("SYNTAX", stringResources.SYNTAX, DEFAULT_SYNTAX, printDefault);
        printCurrentVsDefault("NUMBER", stringResources.NUMBER, DEFAULT_NUMBER, printDefault);
        printCurrentVsDefault("NUMBER_LITERAL", stringResources.NUMBER_LITERAL, DEFAULT_NUMBER_LITERAL, printDefault);
        printCurrentVsDefault("TYPE", stringResources.TYPE, DEFAULT_TYPE, printDefault);
        printCurrentVsDefault("SINCE", stringResources.SINCE, DEFAULT_SINCE, printDefault);
        printCurrentVsDefault("DESCRIPTION", stringResources.DESCRIPTION, DEFAULT_DESCRIPTION, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("CALC_STEPS_REGISTER_IS_EMPTY", stringResources.CALC_STEPS_REGISTER_IS_EMPTY, DEFAULT_CALC_STEPS_REGISTER_IS_EMPTY, printDefault);
        printCurrentVsDefault("CALC_STEPS_REGISTER_FOR", stringResources.CALC_STEPS_REGISTER_FOR, DEFAULT_CALC_STEPS_REGISTER_FOR, printDefault);
        printCurrentVsDefault("ARGUMENT", stringResources.ARGUMENT, DEFAULT_ARGUMENT, printDefault);
        printCurrentVsDefault("FUNCTION", stringResources.FUNCTION, DEFAULT_FUNCTION, printDefault);
        printCurrentVsDefault("EXPRESSION", stringResources.EXPRESSION, DEFAULT_EXPRESSION, printDefault);
        printCurrentVsDefault("RESULT", stringResources.RESULT, DEFAULT_RESULT, printDefault);
        printCurrentVsDefault("COMPUTING_TIME", stringResources.COMPUTING_TIME, DEFAULT_COMPUTING_TIME, printDefault);
        printCurrentVsDefault("GROUP_SHORT", stringResources.GROUP_SHORT, DEFAULT_GROUP_SHORT, printDefault);
        printCurrentVsDefault("NUMBER_SHORT", stringResources.NUMBER_SHORT, DEFAULT_NUMBER_SHORT, printDefault);
        printCurrentVsDefault("FIRST", stringResources.FIRST, DEFAULT_FIRST, printDefault);
        printCurrentVsDefault("LAST", stringResources.LAST, DEFAULT_LAST, printDefault);
        printCurrentVsDefault("DESCRIPTION_SHORT", stringResources.DESCRIPTION_SHORT, DEFAULT_DESCRIPTION_SHORT, printDefault);
        printCurrentVsDefault("STEP", stringResources.STEP, DEFAULT_STEP, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("SERIALIZATION_PERFORMED", stringResources.SERIALIZATION_PERFORMED, DEFAULT_SERIALIZATION_PERFORMED, printDefault);
        printCurrentVsDefault("DESERIALIZATION_PERFORMED", stringResources.DESERIALIZATION_PERFORMED, DEFAULT_DESERIALIZATION_PERFORMED, printDefault);
        printCurrentVsDefault("NULL_OBJECT_PROVIDED", stringResources.NULL_OBJECT_PROVIDED, DEFAULT_NULL_OBJECT_PROVIDED, printDefault);
        printCurrentVsDefault("NULL_FILE_PATH_PROVIDED", stringResources.NULL_FILE_PATH_PROVIDED, DEFAULT_NULL_FILE_PATH_PROVIDED, printDefault);
        printCurrentVsDefault("FILE_PATH_ZERO_LENGTH_PROVIDED", stringResources.FILE_PATH_ZERO_LENGTH_PROVIDED, DEFAULT_FILE_PATH_ZERO_LENGTH_PROVIDED, printDefault);
        printCurrentVsDefault("FILE_PATH_IS_NOT_A_FILE", stringResources.FILE_PATH_IS_NOT_A_FILE, DEFAULT_FILE_PATH_IS_NOT_A_FILE, printDefault);
        printCurrentVsDefault("FILE_PATH_NOT_EXISTS", stringResources.FILE_PATH_NOT_EXISTS, DEFAULT_FILE_PATH_NOT_EXISTS, printDefault);
        printCurrentVsDefault("NULL_DATA_PROVIDED", stringResources.NULL_DATA_PROVIDED, DEFAULT_NULL_DATA_PROVIDED, printDefault);
        printCurrentVsDefault("BINARY_SERIALIZATION_ENABLED", stringResources.BINARY_SERIALIZATION_ENABLED, DEFAULT_BINARY_SERIALIZATION_ENABLED, printDefault);
        printCurrentVsDefault("BINARY_SERIALIZATION_DISABLED", stringResources.BINARY_SERIALIZATION_DISABLED, DEFAULT_BINARY_SERIALIZATION_DISABLED, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("USER_DEFINED_EXPRESSION", stringResources.USER_DEFINED_EXPRESSION, DEFAULT_USER_DEFINED_EXPRESSION, printDefault);
        printCurrentVsDefault("USER_DEFINED_ARGUMENT", stringResources.USER_DEFINED_ARGUMENT, DEFAULT_USER_DEFINED_ARGUMENT, printDefault);
        printCurrentVsDefault("USER_DEFINED_CONSTANT", stringResources.USER_DEFINED_CONSTANT, DEFAULT_USER_DEFINED_CONSTANT, printDefault);
        printCurrentVsDefault("USER_DEFINED_FUNCTION", stringResources.USER_DEFINED_FUNCTION, DEFAULT_USER_DEFINED_FUNCTION, printDefault);
        printCurrentVsDefault("USER_DEFINED_RECURSIVE_ARGUMENT", stringResources.USER_DEFINED_RECURSIVE_ARGUMENT, DEFAULT_USER_DEFINED_RECURSIVE_ARGUMENT, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("HELP_CONTENT_LIMITED_TO_QUERY", stringResources.HELP_CONTENT_LIMITED_TO_QUERY, DEFAULT_HELP_CONTENT_LIMITED_TO_QUERY, printDefault);
        printCurrentVsDefault("ALL_HELP_CONTENT", stringResources.ALL_HELP_CONTENT, DEFAULT_ALL_HELP_CONTENT, printDefault);
        printCurrentVsDefault("CAPTION", stringResources.CAPTION, DEFAULT_CAPTION, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("WARNING_BINARY_SERIALIZATION_SECURITY_RISKS", stringResources.WARNING_BINARY_SERIALIZATION_SECURITY_RISKS, DEFAULT_WARNING_BINARY_SERIALIZATION_SECURITY_RISKS, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("BINARY_RELATION", stringResources.BINARY_RELATION, DEFAULT_BINARY_RELATION, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR", stringResources.BITWISE_OPERATOR, DEFAULT_BITWISE_OPERATOR, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR", stringResources.BOOLEAN_OPERATOR, DEFAULT_BOOLEAN_OPERATOR, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR", stringResources.CALCULUS_OPERATOR, DEFAULT_CALCULUS_OPERATOR, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE", stringResources.CONSTANT_VALUE, DEFAULT_CONSTANT_VALUE, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG", stringResources.FUNCTION_1_ARG, DEFAULT_FUNCTION_1_ARG, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG", stringResources.FUNCTION_2_ARG, DEFAULT_FUNCTION_2_ARG, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG", stringResources.FUNCTION_3_ARG, DEFAULT_FUNCTION_3_ARG, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC", stringResources.FUNCTION_VARIADIC, DEFAULT_FUNCTION_VARIADIC, printDefault);
        printCurrentVsDefault("OPERATOR", stringResources.OPERATOR, DEFAULT_OPERATOR, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL", stringResources.PARSER_SYMBOL, DEFAULT_PARSER_SYMBOL, printDefault);
        printCurrentVsDefault("RANDOM_VARIABLE", stringResources.RANDOM_VARIABLE, DEFAULT_RANDOM_VARIABLE, printDefault);
        printCurrentVsDefault("UNIT", stringResources.UNIT, DEFAULT_UNIT, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT", stringResources.DIMENSIONLESS_UNIT, DEFAULT_DIMENSIONLESS_UNIT, printDefault);
        printCurrentVsDefault("ITERATED_OPERATOR", stringResources.ITERATED_OPERATOR, DEFAULT_ITERATED_OPERATOR, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("RATIO_FRACTION", stringResources.RATIO_FRACTION, DEFAULT_RATIO_FRACTION, printDefault);
        printCurrentVsDefault("METRIC_PREFIX", stringResources.METRIC_PREFIX, DEFAULT_METRIC_PREFIX, printDefault);
        printCurrentVsDefault("UNIT_OF_LENGTH", stringResources.UNIT_OF_LENGTH, DEFAULT_UNIT_OF_LENGTH, printDefault);
        printCurrentVsDefault("UNIT_OF_AREA", stringResources.UNIT_OF_AREA, DEFAULT_UNIT_OF_AREA, printDefault);
        printCurrentVsDefault("UNIT_OF_VOLUME", stringResources.UNIT_OF_VOLUME, DEFAULT_UNIT_OF_VOLUME, printDefault);
        printCurrentVsDefault("UNIT_OF_TIME", stringResources.UNIT_OF_TIME, DEFAULT_UNIT_OF_TIME, printDefault);
        printCurrentVsDefault("UNIT_OF_MASS", stringResources.UNIT_OF_MASS, DEFAULT_UNIT_OF_MASS, printDefault);
        printCurrentVsDefault("UNIT_OF_INFORMATION", stringResources.UNIT_OF_INFORMATION, DEFAULT_UNIT_OF_INFORMATION, printDefault);
        printCurrentVsDefault("UNIT_OF_ENERGY", stringResources.UNIT_OF_ENERGY, DEFAULT_UNIT_OF_ENERGY, printDefault);
        printCurrentVsDefault("UNIT_OF_SPEED", stringResources.UNIT_OF_SPEED, DEFAULT_UNIT_OF_SPEED, printDefault);
        printCurrentVsDefault("UNIT_OF_ACCELERATION", stringResources.UNIT_OF_ACCELERATION, DEFAULT_UNIT_OF_ACCELERATION, printDefault);
        printCurrentVsDefault("UNIT_OF_ANGLE", stringResources.UNIT_OF_ANGLE, DEFAULT_UNIT_OF_ANGLE, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("PHYSICAL_CONSTANT", stringResources.PHYSICAL_CONSTANT, DEFAULT_PHYSICAL_CONSTANT, printDefault);
        printCurrentVsDefault("ASTRONOMICAL_CONSTANT", stringResources.ASTRONOMICAL_CONSTANT, DEFAULT_ASTRONOMICAL_CONSTANT, printDefault);
        printCurrentVsDefault("MATHEMATICAL_CONSTANT", stringResources.MATHEMATICAL_CONSTANT, DEFAULT_MATHEMATICAL_CONSTANT, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("PROBABILITY_DISTRIBUTION_FUNCTION", stringResources.PROBABILITY_DISTRIBUTION_FUNCTION, DEFAULT_PROBABILITY_DISTRIBUTION_FUNCTION, printDefault);
        printCurrentVsDefault("CUMULATIVE_DISTRIBUTION_FUNCTION", stringResources.CUMULATIVE_DISTRIBUTION_FUNCTION, DEFAULT_CUMULATIVE_DISTRIBUTION_FUNCTION, printDefault);
        printCurrentVsDefault("QUANTILE_FUNCTION", stringResources.QUANTILE_FUNCTION, DEFAULT_QUANTILE_FUNCTION, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("STUDENTS_T_DISTRIBUTION", stringResources.STUDENTS_T_DISTRIBUTION, DEFAULT_STUDENTS_T_DISTRIBUTION, printDefault);
        printCurrentVsDefault("CHI_SQUARED_DISTRIBUTION", stringResources.CHI_SQUARED_DISTRIBUTION, DEFAULT_CHI_SQUARED_DISTRIBUTION, printDefault);
        printCurrentVsDefault("SNEDECORS_F_DISTRIBUTION", stringResources.SNEDECORS_F_DISTRIBUTION, DEFAULT_SNEDECORS_F_DISTRIBUTION, printDefault);
        printCurrentVsDefault("UNIFORM_CONTINUOUS_DISTRIBUTION", stringResources.UNIFORM_CONTINUOUS_DISTRIBUTION, DEFAULT_UNIFORM_CONTINUOUS_DISTRIBUTION, printDefault);
        printCurrentVsDefault("UNIFORM_DISCRETE_DISTRIBUTION", stringResources.UNIFORM_DISCRETE_DISTRIBUTION, DEFAULT_UNIFORM_DISCRETE_DISTRIBUTION, printDefault);
        printCurrentVsDefault("NORMAL_DISTRIBUTION", stringResources.NORMAL_DISTRIBUTION, DEFAULT_NORMAL_DISTRIBUTION, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("RANDOM_INTEGER", stringResources.RANDOM_INTEGER, DEFAULT_RANDOM_INTEGER, printDefault);
        printCurrentVsDefault("RANDOM_NATURAL_NUMBER", stringResources.RANDOM_NATURAL_NUMBER, DEFAULT_RANDOM_NATURAL_NUMBER, printDefault);
        printCurrentVsDefault("RANDOM_NATURAL_NUMBER_INCLUDING_0", stringResources.RANDOM_NATURAL_NUMBER_INCLUDING_0, DEFAULT_RANDOM_NATURAL_NUMBER_INCLUDING_0, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("SPECIAL_FUNCTION", stringResources.SPECIAL_FUNCTION, DEFAULT_SPECIAL_FUNCTION, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("SEMI_MAJOR_AXIS", stringResources.SEMI_MAJOR_AXIS, DEFAULT_SEMI_MAJOR_AXIS, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("BINARY_RELATION_EQ", stringResources.BINARY_RELATION_EQ, DEFAULT_BINARY_RELATION_EQ, printDefault);
        printCurrentVsDefault("BINARY_RELATION_NEQ", stringResources.BINARY_RELATION_NEQ, DEFAULT_BINARY_RELATION_NEQ, printDefault);
        printCurrentVsDefault("BINARY_RELATION_LT", stringResources.BINARY_RELATION_LT, DEFAULT_BINARY_RELATION_LT, printDefault);
        printCurrentVsDefault("BINARY_RELATION_GT", stringResources.BINARY_RELATION_GT, DEFAULT_BINARY_RELATION_GT, printDefault);
        printCurrentVsDefault("BINARY_RELATION_LEQ", stringResources.BINARY_RELATION_LEQ, DEFAULT_BINARY_RELATION_LEQ, printDefault);
        printCurrentVsDefault("BINARY_RELATION_GEQ", stringResources.BINARY_RELATION_GEQ, DEFAULT_BINARY_RELATION_GEQ, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("BITWISE_OPERATOR_COMPL", stringResources.BITWISE_OPERATOR_COMPL, DEFAULT_BITWISE_OPERATOR_COMPL, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_AND", stringResources.BITWISE_OPERATOR_AND, DEFAULT_BITWISE_OPERATOR_AND, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_XOR", stringResources.BITWISE_OPERATOR_XOR, DEFAULT_BITWISE_OPERATOR_XOR, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_OR", stringResources.BITWISE_OPERATOR_OR, DEFAULT_BITWISE_OPERATOR_OR, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_LEFT_SHIFT", stringResources.BITWISE_OPERATOR_LEFT_SHIFT, DEFAULT_BITWISE_OPERATOR_LEFT_SHIFT, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_RIGHT_SHIFT", stringResources.BITWISE_OPERATOR_RIGHT_SHIFT, DEFAULT_BITWISE_OPERATOR_RIGHT_SHIFT, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_NAND", stringResources.BITWISE_OPERATOR_NAND, DEFAULT_BITWISE_OPERATOR_NAND, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_NOR", stringResources.BITWISE_OPERATOR_NOR, DEFAULT_BITWISE_OPERATOR_NOR, printDefault);
        printCurrentVsDefault("BITWISE_OPERATOR_XNOR", stringResources.BITWISE_OPERATOR_XNOR, DEFAULT_BITWISE_OPERATOR_XNOR, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("BOOLEAN_OPERATOR_AND", stringResources.BOOLEAN_OPERATOR_AND, DEFAULT_BOOLEAN_OPERATOR_AND, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_OR", stringResources.BOOLEAN_OPERATOR_OR, DEFAULT_BOOLEAN_OPERATOR_OR, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_NEG", stringResources.BOOLEAN_OPERATOR_NEG, DEFAULT_BOOLEAN_OPERATOR_NEG, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_NAND", stringResources.BOOLEAN_OPERATOR_NAND, DEFAULT_BOOLEAN_OPERATOR_NAND, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_NOR", stringResources.BOOLEAN_OPERATOR_NOR, DEFAULT_BOOLEAN_OPERATOR_NOR, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_XOR", stringResources.BOOLEAN_OPERATOR_XOR, DEFAULT_BOOLEAN_OPERATOR_XOR, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_IMP", stringResources.BOOLEAN_OPERATOR_IMP, DEFAULT_BOOLEAN_OPERATOR_IMP, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_CIMP", stringResources.BOOLEAN_OPERATOR_CIMP, DEFAULT_BOOLEAN_OPERATOR_CIMP, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_NIMP", stringResources.BOOLEAN_OPERATOR_NIMP, DEFAULT_BOOLEAN_OPERATOR_NIMP, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_CNIMP", stringResources.BOOLEAN_OPERATOR_CNIMP, DEFAULT_BOOLEAN_OPERATOR_CNIMP, printDefault);
        printCurrentVsDefault("BOOLEAN_OPERATOR_EQV", stringResources.BOOLEAN_OPERATOR_EQV, DEFAULT_BOOLEAN_OPERATOR_EQV, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("CALCULUS_OPERATOR_SUM", stringResources.CALCULUS_OPERATOR_SUM, DEFAULT_CALCULUS_OPERATOR_SUM, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_PROD", stringResources.CALCULUS_OPERATOR_PROD, DEFAULT_CALCULUS_OPERATOR_PROD, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_INT", stringResources.CALCULUS_OPERATOR_INT, DEFAULT_CALCULUS_OPERATOR_INT, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_DER", stringResources.CALCULUS_OPERATOR_DER, DEFAULT_CALCULUS_OPERATOR_DER, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_DER_LEFT", stringResources.CALCULUS_OPERATOR_DER_LEFT, DEFAULT_CALCULUS_OPERATOR_DER_LEFT, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_DER_RIGHT", stringResources.CALCULUS_OPERATOR_DER_RIGHT, DEFAULT_CALCULUS_OPERATOR_DER_RIGHT, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_DERN", stringResources.CALCULUS_OPERATOR_DERN, DEFAULT_CALCULUS_OPERATOR_DERN, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_FORW_DIFF", stringResources.CALCULUS_OPERATOR_FORW_DIFF, DEFAULT_CALCULUS_OPERATOR_FORW_DIFF, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_BACKW_DIFF", stringResources.CALCULUS_OPERATOR_BACKW_DIFF, DEFAULT_CALCULUS_OPERATOR_BACKW_DIFF, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_AVG", stringResources.CALCULUS_OPERATOR_AVG, DEFAULT_CALCULUS_OPERATOR_AVG, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_VAR", stringResources.CALCULUS_OPERATOR_VAR, DEFAULT_CALCULUS_OPERATOR_VAR, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_STD", stringResources.CALCULUS_OPERATOR_STD, DEFAULT_CALCULUS_OPERATOR_STD, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_MIN", stringResources.CALCULUS_OPERATOR_MIN, DEFAULT_CALCULUS_OPERATOR_MIN, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_MAX", stringResources.CALCULUS_OPERATOR_MAX, DEFAULT_CALCULUS_OPERATOR_MAX, printDefault);
        printCurrentVsDefault("CALCULUS_OPERATOR_SOLVE", stringResources.CALCULUS_OPERATOR_SOLVE, DEFAULT_CALCULUS_OPERATOR_SOLVE, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("CONSTANT_VALUE_PI", stringResources.CONSTANT_VALUE_PI, DEFAULT_CONSTANT_VALUE_PI, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EULER", stringResources.CONSTANT_VALUE_EULER, DEFAULT_CONSTANT_VALUE_EULER, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EULER_MASCHERONI", stringResources.CONSTANT_VALUE_EULER_MASCHERONI, DEFAULT_CONSTANT_VALUE_EULER_MASCHERONI, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_GOLDEN_RATIO", stringResources.CONSTANT_VALUE_GOLDEN_RATIO, DEFAULT_CONSTANT_VALUE_GOLDEN_RATIO, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PLASTIC", stringResources.CONSTANT_VALUE_PLASTIC, DEFAULT_CONSTANT_VALUE_PLASTIC, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EMBREE_TREFETHEN", stringResources.CONSTANT_VALUE_EMBREE_TREFETHEN, DEFAULT_CONSTANT_VALUE_EMBREE_TREFETHEN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_FEIGENBAUM_DELTA", stringResources.CONSTANT_VALUE_FEIGENBAUM_DELTA, DEFAULT_CONSTANT_VALUE_FEIGENBAUM_DELTA, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_FEIGENBAUM_ALPHA", stringResources.CONSTANT_VALUE_FEIGENBAUM_ALPHA, DEFAULT_CONSTANT_VALUE_FEIGENBAUM_ALPHA, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_TWIN_PRIME", stringResources.CONSTANT_VALUE_TWIN_PRIME, DEFAULT_CONSTANT_VALUE_TWIN_PRIME, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MEISSEL_MERTEENS", stringResources.CONSTANT_VALUE_MEISSEL_MERTEENS, DEFAULT_CONSTANT_VALUE_MEISSEL_MERTEENS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_BRAUN_TWIN_PRIME", stringResources.CONSTANT_VALUE_BRAUN_TWIN_PRIME, DEFAULT_CONSTANT_VALUE_BRAUN_TWIN_PRIME, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_BRAUN_PRIME_QUADR", stringResources.CONSTANT_VALUE_BRAUN_PRIME_QUADR, DEFAULT_CONSTANT_VALUE_BRAUN_PRIME_QUADR, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_BRUIJN_NEWMAN", stringResources.CONSTANT_VALUE_BRUIJN_NEWMAN, DEFAULT_CONSTANT_VALUE_BRUIJN_NEWMAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_CATALAN", stringResources.CONSTANT_VALUE_CATALAN, DEFAULT_CONSTANT_VALUE_CATALAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LANDAU_RAMANUJAN", stringResources.CONSTANT_VALUE_LANDAU_RAMANUJAN, DEFAULT_CONSTANT_VALUE_LANDAU_RAMANUJAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_VISWANATH", stringResources.CONSTANT_VALUE_VISWANATH, DEFAULT_CONSTANT_VALUE_VISWANATH, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LEGENDRE", stringResources.CONSTANT_VALUE_LEGENDRE, DEFAULT_CONSTANT_VALUE_LEGENDRE, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_RAMANUJAN_SOLDNER", stringResources.CONSTANT_VALUE_RAMANUJAN_SOLDNER, DEFAULT_CONSTANT_VALUE_RAMANUJAN_SOLDNER, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_ERDOS_BORWEIN", stringResources.CONSTANT_VALUE_ERDOS_BORWEIN, DEFAULT_CONSTANT_VALUE_ERDOS_BORWEIN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_BERNSTEIN", stringResources.CONSTANT_VALUE_BERNSTEIN, DEFAULT_CONSTANT_VALUE_BERNSTEIN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING", stringResources.CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING, DEFAULT_CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY", stringResources.CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY, DEFAULT_CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_GOLOMB_DICKMAN", stringResources.CONSTANT_VALUE_GOLOMB_DICKMAN, DEFAULT_CONSTANT_VALUE_GOLOMB_DICKMAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_CAHEN", stringResources.CONSTANT_VALUE_CAHEN, DEFAULT_CONSTANT_VALUE_CAHEN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LAPLACE_LIMIT", stringResources.CONSTANT_VALUE_LAPLACE_LIMIT, DEFAULT_CONSTANT_VALUE_LAPLACE_LIMIT, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_ALLADI_GRINSTEAD", stringResources.CONSTANT_VALUE_ALLADI_GRINSTEAD, DEFAULT_CONSTANT_VALUE_ALLADI_GRINSTEAD, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LENGYEL", stringResources.CONSTANT_VALUE_LENGYEL, DEFAULT_CONSTANT_VALUE_LENGYEL, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LEVY", stringResources.CONSTANT_VALUE_LEVY, DEFAULT_CONSTANT_VALUE_LEVY, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_APERY", stringResources.CONSTANT_VALUE_APERY, DEFAULT_CONSTANT_VALUE_APERY, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MILLS", stringResources.CONSTANT_VALUE_MILLS, DEFAULT_CONSTANT_VALUE_MILLS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_BACKHOUSE", stringResources.CONSTANT_VALUE_BACKHOUSE, DEFAULT_CONSTANT_VALUE_BACKHOUSE, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PORTER", stringResources.CONSTANT_VALUE_PORTER, DEFAULT_CONSTANT_VALUE_PORTER, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LIEB_QUARE_ICE", stringResources.CONSTANT_VALUE_LIEB_QUARE_ICE, DEFAULT_CONSTANT_VALUE_LIEB_QUARE_ICE, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_NIVEN", stringResources.CONSTANT_VALUE_NIVEN, DEFAULT_CONSTANT_VALUE_NIVEN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_SIERPINSKI", stringResources.CONSTANT_VALUE_SIERPINSKI, DEFAULT_CONSTANT_VALUE_SIERPINSKI, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_KHINCHIN", stringResources.CONSTANT_VALUE_KHINCHIN, DEFAULT_CONSTANT_VALUE_KHINCHIN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_FRANSEN_ROBINSON", stringResources.CONSTANT_VALUE_FRANSEN_ROBINSON, DEFAULT_CONSTANT_VALUE_FRANSEN_ROBINSON, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LANDAU", stringResources.CONSTANT_VALUE_LANDAU, DEFAULT_CONSTANT_VALUE_LANDAU, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PARABOLIC", stringResources.CONSTANT_VALUE_PARABOLIC, DEFAULT_CONSTANT_VALUE_PARABOLIC, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_OMEGA", stringResources.CONSTANT_VALUE_OMEGA, DEFAULT_CONSTANT_VALUE_OMEGA, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MRB", stringResources.CONSTANT_VALUE_MRB, DEFAULT_CONSTANT_VALUE_MRB, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LI2", stringResources.CONSTANT_VALUE_LI2, DEFAULT_CONSTANT_VALUE_LI2, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_GOMPERTZ", stringResources.CONSTANT_VALUE_GOMPERTZ, DEFAULT_CONSTANT_VALUE_GOMPERTZ, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LIGHT_SPEED", stringResources.CONSTANT_VALUE_LIGHT_SPEED, DEFAULT_CONSTANT_VALUE_LIGHT_SPEED, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_GRAVITATIONAL_CONSTANT", stringResources.CONSTANT_VALUE_GRAVITATIONAL_CONSTANT, DEFAULT_CONSTANT_VALUE_GRAVITATIONAL_CONSTANT, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_GRAVIT_ACC_EARTH", stringResources.CONSTANT_VALUE_GRAVIT_ACC_EARTH, DEFAULT_CONSTANT_VALUE_GRAVIT_ACC_EARTH, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PLANCK_CONSTANT", stringResources.CONSTANT_VALUE_PLANCK_CONSTANT, DEFAULT_CONSTANT_VALUE_PLANCK_CONSTANT, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED", stringResources.CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED, DEFAULT_CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PLANCK_LENGTH", stringResources.CONSTANT_VALUE_PLANCK_LENGTH, DEFAULT_CONSTANT_VALUE_PLANCK_LENGTH, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PLANCK_MASS", stringResources.CONSTANT_VALUE_PLANCK_MASS, DEFAULT_CONSTANT_VALUE_PLANCK_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PLANCK_TIME", stringResources.CONSTANT_VALUE_PLANCK_TIME, DEFAULT_CONSTANT_VALUE_PLANCK_TIME, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_LIGHT_YEAR", stringResources.CONSTANT_VALUE_LIGHT_YEAR, DEFAULT_CONSTANT_VALUE_LIGHT_YEAR, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_ASTRONOMICAL_UNIT", stringResources.CONSTANT_VALUE_ASTRONOMICAL_UNIT, DEFAULT_CONSTANT_VALUE_ASTRONOMICAL_UNIT, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_PARSEC", stringResources.CONSTANT_VALUE_PARSEC, DEFAULT_CONSTANT_VALUE_PARSEC, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_KILOPARSEC", stringResources.CONSTANT_VALUE_KILOPARSEC, DEFAULT_CONSTANT_VALUE_KILOPARSEC, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL", stringResources.CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL, DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EARTH_RADIUS_POLAR", stringResources.CONSTANT_VALUE_EARTH_RADIUS_POLAR, DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_POLAR, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EARTH_RADIUS_MEAN", stringResources.CONSTANT_VALUE_EARTH_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_EARTH_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EARTH_MASS", stringResources.CONSTANT_VALUE_EARTH_MASS, DEFAULT_CONSTANT_VALUE_EARTH_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MOON_RADIUS_MEAN", stringResources.CONSTANT_VALUE_MOON_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_MOON_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MOON_MASS", stringResources.CONSTANT_VALUE_MOON_MASS, DEFAULT_CONSTANT_VALUE_MOON_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_SOLAR_RADIUS", stringResources.CONSTANT_VALUE_SOLAR_RADIUS, DEFAULT_CONSTANT_VALUE_SOLAR_RADIUS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_SOLAR_MASS", stringResources.CONSTANT_VALUE_SOLAR_MASS, DEFAULT_CONSTANT_VALUE_SOLAR_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MERCURY_RADIUS_MEAN", stringResources.CONSTANT_VALUE_MERCURY_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_MERCURY_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MERCURY_MASS", stringResources.CONSTANT_VALUE_MERCURY_MASS, DEFAULT_CONSTANT_VALUE_MERCURY_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_VENUS_RADIUS_MEAN", stringResources.CONSTANT_VALUE_VENUS_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_VENUS_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_VENUS_MASS", stringResources.CONSTANT_VALUE_VENUS_MASS, DEFAULT_CONSTANT_VALUE_VENUS_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MARS_RADIUS_MEAN", stringResources.CONSTANT_VALUE_MARS_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_MARS_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MARS_MASS", stringResources.CONSTANT_VALUE_MARS_MASS, DEFAULT_CONSTANT_VALUE_MARS_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_JUPITER_RADIUS_MEAN", stringResources.CONSTANT_VALUE_JUPITER_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_JUPITER_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_JUPITER_MASS", stringResources.CONSTANT_VALUE_JUPITER_MASS, DEFAULT_CONSTANT_VALUE_JUPITER_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_SATURN_RADIUS_MEAN", stringResources.CONSTANT_VALUE_SATURN_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_SATURN_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_SATURN_MASS", stringResources.CONSTANT_VALUE_SATURN_MASS, DEFAULT_CONSTANT_VALUE_SATURN_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_URANUS_RADIUS_MEAN", stringResources.CONSTANT_VALUE_URANUS_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_URANUS_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_URANUS_MASS", stringResources.CONSTANT_VALUE_URANUS_MASS, DEFAULT_CONSTANT_VALUE_URANUS_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN", stringResources.CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN, DEFAULT_CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_NEPTUNE_MASS", stringResources.CONSTANT_VALUE_NEPTUNE_MASS, DEFAULT_CONSTANT_VALUE_NEPTUNE_MASS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS", stringResources.CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS, DEFAULT_CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_TRUE", stringResources.CONSTANT_VALUE_TRUE, DEFAULT_CONSTANT_VALUE_TRUE, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_FALSE", stringResources.CONSTANT_VALUE_FALSE, DEFAULT_CONSTANT_VALUE_FALSE, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_NPAR", stringResources.CONSTANT_VALUE_NPAR, DEFAULT_CONSTANT_VALUE_NPAR, printDefault);
        printCurrentVsDefault("CONSTANT_VALUE_NAN", stringResources.CONSTANT_VALUE_NAN, DEFAULT_CONSTANT_VALUE_NAN, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("FUNCTION_1_ARG_SIN", stringResources.FUNCTION_1_ARG_SIN, DEFAULT_FUNCTION_1_ARG_SIN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_COS", stringResources.FUNCTION_1_ARG_COS, DEFAULT_FUNCTION_1_ARG_COS, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_TAN", stringResources.FUNCTION_1_ARG_TAN, DEFAULT_FUNCTION_1_ARG_TAN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_CTAN", stringResources.FUNCTION_1_ARG_CTAN, DEFAULT_FUNCTION_1_ARG_CTAN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SEC", stringResources.FUNCTION_1_ARG_SEC, DEFAULT_FUNCTION_1_ARG_SEC, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_COSEC", stringResources.FUNCTION_1_ARG_COSEC, DEFAULT_FUNCTION_1_ARG_COSEC, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ASIN", stringResources.FUNCTION_1_ARG_ASIN, DEFAULT_FUNCTION_1_ARG_ASIN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ACOS", stringResources.FUNCTION_1_ARG_ACOS, DEFAULT_FUNCTION_1_ARG_ACOS, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ATAN", stringResources.FUNCTION_1_ARG_ATAN, DEFAULT_FUNCTION_1_ARG_ATAN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ACTAN", stringResources.FUNCTION_1_ARG_ACTAN, DEFAULT_FUNCTION_1_ARG_ACTAN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LN", stringResources.FUNCTION_1_ARG_LN, DEFAULT_FUNCTION_1_ARG_LN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LOG2", stringResources.FUNCTION_1_ARG_LOG2, DEFAULT_FUNCTION_1_ARG_LOG2, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LOG10", stringResources.FUNCTION_1_ARG_LOG10, DEFAULT_FUNCTION_1_ARG_LOG10, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_RAD", stringResources.FUNCTION_1_ARG_RAD, DEFAULT_FUNCTION_1_ARG_RAD, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_EXP", stringResources.FUNCTION_1_ARG_EXP, DEFAULT_FUNCTION_1_ARG_EXP, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SQRT", stringResources.FUNCTION_1_ARG_SQRT, DEFAULT_FUNCTION_1_ARG_SQRT, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SINH", stringResources.FUNCTION_1_ARG_SINH, DEFAULT_FUNCTION_1_ARG_SINH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_COSH", stringResources.FUNCTION_1_ARG_COSH, DEFAULT_FUNCTION_1_ARG_COSH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_TANH", stringResources.FUNCTION_1_ARG_TANH, DEFAULT_FUNCTION_1_ARG_TANH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_COTH", stringResources.FUNCTION_1_ARG_COTH, DEFAULT_FUNCTION_1_ARG_COTH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SECH", stringResources.FUNCTION_1_ARG_SECH, DEFAULT_FUNCTION_1_ARG_SECH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_CSCH", stringResources.FUNCTION_1_ARG_CSCH, DEFAULT_FUNCTION_1_ARG_CSCH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_DEG", stringResources.FUNCTION_1_ARG_DEG, DEFAULT_FUNCTION_1_ARG_DEG, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ABS", stringResources.FUNCTION_1_ARG_ABS, DEFAULT_FUNCTION_1_ARG_ABS, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SGN", stringResources.FUNCTION_1_ARG_SGN, DEFAULT_FUNCTION_1_ARG_SGN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_FLOOR", stringResources.FUNCTION_1_ARG_FLOOR, DEFAULT_FUNCTION_1_ARG_FLOOR, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_CEIL", stringResources.FUNCTION_1_ARG_CEIL, DEFAULT_FUNCTION_1_ARG_CEIL, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_NOT", stringResources.FUNCTION_1_ARG_NOT, DEFAULT_FUNCTION_1_ARG_NOT, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARSINH", stringResources.FUNCTION_1_ARG_ARSINH, DEFAULT_FUNCTION_1_ARG_ARSINH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARCOSH", stringResources.FUNCTION_1_ARG_ARCOSH, DEFAULT_FUNCTION_1_ARG_ARCOSH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARTANH", stringResources.FUNCTION_1_ARG_ARTANH, DEFAULT_FUNCTION_1_ARG_ARTANH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARCOTH", stringResources.FUNCTION_1_ARG_ARCOTH, DEFAULT_FUNCTION_1_ARG_ARCOTH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARSECH", stringResources.FUNCTION_1_ARG_ARSECH, DEFAULT_FUNCTION_1_ARG_ARSECH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARCSCH", stringResources.FUNCTION_1_ARG_ARCSCH, DEFAULT_FUNCTION_1_ARG_ARCSCH, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SA", stringResources.FUNCTION_1_ARG_SA, DEFAULT_FUNCTION_1_ARG_SA, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SINC", stringResources.FUNCTION_1_ARG_SINC, DEFAULT_FUNCTION_1_ARG_SINC, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_BELL_NUMBER", stringResources.FUNCTION_1_ARG_BELL_NUMBER, DEFAULT_FUNCTION_1_ARG_BELL_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LUCAS_NUMBER", stringResources.FUNCTION_1_ARG_LUCAS_NUMBER, DEFAULT_FUNCTION_1_ARG_LUCAS_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_FIBONACCI_NUMBER", stringResources.FUNCTION_1_ARG_FIBONACCI_NUMBER, DEFAULT_FUNCTION_1_ARG_FIBONACCI_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_HARMONIC_NUMBER", stringResources.FUNCTION_1_ARG_HARMONIC_NUMBER, DEFAULT_FUNCTION_1_ARG_HARMONIC_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_IS_PRIME", stringResources.FUNCTION_1_ARG_IS_PRIME, DEFAULT_FUNCTION_1_ARG_IS_PRIME, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_PRIME_COUNT", stringResources.FUNCTION_1_ARG_PRIME_COUNT, DEFAULT_FUNCTION_1_ARG_PRIME_COUNT, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_EXP_INT", stringResources.FUNCTION_1_ARG_EXP_INT, DEFAULT_FUNCTION_1_ARG_EXP_INT, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LOG_INT", stringResources.FUNCTION_1_ARG_LOG_INT, DEFAULT_FUNCTION_1_ARG_LOG_INT, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_OFF_LOG_INT", stringResources.FUNCTION_1_ARG_OFF_LOG_INT, DEFAULT_FUNCTION_1_ARG_OFF_LOG_INT, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_GAUSS_ERF", stringResources.FUNCTION_1_ARG_GAUSS_ERF, DEFAULT_FUNCTION_1_ARG_GAUSS_ERF, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_GAUSS_ERFC", stringResources.FUNCTION_1_ARG_GAUSS_ERFC, DEFAULT_FUNCTION_1_ARG_GAUSS_ERFC, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_GAUSS_ERF_INV", stringResources.FUNCTION_1_ARG_GAUSS_ERF_INV, DEFAULT_FUNCTION_1_ARG_GAUSS_ERF_INV, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_GAUSS_ERFC_INV", stringResources.FUNCTION_1_ARG_GAUSS_ERFC_INV, DEFAULT_FUNCTION_1_ARG_GAUSS_ERFC_INV, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ULP", stringResources.FUNCTION_1_ARG_ULP, DEFAULT_FUNCTION_1_ARG_ULP, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ISNAN", stringResources.FUNCTION_1_ARG_ISNAN, DEFAULT_FUNCTION_1_ARG_ISNAN, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_NDIG10", stringResources.FUNCTION_1_ARG_NDIG10, DEFAULT_FUNCTION_1_ARG_NDIG10, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_NFACT", stringResources.FUNCTION_1_ARG_NFACT, DEFAULT_FUNCTION_1_ARG_NFACT, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARCSEC", stringResources.FUNCTION_1_ARG_ARCSEC, DEFAULT_FUNCTION_1_ARG_ARCSEC, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_ARCCSC", stringResources.FUNCTION_1_ARG_ARCCSC, DEFAULT_FUNCTION_1_ARG_ARCCSC, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_GAMMA", stringResources.FUNCTION_1_ARG_GAMMA, DEFAULT_FUNCTION_1_ARG_GAMMA, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LAMBERT_W0", stringResources.FUNCTION_1_ARG_LAMBERT_W0, DEFAULT_FUNCTION_1_ARG_LAMBERT_W0, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LAMBERT_W1", stringResources.FUNCTION_1_ARG_LAMBERT_W1, DEFAULT_FUNCTION_1_ARG_LAMBERT_W1, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_SGN_GAMMA", stringResources.FUNCTION_1_ARG_SGN_GAMMA, DEFAULT_FUNCTION_1_ARG_SGN_GAMMA, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_LOG_GAMMA", stringResources.FUNCTION_1_ARG_LOG_GAMMA, DEFAULT_FUNCTION_1_ARG_LOG_GAMMA, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_DI_GAMMA", stringResources.FUNCTION_1_ARG_DI_GAMMA, DEFAULT_FUNCTION_1_ARG_DI_GAMMA, printDefault);
        printCurrentVsDefault("FUNCTION_1_ARG_PARAM", stringResources.FUNCTION_1_ARG_PARAM, DEFAULT_FUNCTION_1_ARG_PARAM, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("FUNCTION_2_ARG_LOG", stringResources.FUNCTION_2_ARG_LOG, DEFAULT_FUNCTION_2_ARG_LOG, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_MOD", stringResources.FUNCTION_2_ARG_MOD, DEFAULT_FUNCTION_2_ARG_MOD, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_BINOM_COEFF", stringResources.FUNCTION_2_ARG_BINOM_COEFF, DEFAULT_FUNCTION_2_ARG_BINOM_COEFF, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_BERNOULLI_NUMBER", stringResources.FUNCTION_2_ARG_BERNOULLI_NUMBER, DEFAULT_FUNCTION_2_ARG_BERNOULLI_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_STIRLING1_NUMBER", stringResources.FUNCTION_2_ARG_STIRLING1_NUMBER, DEFAULT_FUNCTION_2_ARG_STIRLING1_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_STIRLING2_NUMBER", stringResources.FUNCTION_2_ARG_STIRLING2_NUMBER, DEFAULT_FUNCTION_2_ARG_STIRLING2_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_WORPITZKY_NUMBER", stringResources.FUNCTION_2_ARG_WORPITZKY_NUMBER, DEFAULT_FUNCTION_2_ARG_WORPITZKY_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_EULER_NUMBER", stringResources.FUNCTION_2_ARG_EULER_NUMBER, DEFAULT_FUNCTION_2_ARG_EULER_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_KRONECKER_DELTA", stringResources.FUNCTION_2_ARG_KRONECKER_DELTA, DEFAULT_FUNCTION_2_ARG_KRONECKER_DELTA, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_EULER_POLYNOMIAL", stringResources.FUNCTION_2_ARG_EULER_POLYNOMIAL, DEFAULT_FUNCTION_2_ARG_EULER_POLYNOMIAL, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_HARMONIC_NUMBER", stringResources.FUNCTION_2_ARG_HARMONIC_NUMBER, DEFAULT_FUNCTION_2_ARG_HARMONIC_NUMBER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_ROUND", stringResources.FUNCTION_2_ARG_ROUND, DEFAULT_FUNCTION_2_ARG_ROUND, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_NDIG", stringResources.FUNCTION_2_ARG_NDIG, DEFAULT_FUNCTION_2_ARG_NDIG, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_DIGIT10", stringResources.FUNCTION_2_ARG_DIGIT10, DEFAULT_FUNCTION_2_ARG_DIGIT10, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_FACTVAL", stringResources.FUNCTION_2_ARG_FACTVAL, DEFAULT_FUNCTION_2_ARG_FACTVAL, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_FACTEXP", stringResources.FUNCTION_2_ARG_FACTEXP, DEFAULT_FUNCTION_2_ARG_FACTEXP, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_ROOT", stringResources.FUNCTION_2_ARG_ROOT, DEFAULT_FUNCTION_2_ARG_ROOT, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_INC_GAMMA_LOWER", stringResources.FUNCTION_2_ARG_INC_GAMMA_LOWER, DEFAULT_FUNCTION_2_ARG_INC_GAMMA_LOWER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_INC_GAMMA_UPPER", stringResources.FUNCTION_2_ARG_INC_GAMMA_UPPER, DEFAULT_FUNCTION_2_ARG_INC_GAMMA_UPPER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_REG_GAMMA_LOWER", stringResources.FUNCTION_2_ARG_REG_GAMMA_LOWER, DEFAULT_FUNCTION_2_ARG_REG_GAMMA_LOWER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_REG_GAMMA_UPPER", stringResources.FUNCTION_2_ARG_REG_GAMMA_UPPER, DEFAULT_FUNCTION_2_ARG_REG_GAMMA_UPPER, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_PERMUTATIONS", stringResources.FUNCTION_2_ARG_PERMUTATIONS, DEFAULT_FUNCTION_2_ARG_PERMUTATIONS, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_BETA", stringResources.FUNCTION_2_ARG_BETA, DEFAULT_FUNCTION_2_ARG_BETA, printDefault);
        printCurrentVsDefault("FUNCTION_2_ARG_LOG_BETA", stringResources.FUNCTION_2_ARG_LOG_BETA, DEFAULT_FUNCTION_2_ARG_LOG_BETA, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("FUNCTION_3_ARG_IF", stringResources.FUNCTION_3_ARG_IF, DEFAULT_FUNCTION_3_ARG_IF, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG_CHI", stringResources.FUNCTION_3_ARG_CHI, DEFAULT_FUNCTION_3_ARG_CHI, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG_CHI_LR", stringResources.FUNCTION_3_ARG_CHI_LR, DEFAULT_FUNCTION_3_ARG_CHI_LR, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG_CHI_L", stringResources.FUNCTION_3_ARG_CHI_L, DEFAULT_FUNCTION_3_ARG_CHI_L, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG_CHI_R", stringResources.FUNCTION_3_ARG_CHI_R, DEFAULT_FUNCTION_3_ARG_CHI_R, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG_DIGIT", stringResources.FUNCTION_3_ARG_DIGIT, DEFAULT_FUNCTION_3_ARG_DIGIT, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG_INC_BETA", stringResources.FUNCTION_3_ARG_INC_BETA, DEFAULT_FUNCTION_3_ARG_INC_BETA, printDefault);
        printCurrentVsDefault("FUNCTION_3_ARG_REG_BETA", stringResources.FUNCTION_3_ARG_REG_BETA, DEFAULT_FUNCTION_3_ARG_REG_BETA, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("FUNCTION_VARIADIC_IFF", stringResources.FUNCTION_VARIADIC_IFF, DEFAULT_FUNCTION_VARIADIC_IFF, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_MIN", stringResources.FUNCTION_VARIADIC_MIN, DEFAULT_FUNCTION_VARIADIC_MIN, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_MAX", stringResources.FUNCTION_VARIADIC_MAX, DEFAULT_FUNCTION_VARIADIC_MAX, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_CONT_FRAC", stringResources.FUNCTION_VARIADIC_CONT_FRAC, DEFAULT_FUNCTION_VARIADIC_CONT_FRAC, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_CONT_POL", stringResources.FUNCTION_VARIADIC_CONT_POL, DEFAULT_FUNCTION_VARIADIC_CONT_POL, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_GCD", stringResources.FUNCTION_VARIADIC_GCD, DEFAULT_FUNCTION_VARIADIC_GCD, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_LCM", stringResources.FUNCTION_VARIADIC_LCM, DEFAULT_FUNCTION_VARIADIC_LCM, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_SUM", stringResources.FUNCTION_VARIADIC_SUM, DEFAULT_FUNCTION_VARIADIC_SUM, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_PROD", stringResources.FUNCTION_VARIADIC_PROD, DEFAULT_FUNCTION_VARIADIC_PROD, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_AVG", stringResources.FUNCTION_VARIADIC_AVG, DEFAULT_FUNCTION_VARIADIC_AVG, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_VAR", stringResources.FUNCTION_VARIADIC_VAR, DEFAULT_FUNCTION_VARIADIC_VAR, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_STD", stringResources.FUNCTION_VARIADIC_STD, DEFAULT_FUNCTION_VARIADIC_STD, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_RND_LIST", stringResources.FUNCTION_VARIADIC_RND_LIST, DEFAULT_FUNCTION_VARIADIC_RND_LIST, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_COALESCE", stringResources.FUNCTION_VARIADIC_COALESCE, DEFAULT_FUNCTION_VARIADIC_COALESCE, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_OR", stringResources.FUNCTION_VARIADIC_OR, DEFAULT_FUNCTION_VARIADIC_OR, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_AND", stringResources.FUNCTION_VARIADIC_AND, DEFAULT_FUNCTION_VARIADIC_AND, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_XOR", stringResources.FUNCTION_VARIADIC_XOR, DEFAULT_FUNCTION_VARIADIC_XOR, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_ARGMIN", stringResources.FUNCTION_VARIADIC_ARGMIN, DEFAULT_FUNCTION_VARIADIC_ARGMIN, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_ARGMAX", stringResources.FUNCTION_VARIADIC_ARGMAX, DEFAULT_FUNCTION_VARIADIC_ARGMAX, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_MEDIAN", stringResources.FUNCTION_VARIADIC_MEDIAN, DEFAULT_FUNCTION_VARIADIC_MEDIAN, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_MODE", stringResources.FUNCTION_VARIADIC_MODE, DEFAULT_FUNCTION_VARIADIC_MODE, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_BASE", stringResources.FUNCTION_VARIADIC_BASE, DEFAULT_FUNCTION_VARIADIC_BASE, printDefault);
        printCurrentVsDefault("FUNCTION_VARIADIC_NDIST", stringResources.FUNCTION_VARIADIC_NDIST, DEFAULT_FUNCTION_VARIADIC_NDIST, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("OPERATOR_PLUS", stringResources.OPERATOR_PLUS, DEFAULT_OPERATOR_PLUS, printDefault);
        printCurrentVsDefault("OPERATOR_MINUS", stringResources.OPERATOR_MINUS, DEFAULT_OPERATOR_MINUS, printDefault);
        printCurrentVsDefault("OPERATOR_MULTIPLY", stringResources.OPERATOR_MULTIPLY, DEFAULT_OPERATOR_MULTIPLY, printDefault);
        printCurrentVsDefault("OPERATOR_DIVIDE", stringResources.OPERATOR_DIVIDE, DEFAULT_OPERATOR_DIVIDE, printDefault);
        printCurrentVsDefault("OPERATOR_DIVIDE_QUOTIENT", stringResources.OPERATOR_DIVIDE_QUOTIENT, DEFAULT_OPERATOR_DIVIDE_QUOTIENT, printDefault);
        printCurrentVsDefault("OPERATOR_POWER", stringResources.OPERATOR_POWER, DEFAULT_OPERATOR_POWER, printDefault);
        printCurrentVsDefault("OPERATOR_FACT", stringResources.OPERATOR_FACT, DEFAULT_OPERATOR_FACT, printDefault);
        printCurrentVsDefault("OPERATOR_MOD", stringResources.OPERATOR_MOD, DEFAULT_OPERATOR_MOD, printDefault);
        printCurrentVsDefault("OPERATOR_PERC", stringResources.OPERATOR_PERC, DEFAULT_OPERATOR_PERC, printDefault);
        printCurrentVsDefault("OPERATOR_TETRATION", stringResources.OPERATOR_TETRATION, DEFAULT_OPERATOR_TETRATION, printDefault);
        printCurrentVsDefault("OPERATOR_SQUARE_ROOT", stringResources.OPERATOR_SQUARE_ROOT, DEFAULT_OPERATOR_SQUARE_ROOT, printDefault);
        printCurrentVsDefault("OPERATOR_CUBE_ROOT", stringResources.OPERATOR_CUBE_ROOT, DEFAULT_OPERATOR_CUBE_ROOT, printDefault);
        printCurrentVsDefault("OPERATOR_FOURTH_ROOT", stringResources.OPERATOR_FOURTH_ROOT, DEFAULT_OPERATOR_FOURTH_ROOT, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("PARSER_SYMBOL_LEFT_PARENTHESES", stringResources.PARSER_SYMBOL_LEFT_PARENTHESES, DEFAULT_PARSER_SYMBOL_LEFT_PARENTHESES, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_RIGHT_PARENTHESES", stringResources.PARSER_SYMBOL_RIGHT_PARENTHESES, DEFAULT_PARSER_SYMBOL_RIGHT_PARENTHESES, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_COMMA", stringResources.PARSER_SYMBOL_COMMA, DEFAULT_PARSER_SYMBOL_COMMA, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_SEMI", stringResources.PARSER_SYMBOL_SEMI, DEFAULT_PARSER_SYMBOL_SEMI, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_BLANK", stringResources.PARSER_SYMBOL_BLANK, DEFAULT_PARSER_SYMBOL_BLANK, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_NUMBER_INTEGER", stringResources.PARSER_SYMBOL_NUMBER_INTEGER, DEFAULT_PARSER_SYMBOL_NUMBER_INTEGER, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_NUMBER_DECIMAL", stringResources.PARSER_SYMBOL_NUMBER_DECIMAL, DEFAULT_PARSER_SYMBOL_NUMBER_DECIMAL, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_NUMBER_LEADING_ZERO", stringResources.PARSER_SYMBOL_NUMBER_LEADING_ZERO, DEFAULT_PARSER_SYMBOL_NUMBER_LEADING_ZERO, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_NUMBER_SCI_NOTATION", stringResources.PARSER_SYMBOL_NUMBER_SCI_NOTATION, DEFAULT_PARSER_SYMBOL_NUMBER_SCI_NOTATION, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO", stringResources.PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO, DEFAULT_PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_NUMBER_FRACTIONS", stringResources.PARSER_SYMBOL_NUMBER_FRACTIONS, DEFAULT_PARSER_SYMBOL_NUMBER_FRACTIONS, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS", stringResources.PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS, DEFAULT_PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS, printDefault);
        printCurrentVsDefault("PARSER_SYMBOL_UNICODE_MATH", stringResources.PARSER_SYMBOL_UNICODE_MATH, DEFAULT_PARSER_SYMBOL_UNICODE_MATH, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_PERC", stringResources.DIMENSIONLESS_UNIT_PERC, DEFAULT_DIMENSIONLESS_UNIT_PERC, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_PROMIL", stringResources.DIMENSIONLESS_UNIT_PERM, DEFAULT_DIMENSIONLESS_UNIT_PERM, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_YOTTA", stringResources.DIMENSIONLESS_UNIT_YOTTA, DEFAULT_DIMENSIONLESS_UNIT_YOTTA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_ZETTA", stringResources.DIMENSIONLESS_UNIT_ZETTA, DEFAULT_DIMENSIONLESS_UNIT_ZETTA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_EXA", stringResources.DIMENSIONLESS_UNIT_EXA, DEFAULT_DIMENSIONLESS_UNIT_EXA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_PETA", stringResources.DIMENSIONLESS_UNIT_PETA, DEFAULT_DIMENSIONLESS_UNIT_PETA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_TERA", stringResources.DIMENSIONLESS_UNIT_TERA, DEFAULT_DIMENSIONLESS_UNIT_TERA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_GIGA", stringResources.DIMENSIONLESS_UNIT_GIGA, DEFAULT_DIMENSIONLESS_UNIT_GIGA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_MEGA", stringResources.DIMENSIONLESS_UNIT_MEGA, DEFAULT_DIMENSIONLESS_UNIT_MEGA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_KILO", stringResources.DIMENSIONLESS_UNIT_KILO, DEFAULT_DIMENSIONLESS_UNIT_KILO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_HECTO", stringResources.DIMENSIONLESS_UNIT_HECTO, DEFAULT_DIMENSIONLESS_UNIT_HECTO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_DECA", stringResources.DIMENSIONLESS_UNIT_DECA, DEFAULT_DIMENSIONLESS_UNIT_DECA, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_DECI", stringResources.DIMENSIONLESS_UNIT_DECI, DEFAULT_DIMENSIONLESS_UNIT_DECI, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_CENTI", stringResources.DIMENSIONLESS_UNIT_CENTI, DEFAULT_DIMENSIONLESS_UNIT_CENTI, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_MILLI", stringResources.DIMENSIONLESS_UNIT_MILLI, DEFAULT_DIMENSIONLESS_UNIT_MILLI, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_MICRO", stringResources.DIMENSIONLESS_UNIT_MICRO, DEFAULT_DIMENSIONLESS_UNIT_MICRO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_NANO", stringResources.DIMENSIONLESS_UNIT_NANO, DEFAULT_DIMENSIONLESS_UNIT_NANO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_PICO", stringResources.DIMENSIONLESS_UNIT_PICO, DEFAULT_DIMENSIONLESS_UNIT_PICO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_FEMTO", stringResources.DIMENSIONLESS_UNIT_FEMTO, DEFAULT_DIMENSIONLESS_UNIT_FEMTO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_ATTO", stringResources.DIMENSIONLESS_UNIT_ATTO, DEFAULT_DIMENSIONLESS_UNIT_ATTO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_ZEPTO", stringResources.DIMENSIONLESS_UNIT_ZEPTO, DEFAULT_DIMENSIONLESS_UNIT_ZEPTO, printDefault);
        printCurrentVsDefault("DIMENSIONLESS_UNIT_YOCTO", stringResources.DIMENSIONLESS_UNIT_YOCTO, DEFAULT_DIMENSIONLESS_UNIT_YOCTO, printDefault);
        /* ------------------------------------------------- */ StringUtils.consolePrintln(LINE_BREAK);
        printCurrentVsDefault("UNIT_METRE", stringResources.UNIT_METRE, DEFAULT_UNIT_METRE, printDefault);
        printCurrentVsDefault("UNIT_KILOMETRE", stringResources.UNIT_KILOMETRE, DEFAULT_UNIT_KILOMETRE, printDefault);
        printCurrentVsDefault("UNIT_CENTIMETRE", stringResources.UNIT_CENTIMETRE, DEFAULT_UNIT_CENTIMETRE, printDefault);
        printCurrentVsDefault("UNIT_MILLIMETRE", stringResources.UNIT_MILLIMETRE, DEFAULT_UNIT_MILLIMETRE, printDefault);
        printCurrentVsDefault("UNIT_INCH", stringResources.UNIT_INCH, DEFAULT_UNIT_INCH, printDefault);
        printCurrentVsDefault("UNIT_YARD", stringResources.UNIT_YARD, DEFAULT_UNIT_YARD, printDefault);
        printCurrentVsDefault("UNIT_FEET", stringResources.UNIT_FEET, DEFAULT_UNIT_FEET, printDefault);
        printCurrentVsDefault("UNIT_MILE", stringResources.UNIT_MILE, DEFAULT_UNIT_MILE, printDefault);
        printCurrentVsDefault("UNIT_NAUTICAL_MILE", stringResources.UNIT_NAUTICAL_MILE, DEFAULT_UNIT_NAUTICAL_MILE, printDefault);
        printCurrentVsDefault("UNIT_METRE2", stringResources.UNIT_METRE2, DEFAULT_UNIT_METRE2, printDefault);
        printCurrentVsDefault("UNIT_CENTIMETRE2", stringResources.UNIT_CENTIMETRE2, DEFAULT_UNIT_CENTIMETRE2, printDefault);
        printCurrentVsDefault("UNIT_MILLIMETRE2", stringResources.UNIT_MILLIMETRE2, DEFAULT_UNIT_MILLIMETRE2, printDefault);
        printCurrentVsDefault("UNIT_ARE", stringResources.UNIT_ARE, DEFAULT_UNIT_ARE, printDefault);
        printCurrentVsDefault("UNIT_HECTARE", stringResources.UNIT_HECTARE, DEFAULT_UNIT_HECTARE, printDefault);
        printCurrentVsDefault("UNIT_ACRE", stringResources.UNIT_ACRE, DEFAULT_UNIT_ACRE, printDefault);
        printCurrentVsDefault("UNIT_KILOMETRE2", stringResources.UNIT_KILOMETRE2, DEFAULT_UNIT_KILOMETRE2, printDefault);
        printCurrentVsDefault("UNIT_MILLIMETRE3", stringResources.UNIT_MILLIMETRE3, DEFAULT_UNIT_MILLIMETRE3, printDefault);
        printCurrentVsDefault("UNIT_CENTIMETRE3", stringResources.UNIT_CENTIMETRE3, DEFAULT_UNIT_CENTIMETRE3, printDefault);
        printCurrentVsDefault("UNIT_METRE3", stringResources.UNIT_METRE3, DEFAULT_UNIT_METRE3, printDefault);
        printCurrentVsDefault("UNIT_KILOMETRE3", stringResources.UNIT_KILOMETRE3, DEFAULT_UNIT_KILOMETRE3, printDefault);
        printCurrentVsDefault("UNIT_MILLILITRE", stringResources.UNIT_MILLILITRE, DEFAULT_UNIT_MILLILITRE, printDefault);
        printCurrentVsDefault("UNIT_LITRE", stringResources.UNIT_LITRE, DEFAULT_UNIT_LITRE, printDefault);
        printCurrentVsDefault("UNIT_GALLON", stringResources.UNIT_GALLON, DEFAULT_UNIT_GALLON, printDefault);
        printCurrentVsDefault("UNIT_PINT", stringResources.UNIT_PINT, DEFAULT_UNIT_PINT, printDefault);
        printCurrentVsDefault("UNIT_SECOND", stringResources.UNIT_SECOND, DEFAULT_UNIT_SECOND, printDefault);
        printCurrentVsDefault("UNIT_MILLISECOND", stringResources.UNIT_MILLISECOND, DEFAULT_UNIT_MILLISECOND, printDefault);
        printCurrentVsDefault("UNIT_MINUTE", stringResources.UNIT_MINUTE, DEFAULT_UNIT_MINUTE, printDefault);
        printCurrentVsDefault("UNIT_HOUR", stringResources.UNIT_HOUR, DEFAULT_UNIT_HOUR, printDefault);
        printCurrentVsDefault("UNIT_DAY", stringResources.UNIT_DAY, DEFAULT_UNIT_DAY, printDefault);
        printCurrentVsDefault("UNIT_WEEK", stringResources.UNIT_WEEK, DEFAULT_UNIT_WEEK, printDefault);
        printCurrentVsDefault("UNIT_JULIAN_YEAR", stringResources.UNIT_JULIAN_YEAR, DEFAULT_UNIT_JULIAN_YEAR, printDefault);
        printCurrentVsDefault("UNIT_KILOGRAM", stringResources.UNIT_KILOGRAM, DEFAULT_UNIT_KILOGRAM, printDefault);
        printCurrentVsDefault("UNIT_GRAM", stringResources.UNIT_GRAM, DEFAULT_UNIT_GRAM, printDefault);
        printCurrentVsDefault("UNIT_MILLIGRAM", stringResources.UNIT_MILLIGRAM, DEFAULT_UNIT_MILLIGRAM, printDefault);
        printCurrentVsDefault("UNIT_DECAGRAM", stringResources.UNIT_DECAGRAM, DEFAULT_UNIT_DECAGRAM, printDefault);
        printCurrentVsDefault("UNIT_TONNE", stringResources.UNIT_TONNE, DEFAULT_UNIT_TONNE, printDefault);
        printCurrentVsDefault("UNIT_OUNCE", stringResources.UNIT_OUNCE, DEFAULT_UNIT_OUNCE, printDefault);
        printCurrentVsDefault("UNIT_POUND", stringResources.UNIT_POUND, DEFAULT_UNIT_POUND, printDefault);
        printCurrentVsDefault("UNIT_BIT", stringResources.UNIT_BIT, DEFAULT_UNIT_BIT, printDefault);
        printCurrentVsDefault("UNIT_KILOBIT", stringResources.UNIT_KILOBIT, DEFAULT_UNIT_KILOBIT, printDefault);
        printCurrentVsDefault("UNIT_MEGABIT", stringResources.UNIT_MEGABIT, DEFAULT_UNIT_MEGABIT, printDefault);
        printCurrentVsDefault("UNIT_GIGABIT", stringResources.UNIT_GIGABIT, DEFAULT_UNIT_GIGABIT, printDefault);
        printCurrentVsDefault("UNIT_TERABIT", stringResources.UNIT_TERABIT, DEFAULT_UNIT_TERABIT, printDefault);
        printCurrentVsDefault("UNIT_PETABIT", stringResources.UNIT_PETABIT, DEFAULT_UNIT_PETABIT, printDefault);
        printCurrentVsDefault("UNIT_EXABIT", stringResources.UNIT_EXABIT, DEFAULT_UNIT_EXABIT, printDefault);
        printCurrentVsDefault("UNIT_ZETTABIT", stringResources.UNIT_ZETTABIT, DEFAULT_UNIT_ZETTABIT, printDefault);
        printCurrentVsDefault("UNIT_YOTTABIT", stringResources.UNIT_YOTTABIT, DEFAULT_UNIT_YOTTABIT, printDefault);
        printCurrentVsDefault("UNIT_BYTE", stringResources.UNIT_BYTE, DEFAULT_UNIT_BYTE, printDefault);
        printCurrentVsDefault("UNIT_KILOBYTE", stringResources.UNIT_KILOBYTE, DEFAULT_UNIT_KILOBYTE, printDefault);
        printCurrentVsDefault("UNIT_MEGABYTE", stringResources.UNIT_MEGABYTE, DEFAULT_UNIT_MEGABYTE, printDefault);
        printCurrentVsDefault("UNIT_GIGABYTE", stringResources.UNIT_GIGABYTE, DEFAULT_UNIT_GIGABYTE, printDefault);
        printCurrentVsDefault("UNIT_TERABYTE", stringResources.UNIT_TERABYTE, DEFAULT_UNIT_TERABYTE, printDefault);
        printCurrentVsDefault("UNIT_PETABYTE", stringResources.UNIT_PETABYTE, DEFAULT_UNIT_PETABYTE, printDefault);
        printCurrentVsDefault("UNIT_EXABYTE", stringResources.UNIT_EXABYTE, DEFAULT_UNIT_EXABYTE, printDefault);
        printCurrentVsDefault("UNIT_ZETTABYTE", stringResources.UNIT_ZETTABYTE, DEFAULT_UNIT_ZETTABYTE, printDefault);
        printCurrentVsDefault("UNIT_YOTTABYTE", stringResources.UNIT_YOTTABYTE, DEFAULT_UNIT_YOTTABYTE, printDefault);
        printCurrentVsDefault("UNIT_JOULE", stringResources.UNIT_JOULE, DEFAULT_UNIT_JOULE, printDefault);
        printCurrentVsDefault("UNIT_ELECTRONO_VOLT", stringResources.UNIT_ELECTRONO_VOLT, DEFAULT_UNIT_ELECTRONO_VOLT, printDefault);
        printCurrentVsDefault("UNIT_KILO_ELECTRONO_VOLT", stringResources.UNIT_KILO_ELECTRONO_VOLT, DEFAULT_UNIT_KILO_ELECTRONO_VOLT, printDefault);
        printCurrentVsDefault("UNIT_MEGA_ELECTRONO_VOLT", stringResources.UNIT_MEGA_ELECTRONO_VOLT, DEFAULT_UNIT_MEGA_ELECTRONO_VOLT, printDefault);
        printCurrentVsDefault("UNIT_GIGA_ELECTRONO_VOLT", stringResources.UNIT_GIGA_ELECTRONO_VOLT, DEFAULT_UNIT_GIGA_ELECTRONO_VOLT, printDefault);
        printCurrentVsDefault("UNIT_TERA_ELECTRONO_VOLT", stringResources.UNIT_TERA_ELECTRONO_VOLT, DEFAULT_UNIT_TERA_ELECTRONO_VOLT, printDefault);
        printCurrentVsDefault("UNIT_METRE_PER_SECOND", stringResources.UNIT_METRE_PER_SECOND, DEFAULT_UNIT_METRE_PER_SECOND, printDefault);
        printCurrentVsDefault("UNIT_KILOMETRE_PER_HOUR", stringResources.UNIT_KILOMETRE_PER_HOUR, DEFAULT_UNIT_KILOMETRE_PER_HOUR, printDefault);
        printCurrentVsDefault("UNIT_MILE_PER_HOUR", stringResources.UNIT_MILE_PER_HOUR, DEFAULT_UNIT_MILE_PER_HOUR, printDefault);
        printCurrentVsDefault("UNIT_KNOT", stringResources.UNIT_KNOT, DEFAULT_UNIT_KNOT, printDefault);
        printCurrentVsDefault("UNIT_METRE_PER_SECOND2", stringResources.UNIT_METRE_PER_SECOND2, DEFAULT_UNIT_METRE_PER_SECOND2, printDefault);
        printCurrentVsDefault("UNIT_KILOMETRE_PER_HOUR2", stringResources.UNIT_KILOMETRE_PER_HOUR2, DEFAULT_UNIT_KILOMETRE_PER_HOUR2, printDefault);
        printCurrentVsDefault("UNIT_MILE_PER_HOUR2", stringResources.UNIT_MILE_PER_HOUR2, DEFAULT_UNIT_MILE_PER_HOUR2, printDefault);
        printCurrentVsDefault("UNIT_RADIAN_ARC", stringResources.UNIT_RADIAN_ARC, DEFAULT_UNIT_RADIAN_ARC, printDefault);
        printCurrentVsDefault("UNIT_DEGREE_ARC", stringResources.UNIT_DEGREE_ARC, DEFAULT_UNIT_DEGREE_ARC, printDefault);
        printCurrentVsDefault("UNIT_MINUTE_ARC", stringResources.UNIT_MINUTE_ARC, DEFAULT_UNIT_MINUTE_ARC, printDefault);
        printCurrentVsDefault("UNIT_SECOND_ARC", stringResources.UNIT_SECOND_ARC, DEFAULT_UNIT_SECOND_ARC, printDefault);
    }
}