/*
 * @(#)StringResourcesPolish.java        6.0.0    2024-05-19
 *
 * MathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19
 * The most up-to-date license is available at the below link:
 * - https://mathparser.org/mxparser-license
 *
 * AUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved
 * PUBLISHER: INFIMA - https://payhip.com/infima
 *
 * SOFTWARE means source code and/or binary form and/or documentation.
 * PRODUCT: MathParser.org-mXparser SOFTWARE
 * LICENSE: DUAL LICENSE AGREEMENT
 *
 * BY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE
 * BOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.
 *
 * The AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT
 * model designed to meet the needs of both non-commercial use and commercial
 * use.
 *
 * NON-COMMERCIAL USE means any use or activity where a fee is not charged
 * and the purpose is not the sale of a good or service, and the use or
 * activity is not intended to produce a profit. Examples of NON-COMMERCIAL USE
 * include:
 *
 * 1. Non-commercial open-source software.
 * 2. Non-commercial mobile applications.
 * 3. Non-commercial desktop software.
 * 4. Non-commercial web applications/solutions.
 * 5. Non-commercial use in research, scholarly and educational context.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * COMMERCIAL USE means any use or activity where a fee is charged or the
 * purpose is the sale of a good or service, or the use or activity is
 * intended to produce a profit. COMMERCIAL USE examples:
 *
 * 1. OEMs (Original Equipment Manufacturers).
 * 2. ISVs (Independent Software Vendors).
 * 3. VARs (Value Added Resellers).
 * 4. Other distributors that combine and distribute commercially licensed
 *    software.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * IN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE
 * APPROPRIATE LICENSE FROM "INFIMA" ONLINE STORE, STORE ADDRESS:
 *
 * 1. https://mathparser.org/order-commercial-license
 * 2. https://payhip.com/infima
 *
 * NON-COMMERCIAL LICENSE
 *
 * Redistribution and use of the PRODUCT in source and/or binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the unmodified content of
 *    the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including
 *    the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,
 *    the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 2. Redistributions in binary form must reproduce the entire content of
 *    MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation
 *    and/or other materials provided with the distribution, including the
 *    definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the
 *    NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 3. Any form of redistribution requires confirmation and signature of
 *    the NON-COMMERCIAL USE by successfully calling the method:
 *       License.iConfirmNonCommercialUse(...)
 *    The method call is used only internally for logging purposes, and
 *    there is no connection with other external services, and no data is
 *    sent or collected. The lack of a method call (or its successful call)
 *    does not affect the operation of the PRODUCT in any way. Please see
 *    the API documentation.
 *
 * COMMERCIAL LICENSE
 *
 *  1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow
 *     you to download, install, and use up to three copies of the PRODUCT to
 *     perform integration tests, confirm the quality of the PRODUCT, and
 *     its suitability. The testing period should be limited to fourteen
 *     days. Tests should be performed under the test environments conditions
 *     and not for profit generation.
 *  2. Provided that you purchased a license from "INFIMA" online store
 *     (store address: https://mathparser.org/order-commercial-license or
 *     https://payhip.com/infima), and you comply with all terms and
 *     conditions below, and you have acknowledged and understood the
 *     following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive
 *     license with the following rights:
 *  3. The license is granted only to you, the person or entity that made
 *     the purchase, identified and confirmed by the data provided during
 *     the purchase.
 *  4. If you purchased a license in the "ONE-TIME PURCHASE" model, the
 *     license is granted only for the PRODUCT version specified in the
 *     purchase. The upgrade policy gives you additional rights, described
 *     in the dedicated section below.
 *  5. If you purchased a license in the "SUBSCRIPTION" model, you may
 *     install and use any version of the PRODUCT during the subscription
 *     validity period.
 *  6. If you purchased a "SINGLE LICENSE" you may install and use the
 *     PRODUCT on/from one workstation that is located/accessible at/from
 *     any of your premises.
 *  7. Additional copies of the PRODUCT may be installed and used on/from
 *     more than one workstation, limited to the number of workstations
 *     purchased per order.
 *  8. If you purchased a "SITE LICENSE", the PRODUCT may be installed
 *     and used on/from all workstations located/accessible at/from any
 *     of your premises.
 *  9. You may incorporate the unmodified PRODUCT into your own products
 *     and software.
 * 10. If you purchased a license with the "SOURCE CODE" option, you may
 *     modify the PRODUCT's source code and incorporate the modified source
 *     code into your own products and/or software.
 * 11. Provided that the license validity period has not expired, you may
 *     distribute your product and/or software with the incorporated
 *     PRODUCT royalty-free.
 * 12. You may make copies of the PRODUCT for backup and archival purposes.
 * 13. Any form of redistribution requires confirmation and signature of
 *     the COMMERCIAL USE by successfully calling the method:
 *        License.iConfirmCommercialUse(...)
 *     The method call is used only internally for logging purposes, and
 *     there is no connection with other external services, and no data is
 *     sent or collected. The lack of a method call (or its successful call)
 *     does not affect the operation of the PRODUCT in any way. Please see
 *     the API documentation.
 * 14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to
 *     you in this agreement.
 *
 * ADDITIONAL CLARIFICATION ON WORKSTATION
 *
 * A workstation is a device, a remote device, or a virtual device, used by
 * you, your employees, or other entities to whom you have commissioned
 * tasks. For example, the number of workstations may refer to the number
 * of software developers, engineers, architects, scientists, and other
 * professionals who use the PRODUCT on your behalf. The number of
 * workstations is not the number of copies of your end-product that you
 * distribute to your end-users.
 *
 * By purchasing the COMMERCIAL LICENSE, you only pay for the number of
 * workstations, while the number of copies/users of your final product
 * (delivered to your end-users) is not limited.
 *
 * Below are some examples to help you select the right license size:
 *
 * Example 1: Single Workstation License
 * Only one developer works on the development of your application. You do
 * not use separate environments for testing, meaning you design, create,
 * test, and compile your final application on one environment. In this
 * case, you need a license for a single workstation.
 *
 * Example 2: Up to 5 Workstations License
 * Two developers are working on the development of your application.
 * Additionally, one tester conducts tests in a separate environment.
 * You use three workstations in total, so you need a license for up to
 * five workstations.
 *
 * Example 3: Up to 20 Workstations License
 * Ten developers are working on the development of your application.
 * Additionally, five testers conduct tests in separate environments.
 * You use fifteen workstations in total, so you need a license for
 * up to twenty workstations.
 *
 * Example 4: Site License
 * Several dozen developers and testers work on the development of your
 * application using multiple environments. You have a large,
 * multi-disciplinary team involved in creating your solution. As your team
 * is growing and you want to avoid licensing limitations, the best choice
 * would be a site license.
 *
 * UPGRADE POLICY
 *
 * The PRODUCT is versioned according to the following convention:
 *
 *    [MAJOR].[MINOR].[PATCH]
 *
 * 1. COMMERCIAL LICENSE holders can install and use the updated version
 *    for bug fixes free of charge, i.e. if you have purchased a license
 *    for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install
 *    all releases specified in the [PATCH] version (e.g., 5.0.2).
 *    The license terms remain unchanged after the update.
 * 2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)
 *    can install and use the updated version [MAJOR].[MINOR + 1] free of
 *    charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The
 *    license terms remain unchanged after the update.
 * 3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are
 *    not eligible for the free upgrade, can claim a discount when
 *    purchasing the upgrade. For this purpose, please contact us via e-mail.
 *
 * DISCLAIMER
 *
 * THIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE
 * THOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING
 * OFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.
 *
 * CONTACT
 *
 * - e-mail: info@mathparser.org
 * - website: https://mathparser.org
 * - source code: https://github.com/mariuszgromada/MathParser.org-mXparser
 * - online store: https://mathparser.org/order-commercial-license
 * - online store: https://payhip.com/infima
 */
package org.mariuszgromada.math.mxparser;

/**
 * A class containing definition of Polish user language
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="https://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="https://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser on GitHub</a><br>
 *                 <a href="https://payhip.com/INFIMA" target="_blank">INFIMA place to purchase a commercial MathParser.org-mXparser software license</a><br>
 *                 <a href="mailto:info@mathparser.org">info@mathparser.org</a><br>
 *                 <a href="https://scalarmath.org/" target="_blank">ScalarMath.org - a powerful math engine and math scripting language</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.lite" target="_blank">Scalar Lite</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.pro" target="_blank">Scalar Pro</a><br>
 *                 <a href="https://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *
 * @version        6.0.0
 *
 * @see StringResources
 * @see StringModel
 * @see StringModel#setStringResources(StringResources)
 * @see StringModel#getStringResources()
 */
class StringResourcesPolish extends StringResources {
    StringResourcesPolish() {
        USER_LANGUAGE = "Polski";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK = "Rozpoczynanie sprawdzania składni...";
        NO_ERRORS_DETECTED = "Nie wykryto błędów.";
        NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = "Nie wykryto błędów w definicji argumentu.";
        NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = "Nie wykryto błędów w rekurencyjnej definicji argumentu.";
        NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = "Nie wykryto błędów w definicji funkcji.";
        NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = "Nie wykryto błędów w definicji stałej.";
        LEXICAL_ERROR_HAS_BEEN_FOUND = "Znaleziono błąd leksykalny.";
        ERRORS_HAVE_BEEN_FOUND = "Znaleziono błędy.";
        ALREADY_CHECKED_NO_ERRORS = "Składnia została już sprawdzona - nie wykryto błędów.";
        SYNTAX_STATUS_UNKNOWN = "Status składni jest nieznany.";
        PROBLEM_WITH_EXPRESSION_SYNTAX = "Występuje problem ze składnią wyrażenia.";
        // -------------------------------------------------
        ENCOUNTERED = "Napotkano";
        AT_INDEX = "na indeksie";
        WAS_EXPECTING = "Oczekiwano";
        WAS_EXPECTING_ONE_OF = "Oczekiwano jednego z";
        UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = "Napotkano nieoczekiwany wyjątek. Prawdopodobnie błąd parsera - proszę zgłosić to.";
        UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = "Napotkano nieoczekiwany błąd parsera tokenów. Prawdopodobnie błąd parsera - proszę zgłosić to.";
        // -------------------------------------------------
        EXPRESSION_STRING_IS_EMPTY = "Łańcuch wyrażenia jest pusty.";
        EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = "Wyrażenie nie zawiera żadnych tokenów.";
        DUPLICATED_KEYWORD = "Znaleziono zduplikowane słowo kluczowe. Sprawdź elementy zdefiniowane przez użytkownika. Rozważ użycie opcji zastępowania wbudowanych tokenów.";
        ELEMENT = "Element";
        ERROR = "Błąd";
        EXCEPTION = "Wyjątek";
        TOKEN = "Token";
        INDEX = "indeks";
        INVALID_TOKEN = "Nieprawidłowy token.";
        INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = "Nieprawidłowy token. Prawdopodobnie brakuje operatora mnożenia - spróbuj trybu domniemanego mnożenia.";
        EXPRESSION_TOKENS = "Tokeny wyrażenia";
        NULL_TOKENS_LIST = "Pusta lista tokenów";
        // -------------------------------------------------
        FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = "Zdefiniowana przez użytkownika funkcja z rozszerzonym ciałem - założenie braku błędów.";
        ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = "Zdefiniowany przez użytkownika argument z rozszerzonym ciałem - założenie braku błędów.";
        PROVIDED_EXTENSION_IS_NULL = "Podane rozszerzenie jest null.";
        PROVIDED_STRING_IS_NULL = "Podany łańcuch jest null.";
        PROVIDED_ELEMENTS_ARE_NULL = "Podane elementy są null.";
        MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = "Prawdopodobnie brakuje operatora mnożenia - spróbuj trybu domniemanego mnożenia.";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = "Rozpoczęcie sprawdzania składni zależnego argumentu zdefiniowanego przez użytkownika.";
        STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = "Rozpoczęcie sprawdzania składni rekurencyjnego argumentu zdefiniowanego przez użytkownika.";
        STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = "Rozpoczęcie sprawdzania składni zdefiniowanej przez użytkownika funkcji.";
        STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = "Rozpoczęcie sprawdzania składni zdefiniowanej przez użytkownika funkcji zmiennych.";
        // -------------------------------------------------
        ARGUMENT_WAS_EXPECTED = "Oczekiwano argumentu zdefiniowanego przez użytkownika.";
        RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = "Rekurencyjny argument zdefiniowany przez użytkownika wymaga jednego parametru.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = "Nieprawidłowa liczba parametrów w zdefiniowanej przez użytkownika funkcji.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = "Nieprawidłowa liczba parametrów funkcji.";
        EXPECTED = "Oczekiwano";
        PROVIDED = "Podano";
        USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = "Nieprawidłowa liczba parametrów w zdefiniowanej przez użytkownika funkcji - oczekiwany jest przynajmniej jeden argument.";
        EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = "Oczekiwano parzystej liczby argumentów.";
        // -------------------------------------------------
        INVALID_FUNCTION_NAME = "Nieprawidłowa nazwa funkcji.";
        INVALID_ARGUMENT_NAME = "Nieprawidłowa nazwa argumentu.";
        INVALID_CONSTANT_NAME = "Nieprawidłowa nazwa stałej.";
        INVALID_FUNCTION_DEFINITION = "Nieprawidłowa definicja funkcji.";
        INVALID_ARGUMENT_DEFINITION = "Nieprawidłowa definicja argumentu.";
        INVALID_CONSTANT_DEFINITION = "Nieprawidłowa definicja stałej.";
        PATTERN_DOES_NOT_MATCH = "Wzorzec nie pasuje.";
        PATTERN_EXAMPLES = "Przykłady wzorca";
        // -------------------------------------------------
        CONSTANT_WAS_EXPECTED = "Oczekiwano wartości stałej.";
        USER_CONSTANT_WAS_EXPECTED = "Oczekiwano zdefiniowanej przez użytkownika stałej.";
        // -------------------------------------------------
        UNARY_FUNCTION_EXPECTS_1_PARAMETER = "Funkcja jednoargumentowa oczekuje 1 parametru.";
        BINARY_FUNCTION_EXPECTS_2_PARAMETERS = "Funkcja dwuargumentowa oczekuje 2 parametrów.";
        TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = "Funkcja trójargumentowa oczekuje 3 parametrów.";
        // -------------------------------------------------
        DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = "Operator różniczkowania oczekuje 2, 3, 4 lub 5 parametrów kalkulacyjnych.";
        ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = "Oczekiwano argumentu w wywołaniu operatora różniczkowania.";
        DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Znaleziono zduplikowane słowa kluczowe w wywołaniu operatora kalkulacyjnego. Sprawdź parametry kalkulacyjne.";
        ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Oczekiwano jednego tokenu (argumentu lub nieznanego) w wywołaniu operatora kalkulacyjnego.";
        NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = "Operator różniczkowania N-tego rzędu oczekuje 3 lub 5 parametrów kalkulacyjnych.";
        INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = "Operator całkowania / rozwiązania oczekuje 4 parametrów kalkulacyjnych.";
        ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = "Operator iterowany oczekuje 4 lub 5 parametrów kalkulacyjnych.";
        FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = "Operator różnicy w przód / w tył oczekuje 2 lub 3 parametrów kalkulacyjnych.";
        FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = "Oczekiwano argumentu w wywołaniu operatora różnicy w przód / w tył.";
        AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = "Oczekiwano przynajmniej jednego argumentu.";
        // -------------------------------------------------
        ERROR_WHILE_EXECUTING_THE_CALCULATE = "Błąd podczas wykonywania obliczeń.";
        RECURSION_CALLS_COUNTER_EXCEEDED = "Przekroczono maksymalną liczbę wywołań rekurencyjnych.";
        RECURSION_CALLS_COUNTER = "Licznik wywołań rekurencyjnych";
        STARTING_CALCULATION_LOOP = "Rozpoczęcie pętli obliczeniowej.";
        CANCEL_REQUEST_FINISHING = "Zastosowano żądanie anulowania - zakończenie.";
        INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = "Błąd wewnętrzny / dziwny poziom tokenu - zakończenie. Prawdopodobnie błąd parsera - proszę zgłosić to.";
        FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = "Błąd krytyczny, nie wiadomo, co zrobić z napotkanym tokenem. Prawdopodobnie błąd parsera - proszę zgłosić to.";
        MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = "Przekroczono maksymalną długość komunikatu o błędzie.";
        // -------------------------------------------------
        STARTING = "Rozpoczęcie...";
        PARSING = "Parsowanie";
        FULLY_COMPILED = "W pełni skompilowane";
        CALCULATED_VALUE = "Obliczona wartość";
        EXITING = "Zakończenie.";
        DONE = "zakończone.";
        // -------------------------------------------------
        KEYWORD = "Słowo kluczowe";
        SYNTAX = "Składnia";
        NUMBER = "Liczba";
        NUMBER_LITERAL = "Liczba literowa";
        TYPE = "Typ";
        SINCE = "Od";
        DESCRIPTION = "Opis";
        // -------------------------------------------------
        CALC_STEPS_REGISTER_IS_EMPTY = "Rejestr kroków obliczeń jest pusty.";
        CALC_STEPS_REGISTER_FOR = "Rejestr kroków obliczeń dla";
        ARGUMENT = "Argument";
        FUNCTION = "Funkcja";
        EXPRESSION = "Wyrażenie";
        RESULT = "wynik";
        COMPUTING_TIME = "Czas obliczeń";
        GROUP_SHORT = "gr";
        NUMBER_SHORT = "nr";
        FIRST = "pierwszy";
        LAST = "ostatni";
        DESCRIPTION_SHORT = "opis";
        STEP = "krok";
        // -------------------------------------------------
        SERIALIZATION_PERFORMED = "Wykonano serializację:";
        DESERIALIZATION_PERFORMED = "Wykonano deserializację:";
        NULL_OBJECT_PROVIDED = "Przekazano null jako obiekt.";
        NULL_FILE_PATH_PROVIDED = "Przekazano null jako ścieżkę pliku.";
        FILE_PATH_ZERO_LENGTH_PROVIDED = "Ścieżka pliku nie zawiera żadnych znaków.";
        FILE_PATH_IS_NOT_A_FILE = "Ścieżka pliku nie jest plikiem:";
        FILE_PATH_NOT_EXISTS = "Ścieżka pliku nie istnieje:";
        NULL_DATA_PROVIDED = "Przekazano null jako dane.";
        BINARY_SERIALIZATION_ENABLED = "Włączona jest serializacja binarna. Używaj jej świadomie i ograniczając się do niezbędnego.";
        BINARY_SERIALIZATION_DISABLED = "Serializacja binarna jest wyłączona. Możesz ją włączyć, jeśli jesteś świadomy ryzyka związanego z bezpieczeństwem.";
        // -------------------------------------------------
        USER_DEFINED_EXPRESSION = "Wyrażenie zdefiniowane przez użytkownika";
        USER_DEFINED_ARGUMENT = "Argument zdefiniowany przez użytkownika";
        USER_DEFINED_CONSTANT = "Stała zdefiniowana przez użytkownika";
        USER_DEFINED_FUNCTION = "Funkcja zdefiniowana przez użytkownika";
        USER_DEFINED_RECURSIVE_ARGUMENT = "Rekurencyjny argument zdefiniowany przez użytkownika";
        // -------------------------------------------------
        HELP_CONTENT_LIMITED_TO_QUERY = "Zawartość pomocy ograniczona do zapytania";
        ALL_HELP_CONTENT = "Cała zawartość pomocy.";
        CAPTION = "Nagłówek";
        // -------------------------------------------------
        WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "OSTRZEŻENIE BEZPIECZEŃSTWA:" + StringInvariant.NEW_LINE
                + "Deserializacja danych z niezaufanego źródła może wprowadzić luki bezpieczeństwa" + StringInvariant.NEW_LINE
                + "do twojej aplikacji. W zależności od ustawień używanych podczas deserializacji," + StringInvariant.NEW_LINE
                + "niezaufane dane mogą być w stanie wykonać dowolny kod lub spowodować atak typu denial" + StringInvariant.NEW_LINE
                + "of service. Niezaufane dane mogą pochodzić z sieci od niezaufanego źródła" + StringInvariant.NEW_LINE
                + "(np. dowolny klient sieciowy), lub mogą być manipulowane/podrabiane przez pośrednika" + StringInvariant.NEW_LINE
                + "podczas transmisji przez nieuwierzytelnione połączenie, lub z lokalnego magazynu," + StringInvariant.NEW_LINE
                + "gdzie mogły zostać skompromitowane/podrobione, lub z wielu innych źródeł." + StringInvariant.NEW_LINE
                + "MathParser.org-mXparser nie dostarcza żadnych środków do uwierzytelniania danych" + StringInvariant.NEW_LINE
                + "ani zabezpieczenia ich przed manipulacją. Użyj odpowiedniej metody uwierzytelniania" + StringInvariant.NEW_LINE
                + "danych przed deserializacją. Bądź bardzo świadomy tych scenariuszy ataku; wiele" + StringInvariant.NEW_LINE
                + "projektów i firm oraz użytkowników bibliotek serializacji ogólnie zostało już" + StringInvariant.NEW_LINE
                + "narażonych na niezaufaną deserializację danych użytkownika w przeszłości." + StringInvariant.NEW_LINE
        ;
        // -------------------------------------------------
        BINARY_RELATION = "Relacja binarna";
        BITWISE_OPERATOR = "Operator bitowy";
        BOOLEAN_OPERATOR = "Operator logiczny";
        CALCULUS_OPERATOR = "Operator rachunku";
        CONSTANT_VALUE = "Stała wartość";
        FUNCTION_1_ARG = "Funkcja jednoargumentowa";
        FUNCTION_2_ARG = "Funkcja dwuargumentowa";
        FUNCTION_3_ARG = "Funkcja trójargumentowa";
        FUNCTION_VARIADIC = "Funkcja o zmiennej liczbie argumentów";
        OPERATOR = "Operator";
        PARSER_SYMBOL = "Symbol parsera";
        RANDOM_VARIABLE = "Zmienna losowa";
        UNIT = "Jednostka";
        DIMENSIONLESS_UNIT = "Jednostka bezwymiarowa";
        ITERATED_OPERATOR = "Operator iterowany";
        // -------------------------------------------------
        RATIO_FRACTION = "Stosunek / Ułamek";
        METRIC_PREFIX = "Przedrostek metryczny";
        UNIT_OF_LENGTH = "Jednostka długości";
        UNIT_OF_AREA = "Jednostka powierzchni";
        UNIT_OF_VOLUME = "Jednostka objętości";
        UNIT_OF_TIME = "Jednostka czasu";
        UNIT_OF_MASS = "Jednostka masy";
        UNIT_OF_INFORMATION = "Jednostka informacji";
        UNIT_OF_ENERGY = "Jednostka energii";
        UNIT_OF_SPEED = "Jednostka prędkości";
        UNIT_OF_ACCELERATION = "Jednostka przyspieszenia";
        UNIT_OF_ANGLE = "Jednostka kąta";
        // -------------------------------------------------
        PHYSICAL_CONSTANT = "Stała fizyczna";
        ASTRONOMICAL_CONSTANT = "Stała astronomiczna";
        MATHEMATICAL_CONSTANT = "Stała matematyczna";
        // -------------------------------------------------
        PROBABILITY_DISTRIBUTION_FUNCTION = "Funkcja rozkładu prawdopodobieństwa";
        CUMULATIVE_DISTRIBUTION_FUNCTION = "Funkcja dystrybuanty";
        QUANTILE_FUNCTION = "Funkcja kwantylowa (odwrotna funkcja dystrybuanty)";
        // -------------------------------------------------
        STUDENTS_T_DISTRIBUTION = "Rozkład t-Studenta";
        CHI_SQUARED_DISTRIBUTION = "Rozkład chi-kwadrat";
        SNEDECORS_F_DISTRIBUTION = "Rozkład F Snedecora (rozkład F lub stosunek F, znany również jako rozkład Fishera-Snedecora)";
        UNIFORM_CONTINUOUS_DISTRIBUTION = "Rozkład jednostajny ciągły";
        UNIFORM_DISCRETE_DISTRIBUTION = "Rozkład jednostajny dyskretny";
        NORMAL_DISTRIBUTION = "Rozkład normalny";
        // -------------------------------------------------
        RANDOM_INTEGER = "Losowa liczba całkowita";
        RANDOM_NATURAL_NUMBER = "Losowa liczba naturalna";
        RANDOM_NATURAL_NUMBER_INCLUDING_0 = "Losowa liczba naturalna włącznie z 0";
        // -------------------------------------------------
        SPECIAL_FUNCTION = "Funkcja specjalna";
        // -------------------------------------------------
        SEMI_MAJOR_AXIS = "Półoś wielka";
        // -------------------------------------------------
        BINARY_RELATION_EQ = "Równość";
        BINARY_RELATION_NEQ = "Nierówność";
        BINARY_RELATION_LT = "Mniejsze niż";
        BINARY_RELATION_GT = "Większe niż";
        BINARY_RELATION_LEQ = "Mniejsze lub równe";
        BINARY_RELATION_GEQ = "Większe lub równe";
        // -------------------------------------------------
        BITWISE_OPERATOR_COMPL = "Bitowe dopełnienie jednoargumentowe (NOT)";
        BITWISE_OPERATOR_AND = "Bitowe i (AND)";
        BITWISE_OPERATOR_XOR = "Bitowe wykluczające lub (XOR)";
        BITWISE_OPERATOR_OR = "Bitowe lub (OR)";
        BITWISE_OPERATOR_LEFT_SHIFT = "Bitowe przesunięcie w lewo ze znakiem";
        BITWISE_OPERATOR_RIGHT_SHIFT = "Bitowe przesunięcie w prawo ze znakiem";
        BITWISE_OPERATOR_NAND = "Bitowe NOT AND (NAND)";
        BITWISE_OPERATOR_NOR = "Bitowe NOT OR (NOR)";
        BITWISE_OPERATOR_XNOR = "Bitowe wykluczające NOR (XNOR)";
        // -------------------------------------------------
        BOOLEAN_OPERATOR_AND = "Koniunkcja logiczna";
        BOOLEAN_OPERATOR_OR = "Alternatywa logiczna";
        BOOLEAN_OPERATOR_NEG = "Negacja";
        BOOLEAN_OPERATOR_NAND = "Strzałka Sheffera";
        BOOLEAN_OPERATOR_NOR = "Alternatywa zanegowana (negacja wspólna)";
        BOOLEAN_OPERATOR_XOR = "Alternatywa wykluczająca";
        BOOLEAN_OPERATOR_IMP = "Implikacja";
        BOOLEAN_OPERATOR_CIMP = "Implikacja odwrotna";
        BOOLEAN_OPERATOR_NIMP = "Nie-implikacja";
        BOOLEAN_OPERATOR_CNIMP = "Nie-implikacja odwrotna";
        BOOLEAN_OPERATOR_EQV = "Równoważność logiczna";
        // -------------------------------------------------
        CALCULUS_OPERATOR_SUM = "Sumowanie SIGMA";
        CALCULUS_OPERATOR_PROD = "Produkt PI";
        CALCULUS_OPERATOR_INT = "Całka oznaczona";
        CALCULUS_OPERATOR_DER = "Pochodna";
        CALCULUS_OPERATOR_DER_LEFT = "Pochodna lewostronna";
        CALCULUS_OPERATOR_DER_RIGHT = "Pochodna prawostronna";
        CALCULUS_OPERATOR_DERN = "n-ta pochodna";
        CALCULUS_OPERATOR_FORW_DIFF = "Różnica do przodu";
        CALCULUS_OPERATOR_BACKW_DIFF = "Różnica do tyłu";
        CALCULUS_OPERATOR_AVG = "Średnia";
        CALCULUS_OPERATOR_VAR = "Skorygowana wariancja próbkowa";
        CALCULUS_OPERATOR_STD = "Skorygowane odchylenie standardowe próbkowe";
        CALCULUS_OPERATOR_MIN = "Minimalna wartość";
        CALCULUS_OPERATOR_MAX = "Maksymalna wartość";
        CALCULUS_OPERATOR_SOLVE = "Rozwiązywanie równań (znajdowanie pierwiastków)";
        // -------------------------------------------------
        CONSTANT_VALUE_PI = "Pi, liczba Archimedesa lub Ludolfa";
        CONSTANT_VALUE_EULER = "Liczba Napierska lub Eulera (podstawa logarytmu naturalnego)";
        CONSTANT_VALUE_EULER_MASCHERONI = "Stała Eulera-Mascheroniego";
        CONSTANT_VALUE_GOLDEN_RATIO = "Złoty podział";
        CONSTANT_VALUE_PLASTIC = "Stała plastyczna";
        CONSTANT_VALUE_EMBREE_TREFETHEN = "Stała Embree-Trefethena";
        CONSTANT_VALUE_FEIGENBAUM_DELTA = "Stała delty Feigenbauma";
        CONSTANT_VALUE_FEIGENBAUM_ALPHA = "Stała alfa Feigenbauma";
        CONSTANT_VALUE_TWIN_PRIME = "Stała liczb bliźniaczych";
        CONSTANT_VALUE_MEISSEL_MERTEENS = "Stała Meissela-Mertensa";
        CONSTANT_VALUE_BRAUN_TWIN_PRIME = "Stała Bruna dla liczb bliźniaczych";
        CONSTANT_VALUE_BRAUN_PRIME_QUADR = "Stała Bruna dla czwórek liczb pierwszych";
        CONSTANT_VALUE_BRUIJN_NEWMAN = "Stała de Bruijn-Newmana";
        CONSTANT_VALUE_CATALAN = "Stała Catalana";
        CONSTANT_VALUE_LANDAU_RAMANUJAN = "Stała Landau-Ramanujan";
        CONSTANT_VALUE_VISWANATH = "Stała Viswanatha";
        CONSTANT_VALUE_LEGENDRE = "Stała Legendre'a";
        CONSTANT_VALUE_RAMANUJAN_SOLDNER = "Stała Ramanujan-Soldnera";
        CONSTANT_VALUE_ERDOS_BORWEIN = "Stała Erdosa-Borweina";
        CONSTANT_VALUE_BERNSTEIN = "Stała Bernsteina";
        CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = "Stała Gaussa-Kuzmina-Wirsinga";
        CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = "Stała Hafnera-Sarnaka-McCurleya";
        CONSTANT_VALUE_GOLOMB_DICKMAN = "Stała Golomba-Dickmana";
        CONSTANT_VALUE_CAHEN = "Stała Cahena";
        CONSTANT_VALUE_LAPLACE_LIMIT = "Stała graniczna Laplace'a";
        CONSTANT_VALUE_ALLADI_GRINSTEAD = "Stała Alladi-Grinsteada";
        CONSTANT_VALUE_LENGYEL = "Stała Lengyela";
        CONSTANT_VALUE_LEVY = "Stała Levy'ego";
        CONSTANT_VALUE_APERY = "Stała Apery'ego";
        CONSTANT_VALUE_MILLS = "Stała Millsa";
        CONSTANT_VALUE_BACKHOUSE = "Stała Backhouse'a";
        CONSTANT_VALUE_PORTER = "Stała Portera";
        CONSTANT_VALUE_LIEB_QUARE_ICE = "Stała kwadratowego lodu Lieba";
        CONSTANT_VALUE_NIVEN = "Stała Nivena";
        CONSTANT_VALUE_SIERPINSKI = "Stała Sierpińskiego";
        CONSTANT_VALUE_KHINCHIN = "Stała Khinchina";
        CONSTANT_VALUE_FRANSEN_ROBINSON = "Stała Fransen-Robinsona";
        CONSTANT_VALUE_LANDAU = "Stała Landaua";
        CONSTANT_VALUE_PARABOLIC = "Stała paraboliczna";
        CONSTANT_VALUE_OMEGA = "Stała Omega";
        CONSTANT_VALUE_MRB = "Stała MRB";
        CONSTANT_VALUE_LI2 = "Całka logarytmiczna w punkcie 2";
        CONSTANT_VALUE_GOMPERTZ = "Stała Gompertza";
        CONSTANT_VALUE_LIGHT_SPEED = "Prędkość światła w próżni";
        CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = "Stała grawitacyjna";
        CONSTANT_VALUE_GRAVIT_ACC_EARTH = "Przyspieszenie grawitacyjne na Ziemi";
        CONSTANT_VALUE_PLANCK_CONSTANT = "Stała Plancka";
        CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = "Zredukowana stała Plancka (stała Diraca)";
        CONSTANT_VALUE_PLANCK_LENGTH = "Długość Plancka";
        CONSTANT_VALUE_PLANCK_MASS = "Masa Plancka";
        CONSTANT_VALUE_PLANCK_TIME = "Czas Plancka";
        CONSTANT_VALUE_LIGHT_YEAR = "Rok świetlny";
        CONSTANT_VALUE_ASTRONOMICAL_UNIT = "Jednostka astronomiczna";
        CONSTANT_VALUE_PARSEC = "Parsek";
        CONSTANT_VALUE_KILOPARSEC = "Kiloparsek";
        CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = "Równikowy promień Ziemi";
        CONSTANT_VALUE_EARTH_RADIUS_POLAR = "Biegunowy promień Ziemi";
        CONSTANT_VALUE_EARTH_RADIUS_MEAN = "Średni promień Ziemi";
        CONSTANT_VALUE_EARTH_MASS = "Masa Ziemi";
        CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = "Odległość Ziemi od Słońca";
        CONSTANT_VALUE_MOON_RADIUS_MEAN = "Średni promień Księżyca";
        CONSTANT_VALUE_MOON_MASS = "Masa Księżyca";
        CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = "Odległość Księżyca od Ziemi";
        CONSTANT_VALUE_SOLAR_RADIUS = "Średni promień Słońca";
        CONSTANT_VALUE_SOLAR_MASS = "Masa Słońca";
        CONSTANT_VALUE_MERCURY_RADIUS_MEAN = "Średni promień Merkurego";
        CONSTANT_VALUE_MERCURY_MASS = "Masa Merkurego";
        CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = "Odległość Merkurego od Słońca";
        CONSTANT_VALUE_VENUS_RADIUS_MEAN = "Średni promień Wenus";
        CONSTANT_VALUE_VENUS_MASS = "Masa Wenus";
        CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = "Odległość Wenus od Słońca";
        CONSTANT_VALUE_MARS_RADIUS_MEAN = "Średni promień Marsa";
        CONSTANT_VALUE_MARS_MASS = "Masa Marsa";
        CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = "Odległość Marsa od Słońca";
        CONSTANT_VALUE_JUPITER_RADIUS_MEAN = "Średni promień Jowisza";
        CONSTANT_VALUE_JUPITER_MASS = "Masa Jowisza";
        CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = "Odległość Jowisza od Słońca";
        CONSTANT_VALUE_SATURN_RADIUS_MEAN = "Średni promień Saturna";
        CONSTANT_VALUE_SATURN_MASS = "Masa Saturna";
        CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = "Odległość Saturna od Słońca";
        CONSTANT_VALUE_URANUS_RADIUS_MEAN = "Średni promień Uranu";
        CONSTANT_VALUE_URANUS_MASS = "Masa Uranu";
        CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = "Odległość Uranu od Słońca";
        CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = "Średni promień Neptuna";
        CONSTANT_VALUE_NEPTUNE_MASS = "Masa Neptuna";
        CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = "Odległość Neptuna od Słońca";
        CONSTANT_VALUE_TRUE = "Wartość logiczna Prawda reprezentowana jako 1";
        CONSTANT_VALUE_FALSE = "Wartość logiczna Fałsz reprezentowana jako 0";
        CONSTANT_VALUE_NPAR = "Automatycznie generowana stała dla funkcji zdefiniowanych przez użytkownika, zwraca liczbę parametrów danej funkcji";
        CONSTANT_VALUE_NAN = "Nie-jest-Liczbą";
        // -------------------------------------------------
        FUNCTION_1_ARG_SIN = "Trygonometryczny sinus";
        FUNCTION_1_ARG_COS = "Trygonometryczny cosinus";
        FUNCTION_1_ARG_TAN = "Trygonometryczny tangens";
        FUNCTION_1_ARG_CTAN = "Trygonometryczny cotangens";
        FUNCTION_1_ARG_SEC = "Trygonometryczny secans";
        FUNCTION_1_ARG_COSEC = "Trygonometryczny cosecans";
        FUNCTION_1_ARG_ASIN = "Odwrotny trygonometryczny sinus";
        FUNCTION_1_ARG_ACOS = "Odwrotny trygonometryczny cosinus";
        FUNCTION_1_ARG_ATAN = "Odwrotny trygonometryczny tangens";
        FUNCTION_1_ARG_ACTAN = "Odwrotny trygonometryczny cotangens";
        FUNCTION_1_ARG_LN = "Logarytm naturalny (o podstawie e)";
        FUNCTION_1_ARG_LOG2 = "Logarytm binarny (o podstawie 2)";
        FUNCTION_1_ARG_LOG10 = "Logarytm dziesiętny (o podstawie 10)";
        FUNCTION_1_ARG_RAD = "Stopnie na radiany";
        FUNCTION_1_ARG_EXP = "Wykładnicza";
        FUNCTION_1_ARG_SQRT = "Pierwiastek kwadratowy";
        FUNCTION_1_ARG_SINH = "Hiperboliczny sinus";
        FUNCTION_1_ARG_COSH = "Hiperboliczny cosinus";
        FUNCTION_1_ARG_TANH = "Hiperboliczny tangens";
        FUNCTION_1_ARG_COTH = "Hiperboliczny cotangens";
        FUNCTION_1_ARG_SECH = "Hiperboliczny secans";
        FUNCTION_1_ARG_CSCH = "Hiperboliczny cosecans";
        FUNCTION_1_ARG_DEG = "Radiany na stopnie";
        FUNCTION_1_ARG_ABS = "Wartość absolutna";
        FUNCTION_1_ARG_SGN = "Signum";
        FUNCTION_1_ARG_FLOOR = "Podłoga";
        FUNCTION_1_ARG_CEIL = "Sufit";
        FUNCTION_1_ARG_NOT = "Negacja";
        FUNCTION_1_ARG_ARSINH = "Odwrotny hiperboliczny sinus";
        FUNCTION_1_ARG_ARCOSH = "Odwrotny hiperboliczny cosinus";
        FUNCTION_1_ARG_ARTANH = "Odwrotny hiperboliczny tangens";
        FUNCTION_1_ARG_ARCOTH = "Odwrotny hiperboliczny cotangens";
        FUNCTION_1_ARG_ARSECH = "Odwrotny hiperboliczny secans";
        FUNCTION_1_ARG_ARCSCH = "Odwrotny hiperboliczny cosecans";
        FUNCTION_1_ARG_SA = "Sinc (znormalizowany)";
        FUNCTION_1_ARG_SINC = "Sinc (nieznormalizowany)";
        FUNCTION_1_ARG_BELL_NUMBER = "Liczba Bella";
        FUNCTION_1_ARG_LUCAS_NUMBER = "Liczba Lucasa";
        FUNCTION_1_ARG_FIBONACCI_NUMBER = "Liczba Fibonacciego";
        FUNCTION_1_ARG_HARMONIC_NUMBER = "Liczba harmoniczna";
        FUNCTION_1_ARG_IS_PRIME = "Test liczby pierwszej (czy liczba jest pierwsza?)";
        FUNCTION_1_ARG_PRIME_COUNT = "Liczenie liczb pierwszych";
        FUNCTION_1_ARG_EXP_INT = "Całka wykładnicza";
        FUNCTION_1_ARG_LOG_INT = "Całka logarytmiczna";
        FUNCTION_1_ARG_OFF_LOG_INT = "Całka logarytmiczna z przesunięciem";
        FUNCTION_1_ARG_GAUSS_ERF = "Błąd Gaussa";
        FUNCTION_1_ARG_GAUSS_ERFC = "Uzupełniający błąd Gaussa";
        FUNCTION_1_ARG_GAUSS_ERF_INV = "Odwrotny błąd Gaussa";
        FUNCTION_1_ARG_GAUSS_ERFC_INV = "Odwrotny uzupełniający błąd Gaussa";
        FUNCTION_1_ARG_ULP = "Jednostka na ostatnim miejscu";
        FUNCTION_1_ARG_ISNAN = "Zwraca prawda jeśli wartość jest Nie-jest-Liczba (NaN), fałsz w przeciwnym przypadku";
        FUNCTION_1_ARG_NDIG10 = "Liczba cyfr w systemie liczbowym o podstawie 10";
        FUNCTION_1_ARG_NFACT = "Rozkład na czynniki pierwsze - liczba różnych czynników pierwszych";
        FUNCTION_1_ARG_ARCSEC = "Odwrotny trygonometryczny secans";
        FUNCTION_1_ARG_ARCCSC = "Odwrotny trygonometryczny cosecans";
        FUNCTION_1_ARG_GAMMA = "Gamma";
        FUNCTION_1_ARG_LAMBERT_W0 = "Lambert-W, główne rozgałęzienie 0, nazywane też omega lub logarytmem iloczynu";
        FUNCTION_1_ARG_LAMBERT_W1 = "Lambert-W, rozgałęzienie -1, nazywane też omega lub logarytmem iloczynu";
        FUNCTION_1_ARG_SGN_GAMMA = "Signum Gamma";
        FUNCTION_1_ARG_LOG_GAMMA = "Log Gamma";
        FUNCTION_1_ARG_DI_GAMMA = "Digamma jako logarytmiczna pochodna Gamma";
        FUNCTION_1_ARG_PARAM = "Automatycznie generowana funkcja dla funkcji zdefiniowanych przez użytkownika, zwraca wartość parametru funkcji na indeksie 'i'";
        // -------------------------------------------------
        FUNCTION_2_ARG_LOG = "Logarytm";
        FUNCTION_2_ARG_MOD = "Modulo";
        FUNCTION_2_ARG_BINOM_COEFF = "Współczynnik dwumianowy, liczba k-kombinacji, które można wybrać z n-elementowego zbioru";
        FUNCTION_2_ARG_BERNOULLI_NUMBER = "Liczby Bernoulliego";
        FUNCTION_2_ARG_STIRLING1_NUMBER = "Liczby Stirlinga pierwszego rodzaju";
        FUNCTION_2_ARG_STIRLING2_NUMBER = "Liczby Stirlinga drugiego rodzaju";
        FUNCTION_2_ARG_WORPITZKY_NUMBER = "Liczba Worpitzkiego";
        FUNCTION_2_ARG_EULER_NUMBER = "Liczba Eulera";
        FUNCTION_2_ARG_KRONECKER_DELTA = "Delta Kroneckera";
        FUNCTION_2_ARG_EULER_POLYNOMIAL = "Wielomian Eulera";
        FUNCTION_2_ARG_HARMONIC_NUMBER = "Liczba harmoniczna";
        FUNCTION_2_ARG_ROUND = "Zaokrąglenie w górę";
        FUNCTION_2_ARG_NDIG = "Liczba cyfr reprezentujących liczbę w systemie liczbowym o danej podstawie";
        FUNCTION_2_ARG_DIGIT10 = "Cyfra na pozycji 1 ... n (lewo -> prawo) lub 0 ... -(n-1) (prawo -> lewo) - system liczbowy o podstawie 10";
        FUNCTION_2_ARG_FACTVAL = "Rozkład na czynniki pierwsze - wartość czynnika na pozycji od 1 ... nfact(n) - rosnąco według wartości czynnika";
        FUNCTION_2_ARG_FACTEXP = "Rozkład na czynniki pierwsze - wykładnik czynnika / wielokrotność na pozycji między 1 ... nfact(n) - rosnąco według wartości czynnika";
        FUNCTION_2_ARG_ROOT = "Pierwiastek n-tego stopnia liczby";
        FUNCTION_2_ARG_INC_GAMMA_LOWER = "Dolna niekompletna gamma";
        FUNCTION_2_ARG_INC_GAMMA_UPPER = "Górna niekompletna Gamma";
        FUNCTION_2_ARG_REG_GAMMA_LOWER = "Dolna znormalizowana P gamma";
        FUNCTION_2_ARG_REG_GAMMA_UPPER = "Górna znormalizowana Q Gamma";
        FUNCTION_2_ARG_PERMUTATIONS = "Liczba k-permutacji, które można wybrać z n-elementowego zbioru";
        FUNCTION_2_ARG_BETA = "Beta, nazywana też całką Eulera pierwszego rodzaju";
        FUNCTION_2_ARG_LOG_BETA = "Log Beta, nazywana też logarytmem całkowym Eulera pierwszego rodzaju";
        // -------------------------------------------------
        FUNCTION_3_ARG_IF = "Jeżeli";
        FUNCTION_3_ARG_CHI = "Funkcja charakterystyczna dla x w (a,b)";
        FUNCTION_3_ARG_CHI_LR = "Funkcja charakterystyczna dla x w [a,b]";
        FUNCTION_3_ARG_CHI_L = "Funkcja charakterystyczna dla x w [a,b)";
        FUNCTION_3_ARG_CHI_R = "Funkcja charakterystyczna dla x w (a,b]";
        FUNCTION_3_ARG_DIGIT = "Cyfra na pozycji 1 ... n (lewo -> prawo) lub 0 ... -(n-1) (prawo -> lewo) - system liczbowy o podanej podstawie";
        FUNCTION_3_ARG_INC_BETA = "Niekompletna Beta, nazywana też niekompletną całką Eulera pierwszego rodzaju";
        FUNCTION_3_ARG_REG_BETA = "Znormalizowana niekompletna Beta (lub znormalizowana beta), nazywana też znormalizowaną niekompletną całką Eulera pierwszego rodzaju";
        // -------------------------------------------------
        FUNCTION_VARIADIC_IFF = "Funkcja warunkowa";
        FUNCTION_VARIADIC_MIN = "Minimum";
        FUNCTION_VARIADIC_MAX = "Maksimum";
        FUNCTION_VARIADIC_CONT_FRAC = "Ciągła ułamkowa";
        FUNCTION_VARIADIC_CONT_POL = "Ciągły wielomian";
        FUNCTION_VARIADIC_GCD = "Największy wspólny dzielnik";
        FUNCTION_VARIADIC_LCM = "Najmniejsza wspólna wielokrotność";
        FUNCTION_VARIADIC_SUM = "Suma";
        FUNCTION_VARIADIC_PROD = "Mnożenie";
        FUNCTION_VARIADIC_AVG = "Średnia / wartość średnia";
        FUNCTION_VARIADIC_VAR = "Poprawione próbkowanie wariancji";
        FUNCTION_VARIADIC_STD = "Poprawione próbkowanie odchylenia standardowego";
        FUNCTION_VARIADIC_RND_LIST = "Losowa liczba z podanej listy liczb";
        FUNCTION_VARIADIC_COALESCE = "Zwraca pierwszą wartość nie-NaN";
        FUNCTION_VARIADIC_OR = "Alternatywa logiczna (OR) - wariant";
        FUNCTION_VARIADIC_AND = "Koniunkcja logiczna (AND) - wariant";
        FUNCTION_VARIADIC_XOR = "Alternatywa wykluczająca (XOR) - wariant";
        FUNCTION_VARIADIC_ARGMIN = "Argumenty / indeksy minimów";
        FUNCTION_VARIADIC_ARGMAX = "Argumenty / indeksy maksimów";
        FUNCTION_VARIADIC_MEDIAN = "Mediana próbki";
        FUNCTION_VARIADIC_MODE = "Moda - wartość, która występuje najczęściej";
        FUNCTION_VARIADIC_BASE = "Zwraca liczbę w podanym systemie liczbowym reprezentowaną przez listę cyfr";
        FUNCTION_VARIADIC_NDIST = "Liczba różnych wartości";
        // -------------------------------------------------
        OPERATOR_PLUS = "Dodawanie";
        OPERATOR_MINUS = "Odejmowanie";
        OPERATOR_MULTIPLY = "Mnożenie";
        OPERATOR_DIVIDE = "Dzielenie";
        OPERATOR_DIVIDE_QUOTIENT = "Dzielenie całkowitoliczbowe (iloraz)";
        OPERATOR_POWER = "Potęgowanie";
        OPERATOR_FACT = "Silnia";
        OPERATOR_MOD = "Modulo";
        OPERATOR_PERC = "Procenty";
        OPERATOR_TETRATION = "Tetracja (hiper-4, wieża potęg, wieża wykładnicza)";
        OPERATOR_SQUARE_ROOT = "Pierwiastek kwadratowy";
        OPERATOR_CUBE_ROOT = "Pierwiastek sześcienny";
        OPERATOR_FOURTH_ROOT = "Pierwiastek czwarty";
        // -------------------------------------------------
        PARSER_SYMBOL_LEFT_PARENTHESES = "Lewy nawias";
        PARSER_SYMBOL_RIGHT_PARENTHESES = "Prawy nawias";
        PARSER_SYMBOL_COMMA = "Przecinek (parametry funkcji)";
        PARSER_SYMBOL_SEMI = "Średnik (parametry funkcji)";
        PARSER_SYMBOL_BLANK = "Znak pusty (biały znak)";
        PARSER_SYMBOL_NUMBER_INTEGER = "Liczba całkowita";
        PARSER_SYMBOL_NUMBER_DECIMAL = "Liczba dziesiętna";
        PARSER_SYMBOL_NUMBER_LEADING_ZERO = "Zerowy znak początkowy";
        PARSER_SYMBOL_NUMBER_SCI_NOTATION = "Notacja naukowa";
        PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = "Brak zerowego znaku początkowego";
        PARSER_SYMBOL_NUMBER_FRACTIONS = "Ułamki";
        PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = "Inne systemy liczbowe";
        PARSER_SYMBOL_UNICODE_MATH = " - Symbol matematyczny Unicode";
        // -------------------------------------------------
        DIMENSIONLESS_UNIT_PERC = "Procenty";
        DIMENSIONLESS_UNIT_PERM = "Promil";
        DIMENSIONLESS_UNIT_YOTTA = "Septilion / Jotta";
        DIMENSIONLESS_UNIT_ZETTA = "Sekstylion / Zetta";
        DIMENSIONLESS_UNIT_EXA = "Kwintylion / Eksa";
        DIMENSIONLESS_UNIT_PETA = "Kwadrylion / Peta";
        DIMENSIONLESS_UNIT_TERA = "Trylion / Tera";
        DIMENSIONLESS_UNIT_GIGA = "Miliard / Giga";
        DIMENSIONLESS_UNIT_MEGA = "Milion / Mega";
        DIMENSIONLESS_UNIT_KILO = "Tysiąc / Kilo";
        DIMENSIONLESS_UNIT_HECTO = "Sto / Hekto";
        DIMENSIONLESS_UNIT_DECA = "Dziesięć / Deca";
        DIMENSIONLESS_UNIT_DECI = "Dziesiąta / Deci";
        DIMENSIONLESS_UNIT_CENTI = "Setna / Centi";
        DIMENSIONLESS_UNIT_MILLI = "Tysięczna / Milli";
        DIMENSIONLESS_UNIT_MICRO = "Milionowa / Mikro";
        DIMENSIONLESS_UNIT_NANO = "Miliardowa / Nano";
        DIMENSIONLESS_UNIT_PICO = "Trylionowa / Piko";
        DIMENSIONLESS_UNIT_FEMTO = "Kwadrylionowa / Femto";
        DIMENSIONLESS_UNIT_ATTO = "Kwintylionowa / Atto";
        DIMENSIONLESS_UNIT_ZEPTO = "Sekstylionowa / Zepto";
        DIMENSIONLESS_UNIT_YOCTO = "Septylionowa / Yokto";
        // -------------------------------------------------
        UNIT_METRE = "Metr";
        UNIT_KILOMETRE = "Kilometr";
        UNIT_CENTIMETRE = "Centymetr";
        UNIT_MILLIMETRE = "Milimetr";
        UNIT_INCH = "Cal";
        UNIT_YARD = "Jard";
        UNIT_FEET = "Stopa";
        UNIT_MILE = "Mila";
        UNIT_NAUTICAL_MILE = "Mila morska";
        UNIT_METRE2 = "Metr kwadratowy";
        UNIT_CENTIMETRE2 = "Centymetr kwadratowy";
        UNIT_MILLIMETRE2 = "Milimetr kwadratowy";
        UNIT_ARE = "Ar";
        UNIT_HECTARE = "Hektar";
        UNIT_ACRE = "Akr";
        UNIT_KILOMETRE2 = "Kilometr kwadratowy";
        UNIT_MILLIMETRE3 = "Milimetr sześcienny";
        UNIT_CENTIMETRE3 = "Centymetr sześcienny";
        UNIT_METRE3 = "Metr sześcienny";
        UNIT_KILOMETRE3 = "Kilometr sześcienny";
        UNIT_MILLILITRE = "Mililitr";
        UNIT_LITRE = "Litr";
        UNIT_GALLON = "Galon";
        UNIT_PINT = "Pinta";
        UNIT_SECOND = "Sekunda";
        UNIT_MILLISECOND = "Milisekunda";
        UNIT_MINUTE = "Minuta";
        UNIT_HOUR = "Godzina";
        UNIT_DAY = "Dzień";
        UNIT_WEEK = "Tydzień";
        UNIT_JULIAN_YEAR = "Rok juliański = 365,25 dnia";
        UNIT_KILOGRAM = "Kilogram";
        UNIT_GRAM = "Gram";
        UNIT_MILLIGRAM = "Miligram";
        UNIT_DECAGRAM = "Dekagram";
        UNIT_TONNE = "Tona";
        UNIT_OUNCE = "Uncja";
        UNIT_POUND = "Funt";
        UNIT_BIT = "Bit";
        UNIT_KILOBIT = "Kilobit";
        UNIT_MEGABIT = "Megabit";
        UNIT_GIGABIT = "Gigabit";
        UNIT_TERABIT = "Terabit";
        UNIT_PETABIT = "Petabit";
        UNIT_EXABIT = "Exabit";
        UNIT_ZETTABIT = "Zettabit";
        UNIT_YOTTABIT = "Yottabit";
        UNIT_BYTE = "Bajt";
        UNIT_KILOBYTE = "Kilobajt";
        UNIT_MEGABYTE = "Megabajt";
        UNIT_GIGABYTE = "Gigabajt";
        UNIT_TERABYTE = "Terabajt";
        UNIT_PETABYTE = "Petabajt";
        UNIT_EXABYTE = "Exabajt";
        UNIT_ZETTABYTE = "Zettabajt";
        UNIT_YOTTABYTE = "Yottabajt";
        UNIT_JOULE = "Dżul";
        UNIT_ELECTRONO_VOLT = "Elektronowolt";
        UNIT_KILO_ELECTRONO_VOLT = "Kiloelektronowolt";
        UNIT_MEGA_ELECTRONO_VOLT = "Megaelektronowolt";
        UNIT_GIGA_ELECTRONO_VOLT = "Gigaelektronowolt";
        UNIT_TERA_ELECTRONO_VOLT = "Teraelektronowolt";
        UNIT_METRE_PER_SECOND = "Metr na sekundę";
        UNIT_KILOMETRE_PER_HOUR = "Kilometr na godzinę";
        UNIT_MILE_PER_HOUR = "Mila na godzinę";
        UNIT_KNOT = "Węzeł";
        UNIT_METRE_PER_SECOND2 = "Metr na sekundę kwadratową";
        UNIT_KILOMETRE_PER_HOUR2 = "Kilometr na godzinę kwadratową";
        UNIT_MILE_PER_HOUR2 = "Mila na godzinę kwadratową";
        UNIT_RADIAN_ARC = "Radian";
        UNIT_DEGREE_ARC = "Stopień kątowy";
        UNIT_MINUTE_ARC = "Minuta kątowa";
        UNIT_SECOND_ARC = "Sekunda kątowa";
    }
}