/*
 * @(#)StringResourcesSpanish.java        6.0.0    2024-05-19
 *
 * MathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19
 * The most up-to-date license is available at the below link:
 * - https://mathparser.org/mxparser-license
 *
 * AUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved
 * PUBLISHER: INFIMA - https://payhip.com/infima
 *
 * SOFTWARE means source code and/or binary form and/or documentation.
 * PRODUCT: MathParser.org-mXparser SOFTWARE
 * LICENSE: DUAL LICENSE AGREEMENT
 *
 * BY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE
 * BOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.
 *
 * The AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT
 * model designed to meet the needs of both non-commercial use and commercial
 * use.
 *
 * NON-COMMERCIAL USE means any use or activity where a fee is not charged
 * and the purpose is not the sale of a good or service, and the use or
 * activity is not intended to produce a profit. Examples of NON-COMMERCIAL USE
 * include:
 *
 * 1. Non-commercial open-source software.
 * 2. Non-commercial mobile applications.
 * 3. Non-commercial desktop software.
 * 4. Non-commercial web applications/solutions.
 * 5. Non-commercial use in research, scholarly and educational context.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * COMMERCIAL USE means any use or activity where a fee is charged or the
 * purpose is the sale of a good or service, or the use or activity is
 * intended to produce a profit. COMMERCIAL USE examples:
 *
 * 1. OEMs (Original Equipment Manufacturers).
 * 2. ISVs (Independent Software Vendors).
 * 3. VARs (Value Added Resellers).
 * 4. Other distributors that combine and distribute commercially licensed
 *    software.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * IN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE
 * APPROPRIATE LICENSE FROM "INFIMA" ONLINE STORE, STORE ADDRESS:
 *
 * 1. https://mathparser.org/order-commercial-license
 * 2. https://payhip.com/infima
 *
 * NON-COMMERCIAL LICENSE
 *
 * Redistribution and use of the PRODUCT in source and/or binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the unmodified content of
 *    the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including
 *    the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,
 *    the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 2. Redistributions in binary form must reproduce the entire content of
 *    MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation
 *    and/or other materials provided with the distribution, including the
 *    definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the
 *    NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 3. Any form of redistribution requires confirmation and signature of
 *    the NON-COMMERCIAL USE by successfully calling the method:
 *       License.iConfirmNonCommercialUse(...)
 *    The method call is used only internally for logging purposes, and
 *    there is no connection with other external services, and no data is
 *    sent or collected. The lack of a method call (or its successful call)
 *    does not affect the operation of the PRODUCT in any way. Please see
 *    the API documentation.
 *
 * COMMERCIAL LICENSE
 *
 *  1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow
 *     you to download, install, and use up to three copies of the PRODUCT to
 *     perform integration tests, confirm the quality of the PRODUCT, and
 *     its suitability. The testing period should be limited to fourteen
 *     days. Tests should be performed under the test environments conditions
 *     and not for profit generation.
 *  2. Provided that you purchased a license from "INFIMA" online store
 *     (store address: https://mathparser.org/order-commercial-license or
 *     https://payhip.com/infima), and you comply with all terms and
 *     conditions below, and you have acknowledged and understood the
 *     following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive
 *     license with the following rights:
 *  3. The license is granted only to you, the person or entity that made
 *     the purchase, identified and confirmed by the data provided during
 *     the purchase.
 *  4. If you purchased a license in the "ONE-TIME PURCHASE" model, the
 *     license is granted only for the PRODUCT version specified in the
 *     purchase. The upgrade policy gives you additional rights, described
 *     in the dedicated section below.
 *  5. If you purchased a license in the "SUBSCRIPTION" model, you may
 *     install and use any version of the PRODUCT during the subscription
 *     validity period.
 *  6. If you purchased a "SINGLE LICENSE" you may install and use the
 *     PRODUCT on/from one workstation that is located/accessible at/from
 *     any of your premises.
 *  7. Additional copies of the PRODUCT may be installed and used on/from
 *     more than one workstation, limited to the number of workstations
 *     purchased per order.
 *  8. If you purchased a "SITE LICENSE", the PRODUCT may be installed
 *     and used on/from all workstations located/accessible at/from any
 *     of your premises.
 *  9. You may incorporate the unmodified PRODUCT into your own products
 *     and software.
 * 10. If you purchased a license with the "SOURCE CODE" option, you may
 *     modify the PRODUCT's source code and incorporate the modified source
 *     code into your own products and/or software.
 * 11. Provided that the license validity period has not expired, you may
 *     distribute your product and/or software with the incorporated
 *     PRODUCT royalty-free.
 * 12. You may make copies of the PRODUCT for backup and archival purposes.
 * 13. Any form of redistribution requires confirmation and signature of
 *     the COMMERCIAL USE by successfully calling the method:
 *        License.iConfirmCommercialUse(...)
 *     The method call is used only internally for logging purposes, and
 *     there is no connection with other external services, and no data is
 *     sent or collected. The lack of a method call (or its successful call)
 *     does not affect the operation of the PRODUCT in any way. Please see
 *     the API documentation.
 * 14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to
 *     you in this agreement.
 *
 * ADDITIONAL CLARIFICATION ON WORKSTATION
 *
 * A workstation is a device, a remote device, or a virtual device, used by
 * you, your employees, or other entities to whom you have commissioned
 * tasks. For example, the number of workstations may refer to the number
 * of software developers, engineers, architects, scientists, and other
 * professionals who use the PRODUCT on your behalf. The number of
 * workstations is not the number of copies of your end-product that you
 * distribute to your end-users.
 *
 * By purchasing the COMMERCIAL LICENSE, you only pay for the number of
 * workstations, while the number of copies/users of your final product
 * (delivered to your end-users) is not limited.
 *
 * Below are some examples to help you select the right license size:
 *
 * Example 1: Single Workstation License
 * Only one developer works on the development of your application. You do
 * not use separate environments for testing, meaning you design, create,
 * test, and compile your final application on one environment. In this
 * case, you need a license for a single workstation.
 *
 * Example 2: Up to 5 Workstations License
 * Two developers are working on the development of your application.
 * Additionally, one tester conducts tests in a separate environment.
 * You use three workstations in total, so you need a license for up to
 * five workstations.
 *
 * Example 3: Up to 20 Workstations License
 * Ten developers are working on the development of your application.
 * Additionally, five testers conduct tests in separate environments.
 * You use fifteen workstations in total, so you need a license for
 * up to twenty workstations.
 *
 * Example 4: Site License
 * Several dozen developers and testers work on the development of your
 * application using multiple environments. You have a large,
 * multi-disciplinary team involved in creating your solution. As your team
 * is growing and you want to avoid licensing limitations, the best choice
 * would be a site license.
 *
 * UPGRADE POLICY
 *
 * The PRODUCT is versioned according to the following convention:
 *
 *    [MAJOR].[MINOR].[PATCH]
 *
 * 1. COMMERCIAL LICENSE holders can install and use the updated version
 *    for bug fixes free of charge, i.e. if you have purchased a license
 *    for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install
 *    all releases specified in the [PATCH] version (e.g., 5.0.2).
 *    The license terms remain unchanged after the update.
 * 2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)
 *    can install and use the updated version [MAJOR].[MINOR + 1] free of
 *    charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The
 *    license terms remain unchanged after the update.
 * 3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are
 *    not eligible for the free upgrade, can claim a discount when
 *    purchasing the upgrade. For this purpose, please contact us via e-mail.
 *
 * DISCLAIMER
 *
 * THIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE
 * THOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING
 * OFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.
 *
 * CONTACT
 *
 * - e-mail: info@mathparser.org
 * - website: https://mathparser.org
 * - source code: https://github.com/mariuszgromada/MathParser.org-mXparser
 * - online store: https://mathparser.org/order-commercial-license
 * - online store: https://payhip.com/infima
 */
package org.mariuszgromada.math.mxparser;

/**
 * A class containing definition of Spanish user language
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="https://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="https://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser on GitHub</a><br>
 *                 <a href="https://payhip.com/INFIMA" target="_blank">INFIMA place to purchase a commercial MathParser.org-mXparser software license</a><br>
 *                 <a href="mailto:info@mathparser.org">info@mathparser.org</a><br>
 *                 <a href="https://scalarmath.org/" target="_blank">ScalarMath.org - a powerful math engine and math scripting language</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.lite" target="_blank">Scalar Lite</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.pro" target="_blank">Scalar Pro</a><br>
 *                 <a href="https://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *
 * @version        6.0.0
 *
 * @see StringResources
 * @see StringModel
 * @see StringModel#setStringResources(StringResources)
 * @see StringModel#getStringResources()
 */
class StringResourcesSpanish extends StringResources {
    StringResourcesSpanish() {
        USER_LANGUAGE = "Español";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK = "Iniciando verificación de sintaxis...";
        NO_ERRORS_DETECTED = "No se encontraron errores.";
        NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = "No se encontraron errores en la definición del argumento.";
        NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = "No se encontraron errores en la definición recursiva del argumento.";
        NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = "No se encontraron errores en la definición de la función.";
        NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = "No se encontraron errores en la definición de la constante.";
        LEXICAL_ERROR_HAS_BEEN_FOUND = "Se encontró un error léxico.";
        ERRORS_HAVE_BEEN_FOUND = "Se encontraron errores.";
        ALREADY_CHECKED_NO_ERRORS = "La sintaxis ya ha sido verificada: no se encontraron errores.";
        SYNTAX_STATUS_UNKNOWN = "El estado de la sintaxis es desconocido.";
        PROBLEM_WITH_EXPRESSION_SYNTAX = "Hay un problema con la sintaxis de la expresión.";
        // -------------------------------------------------
        ENCOUNTERED = "Encontrado";
        AT_INDEX = "en el índice";
        WAS_EXPECTING = "Se esperaba";
        WAS_EXPECTING_ONE_OF = "Se esperaba uno de";
        UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = "Se encontró una excepción inesperada. Probablemente un error de análisis: por favor, repórtelo.";
        UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = "Se encontró un error inesperado en el administrador de tokens. Probablemente un error de análisis: por favor, repórtelo.";
        // -------------------------------------------------
        EXPRESSION_STRING_IS_EMPTY = "La cadena de la expresión está vacía.";
        EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = "La expresión no contiene ningún token.";
        DUPLICATED_KEYWORD = "Se encontraron palabras clave duplicadas. Verifique los elementos definidos por el usuario. Considere usar la opción para reemplazar los tokens incorporados.";
        ELEMENT = "Elemento";
        ERROR = "Error";
        EXCEPTION = "Excepción";
        TOKEN = "Token";
        INDEX = "índice";
        INVALID_TOKEN = "Token no válido.";
        INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = "Token no válido. Es posible que falte el operador de multiplicación: intente el modo de multiplicación implícita.";
        EXPRESSION_TOKENS = "Tokens de la expresión";
        NULL_TOKENS_LIST = "Lista de tokens nula";
        // -------------------------------------------------
        FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = "Función definida por el usuario con cuerpo extendido: no se encontraron errores por suposición.";
        ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = "Argumento definido por el usuario con cuerpo extendido: no se encontraron errores por suposición.";
        PROVIDED_EXTENSION_IS_NULL = "La extensión proporcionada es nula.";
        PROVIDED_STRING_IS_NULL = "La cadena proporcionada es nula.";
        PROVIDED_ELEMENTS_ARE_NULL = "Los elementos proporcionados son nulos.";
        MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = "Falta el operador de multiplicación: intente el modo de multiplicación implícita.";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = "Iniciando verificación de sintaxis del argumento dependiente definido por el usuario.";
        STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = "Iniciando verificación de sintaxis del argumento recursivo definido por el usuario.";
        STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = "Iniciando verificación de sintaxis de la función definida por el usuario.";
        STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = "Iniciando verificación de sintaxis de la función variádica definida por el usuario.";
        // -------------------------------------------------
        ARGUMENT_WAS_EXPECTED = "Se esperaba un argumento definido por el usuario.";
        RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = "Un argumento recursivo definido por el usuario requiere un parámetro.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = "Número incorrecto de parámetros en la función definida por el usuario.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = "Número incorrecto de parámetros de función.";
        EXPECTED = "Se esperaba";
        PROVIDED = "Proporcionado";
        USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = "Número incorrecto de parámetros en la función definida por el usuario: se espera al menos un argumento.";
        EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = "Se esperaba un número par de argumentos.";
        // -------------------------------------------------
        INVALID_FUNCTION_NAME = "Nombre de función no válido.";
        INVALID_ARGUMENT_NAME = "Nombre de argumento no válido.";
        INVALID_CONSTANT_NAME = "Nombre de constante no válido.";
        INVALID_FUNCTION_DEFINITION = "Definición de función no válida.";
        INVALID_ARGUMENT_DEFINITION = "Definición de argumento no válida.";
        INVALID_CONSTANT_DEFINITION = "Definición de constante no válida.";
        PATTERN_DOES_NOT_MATCH = "El patrón no coincide.";
        PATTERN_EXAMPLES = "Ejemplos de patrón";
        // -------------------------------------------------
        CONSTANT_WAS_EXPECTED = "Se esperaba un valor constante.";
        USER_CONSTANT_WAS_EXPECTED = "Se esperaba una constante definida por el usuario.";
        // -------------------------------------------------
        UNARY_FUNCTION_EXPECTS_1_PARAMETER = "Una función unaria espera 1 parámetro.";
        BINARY_FUNCTION_EXPECTS_2_PARAMETERS = "Una función binaria espera 2 parámetros.";
        TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = "Una función ternaria espera 3 parámetros.";
        // -------------------------------------------------
        DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = "El operador de derivada espera 2, 3, 4 o 5 parámetros de cálculo.";
        ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = "Se esperaba un argumento en una invocación del operador de derivada.";
        DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Se encontraron palabras clave duplicadas en la invocación del operador de cálculo. Verifique los parámetros de cálculo.";
        ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Se esperaba un token (argumento o desconocido) en la invocación del operador de cálculo.";
        NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = "El operador de derivada de orden N espera 3 o 5 parámetros de cálculo.";
        INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = "El operador integral/resolver espera 4 parámetros de cálculo.";
        ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = "El operador iterado espera 4 o 5 parámetros de cálculo.";
        FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = "El operador de diferencia hacia adelante/hacia atrás espera 2 o 3 parámetros de cálculo.";
        FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = "Se esperaba un argumento en la invocación del operador de diferencia hacia adelante/hacia atrás.";
        AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = "Se esperaba al menos un argumento.";
        // -------------------------------------------------
        ERROR_WHILE_EXECUTING_THE_CALCULATE = "Error al ejecutar el cálculo.";
        RECURSION_CALLS_COUNTER_EXCEEDED = "El contador de llamadas recursivas ha sido superado.";
        RECURSION_CALLS_COUNTER = "Contador de llamadas recursivas";
        STARTING_CALCULATION_LOOP = "Iniciando el bucle de cálculo.";
        CANCEL_REQUEST_FINISHING = "Solicitud de cancelación encontrada: finalizando.";
        INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = "Error interno/nivel de token extraño: finalizando. Probablemente un error de análisis: por favor, repórtelo.";
        FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = "Error fatal: no se sabe qué hacer con el token encontrado. Probablemente un error de análisis: por favor, repórtelo.";
        MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = "Se ha superado la longitud máxima del mensaje de error.";
        // -------------------------------------------------
        STARTING = "Iniciando...";
        PARSING = "Analizando";
        FULLY_COMPILED = "Completamente compilado";
        CALCULATED_VALUE = "Valor calculado";
        EXITING = "Saliendo.";
        DONE = "terminado.";
        // -------------------------------------------------
        KEYWORD = "Palabra clave";
        SYNTAX = "Sintaxis";
        NUMBER = "Número";
        NUMBER_LITERAL = "Literal numérico";
        TYPE = "Tipo";
        SINCE = "Desde";
        DESCRIPTION = "Descripción";
        // -------------------------------------------------
        CALC_STEPS_REGISTER_IS_EMPTY = "El registro de pasos de cálculo está vacío.";
        CALC_STEPS_REGISTER_FOR = "Registro de pasos de cálculo para";
        ARGUMENT = "Argumento";
        FUNCTION = "Función";
        EXPRESSION = "Expresión";
        RESULT = "resultado";
        COMPUTING_TIME = "Tiempo de cálculo";
        GROUP_SHORT = "grupo";
        NUMBER_SHORT = "núm.";
        FIRST = "primero";
        LAST = "último";
        DESCRIPTION_SHORT = "descr.";
        STEP = "paso";
        // -------------------------------------------------
        SERIALIZATION_PERFORMED = "Se realizó la serialización:";
        DESERIALIZATION_PERFORMED = "Se realizó la deserialización:";
        NULL_OBJECT_PROVIDED = "Se proporcionó un objeto nulo.";
        NULL_FILE_PATH_PROVIDED = "Se proporcionó una ruta de archivo nula.";
        FILE_PATH_ZERO_LENGTH_PROVIDED = "La ruta de archivo no contiene caracteres.";
        FILE_PATH_IS_NOT_A_FILE = "La ruta de archivo no es un archivo:";
        FILE_PATH_NOT_EXISTS = "La ruta de archivo no existe:";
        NULL_DATA_PROVIDED = "Se proporcionaron datos nulos.";
        BINARY_SERIALIZATION_ENABLED = "La serialización binaria está habilitada. Úsela solo de manera consciente y limitada.";
        BINARY_SERIALIZATION_DISABLED = "La serialización binaria está deshabilitada. Puede habilitarla si es consciente de los riesgos de seguridad.";
        // -------------------------------------------------
        USER_DEFINED_EXPRESSION = "Expresión definida por el usuario";
        USER_DEFINED_ARGUMENT = "Argumento definido por el usuario";
        USER_DEFINED_CONSTANT = "Constante definida por el usuario";
        USER_DEFINED_FUNCTION = "Función definida por el usuario";
        USER_DEFINED_RECURSIVE_ARGUMENT = "Argumento recursivo definido por el usuario";
        // -------------------------------------------------
        HELP_CONTENT_LIMITED_TO_QUERY = "Contenido de ayuda limitado a la consulta";
        ALL_HELP_CONTENT = "Todo el contenido de ayuda.";
        CAPTION = "Título";
        // -------------------------------------------------
        WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "ADVERTENCIA DE SEGURIDAD:" + StringInvariant.NEW_LINE
                + "Deserializar datos de una fuente no confiable puede introducir vulnerabilidades de seguridad" + StringInvariant.NEW_LINE
                + "en su aplicación. Dependiendo de los ajustes utilizados durante la deserialización," + StringInvariant.NEW_LINE
                + "los datos no confiables pueden ejecutar código arbitrario o causar un ataque de denegación" + StringInvariant.NEW_LINE
                + "de servicio. Los datos no confiables pueden provenir de la red de una fuente no confiable" + StringInvariant.NEW_LINE
                + "(por ejemplo, cualquier cliente de red), o pueden ser manipulados / alterados por un" + StringInvariant.NEW_LINE
                + "intermediario mientras se transitan por una conexión no autenticada, o del almacenamiento" + StringInvariant.NEW_LINE
                + "local donde pueden haber sido comprometidos / alterados, o de muchas otras fuentes." + StringInvariant.NEW_LINE
                + "MathParser.org-mXparser no proporciona ningún medio para autenticar datos o asegurarlos" + StringInvariant.NEW_LINE
                + "contra la manipulación. Use un método de autenticación de datos apropiado antes de" + StringInvariant.NEW_LINE
                + "deserializar. Sea muy consciente de estos escenarios de ataque; muchos proyectos y empresas" + StringInvariant.NEW_LINE
                + "y usuarios de bibliotecas de serialización en general han sido afectados por la" + StringInvariant.NEW_LINE
                + "deserialización no confiable de los datos del usuario en el pasado." + StringInvariant.NEW_LINE
        ;
        // -------------------------------------------------
        BINARY_RELATION = "Relación binaria";
        BITWISE_OPERATOR = "Operador a nivel de bits";
        BOOLEAN_OPERATOR = "Operador booleano";
        CALCULUS_OPERATOR = "Operador de cálculo";
        CONSTANT_VALUE = "Valor constante";
        FUNCTION_1_ARG = "Función unaria";
        FUNCTION_2_ARG = "Función binaria";
        FUNCTION_3_ARG = "Función ternaria";
        FUNCTION_VARIADIC = "Función variadica";
        OPERATOR = "Operador";
        PARSER_SYMBOL = "Símbolo del analizador";
        RANDOM_VARIABLE = "Variable aleatoria";
        UNIT = "Unidad";
        DIMENSIONLESS_UNIT = "Unidad sin dimensiones";
        ITERATED_OPERATOR = "Operador iterado";
        // -------------------------------------------------
        RATIO_FRACTION = "Razón / Fracción";
        METRIC_PREFIX = "Prefijo métrico";
        UNIT_OF_LENGTH = "Unidad de longitud";
        UNIT_OF_AREA = "Unidad de área";
        UNIT_OF_VOLUME = "Unidad de volumen";
        UNIT_OF_TIME = "Unidad de tiempo";
        UNIT_OF_MASS = "Unidad de masa";
        UNIT_OF_INFORMATION = "Unidad de información";
        UNIT_OF_ENERGY = "Unidad de energía";
        UNIT_OF_SPEED = "Unidad de velocidad";
        UNIT_OF_ACCELERATION = "Unidad de aceleración";
        UNIT_OF_ANGLE = "Unidad de ángulo";
        // -------------------------------------------------
        PHYSICAL_CONSTANT = "Constante física";
        ASTRONOMICAL_CONSTANT = "Constante astronómica";
        MATHEMATICAL_CONSTANT = "Constante matemática";
        // -------------------------------------------------
        PROBABILITY_DISTRIBUTION_FUNCTION = "Función de distribución de probabilidad";
        CUMULATIVE_DISTRIBUTION_FUNCTION = "Función de distribución acumulativa";
        QUANTILE_FUNCTION = "Función cuantil (función de distribución acumulativa inversa)";
        // -------------------------------------------------
        STUDENTS_T_DISTRIBUTION = "Distribución t de Student";
        CHI_SQUARED_DISTRIBUTION = "Distribución chi cuadrado";
        SNEDECORS_F_DISTRIBUTION = "Distribución F de Snedecor (Distribución F o razón F, también conocida como distribución Fisher-Snedecor)";
        UNIFORM_CONTINUOUS_DISTRIBUTION = "Distribución uniforme continua";
        UNIFORM_DISCRETE_DISTRIBUTION = "Distribución uniforme discreta";
        NORMAL_DISTRIBUTION = "Distribución normal";
        // -------------------------------------------------
        RANDOM_INTEGER = "Número entero aleatorio";
        RANDOM_NATURAL_NUMBER = "Número natural aleatorio";
        RANDOM_NATURAL_NUMBER_INCLUDING_0 = "Número natural aleatorio incluyendo 0";
        // -------------------------------------------------
        SPECIAL_FUNCTION = "Función especial";
        // -------------------------------------------------
        SEMI_MAJOR_AXIS = "Eje semimayor";
        // -------------------------------------------------
        BINARY_RELATION_EQ = "Igualdad";
        BINARY_RELATION_NEQ = "Inequación";
        BINARY_RELATION_LT = "Menor que";
        BINARY_RELATION_GT = "Mayor que";
        BINARY_RELATION_LEQ = "Menor o igual que";
        BINARY_RELATION_GEQ = "Mayor o igual que";
        // -------------------------------------------------
        BITWISE_OPERATOR_COMPL = "Complemento unario a nivel de bits (NOT)";
        BITWISE_OPERATOR_AND = "Y a nivel de bits (AND)";
        BITWISE_OPERATOR_XOR = "O exclusivo a nivel de bits (XOR)";
        BITWISE_OPERATOR_OR = "O inclusivo a nivel de bits (OR)";
        BITWISE_OPERATOR_LEFT_SHIFT = "Desplazamiento a la izquierda con signo a nivel de bits";
        BITWISE_OPERATOR_RIGHT_SHIFT = "Desplazamiento a la derecha con signo a nivel de bits";
        BITWISE_OPERATOR_NAND = "NO Y a nivel de bits (NAND)";
        BITWISE_OPERATOR_NOR = "NO O a nivel de bits (NOR)";
        BITWISE_OPERATOR_XNOR = "NO O exclusivo a nivel de bits (XNOR)";
        // -------------------------------------------------
        BOOLEAN_OPERATOR_AND = "Conjunción lógica";
        BOOLEAN_OPERATOR_OR = "Disyunción lógica";
        BOOLEAN_OPERATOR_NEG = "Negación";
        BOOLEAN_OPERATOR_NAND = "Stroke de Sheffer";
        BOOLEAN_OPERATOR_NOR = "No lógico o (negación conjunta)";
        BOOLEAN_OPERATOR_XOR = "O exclusivo";
        BOOLEAN_OPERATOR_IMP = "Implicación";
        BOOLEAN_OPERATOR_CIMP = "Implicación conversa";
        BOOLEAN_OPERATOR_NIMP = "No implicación material";
        BOOLEAN_OPERATOR_CNIMP = "No implicación conversa";
        BOOLEAN_OPERATOR_EQV = "Bicondicional lógico";
        // -------------------------------------------------
        CALCULUS_OPERATOR_SUM = "Sumatoria SIGMA";
        CALCULUS_OPERATOR_PROD = "Producto PI";
        CALCULUS_OPERATOR_INT = "Integral definida";
        CALCULUS_OPERATOR_DER = "Derivada";
        CALCULUS_OPERATOR_DER_LEFT = "Derivada izquierda";
        CALCULUS_OPERATOR_DER_RIGHT = "Derivada derecha";
        CALCULUS_OPERATOR_DERN = "n-ésima derivada";
        CALCULUS_OPERATOR_FORW_DIFF = "Diferencia hacia adelante";
        CALCULUS_OPERATOR_BACKW_DIFF = "Diferencia hacia atrás";
        CALCULUS_OPERATOR_AVG = "Promedio";
        CALCULUS_OPERATOR_VAR = "Varianza de muestra corregida por sesgo";
        CALCULUS_OPERATOR_STD = "Desviación estándar de muestra corregida por sesgo";
        CALCULUS_OPERATOR_MIN = "Valor mínimo";
        CALCULUS_OPERATOR_MAX = "Valor máximo";
        CALCULUS_OPERATOR_SOLVE = "Resolución de ecuaciones (búsqueda de raíces)";
        // -------------------------------------------------
        CONSTANT_VALUE_PI = "Pi, número de Arquímedes o de Ludolph";
        CONSTANT_VALUE_EULER = "Número de Napier o de Euler (base del logaritmo natural)";
        CONSTANT_VALUE_EULER_MASCHERONI = "Constante de Euler-Mascheroni";
        CONSTANT_VALUE_GOLDEN_RATIO = "Proporción áurea";
        CONSTANT_VALUE_PLASTIC = "Constante plástica";
        CONSTANT_VALUE_EMBREE_TREFETHEN = "Constante de Embree-Trefethen";
        CONSTANT_VALUE_FEIGENBAUM_DELTA = "Constante delta de Feigenbaum";
        CONSTANT_VALUE_FEIGENBAUM_ALPHA = "Constante alfa de Feigenbaum";
        CONSTANT_VALUE_TWIN_PRIME = "Constante de los primos gemelos";
        CONSTANT_VALUE_MEISSEL_MERTEENS = "Constante de Meissel-Mertens";
        CONSTANT_VALUE_BRAUN_TWIN_PRIME = "Constante de Brun para primos gemelos";
        CONSTANT_VALUE_BRAUN_PRIME_QUADR = "Constante de Brun para cuadruplets primos";
        CONSTANT_VALUE_BRUIJN_NEWMAN = "Constante de de Bruijn-Newman";
        CONSTANT_VALUE_CATALAN = "Constante de Catalan";
        CONSTANT_VALUE_LANDAU_RAMANUJAN = "Constante de Landau-Ramanujan";
        CONSTANT_VALUE_VISWANATH = "Constante de Viswanath";
        CONSTANT_VALUE_LEGENDRE = "Constante de Legendre";
        CONSTANT_VALUE_RAMANUJAN_SOLDNER = "Constante de Ramanujan-Soldner";
        CONSTANT_VALUE_ERDOS_BORWEIN = "Constante de Erdos-Borwein";
        CONSTANT_VALUE_BERNSTEIN = "Constante de Bernstein";
        CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = "Constante de Gauss-Kuzmin-Wirsing";
        CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = "Constante de Hafner-Sarnak-McCurley";
        CONSTANT_VALUE_GOLOMB_DICKMAN = "Constante de Golomb-Dickman";
        CONSTANT_VALUE_CAHEN = "Constante de Cahen";
        CONSTANT_VALUE_LAPLACE_LIMIT = "Constante del límite de Laplace";
        CONSTANT_VALUE_ALLADI_GRINSTEAD = "Constante de Alladi-Grinstead";
        CONSTANT_VALUE_LENGYEL = "Constante de Lengyel";
        CONSTANT_VALUE_LEVY = "Constante de Levy";
        CONSTANT_VALUE_APERY = "Constante de Apery";
        CONSTANT_VALUE_MILLS = "Constante de Mills";
        CONSTANT_VALUE_BACKHOUSE = "Constante de Backhouse";
        CONSTANT_VALUE_PORTER = "Constante de Porter";
        CONSTANT_VALUE_LIEB_QUARE_ICE = "Constante de hielo cuadrado de Lieb";
        CONSTANT_VALUE_NIVEN = "Constante de Niven";
        CONSTANT_VALUE_SIERPINSKI = "Constante de Sierpinski";
        CONSTANT_VALUE_KHINCHIN = "Constante de Khinchin";
        CONSTANT_VALUE_FRANSEN_ROBINSON = "Constante de Fransen-Robinson";
        CONSTANT_VALUE_LANDAU = "Constante de Landau";
        CONSTANT_VALUE_PARABOLIC = "Constante parabólica";
        CONSTANT_VALUE_OMEGA = "Constante Omega";
        CONSTANT_VALUE_MRB = "Constante MRB";
        CONSTANT_VALUE_LI2 = "Integral logarítmica en el punto 2";
        CONSTANT_VALUE_GOMPERTZ = "Constante de Gompertz";
        CONSTANT_VALUE_LIGHT_SPEED = "Velocidad de la luz en el vacío";
        CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = "Constante gravitacional";
        CONSTANT_VALUE_GRAVIT_ACC_EARTH = "Aceleración gravitacional en la Tierra";
        CONSTANT_VALUE_PLANCK_CONSTANT = "Constante de Planck";
        CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = "Constante reducida de Planck (constante de Dirac)";
        CONSTANT_VALUE_PLANCK_LENGTH = "Longitud de Planck";
        CONSTANT_VALUE_PLANCK_MASS = "Masa de Planck";
        CONSTANT_VALUE_PLANCK_TIME = "Tiempo de Planck";
        CONSTANT_VALUE_LIGHT_YEAR = "Año luz";
        CONSTANT_VALUE_ASTRONOMICAL_UNIT = "Unidad astronómica";
        CONSTANT_VALUE_PARSEC = "Parsec";
        CONSTANT_VALUE_KILOPARSEC = "Kiloparsec";
        CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = "Radio ecuatorial de la Tierra";
        CONSTANT_VALUE_EARTH_RADIUS_POLAR = "Radio polar de la Tierra";
        CONSTANT_VALUE_EARTH_RADIUS_MEAN = "Radio medio de la Tierra";
        CONSTANT_VALUE_EARTH_MASS = "Masa de la Tierra";
        CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = "Distancia Tierra-Sol";
        CONSTANT_VALUE_MOON_RADIUS_MEAN = "Radio medio de la Luna";
        CONSTANT_VALUE_MOON_MASS = "Masa de la Luna";
        CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = "Distancia Luna-Tierra";
        CONSTANT_VALUE_SOLAR_RADIUS = "Radio medio solar";
        CONSTANT_VALUE_SOLAR_MASS = "Masa solar";
        CONSTANT_VALUE_MERCURY_RADIUS_MEAN = "Radio medio de Mercurio";
        CONSTANT_VALUE_MERCURY_MASS = "Masa de Mercurio";
        CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = "Distancia Mercurio-Sol";
        CONSTANT_VALUE_VENUS_RADIUS_MEAN = "Radio medio de Venus";
        CONSTANT_VALUE_VENUS_MASS = "Masa de Venus";
        CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = "Distancia Venus-Sol";
        CONSTANT_VALUE_MARS_RADIUS_MEAN = "Radio medio de Marte";
        CONSTANT_VALUE_MARS_MASS = "Masa de Marte";
        CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = "Distancia Marte-Sol";
        CONSTANT_VALUE_JUPITER_RADIUS_MEAN = "Radio medio de Júpiter";
        CONSTANT_VALUE_JUPITER_MASS = "Masa de Júpiter";
        CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = "Distancia Júpiter-Sol";
        CONSTANT_VALUE_SATURN_RADIUS_MEAN = "Radio medio de Saturno";
        CONSTANT_VALUE_SATURN_MASS = "Masa de Saturno";
        CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = "Distancia Saturno-Sol";
        CONSTANT_VALUE_URANUS_RADIUS_MEAN = "Radio medio de Urano";
        CONSTANT_VALUE_URANUS_MASS = "Masa de Urano";
        CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = "Distancia Urano-Sol";
        CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = "Radio medio de Neptuno";
        CONSTANT_VALUE_NEPTUNE_MASS = "Masa de Neptuno";
        CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = "Distancia Neptuno-Sol";
        CONSTANT_VALUE_TRUE = "Booleano Verdadero representado como 1";
        CONSTANT_VALUE_FALSE = "Booleano Falso representado como 0";
        CONSTANT_VALUE_NPAR = "Constante generada automáticamente para funciones definidas por el usuario, devuelve el número de parámetros de la función dada";
        CONSTANT_VALUE_NAN = "No es un número";
        // -------------------------------------------------
        FUNCTION_1_ARG_SIN = "Seno trigonométrico";
        FUNCTION_1_ARG_COS = "Coseno trigonométrico";
        FUNCTION_1_ARG_TAN = "Tangente trigonométrica";
        FUNCTION_1_ARG_CTAN = "Cotangente trigonométrica";
        FUNCTION_1_ARG_SEC = "Secante trigonométrica";
        FUNCTION_1_ARG_COSEC = "Cosecante trigonométrica";
        FUNCTION_1_ARG_ASIN = "Seno trigonométrico inverso";
        FUNCTION_1_ARG_ACOS = "Coseno trigonométrico inverso";
        FUNCTION_1_ARG_ATAN = "Tangente trigonométrica inversa";
        FUNCTION_1_ARG_ACTAN = "Cotangente trigonométrica inversa";
        FUNCTION_1_ARG_LN = "Logaritmo natural (base e)";
        FUNCTION_1_ARG_LOG2 = "Logaritmo binario (base 2)";
        FUNCTION_1_ARG_LOG10 = "Logaritmo común (base 10)";
        FUNCTION_1_ARG_RAD = "Grados a radianes";
        FUNCTION_1_ARG_EXP = "Exponencial";
        FUNCTION_1_ARG_SQRT = "Raíz cuadrada";
        FUNCTION_1_ARG_SINH = "Seno hiperbólico";
        FUNCTION_1_ARG_COSH = "Coseno hiperbólico";
        FUNCTION_1_ARG_TANH = "Tangente hiperbólica";
        FUNCTION_1_ARG_COTH = "Cotangente hiperbólica";
        FUNCTION_1_ARG_SECH = "Secante hiperbólica";
        FUNCTION_1_ARG_CSCH = "Cosecante hiperbólica";
        FUNCTION_1_ARG_DEG = "Radianes a grados";
        FUNCTION_1_ARG_ABS = "Valor absoluto";
        FUNCTION_1_ARG_SGN = "Signo";
        FUNCTION_1_ARG_FLOOR = "Suelo";
        FUNCTION_1_ARG_CEIL = "Techo";
        FUNCTION_1_ARG_NOT = "Negación";
        FUNCTION_1_ARG_ARSINH = "Seno hiperbólico inverso";
        FUNCTION_1_ARG_ARCOSH = "Coseno hiperbólico inverso";
        FUNCTION_1_ARG_ARTANH = "Tangente hiperbólica inversa";
        FUNCTION_1_ARG_ARCOTH = "Cotangente hiperbólica inversa";
        FUNCTION_1_ARG_ARSECH = "Secante hiperbólica inversa";
        FUNCTION_1_ARG_ARCSCH = "Cosecante hiperbólica inversa";
        FUNCTION_1_ARG_SA = "Sinc (normalizado)";
        FUNCTION_1_ARG_SINC = "Sinc (no normalizado)";
        FUNCTION_1_ARG_BELL_NUMBER = "Número de Bell";
        FUNCTION_1_ARG_LUCAS_NUMBER = "Número de Lucas";
        FUNCTION_1_ARG_FIBONACCI_NUMBER = "Número de Fibonacci";
        FUNCTION_1_ARG_HARMONIC_NUMBER = "Número armónico";
        FUNCTION_1_ARG_IS_PRIME = "Test de número primo (¿es el número primo?)";
        FUNCTION_1_ARG_PRIME_COUNT = "Conteo de primos";
        FUNCTION_1_ARG_EXP_INT = "Integral exponencial";
        FUNCTION_1_ARG_LOG_INT = "Integral logarítmica";
        FUNCTION_1_ARG_OFF_LOG_INT = "Integral logarítmica compensada";
        FUNCTION_1_ARG_GAUSS_ERF = "Error de Gauss";
        FUNCTION_1_ARG_GAUSS_ERFC = "Error complementario de Gauss";
        FUNCTION_1_ARG_GAUSS_ERF_INV = "Error de Gauss inverso";
        FUNCTION_1_ARG_GAUSS_ERFC_INV = "Error complementario de Gauss inverso";
        FUNCTION_1_ARG_ULP = "Unidad en el último lugar";
        FUNCTION_1_ARG_ISNAN = "Devuelve verdadero si el valor es No es un número (NaN), falso en caso contrario";
        FUNCTION_1_ARG_NDIG10 = "Número de dígitos en el sistema numérico con base 10";
        FUNCTION_1_ARG_NFACT = "Descomposición en primos - número de factores primos distintos";
        FUNCTION_1_ARG_ARCSEC = "Secante trigonométrica inversa";
        FUNCTION_1_ARG_ARCCSC = "Cosecante trigonométrica inversa";
        FUNCTION_1_ARG_GAMMA = "Gamma";
        FUNCTION_1_ARG_LAMBERT_W0 = "Lambert-W, rama principal 0, también llamada el logaritmo de producto u omega";
        FUNCTION_1_ARG_LAMBERT_W1 = "Lambert-W, rama -1, también llamada el logaritmo de producto u omega";
        FUNCTION_1_ARG_SGN_GAMMA = "Signo de Gamma";
        FUNCTION_1_ARG_LOG_GAMMA = "Log Gamma";
        FUNCTION_1_ARG_DI_GAMMA = "Digamma como la derivada logarítmica de la Gamma";
        FUNCTION_1_ARG_PARAM = "Función generada automáticamente para funciones definidas por el usuario, devuelve el valor del parámetro de la función en el índice 'i'";
        // -------------------------------------------------
        FUNCTION_2_ARG_LOG = "Logaritmo";
        FUNCTION_2_ARG_MOD = "Módulo";
        FUNCTION_2_ARG_BINOM_COEFF = "Coeficiente binomial, número de combinaciones k que se pueden sacar de un conjunto de n elementos";
        FUNCTION_2_ARG_BERNOULLI_NUMBER = "Números de Bernoulli";
        FUNCTION_2_ARG_STIRLING1_NUMBER = "Números de Stirling del primer tipo";
        FUNCTION_2_ARG_STIRLING2_NUMBER = "Números de Stirling del segundo tipo";
        FUNCTION_2_ARG_WORPITZKY_NUMBER = "Número de Worpitzky";
        FUNCTION_2_ARG_EULER_NUMBER = "Número de Euler";
        FUNCTION_2_ARG_KRONECKER_DELTA = "Delta de Kronecker";
        FUNCTION_2_ARG_EULER_POLYNOMIAL = "Polinomio de Euler";
        FUNCTION_2_ARG_HARMONIC_NUMBER = "Número armónico";
        FUNCTION_2_ARG_ROUND = "Redondeo a la mitad hacia arriba";
        FUNCTION_2_ARG_NDIG = "Número de dígitos que representan el número en el sistema numérico con base dada";
        FUNCTION_2_ARG_DIGIT10 = "Dígito en la posición 1 ... n (izquierda -> derecha) o 0 ... -(n-1) (derecha -> izquierda) - sistema numeral base 10";
        FUNCTION_2_ARG_FACTVAL = "Descomposición en factores primos - valor del factor en la posición entre 1 ... nfact(n) - orden ascendente por valor del factor";
        FUNCTION_2_ARG_FACTEXP = "Descomposición en factores primos - exponente del factor / multiplicidad en la posición entre 1 ... nfact(n) - orden ascendente por valor del factor";
        FUNCTION_2_ARG_ROOT = "Raíz de orden N de un número";
        FUNCTION_2_ARG_INC_GAMMA_LOWER = "Gamma incompleta inferior";
        FUNCTION_2_ARG_INC_GAMMA_UPPER = "Gamma incompleta superior";
        FUNCTION_2_ARG_REG_GAMMA_LOWER = "Gamma P regularizada inferior";
        FUNCTION_2_ARG_REG_GAMMA_UPPER = "Gamma Q regularizada superior";
        FUNCTION_2_ARG_PERMUTATIONS = "Número de permutaciones k que se pueden sacar de un conjunto de n elementos";
        FUNCTION_2_ARG_BETA = "La Beta, también llamada integral de Euler del primer tipo";
        FUNCTION_2_ARG_LOG_BETA = "La Log Beta, también llamada integral de Euler del primer tipo logarítmica";
        // -------------------------------------------------
        FUNCTION_3_ARG_IF = "Si";
        FUNCTION_3_ARG_CHI = "Función característica para x en (a,b)";
        FUNCTION_3_ARG_CHI_LR = "Función característica para x en [a,b]";
        FUNCTION_3_ARG_CHI_L = "Función característica para x en [a,b)";
        FUNCTION_3_ARG_CHI_R = "Función característica para x en (a,b]";
        FUNCTION_3_ARG_DIGIT = "Dígito en la posición 1 ... n (izquierda -> derecha) o 0 ... -(n-1) (derecha -> izquierda) - sistema numeral con base dada";
        FUNCTION_3_ARG_INC_BETA = "La Beta incompleta, también llamada integral de Euler del primer tipo incompleta";
        FUNCTION_3_ARG_REG_BETA = "La Beta regularizada incompleta (o beta regularizada), también llamada integral de Euler del primer tipo incompleta regularizada";
        // -------------------------------------------------
        FUNCTION_VARIADIC_IFF = "Función Si";
        FUNCTION_VARIADIC_MIN = "Mínimo";
        FUNCTION_VARIADIC_MAX = "Máximo";
        FUNCTION_VARIADIC_CONT_FRAC = "Fracción continua";
        FUNCTION_VARIADIC_CONT_POL = "Polinomio continuado";
        FUNCTION_VARIADIC_GCD = "Máximo común divisor";
        FUNCTION_VARIADIC_LCM = "Mínimo común múltiplo";
        FUNCTION_VARIADIC_SUM = "Suma";
        FUNCTION_VARIADIC_PROD = "Multiplicación";
        FUNCTION_VARIADIC_AVG = "Media / valor promedio";
        FUNCTION_VARIADIC_VAR = "Varianza de muestra corregida por sesgo";
        FUNCTION_VARIADIC_STD = "Desviación estándar de la muestra corregida por sesgo";
        FUNCTION_VARIADIC_RND_LIST = "Número aleatorio de una lista dada de números";
        FUNCTION_VARIADIC_COALESCE = "Devuelve el primer valor no-NaN";
        FUNCTION_VARIADIC_OR = "Disyunción lógica (OR) - variadic";
        FUNCTION_VARIADIC_AND = "Conjunción lógica (AND) - variadic";
        FUNCTION_VARIADIC_XOR = "O exclusivo (XOR) - variadic";
        FUNCTION_VARIADIC_ARGMIN = "Argumentos / índices de los mínimos";
        FUNCTION_VARIADIC_ARGMAX = "Argumentos / índices de los máximos";
        FUNCTION_VARIADIC_MEDIAN = "La mediana de la muestra";
        FUNCTION_VARIADIC_MODE = "Moda - el valor que aparece con más frecuencia";
        FUNCTION_VARIADIC_BASE = "Devuelve el número en la base del sistema numérico dado representado por una lista de dígitos";
        FUNCTION_VARIADIC_NDIST = "Número de valores distintos";
        // -------------------------------------------------
        OPERATOR_PLUS = "Suma";
        OPERATOR_MINUS = "Resta";
        OPERATOR_MULTIPLY = "Multiplicación";
        OPERATOR_DIVIDE = "División";
        OPERATOR_DIVIDE_QUOTIENT = "División entera (cociente)";
        OPERATOR_POWER = "Exponenciación";
        OPERATOR_FACT = "Factorial";
        OPERATOR_MOD = "Módulo";
        OPERATOR_PERC = "Porcentaje";
        OPERATOR_TETRATION = "Tetración (hiper-4, torre de potencias, torre exponencial)";
        OPERATOR_SQUARE_ROOT = "Raíz cuadrada";
        OPERATOR_CUBE_ROOT = "Raíz cúbica";
        OPERATOR_FOURTH_ROOT = "Raíz cuarta";
        // -------------------------------------------------
        PARSER_SYMBOL_LEFT_PARENTHESES = "Paréntesis izquierdo";
        PARSER_SYMBOL_RIGHT_PARENTHESES = "Paréntesis derecho";
        PARSER_SYMBOL_COMMA = "Coma (parámetros de función)";
        PARSER_SYMBOL_SEMI = "Punto y coma (parámetros de función)";
        PARSER_SYMBOL_BLANK = "Carácter en blanco (espacio)";
        PARSER_SYMBOL_NUMBER_INTEGER = "Entero";
        PARSER_SYMBOL_NUMBER_DECIMAL = "Decimal";
        PARSER_SYMBOL_NUMBER_LEADING_ZERO = "Cero inicial";
        PARSER_SYMBOL_NUMBER_SCI_NOTATION = "Notación científica";
        PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = "Sin cero inicial";
        PARSER_SYMBOL_NUMBER_FRACTIONS = "Fracciones";
        PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = "Otros sistemas numerales";
        PARSER_SYMBOL_UNICODE_MATH = " - Símbolo matemático Unicode";
        // -------------------------------------------------
        DIMENSIONLESS_UNIT_PERC = "Porcentaje";
        DIMENSIONLESS_UNIT_PERM = "Por mil";
        DIMENSIONLESS_UNIT_YOTTA = "Septillón / Yotta";
        DIMENSIONLESS_UNIT_ZETTA = "Sextillón / Zetta";
        DIMENSIONLESS_UNIT_EXA = "Quintillón / Exa";
        DIMENSIONLESS_UNIT_PETA = "Cuadrillón / Peta";
        DIMENSIONLESS_UNIT_TERA = "Trillón / Tera";
        DIMENSIONLESS_UNIT_GIGA = "Billón / Giga";
        DIMENSIONLESS_UNIT_MEGA = "Millón / Mega";
        DIMENSIONLESS_UNIT_KILO = "Mil / Kilo";
        DIMENSIONLESS_UNIT_HECTO = "Cien / Hecto";
        DIMENSIONLESS_UNIT_DECA = "Diez / Deca";
        DIMENSIONLESS_UNIT_DECI = "Décimo / Deci";
        DIMENSIONLESS_UNIT_CENTI = "Centésimo / Centi";
        DIMENSIONLESS_UNIT_MILLI = "Milésimo / Milli";
        DIMENSIONLESS_UNIT_MICRO = "Millonésimo / Micro";
        DIMENSIONLESS_UNIT_NANO = "Milmillonésimo / Nano";
        DIMENSIONLESS_UNIT_PICO = "Billonésimo / Pico";
        DIMENSIONLESS_UNIT_FEMTO = "Trillonésimo / Femto";
        DIMENSIONLESS_UNIT_ATTO = "Cuatrillonésimo / Atto";
        DIMENSIONLESS_UNIT_ZEPTO = "Quintillonésimo / Zepto";
        DIMENSIONLESS_UNIT_YOCTO = "Sextillonésimo / Yocto";
        // -------------------------------------------------
        UNIT_METRE = "Metro";
        UNIT_KILOMETRE = "Kilómetro";
        UNIT_CENTIMETRE = "Centímetro";
        UNIT_MILLIMETRE = "Milímetro";
        UNIT_INCH = "Pulgada";
        UNIT_YARD = "Yarda";
        UNIT_FEET = "Pie";
        UNIT_MILE = "Milla";
        UNIT_NAUTICAL_MILE = "Milla náutica";
        UNIT_METRE2 = "Metro cuadrado";
        UNIT_CENTIMETRE2 = "Centímetro cuadrado";
        UNIT_MILLIMETRE2 = "Milímetro cuadrado";
        UNIT_ARE = "Área";
        UNIT_HECTARE = "Hectárea";
        UNIT_ACRE = "Acre";
        UNIT_KILOMETRE2 = "Kilómetro cuadrado";
        UNIT_MILLIMETRE3 = "Milímetro cúbico";
        UNIT_CENTIMETRE3 = "Centímetro cúbico";
        UNIT_METRE3 = "Metro cúbico";
        UNIT_KILOMETRE3 = "Kilómetro cúbico";
        UNIT_MILLILITRE = "Mililitro";
        UNIT_LITRE = "Litro";
        UNIT_GALLON = "Galón";
        UNIT_PINT = "Pinta";
        UNIT_SECOND = "Segundo";
        UNIT_MILLISECOND = "Milisegundo";
        UNIT_MINUTE = "Minuto";
        UNIT_HOUR = "Hora";
        UNIT_DAY = "Día";
        UNIT_WEEK = "Semana";
        UNIT_JULIAN_YEAR = "Año juliano = 365.25 días";
        UNIT_KILOGRAM = "Kilogramo";
        UNIT_GRAM = "Gramo";
        UNIT_MILLIGRAM = "Miligramo";
        UNIT_DECAGRAM = "Decagramo";
        UNIT_TONNE = "Tonelada";
        UNIT_OUNCE = "Onza";
        UNIT_POUND = "Libra";
        UNIT_BIT = "Bit";
        UNIT_KILOBIT = "Kilobit";
        UNIT_MEGABIT = "Megabit";
        UNIT_GIGABIT = "Gigabit";
        UNIT_TERABIT = "Terabit";
        UNIT_PETABIT = "Petabit";
        UNIT_EXABIT = "Exabit";
        UNIT_ZETTABIT = "Zettabit";
        UNIT_YOTTABIT = "Yottabit";
        UNIT_BYTE = "Byte";
        UNIT_KILOBYTE = "Kilobyte";
        UNIT_MEGABYTE = "Megabyte";
        UNIT_GIGABYTE = "Gigabyte";
        UNIT_TERABYTE = "Terabyte";
        UNIT_PETABYTE = "Petabyte";
        UNIT_EXABYTE = "Exabyte";
        UNIT_ZETTABYTE = "Zettabyte";
        UNIT_YOTTABYTE = "Yottabyte";
        UNIT_JOULE = "Julio";
        UNIT_ELECTRONO_VOLT = "Electronvoltio";
        UNIT_KILO_ELECTRONO_VOLT = "Kiloelectronvoltio";
        UNIT_MEGA_ELECTRONO_VOLT = "Megaelectronvoltio";
        UNIT_GIGA_ELECTRONO_VOLT = "Gigaelectronvoltio";
        UNIT_TERA_ELECTRONO_VOLT = "Teraelectronvoltio";
        UNIT_METRE_PER_SECOND = "Metro por segundo";
        UNIT_KILOMETRE_PER_HOUR = "Kilómetro por hora";
        UNIT_MILE_PER_HOUR = "Milla por hora";
        UNIT_KNOT = "Nudo";
        UNIT_METRE_PER_SECOND2 = "Metro por segundo cuadrado";
        UNIT_KILOMETRE_PER_HOUR2 = "Kilómetro por hora cuadrada";
        UNIT_MILE_PER_HOUR2 = "Milla por hora cuadrada";
        UNIT_RADIAN_ARC = "Radián";
        UNIT_DEGREE_ARC = "Grado de arco";
        UNIT_MINUTE_ARC = "Minuto de arco";
        UNIT_SECOND_ARC = "Segundo de arco";
    }
}