/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.mariuszgromada.math.mxparser.StringInvariant;
import org.mariuszgromada.math.mxparser.StringModel;

public final class StringUtils {
    private static final String HTML_TD_START_TAG = "<td>";
    private static final String HTML_TD_END_TAG = "</td>";
    private static final String HTML_TH_START_TAG = "<th>";
    private static final String HTML_TH_END_TAG = "</th>";
    private static final String HTML_TR_START_TAG = "<tr>";
    private static final String HTML_TR_END_TAG = "</tr>" + StringInvariant.NEW_LINE;
    private static final String MARKDOWN_DELIMITER = "|";
    private static final String MARKDOWN_ROW_BEFORE_TAG = "|";
    private static final String MARKDOWN_ROW_AFTER_TAG = "|" + StringInvariant.NEW_LINE;
    private static final String MARKDOWN_HEADER_TAG = "---";
    static final String JSON_ROW_INDENTATION_TAG = "  ";
    private static final String JSON_PART_INDENTATION_TAG = "    ";
    private static final String JSON_ROW_BEFORE_TAG = StringInvariant.NEW_LINE + "  " + "{" + StringInvariant.NEW_LINE;
    private static final String JSON_ROW_AFTER_TAG = StringInvariant.NEW_LINE + "  " + "}";
    private static final String JSON_PART_DELIMITER = "," + StringInvariant.NEW_LINE;

    public static boolean regexMatch(String str, String pattern) {
        return Pattern.matches(pattern, str);
    }

    static String surroundBrackets(String str) {
        return "(" + str + ")";
    }

    static String surroundBracketsAddSpace(String str) {
        return StringUtils.surroundBrackets(str) + " ";
    }

    static String surroundSquareBrackets(String str) {
        return "[" + str + "]";
    }

    static String surroundSquareBracketsAddSpace(String str) {
        return StringUtils.surroundSquareBrackets(str) + " ";
    }

    static String surroundApostrophe(String str) {
        return "'" + str + "'";
    }

    static String surroundApostropheAddSpace(String str) {
        return StringUtils.surroundApostrophe(str) + " ";
    }

    static String surroundQuote(String str) {
        return "\"" + str + "\"";
    }

    static String surroundQuoteAddSpace(String str) {
        return StringUtils.surroundQuote(str) + " ";
    }

    static String trimNotNull(String str) {
        if (str != null) {
            return str.trim();
        }
        return "";
    }

    static String stringConcatenateMaxLength(String str1, String str2, int maxLength) {
        if (str1.length() + str2.length() > maxLength) {
            if (str1.contains(StringModel.STRING_RESOURCES.MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED)) {
                return str1;
            }
            return str1 + StringModel.STRING_RESOURCES.MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED + StringInvariant.NEW_LINE;
        }
        return str1 + str2;
    }

    static boolean isUnicodeName(char c) {
        switch (c) {
            case '\u0391': 
            case '\u0392': 
            case '\u0393': 
            case '\u0394': 
            case '\u0395': 
            case '\u0396': 
            case '\u0397': 
            case '\u0398': 
            case '\u0399': 
            case '\u039a': 
            case '\u039b': 
            case '\u039c': 
            case '\u039d': 
            case '\u039e': 
            case '\u039f': 
            case '\u03a0': 
            case '\u03a1': 
            case '\u03a3': 
            case '\u03a4': 
            case '\u03a5': 
            case '\u03a6': 
            case '\u03a7': 
            case '\u03a8': 
            case '\u03a9': 
            case '\u03b1': 
            case '\u03b2': 
            case '\u03b3': 
            case '\u03b4': 
            case '\u03b5': 
            case '\u03b6': 
            case '\u03b7': 
            case '\u03b8': 
            case '\u03b9': 
            case '\u03ba': 
            case '\u03bb': 
            case '\u03bc': 
            case '\u03bd': 
            case '\u03be': 
            case '\u03bf': 
            case '\u03c0': 
            case '\u03c1': 
            case '\u03c2': 
            case '\u03c3': 
            case '\u03c4': 
            case '\u03c5': 
            case '\u03c6': 
            case '\u03c7': 
            case '\u03c8': 
            case '\u03c9': 
            case '\u2107': 
            case '\u212f': 
            case '\u213c': 
            case '\u213f': 
            case '\u2147': 
            case '\u2202': 
            case '\u2206': 
            case '\u2207': 
            case '\u220f': 
            case '\u2211': 
            case '\u222b': {
                return true;
            }
        }
        return false;
    }

    private static boolean isUnicodeOperator(char c) {
        switch (c) {
            case '\u00ac': 
            case '\u00d7': 
            case '\u00f7': 
            case '\u21cd': 
            case '\u21cf': 
            case '\u21d0': 
            case '\u21d2': 
            case '\u21d4': 
            case '\u2219': 
            case '\u221a': 
            case '\u221b': 
            case '\u221c': 
            case '\u2227': 
            case '\u2228': 
            case '\u2260': 
            case '\u2264': 
            case '\u2265': 
            case '\u22bb': 
            case '\u22bc': 
            case '\u22bd': 
            case '\u22dc': 
            case '\u22dd': 
            case '\u2a09': {
                return true;
            }
        }
        return false;
    }

    static boolean isNotSpecialChar(char c) {
        switch (c) {
            case '#': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '|': 
            case '~': {
                return false;
            }
        }
        return !StringUtils.isUnicodeOperator(c);
    }

    static boolean is0To9Digit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    static boolean canBeSeparatingChar(char c) {
        switch (c) {
            case ' ': 
            case '!': 
            case '#': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return StringUtils.isUnicodeOperator(c);
    }

    static boolean isBlankChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static boolean charIsLeftParenthesis(String str, int pos) {
        int len = str.length();
        if (pos >= len) {
            return false;
        }
        return str.charAt(pos) == '(';
    }

    static String repeatString(String str, int times) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    static String getLeftSpaces(String maxStr, String str) {
        return StringUtils.repeatString(" ", maxStr.length() - str.length()) + str;
    }

    static String getRightSpaces(String maxStr, String str) {
        return str + StringUtils.repeatString(" ", maxStr.length() - str.length());
    }

    static void consolePrintln() {
        System.out.println();
    }

    static void consolePrintln(Object o) {
        System.out.println(o);
    }

    static void errorPrintln() {
        System.err.println();
    }

    static void errorPrintln(Object o) {
        System.err.println(o);
    }

    static String cleanForHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    static String cleanForMarkdown(String text) {
        return text.replace("\\", "\\\\").replace("|", "\\|");
    }

    static String cleanForJson(String text) {
        return text.replace("\\", "\\\\");
    }

    static void stringBuilderPartsAppend(StringBuilder stringBuilder, String ... partsToAppend) {
        for (String part : partsToAppend) {
            stringBuilder.append(part);
        }
    }

    static void stringBuilderLinesAppend(StringBuilder stringBuilder, String ... linesToAppend) {
        for (String line : linesToAppend) {
            stringBuilder.append(line);
            stringBuilder.append(StringInvariant.NEW_LINE);
        }
    }

    static void stringBuilderPartsAppendDelimited(String partTagLeft, String partTagRight, String delimiter, boolean clearForHtml, boolean clearForMarkdown, boolean clearForJson, StringBuilder stringBuilder, String ... partsToAppend) {
        int n = 0;
        for (String part : partsToAppend) {
            if (++n > 1) {
                stringBuilder.append(delimiter);
            }
            stringBuilder.append(partTagLeft);
            String partFinal = part;
            if (clearForHtml) {
                partFinal = StringUtils.cleanForHtml(partFinal);
            }
            if (clearForMarkdown) {
                partFinal = StringUtils.cleanForMarkdown(partFinal);
            }
            if (clearForJson) {
                partFinal = StringUtils.cleanForJson(partFinal);
            }
            stringBuilder.append(partFinal);
            stringBuilder.append(partTagRight);
        }
    }

    static void stringBuilderPartsAppendDelimited(String partQuote, String delimiter, StringBuilder stringBuilder, String ... partsToAppend) {
        StringUtils.stringBuilderPartsAppendDelimited(partQuote, partQuote, delimiter, false, false, false, stringBuilder, partsToAppend);
    }

    static void stringBuilderPartsAppendDelimitedRow(String partTagLeft, String partTagRight, String delimiter, String rowBeforeTag, String rowAfterTag, boolean clearForHtml, boolean clearForMarkdown, boolean clearForJson, StringBuilder stringBuilder, String ... partsToAppend) {
        boolean tagAfter;
        boolean tagBefore = rowBeforeTag == null || rowBeforeTag.length() > 0;
        boolean bl = tagAfter = rowAfterTag == null || rowAfterTag.length() > 0;
        if (tagBefore) {
            stringBuilder.append(rowBeforeTag);
        }
        StringUtils.stringBuilderPartsAppendDelimited(partTagLeft, partTagRight, delimiter, clearForHtml, clearForMarkdown, clearForJson, stringBuilder, partsToAppend);
        if (tagAfter) {
            stringBuilder.append(rowAfterTag);
        }
    }

    static void stringBuilderPartsAppendDelimitedRow(String partQuote, String delimiter, boolean newLineBefore, boolean clearForHtml, boolean clearForMarkdown, boolean clearForJson, StringBuilder stringBuilder, String ... partsToAppend) {
        if (newLineBefore) {
            StringUtils.stringBuilderPartsAppendDelimitedRow(partQuote, partQuote, delimiter, StringInvariant.NEW_LINE, "", clearForHtml, clearForMarkdown, clearForJson, stringBuilder, partsToAppend);
        } else {
            StringUtils.stringBuilderPartsAppendDelimitedRow(partQuote, partQuote, delimiter, "", "", clearForHtml, clearForMarkdown, clearForJson, stringBuilder, partsToAppend);
        }
    }

    static void stringBuilderPartsAppendDelimitedRow(String partQuote, String delimiter, boolean newLineBefore, StringBuilder stringBuilder, String ... partsToAppend) {
        StringUtils.stringBuilderPartsAppendDelimitedRow(partQuote, delimiter, newLineBefore, false, false, false, stringBuilder, partsToAppend);
    }

    static void stringBuilderPartsAppendHtmlTableRow(StringBuilder stringBuilder, String ... partsToAppend) {
        StringUtils.stringBuilderPartsAppendDelimitedRow(HTML_TD_START_TAG, HTML_TD_END_TAG, "", HTML_TR_START_TAG, HTML_TR_END_TAG, true, false, false, stringBuilder, partsToAppend);
    }

    static void stringBuilderPartsAppendHtmlTableHead(StringBuilder stringBuilder, String ... partsToAppend) {
        StringUtils.stringBuilderPartsAppendDelimitedRow(HTML_TH_START_TAG, HTML_TH_END_TAG, "", HTML_TR_START_TAG, HTML_TR_END_TAG, true, false, false, stringBuilder, partsToAppend);
    }

    static void stringBuilderPartsAppendMarkdownTableRow(StringBuilder stringBuilder, String ... partsToAppend) {
        StringUtils.stringBuilderPartsAppendDelimitedRow("", "", "|", "|", MARKDOWN_ROW_AFTER_TAG, false, true, false, stringBuilder, partsToAppend);
    }

    static void stringBuilderPartsAppendMarkdownTableHead(boolean addHeader, StringBuilder stringBuilder, String ... partsToAppend) {
        if (!addHeader) {
            Object[] mdTableEmptyHeader = new String[partsToAppend.length];
            Arrays.fill(mdTableEmptyHeader, "   ");
            StringUtils.stringBuilderPartsAppendDelimitedRow("", "", "|", "|", MARKDOWN_ROW_AFTER_TAG, false, false, false, stringBuilder, (String[])mdTableEmptyHeader);
        } else {
            StringUtils.stringBuilderPartsAppendDelimitedRow("", "", "|", "|", MARKDOWN_ROW_AFTER_TAG, false, true, false, stringBuilder, partsToAppend);
        }
        Object[] mdTableStructure = new String[partsToAppend.length];
        Arrays.fill(mdTableStructure, MARKDOWN_HEADER_TAG);
        StringUtils.stringBuilderPartsAppendDelimitedRow("", "", "|", "|", MARKDOWN_ROW_AFTER_TAG, false, false, false, stringBuilder, (String[])mdTableStructure);
    }

    static void stringBuilderPartsAppendJsonRow(StringBuilder stringBuilder, String ... partsToAppend) {
        StringUtils.stringBuilderPartsAppendDelimitedRow(JSON_PART_INDENTATION_TAG, "", JSON_PART_DELIMITER, JSON_ROW_BEFORE_TAG, JSON_ROW_AFTER_TAG, false, false, true, stringBuilder, partsToAppend);
    }

    static String cleanNewLineAtTheEnd(String str) {
        int length = str.length();
        if (length == 0) {
            return str;
        }
        if (str.endsWith(StringInvariant.NEW_LINE)) {
            return str.substring(0, length - StringInvariant.NEW_LINE.length());
        }
        return str;
    }

    public static String numberToHexString(int number) {
        return Integer.toHexString(number);
    }

    public static String numberToHexString(long number) {
        return Long.toHexString(number);
    }

    public static String numberToHexString(double number) {
        return StringUtils.numberToHexString((long)number);
    }

    public static String hexString2AsciiString(String hexString) {
        String asciiString = "";
        for (int i = 0; i < hexString.length(); i += 2) {
            String hexByteStr = hexString.substring(i, i + 2);
            int hexByteInt = Integer.parseInt(hexByteStr, 16);
            asciiString = asciiString + (char)hexByteInt;
        }
        return asciiString;
    }

    public static String numberToAsciiString(int number) {
        return StringUtils.hexString2AsciiString(StringUtils.numberToHexString(number));
    }

    public static String numberToAsciiString(long number) {
        return StringUtils.hexString2AsciiString(StringUtils.numberToHexString(number));
    }

    public static String numberToAsciiString(double number) {
        return StringUtils.hexString2AsciiString(StringUtils.numberToHexString(number));
    }

    public static int countOccurrences(String str, String toFind) {
        if (str == null || toFind == null) {
            return -1;
        }
        int strLen = str.length();
        int toFindLen = toFind.length();
        if (strLen == 0 || toFindLen == 0 || toFindLen > strLen) {
            return 0;
        }
        return (strLen - str.replace(toFind, "").length()) / toFindLen;
    }

    public static int countLines(String text) {
        if (text == null) {
            return -1;
        }
        if (text.length() == 0) {
            return 0;
        }
        return StringUtils.countOccurrences(text, StringInvariant.NEW_LINE) + 1;
    }
}

