/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.mXparser;

public class Tutorial {
    private static String highlight(String str) {
        return "------ >>>>>>> " + str;
    }

    public static void main(String[] args) {
        mXparser.consolePrintln(Tutorial.highlight("Tutorial for the mXparser version 5.0 - Mariusz Gromada - 2022-01-23"));
        mXparser.consolePrintln(Tutorial.highlight("Start from the license"));
        mXparser.consolePrintln("mXparser - version 6.0.0\nMathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19\nThe most up-to-date license is available at the below link:\n- https://mathparser.org/mxparser-license\n\nAUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved\nPUBLISHER: INFIMA - https://payhip.com/infima\n\nSOFTWARE means source code and/or binary form and/or documentation.\nPRODUCT: MathParser.org-mXparser SOFTWARE\nLICENSE: DUAL LICENSE AGREEMENT\n\nBY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE\nBOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.\n\nThe AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT\nmodel designed to meet the needs of both non-commercial use and commercial\nuse.\n\nNON-COMMERCIAL USE means any use or activity where a fee is not charged\nand the purpose is not the sale of a good or service, and the use or\nactivity is not intended to produce a profit. Examples of NON-COMMERCIAL USE\ninclude:\n\n1. Non-commercial open-source software.\n2. Non-commercial mobile applications.\n3. Non-commercial desktop software.\n4. Non-commercial web applications/solutions.\n5. Non-commercial use in research, scholarly and educational context.\n\nThe above list is non-exhaustive and illustrative only.\n\nCOMMERCIAL USE means any use or activity where a fee is charged or the\npurpose is the sale of a good or service, or the use or activity is\nintended to produce a profit. COMMERCIAL USE examples:\n\n1. OEMs (Original Equipment Manufacturers).\n2. ISVs (Independent Software Vendors).\n3. VARs (Value Added Resellers).\n4. Other distributors that combine and distribute commercially licensed\n   software.\n\nThe above list is non-exhaustive and illustrative only.\n\nIN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE\nAPPROPRIATE LICENSE FROM \"INFIMA\" ONLINE STORE, STORE ADDRESS:\n\n1. https://mathparser.org/order-commercial-license\n2. https://payhip.com/infima\n\nNON-COMMERCIAL LICENSE\n\nRedistribution and use of the PRODUCT in source and/or binary forms,\nwith or without modification, are permitted provided that the following\nconditions are met:\n\n1. Redistributions of source code must retain the unmodified content of\n   the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including\n   the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,\n   the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,\n   and the following DISCLAIMER.\n2. Redistributions in binary form must reproduce the entire content of\n   MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation\n   and/or other materials provided with the distribution, including the\n   definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the\n   NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,\n   and the following DISCLAIMER.\n3. Any form of redistribution requires confirmation and signature of\n   the NON-COMMERCIAL USE by successfully calling the method:\n      License.iConfirmNonCommercialUse(...)\n   The method call is used only internally for logging purposes, and\n   there is no connection with other external services, and no data is\n   sent or collected. The lack of a method call (or its successful call)\n   does not affect the operation of the PRODUCT in any way. Please see\n   the API documentation.\n\nCOMMERCIAL LICENSE\n\n 1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow\n    you to download, install, and use up to three copies of the PRODUCT to\n    perform integration tests, confirm the quality of the PRODUCT, and\n    its suitability. The testing period should be limited to fourteen\n    days. Tests should be performed under the test environments conditions\n    and not for profit generation.\n 2. Provided that you purchased a license from \"INFIMA\" online store\n    (store address: https://mathparser.org/order-commercial-license or\n    https://payhip.com/infima), and you comply with all terms and\n    conditions below, and you have acknowledged and understood the\n    following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive\n    license with the following rights:\n 3. The license is granted only to you, the person or entity that made\n    the purchase, identified and confirmed by the data provided during\n    the purchase.\n 4. If you purchased a license in the \"ONE-TIME PURCHASE\" model, the\n    license is granted only for the PRODUCT version specified in the\n    purchase. The upgrade policy gives you additional rights, described\n    in the dedicated section below.\n 5. If you purchased a license in the \"SUBSCRIPTION\" model, you may\n    install and use any version of the PRODUCT during the subscription\n    validity period.\n 6. If you purchased a \"SINGLE LICENSE\" you may install and use the\n    PRODUCT on/from one workstation that is located/accessible at/from\n    any of your premises.\n 7. Additional copies of the PRODUCT may be installed and used on/from\n    more than one workstation, limited to the number of workstations\n    purchased per order.\n 8. If you purchased a \"SITE LICENSE\", the PRODUCT may be installed\n    and used on/from all workstations located/accessible at/from any\n    of your premises.\n 9. You may incorporate the unmodified PRODUCT into your own products\n    and software.\n10. If you purchased a license with the \"SOURCE CODE\" option, you may\n    modify the PRODUCT's source code and incorporate the modified source\n    code into your own products and/or software.\n11. Provided that the license validity period has not expired, you may\n    distribute your product and/or software with the incorporated\n    PRODUCT royalty-free.\n12. You may make copies of the PRODUCT for backup and archival purposes.\n13. Any form of redistribution requires confirmation and signature of\n    the COMMERCIAL USE by successfully calling the method:\n       License.iConfirmCommercialUse(...)\n    The method call is used only internally for logging purposes, and\n    there is no connection with other external services, and no data is\n    sent or collected. The lack of a method call (or its successful call)\n    does not affect the operation of the PRODUCT in any way. Please see\n    the API documentation.\n14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to\n    you in this agreement.\n\nADDITIONAL CLARIFICATION ON WORKSTATION\n\nA workstation is a device, a remote device, or a virtual device, used by\nyou, your employees, or other entities to whom you have commissioned\ntasks. For example, the number of workstations may refer to the number\nof software developers, engineers, architects, scientists, and other\nprofessionals who use the PRODUCT on your behalf. The number of\nworkstations is not the number of copies of your end-product that you\ndistribute to your end-users.\n\nBy purchasing the COMMERCIAL LICENSE, you only pay for the number of\nworkstations, while the number of copies/users of your final product\n(delivered to your end-users) is not limited.\n\nBelow are some examples to help you select the right license size:\n\nExample 1: Single Workstation License\nOnly one developer works on the development of your application. You do\nnot use separate environments for testing, meaning you design, create,\ntest, and compile your final application on one environment. In this\ncase, you need a license for a single workstation.\n\nExample 2: Up to 5 Workstations License\nTwo developers are working on the development of your application.\nAdditionally, one tester conducts tests in a separate environment.\nYou use three workstations in total, so you need a license for up to\nfive workstations.\n\nExample 3: Up to 20 Workstations License\nTen developers are working on the development of your application.\nAdditionally, five testers conduct tests in separate environments.\nYou use fifteen workstations in total, so you need a license for\nup to twenty workstations.\n\nExample 4: Site License\nSeveral dozen developers and testers work on the development of your\napplication using multiple environments. You have a large,\nmulti-disciplinary team involved in creating your solution. As your team\nis growing and you want to avoid licensing limitations, the best choice\nwould be a site license.\n\nUPGRADE POLICY\n\nThe PRODUCT is versioned according to the following convention:\n\n   [MAJOR].[MINOR].[PATCH]\n\n1. COMMERCIAL LICENSE holders can install and use the updated version\n   for bug fixes free of charge, i.e. if you have purchased a license\n   for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install\n   all releases specified in the [PATCH] version (e.g., 5.0.2).\n   The license terms remain unchanged after the update.\n2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)\n   can install and use the updated version [MAJOR].[MINOR + 1] free of\n   charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The\n   license terms remain unchanged after the update.\n3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are\n   not eligible for the free upgrade, can claim a discount when\n   purchasing the upgrade. For this purpose, please contact us via e-mail.\n\nDISCLAIMER\n\nTHIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER \"AS IS\" AND ANY EXPRESS\nOR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE\nLIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\nSUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\nINTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\nCONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\nARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF\nTHE POSSIBILITY OF SUCH DAMAGE.\n\nTHE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE\nTHOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING\nOFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.\n\nCONTACT\n\n- e-mail: info@mathparser.org\n- website: https://mathparser.org\n- source code: https://github.com/mariuszgromada/MathParser.org-mXparser\n- online store: https://mathparser.org/order-commercial-license\n- online store: https://payhip.com/infima\n");
        mXparser.consolePrintln(Tutorial.highlight("Using help"));
        Expression e = new Expression(new PrimitiveElement[0]);
        mXparser.consolePrintln(e.getHelp());
        mXparser.consolePrintln(Tutorial.highlight("Full line searching"));
        mXparser.consolePrintln();
        mXparser.consolePrintln(e.getHelp("sine"));
        mXparser.consolePrintln();
        mXparser.consolePrintln(e.getHelp("inver"));
        mXparser.consolePrintln(Tutorial.highlight("Simple expression"));
        Expression e1 = new Expression("2+1", new PrimitiveElement[0]);
        mXparser.consolePrintln(e1.getExpressionString() + " = " + e1.calculate());
        e1.setExpressionString("2-1");
        mXparser.consolePrintln(e1.getExpressionString() + " = " + e1.calculate());
        mXparser.consolePrintln(Tutorial.highlight("operators"));
        Expression e2 = new Expression("2-(32-4)/(23+(4)/(5))-(2-4)*(4+6-98.2)+4", new PrimitiveElement[0]);
        mXparser.consolePrintln(e2.getExpressionString() + " = " + e2.calculate());
        mXparser.consolePrintln(Tutorial.highlight("power function"));
        Expression e3 = new Expression("2^3+2^(-3)+2^3^(-4)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e3.getExpressionString() + " = " + e3.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Relations"));
        Expression e4 = new Expression("2=3", new PrimitiveElement[0]);
        mXparser.consolePrintln(e4.getExpressionString() + " = " + e4.calculate());
        Expression e5 = new Expression("2<3", new PrimitiveElement[0]);
        mXparser.consolePrintln(e5.getExpressionString() + " = " + e5.calculate());
        Expression e6 = new Expression("(2=3) | (2<3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e6.getExpressionString() + " = " + e6.calculate());
        Expression e7 = new Expression("(2=3) & (2<3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e7.getExpressionString() + " = " + e7.calculate());
        mXparser.consolePrintln(Tutorial.highlight("1 arg functions"));
        Expression e8 = new Expression("sin(2)-cos(3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e8.getExpressionString() + " = " + e8.calculate());
        mXparser.consolePrintln(Tutorial.highlight("2 args functions"));
        Expression e9 = new Expression("min(3,4) + max(-2,-1)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e9.getExpressionString() + " = " + e9.calculate());
        mXparser.consolePrintln(Tutorial.highlight("binomial coefficient"));
        Expression e10 = new Expression("C(10,5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e10.getExpressionString() + " = " + e10.calculate());
        mXparser.consolePrintln(Tutorial.highlight("3 args function"));
        mXparser.consolePrintln(Tutorial.highlight("conditions"));
        Expression e11 = new Expression("if(2<3,1,0)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e11.getExpressionString() + " = " + e11.calculate());
        Expression e12 = new Expression("if(3<2,1,0)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e12.getExpressionString() + " = " + e12.calculate());
        Expression e13 = new Expression("if(3<2, 1, if(1=1, 5, 0) )", new PrimitiveElement[0]);
        mXparser.consolePrintln(e13.getExpressionString() + " = " + e13.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Free Arguments"));
        Argument x = new Argument("x = 1", new PrimitiveElement[0]);
        Argument y = new Argument("y = 2", new PrimitiveElement[0]);
        Argument z = new Argument("z", 3.0);
        Argument n = new Argument("n", 4.0);
        Expression e14 = new Expression("sin(x+y)-cos(y/z)", x, y, z);
        mXparser.consolePrintln(e14.getExpressionString() + " = " + e14.calculate());
        Expression e15 = new Expression("if(x>y, x-z, if(y<z, sin(x+y), cos(z)) )", x, y, z);
        mXparser.consolePrintln(e15.getExpressionString() + " = " + e15.calculate());
        x.setArgumentValue(5.0);
        mXparser.consolePrintln(x.getArgumentName() + " = " + x.getArgumentValue());
        mXparser.consolePrintln(Tutorial.highlight("Dependent arguments"));
        y = new Argument("y", "2*x+5", x);
        mXparser.consolePrintln(y.getArgumentName() + " = " + y.getArgumentValue());
        y = new Argument("y = 2*x+5", x);
        mXparser.consolePrintln(y.getArgumentName() + " = " + y.getArgumentValue());
        y = new Argument("y", "sin(y)-z", y, z);
        mXparser.consolePrintln(y.getArgumentName() + " = " + y.getArgumentValue());
        mXparser.consolePrintln(Tutorial.highlight("syntax checking"));
        y.setArgumentExpressionString("n*sin(y)-z");
        mXparser.consolePrintln(y.getArgumentName() + " = ... \n syntax = " + y.checkSyntax() + "\n message = \n" + y.getErrorMessage());
        y.addDefinitions(n);
        mXparser.consolePrintln(y.getArgumentName() + " = ... \n syntax = " + y.checkSyntax() + "\n message = \n" + y.getErrorMessage());
        mXparser.consolePrintln(y.getArgumentName() + " = " + y.getArgumentValue());
        mXparser.consolePrintln(Tutorial.highlight("Complex expressions"));
        mXparser.consolePrintln(Tutorial.highlight("Summation operator SIGMA"));
        Expression e16 = new Expression("sum(i, 1, 10, i)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e16.getExpressionString() + " = " + e16.calculate());
        Expression e17 = new Expression("sum(i, 1, 10, 2*i, 0.5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e17.getExpressionString() + " = " + e17.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Product operator PI PROD"));
        mXparser.consolePrintln(Tutorial.highlight("factorial"));
        Expression e18 = new Expression("prod(i, 1, 5, i)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e18.getExpressionString() + " = " + e18.calculate());
        Expression e19 = new Expression("prod(i, 1, 5, 2*i, 0.5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e19.getExpressionString() + " = " + e19.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Approximation sin(x) by Taylor series"));
        Expression e20 = new Expression("sin(x)-sum(n,0,20,(-1)^n*(x^(2*n+1))/(2*n+1)!)", x);
        x.setArgumentValue(1.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e20.getExpressionString() + " = " + e20.calculate());
        x.setArgumentValue(5.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e20.getExpressionString() + " = " + e20.calculate());
        x.setArgumentValue(10.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e20.getExpressionString() + " = " + e20.calculate());
        mXparser.consolePrintln(Tutorial.highlight("calculating pi by integral"));
        Argument d = new Argument("d", 0.1);
        Expression e21 = new Expression("2*sum(x, -1, 1, d*sqrt(1-x^2), d)", d);
        mXparser.consolePrintln("d = " + d.getArgumentValue() + ", " + e21.getExpressionString() + " = " + e21.calculate());
        d.setArgumentValue(0.01);
        mXparser.consolePrintln("d = " + d.getArgumentValue() + ", " + e21.getExpressionString() + " = " + e21.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Derivatives"));
        mXparser.consolePrintln(Tutorial.highlight("cos(x) as derivative from sin(x)"));
        Expression e22 = new Expression("cos(x)-der(sin(x), x)", x);
        mXparser.consolePrintln(e22.getExpressionString() + " = " + e22.calculate());
        mXparser.consolePrintln(Tutorial.highlight("left and right derivative from |x|"));
        x.setArgumentValue(0.0);
        Expression e23 = new Expression("der-(abs(x), x)", x);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e23.getExpressionString() + " = " + e23.calculate());
        Expression e24 = new Expression("der+(abs(x), x)", x);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e24.getExpressionString() + " = " + e24.calculate());
        mXparser.consolePrintln(Tutorial.highlight("derivative from sin(x) as Taylor series (approximation)"));
        x.setArgumentValue(1.0);
        Expression e25 = new Expression("cos(x)-der(sum(n,0,20,(-1)^n*(x^(2*n+1))/(2*n+1)!), x)", x);
        x.setArgumentValue(1.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e25.getExpressionString() + " = " + e25.calculate());
        x.setArgumentValue(5.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e25.getExpressionString() + " = " + e25.calculate());
        x.setArgumentValue(10.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e25.getExpressionString() + " = " + e25.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Integral"));
        mXparser.consolePrintln(Tutorial.highlight("calculating PI value"));
        Expression e26 = new Expression("2 * int(sqrt(1-x^2), x, -1, 1)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e26.getExpressionString() + " = " + e26.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Parser constants"));
        Expression e27 = new Expression("pi", new PrimitiveElement[0]);
        mXparser.consolePrintln(e27.getExpressionString() + " = " + e27.calculate());
        Expression e28 = new Expression("e", new PrimitiveElement[0]);
        mXparser.consolePrintln(e28.getExpressionString() + " = " + e28.calculate());
        mXparser.consolePrintln(Tutorial.highlight("USER DEFINED FUNCTIONS"));
        Function f = new Function("f", "x^2", "x");
        Expression e29 = new Expression("f(2)", new PrimitiveElement[0]);
        e29.addDefinitions(f);
        mXparser.consolePrintln(e29.getExpressionString() + " = " + e29.calculate());
        f = new Function("f(a,b,c) = a + b + c", new PrimitiveElement[0]);
        Expression e30 = new Expression("f(1, 2, 3)", new PrimitiveElement[0]);
        e30.addDefinitions(f);
        mXparser.consolePrintln(e30.getExpressionString() + " = " + e30.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Using functions in functions"));
        f = new Function("f", "x^2", "x");
        Function g = new Function("g", "f(x)^2", "x");
        g.addDefinitions(f);
        mXparser.consolePrintln("g(2) = " + g.calculate(2.0));
        Expression e31 = new Expression("f(x)+g(2*x)", x);
        e31.addDefinitions(f, g);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e31.getExpressionString() + " = " + e31.calculate());
        x.setArgumentValue(2.0);
        Expression e32 = new Expression("der(g(x),x)", x);
        e32.addDefinitions(g);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e32.getExpressionString() + " = " + e32.calculate());
        mXparser.consolePrintln(Tutorial.highlight("Fundamental theorem of calculus"));
        f = new Function("f", "sin(x)", "x");
        Function F = new Function("F", "int(f(t), t, 0, x)", "x");
        F.addDefinitions(f);
        Expression e33 = new Expression("f(x) - der(F(x),x)", x);
        e33.addDefinitions(f, F);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e33.getExpressionString() + " = " + e33.calculate() + ", computing time : " + e33.getComputingTime() + " s.");
        mXparser.consolePrintln(Tutorial.highlight("Simple (fast) recursion"));
        mXparser.consolePrintln(Tutorial.highlight("Fibonacci numbers with add base cases method"));
        n = new Argument("n", new PrimitiveElement[0]);
        RecursiveArgument fib1 = new RecursiveArgument("fib1", "fib1(n-1)+fib1(n-2)", n, new PrimitiveElement[0]);
        fib1.addBaseCase(0, 0.0);
        fib1.addBaseCase(1, 1.0);
        mXparser.consolePrintln("fib1: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(fib1.getArgumentValue(i) + ", ");
        }
        mXparser.consolePrintln();
        mXparser.consolePrintln(Tutorial.highlight("Fibonacci numbers with if statement"));
        RecursiveArgument fib2 = new RecursiveArgument("fib2(n) = if( n>1, fib2(n-1)+fib2(n-2), if(n=1,1,0) )", new PrimitiveElement[0]);
        mXparser.consolePrintln("fib2: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(fib2.getArgumentValue(i) + ", ");
        }
        mXparser.consolePrintln();
        Expression e34 = new Expression("sum(i, 0, 10, fib1(i))", fib1);
        mXparser.consolePrintln(e34.getExpressionString() + " = " + e34.calculate() + ", computing time : " + e34.getComputingTime() + " s.");
        Expression e35 = new Expression("sum(i, 0, 10, fib2(i))", fib2);
        mXparser.consolePrintln(e35.getExpressionString() + " = " + e35.calculate() + ", computing time : " + e35.getComputingTime() + " s.");
        mXparser.consolePrintln(Tutorial.highlight("Complex recursion "));
        mXparser.consolePrintln(Tutorial.highlight("Fibonacci numbers using complex recursion"));
        Function fib3 = new Function("fib3", "if(n>1, fib3(n-1)+fib3(n-2), if(n>0,1,0))", "n");
        mXparser.consolePrintln("fib2: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(fib3.calculate(i) + ", ");
        }
        mXparser.consolePrintln();
        Expression e36 = new Expression("sum(i, 0, 10, fib3(i))", new PrimitiveElement[0]);
        e36.addDefinitions(fib3);
        mXparser.consolePrintln(e36.getExpressionString() + " = " + e36.calculate() + ", computing time : " + e36.getComputingTime() + " s.");
        mXparser.consolePrintln(Tutorial.highlight("Chebyshev polynomials definition using"));
        Function T = new Function("T(n,x) = if(n>1, 2*x*T(n-1,x)-T(n-2,x), if(n>0, x, 1) )", new PrimitiveElement[0]);
        Argument k = new Argument("k", 5.0);
        Expression e37 = new Expression("T(k,x) - ( (x + sqrt(x^2-1))^k + (x - sqrt(x^2-1))^k)/2", k, x);
        e37.addDefinitions(T);
        mXparser.consolePrintln(e37.getExpressionString() + " = " + e37.calculate() + ", computing time : " + e37.getComputingTime() + " s.");
        mXparser.consolePrintln(Tutorial.highlight("Binomial coefficient using complex recursion"));
        Function Cnk = new Function("Cnk", "if( k>0, if( k<n, Cnk(n-1,k-1)+Cnk(n-1,k), 1), 1)", "n", "k");
        Expression e38 = new Expression("C(10,5) - Cnk(10,5)", new PrimitiveElement[0]);
        e38.addDefinitions(Cnk);
        mXparser.consolePrintln(e38.getExpressionString() + " = " + e38.calculate() + ", computing time : " + e38.getComputingTime() + " s.");
        mXparser.consolePrintln(Tutorial.highlight("User defined constants"));
        Constant a = new Constant("a", 5.0);
        Constant b = new Constant("b = 10", new PrimitiveElement[0]);
        Constant c = new Constant("c = a + b", a, b);
        Expression e39 = new Expression("a+b+c", new PrimitiveElement[0]);
        e39.addDefinitions(a, b, c);
        mXparser.consolePrintln(Tutorial.highlight("verbose mode"));
        e39.setVerboseMode();
        e39.checkSyntax();
        mXparser.consolePrintln();
        mXparser.consolePrintln(e39.getErrorMessage());
        mXparser.consolePrintln(e39.getExpressionString() + " = " + e39.calculate() + ", computing time : " + e39.getComputingTime() + " s.");
    }
}

