/*
 * @(#)StringResourcesGerman.java        6.1.0    2024-10-06
 *
 * MathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19
 * The most up-to-date license is available at the below link:
 * - https://mathparser.org/mxparser-license
 *
 * AUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved
 * PUBLISHER: INFIMA - https://payhip.com/infima
 *
 * SOFTWARE means source code and/or binary form and/or documentation.
 * PRODUCT: MathParser.org-mXparser SOFTWARE
 * LICENSE: DUAL LICENSE AGREEMENT
 *
 * BY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE
 * BOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.
 *
 * The AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT
 * model designed to meet the needs of both non-commercial use and commercial
 * use.
 *
 * NON-COMMERCIAL USE means any use or activity where a fee is not charged
 * and the purpose is not the sale of a good or service, and the use or
 * activity is not intended to produce a profit. Examples of NON-COMMERCIAL USE
 * include:
 *
 * 1. Non-commercial open-source software.
 * 2. Non-commercial mobile applications.
 * 3. Non-commercial desktop software.
 * 4. Non-commercial web applications/solutions.
 * 5. Non-commercial use in research, scholarly and educational context.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * COMMERCIAL USE means any use or activity where a fee is charged or the
 * purpose is the sale of a good or service, or the use or activity is
 * intended to produce a profit. COMMERCIAL USE examples:
 *
 * 1. OEMs (Original Equipment Manufacturers).
 * 2. ISVs (Independent Software Vendors).
 * 3. VARs (Value Added Resellers).
 * 4. Other distributors that combine and distribute commercially licensed
 *    software.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * IN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE
 * APPROPRIATE LICENSE FROM "INFIMA" ONLINE STORE, STORE ADDRESS:
 *
 * 1. https://mathparser.org/order-commercial-license
 * 2. https://payhip.com/infima
 *
 * NON-COMMERCIAL LICENSE
 *
 * Redistribution and use of the PRODUCT in source and/or binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the unmodified content of
 *    the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including
 *    the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,
 *    the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 2. Redistributions in binary form must reproduce the entire content of
 *    MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation
 *    and/or other materials provided with the distribution, including the
 *    definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the
 *    NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 3. Any form of redistribution requires confirmation and signature of
 *    the NON-COMMERCIAL USE by successfully calling the method:
 *       License.iConfirmNonCommercialUse(...)
 *    The method call is used only internally for logging purposes, and
 *    there is no connection with other external services, and no data is
 *    sent or collected. The lack of a method call (or its successful call)
 *    does not affect the operation of the PRODUCT in any way. Please see
 *    the API documentation.
 *
 * COMMERCIAL LICENSE
 *
 *  1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow
 *     you to download, install, and use up to three copies of the PRODUCT to
 *     perform integration tests, confirm the quality of the PRODUCT, and
 *     its suitability. The testing period should be limited to fourteen
 *     days. Tests should be performed under the test environments conditions
 *     and not for profit generation.
 *  2. Provided that you purchased a license from "INFIMA" online store
 *     (store address: https://mathparser.org/order-commercial-license or
 *     https://payhip.com/infima), and you comply with all terms and
 *     conditions below, and you have acknowledged and understood the
 *     following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive
 *     license with the following rights:
 *  3. The license is granted only to you, the person or entity that made
 *     the purchase, identified and confirmed by the data provided during
 *     the purchase.
 *  4. If you purchased a license in the "ONE-TIME PURCHASE" model, the
 *     license is granted only for the PRODUCT version specified in the
 *     purchase. The upgrade policy gives you additional rights, described
 *     in the dedicated section below.
 *  5. If you purchased a license in the "SUBSCRIPTION" model, you may
 *     install and use any version of the PRODUCT during the subscription
 *     validity period.
 *  6. If you purchased a "SINGLE LICENSE" you may install and use the
 *     PRODUCT on/from one workstation that is located/accessible at/from
 *     any of your premises.
 *  7. Additional copies of the PRODUCT may be installed and used on/from
 *     more than one workstation, limited to the number of workstations
 *     purchased per order.
 *  8. If you purchased a "SITE LICENSE", the PRODUCT may be installed
 *     and used on/from all workstations located/accessible at/from any
 *     of your premises.
 *  9. You may incorporate the unmodified PRODUCT into your own products
 *     and software.
 * 10. If you purchased a license with the "SOURCE CODE" option, you may
 *     modify the PRODUCT's source code and incorporate the modified source
 *     code into your own products and/or software.
 * 11. Provided that the license validity period has not expired, you may
 *     distribute your product and/or software with the incorporated
 *     PRODUCT royalty-free.
 * 12. You may make copies of the PRODUCT for backup and archival purposes.
 * 13. Any form of redistribution requires confirmation and signature of
 *     the COMMERCIAL USE by successfully calling the method:
 *        License.iConfirmCommercialUse(...)
 *     The method call is used only internally for logging purposes, and
 *     there is no connection with other external services, and no data is
 *     sent or collected. The lack of a method call (or its successful call)
 *     does not affect the operation of the PRODUCT in any way. Please see
 *     the API documentation.
 * 14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to
 *     you in this agreement.
 *
 * ADDITIONAL CLARIFICATION ON WORKSTATION
 *
 * A workstation is a device, a remote device, or a virtual device, used by
 * you, your employees, or other entities to whom you have commissioned
 * tasks. For example, the number of workstations may refer to the number
 * of software developers, engineers, architects, scientists, and other
 * professionals who use the PRODUCT on your behalf. The number of
 * workstations is not the number of copies of your end-product that you
 * distribute to your end-users.
 *
 * By purchasing the COMMERCIAL LICENSE, you only pay for the number of
 * workstations, while the number of copies/users of your final product
 * (delivered to your end-users) is not limited.
 *
 * Below are some examples to help you select the right license size:
 *
 * Example 1: Single Workstation License
 * Only one developer works on the development of your application. You do
 * not use separate environments for testing, meaning you design, create,
 * test, and compile your final application on one environment. In this
 * case, you need a license for a single workstation.
 *
 * Example 2: Up to 5 Workstations License
 * Two developers are working on the development of your application.
 * Additionally, one tester conducts tests in a separate environment.
 * You use three workstations in total, so you need a license for up to
 * five workstations.
 *
 * Example 3: Up to 20 Workstations License
 * Ten developers are working on the development of your application.
 * Additionally, five testers conduct tests in separate environments.
 * You use fifteen workstations in total, so you need a license for
 * up to twenty workstations.
 *
 * Example 4: Site License
 * Several dozen developers and testers work on the development of your
 * application using multiple environments. You have a large,
 * multi-disciplinary team involved in creating your solution. As your team
 * is growing and you want to avoid licensing limitations, the best choice
 * would be a site license.
 *
 * UPGRADE POLICY
 *
 * The PRODUCT is versioned according to the following convention:
 *
 *    [MAJOR].[MINOR].[PATCH]
 *
 * 1. COMMERCIAL LICENSE holders can install and use the updated version
 *    for bug fixes free of charge, i.e. if you have purchased a license
 *    for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install
 *    all releases specified in the [PATCH] version (e.g., 5.0.2).
 *    The license terms remain unchanged after the update.
 * 2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)
 *    can install and use the updated version [MAJOR].[MINOR + 1] free of
 *    charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The
 *    license terms remain unchanged after the update.
 * 3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are
 *    not eligible for the free upgrade, can claim a discount when
 *    purchasing the upgrade. For this purpose, please contact us via e-mail.
 *
 * DISCLAIMER
 *
 * THIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE
 * THOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING
 * OFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.
 *
 * CONTACT
 *
 * - e-mail: info@mathparser.org
 * - website: https://mathparser.org
 * - source code: https://github.com/mariuszgromada/MathParser.org-mXparser
 * - online store: https://mathparser.org/order-commercial-license
 * - online store: https://payhip.com/infima
 */
package org.mariuszgromada.math.mxparser;

/**
 * A class containing definition of German user language
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="https://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="https://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser on GitHub</a><br>
 *                 <a href="https://payhip.com/INFIMA" target="_blank">INFIMA place to purchase a commercial MathParser.org-mXparser software license</a><br>
 *                 <a href="mailto:info@mathparser.org">info@mathparser.org</a><br>
 *                 <a href="https://scalarmath.org/" target="_blank">ScalarMath.org - a powerful math engine and math scripting language</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.lite" target="_blank">Scalar Lite</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.pro" target="_blank">Scalar Pro</a><br>
 *                 <a href="https://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *
 * @version        6.0.0
 *
 * @see StringResources
 * @see StringModel
 * @see StringModel#setStringResources(StringResources)
 * @see StringModel#getStringResources()
 */
class StringResourcesGerman extends StringResources{
    StringResourcesGerman() {
        USER_LANGUAGE = "Deutsch";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK = "Starte Syntaxprüfung...";
        NO_ERRORS_DETECTED = "Es wurden keine Fehler gefunden.";
        NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = "Es wurden keine Fehler in der Argumentdefinition gefunden.";
        NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = "Es wurden keine Fehler in der rekursiven Argumentdefinition gefunden.";
        NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = "Es wurden keine Fehler in der Funktionsdefinition gefunden.";
        NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = "Es wurden keine Fehler in der Konstantendefinition gefunden.";
        LEXICAL_ERROR_HAS_BEEN_FOUND = "Ein lexikaler Fehler wurde gefunden.";
        ERRORS_HAVE_BEEN_FOUND = "Es wurden Fehler gefunden.";
        ALREADY_CHECKED_NO_ERRORS = "Die Syntax wurde bereits überprüft - es wurden keine Fehler gefunden.";
        SYNTAX_STATUS_UNKNOWN = "Der Syntaxstatus ist unbekannt.";
        PROBLEM_WITH_EXPRESSION_SYNTAX = "Es gibt ein Problem mit der Ausdruckssyntax.";
        // -------------------------------------------------
        ENCOUNTERED = "Angetroffen";
        AT_INDEX = "an Position";
        WAS_EXPECTING = "Erwartet wurde";
        WAS_EXPECTING_ONE_OF = "Erwartet wurde eines der folgenden";
        UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = "Es wurde eine unerwartete Ausnahme gefunden. Möglicherweise ein Parserfehler - bitte melden Sie diesen.";
        UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = "Es wurde ein unerwarteter Token-Manager-Fehler gefunden. Möglicherweise ein Parserfehler - bitte melden Sie diesen.";
        // -------------------------------------------------
        EXPRESSION_STRING_IS_EMPTY = "Der Ausdrucksstring ist leer.";
        EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = "Der Ausdruck enthält keine Token.";
        DUPLICATED_KEYWORD = "Doppelte Schlüsselwörter gefunden. Überprüfen Sie benutzerdefinierte Elemente und erwägen Sie die Option, eingebaute Tokens zu überschreiben.";
        ELEMENT = "Element";
        ERROR = "Fehler";
        EXCEPTION = "Ausnahme";
        TOKEN = "Token";
        INDEX = "Index";
        INVALID_TOKEN = "Ungültiges Token.";
        INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = "Ungültiges Token. Möglicherweise fehlt der Multiplikationsoperator - versuchen Sie den impliziten Multiplikationsmodus.";
        EXPRESSION_TOKENS = "Ausdruckstokens";
        NULL_TOKENS_LIST = "Leere Token-Liste";
        // -------------------------------------------------
        FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = "Benutzerdefinierte Funktion mit erweitertem Körper - keine Fehler nach Annahme.";
        ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = "Benutzerdefiniertes Argument mit erweitertem Körper - keine Fehler nach Annahme.";
        PROVIDED_EXTENSION_IS_NULL = "Die bereitgestellte Erweiterung ist null.";
        PROVIDED_STRING_IS_NULL = "Der bereitgestellte String ist null.";
        PROVIDED_ELEMENTS_ARE_NULL = "Die bereitgestellten Elemente sind null.";
        MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = "Möglicherweise fehlt der Multiplikationsoperator - versuchen Sie den impliziten Multiplikationsmodus.";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = "Syntaxprüfung des abhängigen benutzerdefinierten Arguments wird gestartet.";
        STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = "Syntaxprüfung des benutzerdefinierten rekursiven Arguments wird gestartet.";
        STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = "Syntaxprüfung der benutzerdefinierten Funktion wird gestartet.";
        STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = "Syntaxprüfung der benutzerdefinierten variadischen Funktion wird gestartet.";
        // -------------------------------------------------
        ARGUMENT_WAS_EXPECTED = "Es wurde ein benutzerdefiniertes Argument erwartet.";
        RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = "Ein rekursives benutzerdefiniertes Argument erfordert einen Parameter.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = "Falsche Anzahl von Parametern in benutzerdefinierter Funktion.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = "Falsche Anzahl von Funktionsparametern.";
        EXPECTED = "Erwartet wurde";
        PROVIDED = "Bereitgestellt";
        USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = "Falsche Anzahl von Parametern in benutzerdefinierter Funktion - mindestens ein Argument wird erwartet.";
        EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = "Gerade Anzahl von Argumenten wurde erwartet.";
        // -------------------------------------------------
        INVALID_FUNCTION_NAME = "Ungültiger Funktionsname.";
        INVALID_ARGUMENT_NAME = "Ungültiger Argumentname.";
        INVALID_CONSTANT_NAME = "Ungültiger Konstantenname.";
        INVALID_FUNCTION_DEFINITION = "Ungültige Funktionsdefinition.";
        INVALID_ARGUMENT_DEFINITION = "Ungültige Argumentdefinition.";
        INVALID_CONSTANT_DEFINITION = "Ungültige Konstantendefinition.";
        PATTERN_DOES_NOT_MATCH = "Das Muster stimmt nicht überein.";
        PATTERN_EXAMPLES = "Musterbeispiele";
        // -------------------------------------------------
        CONSTANT_WAS_EXPECTED = "Konstantenwert wurde erwartet.";
        USER_CONSTANT_WAS_EXPECTED = "Benutzerdefinierte Konstante wurde erwartet.";
        // -------------------------------------------------
        UNARY_FUNCTION_EXPECTS_1_PARAMETER = "Eine unäre Funktion erwartet 1 Parameter.";
        BINARY_FUNCTION_EXPECTS_2_PARAMETERS = "Eine binäre Funktion erwartet 2 Parameter.";
        TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = "Eine ternäre Funktion erwartet 3 Parameter.";
        // -------------------------------------------------
        DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = "Der Ableitungsoperator erwartet 2, 3, 4 oder 5 Kalkulationsparameter.";
        ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = "In einem Aufruf des Ableitungsoperators wurde ein Argument erwartet.";
        DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Doppelte Schlüsselwörter wurden im Aufruf des Kalkulationsoperators gefunden. Überprüfen Sie die Kalkulationsparameter.";
        ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Es wurde ein Token (Argument oder unbekannt) im Aufruf des Kalkulationsoperators erwartet.";
        NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = "Der Ableitungsoperator N-ter Ordnung erwartet 3 oder 5 Kalkulationsparameter.";
        INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = "Der Integral-/Lösungsoperator erwartet 4 Kalkulationsparameter.";
        ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = "Der iterierte Operator erwartet 4 oder 5 Kalkulationsparameter.";
        FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = "Der Vorwärts-/Rückwärtsdifferenzoperator erwartet 2 oder 3 Kalkulationsparameter.";
        FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = "In einem Aufruf des Vorwärts-/Rückwärtsdifferenzoperators wurde ein Argument erwartet.";
        AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = "Mindestens ein Argument wurde erwartet.";
        // -------------------------------------------------
        ERROR_WHILE_EXECUTING_THE_CALCULATE = "Fehler beim Ausführen der Berechnung.";
        RECURSION_CALLS_COUNTER_EXCEEDED = "Die Anzahl der Rekursionsaufrufe wurde überschritten.";
        RECURSION_CALLS_COUNTER = "Rekursionsaufrufzähler";
        STARTING_CALCULATION_LOOP = "Starte Berechnungsschleife.";
        CANCEL_REQUEST_FINISHING = "Abbruchanforderung erkannt - Beendigung.";
        INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = "Interner Fehler / seltsame Token-Ebene - Beendigung. Möglicherweise ein Parserfehler - bitte melden.";
        FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = "Schwerwiegender Fehler. Es ist nicht bekannt, was mit dem gefundenen Token zu tun ist. Möglicherweise ein Parserfehler - bitte melden.";
        MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = "Die maximale Länge der Fehlermeldung wurde überschritten.";
        // -------------------------------------------------
        STARTING = "Starte...";
        PARSING = "Parsing";
        FULLY_COMPILED = "Vollständig kompiliert";
        CALCULATED_VALUE = "Berechneter Wert";
        EXITING = "Beenden.";
        DONE = "abgeschlossen.";
        // -------------------------------------------------
        KEYWORD = "Schlüsselwort";
        SYNTAX = "Syntax";
        NUMBER = "Zahl";
        NUMBER_LITERAL = "Zahlenliteral";
        TYPE = "Typ";
        SINCE = "Seit";
        DESCRIPTION = "Beschreibung";
        // -------------------------------------------------
        CALC_STEPS_REGISTER_IS_EMPTY = "CalcStepsRegister ist leer.";
        CALC_STEPS_REGISTER_FOR = "CalcStepsRegister für";
        ARGUMENT = "Argument";
        FUNCTION = "Funktion";
        EXPRESSION = "Ausdruck";
        RESULT = "Ergebnis";
        COMPUTING_TIME = "Berechnungszeit";
        GROUP_SHORT = "Gruppe";
        NUMBER_SHORT = "Nr.";
        FIRST = "erste";
        LAST = "letzte";
        DESCRIPTION_SHORT = "Beschr.";
        STEP = "Schritt";
        // -------------------------------------------------
        SERIALIZATION_PERFORMED = "Serialisierung wurde durchgeführt:";
        DESERIALIZATION_PERFORMED = "Deserialisierung wurde durchgeführt:";
        NULL_OBJECT_PROVIDED = "Null-Objekt wurde übergeben.";
        NULL_FILE_PATH_PROVIDED = "Null-Dateipfad wurde übergeben.";
        FILE_PATH_ZERO_LENGTH_PROVIDED = "Der Dateipfad enthält keine Zeichen.";
        FILE_PATH_IS_NOT_A_FILE = "Der Dateipfad ist keine Datei:";
        FILE_PATH_NOT_EXISTS = "Der Dateipfad existiert nicht:";
        NULL_DATA_PROVIDED = "Null-Daten wurden übergeben.";
        BINARY_SERIALIZATION_ENABLED = "Die binäre Serialisierung ist aktiviert. Verwenden Sie sie nur bewusst und begrenzt.";
        BINARY_SERIALIZATION_DISABLED = "Die binäre Serialisierung ist deaktiviert. Sie können sie aktivieren, wenn Sie sich der Sicherheitsrisiken bewusst sind.";
        // -------------------------------------------------
        USER_DEFINED_EXPRESSION = "Benutzerdefinierter Ausdruck";
        USER_DEFINED_ARGUMENT = "Benutzerdefiniertes Argument";
        USER_DEFINED_CONSTANT = "Benutzerdefinierte Konstante";
        USER_DEFINED_FUNCTION = "Benutzerdefinierte Funktion";
        USER_DEFINED_RECURSIVE_ARGUMENT = "Benutzerdefiniertes rekursives Argument";
        // -------------------------------------------------
        HELP_CONTENT_LIMITED_TO_QUERY = "Hilfeinhalt auf die Abfrage beschränkt";
        ALL_HELP_CONTENT = "Alle Hilfeinhalte.";
        CAPTION = "Beschriftung";
        // -------------------------------------------------
        WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "SICHERHEITSWARNUNG:" + StringInvariant.NEW_LINE
                + "Das Deserialisieren von Daten aus einer nicht vertrauenswürdigen Quelle kann" + StringInvariant.NEW_LINE
                + "Sicherheitslücken in Ihrer Anwendung einführen. Je nach den Einstellungen," + StringInvariant.NEW_LINE
                + "die beim Deserialisieren verwendet werden, können nicht vertrauenswürdige Daten" + StringInvariant.NEW_LINE
                + "beliebigen Code ausführen oder einen Denial-of-Service-Angriff verursachen." + StringInvariant.NEW_LINE
                + "Nicht vertrauenswürdige Daten können aus dem Netzwerk von einer nicht" + StringInvariant.NEW_LINE
                + "vertrauenswürdigen Quelle stammen (z.B. von jedem Netzwerkklienten), oder sie" + StringInvariant.NEW_LINE
                + "können von einem Zwischenhändler während der Übertragung über eine nicht" + StringInvariant.NEW_LINE
                + "authentifizierte Verbindung manipuliert/gefälscht werden, oder aus einem lokalen" + StringInvariant.NEW_LINE
                + "Speicher, in dem sie möglicherweise kompromittiert/gefälscht wurden, oder aus" + StringInvariant.NEW_LINE
                + "vielen anderen Quellen. MathParser.org-mXparser bietet keine Mittel zur" + StringInvariant.NEW_LINE
                + "Datenauthentifizierung oder zum Schutz vor Fälschungen. Verwenden Sie eine" + StringInvariant.NEW_LINE
                + "geeignete Methode zur Datenauthentifizierung vor dem Deserialisieren. Seien Sie" + StringInvariant.NEW_LINE
                + "sich dieser Angriffsszenarien sehr bewusst; viele Projekte und Unternehmen und" + StringInvariant.NEW_LINE
                + "Benutzer von Serialisierungsbibliotheken im Allgemeinen sind in der Vergangenheit" + StringInvariant.NEW_LINE
                + "durch das nicht vertrauenswürdige Deserialisieren von Benutzerdaten in die Falle getappt." + StringInvariant.NEW_LINE
        ;
        // -------------------------------------------------
        BINARY_RELATION = "Binäre Beziehung";
        BITWISE_OPERATOR = "Bitweiser Operator";
        BOOLEAN_OPERATOR = "Boolescher Operator";
        CALCULUS_OPERATOR = "Kalkulationsoperator";
        CONSTANT_VALUE = "Konstanter Wert";
        FUNCTION_1_ARG = "Unäre Funktion";
        FUNCTION_2_ARG = "Binäre Funktion";
        FUNCTION_3_ARG = "Ternäre Funktion";
        FUNCTION_VARIADIC = "Variadische Funktion";
        OPERATOR = "Operator";
        PARSER_SYMBOL = "Parser-Symbol";
        RANDOM_VARIABLE = "Zufallsvariable";
        UNIT = "Einheit";
        DIMENSIONLESS_UNIT = "Dimensionslose Einheit";
        ITERATED_OPERATOR = "Iterierter Operator";
        // -------------------------------------------------
        RATIO_FRACTION = "Verhältnis / Bruch";
        METRIC_PREFIX = "Metrisches Präfix";
        UNIT_OF_LENGTH = "Längeneinheit";
        UNIT_OF_AREA = "Flächeneinheit";
        UNIT_OF_VOLUME = "Volumeneinheit";
        UNIT_OF_TIME = "Zeiteinheit";
        UNIT_OF_MASS = "Masseneinheit";
        UNIT_OF_INFORMATION = "Informationseinheit";
        UNIT_OF_ENERGY = "Energieeinheit";
        UNIT_OF_SPEED = "Geschwindigkeitseinheit";
        UNIT_OF_ACCELERATION = "Beschleunigungseinheit";
        UNIT_OF_ANGLE = "Winkelmass";
        // -------------------------------------------------
        PHYSICAL_CONSTANT = "Physikalische Konstante";
        ASTRONOMICAL_CONSTANT = "Astronomische Konstante";
        MATHEMATICAL_CONSTANT = "Mathematische Konstante";
        // -------------------------------------------------
        PROBABILITY_DISTRIBUTION_FUNCTION = "Wahrscheinlichkeitsverteilungsfunktion";
        CUMULATIVE_DISTRIBUTION_FUNCTION = "Kumulative Verteilungsfunktion";
        QUANTILE_FUNCTION = "Quantilfunktion (inverse kumulative Verteilungsfunktion)";
        // -------------------------------------------------
        STUDENTS_T_DISTRIBUTION = "Student'sche t-Verteilung";
        CHI_SQUARED_DISTRIBUTION = "Chi-Quadrat-Verteilung";
        SNEDECORS_F_DISTRIBUTION = "Snedecor's F-Verteilung (F-Verteilung oder F-Verhältnis, auch bekannt als Fisher-Snedecor-Verteilung)";
        UNIFORM_CONTINUOUS_DISTRIBUTION = "Gleichförmige kontinuierliche Verteilung";
        UNIFORM_DISCRETE_DISTRIBUTION = "Gleichförmige diskrete Verteilung";
        NORMAL_DISTRIBUTION = "Normalverteilung";
        // -------------------------------------------------
        RANDOM_INTEGER = "Zufällige Ganzzahl";
        RANDOM_NATURAL_NUMBER = "Zufällige natürliche Zahl";
        RANDOM_NATURAL_NUMBER_INCLUDING_0 = "Zufällige natürliche Zahl einschließlich 0";
        // -------------------------------------------------
        SPECIAL_FUNCTION = "Spezielle Funktion";
        // -------------------------------------------------
        SEMI_MAJOR_AXIS = "Halbe Hauptachse";
        // -------------------------------------------------
        BINARY_RELATION_EQ = "Gleichheit";
        BINARY_RELATION_NEQ = "Ungleichung";
        BINARY_RELATION_LT = "Kleiner als";
        BINARY_RELATION_GT = "Größer als";
        BINARY_RELATION_LEQ = "Kleiner oder gleich";
        BINARY_RELATION_GEQ = "Größer oder gleich";
        // -------------------------------------------------
        BITWISE_OPERATOR_COMPL = "Bitweise einstellige Komplementbildung (NOT)";
        BITWISE_OPERATOR_AND = "Bitweises Und (AND)";
        BITWISE_OPERATOR_XOR = "Bitweises exklusives Oder (XOR)";
        BITWISE_OPERATOR_OR = "Bitweises inklusives Oder (OR)";
        BITWISE_OPERATOR_LEFT_SHIFT = "Bitweise Signierter Linksverschiebung";
        BITWISE_OPERATOR_RIGHT_SHIFT = "Bitweise Signierter Rechtsverschiebung";
        BITWISE_OPERATOR_NAND = "Bitweises Nicht-Und (NAND)";
        BITWISE_OPERATOR_NOR = "Bitweises Nicht-Oder (NOR)";
        BITWISE_OPERATOR_XNOR = "Bitweises exklusives Nicht-Oder (XNOR)";
        // -------------------------------------------------
        BOOLEAN_OPERATOR_AND = "Logische Konjunktion";
        BOOLEAN_OPERATOR_OR = "Logische Disjunktion";
        BOOLEAN_OPERATOR_NEG = "Negation";
        BOOLEAN_OPERATOR_NAND = "NAND-Funktion";
        BOOLEAN_OPERATOR_NOR = "Logisches Nicht Oder (gemeinsame Verweigerung)";
        BOOLEAN_OPERATOR_XOR = "Exklusives Oder";
        BOOLEAN_OPERATOR_IMP = "Implikation";
        BOOLEAN_OPERATOR_CIMP = "Konverse Implikation";
        BOOLEAN_OPERATOR_NIMP = "Materiale Nichtimplikation";
        BOOLEAN_OPERATOR_CNIMP = "Konverse Nichtimplikation";
        BOOLEAN_OPERATOR_EQV = "Logische Äquivalenz";
        // -------------------------------------------------
        CALCULUS_OPERATOR_SUM = "Summation SIGMA";
        CALCULUS_OPERATOR_PROD = "Produkt PI";
        CALCULUS_OPERATOR_INT = "Bestimmtes Integral";
        CALCULUS_OPERATOR_DER = "Ableitung";
        CALCULUS_OPERATOR_DER_LEFT = "Linke Ableitung";
        CALCULUS_OPERATOR_DER_RIGHT = "Rechte Ableitung";
        CALCULUS_OPERATOR_DERN = "n-te Ableitung";
        CALCULUS_OPERATOR_FORW_DIFF = "Vorwärtsdifferenz";
        CALCULUS_OPERATOR_BACKW_DIFF = "Rückwärtsdifferenz";
        CALCULUS_OPERATOR_AVG = "Durchschnitt";
        CALCULUS_OPERATOR_VAR = "Bias-korrigierte Stichprobenvarianz";
        CALCULUS_OPERATOR_STD = "Bias-korrigierte Stichprobenstandardabweichung";
        CALCULUS_OPERATOR_MIN = "Minimalwert";
        CALCULUS_OPERATOR_MAX = "Maximalwert";
        CALCULUS_OPERATOR_SOLVE = "Gleichungslösung (Nullstellensuche)";
        // -------------------------------------------------
        CONSTANT_VALUE_PI = "Pi, Zahl von Archimedes oder Ludolph";
        CONSTANT_VALUE_EULER = "Zahl von Napier oder Euler (Basis des natürlichen Logarithmus)";
        CONSTANT_VALUE_EULER_MASCHERONI = "Euler-Mascheroni-Konstante";
        CONSTANT_VALUE_GOLDEN_RATIO = "Goldener Schnitt";
        CONSTANT_VALUE_PLASTIC = "Plastische Konstante";
        CONSTANT_VALUE_EMBREE_TREFETHEN = "Embree-Trefethen-Konstante";
        CONSTANT_VALUE_FEIGENBAUM_DELTA = "Feigenbaum-Delta-Konstante";
        CONSTANT_VALUE_FEIGENBAUM_ALPHA = "Feigenbaum-Alpha-Konstante";
        CONSTANT_VALUE_TWIN_PRIME = "Zwillings-Primzahl-Konstante";
        CONSTANT_VALUE_MEISSEL_MERTEENS = "Meissel-Mertens-Konstante";
        CONSTANT_VALUE_BRAUN_TWIN_PRIME = "Brunsche Konstante für Zwillingsprimzahlen";
        CONSTANT_VALUE_BRAUN_PRIME_QUADR = "Brunsche Konstante für Primzahlvierlinge";
        CONSTANT_VALUE_BRUIJN_NEWMAN = "Konstante von de Bruijn-Newman";
        CONSTANT_VALUE_CATALAN = "Catalansche Konstante";
        CONSTANT_VALUE_LANDAU_RAMANUJAN = "Landau-Ramanujan-Konstante";
        CONSTANT_VALUE_VISWANATH = "Viswanathsche Konstante";
        CONSTANT_VALUE_LEGENDRE = "Legendresche Konstante";
        CONSTANT_VALUE_RAMANUJAN_SOLDNER = "Ramanujan-Soldner-Konstante";
        CONSTANT_VALUE_ERDOS_BORWEIN = "Erdos-Borwein-Konstante";
        CONSTANT_VALUE_BERNSTEIN = "Bernsteinsche Konstante";
        CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = "Gauss-Kuzmin-Wirsing-Konstante";
        CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = "Hafner-Sarnak-McCurley-Konstante";
        CONSTANT_VALUE_GOLOMB_DICKMAN = "Golomb-Dickman-Konstante";
        CONSTANT_VALUE_CAHEN = "Cahensche Konstante";
        CONSTANT_VALUE_LAPLACE_LIMIT = "Laplacesche Grenzkonstante";
        CONSTANT_VALUE_ALLADI_GRINSTEAD = "Alladi-Grinstead-Konstante";
        CONSTANT_VALUE_LENGYEL = "Lengyelsche Konstante";
        CONSTANT_VALUE_LEVY = "Levysche Konstante";
        CONSTANT_VALUE_APERY = "Aperysche Konstante";
        CONSTANT_VALUE_MILLS = "Millsche Konstante";
        CONSTANT_VALUE_BACKHOUSE = "Backhousesche Konstante";
        CONSTANT_VALUE_PORTER = "Portersche Konstante";
        CONSTANT_VALUE_LIEB_QUARE_ICE = "Liebsche quadratische Eis-Konstante";
        CONSTANT_VALUE_NIVEN = "Nivensche Konstante";
        CONSTANT_VALUE_SIERPINSKI = "Sierpinskische Konstante";
        CONSTANT_VALUE_KHINCHIN = "Khinchinsche Konstante";
        CONSTANT_VALUE_FRANSEN_ROBINSON = "Fransen-Robinson-Konstante";
        CONSTANT_VALUE_LANDAU = "Landausche Konstante";
        CONSTANT_VALUE_PARABOLIC = "Parabolische Konstante";
        CONSTANT_VALUE_OMEGA = "Omega-Konstante";
        CONSTANT_VALUE_MRB = "MRB-Konstante";
        CONSTANT_VALUE_LI2 = "Logarithmisches Integral am Punkt 2";
        CONSTANT_VALUE_GOMPERTZ = "Gompertz-Konstante";
        CONSTANT_VALUE_LIGHT_SPEED = "Lichtgeschwindigkeit im Vakuum";
        CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = "Gravitationskonstante";
        CONSTANT_VALUE_GRAVIT_ACC_EARTH = "Gravitationsbeschleunigung auf der Erde";
        CONSTANT_VALUE_PLANCK_CONSTANT = "Plancksche Konstante";
        CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = "Reduzierte Plancksche Konstante (Dirac-Konstante)";
        CONSTANT_VALUE_PLANCK_LENGTH = "Plancksche Länge";
        CONSTANT_VALUE_PLANCK_MASS = "Plancksche Masse";
        CONSTANT_VALUE_PLANCK_TIME = "Plancksche Zeit";
        CONSTANT_VALUE_LIGHT_YEAR = "Lichtjahr";
        CONSTANT_VALUE_ASTRONOMICAL_UNIT = "Astronomische Einheit";
        CONSTANT_VALUE_PARSEC = "Parsec";
        CONSTANT_VALUE_KILOPARSEC = "Kiloparsec";
        CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = "Äquatorialradius der Erde";
        CONSTANT_VALUE_EARTH_RADIUS_POLAR = "Polaradius der Erde";
        CONSTANT_VALUE_EARTH_RADIUS_MEAN = "Mittlerer Erdradius";
        CONSTANT_VALUE_EARTH_MASS = "Erdmasse";
        CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = "Erde-Sonne Entfernung";
        CONSTANT_VALUE_MOON_RADIUS_MEAN = "Mittlerer Mondradius";
        CONSTANT_VALUE_MOON_MASS = "Mondmasse";
        CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = "Mond-Erde Entfernung";
        CONSTANT_VALUE_SOLAR_RADIUS = "Mittlerer Sonnenradius";
        CONSTANT_VALUE_SOLAR_MASS = "Sonnenmasse";
        CONSTANT_VALUE_MERCURY_RADIUS_MEAN = "Mittlerer Merkuradius";
        CONSTANT_VALUE_MERCURY_MASS = "Merkurmasse";
        CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = "Merkur-Sonne Entfernung";
        CONSTANT_VALUE_VENUS_RADIUS_MEAN = "Mittlerer Venusradius";
        CONSTANT_VALUE_VENUS_MASS = "Venusmasse";
        CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = "Venus-Sonne Entfernung";
        CONSTANT_VALUE_MARS_RADIUS_MEAN = "Mittlerer Marsradius";
        CONSTANT_VALUE_MARS_MASS = "Marsmasse";
        CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = "Mars-Sonne Entfernung";
        CONSTANT_VALUE_JUPITER_RADIUS_MEAN = "Mittlerer Jupiteradius";
        CONSTANT_VALUE_JUPITER_MASS = "Jupitermasse";
        CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = "Jupiter-Sonne Entfernung";
        CONSTANT_VALUE_SATURN_RADIUS_MEAN = "Mittlerer Saturnradius";
        CONSTANT_VALUE_SATURN_MASS = "Saturnmasse";
        CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = "Saturn-Sonne Entfernung";
        CONSTANT_VALUE_URANUS_RADIUS_MEAN = "Mittlerer Uranusradius";
        CONSTANT_VALUE_URANUS_MASS = "Uranusmasse";
        CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = "Uranus-Sonne Entfernung";
        CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = "Mittlerer Neptunradius";
        CONSTANT_VALUE_NEPTUNE_MASS = "Neptunmasse";
        CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = "Neptun-Sonne Entfernung";
        CONSTANT_VALUE_TRUE = "Boolescher Wert true, dargestellt als 1";
        CONSTANT_VALUE_FALSE = "Boolescher Wert false, dargestellt als 0";
        CONSTANT_VALUE_NPAR = "Automatisch generierte Konstante für benutzerdefinierte Funktionen, gibt die Anzahl der gegebenen Funktionsparameter zurück";
        CONSTANT_VALUE_NAN = "Nicht-eine-Zahl";
        // -------------------------------------------------
        FUNCTION_1_ARG_SIN = "Trigonometrische Sinus";
        FUNCTION_1_ARG_COS = "Trigonometrische Kosinus";
        FUNCTION_1_ARG_TAN = "Trigonometrische Tangente";
        FUNCTION_1_ARG_CTAN = "Trigonometrische Kotangente";
        FUNCTION_1_ARG_SEC = "Trigonometrische Sekante";
        FUNCTION_1_ARG_COSEC = "Trigonometrische Kosekante";
        FUNCTION_1_ARG_ASIN = "Inverse trigonometrische Sinus";
        FUNCTION_1_ARG_ACOS = "Inverse trigonometrische Kosinus";
        FUNCTION_1_ARG_ATAN = "Inverse trigonometrische Tangente";
        FUNCTION_1_ARG_ACTAN = "Inverse trigonometrische Kotangente";
        FUNCTION_1_ARG_LN = "Natürlicher Logarithmus (Basis e)";
        FUNCTION_1_ARG_LOG2 = "Binärlogarithmus (Basis 2)";
        FUNCTION_1_ARG_LOG10 = "Gemeinlogarithmus (Basis 10)";
        FUNCTION_1_ARG_RAD = "Grad zu Radians";
        FUNCTION_1_ARG_EXP = "Exponentiell";
        FUNCTION_1_ARG_SQRT = "Quadratwurzel";
        FUNCTION_1_ARG_SINH = "Hyperbolischer Sinus";
        FUNCTION_1_ARG_COSH = "Hyperbolischer Kosinus";
        FUNCTION_1_ARG_TANH = "Hyperbolische Tangente";
        FUNCTION_1_ARG_COTH = "Hyperbolische Kotangente";
        FUNCTION_1_ARG_SECH = "Hyperbolische Sekante";
        FUNCTION_1_ARG_CSCH = "Hyperbolische Kosekante";
        FUNCTION_1_ARG_DEG = "Radians zu Grad";
        FUNCTION_1_ARG_ABS = "Absoluter Wert";
        FUNCTION_1_ARG_SGN = "Signum";
        FUNCTION_1_ARG_FLOOR = "Abrunden";
        FUNCTION_1_ARG_CEIL = "Aufrunden";
        FUNCTION_1_ARG_NOT = "Negation";
        FUNCTION_1_ARG_ARSINH = "Inverse hyperbolische Sinus";
        FUNCTION_1_ARG_ARCOSH = "Inverse hyperbolische Kosinus";
        FUNCTION_1_ARG_ARTANH = "Inverse hyperbolische Tangente";
        FUNCTION_1_ARG_ARCOTH = "Inverse hyperbolische Kotangente";
        FUNCTION_1_ARG_ARSECH = "Inverse hyperbolische Sekante";
        FUNCTION_1_ARG_ARCSCH = "Inverse hyperbolische Kosekante";
        FUNCTION_1_ARG_SA = "Sinc (normalisiert)";
        FUNCTION_1_ARG_SINC = "Sinc (nicht normalisiert)";
        FUNCTION_1_ARG_BELL_NUMBER = "Bell-Zahl";
        FUNCTION_1_ARG_LUCAS_NUMBER = "Lucas-Zahl";
        FUNCTION_1_ARG_FIBONACCI_NUMBER = "Fibonacci-Zahl";
        FUNCTION_1_ARG_HARMONIC_NUMBER = "Harmonische Zahl";
        FUNCTION_1_ARG_IS_PRIME = "Primzahltest (Ist Zahl eine Primzahl?)";
        FUNCTION_1_ARG_PRIME_COUNT = "Primzahlzählung";
        FUNCTION_1_ARG_EXP_INT = "Exponentielle Integral";
        FUNCTION_1_ARG_LOG_INT = "Logarithmisches Integral";
        FUNCTION_1_ARG_OFF_LOG_INT = "Versetztes logarithmisches Integral";
        FUNCTION_1_ARG_GAUSS_ERF = "Gauß-Fehlerfunktion";
        FUNCTION_1_ARG_GAUSS_ERFC = "Komplementäre Gauß-Fehlerfunktion";
        FUNCTION_1_ARG_GAUSS_ERF_INV = "Inverse Gauß-Fehlerfunktion";
        FUNCTION_1_ARG_GAUSS_ERFC_INV = "Inverse komplementäre Gauß-Fehlerfunktion";
        FUNCTION_1_ARG_ULP = "Einheit in der letzten Stelle";
        FUNCTION_1_ARG_ISNAN = "Gibt wahr zurück, wenn der Wert eine Nicht-Zahl (NaN) ist, sonst falsch";
        FUNCTION_1_ARG_NDIG10 = "Anzahl der Ziffern im Zahlensystem mit Basis 10";
        FUNCTION_1_ARG_NFACT = "Primfaktorzerlegung - Anzahl unterschiedlicher Primfaktoren";
        FUNCTION_1_ARG_ARCSEC = "Inverse trigonometrische Sekante";
        FUNCTION_1_ARG_ARCCSC = "Inverse trigonometrische Kosekante";
        FUNCTION_1_ARG_GAMMA = "Gamma";
        FUNCTION_1_ARG_LAMBERT_W0 = "Lambert-W, Hauptast 0, auch Produktlogarithmus genannt";
        FUNCTION_1_ARG_LAMBERT_W1 = "Lambert-W, Ast -1, auch Produktlogarithmus genannt";
        FUNCTION_1_ARG_SGN_GAMMA = "Signum von Gamma";
        FUNCTION_1_ARG_LOG_GAMMA = "Log Gamma";
        FUNCTION_1_ARG_DI_GAMMA = "Digamma als logarithmische Ableitung von Gamma";
        FUNCTION_1_ARG_PARAM = "Automatisch generierte Funktion für benutzerdefinierte Funktionen, gibt den Funktionsparameterwert am Index 'i' zurück";
        // -------------------------------------------------
        FUNCTION_2_ARG_LOG = "Logarithmus";
        FUNCTION_2_ARG_MOD = "Modulo";
        FUNCTION_2_ARG_BINOM_COEFF = "Binomialkoeffizient, Anzahl der k-Kombinationen, die aus einer Menge mit n Elementen gezogen werden können";
        FUNCTION_2_ARG_BERNOULLI_NUMBER = "Bernoulli-Zahlen";
        FUNCTION_2_ARG_STIRLING1_NUMBER = "Stirling-Zahlen der ersten Art";
        FUNCTION_2_ARG_STIRLING2_NUMBER = "Stirling-Zahlen der zweiten Art";
        FUNCTION_2_ARG_WORPITZKY_NUMBER = "Worpitzky-Zahl";
        FUNCTION_2_ARG_EULER_NUMBER = "Euler-Zahl";
        FUNCTION_2_ARG_KRONECKER_DELTA = "Kronecker-Delta";
        FUNCTION_2_ARG_EULER_POLYNOMIAL = "Euler-Polynom";
        FUNCTION_2_ARG_HARMONIC_NUMBER = "Harmonische Zahl";
        FUNCTION_2_ARG_ROUND = "Runden zur nächsten Ganzzahl";
        FUNCTION_2_ARG_NDIG = "Anzahl der Ziffern, die die Zahl im Zahlsystem mit gegebener Basis darstellen";
        FUNCTION_2_ARG_DIGIT10 = "Ziffer an Position 1 ... n (links -> rechts) oder 0 ... -(n-1) (rechts -> links) - Zehnersystem";
        FUNCTION_2_ARG_FACTVAL = "Primzerlegung - Faktorwert an Position zwischen 1 ... nfact(n) - aufsteigende Reihenfolge nach Faktorwert";
        FUNCTION_2_ARG_FACTEXP = "Primzerlegung - Faktorexponent / Vielfachheit an Position zwischen 1 ... nfact(n) - aufsteigende Reihenfolge nach Faktorwert";
        FUNCTION_2_ARG_ROOT = "Wurzel der Ordnung N einer Zahl";
        FUNCTION_2_ARG_INC_GAMMA_LOWER = "Unterfunktion der unvollständigen Gammafunktion";
        FUNCTION_2_ARG_INC_GAMMA_UPPER = "Oberfunktion der unvollständigen Gammafunktion";
        FUNCTION_2_ARG_REG_GAMMA_LOWER = "Unterfunktion der regularisierten Gammafunktion P";
        FUNCTION_2_ARG_REG_GAMMA_UPPER = "Oberfunktion der regularisierten Gammafunktion Q";
        FUNCTION_2_ARG_PERMUTATIONS = "Anzahl der k-Permutationen, die aus einer Menge mit n Elementen gezogen werden können";
        FUNCTION_2_ARG_BETA = "Die Beta, auch Euler-Integral der ersten Art genannt";
        FUNCTION_2_ARG_LOG_BETA = "Die Log-Beta, auch Log-Euler-Integral der ersten Art genannt";
        // -------------------------------------------------
        FUNCTION_3_ARG_IF = "Wenn";
        FUNCTION_3_ARG_CHI = "Charakteristische Funktion für x in (a,b)";
        FUNCTION_3_ARG_CHI_LR = "Charakteristische Funktion für x in [a,b]";
        FUNCTION_3_ARG_CHI_L = "Charakteristische Funktion für x in [a,b)";
        FUNCTION_3_ARG_CHI_R = "Charakteristische Funktion für x in (a,b]";
        FUNCTION_3_ARG_DIGIT = "Ziffer an Position 1 ... n (links -> rechts) oder 0 ... -(n-1) (rechts -> links) - Zahlensystem mit gegebener Basis";
        FUNCTION_3_ARG_INC_BETA = "Die unvollständige Beta, auch unvollständiges Euler-Integral der ersten Art genannt";
        FUNCTION_3_ARG_REG_BETA = "Die regularisierte unvollständige Beta (oder regularisierte Beta), auch regularisiertes unvollständiges Euler-Integral der ersten Art genannt";
        // -------------------------------------------------
        FUNCTION_VARIADIC_IFF = "Wenn Funktion";
        FUNCTION_VARIADIC_MIN = "Minimum";
        FUNCTION_VARIADIC_MAX = "Maximum";
        FUNCTION_VARIADIC_CONT_FRAC = "Kettenbruch";
        FUNCTION_VARIADIC_CONT_POL = "Fortgesetztes Polynom";
        FUNCTION_VARIADIC_GCD = "Größter gemeinsamer Teiler";
        FUNCTION_VARIADIC_LCM = "Kleinstes gemeinsames Vielfaches";
        FUNCTION_VARIADIC_SUM = "Summierung";
        FUNCTION_VARIADIC_PROD = "Multiplikation";
        FUNCTION_VARIADIC_AVG = "Mittelwert / Durchschnittswert";
        FUNCTION_VARIADIC_VAR = "Korrektur der Stichprobenvarianz";
        FUNCTION_VARIADIC_STD = "Korrektur der Stichprobenstandardabweichung";
        FUNCTION_VARIADIC_RND_LIST = "Zufallszahl aus einer gegebenen Liste von Zahlen";
        FUNCTION_VARIADIC_COALESCE = "Gibt den ersten Nicht-NaN-Wert zurück";
        FUNCTION_VARIADIC_OR = "Logische Disjunktion (ODER) - variadisch";
        FUNCTION_VARIADIC_AND = "Logische Konjunktion (UND) - variadisch";
        FUNCTION_VARIADIC_XOR = "Exklusives Oder (XOR) - variadisch";
        FUNCTION_VARIADIC_ARGMIN = "Argumente / Indizes der Minima";
        FUNCTION_VARIADIC_ARGMAX = "Argumente / Indizes der Maxima";
        FUNCTION_VARIADIC_MEDIAN = "Der Stichprobenmedian";
        FUNCTION_VARIADIC_MODE = "Modus - der Wert, der am häufigsten vorkommt";
        FUNCTION_VARIADIC_BASE = "Gibt die Zahl in der gegebenen Zahlensystembasis zurück, die durch eine Liste von Ziffern dargestellt wird";
        FUNCTION_VARIADIC_NDIST = "Anzahl der verschiedenen Werte";
        // -------------------------------------------------
        OPERATOR_PLUS = "Addition";
        OPERATOR_MINUS = "Subtraktion";
        OPERATOR_MULTIPLY = "Multiplikation";
        OPERATOR_DIVIDE = "Division";
        OPERATOR_DIVIDE_QUOTIENT = "Ganzzahldivision (Quotient)";
        OPERATOR_POWER = "Exponentiation";
        OPERATOR_FACT = "Fakultät";
        OPERATOR_MOD = "Modulo";
        OPERATOR_PERC = "Prozentsatz";
        OPERATOR_TETRATION = "Tetration (Hyper-4, Potenzturm, exponentieller Turm)";
        OPERATOR_SQUARE_ROOT = "Quadratwurzel";
        OPERATOR_CUBE_ROOT = "Kubikwurzel";
        OPERATOR_FOURTH_ROOT = "Viertelwurzel";
        // -------------------------------------------------
        PARSER_SYMBOL_LEFT_PARENTHESES = "Linke Klammer";
        PARSER_SYMBOL_RIGHT_PARENTHESES = "Rechte Klammer";
        PARSER_SYMBOL_COMMA = "Komma (Funktionsparameter)";
        PARSER_SYMBOL_SEMI = "Semikolon (Funktionsparameter)";
        PARSER_SYMBOL_BLANK = "Leerzeichen";
        PARSER_SYMBOL_NUMBER_INTEGER = "Ganzzahl";
        PARSER_SYMBOL_NUMBER_DECIMAL = "Dezimalzahl";
        PARSER_SYMBOL_NUMBER_LEADING_ZERO = "Führende Null";
        PARSER_SYMBOL_NUMBER_SCI_NOTATION = "Wissenschaftliche Notation";
        PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = "Keine führende Null";
        PARSER_SYMBOL_NUMBER_FRACTIONS = "Brüche";
        PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = "Andere Zahlensysteme";
        PARSER_SYMBOL_UNICODE_MATH = "- Unicode-Mathematiksymbol";
        // -------------------------------------------------
        DIMENSIONLESS_UNIT_PERC = "Prozentsatz";
        DIMENSIONLESS_UNIT_PERM = "Promille";
        DIMENSIONLESS_UNIT_YOTTA = "Septillion / Yotta";
        DIMENSIONLESS_UNIT_ZETTA = "Sextillion / Zetta";
        DIMENSIONLESS_UNIT_EXA = "Quintillion / Exa";
        DIMENSIONLESS_UNIT_PETA = "Quadrillion / Peta";
        DIMENSIONLESS_UNIT_TERA = "Billion / Tera";
        DIMENSIONLESS_UNIT_GIGA = "Milliarde / Giga";
        DIMENSIONLESS_UNIT_MEGA = "Million / Mega";
        DIMENSIONLESS_UNIT_KILO = "Tausend / Kilo";
        DIMENSIONLESS_UNIT_HECTO = "Hundert / Hecto";
        DIMENSIONLESS_UNIT_DECA = "Zehn / Deca";
        DIMENSIONLESS_UNIT_DECI = "Zehntel / Deci";
        DIMENSIONLESS_UNIT_CENTI = "Hundertstel / Centi";
        DIMENSIONLESS_UNIT_MILLI = "Tausendstel / Milli";
        DIMENSIONLESS_UNIT_MICRO = "Millionstel / Micro";
        DIMENSIONLESS_UNIT_NANO = "Milliardstel / Nano";
        DIMENSIONLESS_UNIT_PICO = "Billionstel / Pico";
        DIMENSIONLESS_UNIT_FEMTO = "Billiardstel / Femto";
        DIMENSIONLESS_UNIT_ATTO = "Trillionstel / Atto";
        DIMENSIONLESS_UNIT_ZEPTO = "Trilliardstel / Zepto";
        DIMENSIONLESS_UNIT_YOCTO = "Quadrillionstel / Yocto";
        // -------------------------------------------------
        UNIT_METRE = "Meter";
        UNIT_KILOMETRE = "Kilometer";
        UNIT_CENTIMETRE = "Zentimeter";
        UNIT_MILLIMETRE = "Millimeter";
        UNIT_INCH = "Zoll";
        UNIT_YARD = "Yard";
        UNIT_FEET = "Fuß";
        UNIT_MILE = "Meile";
        UNIT_NAUTICAL_MILE = "Seemeile";
        UNIT_METRE2 = "Quadratmeter";
        UNIT_CENTIMETRE2 = "Quadratzentimeter";
        UNIT_MILLIMETRE2 = "Quadratmillimeter";
        UNIT_ARE = "Ar";
        UNIT_HECTARE = "Hektar";
        UNIT_ACRE = "Morgen";
        UNIT_KILOMETRE2 = "Quadratkilometer";
        UNIT_MILLIMETRE3 = "Kubikmillimeter";
        UNIT_CENTIMETRE3 = "Kubikzentimeter";
        UNIT_METRE3 = "Kubikmeter";
        UNIT_KILOMETRE3 = "Kubikkilometer";
        UNIT_MILLILITRE = "Milliliter";
        UNIT_LITRE = "Liter";
        UNIT_GALLON = "Gallone";
        UNIT_PINT = "Pint";
        UNIT_SECOND = "Sekunde";
        UNIT_MILLISECOND = "Millisekunde";
        UNIT_MINUTE = "Minute";
        UNIT_HOUR = "Stunde";
        UNIT_DAY = "Tag";
        UNIT_WEEK = "Woche";
        UNIT_JULIAN_YEAR = "Julianisches Jahr = 365,25 Tage";
        UNIT_KILOGRAM = "Kilogramm";
        UNIT_GRAM = "Gramm";
        UNIT_MILLIGRAM = "Milligramm";
        UNIT_DECAGRAM = "Dekagramm";
        UNIT_TONNE = "Tonne";
        UNIT_OUNCE = "Unze";
        UNIT_POUND = "Pfund";
        UNIT_BIT = "Bit";
        UNIT_KILOBIT = "Kilobit";
        UNIT_MEGABIT = "Megabit";
        UNIT_GIGABIT = "Gigabit";
        UNIT_TERABIT = "Terabit";
        UNIT_PETABIT = "Petabit";
        UNIT_EXABIT = "Exabit";
        UNIT_ZETTABIT = "Zettabit";
        UNIT_YOTTABIT = "Yottabit";
        UNIT_BYTE = "Byte";
        UNIT_KILOBYTE = "Kilobyte";
        UNIT_MEGABYTE = "Megabyte";
        UNIT_GIGABYTE = "Gigabyte";
        UNIT_TERABYTE = "Terabyte";
        UNIT_PETABYTE = "Petabyte";
        UNIT_EXABYTE = "Exabyte";
        UNIT_ZETTABYTE = "Zettabyte";
        UNIT_YOTTABYTE = "Yottabyte";
        UNIT_JOULE = "Joule";
        UNIT_ELECTRONO_VOLT = "Elektronenvolt";
        UNIT_KILO_ELECTRONO_VOLT = "Kiloelektronenvolt";
        UNIT_MEGA_ELECTRONO_VOLT = "Megaelektronenvolt";
        UNIT_GIGA_ELECTRONO_VOLT = "Gigaelektronenvolt";
        UNIT_TERA_ELECTRONO_VOLT = "Teraelektronenvolt";
        UNIT_METRE_PER_SECOND = "Meter pro Sekunde";
        UNIT_KILOMETRE_PER_HOUR = "Kilometer pro Stunde";
        UNIT_MILE_PER_HOUR = "Meilen pro Stunde";
        UNIT_KNOT = "Knoten";
        UNIT_METRE_PER_SECOND2 = "Meter pro Quadratsekunde";
        UNIT_KILOMETRE_PER_HOUR2 = "Kilometer pro Quadratstunde";
        UNIT_MILE_PER_HOUR2 = "Meilen pro Quadratstunde";
        UNIT_RADIAN_ARC = "Radiant";
        UNIT_DEGREE_ARC = "Grad";
        UNIT_MINUTE_ARC = "Bogenminute";
        UNIT_SECOND_ARC = "Bogensekunde";
    }
}