/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.cep.esper;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.management.JMX;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.module.BlockingSinkDataListener;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;
import org.marketcetera.modules.cep.esper.CEPEsperFactory;
import org.marketcetera.modules.cep.esper.CEPEsperProcessorMXBean;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.OrderSingleSuggestion;

@ClassVersion(value="$Id: ExternalTimeTest.java 16994 2015-03-09 21:18:25Z colin $")
public class ExternalTimeTest
extends ModuleTestBase {
    protected ModuleManager sManager;
    protected static BlockingSinkDataListener sSink;
    protected static Factory sFactory;
    private static ModuleURN TEST_URN;

    @Before
    public void before() throws Exception {
        sSink = new BlockingSinkDataListener();
        this.sManager = new ModuleManager();
        this.sManager.init();
        this.sManager.addSinkListener((SinkDataListener)sSink);
    }

    @After
    public void after() throws Exception {
        this.sManager.removeSinkListener((SinkDataListener)sSink);
        this.sManager.stop();
    }

    @Test(timeout=120000L)
    public void testExternalTime() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(2977, 7, 8, 10, 30, 40);
        AskEvent ask1 = EventTestBase.generateEquityAskEvent((long)1L, (long)cal.getTimeInMillis(), (Equity)new Equity("AB1"), (String)"nyse", (BigDecimal)new BigDecimal("23"), (BigDecimal)new BigDecimal("23"));
        cal.set(2977, 7, 13, 10, 30, 40);
        AskEvent ask2 = EventTestBase.generateEquityAskEvent((long)1L, (long)cal.getTimeInMillis(), (Equity)new Equity("AB2"), (String)"nyse", (BigDecimal)new BigDecimal("23"), (BigDecimal)new BigDecimal("23"));
        cal.set(2978, 7, 13, 10, 30, 40);
        AskEvent ask3 = EventTestBase.generateEquityAskEvent((long)1L, (long)cal.getTimeInMillis(), (Equity)new Equity("AB3"), (String)"nyse", (BigDecimal)new BigDecimal("23"), (BigDecimal)new BigDecimal("23"));
        cal.set(2978, 7, 14, 10, 30, 40);
        AskEvent ask4 = EventTestBase.generateEquityAskEvent((long)1L, (long)cal.getTimeInMillis(), (Equity)new Equity("AB4"), (String)"nyse", (BigDecimal)new BigDecimal("23"), (BigDecimal)new BigDecimal("23"));
        cal.set(2978, 7, 29, 11, 15, 40);
        AskEvent ask5 = EventTestBase.generateEquityAskEvent((long)1L, (long)cal.getTimeInMillis(), (Equity)new Equity("AB5"), (String)"nyse", (BigDecimal)new BigDecimal("23"), (BigDecimal)new BigDecimal("23"));
        this.sManager.createModule(CEPEsperFactory.PROVIDER_URN, new Object[]{TEST_URN});
        CEPEsperProcessorMXBean esperBean = JMX.newMXBeanProxy(ModuleTestBase.getMBeanServer(), TEST_URN.toObjectName(), CEPEsperProcessorMXBean.class);
        this.sManager.stop(TEST_URN);
        esperBean.setUseExternalTime(true);
        Assert.assertTrue((String)"accessor doesn't return right value", (boolean)esperBean.isUseExternalTime());
        this.sManager.start(TEST_URN);
        OrderSingleSuggestion sug1 = Factory.getInstance().createOrderSingleSuggestion();
        sug1.setIdentifier("acura");
        DataFlowID flow = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Object[]{ask1, ask2, ask3, ask4, ask5}), new DataRequest(TEST_URN, (Object)new String[]{"select * from ask.win:time(10 days).std:size()"})});
        Assert.assertEquals((String)"wrong size event", (Object)1L, (Object)sSink.getNextData());
        Assert.assertEquals((String)"wrong size event", (Object)2L, (Object)sSink.getNextData());
        Assert.assertEquals((String)"wrong size event", (Object)0L, (Object)sSink.getNextData());
        Assert.assertEquals((String)"wrong size event", (Object)1L, (Object)sSink.getNextData());
        Assert.assertEquals((String)"wrong size event", (Object)2L, (Object)sSink.getNextData());
        Assert.assertEquals((String)"wrong size event", (Object)0L, (Object)sSink.getNextData());
        Assert.assertEquals((String)"wrong size event", (Object)1L, (Object)sSink.getNextData());
        this.sManager.cancel(flow);
    }

    @Test(timeout=120000L)
    public void testCancelBeforeFlowIsOver() throws Exception {
        this.sManager.createModule(CEPEsperFactory.PROVIDER_URN, new Object[]{TEST_URN});
        CEPEsperProcessorMXBean esperBean = JMX.newMXBeanProxy(ModuleTestBase.getMBeanServer(), TEST_URN.toObjectName(), CEPEsperProcessorMXBean.class);
        this.sManager.stop(TEST_URN);
        esperBean.setUseExternalTime(true);
        this.sManager.start(TEST_URN);
        DataFlowID flow = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Object[]{1, 2, 3, 4, 5, "vishel zaichik pogulyat"}), new DataRequest(TEST_URN, (Object)new String[]{"select * bid"})});
        this.sManager.cancel(flow);
        Assert.assertEquals((String)"shouldn't have any statements", (long)0L, (long)esperBean.getStatementNames().length);
    }

    @Test
    public void testCancelWithoutData() throws Exception {
        this.sManager.createModule(CEPEsperFactory.PROVIDER_URN, new Object[]{TEST_URN});
        CEPEsperProcessorMXBean esperBean = JMX.newMXBeanProxy(ModuleTestBase.getMBeanServer(), TEST_URN.toObjectName(), CEPEsperProcessorMXBean.class);
        this.sManager.stop(TEST_URN);
        esperBean.setUseExternalTime(true);
        this.sManager.start(TEST_URN);
        String[] query = new String[]{"select * bid"};
        DataFlowID flowID = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Object[0]), new DataRequest(TEST_URN, (Object)query)});
        this.sManager.cancel(flowID);
    }

    static {
        TEST_URN = new ModuleURN(CEPEsperFactory.PROVIDER_URN, "toli");
    }
}

