/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.cep.esper;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.module.BlockingSinkDataListener;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;
import org.marketcetera.modules.cep.esper.CEPEsperFactory;
import org.marketcetera.trade.Factory;

@ClassVersion(value="$Id: SelfRepostingEventsTest.java 16994 2015-03-09 21:18:25Z colin $")
public class SelfRepostingEventsTest
extends ModuleTestBase {
    protected ModuleManager sManager;
    protected static BlockingSinkDataListener sSink;
    protected static Factory sFactory;
    private static ModuleURN TEST_URN;

    @Before
    public void before() throws Exception {
        sSink = new BlockingSinkDataListener();
        this.sManager = new ModuleManager();
        this.sManager.init();
        this.sManager.addSinkListener((SinkDataListener)sSink);
    }

    @After
    public void after() throws Exception {
        this.sManager.removeSinkListener((SinkDataListener)sSink);
        this.sManager.stop();
    }

    @Test(timeout=120000L)
    public void testSelfRepostingEvents() throws Exception {
        DataFlowID flow = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Object[]{new ClassB(new ClassA("vasya"))}), new DataRequest(TEST_URN, (Object)("select * from " + ClassB.class.getName())), new DataRequest(TEST_URN, (Object)("select attribA from " + ClassB.class.getName())), new DataRequest(TEST_URN, (Object)("select strAttrib from " + ClassA.class.getName()))});
        Assert.assertEquals((Object)"vasya", (Object)sSink.getNextData());
        this.sManager.cancel(flow);
    }

    static {
        TEST_URN = new ModuleURN(CEPEsperFactory.PROVIDER_URN, "toli");
    }

    public static final class ClassB {
        private ClassA attribA;

        public ClassB(ClassA attribA) {
            this.attribA = attribA;
        }

        public ClassA getAttribA() {
            return this.attribA;
        }
    }

    public static final class ClassA {
        private String strAttrib;

        public ClassA(String strAttrib) {
            this.strAttrib = strAttrib;
        }

        public String getStrAttrib() {
            return this.strAttrib;
        }
    }
}

