/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.cep.esper;

import com.espertech.esper.client.EPStatement;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMX;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.event.HasInstrument;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.modules.cep.esper.CEPEsperFactory;
import org.marketcetera.modules.cep.esper.CEPEsperProcessor;
import org.marketcetera.modules.cep.esper.CEPEsperProcessorMXBean;
import org.marketcetera.modules.cep.system.CEPTestBase;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Factory;

public class EsperModuleTest
extends CEPTestBase {
    private static CEPEsperProcessorMXBean sEsperBean;
    private static ModuleURN TEST_URN;

    @BeforeClass
    public static void setup() throws Exception {
        sFactory = Factory.getInstance();
        sEsperBean = JMX.newMXBeanProxy(ModuleTestBase.getMBeanServer(), TEST_URN.toObjectName(), CEPEsperProcessorMXBean.class);
    }

    protected ModuleURN getModuleURN() {
        return TEST_URN;
    }

    protected Class<?> getIncorrectQueryException() {
        return IllegalRequestParameterValue.class;
    }

    @Test(timeout=120000L)
    public void testBasicFlow() throws Exception {
        DataFlowID flowID = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityTradeEvent((long)5L, (long)6L, (Equity)new Equity("JAVA"), (String)"NASDAQ", (BigDecimal)new BigDecimal("1.23"), (BigDecimal)new BigDecimal("300")), EventTestBase.generateEquityTradeEvent((long)3L, (long)4L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("200"))}), new DataRequest(TEST_URN, (Object)"select * from trade where instrumentAsString='IBM'")});
        Object obj = sSink.getNextData();
        Assert.assertTrue((String)"Didn't receive right trade event", (boolean)(obj instanceof TradeEvent));
        TradeEvent theTrade = (TradeEvent)obj;
        Assert.assertEquals((String)"Didn't receive right symbol event", (Object)"IBM", (Object)theTrade.getInstrumentAsString());
        Assert.assertEquals((String)"Didn't receive right size event", (Object)new BigDecimal("200"), (Object)theTrade.getSize());
        Assert.assertEquals((String)"Wrong number of received events", (long)3L, (long)sEsperBean.getNumEventsReceived());
        Assert.assertEquals((String)"Wrong number of emitted events", (long)1L, (long)this.sManager.getDataFlowInfo(flowID).getFlowSteps()[1].getNumEmitted());
        Assert.assertEquals((String)"Sink should only receive one event", (long)0L, (long)sSink.size());
        this.sManager.cancel(flowID);
    }

    @Test(timeout=120000L)
    public void testOnlyLastStatementGetsSubscriber() throws Exception {
        DataFlowID flowID = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityTradeEvent((long)3L, (long)4L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("200")), EventTestBase.generateEquityTradeEvent((long)5L, (long)6L, (Equity)new Equity("JAVA"), (String)"NASDAQ", (BigDecimal)new BigDecimal("1.23"), (BigDecimal)new BigDecimal("300"))}), new DataRequest(TEST_URN, (Object)new String[]{"select * from trade where instrumentAsString='IBM'", "select * from trade where instrumentAsString='JAVA'"})});
        Assert.assertEquals((Object)"JAVA", (Object)((HasInstrument)sSink.getNextData()).getInstrumentAsString());
        Assert.assertEquals((String)"wrong # of emitted events from Esper", (long)1L, (long)this.sManager.getDataFlowInfo(flowID).getFlowSteps()[1].getNumEmitted());
        Assert.assertEquals((String)"# of running statements", (long)2L, (long)sEsperBean.getStatementNames().length);
        this.sManager.cancel(flowID);
    }

    @Test(timeout=120000L)
    public void testEsperCancel() throws Exception {
        DataFlowID flowID = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityTradeEvent((long)3L, (long)4L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("200")), EventTestBase.generateEquityTradeEvent((long)5L, (long)6L, (Equity)new Equity("JAVA"), (String)"NASDAQ", (BigDecimal)new BigDecimal("1.23"), (BigDecimal)new BigDecimal("300"))}), new DataRequest(TEST_URN, (Object)"select * from trade where instrumentAsString='IBM'")});
        Assert.assertEquals((Object)"IBM", (Object)((HasInstrument)sSink.getNextData()).getInstrumentAsString());
        Assert.assertEquals((String)"wrong # of emitted events from Esper", (long)1L, (long)this.sManager.getDataFlowInfo(flowID).getFlowSteps()[1].getNumEmitted());
        Assert.assertEquals((String)"# of running statements before cancel", (long)1L, (long)sEsperBean.getStatementNames().length);
        this.sManager.cancel(flowID);
        DataFlowID flowID2 = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityTradeEvent((long)3L, (long)4L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("200")), EventTestBase.generateEquityTradeEvent((long)5L, (long)6L, (Equity)new Equity("JAVA"), (String)"NASDAQ", (BigDecimal)new BigDecimal("1.23"), (BigDecimal)new BigDecimal("300"))}), new DataRequest(TEST_URN, (Object)"select * from trade where instrumentAsString='JAVA'")});
        Assert.assertEquals((Object)"JAVA", (Object)((HasInstrument)sSink.getNextData()).getInstrumentAsString());
        Assert.assertEquals((String)"wrong # of emitted events from Esper", (long)1L, (long)this.sManager.getDataFlowInfo(flowID2).getFlowSteps()[1].getNumEmitted());
        this.sManager.cancel(flowID2);
    }

    @Test(timeout=120000L)
    public void testCreateStatements() throws Exception {
        CEPEsperProcessor esperPr = new CEPEsperProcessor(CEPEsperFactory.PROVIDER_URN);
        esperPr.preStart();
        ArrayList stmts = esperPr.createStatements(new String[]{"select * from ask where instrumentAsString = 'entourage'", "p:every(spike=ask(exchange='sunday'))"});
        Assert.assertEquals((long)2L, (long)stmts.size());
        Assert.assertFalse((String)"Did not create a regular Esper statement", (boolean)((EPStatement)stmts.get(0)).isPattern());
        Assert.assertTrue((String)"did not create a pattern statement", (boolean)((EPStatement)stmts.get(1)).isPattern());
    }

    @Test
    public void testJMX() throws Exception {
        this.sManager.createModule(CEPEsperFactory.PROVIDER_URN, new Object[]{TEST_URN});
        CEPEsperProcessorMXBean esperBean = JMX.newMXBeanProxy(ModuleTestBase.getMBeanServer(), TEST_URN.toObjectName(), CEPEsperProcessorMXBean.class);
        Assert.assertFalse((String)"external time not set correctly", (boolean)esperBean.isUseExternalTime());
        this.sManager.stop(TEST_URN);
        esperBean.setUseExternalTime(true);
        this.sManager.start(TEST_URN);
        Assert.assertTrue((String)"external time not set correctly", (boolean)esperBean.isUseExternalTime());
        this.sManager.stop(TEST_URN);
        this.sManager.deleteModule(TEST_URN);
    }

    @Test
    public void testUnknownAlias() throws Exception {
        new ExpectedTestFailure(IllegalRequestParameterValue.class, "bob"){

            protected void execute() throws Throwable {
                EsperModuleTest.this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("GOOG"), (String)"NYSE", (BigDecimal)new BigDecimal("300"), (BigDecimal)new BigDecimal("100"))}), new DataRequest(TEST_URN, (Object)"select * from bob")});
            }
        }.run();
    }

    @Test(timeout=120000L)
    public void testAllStatementsCleanedUpIfOneHasError() throws Exception {
        DataFlowID flow = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("GOOG"), (String)"NYSE", (BigDecimal)new BigDecimal("300"), (BigDecimal)new BigDecimal("100"))}), new DataRequest(TEST_URN, (Object)new String[]{"select * from trade"})});
        CEPEsperProcessorMXBean esperBean = JMX.newMXBeanProxy(ModuleTestBase.getMBeanServer(), TEST_URN.toObjectName(), CEPEsperProcessorMXBean.class);
        Assert.assertEquals((String)("invalid # of statements" + Arrays.toString(esperBean.getStatementNames())), (long)1L, (long)esperBean.getStatementNames().length);
        new ExpectedTestFailure(IllegalRequestParameterValue.class, "bob"){

            protected void execute() throws Throwable {
                EsperModuleTest.this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("GOOG"), (String)"NYSE", (BigDecimal)new BigDecimal("300"), (BigDecimal)new BigDecimal("100"))}), new DataRequest(TEST_URN, (Object)new String[]{"select * from trade", "select * from bob"})});
            }
        }.run();
        Assert.assertEquals((String)("invalid # of statements" + Arrays.toString(esperBean.getStatementNames())), (long)1L, (long)esperBean.getStatementNames().length);
        this.sManager.cancel(flow);
    }

    @Test(timeout=120000L)
    public void testPattern() throws Exception {
        long timeStart = System.currentTimeMillis();
        DataFlowID flow = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("GOOG"), (String)"NYSE", (BigDecimal)new BigDecimal("300"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityAskEvent((long)1L, (long)2L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("100"), (BigDecimal)new BigDecimal("100"))}), new DataRequest(TEST_URN, (Object)new String[]{"p: ask(instrumentAsString='IBM') -> timer:interval(10 seconds)"})});
        sSink.getNextData();
        long timeEnd = System.currentTimeMillis();
        Assert.assertTrue((String)("Didn't wait longer than 10 secs: " + (timeEnd - timeStart)), (timeEnd - timeStart > 10000L ? 1 : 0) != 0);
        this.sManager.cancel(flow);
    }

    @Test
    public void testPattern_explicit() throws Exception {
        long timeStart = System.currentTimeMillis();
        DataFlowID flow = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (long)2L, (Equity)new Equity("GOOG"), (String)"NYSE", (BigDecimal)new BigDecimal("300"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityAskEvent((long)1L, (long)2L, (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("100"), (BigDecimal)new BigDecimal("100"))}), new DataRequest(TEST_URN, (Object)new String[]{"select 1 as toli from pattern [ask(instrumentAsString='IBM') -> timer:interval(10 seconds)]"})});
        Assert.assertEquals((String)"received wrong object", (Object)1, (Object)sSink.getNextData());
        long timeEnd = System.currentTimeMillis();
        Assert.assertTrue((String)("Didn't wait longer than 10 secs: " + (timeEnd - timeStart)), (timeEnd - timeStart > 10000L ? 1 : 0) != 0);
        this.sManager.cancel(flow);
    }

    @Test
    public void testDynamicMapProperties() throws Exception {
        HashMap map1 = Maps.newHashMap();
        map1.put("name", "nap");
        map1.put("game", "tap");
        HashMap map2 = Maps.newHashMap();
        map2.put("name", "gap");
        map2.put("game", "kebap");
        DataFlowID flow = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Map[]{map1, map2}), new DataRequest(TEST_URN, (Object)new String[]{"select name? from map"})});
        Assert.assertEquals((String)"received wrong object", (Object)"nap", (Object)sSink.getNextData());
        Assert.assertEquals((String)"received wrong object", (Object)"gap", (Object)sSink.getNextData());
        this.sManager.cancel(flow);
    }

    public void testMap() throws Exception {
        this.flowTestHelper("map", new Object[]{this.map1, this.map2});
    }

    static {
        TEST_URN = new ModuleURN(CEPEsperFactory.PROVIDER_URN, "toli");
    }
}

