/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.cep.esper;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.modules.cep.esper.CEPEsperFactory;
import org.marketcetera.modules.cep.esper.CEPEsperProcessor;
import org.marketcetera.modules.cep.esper.Messages;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class ParameterVerfiicationTest
extends ModuleTestBase {
    private static ModuleURN TEST_URN = new ModuleURN(CEPEsperFactory.PROVIDER_URN, "toli");
    private CEPEsperProcessor esperPr;
    private ModuleManager mManager;

    @Before
    public void before() {
        this.esperPr = new CEPEsperProcessor(TEST_URN);
    }

    @Test
    public void invalidRequests_null() throws Exception {
        new ExpectedFailure<IllegalRequestParameterValue>((I18NMessage)org.marketcetera.module.Messages.ILLEGAL_REQ_PARM_VALUE, new Object[]{TEST_URN.getValue(), null}){

            protected void run() throws Exception {
                ParameterVerfiicationTest.this.esperPr.requestData(new DataRequest(TEST_URN, null), null);
            }
        };
    }

    @Test
    public void invalidRequests_EmptyArray() throws Exception {
        final String[] emptyParams = new String[]{};
        new ExpectedTestFailure(IllegalRequestParameterValue.class, org.marketcetera.module.Messages.ILLEGAL_REQ_PARM_VALUE.getText((Object)TEST_URN.getValue(), (Object)emptyParams)){

            protected void execute() throws Throwable {
                ParameterVerfiicationTest.this.esperPr.requestData(new DataRequest(TEST_URN, (Object)emptyParams), null);
            }
        }.run();
    }

    @Test
    public void invalidRequests_InvalidReq() throws Exception {
        String query = "v lesu rodilas yolochka";
        this.esperPr.preStart();
        new ExpectedTestFailure(IllegalRequestParameterValue.class){

            protected void execute() throws Exception {
                ParameterVerfiicationTest.this.esperPr.requestData(new DataRequest(TEST_URN, (Object)"v lesu rodilas yolochka"), null);
            }
        }.run();
    }

    @Test
    public void invalidRequests_Pattern() throws Exception {
        String query = "p:v lesu rodilas yolochka";
        this.esperPr.preStart();
        new ExpectedTestFailure(IllegalRequestParameterValue.class){

            protected void execute() throws Throwable {
                ParameterVerfiicationTest.this.esperPr.requestData(new DataRequest(TEST_URN, (Object)"p:v lesu rodilas yolochka"), null);
            }
        }.run();
    }

    @Test
    public void providerInfo() throws Exception {
        ParameterVerfiicationTest.assertProviderInfo((ModuleManager)this.mManager, (ModuleURN)CEPEsperFactory.PROVIDER_URN, (String[])new String[]{ModuleURN.class.getName()}, (Class[])new Class[]{ModuleURN.class}, (String)Messages.PROVIDER_DESCRIPTION.getText(), (boolean)true, (boolean)true);
    }

    @Before
    public void setup() throws Exception {
        this.mManager = new ModuleManager();
        this.mManager.init();
    }

    @After
    public void cleanup() throws Exception {
        this.mManager.stop();
        this.mManager = null;
    }
}

