/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.beans.ExceptionListener;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.BrokerStatusListener;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientImpl;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ClientVersion;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.client.MockAuthenticator;
import org.marketcetera.client.MockServer;
import org.marketcetera.client.MockServiceImpl;
import org.marketcetera.client.ReportListener;
import org.marketcetera.client.ServerStatusListener;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.jms.OrderEnvelope;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.core.Util;
import org.marketcetera.core.position.PositionKeyFactory;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.quickfix.FIXDataDictionaryManager;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReportImpl;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.FIXResponse;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelRejectImpl;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TimeInForce;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.tags.AppId;
import quickfix.Message;
import quickfix.field.ClOrdID;
import quickfix.field.OrigClOrdID;
import quickfix.fix44.ExecutionReport;
import quickfix.fix44.OrderCancelReject;

@ClassVersion(value="$Id: ClientTest.java 16154 2012-07-14 16:34:05Z colin $")
public class ClientTest
extends TestCaseBase {
    private static final int NUM_REPEAT = 5;
    private final ErrorListener mListener = new ErrorListener();
    private final ReplyListener mReplies = new ReplyListener();
    private final BrokerStatusReplyListener mBrokerStatusReplies = new BrokerStatusReplyListener();
    private final ServerStatusReplyListener mServerStatusReplies = new ServerStatusReplyListener();
    private static MockServer sServer;
    private Client mClient;
    private static final AtomicLong sCounter;
    private static final String DEFAULT_CREDENTIAL = "name";
    private static final int SHORT_INTERVAL = 2000;
    private static final int LONG_INTERVAL = 60000;

    @BeforeClass
    public static void setup() throws Exception {
        LoggerConfiguration.logSetup();
        FIXDataDictionaryManager.initialize((FIXVersion)FIXVersion.FIX42, (String)FIXVersion.FIX42.getDataDictionaryURL());
        ClientTest.initServer();
    }

    @AfterClass
    public static void closeServer() throws Exception {
        if (sServer != null) {
            sServer.close();
            sServer = null;
        }
    }

    @After
    public void closeClient() {
        if (this.mClient != null) {
            this.mClient.close();
        }
        this.clearAll();
    }

    @Test
    public void versionTest() throws Exception {
        Assert.assertEquals((Object)"2.2.0", (Object)Util.getVersion((AppId)ClientVersion.APP_ID));
    }

    @Test
    public void connect() throws Exception {
        this.initClient();
        Assert.assertNotNull((Object)ClientManager.getInstance());
    }

    @Test
    public void connectFailure() throws Exception {
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.CONNECT_ERROR_NO_URL){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters("you", "why".toCharArray(), null, "localhost", 9000));
            }
        };
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.CONNECT_ERROR_NO_URL){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters("you", "why".toCharArray(), "  ", "localhost", 9000));
            }
        };
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.CONNECT_ERROR_NO_USERNAME){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters(null, "why".toCharArray(), "tcp://whatever:404", "localhost", 9000));
            }
        };
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.CONNECT_ERROR_NO_USERNAME){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters("   ", "why".toCharArray(), "tcp://whatever:404", "localhost", 9000));
            }
        };
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.CONNECT_ERROR_NO_HOSTNAME){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters(ClientTest.DEFAULT_CREDENTIAL, ClientTest.DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", null, 9000));
            }
        };
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.CONNECT_ERROR_NO_HOSTNAME){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters(ClientTest.DEFAULT_CREDENTIAL, ClientTest.DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", "  ", 9000));
            }
        };
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.CONNECT_ERROR_INVALID_PORT, new Object[]{-1}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters(ClientTest.DEFAULT_CREDENTIAL, ClientTest.DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", "localhost", -1));
            }
        };
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.CONNECT_ERROR_INVALID_PORT, new Object[]{65536}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)new ClientParameters(ClientTest.DEFAULT_CREDENTIAL, ClientTest.DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", "localhost", 65536));
            }
        };
        final ClientParameters noServerAtPort = new ClientParameters(DEFAULT_CREDENTIAL, DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", "localhost", 9001);
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[]{noServerAtPort.getURL(), noServerAtPort.getUsername(), "localhost", 9001}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)noServerAtPort);
            }
        };
        final ClientParameters parameters = new ClientParameters(DEFAULT_CREDENTIAL, "game".toCharArray(), "tcp://localhost:61616", "localhost", 9000);
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[]{parameters.getURL(), parameters.getUsername(), "localhost", 9000}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)parameters);
            }
        };
        final ClientParameters wrongPort = new ClientParameters(parameters.getUsername(), DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61617", "localhost", 9000);
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[]{wrongPort.getURL(), wrongPort.getUsername(), "localhost", 9000}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)wrongPort);
            }
        };
        final ClientParameters nullPass = new ClientParameters(parameters.getUsername(), null, "tcp://localhost:61616", "localhost", 9000);
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[]{nullPass.getURL(), nullPass.getUsername(), "localhost", 9000}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)nullPass);
            }
        };
        final ClientParameters incompatVersions = new ClientParameters(MockAuthenticator.VERSION_MISMATCH_USER, DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", "localhost", 9000);
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_INCOMPATIBLE_DIRECT, new Object[]{ClientVersion.APP_ID, MockAuthenticator.VERSION_MISMATCH_SERVER_VERSION}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)incompatVersions);
            }
        };
        final ClientParameters emptyPass = new ClientParameters(parameters.getUsername(), "  ".toCharArray(), "tcp://localhost:61616", "localhost", 9000);
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[]{emptyPass.getURL(), emptyPass.getUsername(), "localhost", 9000}){

            protected void run() throws Exception {
                ClientManager.init((ClientParameters)emptyPass);
            }
        };
    }

    @Test
    public void credentialsMatch() throws Exception {
        this.initClient();
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(null, null));
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(DEFAULT_CREDENTIAL, null));
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(null, DEFAULT_CREDENTIAL.toCharArray()));
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch("", DEFAULT_CREDENTIAL.toCharArray()));
        String otherUser = "you";
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(otherUser, DEFAULT_CREDENTIAL.toCharArray()));
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(DEFAULT_CREDENTIAL, "".toCharArray()));
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(DEFAULT_CREDENTIAL, otherUser.toCharArray()));
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(otherUser, otherUser.toCharArray()));
        Assert.assertTrue((boolean)ClientManager.getInstance().isCredentialsMatch(DEFAULT_CREDENTIAL, DEFAULT_CREDENTIAL.toCharArray()));
        ClientParameters parms = new ClientParameters(otherUser, otherUser.toCharArray(), "tcp://localhost:61616", "localhost", 9000);
        ClientManager.getInstance().reconnect(parms);
        Assert.assertFalse((boolean)ClientManager.getInstance().isCredentialsMatch(DEFAULT_CREDENTIAL, DEFAULT_CREDENTIAL.toCharArray()));
        Assert.assertTrue((boolean)ClientManager.getInstance().isCredentialsMatch(otherUser, otherUser.toCharArray()));
    }

    @Test
    public void webServices() throws Exception {
        this.initClient();
        List ds = this.getClient().getBrokersStatus().getBrokers();
        Assert.assertEquals((long)2L, (long)ds.size());
        BrokerStatus d = (BrokerStatus)ds.get(0);
        Assert.assertEquals((Object)"N1", (Object)d.getName());
        Assert.assertEquals((Object)"ID1", (Object)d.getId().getValue());
        d = (BrokerStatus)ds.get(1);
        Assert.assertEquals((Object)"N2", (Object)d.getName());
        Assert.assertEquals((Object)"ID2", (Object)d.getId().getValue());
        MockServiceImpl.sActive = false;
        UserID id = new UserID(2L);
        UserInfo info = this.getClient().getUserInfo(id, true);
        Assert.assertEquals((Object)"bob", (Object)info.getName());
        Assert.assertEquals((Object)id, (Object)info.getId());
        Assert.assertFalse((boolean)info.getActive());
        Assert.assertFalse((boolean)info.getSuperuser());
        Assert.assertNull((Object)info.getUserData());
        Assert.assertNull((Object)info.getSystemData());
        MockServiceImpl.sActive = true;
        Assert.assertFalse((boolean)this.getClient().getUserInfo(id, true).getActive());
        Assert.assertTrue((boolean)this.getClient().getUserInfo(id, false).getActive());
        Assert.assertTrue((boolean)this.getClient().getUserInfo(id, true).getActive());
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION){

            protected void run() throws Exception {
                ClientTest.this.getClient().getUserInfo(null, true);
            }
        };
        new ExpectedFailure<ConnectionException>((I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION){

            protected void run() throws Exception {
                ClientTest.this.getClient().getUserInfo(null, false);
            }
        };
        this.getClient().setUserData(null);
        Assert.assertNull((Object)this.getClient().getUserData());
        Properties userData = new Properties();
        this.getClient().setUserData(userData);
        Assert.assertNull((Object)this.getClient().getUserData());
        userData.setProperty("key1", "value1");
        userData.setProperty("key2", "value2");
        this.getClient().setUserData(userData);
        Assert.assertEquals((Object)userData, (Object)this.getClient().getUserData());
        Factory f = Factory.getInstance();
        BrokerID dID = new BrokerID("me");
        ExecutionReport er = new ExecutionReport();
        er.set(new OrigClOrdID("42"));
        OrderCancelReject ocr = new OrderCancelReject();
        ocr.set(new OrigClOrdID("43"));
        ExecutionReportImpl reportImpl = (ExecutionReportImpl)f.createExecutionReport((Message)er, dID, Originator.Server, null, null);
        ReportID reportID = new ReportID(1234L);
        ReportBaseImpl.assignReportID((ReportBaseImpl)reportImpl, (ReportID)reportID);
        OrderCancelRejectImpl reject = (OrderCancelRejectImpl)f.createOrderCancelReject((Message)ocr, dID, Originator.Server, null, null);
        ReportID rejectID = new ReportID(2345L);
        ReportBaseImpl.assignReportID((ReportBaseImpl)reject, (ReportID)rejectID);
        MockServiceImpl.sReports = new ReportBaseImpl[]{reportImpl, reject};
        ReportBase[] rs = this.getClient().getReportsSince(new Date());
        Assert.assertEquals((long)2L, (long)rs.length);
        org.marketcetera.trade.ExecutionReport report = (org.marketcetera.trade.ExecutionReport)rs[0];
        Assert.assertEquals((Object)dID, (Object)report.getBrokerID());
        Assert.assertEquals((Object)Originator.Server, (Object)report.getOriginator());
        Assert.assertEquals((Object)"42", (Object)report.getOriginalOrderID().getValue());
        Assert.assertEquals((Object)reportID, (Object)report.getReportID());
        org.marketcetera.trade.OrderCancelReject crreport = (org.marketcetera.trade.OrderCancelReject)rs[1];
        Assert.assertEquals((Object)dID, (Object)crreport.getBrokerID());
        Assert.assertEquals((Object)"43", (Object)crreport.getOriginalOrderID().getValue());
        Assert.assertEquals((Object)rejectID, (Object)crreport.getReportID());
        MockServiceImpl.sReports = new ReportBaseImpl[0];
        rs = this.getClient().getReportsSince(new Date());
        Assert.assertEquals((long)0L, (long)rs.length);
        MockServiceImpl.sReports = null;
        rs = this.getClient().getReportsSince(new Date());
        Assert.assertEquals((long)0L, (long)rs.length);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)this.getClient().getEquityPositionAsOf(new Date(10L), null));
        Assert.assertEquals(MockServiceImpl.POSITIONS, (Object)this.getClient().getAllEquityPositionsAsOf(new Date()));
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)this.getClient().getFuturePositionAsOf(new Date(10L), null));
        Assert.assertEquals(MockServiceImpl.FUTURES_POSITIONS, (Object)this.getClient().getAllFuturePositionsAsOf(new Date()));
        Option option = new Option("XYZ", "20101010", BigDecimal.TEN, OptionType.Call);
        Date date = new Date();
        Assert.assertEquals((Object)BigDecimal.TEN.add(BigDecimal.valueOf(date.getTime())), (Object)this.getClient().getOptionPositionAsOf(date, option));
        Map positions = this.getClient().getOptionPositionsAsOf(date, new String[]{"XYZ", "PQR"});
        Assert.assertEquals((long)2L, (long)positions.size());
        Assert.assertThat((Object)positions, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)PositionKeyFactory.createOptionKey((String)"XYZ", (String)option.getExpiry(), (BigDecimal)option.getStrikePrice(), (OptionType)option.getType(), (String)"acc", (String)"tra"), (Object)BigDecimal.valueOf(date.getTime())), Matchers.hasEntry((Object)PositionKeyFactory.createOptionKey((String)"PQR", (String)option.getExpiry(), (BigDecimal)option.getStrikePrice(), (OptionType)option.getType(), (String)"acc", (String)"tra"), (Object)BigDecimal.valueOf(date.getTime()))}));
        Assert.assertEquals((long)0L, (long)this.getClient().getOptionPositionsAsOf(date, new String[0]).size());
        positions = this.getClient().getAllOptionPositionsAsOf(date);
        Assert.assertEquals((long)1L, (long)positions.size());
        Assert.assertThat((Object)positions, (Matcher)Matchers.hasEntry((Object)PositionKeyFactory.createOptionKey((String)"OPT", (String)option.getExpiry(), (BigDecimal)option.getStrikePrice(), (OptionType)option.getType(), (String)"acc", (String)"tra"), (Object)BigDecimal.valueOf(date.getTime())));
        Assert.assertEquals(null, (Object)this.getClient().getUnderlying(null));
        Assert.assertEquals((Object)"", (Object)this.getClient().getUnderlying(""));
        String symbol = "symbol";
        String underlying = this.getClient().getUnderlying(symbol);
        Assert.assertEquals((Object)symbol, (Object)underlying);
        Assert.assertSame((Object)underlying, (Object)this.getClient().getUnderlying(symbol));
        Collection roots = this.getClient().getOptionRoots(null);
        Assert.assertEquals(null, (Object)roots);
        sServer.getServiceImpl().resetServiceInvoked();
        Assert.assertEquals(null, (Object)this.getClient().getOptionRoots(null));
        Assert.assertFalse((boolean)sServer.getServiceImpl().isServiceInvoked());
        roots = this.getClient().getOptionRoots("");
        Assert.assertEquals(null, (Object)roots);
        sServer.getServiceImpl().resetServiceInvoked();
        Assert.assertEquals(null, (Object)this.getClient().getOptionRoots(""));
        Assert.assertFalse((boolean)sServer.getServiceImpl().isServiceInvoked());
        roots = this.getClient().getOptionRoots(symbol);
        Assert.assertEquals((long)symbol.length(), (long)roots.size());
        Assert.assertThat((Object)roots, (Matcher)Matchers.hasItem((Object)symbol));
        sServer.getServiceImpl().resetServiceInvoked();
        Assert.assertSame((Object)roots, (Object)this.getClient().getOptionRoots(symbol));
        Assert.assertFalse((boolean)sServer.getServiceImpl().isServiceInvoked());
        this.getClient().reconnect();
        sServer.getServiceImpl().resetServiceInvoked();
        Assert.assertNotSame((Object)underlying, (Object)this.getClient().getUnderlying(symbol));
        Assert.assertTrue((boolean)sServer.getServiceImpl().isServiceInvoked());
        sServer.getServiceImpl().resetServiceInvoked();
        Assert.assertNotSame((Object)roots, (Object)this.getClient().getOptionRoots(symbol));
        Assert.assertTrue((boolean)sServer.getServiceImpl().isServiceInvoked());
    }

    @Test(timeout=60000L)
    public void heartbeats() throws Exception {
        this.initClient(2000);
        Assert.assertTrue((boolean)this.getClient().isServerAlive());
        int count = sServer.getServiceImpl().getHeartbeatCount();
        do {
            Thread.sleep(4000L);
            Assert.assertTrue((boolean)this.getClient().isServerAlive());
        } while (sServer.getServiceImpl().getHeartbeatCount() <= count);
        count = sServer.getServiceImpl().getHeartbeatCount();
        this.closeClient();
        Assert.assertFalse((boolean)this.getClient().isServerAlive());
        Thread.sleep(6000L);
        Assert.assertTrue((sServer.getServiceImpl().getHeartbeatCount() <= count + 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.getClient().isServerAlive());
    }

    @Test
    public void sendOrderSingle() throws Exception {
        this.initClient();
        for (int i = 0; i < 5; ++i) {
            OrderSingle order = Factory.getInstance().createOrderSingle();
            order.setAccount("my account");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("101", "value1");
            map.put("201", "value2");
            order.setCustomFields(map);
            order.setBrokerID(new BrokerID("brokerA"));
            order.setOrderID(new OrderID("ord1"));
            order.setOrderType(OrderType.Limit);
            order.setPrice(new BigDecimal("83.43"));
            order.setQuantity(new BigDecimal("823.443"));
            order.setSide(Side.Buy);
            order.setInstrument((Instrument)new Equity("IBM"));
            order.setTimeInForce(TimeInForce.AtTheClose);
            org.marketcetera.trade.ExecutionReport report = ClientTest.createExecutionReport();
            sServer.getHandler().addToSend(report);
            this.getClient().sendOrder(order);
            if (this.mListener.getException() != null) {
                SLF4JLoggerProxy.error((Object)((Object)this), (String)"Unexpected exception", (Throwable)this.mListener.getException());
            }
            Assert.assertNull((Object)this.mListener.getException());
            Object received = sServer.getHandler().removeReceived();
            Assert.assertNotNull((Object)received);
            Assert.assertTrue((boolean)(received instanceof OrderEnvelope));
            Assert.assertEquals((Object)((ClientImpl)this.getClient()).getSessionId(), (Object)((OrderEnvelope)received).getSessionId());
            received = ((OrderEnvelope)received).getOrder();
            Assert.assertTrue((boolean)(received instanceof OrderSingle));
            TypesTestBase.assertOrderSingleEquals((OrderSingle)order, (OrderSingle)((OrderSingle)received));
            ReportBase receivedReport = this.mReplies.getReport();
            Assert.assertTrue((boolean)(receivedReport instanceof org.marketcetera.trade.ExecutionReport));
            TypesTestBase.assertExecReportEquals((org.marketcetera.trade.ExecutionReport)report, (org.marketcetera.trade.ExecutionReport)((org.marketcetera.trade.ExecutionReport)receivedReport));
        }
    }

    @Test
    public void sendOrderReplace() throws Exception {
        this.initClient();
        for (int i = 0; i < 5; ++i) {
            OrderReplace order = ClientTest.createOrderReplace();
            org.marketcetera.trade.ExecutionReport report = ClientTest.createExecutionReport();
            sServer.getHandler().addToSend(report);
            this.getClient().sendOrder(order);
            if (this.mListener.getException() != null) {
                SLF4JLoggerProxy.error((Object)((Object)this), (String)"Unexpected exception", (Throwable)this.mListener.getException());
            }
            Assert.assertNull((Object)this.mListener.getException());
            Object received = sServer.getHandler().removeReceived();
            Assert.assertNotNull((Object)received);
            Assert.assertTrue((boolean)(received instanceof OrderEnvelope));
            Assert.assertEquals((Object)((ClientImpl)this.getClient()).getSessionId(), (Object)((OrderEnvelope)received).getSessionId());
            received = ((OrderEnvelope)received).getOrder();
            Assert.assertTrue((boolean)(received instanceof OrderReplace));
            TypesTestBase.assertOrderReplaceEquals((OrderReplace)order, (OrderReplace)((OrderReplace)received));
            ReportBase receivedReport = this.mReplies.getReport();
            Assert.assertTrue((boolean)(receivedReport instanceof org.marketcetera.trade.ExecutionReport));
            TypesTestBase.assertExecReportEquals((org.marketcetera.trade.ExecutionReport)report, (org.marketcetera.trade.ExecutionReport)((org.marketcetera.trade.ExecutionReport)receivedReport));
        }
    }

    @Test
    public void sendOrderCancel() throws Exception {
        this.initClient();
        for (int i = 0; i < 5; ++i) {
            OrderCancel order = ClientTest.createOrderCancel();
            org.marketcetera.trade.OrderCancelReject report = ClientTest.createCancelReject();
            sServer.getHandler().addToSend(report);
            this.getClient().sendOrder(order);
            if (this.mListener.getException() != null) {
                SLF4JLoggerProxy.error((Object)((Object)this), (String)"Unexpected exception", (Throwable)this.mListener.getException());
            }
            Assert.assertNull((Object)this.mListener.getException());
            Object received = sServer.getHandler().removeReceived();
            Assert.assertNotNull((Object)received);
            Assert.assertTrue((boolean)(received instanceof OrderEnvelope));
            Assert.assertEquals((Object)((ClientImpl)this.getClient()).getSessionId(), (Object)((OrderEnvelope)received).getSessionId());
            received = ((OrderEnvelope)received).getOrder();
            Assert.assertTrue((boolean)(received instanceof OrderCancel));
            TypesTestBase.assertOrderCancelEquals((OrderCancel)order, (OrderCancel)((OrderCancel)received));
            ReportBase receivedReport = this.mReplies.getReport();
            Assert.assertTrue((boolean)(receivedReport instanceof org.marketcetera.trade.OrderCancelReject));
            TypesTestBase.assertCancelRejectEquals((org.marketcetera.trade.OrderCancelReject)report, (org.marketcetera.trade.OrderCancelReject)((org.marketcetera.trade.OrderCancelReject)receivedReport));
        }
    }

    @Test
    public void sendAnyGetFIXResponse() throws Exception {
        this.initClient();
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        String category = ClientImpl.TradeMessageReceiver.class.getName();
        ClientTest.setDefaultLevel((Level)Level.OFF);
        ClientTest.setLevel((String)category, (Level)Level.WARN);
        this.getAppender().clear();
        for (int i = 0; i < 5; ++i) {
            FIXResponse response = ClientTest.createFIXResponse();
            sServer.getHandler().addToSend(response);
            this.getClient().sendOrderRaw(ClientTest.createOrderFIX());
            Thread.sleep(5000L);
            Assert.assertNull((Object)this.mReplies.peekReport());
            this.assertSingleEvent(Level.WARN, category, "Received a fix report that was neither an execution report nor an order cancel reject: '" + response.toString() + "'. Client applications do " + "not yet support this message type, so it was not forwarded " + "to the application or its embedded strategies.", category);
        }
    }

    @Test
    public void sendOrderFIX() throws Exception {
        this.initClient();
        for (int i = 0; i < 5; ++i) {
            FIXOrder order = ClientTest.createOrderFIX();
            org.marketcetera.trade.ExecutionReport report = ClientTest.createExecutionReport();
            sServer.getHandler().addToSend(report);
            this.getClient().sendOrderRaw(order);
            if (this.mListener.getException() != null) {
                SLF4JLoggerProxy.error((Object)((Object)this), (String)"Unexpected exception", (Throwable)this.mListener.getException());
            }
            Assert.assertNull((Object)this.mListener.getException());
            Object received = sServer.getHandler().removeReceived();
            Assert.assertNotNull((Object)received);
            Assert.assertTrue((boolean)(received instanceof OrderEnvelope));
            Assert.assertEquals((Object)((ClientImpl)this.getClient()).getSessionId(), (Object)((OrderEnvelope)received).getSessionId());
            received = ((OrderEnvelope)received).getOrder();
            Assert.assertTrue((boolean)(received instanceof FIXOrder));
            TypesTestBase.assertOrderFIXEquals((FIXOrder)order, (FIXOrder)((FIXOrder)received));
            ReportBase receivedReport = this.mReplies.getReport();
            Assert.assertTrue((boolean)(receivedReport instanceof org.marketcetera.trade.ExecutionReport));
            TypesTestBase.assertExecReportEquals((org.marketcetera.trade.ExecutionReport)report, (org.marketcetera.trade.ExecutionReport)((org.marketcetera.trade.ExecutionReport)receivedReport));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reportListening() throws Exception {
        this.initClient();
        ReplyListener chitChat = new ReplyListener();
        this.getClient().addReportListener((ReportListener)chitChat);
        try {
            org.marketcetera.trade.ExecutionReport report = this.sendVanillaOrder();
            ReportBase receivedReport = chitChat.getReport();
            Assert.assertTrue((boolean)(receivedReport instanceof org.marketcetera.trade.ExecutionReport));
            TypesTestBase.assertExecReportEquals((org.marketcetera.trade.ExecutionReport)report, (org.marketcetera.trade.ExecutionReport)((org.marketcetera.trade.ExecutionReport)receivedReport));
            chitChat.setFail(true);
            report = this.sendVanillaOrder();
            receivedReport = chitChat.getReport();
            Assert.assertTrue((boolean)(receivedReport instanceof org.marketcetera.trade.ExecutionReport));
            TypesTestBase.assertExecReportEquals((org.marketcetera.trade.ExecutionReport)report, (org.marketcetera.trade.ExecutionReport)((org.marketcetera.trade.ExecutionReport)receivedReport));
            this.getClient().removeReportListener((ReportListener)chitChat);
            chitChat.clear();
            Assert.assertNull((Object)chitChat.peekReport());
            this.sendVanillaOrder();
            Assert.assertNull((Object)chitChat.peekReport());
        }
        finally {
            this.getClient().removeReportListener((ReportListener)chitChat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void statusListening() throws Exception {
        this.initClient();
        BrokerStatusReplyListener chitChat = new BrokerStatusReplyListener();
        this.getClient().addBrokerStatusListener((BrokerStatusListener)chitChat);
        try {
            BrokerStatus status = this.triggerBrokerStatus();
            BrokerStatus receivedStatus = chitChat.getStatus();
            Assert.assertEquals((Object)status.toString(), (Object)receivedStatus.toString());
            chitChat.setFail(true);
            status = this.triggerBrokerStatus();
            receivedStatus = chitChat.getStatus();
            Assert.assertEquals((Object)status.toString(), (Object)receivedStatus.toString());
            this.getClient().removeBrokerStatusListener((BrokerStatusListener)chitChat);
            chitChat.clear();
            Assert.assertNull((Object)chitChat.peekStatus());
            this.triggerBrokerStatus();
            Assert.assertNull((Object)chitChat.peekStatus());
        }
        finally {
            this.getClient().removeBrokerStatusListener((BrokerStatusListener)chitChat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void serverListening() throws Exception {
        this.initClient(60000);
        ServerStatusReplyListener chitChat = new ServerStatusReplyListener();
        this.getClient().addServerStatusListener((ServerStatusListener)chitChat);
        try {
            boolean status = this.triggerServerStatus();
            boolean receivedStatus = chitChat.getStatus();
            Assert.assertEquals((Object)status, (Object)receivedStatus);
            chitChat.setFail(true);
            status = this.triggerServerStatus();
            receivedStatus = chitChat.getStatus();
            Assert.assertEquals((Object)status, (Object)receivedStatus);
            this.getClient().removeServerStatusListener((ServerStatusListener)chitChat);
            chitChat.clear();
            Assert.assertNull((Object)chitChat.peekStatus());
            this.triggerServerStatus();
            Assert.assertNull((Object)chitChat.peekStatus());
        }
        finally {
            this.getClient().removeServerStatusListener((ServerStatusListener)chitChat);
        }
    }

    @Test
    public void closedBehavior() throws Exception {
        this.initClient();
        final Client client = ClientManager.getInstance();
        client.close();
        String expectedMsg = Messages.CLIENT_CLOSED.getText();
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.addExceptionListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.addBrokerStatusListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.addServerStatusListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.addReportListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getLastConnectTime();
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getParameters();
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getEquityPositionAsOf(null, null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getAllEquityPositionsAsOf(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getReportsSince(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getBrokersStatus();
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getUserInfo(null, true);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getOptionPositionAsOf(null, null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getAllOptionPositionsAsOf(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getOptionPositionsAsOf(null, new String[]{"symbol"});
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getUnderlying(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.getOptionRoots(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.reconnect();
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.reconnect(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.removeExceptionListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.removeReportListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.removeServerStatusListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.removeBrokerStatusListener(null);
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.sendOrder(ClientTest.createOrderSingle());
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.sendOrder(ClientTest.createOrderReplace());
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.sendOrder(ClientTest.createOrderCancel());
            }
        };
        new ExpectedFailure<IllegalStateException>(expectedMsg){

            protected void run() throws Exception {
                client.sendOrderRaw(ClientTest.createOrderFIX());
            }
        };
        client.close();
    }

    private org.marketcetera.trade.ExecutionReport sendVanillaOrder() throws Exception {
        this.clearAll();
        org.marketcetera.trade.ExecutionReport report = ClientTest.createExecutionReport();
        if (sServer != null) {
            sServer.getHandler().addToSend(report);
        }
        this.getClient().sendOrder(ClientTest.createOrderReplace());
        if (this.mListener.getException() != null) {
            SLF4JLoggerProxy.error((Object)((Object)this), (String)"Unexpected exception", (Throwable)this.mListener.getException());
        }
        Assert.assertNull((Object)this.mListener.getException());
        ReportBase receivedReport = this.mReplies.getReport();
        Assert.assertTrue((boolean)(receivedReport instanceof org.marketcetera.trade.ExecutionReport));
        TypesTestBase.assertExecReportEquals((org.marketcetera.trade.ExecutionReport)report, (org.marketcetera.trade.ExecutionReport)((org.marketcetera.trade.ExecutionReport)receivedReport));
        return report;
    }

    private BrokerStatus triggerBrokerStatus() throws Exception {
        this.clearAll();
        BrokerStatus status = new BrokerStatus("me", new BrokerID("myID"), true);
        sServer.getHandler().addToSendStatus(status);
        sServer.getStatusSender().convertAndSend((Object)status);
        BrokerStatus receivedStatus = this.mBrokerStatusReplies.getStatus();
        Assert.assertEquals((Object)status.toString(), (Object)receivedStatus.toString());
        return status;
    }

    private boolean triggerServerStatus() throws Exception {
        this.clearAll();
        boolean status = sServer.getServiceImpl().toggleServerStatus();
        Thread.sleep(4000L);
        boolean receivedStatus = this.mServerStatusReplies.getStatus();
        Assert.assertEquals((Object)status, (Object)receivedStatus);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionListening() throws Exception {
        this.initClient();
        ErrorListener earl = new ErrorListener();
        this.getClient().addExceptionListener((ExceptionListener)earl);
        try {
            this.sendVanillaOrder();
            Assert.assertNull((Object)earl.getException());
            Method m = this.getClient().getClass().getDeclaredMethod("internalClose", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this.getClient(), new Object[0]);
            ConnectionException exception = (ConnectionException)new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_SEND_MESSAGE, new Object[0]){

                protected void run() throws Exception {
                    ClientTest.this.sendVanillaOrder();
                }
            }.getException();
            Assert.assertEquals((Object)exception, (Object)earl.getException());
            Assert.assertEquals((Object)exception, (Object)this.mListener.getException());
            earl.setFail(true);
            exception = (ConnectionException)new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_SEND_MESSAGE, new Object[0]){

                protected void run() throws Exception {
                    ClientTest.this.sendVanillaOrder();
                }
            }.getException();
            Assert.assertEquals((Object)exception, (Object)earl.getException());
            Assert.assertEquals((Object)exception, (Object)this.mListener.getException());
            this.getClient().removeExceptionListener((ExceptionListener)earl);
            earl.clear();
            exception = (ConnectionException)new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_SEND_MESSAGE, new Object[0]){

                protected void run() throws Exception {
                    ClientTest.this.sendVanillaOrder();
                }
            }.getException();
            Assert.assertNull((Object)earl.getException());
            Assert.assertEquals((Object)exception, (Object)this.mListener.getException());
        }
        finally {
            this.getClient().removeExceptionListener((ExceptionListener)earl);
        }
    }

    @Test
    public void lifecycle() throws Exception {
        this.initClient();
        Assert.assertTrue((boolean)ClientManager.isInitialized());
        new ExpectedFailure<ClientInitException>((I18NBoundMessage)Messages.CLIENT_ALREADY_INITIALIZED){

            protected void run() throws Exception {
                ClientTest.this.initClient();
            }
        };
        this.closeClient();
        Assert.assertFalse((boolean)ClientManager.isInitialized());
        this.initClient();
        Assert.assertTrue((boolean)ClientManager.isInitialized());
        ClientTest.closeServer();
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[0]){

            protected void run() throws Exception {
                ClientTest.this.getClient().reconnect();
            }
        };
        Assert.assertTrue((boolean)ClientManager.isInitialized());
        new ExpectedFailure<ClientInitException>((I18NBoundMessage)Messages.CLIENT_ALREADY_INITIALIZED){

            protected void run() throws Exception {
                ClientTest.this.initClient();
            }
        };
        this.closeClient();
        Assert.assertFalse((boolean)ClientManager.isInitialized());
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[0]){

            protected void run() throws Exception {
                ClientTest.this.initClient();
            }
        };
        Assert.assertFalse((boolean)ClientManager.isInitialized());
        ClientTest.initServer();
        this.initClient();
        Assert.assertTrue((boolean)ClientManager.isInitialized());
    }

    @Test
    public void reconnect() throws Exception {
        this.initClient();
        Date connectTime = this.getClient().getLastConnectTime();
        this.sendVanillaOrder();
        Thread.sleep(100L);
        this.getClient().reconnect();
        Assert.assertTrue((this.getClient().getLastConnectTime().compareTo(connectTime) > 0 ? 1 : 0) != 0);
        connectTime = this.getClient().getLastConnectTime();
        this.sendVanillaOrder();
        ClientTest.closeServer();
        ConnectionException exception = (ConnectionException)new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_SEND_MESSAGE, new Object[0]){

            protected void run() throws Exception {
                ClientTest.this.sendVanillaOrder();
            }
        }.getException();
        Assert.assertNotNull((Object)this.mListener.getException());
        Assert.assertEquals((Object)exception, (Object)this.mListener.getException());
        Assert.assertEquals((Object)connectTime, (Object)this.getClient().getLastConnectTime());
        new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_CONNECT_TO_SERVER, new Object[0]){

            protected void run() throws Exception {
                ClientTest.this.getClient().reconnect();
            }
        };
        Assert.assertEquals((Object)connectTime, (Object)this.getClient().getLastConnectTime());
        Assert.assertTrue((boolean)ClientManager.isInitialized());
        ClientTest.initServer();
        exception = (ConnectionException)new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_SEND_MESSAGE, new Object[0]){

            protected void run() throws Exception {
                ClientTest.this.sendVanillaOrder();
            }
        }.getException();
        Assert.assertEquals((Object)new ClientInitException((I18NBoundMessage)Messages.NOT_CONNECTED_TO_SERVER), (Object)exception.getCause());
        Assert.assertNotNull((Object)this.mListener.getException());
        Assert.assertEquals((Object)exception, (Object)this.mListener.getException());
        Thread.sleep(100L);
        this.getClient().reconnect();
        Assert.assertTrue((this.getClient().getLastConnectTime().compareTo(connectTime) > 0 ? 1 : 0) != 0);
        this.sendVanillaOrder();
    }

    @Test
    public void reconnectParameters() throws Exception {
        this.initClient();
        Date connectTime = this.getClient().getLastConnectTime();
        this.sendVanillaOrder();
        ClientParameters oldParms = this.getClient().getParameters();
        Thread.sleep(100L);
        ClientParameters parms = new ClientParameters("you", "you".toCharArray(), "tcp://localhost:61616", "localhost", 9000);
        this.getClient().reconnect(parms);
        ClientTest.assertCPEquals(parms, this.getClient().getParameters());
        Assert.assertFalse((boolean)oldParms.getUsername().equals(parms.getUsername()));
        Assert.assertTrue((this.getClient().getLastConnectTime().compareTo(connectTime) > 0 ? 1 : 0) != 0);
        this.sendVanillaOrder();
    }

    public static org.marketcetera.trade.ExecutionReport createExecutionReport() throws Exception {
        return Factory.getInstance().createExecutionReport(FIXVersion.FIX42.getMessageFactory().newExecutionReport("ord1", "clord" + sCounter.getAndIncrement(), "exec1", '0', '1', new BigDecimal("4343.49"), new BigDecimal("498.34"), new BigDecimal("783343.49"), new BigDecimal("598.34"), new BigDecimal("234343.49"), new BigDecimal("798.34"), (Instrument)new Equity("IBM"), "my acc", "some text"), new BrokerID("bro"), Originator.Broker, null, null);
    }

    public static org.marketcetera.trade.OrderCancelReject createCancelReject() throws Exception {
        return Factory.getInstance().createOrderCancelReject(FIXVersion.FIX42.getMessageFactory().newOrderCancelReject(new quickfix.field.OrderID("brok3"), new ClOrdID("clord" + sCounter.getAndIncrement()), new OrigClOrdID("origord1"), "what?", null), new BrokerID("bro"), Originator.Broker, null, null);
    }

    public static FIXResponse createFIXResponse() throws Exception {
        return Factory.getInstance().createFIXResponse(FIXVersion.FIX42.getMessageFactory().newBusinessMessageReject("QQ", 3, "Bad message type"), new BrokerID("bro"), Originator.Broker, null, null);
    }

    public static OrderSingle createOrderSingle() {
        OrderSingle order = Factory.getInstance().createOrderSingle();
        order.setOrderType(OrderType.Limit);
        order.setPrice(new BigDecimal("834.34"));
        order.setQuantity(new BigDecimal("833.343"));
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("IBN"));
        return order;
    }

    public static OrderReplace createOrderReplace() throws Exception {
        OrderReplace order = Factory.getInstance().createOrderReplace(ClientTest.createExecutionReport());
        order.setOrderType(OrderType.Limit);
        return order;
    }

    public static OrderCancel createOrderCancel() throws Exception {
        return Factory.getInstance().createOrderCancel(ClientTest.createExecutionReport());
    }

    public static FIXOrder createOrderFIX() throws MessageCreationException {
        return Factory.getInstance().createOrder(FIXVersion.FIX42.getMessageFactory().newLimitOrder("clOrd1", '1', new BigDecimal("8934.234"), (Instrument)new Equity("IBM"), new BigDecimal("9834.23"), '0', "no"), new BrokerID("bro"));
    }

    static void assertCPEquals(ClientParameters inParms1, ClientParameters inParms2) {
        Assert.assertEquals((Object)inParms1.getHostname(), (Object)inParms2.getHostname());
        Assert.assertEquals((Object)inParms1.getIDPrefix(), (Object)inParms2.getIDPrefix());
        Assert.assertEquals((long)inParms1.getPort(), (long)inParms2.getPort());
        Assert.assertEquals((Object)inParms1.getURL(), (Object)inParms2.getURL());
        Assert.assertEquals((Object)inParms1.getUsername(), (Object)inParms2.getUsername());
    }

    private void clearAll() {
        this.mListener.clear();
        this.mReplies.clear();
        this.mBrokerStatusReplies.clear();
        this.mServerStatusReplies.clear();
        if (sServer != null) {
            sServer.getHandler().clear();
        }
    }

    private Client getClient() {
        if (this.mClient == null) {
            throw new NullPointerException("Call initClient() first");
        }
        return this.mClient;
    }

    private void initClient(int heartbeatInterval) throws ConnectionException, ClientInitException {
        Date currentTime = new Date();
        ClientParameters parameters = new ClientParameters(DEFAULT_CREDENTIAL, DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", "localhost", 9000, null, heartbeatInterval);
        ClientManager.init((ClientParameters)parameters);
        this.mClient = ClientManager.getInstance();
        this.mClient.addExceptionListener((ExceptionListener)this.mListener);
        this.mClient.addReportListener((ReportListener)this.mReplies);
        this.mClient.addBrokerStatusListener((BrokerStatusListener)this.mBrokerStatusReplies);
        this.mClient.addServerStatusListener((ServerStatusListener)this.mServerStatusReplies);
        ClientTest.assertCPEquals(parameters, this.mClient.getParameters());
        Assert.assertNotNull((Object)this.mClient.getLastConnectTime());
        Assert.assertTrue((this.mClient.getLastConnectTime().compareTo(currentTime) >= 0 ? 1 : 0) != 0);
    }

    private void initClient() throws ConnectionException, ClientInitException {
        this.initClient(60000);
    }

    private static void initServer() {
        if (sServer == null) {
            sServer = new MockServer();
        }
    }

    static {
        sCounter = new AtomicLong();
    }

    private static class ServerStatusReplyListener
    implements ServerStatusListener {
        private boolean mFail = false;
        private BlockingQueue<Boolean> mStatus = new LinkedBlockingQueue<Boolean>();

        private ServerStatusReplyListener() {
        }

        public void receiveServerStatus(boolean inStatus) {
            this.mStatus.add(inStatus);
            if (this.mFail) {
                throw new IllegalArgumentException("Test Failure");
            }
        }

        public Boolean getStatus() throws InterruptedException {
            return this.mStatus.take();
        }

        public Boolean peekStatus() {
            return (Boolean)this.mStatus.peek();
        }

        public void setFail(boolean isFail) {
            this.mFail = isFail;
        }

        public void clear() {
            this.mStatus.clear();
            this.mFail = false;
        }
    }

    private static class BrokerStatusReplyListener
    implements BrokerStatusListener {
        private boolean mFail = false;
        private BlockingQueue<BrokerStatus> mStatus = new LinkedBlockingQueue<BrokerStatus>();

        private BrokerStatusReplyListener() {
        }

        public void receiveBrokerStatus(BrokerStatus inStatus) {
            this.mStatus.add(inStatus);
            if (this.mFail) {
                throw new IllegalArgumentException("Test Failure");
            }
        }

        public BrokerStatus getStatus() throws InterruptedException {
            return this.mStatus.take();
        }

        public BrokerStatus peekStatus() {
            return (BrokerStatus)this.mStatus.peek();
        }

        public void setFail(boolean isFail) {
            this.mFail = isFail;
        }

        public void clear() {
            this.mStatus.clear();
            this.mFail = false;
        }
    }

    private static class ReplyListener
    implements ReportListener {
        private boolean mFail = false;
        private BlockingQueue<ReportBase> mReports = new LinkedBlockingQueue<ReportBase>();

        private ReplyListener() {
        }

        public void receiveExecutionReport(org.marketcetera.trade.ExecutionReport inReport) {
            this.mReports.add((ReportBase)inReport);
            if (this.mFail) {
                throw new IllegalArgumentException("Test Failure");
            }
        }

        public void receiveCancelReject(org.marketcetera.trade.OrderCancelReject inReport) {
            this.mReports.add((ReportBase)inReport);
            if (this.mFail) {
                throw new IllegalArgumentException("Test Failure");
            }
        }

        public ReportBase getReport() throws InterruptedException {
            return this.mReports.take();
        }

        public ReportBase peekReport() {
            return (ReportBase)this.mReports.peek();
        }

        public void setFail(boolean isFail) {
            this.mFail = isFail;
        }

        public void clear() {
            this.mReports.clear();
            this.mFail = false;
        }
    }

    private static class ErrorListener
    implements ExceptionListener {
        private boolean mFail = false;
        private Exception mException;

        private ErrorListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            SLF4JLoggerProxy.debug((Object)this, (Throwable)e);
            this.mException = e;
            if (this.mFail) {
                throw new IllegalArgumentException("Test Failure");
            }
        }

        public Exception getException() {
            return this.mException;
        }

        public void clear() {
            this.mException = null;
            this.mFail = false;
        }

        public void setFail(boolean isFail) {
            this.mFail = isFail;
        }
    }
}

