/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.xml.bind.JAXBException;
import org.marketcetera.client.MockAuthenticator;
import org.marketcetera.client.MockMessageHandler;
import org.marketcetera.client.MockServiceImpl;
import org.marketcetera.client.MockSessionFactory;
import org.marketcetera.client.Service;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.core.FIXVersionTestSuite;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.quickfix.FIXFieldConverterNotAvailable;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.Originator;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.Server;
import org.marketcetera.util.ws.stateful.SessionFactory;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.ServiceInterface;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Message;

@ClassVersion(value="$Id: MockServer.java 16154 2012-07-14 16:34:05Z colin $")
public class MockServer {
    public static final String URL = "tcp://localhost:61616";
    private final ClassPathXmlApplicationContext mContext = new ClassPathXmlApplicationContext("mock_server.xml");
    private Server<?> mServer;
    private ServiceInterface mServiceInterface;
    private MockServiceImpl mServiceImpl;
    private MockMessageHandler mHandler;
    private SimpleMessageListenerContainer mOrderEnvelopeListener;
    private JmsTemplate mStatusSender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, FIXFieldConverterNotAvailable {
        File msgFile;
        LoggerConfiguration.logSetup();
        FIXVersionTestSuite.initializeFIXDataDictionaryManager((FIXVersion[])FIXVersionTestSuite.ALL_FIX_VERSIONS);
        MockServer ms = new MockServer();
        if (args.length > 0 && (msgFile = new File(args[0])).canRead()) {
            SLF4JLoggerProxy.debug(MockServer.class, (String)"Reading messages from file {}", (Object[])new Object[]{msgFile.getAbsolutePath()});
            ms.readMessagesFromFile(msgFile);
        }
        MockServer mockServer = ms;
        synchronized (mockServer) {
            ms.wait();
        }
        ms.close();
    }

    public MockServer() {
        this.mContext.registerShutdownHook();
        this.mContext.start();
        this.mHandler = new MockMessageHandler();
        JmsManager jmsMgr = new JmsManager((ConnectionFactory)this.mContext.getBean("metc_connection_factory_in"), (ConnectionFactory)this.mContext.getBean("metc_connection_factory_out"));
        try {
            this.mOrderEnvelopeListener = jmsMgr.getIncomingJmsFactory().registerHandlerOEX((ReceiveOnlyHandler)this.mHandler, "ors-commands", false);
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Cannot initialize request queue listener", ex);
        }
        try {
            this.mStatusSender = jmsMgr.getOutgoingJmsFactory().createJmsTemplateX("ors-broker-status", true);
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Cannot initialize broker status sender", ex);
        }
        SessionManager sessionManager = new SessionManager((SessionFactory)new MockSessionFactory(jmsMgr, this.mHandler));
        this.mServer = new Server((Authenticator)new MockAuthenticator(), sessionManager);
        this.mServiceImpl = new MockServiceImpl((SessionManager<Object>)sessionManager);
        this.mServiceInterface = this.mServer.publish((StatelessServiceBase)this.mServiceImpl, Service.class);
    }

    public void close() {
        this.mOrderEnvelopeListener.shutdown();
        this.mContext.close();
        this.mServiceInterface.stop();
        this.mServer.stop();
    }

    MockServiceImpl getServiceImpl() {
        return this.mServiceImpl;
    }

    public ClassPathXmlApplicationContext getContext() {
        return this.mContext;
    }

    public MockMessageHandler getHandler() {
        return this.mHandler;
    }

    public JmsTemplate getStatusSender() {
        return this.mStatusSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessagesFromFile(File inFile) {
        BufferedReader reader = null;
        LinkedList<Message> messages = new LinkedList<Message>();
        try {
            String line;
            reader = new BufferedReader(new FileReader(inFile));
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                try {
                    messages.add(new Message(line));
                }
                catch (InvalidMessage e) {
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Ignoring Error @ line {} from message {}", (Object[])new Object[]{lineNumber, line});
                }
                ++lineNumber;
            }
            this.sortAndAddMessages(messages);
        }
        catch (IOException e) {
            SLF4JLoggerProxy.warn((Object)this, (String)"Ignoring Error", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    SLF4JLoggerProxy.warn((Object)this, (String)"Ignoring Error", (Throwable)e);
                }
            }
        }
    }

    private void sortAndAddMessages(List<Message> inMessages) {
        Collections.sort(inMessages, new Comparator<Message>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int compare(Message o1, Message o2) {
                try {
                    if (o1.isSetField(11) && o2.isSetField(11)) {
                        String s2;
                        String s1 = o1.getString(11);
                        if (!s1.equals(s2 = o2.getString(11))) return s1.compareTo(s2);
                        if (o1.isSetField(39) && o2.isSetField(39)) {
                            int c2;
                            int c1 = o1.getChar(39);
                            if (c1 == (c2 = o2.getChar(39))) {
                                if (o1.getHeader().isSetField(34) && o2.getHeader().isSetField(34)) {
                                    int i1 = o1.getHeader().getInt(34);
                                    int i2 = o2.getHeader().getInt(34);
                                    return i1 - i2;
                                }
                            } else {
                                if (c1 == 65) {
                                    c1 = 47;
                                }
                                if (c2 != 65) return c1 - c2;
                                c2 = 47;
                                return c1 - c2;
                            }
                        }
                    }
                    if (o1.getHeader().isSetField(52) && o2.getHeader().isSetField(52)) {
                        Date d1 = o1.getHeader().getUtcTimeStamp(52);
                        Date d2 = o2.getHeader().getUtcTimeStamp(52);
                        return d1.compareTo(d2);
                    }
                }
                catch (FieldNotFound fieldNotFound) {
                    // empty catch block
                }
                SLF4JLoggerProxy.error((Object)this, (String)"Message comparison failure:{} AND {}", (Object[])new Object[]{o1, o2});
                return 0;
            }
        });
        for (Message message : inMessages) {
            try {
                if (FIXMessageUtil.isExecutionReport((Message)message)) {
                    this.getHandler().addToSend(Factory.getInstance().createExecutionReport(message, new BrokerID("default"), Originator.Server, null, null));
                    continue;
                }
                if (FIXMessageUtil.isCancelReject((Message)message)) {
                    this.getHandler().addToSend(Factory.getInstance().createOrderCancelReject(message, new BrokerID("default"), Originator.Server, null, null));
                    continue;
                }
                this.getHandler().addToSend(Factory.getInstance().createFIXResponse(message, new BrokerID("default"), Originator.Server, null, null));
            }
            catch (MessageCreationException e) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Ignoring Error", (Throwable)e);
            }
        }
    }
}

