/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import javax.management.JMX;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientModuleFactory;
import org.marketcetera.client.ClientModuleMXBean;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.Messages;
import org.marketcetera.client.MockConfigurationProvider;
import org.marketcetera.client.MockServer;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.ModuleConfigurationProvider;
import org.marketcetera.module.ModuleCreationException;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ModuleFailuresTest.java 16154 2012-07-14 16:34:05Z colin $")
public class ModuleFailuresTest
extends ModuleTestBase {
    @BeforeClass
    public static void setup() {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void createModuleFailures() throws Exception {
        MockConfigurationProvider provider = new MockConfigurationProvider();
        provider.setURL("tcp://localhost:61616");
        final ModuleManager m1 = new ModuleManager();
        m1.setConfigurationProvider((ModuleConfigurationProvider)provider);
        new ExpectedFailure<ModuleCreationException>((I18NBoundMessage)Messages.CREATE_MODULE_ERROR){

            protected void run() throws Exception {
                m1.init();
            }
        };
        m1.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void moduleOperationFailures() throws Exception {
        String username = "u";
        MockServer mockServer = null;
        try {
            mockServer = new MockServer();
            ClientManager.init((ClientParameters)new ClientParameters(username, username.toCharArray(), "tcp://localhost:61616", "localhost", 9000));
            ModuleManager manager = new ModuleManager();
            manager.init();
            ModuleFailuresTest.assertModuleInfo((ModuleManager)manager, (ModuleURN)ClientModuleFactory.INSTANCE_URN, (ModuleState)ModuleState.STARTED, null, null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
            final ClientModuleMXBean instance = JMX.newMXBeanProxy(ModuleFailuresTest.getMBeanServer(), ClientModuleFactory.INSTANCE_URN.toObjectName(), ClientModuleMXBean.class);
            ClientManager.getInstance().close();
            new ExpectedFailure<RuntimeException>(Messages.CLIENT_NOT_INITIALIZED.getText()){

                protected void run() throws Exception {
                    instance.getLastConnectTime();
                }
            };
            new ExpectedFailure<RuntimeException>(Messages.CLIENT_NOT_INITIALIZED.getText()){

                protected void run() throws Exception {
                    instance.getParameters();
                }
            };
            new ExpectedFailure<RuntimeException>(Messages.CLIENT_NOT_INITIALIZED.getText()){

                protected void run() throws Exception {
                    instance.reconnect();
                }
            };
            manager.stop();
        }
        finally {
            if (mockServer != null) {
                mockServer.close();
            }
        }
    }
}

