/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.marketcetera.client.ClientManager;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.RequestID;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.NamedThreadFactory;

@ClassVersion(value="$Id: OrderSenderModule.java 16154 2012-07-14 16:34:05Z colin $")
public class OrderSenderModule
extends Module
implements DataEmitter {
    private final Object[] mOrders;
    private final Map<RequestID, Future<?>> mTable = new Hashtable();
    private static final ExecutorService sExecutors = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("TestOrderSender-"));

    protected OrderSenderModule(ModuleURN inURN, Object[] inOrders) {
        super(inURN, true);
        this.mOrders = inOrders;
    }

    protected void preStart() throws ModuleException {
    }

    protected void preStop() throws ModuleException {
    }

    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws RequestDataException {
        this.mTable.put(inSupport.getRequestID(), sExecutors.submit(new OrderSender(inSupport)));
    }

    public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
        Future<?> future = this.mTable.remove(inRequestID);
        future.cancel(true);
    }

    public class OrderSender
    implements Callable<Object> {
        private DataEmitterSupport mSupport;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            for (Object o : OrderSenderModule.this.mOrders) {
                if (Boolean.FALSE.equals(o)) {
                    ClientManager.getInstance().close();
                    continue;
                }
                this.mSupport.send(o);
            }
            OrderSender orderSender = this;
            synchronized (orderSender) {
                this.wait();
            }
            return null;
        }

        public OrderSender(DataEmitterSupport inSupport) {
            this.mSupport = inSupport;
        }
    }
}

