/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.instruments;

import java.math.BigDecimal;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.instruments.InstrumentValidationHandler;
import org.marketcetera.client.instruments.Messages;
import org.marketcetera.client.instruments.OptionValidationHandler;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.FutureExpirationMonth;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: InstrumentValidationHandlerTest.java 16154 2012-07-14 16:34:05Z colin $")
public class InstrumentValidationHandlerTest {
    @BeforeClass
    public static void logSetup() {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void equity() throws Exception {
        Equity equity = new Equity("WIU");
        ((InstrumentValidationHandler)InstrumentValidationHandler.SELECTOR.forInstrument((Instrument)equity)).validate((Instrument)equity);
    }

    @Test
    public void future() throws Exception {
        Future future = new Future("XEURFDAX0F2010U", FutureExpirationMonth.APRIL, 2010);
        ((InstrumentValidationHandler)InstrumentValidationHandler.SELECTOR.forInstrument((Instrument)future)).validate((Instrument)future);
    }

    @Test
    public void option() throws Exception {
        InstrumentValidationHandlerTest.validate("000001");
        InstrumentValidationHandlerTest.validate("000009");
        InstrumentValidationHandlerTest.validate("000010");
        InstrumentValidationHandlerTest.validate("999912");
        InstrumentValidationHandlerTest.validate("00000101");
        InstrumentValidationHandlerTest.validate("00000109");
        InstrumentValidationHandlerTest.validate("00000110");
        InstrumentValidationHandlerTest.validate("00000119");
        InstrumentValidationHandlerTest.validate("00000120");
        InstrumentValidationHandlerTest.validate("00000129");
        InstrumentValidationHandlerTest.validate("00000130");
        InstrumentValidationHandlerTest.validate("99991231");
        InstrumentValidationHandlerTest.validate("20090231");
        InstrumentValidationHandlerTest.validate("999912w1");
        InstrumentValidationHandlerTest.validate("999912w3");
        InstrumentValidationHandlerTest.validate("999912w5");
        InstrumentValidationHandlerTest.invalid("100");
        InstrumentValidationHandlerTest.invalid("2000");
        InstrumentValidationHandlerTest.invalid("10001");
        InstrumentValidationHandlerTest.invalid("1000101");
        InstrumentValidationHandlerTest.invalid("100010101");
        InstrumentValidationHandlerTest.invalid("AAAA10");
        InstrumentValidationHandlerTest.invalid("AAAA1010");
        InstrumentValidationHandlerTest.invalid("100000");
        InstrumentValidationHandlerTest.invalid("100013");
        InstrumentValidationHandlerTest.invalid("100020");
        InstrumentValidationHandlerTest.invalid("100032");
        InstrumentValidationHandlerTest.invalid("10000012");
        InstrumentValidationHandlerTest.invalid("10001312");
        InstrumentValidationHandlerTest.invalid("10002012");
        InstrumentValidationHandlerTest.invalid("1000AB12");
        InstrumentValidationHandlerTest.invalid("10000100");
        InstrumentValidationHandlerTest.invalid("10000132");
        InstrumentValidationHandlerTest.invalid("10000140");
        InstrumentValidationHandlerTest.invalid("100001BA");
        InstrumentValidationHandlerTest.invalid("100001w0");
        InstrumentValidationHandlerTest.invalid("100001w6");
        InstrumentValidationHandlerTest.invalid("100001a1");
        InstrumentValidationHandlerTest.invalid("100001w9");
        InstrumentValidationHandlerTest.invalid("100001ww");
        InstrumentValidationHandlerTest.invalid("100001x2");
    }

    @Test
    public void optionExpiryDate() throws Exception {
        OptionValidationHandler.validateExpiryDate((String)"20010101");
        OptionValidationHandler.validateExpiryDate((String)"20010131");
        OptionValidationHandler.validateExpiryDate((String)"20001231");
        OptionValidationHandler.validateExpiryDate((String)"20001201");
        OptionValidationHandler.validateExpiryDate((String)"20000228");
        OptionValidationHandler.validateExpiryDate((String)"20000229");
        OptionValidationHandler.validateExpiryDate((String)"200002w1");
        OptionValidationHandler.validateExpiryDate((String)"200002w4");
        OptionValidationHandler.validateExpiryDate((String)"200905w5");
        InstrumentValidationHandlerTest.invalidExpiryDate("20000230", Messages.INVALID_OPTION_EXPIRY_DAY);
        InstrumentValidationHandlerTest.invalidExpiryDate("20010229", Messages.INVALID_OPTION_EXPIRY_DAY);
        InstrumentValidationHandlerTest.invalidExpiryDate("20000631", Messages.INVALID_OPTION_EXPIRY_DAY);
        InstrumentValidationHandlerTest.invalidExpiryDate("20090231", Messages.INVALID_OPTION_EXPIRY_DAY);
        InstrumentValidationHandlerTest.invalidExpiryDate("200902w5", Messages.INVALID_OPTION_EXPIRY_WEEK);
        InstrumentValidationHandlerTest.invalidExpiryDate("200910w5", Messages.INVALID_OPTION_EXPIRY_WEEK);
    }

    private static void invalid(final String inExpiry) throws Exception {
        new ExpectedFailure<OrderValidationException>((I18NMessage)Messages.INVALID_OPTION_EXPIRY_FORMAT, new Object[]{inExpiry}){

            protected void run() throws Exception {
                InstrumentValidationHandlerTest.validateOption(inExpiry);
            }
        };
        new ExpectedFailure<OrderValidationException>((I18NMessage)Messages.INVALID_OPTION_EXPIRY_FORMAT, new Object[]{inExpiry}){

            protected void run() throws Exception {
                OptionValidationHandler.validateExpiry((String)inExpiry);
            }
        };
        new ExpectedFailure<OrderValidationException>((I18NMessage)Messages.INVALID_OPTION_EXPIRY_FORMAT, new Object[]{inExpiry}){

            protected void run() throws Exception {
                OptionValidationHandler.validateExpiryDate((String)inExpiry);
            }
        };
    }

    private static void invalidExpiryDate(final String inExpiry, I18NMessage1P inMsg) throws Exception {
        new ExpectedFailure<OrderValidationException>((I18NMessage)inMsg, new Object[]{inExpiry}){

            protected void run() throws Exception {
                OptionValidationHandler.validateExpiryDate((String)inExpiry);
            }
        };
    }

    private static void validate(String inExpiry) throws OrderValidationException {
        InstrumentValidationHandlerTest.validateOption(inExpiry);
        OptionValidationHandler.validateExpiry((String)inExpiry);
    }

    private static void validateOption(String inExpiry) throws OrderValidationException {
        Option option = new Option("XYZ", inExpiry, BigDecimal.TEN, OptionType.Call);
        ((InstrumentValidationHandler)InstrumentValidationHandler.SELECTOR.forInstrument((Instrument)option)).validate((Instrument)option);
    }
}

