/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import java.math.BigDecimal;
import junit.framework.Test;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.marketcetera.client.jms.JMSFIXMessageConverter;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.FIXVersionTestSuite;
import org.marketcetera.core.FIXVersionedTestCase;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtilTest;
import org.marketcetera.quickfix.FIXVersion;
import quickfix.Message;

@ClassVersion(value="$Id: JMSFIXMessageConverterTest.java 16154 2012-07-14 16:34:05Z colin $")
public class JMSFIXMessageConverterTest
extends FIXVersionedTestCase {
    public JMSFIXMessageConverterTest(String inName, FIXVersion version) {
        super(inName, version);
    }

    public static Test suite() {
        return new FIXVersionTestSuite(JMSFIXMessageConverterTest.class, FIXVersionTestSuite.ALL_VERSIONS);
    }

    public void testTextMessage() throws Exception {
        Message buy = FIXMessageUtilTest.createNOS((String)"TOLI", (BigDecimal)new BigDecimal("23.34"), (BigDecimal)new BigDecimal("123"), (char)'1', (FIXMessageFactory)this.msgFactory);
        ActiveMQTextMessage jmsMessage = new ActiveMQTextMessage();
        jmsMessage.setText(buy.toString());
        JMSFIXMessageConverter converter = new JMSFIXMessageConverter();
        JMSFIXMessageConverterTest.assertEquals((String)"mesasage not translated correctly", (String)buy.toString(), (String)converter.fromMessage((javax.jms.Message)jmsMessage).toString());
    }

    public void testBytesMessage() throws Exception {
        Message buy = FIXMessageUtilTest.createNOS((String)"TOLI", (BigDecimal)new BigDecimal("23.34"), (BigDecimal)new BigDecimal("123"), (char)'1', (FIXMessageFactory)this.msgFactory);
        ActiveMQBytesMessage jmsMessage = new ActiveMQBytesMessage();
        jmsMessage.writeBytes(buy.toString().getBytes("UTF-16"));
        jmsMessage.reset();
        JMSFIXMessageConverter converter = new JMSFIXMessageConverter();
        JMSFIXMessageConverterTest.assertEquals((String)"mesasage not translated correctly", (String)buy.toString(), (String)converter.fromMessage((javax.jms.Message)jmsMessage).toString());
    }
}

