/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import org.marketcetera.client.ClientImpl;
import org.marketcetera.client.Messages;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.NoMoreIDsException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: ClientIDFactory.java 16154 2012-07-14 16:34:05Z colin $")
public class ClientIDFactory
implements IDFactory {
    private String mServerID;
    private short mClientID = 0;
    private final String mPrefix;
    private final ClientImpl mClientImpl;
    static final short MAX_CLIENT_ID = 999;

    ClientIDFactory(String inPrefix, ClientImpl inClientImpl) {
        this.mPrefix = inPrefix == null ? "" : inPrefix;
        this.mClientImpl = inClientImpl;
    }

    public synchronized String getNext() throws NoMoreIDsException {
        this.mClientID = (short)(this.mClientID + 1);
        if (this.mClientID > 999) {
            this.getNextServer();
        }
        return String.format("%1$s%2$s%3$03d", this.mPrefix, this.mServerID, this.mClientID);
    }

    public void init() throws NoMoreIDsException {
        this.getNextServer();
    }

    private void getNextServer() throws NoMoreIDsException {
        try {
            this.mServerID = this.mClientImpl.getNextServerID();
            this.mClientID = 0;
        }
        catch (RemoteException e) {
            Messages.LOG_UNABLE_FETCH_ID_SERVER.error((Object)this, (Throwable)e);
            throw new NoMoreIDsException((Throwable)e, (I18NBoundMessage)Messages.UNABLE_FETCH_ID_SERVER);
        }
    }
}

