/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.BrokerStatusListener;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientIDFactory;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ClientVersion;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.IncompatibleComponentsException;
import org.marketcetera.client.Messages;
import org.marketcetera.client.OrderModifier;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.ReportListener;
import org.marketcetera.client.ServerStatusListener;
import org.marketcetera.client.Service;
import org.marketcetera.client.Validations;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.config.SpringConfig;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.client.jms.JmsUtils;
import org.marketcetera.client.jms.OrderEnvelope;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.Util;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.metrics.ThreadedMetric;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderBase;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NBoundMessage4P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.spring.SpringUtils;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.wrappers.DateWrapper;
import org.marketcetera.util.ws.wrappers.RemoteException;
import org.marketcetera.util.ws.wrappers.RemoteProxyException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.listener.SimpleMessageListenerContainer;

@ClassVersion(value="$Id: ClientImpl.java 16154 2012-07-14 16:34:05Z colin $")
class ClientImpl
implements Client,
ExceptionListener {
    private volatile AbstractApplicationContext mContext;
    private volatile JmsManager mJmsMgr;
    private volatile SimpleMessageListenerContainer mTradeMessageListener;
    private volatile SimpleMessageListenerContainer mBrokerStatusListener;
    private volatile JmsOperations mToServer;
    private volatile ClientParameters mParameters;
    private volatile boolean mClosed = false;
    private volatile boolean mServerAlive = false;
    private final Deque<ReportListener> mReportListeners = new LinkedList<ReportListener>();
    private final Deque<BrokerStatusListener> mBrokerStatusListeners = new LinkedList<BrokerStatusListener>();
    private final Deque<ServerStatusListener> mServerStatusListeners = new LinkedList<ServerStatusListener>();
    private final Deque<java.beans.ExceptionListener> mExceptionListeners = new LinkedList<java.beans.ExceptionListener>();
    private Date mLastConnectTime;
    private final Map<UserID, UserInfo> mUserInfoCache = new HashMap<UserID, UserInfo>();
    private final Map<String, String> mUnderlyingToRootCache = new HashMap<String, String>();
    private final Map<String, Collection<String>> mRootToUnderlyingCache = new HashMap<String, Collection<String>>();
    private static final long RECONNECT_WAIT_INTERVAL = 30000L;
    private volatile org.marketcetera.util.ws.stateful.Client mServiceClient;
    private Service mService;
    private Heart mHeart;
    private static final String TRAFFIC = ClientImpl.class.getPackage().getName() + ".traffic";
    private static final String HEARTBEATS = ClientImpl.class.getPackage().getName() + ".heartbeats";

    @Override
    public void sendOrder(OrderSingle inOrderSingle) throws ConnectionException, OrderValidationException {
        Validations.validate(inOrderSingle);
        this.convertAndSend((Order)inOrderSingle);
    }

    @Override
    public void sendOrder(OrderReplace inOrderReplace) throws ConnectionException, OrderValidationException {
        Validations.validate(inOrderReplace);
        this.convertAndSend((Order)inOrderReplace);
    }

    @Override
    public void sendOrder(OrderCancel inOrderCancel) throws ConnectionException, OrderValidationException {
        Validations.validate(inOrderCancel);
        this.convertAndSend((Order)inOrderCancel);
    }

    @Override
    public void sendOrderRaw(FIXOrder inFIXOrder) throws ConnectionException, OrderValidationException {
        Validations.validate(inFIXOrder);
        this.convertAndSend((Order)inFIXOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReportListener(ReportListener inListener) {
        this.failIfClosed();
        Deque<ReportListener> deque = this.mReportListeners;
        synchronized (deque) {
            this.mReportListeners.addFirst(inListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReportListener(ReportListener inListener) {
        this.failIfClosed();
        Deque<ReportListener> deque = this.mReportListeners;
        synchronized (deque) {
            this.mReportListeners.removeFirstOccurrence(inListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBrokerStatusListener(BrokerStatusListener listener) {
        this.failIfClosed();
        Deque<BrokerStatusListener> deque = this.mBrokerStatusListeners;
        synchronized (deque) {
            this.mBrokerStatusListeners.addFirst(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBrokerStatusListener(BrokerStatusListener listener) {
        this.failIfClosed();
        Deque<BrokerStatusListener> deque = this.mBrokerStatusListeners;
        synchronized (deque) {
            this.mBrokerStatusListeners.removeFirstOccurrence(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerStatusListener(ServerStatusListener listener) {
        this.failIfClosed();
        Deque<ServerStatusListener> deque = this.mServerStatusListeners;
        synchronized (deque) {
            this.mServerStatusListeners.addFirst(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerStatusListener(ServerStatusListener listener) {
        this.failIfClosed();
        Deque<ServerStatusListener> deque = this.mServerStatusListeners;
        synchronized (deque) {
            this.mServerStatusListeners.removeFirstOccurrence(listener);
        }
    }

    @Override
    public ReportBase[] getReportsSince(Date inDate) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            ReportBaseImpl[] reports = this.mService.getReportsSince(this.getServiceContext(), new DateWrapper(inDate));
            return reports == null ? new ReportBase[]{} : reports;
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public BigDecimal getEquityPositionAsOf(Date inDate, Equity inEquity) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getEquityPositionAsOf(this.getServiceContext(), new DateWrapper(inDate), inEquity);
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(Date inDate) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getAllEquityPositionsAsOf(this.getServiceContext(), new DateWrapper(inDate)).getMap();
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date inDate) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getAllFuturePositionsAsOf(this.getServiceContext(), new DateWrapper(inDate)).getMap();
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public BigDecimal getFuturePositionAsOf(Date inDate, Future inFuture) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getFuturePositionAsOf(this.getServiceContext(), new DateWrapper(inDate), inFuture);
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public BigDecimal getOptionPositionAsOf(Date inDate, Option inOption) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getOptionPositionAsOf(this.getServiceContext(), new DateWrapper(inDate), inOption);
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date inDate) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getAllOptionPositionsAsOf(this.getServiceContext(), new DateWrapper(inDate)).getMap();
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date inDate, String ... inSymbols) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getOptionPositionsAsOf(this.getServiceContext(), new DateWrapper(inDate), inSymbols).getMap();
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUnderlying(String inOptionRoot) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            String value;
            Map<String, String> map = this.mUnderlyingToRootCache;
            synchronized (map) {
                if (this.mUnderlyingToRootCache.containsKey(inOptionRoot)) {
                    value = this.mUnderlyingToRootCache.get(inOptionRoot);
                } else {
                    value = this.mService.getUnderlying(this.getServiceContext(), inOptionRoot);
                    this.mUnderlyingToRootCache.put(inOptionRoot, value);
                }
            }
            return value;
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getOptionRoots(String inUnderlying) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            Collection<String> value;
            Map<String, Collection<String>> map = this.mRootToUnderlyingCache;
            synchronized (map) {
                if (this.mRootToUnderlyingCache.containsKey(inUnderlying)) {
                    value = this.mRootToUnderlyingCache.get(inUnderlying);
                } else {
                    value = this.mService.getOptionRoots(this.getServiceContext(), inUnderlying);
                    this.mRootToUnderlyingCache.put(inUnderlying, value);
                }
            }
            return value;
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public BrokersStatus getBrokersStatus() throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return this.mService.getBrokersStatus(this.getServiceContext());
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(UserID id, boolean useCache) throws ConnectionException {
        UserInfo result;
        this.failIfClosed();
        Map<UserID, UserInfo> map = this.mUserInfoCache;
        synchronized (map) {
            if (useCache && (result = this.mUserInfoCache.get(id)) != null) {
                return result;
            }
            this.failIfDisconnected();
            try {
                result = this.mService.getUserInfo(this.getServiceContext(), id);
            }
            catch (RemoteException ex) {
                throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
            }
            this.mUserInfoCache.put(id, result);
        }
        return result;
    }

    @Override
    public synchronized void close() {
        this.internalClose();
        ClientManager.reset();
        this.mClosed = true;
    }

    @Override
    public void reconnect() throws ConnectionException {
        this.reconnect(null);
    }

    @Override
    public synchronized void reconnect(ClientParameters inParameters) throws ConnectionException {
        this.failIfClosed();
        if (this.mContext != null) {
            this.internalClose();
        }
        if (inParameters != null) {
            this.setParameters(inParameters);
        }
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExceptionListener(java.beans.ExceptionListener inListener) {
        this.failIfClosed();
        Deque<java.beans.ExceptionListener> deque = this.mExceptionListeners;
        synchronized (deque) {
            this.mExceptionListeners.addFirst(inListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExceptionListener(java.beans.ExceptionListener inListener) {
        this.failIfClosed();
        Deque<java.beans.ExceptionListener> deque = this.mExceptionListeners;
        synchronized (deque) {
            this.mExceptionListeners.removeFirstOccurrence(inListener);
        }
    }

    @Override
    public ClientParameters getParameters() {
        this.failIfClosed();
        return new ClientParameters(this.mParameters.getUsername(), "*****".toCharArray(), this.mParameters.getURL(), this.mParameters.getHostname(), this.mParameters.getPort(), this.mParameters.getIDPrefix());
    }

    @Override
    public Date getLastConnectTime() {
        this.failIfClosed();
        return this.mLastConnectTime;
    }

    @Override
    public boolean isCredentialsMatch(String inUsername, char[] inPassword) {
        return !this.mClosed && ObjectUtils.equals((Object)this.mParameters.getUsername(), (Object)inUsername) && Arrays.equals(this.mParameters.getPassword(), inPassword);
    }

    @Override
    public boolean isServerAlive() {
        return !this.mClosed && this.mServerAlive;
    }

    @Override
    public Properties getUserData() throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            return Util.propertiesFromString((String)this.mService.getUserData(this.getServiceContext()));
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public void setUserData(Properties inProperties) throws ConnectionException {
        this.failIfClosed();
        this.failIfDisconnected();
        try {
            this.mService.setUserData(this.getServiceContext(), Util.propertiesToString((Properties)inProperties));
        }
        catch (RemoteException ex) {
            throw new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    ClientImpl(ClientParameters inParameters) throws ConnectionException {
        this.setParameters(inParameters);
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyExecutionReport(ExecutionReport inReport) {
        SLF4JLoggerProxy.debug((Object)TRAFFIC, (String)"Received Exec Report:{}", (Object[])new Object[]{inReport});
        Deque<ReportListener> deque = this.mReportListeners;
        synchronized (deque) {
            for (ReportListener listener : this.mReportListeners) {
                try {
                    listener.receiveExecutionReport(inReport);
                }
                catch (Throwable t) {
                    Messages.LOG_ERROR_RECEIVE_EXEC_REPORT.warn((Object)this, t, (Object)ObjectUtils.toString((Object)inReport));
                    ExceptUtils.interrupt((Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCancelReject(OrderCancelReject inReport) {
        SLF4JLoggerProxy.debug((Object)TRAFFIC, (String)"Received Cancel Reject:{}", (Object[])new Object[]{inReport});
        Deque<ReportListener> deque = this.mReportListeners;
        synchronized (deque) {
            for (ReportListener listener : this.mReportListeners) {
                try {
                    listener.receiveCancelReject(inReport);
                }
                catch (Throwable t) {
                    Messages.LOG_ERROR_RECEIVE_CANCEL_REJECT.warn((Object)this, t, (Object)ObjectUtils.toString((Object)inReport));
                    ExceptUtils.interrupt((Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyBrokerStatus(BrokerStatus status) {
        SLF4JLoggerProxy.debug((Object)TRAFFIC, (String)"Received Broker Status:{}", (Object[])new Object[]{status});
        Deque<BrokerStatusListener> deque = this.mBrokerStatusListeners;
        synchronized (deque) {
            for (BrokerStatusListener listener : this.mBrokerStatusListeners) {
                try {
                    listener.receiveBrokerStatus(status);
                }
                catch (Throwable t) {
                    Messages.LOG_ERROR_RECEIVE_BROKER_STATUS.warn((Object)this, t, (Object)ObjectUtils.toString((Object)status));
                    ExceptUtils.interrupt((Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerStatus(boolean status) {
        SLF4JLoggerProxy.debug((Object)TRAFFIC, (String)"Received Server Status:{}", (Object[])new Object[]{status});
        Deque<ServerStatusListener> deque = this.mServerStatusListeners;
        synchronized (deque) {
            for (ServerStatusListener listener : this.mServerStatusListeners) {
                try {
                    listener.receiveServerStatus(status);
                }
                catch (Throwable t) {
                    Messages.LOG_ERROR_RECEIVE_SERVER_STATUS.warn((Object)this, t, (Object)status);
                    ExceptUtils.interrupt((Throwable)t);
                }
            }
        }
    }

    public void onException(JMSException e) {
        this.exceptionThrown(new ConnectionException((Throwable)e, (I18NBoundMessage)Messages.ERROR_RECEIVING_JMS_MESSAGE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exceptionThrown(ConnectionException inException) {
        Deque<java.beans.ExceptionListener> deque = this.mExceptionListeners;
        synchronized (deque) {
            for (java.beans.ExceptionListener l : this.mExceptionListeners) {
                try {
                    l.exceptionThrown((Exception)((Object)inException));
                }
                catch (Exception e) {
                    Messages.LOG_ERROR_NOTIFY_EXCEPTION.warn((Object)this, (Throwable)e, (Object)ObjectUtils.toString((Object)((Object)inException)));
                    ExceptUtils.interrupt((Throwable)e);
                }
            }
        }
    }

    String getNextServerID() throws RemoteException {
        this.failIfDisconnected();
        return this.mService.getNextOrderID(this.getServiceContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void internalClose() {
        if (this.mContext == null) {
            return;
        }
        Map<String, Object> map = this.mUnderlyingToRootCache;
        // MONITORENTER : map
        this.mUnderlyingToRootCache.clear();
        // MONITOREXIT : map
        map = this.mRootToUnderlyingCache;
        // MONITORENTER : map
        this.mRootToUnderlyingCache.clear();
        // MONITOREXIT : map
        map = this.mUserInfoCache;
        // MONITORENTER : map
        this.mUserInfoCache.clear();
        // MONITOREXIT : map
        if (this.mHeart != null) {
            this.mHeart.markExit();
            this.mHeart.interrupt();
            try {
                this.mHeart.join();
            }
            catch (InterruptedException ex) {
                SLF4JLoggerProxy.debug((Object)this, (String)"Error when joining with heartbeat thread", (Throwable)ex);
                ExceptUtils.interrupt((Throwable)ex);
            }
        }
        this.setServerAlive(false);
        try {
            if (this.mServiceClient == null) return;
            this.mServiceClient.logout();
            return;
        }
        catch (Exception ex) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Error when closing web service client", (Throwable)ex);
            ExceptUtils.interrupt((Throwable)ex);
            return;
        }
        finally {
            try {
                if (this.mContext != null) {
                    this.mContext.close();
                }
            }
            catch (Exception ex) {
                SLF4JLoggerProxy.debug((Object)this, (String)"Error when closing context", (Throwable)ex);
                ExceptUtils.interrupt((Throwable)ex);
            }
            finally {
                this.setContext(null);
            }
        }
    }

    private void connect() throws ConnectionException {
        if (this.mParameters.getURL() == null || this.mParameters.getURL().trim().isEmpty()) {
            throw new ConnectionException((I18NBoundMessage)Messages.CONNECT_ERROR_NO_URL);
        }
        if (this.mParameters.getUsername() == null || this.mParameters.getUsername().trim().isEmpty()) {
            throw new ConnectionException((I18NBoundMessage)Messages.CONNECT_ERROR_NO_USERNAME);
        }
        if (this.mParameters.getHostname() == null || this.mParameters.getHostname().trim().isEmpty()) {
            throw new ConnectionException((I18NBoundMessage)Messages.CONNECT_ERROR_NO_HOSTNAME);
        }
        if (this.mParameters.getPort() < 1 || this.mParameters.getPort() > 65535) {
            throw new ConnectionException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CONNECT_ERROR_INVALID_PORT, (Serializable)Integer.valueOf(this.mParameters.getPort())));
        }
        try {
            ClassPathXmlApplicationContext ctx;
            StaticApplicationContext parentCtx = new StaticApplicationContext();
            SpringUtils.addStringBean((GenericApplicationContext)parentCtx, (String)"brokerURL", (String)this.mParameters.getURL());
            SpringUtils.addStringBean((GenericApplicationContext)parentCtx, (String)"runtimeUsername", (String)this.mParameters.getUsername());
            SpringUtils.addStringBean((GenericApplicationContext)parentCtx, (String)"runtimePassword", this.mParameters == null ? null : String.valueOf(this.mParameters.getPassword()));
            parentCtx.refresh();
            try {
                ctx = new FileSystemXmlApplicationContext(new String[]{"file:" + ApplicationBase.CONF_DIR + "client.xml"}, (ApplicationContext)parentCtx);
            }
            catch (BeansException e) {
                ctx = new ClassPathXmlApplicationContext(new String[]{"client.xml"}, (ApplicationContext)parentCtx);
            }
            ctx.registerShutdownHook();
            ctx.start();
            this.setContext((AbstractApplicationContext)ctx);
            SpringConfig cfg = SpringConfig.getSingleton();
            if (cfg == null) {
                throw new ConnectionException((I18NBoundMessage)Messages.CONNECT_ERROR_NO_CONFIGURATION);
            }
            this.mServiceClient = new org.marketcetera.util.ws.stateful.Client(this.mParameters.getHostname(), this.mParameters.getPort(), ClientVersion.APP_ID);
            this.mServiceClient.login(this.mParameters.getUsername(), this.mParameters.getPassword());
            this.mService = (Service)this.mServiceClient.getService(Service.class);
            this.mJmsMgr = new JmsManager(cfg.getIncomingConnectionFactory(), cfg.getOutgoingConnectionFactory(), this);
            this.startJms();
            this.mServerAlive = true;
            this.notifyServerStatus(true);
            this.mHeart = new Heart();
            this.mHeart.start();
            ClientIDFactory idFactory = new ClientIDFactory(this.mParameters.getIDPrefix(), this);
            idFactory.init();
            Factory.getInstance().setOrderIDFactory((IDFactory)idFactory);
        }
        catch (Throwable t) {
            this.internalClose();
            ExceptUtils.interrupt((Throwable)t);
            if (t.getCause() instanceof RemoteProxyException) {
                RemoteProxyException ex = (RemoteProxyException)t.getCause();
                if (IncompatibleComponentsException.class.getName().equals(ex.getServerName())) {
                    throw new ConnectionException(t, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_CONNECT_INCOMPATIBLE_DEDUCED, (Serializable)((Object)ex.getMessage())));
                }
            } else if (t.getCause() instanceof IncompatibleComponentsException) {
                IncompatibleComponentsException ex = (IncompatibleComponentsException)((Object)t.getCause());
                throw new ConnectionException(t, (I18NBoundMessage)new I18NBoundMessage2P(Messages.ERROR_CONNECT_INCOMPATIBLE_DIRECT, (Serializable)ClientVersion.APP_ID, (Serializable)((Object)ex.getServerVersion())));
            }
            throw new ConnectionException(t, (I18NBoundMessage)new I18NBoundMessage4P(Messages.ERROR_CONNECT_TO_SERVER, (Serializable)((Object)this.mParameters.getURL()), (Serializable)((Object)this.mParameters.getUsername()), (Serializable)((Object)this.mParameters.getHostname()), (Serializable)Integer.valueOf(this.mParameters.getPort())));
        }
        this.mLastConnectTime = new Date();
    }

    private void setContext(AbstractApplicationContext inContext) {
        this.mContext = inContext;
    }

    private void convertAndSend(Order inOrder) throws ConnectionException {
        ThreadedMetric.event((String)"client-OUT", (Object[])new Object[]{inOrder instanceof OrderBase ? ((OrderBase)inOrder).getOrderID() : null});
        this.failIfClosed();
        SLF4JLoggerProxy.debug((Object)TRAFFIC, (String)"Sending order:{}", (Object[])new Object[]{inOrder});
        try {
            if (this.mToServer == null) {
                throw new ClientInitException((I18NBoundMessage)Messages.NOT_CONNECTED_TO_SERVER);
            }
            this.failIfDisconnected();
            SpringConfig cfg = SpringConfig.getSingleton();
            Collection<OrderModifier> orderModifiers = cfg.getOrderModifiers();
            for (OrderModifier modifier : orderModifiers) {
                modifier.modify(inOrder);
            }
            this.mToServer.convertAndSend((Object)new OrderEnvelope(inOrder, this.getSessionId()));
        }
        catch (Exception e) {
            ConnectionException exception = new ConnectionException(e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_SEND_MESSAGE, (Serializable)((Object)ObjectUtils.toString((Object)inOrder))));
            Messages.LOG_ERROR_SEND_EXCEPTION.warn((Object)this, (Throwable)((Object)exception), (Object)ObjectUtils.toString((Object)inOrder));
            ExceptUtils.interrupt((Throwable)e);
            this.exceptionThrown(exception);
            throw exception;
        }
    }

    private void failIfClosed() throws IllegalStateException {
        if (this.mClosed) {
            throw new IllegalStateException(Messages.CLIENT_CLOSED.getText());
        }
    }

    private void failIfDisconnected() throws IllegalStateException {
        if (!this.isServerAlive()) {
            throw new IllegalStateException(Messages.SERVER_CONNECTION_DEAD.getText());
        }
    }

    private ClientContext getServiceContext() {
        return this.mServiceClient.getContext();
    }

    SessionId getSessionId() {
        return this.getServiceContext().getSessionId();
    }

    private void setParameters(ClientParameters inParameters) {
        if (inParameters == null) {
            throw new NullPointerException();
        }
        this.mParameters = inParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopJms() {
        if (this.mToServer == null) {
            return;
        }
        try {
            if (this.mTradeMessageListener == null) return;
            this.mTradeMessageListener.shutdown();
            return;
        }
        catch (Exception ex) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Error when closing trade message listener", (Throwable)ex);
            ExceptUtils.interrupt((Throwable)ex);
            return;
        }
        finally {
            try {
                if (this.mBrokerStatusListener != null) {
                    this.mBrokerStatusListener.shutdown();
                }
            }
            catch (Exception ex) {
                SLF4JLoggerProxy.debug((Object)this, (String)"Error when closing broker status listener", (Throwable)ex);
                ExceptUtils.interrupt((Throwable)ex);
            }
            finally {
                this.mToServer = null;
            }
        }
    }

    private void startJms() throws JAXBException {
        if (this.mToServer != null) {
            return;
        }
        this.mTradeMessageListener = this.mJmsMgr.getIncomingJmsFactory().registerHandlerTMX(new TradeMessageReceiver(), JmsUtils.getReplyTopicName(this.getSessionId()), true);
        this.mBrokerStatusListener = this.mJmsMgr.getIncomingJmsFactory().registerHandlerBSX(new BrokerStatusReceiver(), "ors-broker-status", true);
        this.mToServer = this.mJmsMgr.getOutgoingJmsFactory().createJmsTemplateX("ors-commands", false);
    }

    private void setServerAlive(boolean serverAlive) {
        if (this.mServerAlive == serverAlive) {
            return;
        }
        if (serverAlive) {
            try {
                this.startJms();
            }
            catch (JAXBException ex) {
                this.exceptionThrown(new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_CREATING_JMS_CONNECTION));
                return;
            }
        } else {
            this.stopJms();
        }
        this.mServerAlive = serverAlive;
        this.notifyServerStatus(this.isServerAlive());
    }

    private class Heart
    extends Thread {
        private volatile boolean mMarked;

        Heart() {
            super(Thread.currentThread().getThreadGroup(), Messages.HEARTBEAT_THREAD_NAME.getText());
            this.setDaemon(true);
        }

        void markExit() {
            this.mMarked = true;
        }

        private boolean isMarked() {
            return this.mMarked;
        }

        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(ClientImpl.this.mParameters.getHeartbeatInterval());
                }
                catch (InterruptedException ex) {
                    SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"Stopped (interrupted)");
                    this.markExit();
                    ClientImpl.this.setServerAlive(false);
                    return;
                }
                if (this.isMarked()) {
                    SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"Stopped (marked)");
                    ClientImpl.this.setServerAlive(false);
                    return;
                }
                try {
                    ClientImpl.this.mService.heartbeat(ClientImpl.this.getServiceContext());
                    ClientImpl.this.setServerAlive(true);
                }
                catch (Exception ex) {
                    ClientImpl.this.setServerAlive(false);
                    if (ExceptUtils.isInterruptException((Throwable)ex)) {
                        SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"Stopped (interrupted)");
                        this.markExit();
                        return;
                    }
                    SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"Failed", (Throwable)ex);
                    ClientImpl.this.exceptionThrown(new ConnectionException(ex, (I18NBoundMessage)Messages.ERROR_HEARTBEAT_FAILED));
                    if (!(ex instanceof RemoteException)) continue;
                    long delay = (long)(30000.0 * (0.75 + 1.25 * Math.random()));
                    SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)("Reconnecting in " + delay + "ms..."));
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex2) {
                        SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"Stopped (interrupted)");
                        this.markExit();
                        return;
                    }
                    try {
                        ClientImpl.this.mServiceClient.logout();
                        ClientImpl.this.mServiceClient.login(ClientImpl.this.mParameters.getUsername(), ClientImpl.this.mParameters.getPassword());
                        ClientImpl.this.setServerAlive(true);
                        SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"...reconnect succeeded.");
                    }
                    catch (Exception ex2) {
                        ClientImpl.this.setServerAlive(false);
                        if (ExceptUtils.isInterruptException((Throwable)ex2)) {
                            SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"Stopped (interrupted)");
                            this.markExit();
                            return;
                        }
                        SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"...reconnect failed.", (Throwable)ex2);
                        ClientImpl.this.exceptionThrown(new ConnectionException(ex2, (I18NBoundMessage)Messages.ERROR_HEARTBEAT_FAILED));
                    }
                }
            } while (!this.isMarked());
            SLF4JLoggerProxy.debug((Object)HEARTBEATS, (String)"Stopped (marked)");
            ClientImpl.this.setServerAlive(false);
        }
    }

    public class BrokerStatusReceiver
    implements ReceiveOnlyHandler<BrokerStatus> {
        @Override
        public void receiveMessage(BrokerStatus status) {
            ClientImpl.this.notifyBrokerStatus(status);
        }
    }

    public class TradeMessageReceiver
    implements ReceiveOnlyHandler<TradeMessage> {
        @Override
        public void receiveMessage(TradeMessage inReport) {
            if (inReport instanceof ExecutionReport) {
                ClientImpl.this.notifyExecutionReport((ExecutionReport)inReport);
            } else if (inReport instanceof OrderCancelReject) {
                ClientImpl.this.notifyCancelReject((OrderCancelReject)inReport);
            } else {
                Messages.LOG_RECEIVED_FIX_REPORT.warn((Object)this, (Object)ObjectUtils.toString((Object)inReport));
            }
        }
    }
}

