/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import org.marketcetera.client.Client;
import org.marketcetera.client.ClientFactory;
import org.marketcetera.client.ClientImpl;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ClientManager.java 16154 2012-07-14 16:34:05Z colin $")
public final class ClientManager {
    private static volatile ClientFactory mClientFactory = new ClientFactory(){

        @Override
        public Client getClient(ClientParameters inParameters) throws ClientInitException, ConnectionException {
            return new ClientImpl(inParameters);
        }
    };
    private static volatile Client mClient;

    public static synchronized void init(ClientParameters inParameter) throws ConnectionException, ClientInitException {
        if (ClientManager.isInitialized()) {
            throw new ClientInitException((I18NBoundMessage)Messages.CLIENT_ALREADY_INITIALIZED);
        }
        mClient = mClientFactory.getClient(inParameter);
    }

    public static synchronized void setClientFactory(ClientFactory inFactory) throws ClientInitException {
        if (ClientManager.isInitialized()) {
            throw new ClientInitException((I18NBoundMessage)Messages.CLIENT_ALREADY_INITIALIZED);
        }
        mClientFactory = inFactory;
    }

    public static Client getInstance() throws ClientInitException {
        if (ClientManager.isInitialized()) {
            return mClient;
        }
        throw new ClientInitException((I18NBoundMessage)Messages.CLIENT_NOT_INITIALIZED);
    }

    public static boolean isInitialized() {
        return mClient != null;
    }

    static synchronized void reset() {
        mClient = null;
    }

    private ClientManager() {
    }
}

