/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.math.BigDecimal;
import java.util.Collection;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.core.position.impl.PositionKeyImpl;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.ServiceBase;
import org.marketcetera.util.ws.wrappers.DateWrapper;
import org.marketcetera.util.ws.wrappers.MapWrapper;
import org.marketcetera.util.ws.wrappers.RemoteException;

@WebService(targetNamespace="http://marketcetera.org/services")
@ClassVersion(value="$Id: Service.java 16154 2012-07-14 16:34:05Z colin $")
@XmlSeeAlso(value={PositionKeyImpl.class, Equity.class})
public interface Service
extends ServiceBase {
    public static final String REPLY_TOPIC_PREFIX = "ors-messages-";
    public static final String BROKER_STATUS_TOPIC = "ors-broker-status";
    public static final String REQUEST_QUEUE = "ors-commands";

    public BrokersStatus getBrokersStatus(@WebParam(name="context") ClientContext var1) throws RemoteException;

    public UserInfo getUserInfo(@WebParam(name="context") ClientContext var1, @WebParam(name="userID") UserID var2) throws RemoteException;

    public ReportBaseImpl[] getReportsSince(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2) throws RemoteException;

    public BigDecimal getEquityPositionAsOf(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2, @WebParam(name="equity") Equity var3) throws RemoteException;

    public MapWrapper<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2) throws RemoteException;

    public BigDecimal getFuturePositionAsOf(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2, @WebParam(name="future") Future var3) throws RemoteException;

    public MapWrapper<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2) throws RemoteException;

    public BigDecimal getOptionPositionAsOf(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2, @WebParam(name="option") Option var3) throws RemoteException;

    public MapWrapper<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2) throws RemoteException;

    public MapWrapper<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(@WebParam(name="context") ClientContext var1, @WebParam(name="date") DateWrapper var2, String ... var3) throws RemoteException;

    public String getNextOrderID(@WebParam(name="context") ClientContext var1) throws RemoteException;

    public String getUnderlying(@WebParam(name="context") ClientContext var1, @WebParam(name="optionRoot") String var2) throws RemoteException;

    public Collection<String> getOptionRoots(@WebParam(name="context") ClientContext var1, @WebParam(name="underlying") String var2) throws RemoteException;

    public void heartbeat(@WebParam(name="context") ClientContext var1) throws RemoteException;

    public String getUserData(@WebParam(name="context") ClientContext var1) throws RemoteException;

    public void setUserData(@WebParam(name="context") ClientContext var1, @WebParam(name="userData") String var2) throws RemoteException;
}

