/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.jms.Messages;
import org.marketcetera.client.jms.OrderEnvelope;
import org.marketcetera.trade.FIXResponseImpl;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

@ClassVersion(value="$Id: JMSXMLMessageConverter.java 16154 2012-07-14 16:34:05Z colin $")
public class JMSXMLMessageConverter
implements MessageConverter {
    private final ThreadLocal<Marshaller> mMarshallers = new ThreadLocal();
    private final ThreadLocal<Unmarshaller> mUnmarshallers = new ThreadLocal();
    private final JAXBContext mContext = JAXBContext.newInstance((Class[])new Class[]{OrderEnvelope.class, ReportBaseImpl.class, FIXResponseImpl.class, BrokerStatus.class});
    private static final String JMS_TYPE_PROPERTY = "metc_type";

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Converting from JMS {}", (Object[])new Object[]{message});
        if (message instanceof TextMessage) {
            Object object = null;
            try {
                object = this.fromXML(((TextMessage)message).getText());
            }
            catch (JAXBException e) {
                throw new MessageConversionException(new I18NBoundMessage1P(Messages.ERROR_CONVERTING_MESSAGE_TO_OBJECT, (Serializable)((Object)ObjectUtils.toString((Object)object))).getText(), (Throwable)e);
            }
            if (object instanceof ReportBaseImpl || object instanceof FIXResponseImpl || object instanceof OrderEnvelope || object instanceof BrokerStatus) {
                return object;
            }
            throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_RECEIVED, (Serializable)((Object)ObjectUtils.toString((Object)object))).getText());
        }
        throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_RECEIVED, (Serializable)((Object)ObjectUtils.toString((Object)message))).getText());
    }

    public Message toMessage(Object inObject, Session session) throws JMSException, MessageConversionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Converting to JMS {}", (Object[])new Object[]{inObject});
        if (inObject instanceof ReportBaseImpl || inObject instanceof FIXResponseImpl || inObject instanceof OrderEnvelope || inObject instanceof BrokerStatus) {
            try {
                TextMessage message = session.createTextMessage(this.toXML(inObject));
                message.setStringProperty(JMS_TYPE_PROPERTY, inObject.getClass().getSimpleName());
                return message;
            }
            catch (JAXBException e) {
                throw new MessageConversionException(new I18NBoundMessage1P(Messages.ERROR_CONVERTING_OBJECT_TO_MESSAGE, (Serializable)((Object)ObjectUtils.toString((Object)inObject))).getText(), (Throwable)e);
            }
        }
        throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_TO_SEND, (Serializable)((Object)ObjectUtils.toString((Object)inObject))).getText());
    }

    String toXML(Object inObject) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        StringWriter writer = new StringWriter();
        marshaller.marshal(inObject, (Writer)writer);
        return writer.toString();
    }

    Object fromXML(String inXML) throws JAXBException {
        Unmarshaller unMarshaller = this.getUnMarshaller();
        StringReader reader = new StringReader(inXML);
        return unMarshaller.unmarshal((Reader)reader);
    }

    JAXBContext getContext() {
        return this.mContext;
    }

    private Marshaller getMarshaller() throws JAXBException {
        Marshaller m = this.mMarshallers.get();
        if (m == null) {
            m = this.mContext.createMarshaller();
            this.mMarshallers.set(m);
        }
        return m;
    }

    private Unmarshaller getUnMarshaller() throws JAXBException {
        Unmarshaller u = this.mUnmarshallers.get();
        if (u == null) {
            u = this.mContext.createUnmarshaller();
            this.mUnmarshallers.set(u);
        }
        return u;
    }
}

