/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.utils;

import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.utils.OrderHistoryManager;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.context.Lifecycle;

@ClassVersion(value="$Id: LiveOrderHistoryManager.java 16154 2012-07-14 16:34:05Z colin $")
public class LiveOrderHistoryManager
extends OrderHistoryManager
implements Lifecycle {
    private volatile Thread reportProcessor;
    private final BlockingDeque<ReportBase> updateReports = new LinkedBlockingDeque<ReportBase>();
    private final Date reportHistoryOrigin;
    private volatile boolean isRunning = false;
    private final Client client;

    public LiveOrderHistoryManager(Date inReportHistoryOrigin) throws ClientInitException {
        this.reportHistoryOrigin = inReportHistoryOrigin == null ? new Date(0L) : inReportHistoryOrigin;
        this.client = ClientManager.getInstance();
    }

    public Map<OrderID, ExecutionReport> getOpenOrders() {
        if (!this.isRunning) {
            throw new IllegalStateException(Messages.OPEN_ORDER_LIST_NOT_READY.getText());
        }
        return super.getOpenOrders();
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void start() {
        if (this.isRunning) {
            this.stop();
        }
        SLF4JLoggerProxy.debug(LiveOrderHistoryManager.class, (String)"LiveOrderHistoryManager starting - collecting order history since {}", (Object[])new Object[]{this.reportHistoryOrigin});
        LinkedList<ReportBase> snapshotReports = new LinkedList<ReportBase>();
        try {
            ReportBase[] orderHistory = this.client.getReportsSince(this.reportHistoryOrigin);
            SLF4JLoggerProxy.debug(LiveOrderHistoryManager.class, (String)"{} report(s) to process", (Object[])new Object[]{orderHistory.length});
            for (ReportBase report : orderHistory) {
                snapshotReports.add(report);
            }
        }
        catch (ConnectionException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        if (!snapshotReports.isEmpty()) {
            for (ReportBase report : snapshotReports) {
                LiveOrderHistoryManager.super.add(report);
            }
            snapshotReports.clear();
            SLF4JLoggerProxy.debug(LiveOrderHistoryManager.class, (String)"All historical reports processed");
        }
        this.reportProcessor = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (LiveOrderHistoryManager.this.isRunning) {
                        LiveOrderHistoryManager.this.add((ReportBase)LiveOrderHistoryManager.this.updateReports.take());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "LiveOrderHistoryManager Report Processor");
        this.reportProcessor.start();
        this.isRunning = true;
    }

    public synchronized void stop() {
        SLF4JLoggerProxy.debug(LiveOrderHistoryManager.class, (String)"LiveOrderHistoryManager stopping");
        if (!this.isRunning) {
            return;
        }
        if (this.reportProcessor != null) {
            this.reportProcessor.interrupt();
            try {
                this.reportProcessor.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reportProcessor = null;
        }
        this.clear();
        this.isRunning = false;
    }

    public Date getReportHistoryOrigin() {
        return this.reportHistoryOrigin;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LiveOrderHistoryManager [").append(this.isRunning ? "running" : "not running").append("]");
        return builder.toString();
    }

    protected Client getClient() {
        return this.client;
    }
}

