/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.io.Serializable;
import java.math.BigDecimal;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ClientTest;
import org.marketcetera.client.Messages;
import org.marketcetera.client.MockServer;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.Validations;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OrderValidationFailureTest.java 16841 2014-02-20 19:59:04Z colin $")
public class OrderValidationFailureTest {
    private static final Option OPTION_INVALID_EXPIRY = new Option("TEST", "20090000", BigDecimal.TEN, OptionType.Call);
    private static final Instrument UNKNOWN_INSTRUMENT = new Instrument(){
        private static final long serialVersionUID = 1L;

        public String getSymbol() {
            return null;
        }

        public SecurityType getSecurityType() {
            return null;
        }
    };
    private static final I18NBoundMessage1P EXPECTED_UNKNOWN_INSTRUMENT_MESSAGE = new I18NBoundMessage1P(Messages.VALIDATION_UNKNOWN_INSTRUMENT, (Serializable)UNKNOWN_INSTRUMENT);
    private static MockServer sServer;
    private static final I18NBoundMessage1P EXPECTED_EXPIRY_FAIL_MESSAGE;

    @Test
    public void orderSingle() throws Exception {
        OrderValidationFailureTest.verifySingle(null, (I18NBoundMessage)Messages.NO_ORDER_SUPPLIED);
        OrderSingle order = ClientTest.createOrderSingle();
        ClientManager.getInstance().sendOrder(order);
        Validations.validate((OrderSingle)order);
        order.setOrderID(null);
        OrderValidationFailureTest.verifySingle(order, (I18NBoundMessage)Messages.VALIDATION_ORDERID);
        order = ClientTest.createOrderSingle();
        order.setOrderType(null);
        OrderValidationFailureTest.verifySingle(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_TYPE);
        order = ClientTest.createOrderSingle();
        order.setQuantity(null);
        OrderValidationFailureTest.verifySingle(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_QUANTITY);
        order = ClientTest.createOrderSingle();
        order.setSide(null);
        OrderValidationFailureTest.verifySingle(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_SIDE);
        order = ClientTest.createOrderSingle();
        order.setInstrument(null);
        OrderValidationFailureTest.verifySingle(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_INSTRUMENT);
        order = ClientTest.createOrderSingle();
        order.setInstrument((Instrument)OPTION_INVALID_EXPIRY);
        OrderValidationFailureTest.verifySingle(order, (I18NBoundMessage)EXPECTED_EXPIRY_FAIL_MESSAGE);
        order = ClientTest.createOrderSingle();
        order.setInstrument(UNKNOWN_INSTRUMENT);
        OrderValidationFailureTest.verifySingle(order, (I18NBoundMessage)EXPECTED_UNKNOWN_INSTRUMENT_MESSAGE);
    }

    @Test
    public void orderReplace() throws Exception {
        OrderValidationFailureTest.verifyReplace(null, (I18NBoundMessage)Messages.NO_ORDER_SUPPLIED);
        OrderReplace order = ClientTest.createOrderReplace();
        ClientManager.getInstance().sendOrder(order);
        Validations.validate((OrderReplace)order);
        order.setOrderID(null);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)Messages.VALIDATION_ORDERID);
        order = ClientTest.createOrderReplace();
        order.setOriginalOrderID(null);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)Messages.VALIDATION_ORIG_ORDERID);
        order = ClientTest.createOrderReplace();
        order.setOrderType(null);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_TYPE);
        order = ClientTest.createOrderReplace();
        order.setQuantity(null);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_QUANTITY);
        order = ClientTest.createOrderReplace();
        order.setSide(null);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_SIDE);
        order = ClientTest.createOrderReplace();
        order.setInstrument(null);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_INSTRUMENT);
        order = ClientTest.createOrderReplace();
        order.setInstrument((Instrument)OPTION_INVALID_EXPIRY);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)EXPECTED_EXPIRY_FAIL_MESSAGE);
        order = ClientTest.createOrderReplace();
        order.setInstrument(UNKNOWN_INSTRUMENT);
        OrderValidationFailureTest.verifyReplace(order, (I18NBoundMessage)EXPECTED_UNKNOWN_INSTRUMENT_MESSAGE);
    }

    @Test
    public void orderCancel() throws Exception {
        OrderValidationFailureTest.verifyCancel(null, (I18NBoundMessage)Messages.NO_ORDER_SUPPLIED);
        OrderCancel order = ClientTest.createOrderCancel();
        ClientManager.getInstance().sendOrder(order);
        Validations.validate((OrderCancel)order);
        order.setOrderID(null);
        OrderValidationFailureTest.verifyCancel(order, (I18NBoundMessage)Messages.VALIDATION_ORDERID);
        order = ClientTest.createOrderCancel();
        order.setOriginalOrderID(null);
        OrderValidationFailureTest.verifyCancel(order, (I18NBoundMessage)Messages.VALIDATION_ORIG_ORDERID);
        order = ClientTest.createOrderCancel();
        order.setQuantity(null);
        OrderValidationFailureTest.verifyCancel(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_QUANTITY);
        order = ClientTest.createOrderCancel();
        order.setSide(null);
        OrderValidationFailureTest.verifyCancel(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_SIDE);
        order = ClientTest.createOrderCancel();
        order.setInstrument(null);
        OrderValidationFailureTest.verifyCancel(order, (I18NBoundMessage)Messages.VALIDATION_ORDER_INSTRUMENT);
        order = ClientTest.createOrderCancel();
        order.setInstrument((Instrument)OPTION_INVALID_EXPIRY);
        OrderValidationFailureTest.verifyCancel(order, (I18NBoundMessage)EXPECTED_EXPIRY_FAIL_MESSAGE);
        order = ClientTest.createOrderCancel();
        order.setInstrument(UNKNOWN_INSTRUMENT);
        OrderValidationFailureTest.verifyCancel(order, (I18NBoundMessage)EXPECTED_UNKNOWN_INSTRUMENT_MESSAGE);
    }

    @Test
    public void orderFIX() throws Exception {
        OrderValidationFailureTest.verifyRaw(null, Messages.NO_ORDER_SUPPLIED);
        Validations.validate((FIXOrder)ClientTest.createOrderFIX());
    }

    @Test
    public void suggestions() throws Exception {
        OrderValidationFailureTest.verifySuggestion(null, Messages.NO_SUGGEST_SUPPLIED);
        OrderSingleSuggestion suggest = Factory.getInstance().createOrderSingleSuggestion();
        suggest.setIdentifier(null);
        suggest.setOrder(ClientTest.createOrderSingle());
        suggest.setScore(BigDecimal.ONE);
        OrderValidationFailureTest.verifySuggestion(suggest, Messages.VALIDATION_SUGGEST_IDENTIFIER);
        suggest.setIdentifier("id");
        suggest.setOrder(null);
        OrderValidationFailureTest.verifySuggestion(suggest, Messages.VALIDATION_SUGGEST_ORDER);
        suggest.setOrder(ClientTest.createOrderSingle());
        suggest.setScore(null);
        OrderValidationFailureTest.verifySuggestion(suggest, Messages.VALIDATION_SUGGEST_SCORE);
        suggest.setScore(BigDecimal.ONE);
        Validations.validate((OrderSingleSuggestion)suggest);
    }

    @Test
    public void instrument() throws Exception {
        new ExpectedFailure<OrderValidationException>((I18NBoundMessage)Messages.VALIDATION_ORDER_INSTRUMENT){

            protected void run() throws Exception {
                Validations.validateInstrument(null);
            }
        };
        new ExpectedFailure<OrderValidationException>((I18NBoundMessage)EXPECTED_UNKNOWN_INSTRUMENT_MESSAGE){

            protected void run() throws Exception {
                Validations.validateInstrument((Instrument)UNKNOWN_INSTRUMENT);
            }
        };
        Validations.validateInstrument((Instrument)new Equity("eq"));
        Validations.validateInstrument((Instrument)new Option("eq", "200010", BigDecimal.TEN, OptionType.Call));
    }

    @BeforeClass
    public static void setup() throws Exception {
        LoggerConfiguration.logSetup();
        sServer = new MockServer();
        String u = "u";
        ClientManager.init((ClientParameters)new ClientParameters(u, u.toCharArray(), "tcp://localhost:61616", "0.0.0.0", 9000));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        if (ClientManager.isInitialized()) {
            ClientManager.getInstance().close();
        }
        if (sServer != null) {
            sServer.close();
            sServer = null;
        }
    }

    private static void verifySingle(final OrderSingle inOrder, I18NBoundMessage inExpectedMessage) throws Exception {
        new ExpectedFailure<OrderValidationException>(inExpectedMessage){

            protected void run() throws Exception {
                Validations.validate((OrderSingle)inOrder);
            }
        };
        new ExpectedFailure<OrderValidationException>(inExpectedMessage){

            protected void run() throws Exception {
                ClientManager.getInstance().sendOrder(inOrder);
            }
        };
    }

    private static void verifyReplace(final OrderReplace inOrder, I18NBoundMessage inExpectedMessage) throws Exception {
        new ExpectedFailure<OrderValidationException>(inExpectedMessage){

            protected void run() throws Exception {
                Validations.validate((OrderReplace)inOrder);
            }
        };
        new ExpectedFailure<OrderValidationException>(inExpectedMessage){

            protected void run() throws Exception {
                ClientManager.getInstance().sendOrder(inOrder);
            }
        };
    }

    private static void verifyCancel(final OrderCancel inOrder, I18NBoundMessage inExpectedMessage) throws Exception {
        new ExpectedFailure<OrderValidationException>(inExpectedMessage){

            protected void run() throws Exception {
                Validations.validate((OrderCancel)inOrder);
            }
        };
        new ExpectedFailure<OrderValidationException>(inExpectedMessage){

            protected void run() throws Exception {
                ClientManager.getInstance().sendOrder(inOrder);
            }
        };
    }

    private static void verifyRaw(final FIXOrder inOrder, I18NMessage0P inExpectedMessage) throws Exception {
        new ExpectedFailure<OrderValidationException>((I18NBoundMessage)inExpectedMessage){

            protected void run() throws Exception {
                Validations.validate((FIXOrder)inOrder);
            }
        };
        new ExpectedFailure<OrderValidationException>((I18NBoundMessage)inExpectedMessage){

            protected void run() throws Exception {
                ClientManager.getInstance().sendOrderRaw(inOrder);
            }
        };
    }

    private static void verifySuggestion(final OrderSingleSuggestion inSuggest, I18NMessage0P inExpectedMessage) throws Exception {
        new ExpectedFailure<OrderValidationException>((I18NBoundMessage)inExpectedMessage){

            protected void run() throws Exception {
                Validations.validate((OrderSingleSuggestion)inSuggest);
            }
        };
    }

    static {
        EXPECTED_EXPIRY_FAIL_MESSAGE = new I18NBoundMessage1P(org.marketcetera.client.instruments.Messages.INVALID_OPTION_EXPIRY_FORMAT, (Serializable)((Object)OPTION_INVALID_EXPIRY.getExpiry()));
    }
}

