/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.instruments;

import java.io.Serializable;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.instruments.InstrumentValidationHandler;
import org.marketcetera.client.instruments.Messages;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;

public class FutureValidationHandler
extends InstrumentValidationHandler<Future> {
    public static void validateExpirationYear(String inExpirationYear) throws OrderValidationException {
        if (inExpirationYear == null || inExpirationYear.isEmpty()) {
            return;
        }
        try {
            if (Integer.parseInt(inExpirationYear) <= 0) {
                throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_FUTURE_EXPIRATION_YEAR_FORMAT, (Serializable)((Object)inExpirationYear)));
            }
        }
        catch (OrderValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_FUTURE_EXPIRATION_YEAR_FORMAT, (Serializable)((Object)inExpirationYear)));
        }
    }

    public static void validateExpirationYear(int inExpirationYear) throws OrderValidationException {
        if (inExpirationYear <= 0) {
            throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_FUTURE_EXPIRATION_YEAR_FORMAT, (Serializable)Integer.valueOf(inExpirationYear)));
        }
    }

    public FutureValidationHandler() {
        super(Future.class);
    }

    @Override
    public void validate(Instrument inInstrument) throws OrderValidationException {
        Future option = (Future)inInstrument;
        FutureValidationHandler.validateExpirationYear(option.getExpirationYear());
    }
}

