/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.MockServer;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.trade.Factory;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.RegExAssert;

@ClassVersion(value="$Id: FactoryIntegrationTest.java 16154 2012-07-14 16:34:05Z colin $")
public class FactoryIntegrationTest {
    private static MockServer sServer;
    private Client mClient;

    @BeforeClass
    public static void setup() throws Exception {
        LoggerConfiguration.logSetup();
        FactoryIntegrationTest.initServer();
    }

    @AfterClass
    public static void closeServer() throws Exception {
        if (sServer != null) {
            sServer.close();
            sServer = null;
        }
    }

    @Test
    public void nullIDPrefix() throws Exception {
        this.initClient(null);
        String idPattern = "MyID\\d+00\\d";
        Factory factory = Factory.getInstance();
        RegExAssert.assertMatches((String)idPattern, (String)factory.createOrderSingle().getOrderID().toString());
        RegExAssert.assertMatches((String)idPattern, (String)factory.createOrderCancel(null).getOrderID().toString());
        RegExAssert.assertMatches((String)idPattern, (String)factory.createOrderReplace(null).getOrderID().toString());
    }

    @Test
    public void idPrefix() throws Exception {
        String prefix = "cetera";
        this.initClient(prefix);
        String idPattern = prefix + "MyID" + "\\d+00\\d";
        Factory factory = Factory.getInstance();
        RegExAssert.assertMatches((String)idPattern, (String)factory.createOrderSingle().getOrderID().toString());
        RegExAssert.assertMatches((String)idPattern, (String)factory.createOrderCancel(null).getOrderID().toString());
        RegExAssert.assertMatches((String)idPattern, (String)factory.createOrderReplace(null).getOrderID().toString());
    }

    @Test
    public void generateMultipleIDs() throws Exception {
        String prefix = "cetera";
        this.initClient(prefix);
        Factory factory = Factory.getInstance();
        String idPattern = prefix + "MyID" + "\\d{4,5}";
        int max = 2997;
        for (int i = 0; i < max; ++i) {
            RegExAssert.assertMatches((String)idPattern, (String)factory.createOrderSingle().getOrderID().toString());
        }
    }

    @After
    public void closeClient() {
        if (this.mClient != null) {
            this.mClient.close();
        }
    }

    private void initClient(String inOrderIDPrefix) throws ConnectionException, ClientInitException {
        ClientParameters parameters = new ClientParameters("name", "name".toCharArray(), "tcp://localhost:61616", "0.0.0.0", 9000, inOrderIDPrefix);
        ClientManager.init((ClientParameters)parameters);
        this.mClient = ClientManager.getInstance();
    }

    private static void initServer() {
        if (sServer == null) {
            sServer = new MockServer();
        }
    }
}

