/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: MockLoginModule.java 16154 2012-07-14 16:34:05Z colin $")
public class MockLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callback;
    private Set<Principal> principals = new HashSet<Principal>();
    private String username;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callback = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Name"), new PasswordCallback("Password", false)};
        try {
            this.callback.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            FailedLoginException ex = new FailedLoginException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            FailedLoginException ex = new FailedLoginException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        char[] password = ((PasswordCallback)callbacks[1]).getPassword();
        String pass = String.valueOf(password);
        if (!ObjectUtils.equals((Object)this.username, (Object)pass)) {
            throw new FailedLoginException(this.username + "<>" + pass);
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"login done for user {}", (Object[])new Object[]{this.username});
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.username));
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Aborting login for user {}", (Object[])new Object[]{this.username});
        this.clear();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        return true;
    }

    private void clear() {
        this.username = null;
    }
}

