/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import org.marketcetera.client.Service;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.core.position.PositionKeyFactory;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReportImpl;
import org.marketcetera.trade.FIXMessageWrapper;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Hierarchy;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.RemoteCaller;
import org.marketcetera.util.ws.stateful.ServiceBaseImpl;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.wrappers.DateWrapper;
import org.marketcetera.util.ws.wrappers.MapWrapper;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: MockServiceImpl.java 16888 2014-04-22 18:32:36Z colin $")
public class MockServiceImpl
extends ServiceBaseImpl<Object>
implements Service {
    private int mNextOrderID;
    private String userdata;
    static final String ID_PREFIX = "MyID";
    private int mHeartbeatCount = 0;
    private boolean mHeartbeatSuccess = true;
    private boolean mServiceInvoked = false;
    static ReportBaseImpl[] sReports = null;
    static boolean sActive = true;
    static final Map<PositionKey<Equity>, BigDecimal> POSITIONS;
    static final Map<PositionKey<Future>, BigDecimal> FUTURES_POSITIONS;

    public MockServiceImpl(SessionManager<Object> sessionManager) {
        super(sessionManager);
    }

    private BrokersStatus getBrokersStatusImpl() {
        LinkedList<BrokerStatus> list = new LinkedList<BrokerStatus>();
        list.add(new BrokerStatus("N1", new BrokerID("ID1"), true));
        list.add(new BrokerStatus("N2", new BrokerID("ID2"), false));
        return new BrokersStatus(list);
    }

    private UserInfo getUserInfoImpl(UserID id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return new UserInfo("bob", id, sActive, false, null);
    }

    private ReportBaseImpl[] getReportsSinceImpl(Date date) throws MessageCreationException {
        return sReports;
    }

    private BigDecimal getPositionAsOfImpl(Date date, Equity equity) {
        return new BigDecimal(date.getTime());
    }

    private MapWrapper<PositionKey<Equity>, BigDecimal> getPositionsAsOfImpl(Date date) {
        return new MapWrapper(POSITIONS);
    }

    private BigDecimal getFuturePositionAsOfImpl(Date inDate, Future inFuture) {
        return new BigDecimal(inDate.getTime());
    }

    private MapWrapper<PositionKey<Future>, BigDecimal> getFuturePositionsAsOfImpl(Date date) {
        return new MapWrapper(FUTURES_POSITIONS);
    }

    private BigDecimal getOptionPositionAsOfImpl(Date inRaw, Option inOption) {
        return inOption.getStrikePrice().add(BigDecimal.valueOf(inRaw.getTime()));
    }

    private MapWrapper<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOfImpl(Date inRaw) {
        HashMap<PositionKey, BigDecimal> map = new HashMap<PositionKey, BigDecimal>();
        map.put(PositionKeyFactory.createOptionKey((String)"OPT", (String)"20101010", (BigDecimal)BigDecimal.TEN, (OptionType)OptionType.Call, (String)"acc", (String)"tra"), BigDecimal.valueOf(inRaw.getTime()));
        return new MapWrapper(map);
    }

    private MapWrapper<PositionKey<Option>, BigDecimal> getOptionPositionsAsOfImpl(Date inRaw, String ... inSymbols) {
        HashMap<PositionKey, BigDecimal> map = new HashMap<PositionKey, BigDecimal>();
        if (inSymbols != null) {
            for (String symbol : inSymbols) {
                map.put(PositionKeyFactory.createOptionKey((String)symbol, (String)"20101010", (BigDecimal)BigDecimal.TEN, (OptionType)OptionType.Call, (String)"acc", (String)"tra"), BigDecimal.valueOf(inRaw.getTime()));
            }
        }
        return new MapWrapper(map);
    }

    private String getNextOrderIDImpl() {
        return ID_PREFIX + this.mNextOrderID++;
    }

    private String getUnderlyingImpl(String inOptionRoot) {
        this.mServiceInvoked = true;
        return inOptionRoot;
    }

    private Collection<String> getOptionRootsImpl(String inUnderlying) {
        this.mServiceInvoked = true;
        if (inUnderlying == null) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < inUnderlying.length(); ++i) {
            list.add(inUnderlying);
        }
        return list;
    }

    public boolean isServiceInvoked() {
        return this.mServiceInvoked;
    }

    public void resetServiceInvoked() {
        this.mServiceInvoked = false;
    }

    boolean toggleServerStatus() {
        this.mHeartbeatSuccess = !this.mHeartbeatSuccess;
        return this.mHeartbeatSuccess;
    }

    int getHeartbeatCount() {
        return this.mHeartbeatCount;
    }

    public BrokersStatus getBrokersStatus(ClientContext context) throws RemoteException {
        return (BrokersStatus)new RemoteCaller<Object, BrokersStatus>(this.getSessionManager()){

            protected BrokersStatus call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getBrokersStatusImpl();
            }
        }.execute(context);
    }

    public UserInfo getUserInfo(ClientContext context, final UserID id) throws RemoteException {
        return (UserInfo)new RemoteCaller<Object, UserInfo>(this.getSessionManager()){

            protected UserInfo call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getUserInfoImpl(id);
            }
        }.execute(context);
    }

    public ReportBaseImpl[] getReportsSince(ClientContext context, final DateWrapper date) throws RemoteException {
        return (ReportBaseImpl[])new RemoteCaller<Object, ReportBaseImpl[]>(this.getSessionManager()){

            protected ReportBaseImpl[] call(ClientContext context, SessionHolder<Object> sessionHolder) throws MessageCreationException {
                return MockServiceImpl.this.getReportsSinceImpl((Date)date.getRaw());
            }
        }.execute(context);
    }

    public BigDecimal getEquityPositionAsOf(ClientContext context, final DateWrapper date, final Equity equity) throws RemoteException {
        return (BigDecimal)new RemoteCaller<Object, BigDecimal>(this.getSessionManager()){

            protected BigDecimal call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getPositionAsOfImpl((Date)date.getRaw(), equity);
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(ClientContext context, final DateWrapper date) throws RemoteException {
        return (MapWrapper)new RemoteCaller<Object, MapWrapper<PositionKey<Equity>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Equity>, BigDecimal> call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getPositionsAsOfImpl((Date)date.getRaw());
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(ClientContext inContext, final DateWrapper inDate) throws RemoteException {
        return (MapWrapper)new RemoteCaller<Object, MapWrapper<PositionKey<Future>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Future>, BigDecimal> call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getFuturePositionsAsOfImpl((Date)inDate.getRaw());
            }
        }.execute(inContext);
    }

    public BigDecimal getFuturePositionAsOf(ClientContext inContext, final DateWrapper inDate, final Future inFuture) throws RemoteException {
        return (BigDecimal)new RemoteCaller<Object, BigDecimal>(this.getSessionManager()){

            protected BigDecimal call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getFuturePositionAsOfImpl((Date)inDate.getRaw(), inFuture);
            }
        }.execute(inContext);
    }

    public BigDecimal getOptionPositionAsOf(ClientContext context, final DateWrapper date, final Option option) throws RemoteException {
        return (BigDecimal)new RemoteCaller<Object, BigDecimal>(this.getSessionManager()){

            protected BigDecimal call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getOptionPositionAsOfImpl((Date)date.getRaw(), option);
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(ClientContext context, final DateWrapper date) throws RemoteException {
        return (MapWrapper)new RemoteCaller<Object, MapWrapper<PositionKey<Option>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Option>, BigDecimal> call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getAllOptionPositionsAsOfImpl((Date)date.getRaw());
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(ClientContext context, final DateWrapper date, final String ... symbols) throws RemoteException {
        return (MapWrapper)new RemoteCaller<Object, MapWrapper<PositionKey<Option>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Option>, BigDecimal> call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getOptionPositionsAsOfImpl((Date)date.getRaw(), symbols);
            }
        }.execute(context);
    }

    public String getUnderlying(ClientContext context, final String optionRoot) throws RemoteException {
        return (String)new RemoteCaller<Object, String>(this.getSessionManager()){

            protected String call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getUnderlyingImpl(optionRoot);
            }
        }.execute(context);
    }

    public Collection<String> getOptionRoots(ClientContext context, final String underlying) throws RemoteException {
        return (Collection)new RemoteCaller<Object, Collection<String>>(this.getSessionManager()){

            protected Collection<String> call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getOptionRootsImpl(underlying);
            }
        }.execute(context);
    }

    public String getNextOrderID(ClientContext context) throws RemoteException {
        return (String)new RemoteCaller<Object, String>(this.getSessionManager()){

            protected String call(ClientContext context, SessionHolder<Object> sessionHolder) {
                return MockServiceImpl.this.getNextOrderIDImpl();
            }
        }.execute(context);
    }

    public void heartbeat(ClientContext context) throws RemoteException {
        if (!this.mHeartbeatSuccess) {
            throw new IllegalStateException();
        }
        ++this.mHeartbeatCount;
    }

    public String getUserData(ClientContext inContext) throws RemoteException {
        return this.userdata;
    }

    public void setUserData(ClientContext inContext, String inData) throws RemoteException {
        this.userdata = inData;
    }

    public BigDecimal getCurrencyPositionAsOf(@WebParam(name="context") ClientContext context, @WebParam(name="date") DateWrapper date, @WebParam(name="currency") Currency currency) throws RemoteException {
        return null;
    }

    public MapWrapper<PositionKey<Currency>, BigDecimal> getAllCurrencyPositionsAsOf(@WebParam(name="context") ClientContext context, @WebParam(name="date") DateWrapper date) throws RemoteException {
        return null;
    }

    public void deleteReport(ClientContext inContext, ExecutionReportImpl inReport) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public Instrument resolveSymbol(@WebParam(name="context") ClientContext inContext, @WebParam(name="symbol") String inSymbol) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public List<ReportBaseImpl> getOpenOrders(@WebParam(name="context") ClientContext inContext) throws RemoteException {
        return Collections.emptyList();
    }

    public OrderID getRootOrderIdFor(ClientContext inServiceContext, OrderID inOrderID) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void addReport(ClientContext inContext, FIXMessageWrapper inReport, BrokerID inBrokerID, Hierarchy inHierarchy) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    static {
        HashMap<PositionKey, BigDecimal> positions = new HashMap<PositionKey, BigDecimal>();
        positions.put(PositionKeyFactory.createEquityKey((String)"A", (String)"acme", (String)"bob"), BigDecimal.TEN);
        positions.put(PositionKeyFactory.createEquityKey((String)"B", (String)"wally", (String)"sue"), BigDecimal.ONE.negate());
        POSITIONS = Collections.unmodifiableMap(positions);
        HashMap<PositionKey, BigDecimal> futurePositions = new HashMap<PositionKey, BigDecimal>();
        futurePositions.put(PositionKeyFactory.createFutureKey((String)"ENOQ1-11", (String)"201103", (String)"acme", (String)"bob"), BigDecimal.TEN);
        futurePositions.put(PositionKeyFactory.createFutureKey((String)"BRN12N", (String)"201207", (String)"wally", (String)"sue"), BigDecimal.ONE.negate());
        FUTURES_POSITIONS = Collections.unmodifiableMap(futurePositions);
    }
}

