/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientModuleMXBean;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.ReportListener;
import org.marketcetera.metrics.ThreadedMetric;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataReceiver;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.ReceiveDataException;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.RequestID;
import org.marketcetera.module.StopDataFlowException;
import org.marketcetera.module.UnsupportedDataTypeException;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ClientModule.java 16154 2012-07-14 16:34:05Z colin $")
class ClientModule
extends Module
implements DataReceiver,
DataEmitter,
ClientModuleMXBean {
    private final Map<RequestID, ReportListener> mRequestTable = new Hashtable<RequestID, ReportListener>();

    public void receiveData(DataFlowID inFlowID, Object inData) throws ReceiveDataException {
        block8: {
            ThreadedMetric.event((String)"client-IN", (Object[])new Object[0]);
            try {
                if (inData instanceof OrderSingle) {
                    this.getClient().sendOrder((OrderSingle)inData);
                    break block8;
                }
                if (inData instanceof OrderCancel) {
                    this.getClient().sendOrder((OrderCancel)inData);
                    break block8;
                }
                if (inData instanceof OrderReplace) {
                    this.getClient().sendOrder((OrderReplace)inData);
                    break block8;
                }
                if (inData instanceof FIXOrder) {
                    this.getClient().sendOrderRaw((FIXOrder)inData);
                    break block8;
                }
                throw new UnsupportedDataTypeException((I18NBoundMessage)new I18NBoundMessage2P(Messages.UNSUPPORTED_DATA_TYPE, (Serializable)((Object)inFlowID.getValue()), (Serializable)((Object)ObjectUtils.toString((Object)inData))));
            }
            catch (ConnectionException e) {
                throw new ReceiveDataException((Throwable)((Object)e), (I18NBoundMessage)new I18NBoundMessage1P(Messages.SEND_ORDER_FAIL_NO_CONNECT, (Serializable)((Object)ObjectUtils.toString((Object)inData))));
            }
            catch (OrderValidationException e) {
                throw new ReceiveDataException((Throwable)((Object)e), (I18NBoundMessage)new I18NBoundMessage2P(Messages.SEND_ORDER_VALIDATION_FAILED, (Serializable)((Object)inFlowID.getValue()), (Serializable)((Object)ObjectUtils.toString((Object)inData))));
            }
            catch (ClientInitException e) {
                throw new StopDataFlowException((Throwable)((Object)e), (I18NBoundMessage)new I18NBoundMessage1P(Messages.SEND_ORDER_FAIL_NO_CONNECT, (Serializable)((Object)ObjectUtils.toString((Object)inData))));
            }
        }
    }

    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws RequestDataException {
        if (inRequest.getData() != null) {
            throw new IllegalRequestParameterValue((I18NBoundMessage)Messages.REQUEST_PARAMETER_SPECIFIED);
        }
        try {
            ReportListenerEmitter listener = new ReportListenerEmitter(inSupport);
            this.getClient().addReportListener(listener);
            this.mRequestTable.put(inSupport.getRequestID(), listener);
        }
        catch (ClientInitException e) {
            throw new RequestDataException((Throwable)((Object)e), (I18NBoundMessage)Messages.REQUEST_CLIENT_NOT_INITIALIZED);
        }
    }

    public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
        ReportListener listener = this.mRequestTable.remove(inRequestID);
        try {
            this.getClient().removeReportListener(listener);
        }
        catch (ClientInitException e) {
            Messages.LOG_CLIENT_NOT_INIT_CANCEL_REQUEST.error((Object)this, (Throwable)((Object)e), (Object)inRequestID.toString());
        }
    }

    @Override
    public void reconnect() throws RuntimeException {
        try {
            this.getClient().reconnect();
        }
        catch (I18NException e) {
            throw new RuntimeException(e.getLocalizedDetail());
        }
    }

    @Override
    public ClientParameters getParameters() {
        try {
            return this.getClient().getParameters();
        }
        catch (ClientInitException e) {
            throw new RuntimeException(e.getLocalizedDetail());
        }
    }

    @Override
    public Date getLastConnectTime() throws RuntimeException {
        try {
            return this.getClient().getLastConnectTime();
        }
        catch (ClientInitException e) {
            throw new RuntimeException(e.getLocalizedDetail());
        }
    }

    protected ClientModule(ModuleURN inURN, boolean inAutoStart) {
        super(inURN, inAutoStart);
    }

    protected void preStart() throws ModuleException {
    }

    protected void preStop() throws ModuleException {
    }

    private Client getClient() throws ClientInitException {
        return ClientManager.getInstance();
    }

    private static class ReportListenerEmitter
    implements ReportListener {
        private final DataEmitterSupport mSupport;

        public ReportListenerEmitter(DataEmitterSupport inSupport) {
            this.mSupport = inSupport;
        }

        @Override
        public void receiveExecutionReport(ExecutionReport inReport) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Emitting Report {}", (Object[])new Object[]{inReport});
            this.mSupport.send((Object)inReport);
        }

        @Override
        public void receiveCancelReject(OrderCancelReject inReport) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Emitting Cancel Reject {}", (Object[])new Object[]{inReport});
            this.mSupport.send((Object)inReport);
        }
    }
}

