/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientModule;
import org.marketcetera.client.ClientModuleFactoryMXBean;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleCreationException;
import org.marketcetera.module.ModuleFactory;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ClientModuleFactory.java 16841 2014-02-20 19:59:04Z colin $")
public class ClientModuleFactory
extends ModuleFactory
implements ClientModuleFactoryMXBean {
    private String mURL;
    private String mUsername;
    private String mPassword;
    private String mHostname;
    private int mPort;
    private String mIDPrefix;
    static final ModuleURN PROVIDER_URN = new ModuleURN("metc:server:system");
    public static final ModuleURN INSTANCE_URN = new ModuleURN(PROVIDER_URN, "single");

    public Module create(Object ... inParameters) throws ModuleCreationException {
        if (this.getURL() != null && !ClientManager.isInitialized()) {
            ClientParameters parameters = new ClientParameters(this.getUsername(), this.getPassword() == null ? null : this.getPassword().toCharArray(), this.getURL(), this.getHostname(), this.getPort(), this.getIDPrefix());
            try {
                ClientManager.init(parameters);
            }
            catch (ConnectionException e) {
                throw new ModuleCreationException((Throwable)((Object)e), (I18NBoundMessage)Messages.CREATE_MODULE_ERROR);
            }
            catch (ClientInitException e) {
                throw new ModuleCreationException((Throwable)((Object)e), (I18NBoundMessage)Messages.CREATE_MODULE_ERROR);
            }
        }
        return new ClientModule(INSTANCE_URN, true);
    }

    public ClientModuleFactory() {
        super(PROVIDER_URN, (I18NBoundMessage)Messages.PROVIDER_DESCRIPTION, false, false, new Class[0]);
    }

    @Override
    public String getURL() {
        return this.mURL;
    }

    @Override
    public void setURL(String inURL) {
        this.mURL = inURL;
    }

    @Override
    public String getUsername() {
        return this.mUsername;
    }

    @Override
    public void setUsername(String inUsername) {
        this.mUsername = inUsername;
    }

    @Override
    public void setPassword(String inPassword) {
        this.mPassword = inPassword;
    }

    private String getPassword() {
        return this.mPassword;
    }

    @Override
    public String getHostname() {
        return this.mHostname;
    }

    @Override
    public void setHostname(String inHostname) {
        this.mHostname = inHostname;
    }

    @Override
    public int getPort() {
        return this.mPort;
    }

    @Override
    public void setPort(int inPort) {
        this.mPort = inPort;
    }

    @Override
    public String getIDPrefix() {
        return this.mIDPrefix;
    }

    @Override
    public void setIDPrefix(String inIDPrefix) {
        this.mIDPrefix = inIDPrefix;
    }
}

