/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.xml.bind.JAXBException;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.jms.JMSFIXMessageConverter;
import org.marketcetera.client.jms.JMSXMLMessageConverter;
import org.marketcetera.client.jms.JmsFactory;
import org.marketcetera.client.jms.OrderEnvelope;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.client.jms.ReplyHandler;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import quickfix.Message;

@ClassVersion(value="$Id: IncomingJmsFactory.java 16614 2013-07-03 22:35:32Z colin $")
public class IncomingJmsFactory
extends JmsFactory {
    private final ExceptionListener mExceptionListener;

    public IncomingJmsFactory(ConnectionFactory connectionFactory, ExceptionListener exceptionListener) {
        super(connectionFactory);
        this.mExceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.mExceptionListener;
    }

    private SimpleMessageListenerContainer registerHandler(Object handler, String handlerMethod, String inDstName, boolean isInDstTopic, String replyDstName, boolean isReplyDstTopic, MessageConverter messageConverter) {
        MessageListenerAdapter adapter = new MessageListenerAdapter(handler);
        adapter.setDefaultListenerMethod(handlerMethod);
        adapter.setMessageConverter(messageConverter);
        if (replyDstName != null) {
            if (isReplyDstTopic) {
                adapter.setDefaultResponseTopicName(replyDstName);
            } else {
                adapter.setDefaultResponseQueueName(replyDstName);
            }
        }
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(this.getConnectionFactory());
        container.setDestinationName(inDstName);
        container.setPubSubDomain(isInDstTopic);
        container.setMessageListener((Object)adapter);
        if (this.getExceptionListener() != null) {
            container.setExceptionListener(this.getExceptionListener());
        }
        container.afterPropertiesSet();
        container.start();
        return container;
    }

    public SimpleMessageListenerContainer registerHandler(ReplyHandler<?> handler, String inDstName, boolean isInDstTopic, String replyDstName, boolean isReplyDstTopic, MessageConverter messageConverter) {
        return this.registerHandler(handler, "replyToMessage", inDstName, isInDstTopic, replyDstName, isReplyDstTopic, messageConverter);
    }

    public SimpleMessageListenerContainer registerHandler(ReceiveOnlyHandler<?> handler, String inDstName, boolean isInDstTopic, MessageConverter messageConverter) {
        return this.registerHandler(handler, "receiveMessage", inDstName, isInDstTopic, null, false, messageConverter);
    }

    public SimpleMessageListenerContainer registerHandler(ReplyHandler<?> handler, String inDstName, boolean isInDstTopic, String replyDstName, boolean isReplyDstTopic) {
        return this.registerHandler(handler, inDstName, isInDstTopic, replyDstName, isReplyDstTopic, (MessageConverter)new SimpleMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandler(ReceiveOnlyHandler<?> handler, String inDstName, boolean isInDstTopic) {
        return this.registerHandler(handler, inDstName, isInDstTopic, (MessageConverter)new SimpleMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerQ(ReplyHandler<Message> handler, String inDstName, boolean isInDstTopic, String replyDstName, boolean isReplyDstTopic) {
        return this.registerHandler(handler, inDstName, isInDstTopic, replyDstName, isReplyDstTopic, new JMSFIXMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerQ(ReceiveOnlyHandler<Message> handler, String inDstName, boolean isInDstTopic) {
        return this.registerHandler(handler, inDstName, isInDstTopic, new JMSFIXMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerTMX(ReplyHandler<TradeMessage> handler, String inDstName, boolean isInDstTopic, String replyDstName, boolean isReplyDstTopic) throws JAXBException {
        return this.registerHandler(handler, inDstName, isInDstTopic, replyDstName, isReplyDstTopic, new JMSXMLMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerTMX(ReceiveOnlyHandler<TradeMessage> handler, String inDstName, boolean isInDstTopic) throws JAXBException {
        return this.registerHandler(handler, inDstName, isInDstTopic, new JMSXMLMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerOEX(ReceiveOnlyHandler<OrderEnvelope> handler, String inDstName, boolean isInDstTopic) throws JAXBException {
        return this.registerHandler(handler, inDstName, isInDstTopic, new JMSXMLMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerOEX(ReplyHandler<OrderEnvelope> handler, String inDstName, boolean isInDstTopic, String replyDstName, boolean isReplyDstTopic) throws JAXBException {
        return this.registerHandler(handler, inDstName, isInDstTopic, replyDstName, isReplyDstTopic, new JMSXMLMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerBSX(ReplyHandler<BrokerStatus> handler, String inDstName, boolean isInDstTopic, String replyDstName, boolean isReplyDstTopic) throws JAXBException {
        return this.registerHandler(handler, inDstName, isInDstTopic, replyDstName, isReplyDstTopic, new JMSXMLMessageConverter());
    }

    public SimpleMessageListenerContainer registerHandlerBSX(ReceiveOnlyHandler<BrokerStatus> handler, String inDstName, boolean isInDstTopic) throws JAXBException {
        return this.registerHandler(handler, inDstName, isInDstTopic, new JMSXMLMessageConverter());
    }
}

