/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.marketcetera.client.jms.Messages;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import quickfix.InvalidMessage;
import quickfix.Message;

public class JMSFIXMessageConverter
implements MessageConverter {
    private static final String FIX_PREAMBLE = "8=FIX";
    boolean serializeToString = true;
    public static final String BYTES_MESSAGE_CHARSET = "UTF-16";

    public boolean isSerializeToString() {
        return this.serializeToString;
    }

    public void setSerializeToString(boolean serializeToString) {
        this.serializeToString = serializeToString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object fromMessage(javax.jms.Message message) throws JMSException, MessageConversionException {
        Message qfMessage = null;
        if (message instanceof TextMessage) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Received JMS msg: {}", (Object[])new Object[]{message});
            try {
                return new Message(((TextMessage)message).getText());
            }
            catch (InvalidMessage e) {
                Messages.ERROR_JMS_MESSAGE_CONVERSION.error((Object)this, (Object)e.getMessage());
                throw new MessageConversionException(Messages.ERROR_JMS_MESSAGE_CONVERSION.getText((Object)e.getMessage()), (Throwable)e);
            }
        }
        if (message instanceof BytesMessage) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Received JMS msg: {}", (Object[])new Object[]{message});
            try {
                BytesMessage bytesMessage = (BytesMessage)message;
                int length = (int)bytesMessage.getBodyLength();
                byte[] buf = new byte[length];
                bytesMessage.readBytes(buf);
                String possibleString = new String(buf, BYTES_MESSAGE_CHARSET);
                if (!possibleString.startsWith(FIX_PREAMBLE)) return qfMessage;
                return new Message(possibleString);
            }
            catch (Exception ex) {
                Messages.ERROR_JMS_MESSAGE_CONVERSION.error((Object)this, (Object)ex.getMessage());
                throw new MessageConversionException(Messages.ERROR_JMS_MESSAGE_CONVERSION.getText((Object)ex.getMessage()), (Throwable)ex);
            }
        }
        if (!(message instanceof ObjectMessage)) return qfMessage;
        return (Message)((ObjectMessage)message).getObject();
    }

    public javax.jms.Message toMessage(Object message, Session session) throws JMSException, MessageConversionException {
        TextMessage jmsMessage = null;
        if (this.serializeToString) {
            jmsMessage = session.createTextMessage(message.toString());
        } else if (message instanceof Serializable) {
            Serializable serializable = (Serializable)message;
            jmsMessage = session.createObjectMessage(serializable);
        }
        return jmsMessage;
    }
}

