/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.jms.Messages;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

@ClassVersion(value="$Id: JMSMessageConverter.java 16154 2012-07-14 16:34:05Z colin $")
public class JMSMessageConverter
implements MessageConverter {
    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Converting from JMS {}", (Object[])new Object[]{message});
        if (message instanceof ObjectMessage) {
            Serializable object = ((ObjectMessage)message).getObject();
            if (object instanceof TradeMessage) {
                return object;
            }
            throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_RECEIVED, (Serializable)((Object)ObjectUtils.toString((Object)object))).getText());
        }
        throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_RECEIVED, (Serializable)((Object)ObjectUtils.toString((Object)message))).getText());
    }

    public Message toMessage(Object inObject, Session session) throws JMSException, MessageConversionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Converting to JMS {}", (Object[])new Object[]{inObject});
        if (inObject instanceof TradeMessage) {
            return session.createObjectMessage((Serializable)inObject);
        }
        throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_TO_SEND, (Serializable)((Object)ObjectUtils.toString((Object)inObject))).getText());
    }
}

