/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.utils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientFactory;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.client.MockClient;
import org.marketcetera.client.utils.LiveOrderHistoryManager;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.marketdata.MarketDataFeedTestBase;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.utils.OrderHistoryManagerTest;
import org.marketcetera.util.log.I18NBoundMessage;

public class LiveOrderHistoryManagerTest {
    private static MockClient client;
    private static final AtomicInteger counter;

    @BeforeClass
    public static void once() throws Exception {
        LoggerConfiguration.logSetup();
        ClientManager.setClientFactory((ClientFactory)new MockClient.MockClientFactory());
        ClientManager.init(null);
        client = (MockClient)ClientManager.getInstance();
        OrderHistoryManagerTest.once();
    }

    @Before
    public void setup() throws Exception {
        client.reset();
    }

    @Test
    public void testConstructor() throws Exception {
        LiveOrderHistoryManager manager = new LiveOrderHistoryManager(null);
        Assert.assertEquals((Object)new Date(0L), (Object)manager.getReportHistoryOrigin());
        manager = new LiveOrderHistoryManager(new Date(Long.MIN_VALUE));
        Assert.assertEquals((Object)new Date(Long.MIN_VALUE), (Object)manager.getReportHistoryOrigin());
        manager = new LiveOrderHistoryManager(new Date(Long.MAX_VALUE));
        Assert.assertEquals((Object)new Date(Long.MAX_VALUE), (Object)manager.getReportHistoryOrigin());
        manager = new LiveOrderHistoryManager(new Date(0L));
        Assert.assertEquals((Object)new Date(0L), (Object)manager.getReportHistoryOrigin());
    }

    @Test
    public void testGetOpenOrders() throws Exception {
        final LiveOrderHistoryManager manager = new LiveOrderHistoryManager(null);
        Assert.assertFalse((boolean)manager.isRunning());
        new ExpectedFailure<IllegalStateException>(Messages.OPEN_ORDER_LIST_NOT_READY.getText()){

            protected void run() throws Exception {
                manager.getOpenOrders();
            }
        };
        manager.start();
        final Map openOrders = manager.getOpenOrders();
        final Set orderIds = manager.getOrderIds();
        Assert.assertTrue((boolean)openOrders.isEmpty());
        Assert.assertTrue((boolean)openOrders.isEmpty());
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.Filled);
        Assert.assertFalse((boolean)report1.getOrderStatus().isCancellable());
        manager.add((ReportBase)report1);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !orderIds.isEmpty();
            }
        });
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.PartiallyFilled);
        Assert.assertTrue((boolean)report2.getOrderStatus().isCancellable());
        manager.add((ReportBase)report2);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !openOrders.isEmpty();
            }
        });
        Assert.assertEquals((long)1L, (long)openOrders.size());
        Assert.assertEquals((Object)report2, openOrders.get(report2.getOrderID()));
        new ExpectedFailure<UnsupportedOperationException>(){

            protected void run() throws Exception {
                openOrders.clear();
            }
        };
        new ExpectedFailure<UnsupportedOperationException>(){

            protected void run() throws Exception {
                openOrders.put(new OrderID("orderID"), OrderHistoryManagerTest.generateExecutionReport((String)"orderID", null, (OrderStatus)OrderStatus.PartiallyFilled));
            }
        };
        new ExpectedFailure<UnsupportedOperationException>(){

            protected void run() throws Exception {
                openOrders.keySet().iterator().remove();
            }
        };
    }

    @Test
    public void testOpenOrdersPopulatedFromSnapshot() throws Exception {
        LiveOrderHistoryManager manager = new LiveOrderHistoryManager(null);
        Set<ReportBase> historicalReports = client.getReports();
        Assert.assertTrue((boolean)historicalReports.isEmpty());
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.New);
        Thread.sleep(250L);
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.Canceled);
        Thread.sleep(250L);
        ExecutionReport report3 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.Replaced);
        Thread.sleep(250L);
        ExecutionReport report4 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.Filled);
        historicalReports.add((ReportBase)report1);
        historicalReports.add((ReportBase)report2);
        historicalReports.add((ReportBase)report3);
        historicalReports.add((ReportBase)report4);
        manager.start();
        Map openOrders = manager.getOpenOrders();
        Assert.assertEquals((long)2L, (long)openOrders.size());
        Assert.assertEquals((long)4L, (long)manager.getOrderIds().size());
        Assert.assertEquals((Object)report1, openOrders.get(report1.getOrderID()));
        Assert.assertEquals((Object)report3, openOrders.get(report3.getOrderID()));
    }

    @Test
    public void testOpenOrderCloses() throws Exception {
        LiveOrderHistoryManager manager = new LiveOrderHistoryManager(null);
        manager.start();
        final Map openOrders = manager.getOpenOrders();
        Assert.assertTrue((boolean)openOrders.isEmpty());
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.New);
        manager.add((ReportBase)report1);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !openOrders.isEmpty();
            }
        });
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)report1.getOrderID().getValue(), null, (OrderStatus)OrderStatus.Filled);
        manager.add((ReportBase)report2);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return openOrders.isEmpty();
            }
        });
    }

    @Test
    public void testOrderLifecycle() throws Exception {
        LiveOrderHistoryManager manager = new LiveOrderHistoryManager(null);
        manager.start();
        final Map openOrders = manager.getOpenOrders();
        Assert.assertTrue((boolean)openOrders.isEmpty());
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.New);
        manager.add((ReportBase)report1);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !openOrders.isEmpty();
            }
        });
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)report1.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PendingReplace);
        manager.add((ReportBase)report2);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>((ReportBase)report1){
            final /* synthetic */ ReportBase val$report1;
            {
                this.val$report1 = reportBase;
            }

            @Override
            public Boolean call() throws Exception {
                ReportBase report = (ReportBase)openOrders.get(this.val$report1.getOrderID());
                if (report == null) {
                    return false;
                }
                return report.getOrderStatus().equals((Object)OrderStatus.PendingReplace);
            }
        });
        Assert.assertEquals((long)1L, (long)openOrders.size());
        Assert.assertEquals((Object)report2, openOrders.get(report1.getOrderID()));
        ExecutionReport report3 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), (String)report1.getOrderID().getValue(), (OrderStatus)OrderStatus.Replaced);
        manager.add((ReportBase)report3);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>((ReportBase)report3){
            final /* synthetic */ ReportBase val$report3;
            {
                this.val$report3 = reportBase;
            }

            @Override
            public Boolean call() throws Exception {
                ReportBase report = (ReportBase)openOrders.get(this.val$report3.getOrderID());
                if (report == null) {
                    return false;
                }
                return report.getOrderStatus().equals((Object)OrderStatus.Replaced) && openOrders.size() == 1;
            }
        });
        Assert.assertEquals((long)1L, (long)openOrders.size());
        Assert.assertEquals((Object)report3, openOrders.get(report3.getOrderID()));
        ExecutionReport report4 = OrderHistoryManagerTest.generateExecutionReport((String)report3.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled);
        manager.add((ReportBase)report4);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>((ReportBase)report4){
            final /* synthetic */ ReportBase val$report4;
            {
                this.val$report4 = reportBase;
            }

            @Override
            public Boolean call() throws Exception {
                ReportBase report = (ReportBase)openOrders.get(this.val$report4.getOrderID());
                if (report == null) {
                    return false;
                }
                return report.getOrderStatus().equals((Object)OrderStatus.PartiallyFilled);
            }
        });
        Assert.assertEquals((long)1L, (long)openOrders.size());
        Assert.assertEquals((Object)report4, openOrders.get(report4.getOrderID()));
        ExecutionReport report5 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), (String)report4.getOrderID().getValue(), (OrderStatus)OrderStatus.PendingReplace);
        manager.add((ReportBase)report5);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>((ReportBase)report5){
            final /* synthetic */ ReportBase val$report5;
            {
                this.val$report5 = reportBase;
            }

            @Override
            public Boolean call() throws Exception {
                ReportBase report = (ReportBase)openOrders.get(this.val$report5.getOrderID());
                if (report == null) {
                    return false;
                }
                return report.getOrderStatus().equals((Object)OrderStatus.PendingReplace) && openOrders.size() == 1;
            }
        });
        Assert.assertEquals((long)1L, (long)openOrders.size());
        Assert.assertEquals((Object)report5, openOrders.get(report5.getOrderID()));
        ExecutionReport report6 = OrderHistoryManagerTest.generateExecutionReport((String)report5.getOrderID().getValue(), (String)report4.getOrderID().getValue(), (OrderStatus)OrderStatus.Replaced);
        manager.add((ReportBase)report6);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>((ReportBase)report6){
            final /* synthetic */ ReportBase val$report6;
            {
                this.val$report6 = reportBase;
            }

            @Override
            public Boolean call() throws Exception {
                ReportBase report = (ReportBase)openOrders.get(this.val$report6.getOrderID());
                if (report == null) {
                    return false;
                }
                return report.getOrderStatus().equals((Object)OrderStatus.Replaced) && openOrders.size() == 1;
            }
        });
        Assert.assertEquals((long)1L, (long)openOrders.size());
        Assert.assertEquals((Object)report6, openOrders.get(report6.getOrderID()));
        ExecutionReport report7 = OrderHistoryManagerTest.generateExecutionReport((String)report6.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PendingCancel);
        manager.add((ReportBase)report7);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>((ReportBase)report7){
            final /* synthetic */ ReportBase val$report7;
            {
                this.val$report7 = reportBase;
            }

            @Override
            public Boolean call() throws Exception {
                ReportBase report = (ReportBase)openOrders.get(this.val$report7.getOrderID());
                if (report == null) {
                    return false;
                }
                return report.getOrderStatus().equals((Object)OrderStatus.PendingCancel);
            }
        });
        Assert.assertEquals((long)1L, (long)openOrders.size());
        Assert.assertEquals((Object)report7, openOrders.get(report7.getOrderID()));
        OrderCancelReject report8 = OrderHistoryManagerTest.generateOrderCancelReject((String)("order-" + counter.incrementAndGet()), (String)report7.getOrderID().getValue());
        manager.add((ReportBase)report8);
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return openOrders.isEmpty();
            }
        });
    }

    @Test
    public void testOpenOrders() throws Exception {
        Set<ReportBase> historicalReports = client.getReports();
        List<ReportBaseImpl> setupOpenOrders = client.getOpenOrders();
        Assert.assertTrue((boolean)historicalReports.isEmpty());
        Assert.assertTrue((boolean)setupOpenOrders.isEmpty());
        ReportBaseImpl report1 = (ReportBaseImpl)OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.New);
        Thread.sleep(250L);
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.Filled);
        Thread.sleep(250L);
        ExecutionReport report3 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.Canceled);
        Thread.sleep(250L);
        ReportBaseImpl report4 = (ReportBaseImpl)OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.PartiallyFilled);
        Assert.assertTrue((boolean)report1.getOrderStatus().isCancellable());
        Assert.assertFalse((boolean)report2.getOrderStatus().isCancellable());
        Assert.assertFalse((boolean)report3.getOrderStatus().isCancellable());
        Assert.assertTrue((boolean)report4.getOrderStatus().isCancellable());
        setupOpenOrders.add(report1);
        setupOpenOrders.add(report4);
        historicalReports.add((ReportBase)report2);
        historicalReports.add((ReportBase)report3);
        historicalReports.add((ReportBase)report4);
        LiveOrderHistoryManager manager = new LiveOrderHistoryManager(new Date(report3.getSendingTime().getTime() - 1L));
        manager.start();
        Map openOrders = manager.getOpenOrders();
        Assert.assertEquals((long)2L, (long)openOrders.size());
        Assert.assertEquals((long)3L, (long)manager.getOrderIds().size());
        Assert.assertEquals((Object)report1, openOrders.get(report1.getOrderID()));
        Assert.assertEquals((Object)report4, openOrders.get(report4.getOrderID()));
    }

    @Test
    public void clientExceptionTest() throws Exception {
        ConnectionException exception = new ConnectionException((I18NBoundMessage)Messages.DONT_ADD_REPORTS);
        client.setGetReportsSinceException(exception);
        final LiveOrderHistoryManager manager = new LiveOrderHistoryManager(null);
        new ExpectedFailure<RuntimeException>(ConnectionException.class.getCanonicalName() + ": " + Messages.DONT_ADD_REPORTS.getText()){

            protected void run() throws Exception {
                manager.start();
            }
        };
    }

    @Test
    public void startAndStopTest() throws Exception {
        LiveOrderHistoryManager manager = new LiveOrderHistoryManager(null);
        Assert.assertFalse((boolean)manager.isRunning());
        Assert.assertNotNull((Object)manager.toString());
        manager.stop();
        Assert.assertFalse((boolean)manager.isRunning());
        Assert.assertNotNull((Object)manager.toString());
        manager.start();
        Assert.assertTrue((boolean)manager.isRunning());
        Assert.assertNotNull((Object)manager.toString());
        manager.start();
        Assert.assertTrue((boolean)manager.isRunning());
        Assert.assertNotNull((Object)manager.toString());
    }

    static {
        counter = new AtomicInteger(0);
    }
}

