/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.io.Serializable;
import org.marketcetera.client.Messages;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.instruments.InstrumentValidationHandler;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: Validations.java 16154 2012-07-14 16:34:05Z colin $")
public final class Validations {
    public static void validate(OrderSingle inOrderSingle) throws OrderValidationException {
        if (inOrderSingle == null) {
            throw new OrderValidationException((I18NBoundMessage)Messages.NO_ORDER_SUPPLIED);
        }
        Validations.validate(inOrderSingle.getOrderID() == null, Messages.VALIDATION_ORDERID);
        Validations.validate(inOrderSingle.getOrderType() == null, Messages.VALIDATION_ORDER_TYPE);
        Validations.validate(inOrderSingle.getQuantity() == null, Messages.VALIDATION_ORDER_QUANTITY);
        Validations.validate(inOrderSingle.getSide() == null, Messages.VALIDATION_ORDER_SIDE);
        Validations.validateInstrument(inOrderSingle.getInstrument());
    }

    public static void validate(FIXOrder inFIXOrder) throws OrderValidationException {
        if (inFIXOrder == null) {
            throw new OrderValidationException((I18NBoundMessage)Messages.NO_ORDER_SUPPLIED);
        }
    }

    public static void validate(OrderReplace inOrderReplace) throws OrderValidationException {
        if (inOrderReplace == null) {
            throw new OrderValidationException((I18NBoundMessage)Messages.NO_ORDER_SUPPLIED);
        }
        Validations.validate(inOrderReplace.getOrderID() == null, Messages.VALIDATION_ORDERID);
        Validations.validate(inOrderReplace.getOriginalOrderID() == null, Messages.VALIDATION_ORIG_ORDERID);
        Validations.validate(inOrderReplace.getOrderType() == null, Messages.VALIDATION_ORDER_TYPE);
        Validations.validate(inOrderReplace.getQuantity() == null, Messages.VALIDATION_ORDER_QUANTITY);
        Validations.validate(inOrderReplace.getSide() == null, Messages.VALIDATION_ORDER_SIDE);
        Validations.validateInstrument(inOrderReplace.getInstrument());
    }

    public static void validate(OrderCancel inOrderCancel) throws OrderValidationException {
        if (inOrderCancel == null) {
            throw new OrderValidationException((I18NBoundMessage)Messages.NO_ORDER_SUPPLIED);
        }
        Validations.validate(inOrderCancel.getOrderID() == null, Messages.VALIDATION_ORDERID);
        Validations.validate(inOrderCancel.getOriginalOrderID() == null, Messages.VALIDATION_ORIG_ORDERID);
        Validations.validate(inOrderCancel.getQuantity() == null, Messages.VALIDATION_ORDER_QUANTITY);
        Validations.validate(inOrderCancel.getSide() == null, Messages.VALIDATION_ORDER_SIDE);
        Validations.validateInstrument(inOrderCancel.getInstrument());
    }

    public static void validate(OrderSingleSuggestion inSuggestion) throws OrderValidationException {
        if (inSuggestion == null) {
            throw new OrderValidationException((I18NBoundMessage)Messages.NO_SUGGEST_SUPPLIED);
        }
        Validations.validate(inSuggestion.getIdentifier() == null, Messages.VALIDATION_SUGGEST_IDENTIFIER);
        Validations.validate(inSuggestion.getScore() == null, Messages.VALIDATION_SUGGEST_SCORE);
        Validations.validate(inSuggestion.getOrder() == null, Messages.VALIDATION_SUGGEST_ORDER);
    }

    public static void validateInstrument(Instrument inInstrument) throws OrderValidationException {
        Validations.validate(inInstrument == null, Messages.VALIDATION_ORDER_INSTRUMENT);
        try {
            ((InstrumentValidationHandler)InstrumentValidationHandler.SELECTOR.forInstrument(inInstrument)).validate(inInstrument);
        }
        catch (IllegalArgumentException e) {
            throw new OrderValidationException(e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.VALIDATION_UNKNOWN_INSTRUMENT, (Serializable)inInstrument));
        }
    }

    private static void validate(boolean inValidationFailed, I18NMessage0P inMessage) throws OrderValidationException {
        if (inValidationFailed) {
            throw new OrderValidationException((I18NBoundMessage)inMessage);
        }
    }

    private Validations() {
    }
}

