/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.rpc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.googlecode.protobuf.pro.duplex.PeerInfo;
import com.googlecode.protobuf.pro.duplex.RpcClientChannel;
import com.googlecode.protobuf.pro.duplex.client.DuplexTcpClientPipelineFactory;
import com.googlecode.protobuf.pro.duplex.execute.RpcServerCallExecutor;
import com.googlecode.protobuf.pro.duplex.execute.ThreadPoolCallExecutor;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.Validate;
import org.marketcetera.client.ClientImpl;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ClientVersion;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.rpc.RpcClient;
import org.marketcetera.client.rpc.RpcClientParameters;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.Util;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.core.position.PositionKeyFactory;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReportImpl;
import org.marketcetera.trade.FIXMessageWrapper;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Hierarchy;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.NodeId;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: RpcClientImpl.java 16952 2014-10-10 22:43:57Z colin $")
@ThreadSafe
public class RpcClientImpl
extends ClientImpl {
    private RpcController controller;
    private SessionId sessionId;
    private RpcClient.RpcClientService.BlockingInterface clientService;
    private RpcServerCallExecutor executor;
    private RpcClientChannel channel;
    private final Object contextLock = new Object();
    @GuardedBy(value="contextLock")
    private JAXBContext context;
    @GuardedBy(value="contextLock")
    private Marshaller marshaller;
    @GuardedBy(value="contextLock")
    private Unmarshaller unmarshaller;

    public RpcClientImpl(ClientParameters inParameters) throws ConnectionException {
        super(inParameters);
    }

    @Override
    public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(Date inDate) throws ConnectionException {
        return this.getAllInstrumentPositionsAsOf(inDate, RpcClient.InstrumentType.EQUITY);
    }

    @Override
    public BigDecimal getEquityPositionAsOf(Date inDate, Equity inEquity) throws ConnectionException {
        return this.getInstrumentPositionAsOf(inDate, inEquity);
    }

    @Override
    public BigDecimal getCurrencyPositionAsOf(Date inDate, Currency inCurrency) throws ConnectionException {
        return this.getInstrumentPositionAsOf(inDate, inCurrency);
    }

    @Override
    public Map<PositionKey<Currency>, BigDecimal> getAllCurrencyPositionsAsOf(Date inDate) throws ConnectionException {
        return this.getAllInstrumentPositionsAsOf(inDate, RpcClient.InstrumentType.CURRENCY);
    }

    @Override
    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date inDate) throws ConnectionException {
        return this.getAllInstrumentPositionsAsOf(inDate, RpcClient.InstrumentType.FUTURE);
    }

    @Override
    public BigDecimal getFuturePositionAsOf(Date inDate, Future inFuture) throws ConnectionException {
        return this.getInstrumentPositionAsOf(inDate, inFuture);
    }

    @Override
    public BigDecimal getOptionPositionAsOf(Date inDate, Option inOption) throws ConnectionException {
        return this.getInstrumentPositionAsOf(inDate, inOption);
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date inDate) throws ConnectionException {
        return this.getAllInstrumentPositionsAsOf(inDate, RpcClient.InstrumentType.OPTION);
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date inDate, String ... inSymbols) throws ConnectionException {
        return this.getAllInstrumentPositionsAsOf(inDate, inSymbols);
    }

    @Override
    public String getUnderlying(String inOptionRoot) throws ConnectionException {
        RpcClient.UnderlyingRequest request = RpcClient.UnderlyingRequest.newBuilder().setSessionId(this.sessionId.getValue()).setSymbol(inOptionRoot).build();
        try {
            RpcClient.UnderlyingResponse response = this.clientService.getUnderlying(this.controller, request);
            return response.hasSymbol() ? response.getSymbol() : null;
        }
        catch (ServiceException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public Collection<String> getOptionRoots(String inUnderlying) throws ConnectionException {
        RpcClient.OptionRootsRequest request = RpcClient.OptionRootsRequest.newBuilder().setSessionId(this.sessionId.getValue()).setSymbol(inUnderlying).build();
        try {
            RpcClient.OptionRootsResponse response = this.clientService.getOptionRoots(this.controller, request);
            return response.getSymbolList();
        }
        catch (ServiceException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instrument resolveSymbol(String inSymbol) throws ConnectionException {
        try {
            SLF4JLoggerProxy.debug((Object)this, (String)"Resolving {}", (Object[])new Object[]{inSymbol});
            RpcClient.ResolveSymbolResponse response = this.clientService.resolveSymbol(this.controller, RpcClient.ResolveSymbolRequest.newBuilder().setSessionId(this.sessionId.getValue()).setSymbol(inSymbol).build());
            Instrument instrument = null;
            if (response.hasInstrument()) {
                Object object = this.contextLock;
                synchronized (object) {
                    Unmarshaller unmarshaller = this.getUnmarshaller();
                    instrument = (Instrument)unmarshaller.unmarshal((Reader)new StringReader(response.getInstrument().getPayload()));
                }
                SLF4JLoggerProxy.debug((Object)this, (String)"Resolved {} to {}", (Object[])new Object[]{inSymbol, instrument});
            }
            return instrument;
        }
        catch (ServiceException | JAXBException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public OrderID findRootOrderIdFor(OrderID inOrderID) {
        RpcClient.RootOrderIdRequest request = RpcClient.RootOrderIdRequest.newBuilder().setSessionId(this.sessionId.getValue()).setOrderId(inOrderID.getValue()).build();
        try {
            return new OrderID(this.clientService.getRootOrderIdFor(this.controller, request).getOrderId());
        }
        catch (ServiceException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReport(FIXMessageWrapper inReport, BrokerID inBrokerID, Hierarchy inHierarchy) throws ConnectionException {
        StringWriter output = new StringWriter();
        try {
            Object object = this.contextLock;
            synchronized (object) {
                Marshaller marshaller = this.getMarshaller();
                marshaller.marshal((Object)inReport, (Writer)output);
            }
            RpcClient.AddReportRequest request = RpcClient.AddReportRequest.newBuilder().setSessionId(this.sessionId.getValue()).setBrokerId(inBrokerID.getValue()).setMessage(output.toString()).setHierarchy(RpcClient.Hierarchy.valueOf(inHierarchy.name())).build();
            SLF4JLoggerProxy.debug((Object)this, (String)"AddReport request: {}", (Object[])new Object[]{request});
            RpcClient.AddReportResponse response = this.clientService.addReport(this.controller, request);
            SLF4JLoggerProxy.debug((Object)this, (String)"AddReport response: {}", (Object[])new Object[]{response});
            if (!response.getStatus()) {
                throw new RuntimeException(response.getMessage());
            }
        }
        catch (ServiceException | JAXBException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteReport(ExecutionReportImpl inReport) throws ConnectionException {
        StringWriter output = new StringWriter();
        try {
            Object object = this.contextLock;
            synchronized (object) {
                Marshaller marshaller = this.getMarshaller();
                marshaller.marshal((Object)inReport, (Writer)output);
            }
            RpcClient.DeleteReportRequest request = RpcClient.DeleteReportRequest.newBuilder().setSessionId(this.sessionId.getValue()).setMessage(output.toString()).build();
            SLF4JLoggerProxy.debug((Object)this, (String)"DeleteReport request: {}", (Object[])new Object[]{request});
            RpcClient.DeleteReportResponse response = this.clientService.deleteReport(this.controller, request);
            SLF4JLoggerProxy.debug((Object)this, (String)"DeleteReport response: {}", (Object[])new Object[]{response});
        }
        catch (ServiceException | JAXBException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public Properties getUserData() throws ConnectionException {
        RpcClient.GetUserDataRequest request = RpcClient.GetUserDataRequest.newBuilder().setSessionId(this.sessionId.getValue()).build();
        try {
            RpcClient.GetUserDataResponse response = this.clientService.getUserData(this.controller, request);
            Properties userData = response.hasUserData() ? Util.propertiesFromString((String)response.getUserData()) : new Properties();
            return userData;
        }
        catch (ServiceException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public void setUserData(Properties inProperties) throws ConnectionException {
        RpcClient.SetUserDataRequest.Builder requestBuilder = RpcClient.SetUserDataRequest.newBuilder().setSessionId(this.sessionId.getValue());
        if (inProperties != null) {
            requestBuilder.setUserData(Util.propertiesToString((Properties)inProperties));
        }
        try {
            this.clientService.setUserData(this.controller, requestBuilder.build());
        }
        catch (ServiceException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public UserInfo getUserInfo(UserID inId, boolean inUseCache) throws ConnectionException {
        RpcClient.UserInfoRequest request = RpcClient.UserInfoRequest.newBuilder().setSessionId(this.sessionId.getValue()).setId(inId.getValue()).build();
        try {
            RpcClient.UserInfoResponse response = this.clientService.getUserInfo(this.controller, request);
            String userData = response.getUserInfo().getUserdata();
            Properties props = new Properties();
            if (userData != null) {
                props = Util.propertiesFromString((String)userData);
            }
            UserInfo userInfo = new UserInfo(response.getUserInfo().getName(), new UserID(response.getUserInfo().getId()), response.getUserInfo().getActive(), response.getUserInfo().getSuperuser(), props);
            return userInfo;
        }
        catch (ServiceException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportBase[] getReportsSince(Date inDate) throws ConnectionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Requesting reports since {}", (Object[])new Object[]{inDate});
        RpcClient.ReportsSinceRequest request = RpcClient.ReportsSinceRequest.newBuilder().setSessionId(this.sessionId.getValue()).setOrigin(inDate.getTime()).build();
        try {
            RpcClient.ReportsSinceResponse response = this.clientService.getReportsSince(this.controller, request);
            ArrayList reports = Lists.newArrayList();
            for (String report : response.getReports().getReportsList()) {
                Object object = this.contextLock;
                synchronized (object) {
                    reports.add((ReportBase)this.getUnmarshaller().unmarshal((Reader)new StringReader(report)));
                }
            }
            SLF4JLoggerProxy.debug((Object)this, (String)"Retrieved reports: {}", (Object[])new Object[]{reports});
            return reports.toArray(new ReportBase[reports.size()]);
        }
        catch (ServiceException | JAXBException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReportBaseImpl> getOpenOrders() throws ConnectionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Requesting open orders");
        RpcClient.OpenOrdersRequest request = RpcClient.OpenOrdersRequest.newBuilder().setSessionId(this.sessionId.getValue()).build();
        try {
            RpcClient.OpenOrdersResponse response = this.clientService.getOpenOrders(this.controller, request);
            ArrayList reports = Lists.newArrayList();
            for (String report : response.getReports().getReportsList()) {
                Object object = this.contextLock;
                synchronized (object) {
                    reports.add((ReportBaseImpl)this.getUnmarshaller().unmarshal((Reader)new StringReader(report)));
                }
            }
            SLF4JLoggerProxy.debug((Object)this, (String)"Retrieved open orders: {}", (Object[])new Object[]{reports});
            return reports;
        }
        catch (ServiceException | JAXBException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public BrokersStatus getBrokersStatus() throws ConnectionException {
        RpcClient.BrokersStatusRequest brokersStatusRequest = RpcClient.BrokersStatusRequest.newBuilder().setSessionId(this.sessionId.getValue()).build();
        try {
            RpcClient.BrokersStatusResponse brokersStatusResponse = this.clientService.getBrokersStatus(this.controller, brokersStatusRequest);
            RpcClient.BrokersStatus rpcBrokersStatus = brokersStatusResponse.getBrokersStatus();
            ArrayList brokers = Lists.newArrayList();
            for (RpcClient.BrokerStatus rpcBrokerStatus : rpcBrokersStatus.getBrokersList()) {
                HashMap<String, String> settings = new HashMap<String, String>();
                for (RpcClient.SessionSetting settingEntry : rpcBrokerStatus.getSettingsList()) {
                    settings.put(settingEntry.getKey(), settingEntry.getValue());
                }
                BrokerStatus brokerStatus = new BrokerStatus(rpcBrokerStatus.getName(), new BrokerID(rpcBrokerStatus.getBrokerId()), rpcBrokerStatus.getLoggedOn(), settings);
                brokers.add(brokerStatus);
            }
            BrokersStatus brokersStatus = new BrokersStatus(brokers);
            return brokersStatus;
        }
        catch (ServiceException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    @Override
    public synchronized void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopRpcServices();
    }

    @Override
    protected String getNextServerID() throws RemoteException {
        RpcClient.NextOrderIdRequest nextOrderIdRequest = RpcClient.NextOrderIdRequest.newBuilder().setSessionId(this.sessionId.getValue()).build();
        try {
            RpcClient.NextOrderIdResponse nextOrderIdResponse = this.clientService.getNextOrderID(this.controller, nextOrderIdRequest);
            return nextOrderIdResponse.getOrderId();
        }
        catch (ServiceException e) {
            throw new RemoteException((Throwable)e);
        }
    }

    @Override
    protected void heartbeat() throws RemoteException {
        RpcClient.HeartbeatRequest request = RpcClient.HeartbeatRequest.newBuilder().setId(System.nanoTime()).build();
        try {
            this.clientService.heartbeat(this.controller, request);
            return;
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    @Override
    protected SessionId getSessionId() {
        return this.sessionId;
    }

    @Override
    protected void connectWebServices() throws I18NException, RemoteException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Connecting to RPC server at {}:{}", (Object[])new Object[]{this.mParameters.getHostname(), this.mParameters.getPort()});
        PeerInfo server = new PeerInfo(this.mParameters.getHostname(), this.mParameters.getPort());
        DuplexTcpClientPipelineFactory clientFactory = new DuplexTcpClientPipelineFactory();
        this.executor = new ThreadPoolCallExecutor(1, 10);
        clientFactory.setRpcServerCallExecutor(this.executor);
        clientFactory.setConnectResponseTimeoutMillis(10000L);
        clientFactory.setCompression(true);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup());
        bootstrap.handler((ChannelHandler)clientFactory);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        bootstrap.option(ChannelOption.SO_SNDBUF, (Object)0x100000);
        bootstrap.option(ChannelOption.SO_RCVBUF, (Object)0x100000);
        try {
            this.channel = clientFactory.peerWith(server, bootstrap);
            this.clientService = RpcClient.RpcClientService.newBlockingStub((BlockingRpcChannel)this.channel);
            this.controller = this.channel.newRpcController();
            Locale currentLocale = Locale.getDefault();
            RpcClient.LoginRequest loginRequest = RpcClient.LoginRequest.newBuilder().setAppId(ClientVersion.APP_ID.getValue()).setVersionId(ClientVersion.APP_ID_VERSION.getVersionInfo()).setClientId(NodeId.generate().getValue()).setLocale(RpcClient.Locale.newBuilder().setCountry(currentLocale.getCountry() == null ? "" : currentLocale.getCountry()).setLanguage(currentLocale.getLanguage() == null ? "" : currentLocale.getLanguage()).setVariant(currentLocale.getVariant() == null ? "" : currentLocale.getVariant()).build()).setUsername(this.mParameters.getUsername()).setPassword(new String(this.mParameters.getPassword())).build();
            RpcClient.LoginResponse loginResponse = this.clientService.login(this.controller, loginRequest);
            this.sessionId = new SessionId(loginResponse.getSessionId());
        }
        catch (ServiceException | IOException e) {
            throw new RemoteException(e);
        }
    }

    @Override
    protected void reconnectWebServices() throws RemoteException {
        try {
            this.stopRpcServices();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connectWebServices();
    }

    @Override
    protected void closeWebServices() throws RemoteException {
        this.stopRpcServices();
    }

    @Override
    protected void connectJms() throws JAXBException {
        if (this.useJms()) {
            super.connectJms();
        }
    }

    @Override
    protected void startJms() throws JAXBException {
        if (this.useJms()) {
            super.startJms();
        }
    }

    private boolean useJms() {
        if (this.mParameters instanceof RpcClientParameters) {
            RpcClientParameters rpcParms = (RpcClientParameters)this.mParameters;
            return rpcParms.getUseJms();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRpcServices() {
        try {
            try {
                this.clientService.logout(this.controller, RpcClient.LogoutRequest.newBuilder().setSessionId(this.sessionId.getValue()).build());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (this.executor != null) {
                try {
                    this.executor.shutdownNow();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.executor = null;
            this.controller = null;
            this.clientService = null;
            this.channel = null;
            this.sessionId = null;
        }
    }

    private <InstrumentClazz extends Instrument> BigDecimal getInstrumentPositionAsOf(Date inDate, InstrumentClazz inInstrument) {
        Map<PositionKey<InstrumentClazz>, BigDecimal> positionMap = this.getInstrumentPositionsAsOf(inDate, null, inInstrument, new String[0]);
        if (positionMap == null || positionMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Validate.isTrue((positionMap.size() == 1 ? 1 : 0) != 0);
        return positionMap.values().iterator().next();
    }

    private <InstrumentClazz extends Instrument> Map<PositionKey<InstrumentClazz>, BigDecimal> getAllInstrumentPositionsAsOf(Date inDate, RpcClient.InstrumentType inInstrumentType) {
        return this.getInstrumentPositionsAsOf(inDate, inInstrumentType, null, new String[0]);
    }

    private <InstrumentClazz extends Instrument> Map<PositionKey<InstrumentClazz>, BigDecimal> getAllInstrumentPositionsAsOf(Date inDate, String ... inOptionRoots) {
        return this.getInstrumentPositionsAsOf(inDate, null, null, inOptionRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private <InstrumentClazz extends Instrument> Map<PositionKey<InstrumentClazz>, BigDecimal> getInstrumentPositionsAsOf(Date inDate, RpcClient.InstrumentType inInstrumentType, Instrument inInstrument, String ... inOptionRoots) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Getting instrument position as of {} for {}/{}/{}", (Object[])new Object[]{inDate, inInstrumentType, inInstrument, inOptionRoots == null ? "" : Arrays.toString(inOptionRoots)});
        try {
            RpcClient.PositionRequest request;
            if (inInstrument == null) {
                if (inInstrumentType == null) {
                    RpcClient.PositionRequest.Builder requestBuilder = RpcClient.PositionRequest.newBuilder().setSessionId(this.sessionId.getValue()).setOrigin(inDate.getTime());
                    for (String optionRoot : inOptionRoots) {
                        requestBuilder.addRoot(optionRoot);
                    }
                    request = requestBuilder.build();
                } else {
                    request = RpcClient.PositionRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstrumentType(inInstrumentType).setOrigin(inDate.getTime()).build();
                }
            } else {
                StringWriter output = new StringWriter();
                try {
                    String[] arr$ = this.contextLock;
                    // MONITORENTER : this.contextLock
                    this.getMarshaller().marshal((Object)inInstrument, (Writer)output);
                    // MONITOREXIT : arr$
                }
                catch (JAXBException e) {
                    throw new ServiceException((Throwable)e);
                }
                request = RpcClient.PositionRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstrument(RpcClient.Instrument.newBuilder().setPayload(output.toString())).setOrigin(inDate.getTime()).build();
            }
            RpcClient.PositionResponse response = this.clientService.getPositions(this.controller, request);
            HashMap positions = Maps.newHashMap();
            Validate.isTrue((response.getKeysCount() == response.getValuesCount() ? 1 : 0) != 0);
            int index = 0;
            while (true) {
                if (index >= response.getKeysCount()) {
                    SLF4JLoggerProxy.debug((Object)this, (String)"Returning positions: {}", (Object[])new Object[]{positions});
                    return positions;
                }
                RpcClient.PositionKey rpcKey = response.getKeys(index);
                RpcClient.Instrument rpcInstrument = rpcKey.getInstrument();
                String rpcAccount = rpcKey.getAccount();
                String rpcTraderId = rpcKey.getTraderId();
                Object object = this.contextLock;
                // MONITORENTER : object
                Instrument instrument = (Instrument)this.getUnmarshaller().unmarshal((Reader)new StringReader(rpcInstrument.getPayload()));
                // MONITOREXIT : object
                PositionKey positionKey = null;
                if (instrument instanceof Equity) {
                    positionKey = PositionKeyFactory.createEquityKey((String)instrument.getSymbol(), (String)rpcAccount, (String)rpcTraderId);
                } else if (instrument instanceof Option) {
                    Option option = (Option)instrument;
                    positionKey = PositionKeyFactory.createOptionKey((String)option.getSymbol(), (String)option.getExpiry(), (BigDecimal)option.getStrikePrice(), (OptionType)option.getType(), (String)rpcAccount, (String)rpcTraderId);
                } else if (instrument instanceof Future) {
                    Future future = (Future)instrument;
                    positionKey = PositionKeyFactory.createFutureKey((String)future.getSymbol(), (String)future.getExpiryAsString(), (String)rpcAccount, (String)rpcTraderId);
                } else {
                    if (!(instrument instanceof Currency)) throw new UnsupportedOperationException();
                    Currency currency = (Currency)instrument;
                    positionKey = PositionKeyFactory.createCurrencyKey((String)currency.getSymbol(), (String)rpcAccount, (String)rpcTraderId);
                }
                positions.put(positionKey, new BigDecimal(response.getValues(index)));
                ++index;
            }
        }
        catch (ServiceException | JAXBException e) {
            throw new ConnectionException(e, (I18NBoundMessage)Messages.ERROR_REMOTE_EXECUTION);
        }
    }

    private Class<?>[] getContextClasses() {
        RpcClientParameters params;
        if (this.mParameters instanceof RpcClientParameters && (params = (RpcClientParameters)this.mParameters).getContextClassProvider() != null) {
            return params.getContextClassProvider().getContextClasses();
        }
        return new Class[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Marshaller getMarshaller() throws JAXBException {
        Object object = this.contextLock;
        synchronized (object) {
            if (this.context == null) {
                this.initContext();
            }
            return this.marshaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unmarshaller getUnmarshaller() throws JAXBException {
        Object object = this.contextLock;
        synchronized (object) {
            if (this.context == null) {
                this.initContext();
            }
            return this.unmarshaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initContext() throws JAXBException {
        Object object = this.contextLock;
        synchronized (object) {
            this.context = JAXBContext.newInstance((Class[])this.getContextClasses());
            this.marshaller = this.context.createMarshaller();
            this.unmarshaller = this.context.createUnmarshaller();
        }
    }
}

