package org.marketcetera.client.brokers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.marketcetera.util.misc.ClassVersion;

/* $License$ */

/**
 * The collective web service representation of the status of all
 * brokers.
 *
 * @author tlerios@marketcetera.com
 * @since 1.0.0
 * @version $Id: BrokersStatus.java 17411 2017-04-28 14:50:38Z colin $
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@ClassVersion("$Id: BrokersStatus.java 17411 2017-04-28 14:50:38Z colin $")
public class BrokersStatus
        implements Serializable, Iterable<BrokerStatus>
{
    /**
     * Creates a new collective status representation, given the status of the brokers.
     *
     * @param inBrokers a <code>List&lt;BrokerStatus&gt;</code> value
     */
    public BrokersStatus(List<BrokerStatus> inBrokers)
    {
        brokers = inBrokers;
    }
    /**
     * Create a new BrokersStatus instance.
     */
    public BrokersStatus()
    {
        brokers = new ArrayList<BrokerStatus>();
    }
    /**
     * Returns the status of the receiver's brokers.
     * 
     * <p>The returned list is not modifiable.
     *
     * @return a <code>List&lt;BrokerStatus&gt;</code> value
     */
    public List<BrokerStatus> getBrokers()
    {
        return Collections.unmodifiableList(brokers);
    }
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder();
        builder.append("BrokersStatus [mBrokers=").append(brokers).append("]"); //$NON-NLS-1$ //$NON-NLS-2$
        return builder.toString();
    }
    /* (non-Javadoc)
     * @see java.lang.Iterable#iterator()
     */
    @Override
    public Iterator<BrokerStatus> iterator()
    {
        return brokers.iterator();
    }
    /**
     * brokers value
     */
    private final List<BrokerStatus> brokers;
    private static final long serialVersionUID = -5848029285343673726L;
}
