/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.management.JMX;
import javax.management.MBeanInfo;
import org.apache.commons.lang.ObjectUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.marketcetera.client.ClientImpl;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientModuleFactory;
import org.marketcetera.client.ClientModuleFactoryMXBean;
import org.marketcetera.client.ClientModuleMXBean;
import org.marketcetera.client.ClientTest;
import org.marketcetera.client.Messages;
import org.marketcetera.client.MockServer;
import org.marketcetera.client.OrderSenderModuleFactory;
import org.marketcetera.client.jms.DataEnvelope;
import org.marketcetera.module.BlockingSinkDataListener;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataFlowInfo;
import org.marketcetera.module.DataFlowStep;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;
import org.marketcetera.module.SinkModuleFactory;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.SessionId;

@ClassVersion(value="$Id: ClientModuleTestBase.java 17372 2017-04-06 19:41:09Z colin $")
@Ignore
public class ClientModuleTestBase
extends ModuleTestBase {
    protected ModuleManager mManager;
    private static MockServer sServer;
    protected static final String IDPREFIX = "my";

    @Test
    public void info() throws Exception {
        ClientModuleTestBase.assertProviderInfo((ModuleManager)this.mManager, (ModuleURN)ClientModuleFactory.PROVIDER_URN, (String[])new String[0], (Class[])new Class[0], (String)Messages.PROVIDER_DESCRIPTION.getText(), (boolean)false, (boolean)false);
        ClientModuleTestBase.assertModuleInfo((ModuleManager)this.mManager, (ModuleURN)ClientModuleFactory.INSTANCE_URN, (ModuleState)ModuleState.STARTED, null, null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    @Test
    public void jmx() throws Exception {
        ClientModuleTestBase.verifyBeanInfo((MBeanInfo)ClientModuleTestBase.getMBeanServer().getMBeanInfo(ClientModuleFactory.PROVIDER_URN.toObjectName()));
        ClientModuleTestBase.verifyBeanInfo((MBeanInfo)ClientModuleTestBase.getMBeanServer().getMBeanInfo(ClientModuleFactory.INSTANCE_URN.toObjectName()));
        ClientModuleFactoryMXBean factory = JMX.newMXBeanProxy(ClientModuleTestBase.getMBeanServer(), ClientModuleFactory.PROVIDER_URN.toObjectName(), ClientModuleFactoryMXBean.class);
        Assert.assertEquals((Object)this.getExpectedURL(), (Object)factory.getURL());
        Assert.assertEquals((Object)this.getExpectedUsername(), (Object)factory.getUsername());
        ClientModuleMXBean instance = JMX.newMXBeanProxy(ClientModuleTestBase.getMBeanServer(), ClientModuleFactory.INSTANCE_URN.toObjectName(), ClientModuleMXBean.class);
        Date lastTime = ClientManager.getInstance().getLastConnectTime();
        Assert.assertEquals((Object)lastTime, (Object)instance.getLastConnectTime());
        ClientTest.assertCPEquals(ClientManager.getInstance().getParameters(), instance.getParameters());
        Thread.sleep(100L);
        instance.reconnect();
        Assert.assertEquals((Object)ClientManager.getInstance().getLastConnectTime(), (Object)instance.getLastConnectTime());
        Assert.assertTrue((instance.getLastConnectTime().compareTo(lastTime) > 0 ? 1 : 0) != 0);
    }

    protected Object getExpectedUsername() {
        return null;
    }

    protected Object getExpectedURL() {
        return null;
    }

    @Test
    public void invalidRequests() throws Exception {
        new ExpectedFailure<IllegalRequestParameterValue>((I18NBoundMessage)Messages.REQUEST_PARAMETER_SPECIFIED){

            protected void run() throws Exception {
                ClientModuleTestBase.this.mManager.createDataFlow(new DataRequest[]{new DataRequest(ClientModuleFactory.INSTANCE_URN, (Object)"some string value")});
            }
        };
    }

    @Test
    public void dataFlow() throws Exception {
        Order[] orders = new Order[]{ClientTest.createOrderSingle(), ClientTest.createOrderReplace(), Factory.getInstance().createOrderCancel(ClientTest.createExecutionReport()), Factory.getInstance().createOrder(FIXVersion.FIX44.getMessageFactory().newLimitOrder("ord1", '1', new BigDecimal(4.3), (Instrument)new Equity("IBM"), new BigDecimal("93.23"), '2', "acc"), new BrokerID("broke"))};
        ReportBase[] reports = new ReportBase[]{ClientTest.createExecutionReport(), ClientTest.createExecutionReport(), ClientTest.createCancelReject(), ClientTest.createExecutionReport()};
        sServer.getHandler().addToSend(reports[0]);
        sServer.getHandler().addToSend(reports[1]);
        sServer.getHandler().addToSend(reports[2]);
        sServer.getHandler().addToSend(reports[3]);
        BlockingSinkDataListener sink = new BlockingSinkDataListener();
        this.mManager.addSinkListener((SinkDataListener)sink);
        ModuleURN senderURN = this.mManager.createModule(OrderSenderModuleFactory.PROVIDER_URN, new Object[]{"sendOrders", orders});
        Assert.assertEquals((long)0L, (long)sServer.getHandler().numReceived());
        DataFlowID flowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(senderURN, null), new DataRequest(ClientModuleFactory.INSTANCE_URN, null)});
        ClientModuleTestBase.assertFlowInfo((DataFlowInfo)this.mManager.getDataFlowInfo(flowID), (DataFlowID)flowID, (int)3, (boolean)true, (boolean)false, null, null);
        for (ReportBase report : reports) {
            if (report instanceof ExecutionReport) {
                TypesTestBase.assertExecReportEquals((ExecutionReport)((ExecutionReport)report), (ExecutionReport)((ExecutionReport)sink.getNextData()));
                continue;
            }
            if (report instanceof OrderCancelReject) {
                TypesTestBase.assertCancelRejectEquals((OrderCancelReject)((OrderCancelReject)report), (OrderCancelReject)((OrderCancelReject)sink.getNextData()));
                continue;
            }
            Assert.fail((String)"Support for FIXResponse messages is pending");
        }
        Thread.sleep(1000L);
        this.mManager.cancel(flowID);
        Assert.assertTrue((boolean)this.mManager.getDataFlows(true).isEmpty());
        List history = this.mManager.getDataFlowHistory();
        Assert.assertEquals((long)1L, (long)history.size());
        DataFlowInfo info = (DataFlowInfo)history.get(0);
        ClientModuleTestBase.assertFlowInfo((DataFlowInfo)info, (DataFlowID)flowID, (int)3, (boolean)true, (boolean)true, null, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[0], (ModuleURN)senderURN, (boolean)true, (int)4, (int)0, null, (boolean)false, (int)0, (int)0, null, null, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[1], (ModuleURN)ClientModuleFactory.INSTANCE_URN, (boolean)true, (int)4, (int)0, null, (boolean)true, (int)4, (int)0, null, (ModuleURN)ClientModuleFactory.INSTANCE_URN, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[2], (ModuleURN)SinkModuleFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)4, (int)0, null, (ModuleURN)SinkModuleFactory.INSTANCE_URN, null);
        SessionId id = ((ClientImpl)ClientManager.getInstance()).getSessionId();
        Assert.assertEquals((long)4L, (long)sServer.getHandler().numReceived());
        DataEnvelope e = (DataEnvelope)sServer.getHandler().removeReceived();
        Assert.assertEquals((Object)id, (Object)e.getSessionId());
        Order order = e.getOrder();
        assert (order instanceof OrderSingle);
        TypesTestBase.assertOrderSingleEquals((OrderSingle)((OrderSingle)orders[0]), (OrderSingle)((OrderSingle)order));
        e = (DataEnvelope)sServer.getHandler().removeReceived();
        Assert.assertEquals((Object)id, (Object)e.getSessionId());
        order = e.getOrder();
        assert (order instanceof OrderReplace);
        TypesTestBase.assertOrderReplaceEquals((OrderReplace)((OrderReplace)orders[1]), (OrderReplace)((OrderReplace)order));
        e = (DataEnvelope)sServer.getHandler().removeReceived();
        Assert.assertEquals((Object)id, (Object)e.getSessionId());
        order = e.getOrder();
        assert (order instanceof OrderCancel);
        TypesTestBase.assertOrderCancelEquals((OrderCancel)((OrderCancel)orders[2]), (OrderCancel)((OrderCancel)order));
        e = (DataEnvelope)sServer.getHandler().removeReceived();
        Assert.assertEquals((Object)id, (Object)e.getSessionId());
        order = e.getOrder();
        assert (order instanceof FIXOrder);
        TypesTestBase.assertOrderFIXEquals((FIXOrder)((FIXOrder)orders[3]), (FIXOrder)((FIXOrder)order));
        this.mManager.removeSinkListener((SinkDataListener)sink);
        this.mManager.stop(senderURN);
        this.mManager.deleteModule(senderURN);
    }

    @Test
    public void dataFlowUnsupportedTypeError() throws Exception {
        OrderSingleSuggestion errorData = Factory.getInstance().createOrderSingleSuggestion();
        ModuleURN senderURN = this.mManager.createModule(OrderSenderModuleFactory.PROVIDER_URN, new Object[]{"unsupported", new Object[]{errorData, ClientTest.createOrderSingle()}});
        BlockingSinkDataListener sink = new BlockingSinkDataListener();
        this.mManager.addSinkListener((SinkDataListener)sink);
        DataFlowID flowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(senderURN, null), new DataRequest(ClientModuleFactory.INSTANCE_URN, null)});
        ClientModuleTestBase.assertFlowInfo((DataFlowInfo)this.mManager.getDataFlowInfo(flowID), (DataFlowID)flowID, (int)3, (boolean)true, (boolean)false, null, null);
        Object data = sink.getNextData();
        Assert.assertTrue((String)data.getClass().getName(), (boolean)(data instanceof ExecutionReport));
        Thread.sleep(1000L);
        this.mManager.cancel(flowID);
        Assert.assertTrue((boolean)this.mManager.getDataFlows(true).isEmpty());
        List history = this.mManager.getDataFlowHistory();
        Assert.assertEquals((long)1L, (long)history.size());
        DataFlowInfo info = (DataFlowInfo)history.get(0);
        ClientModuleTestBase.assertFlowInfo((DataFlowInfo)info, (DataFlowID)flowID, (int)3, (boolean)true, (boolean)true, null, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[0], (ModuleURN)senderURN, (boolean)true, (int)2, (int)0, null, (boolean)false, (int)0, (int)0, null, null, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[1], (ModuleURN)ClientModuleFactory.INSTANCE_URN, (boolean)true, (int)1, (int)0, null, (boolean)true, (int)2, (int)1, (String)Messages.UNSUPPORTED_DATA_TYPE.getText((Object)flowID, (Object)ObjectUtils.toString((Object)errorData)), (ModuleURN)ClientModuleFactory.INSTANCE_URN, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[2], (ModuleURN)SinkModuleFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)1, (int)0, null, (ModuleURN)SinkModuleFactory.INSTANCE_URN, null);
        this.mManager.removeSinkListener((SinkDataListener)sink);
        this.mManager.stop(senderURN);
        this.mManager.deleteModule(senderURN);
    }

    @Test(timeout=60000L)
    public void dataFlowNotInitializedError() throws Exception {
        OrderSingle order = ClientTest.createOrderSingle();
        ModuleURN senderURN = this.mManager.createModule(OrderSenderModuleFactory.PROVIDER_URN, new Object[]{"clientNotInit", new Object[]{Boolean.FALSE, order}});
        DataFlowID flowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(senderURN, null), new DataRequest(ClientModuleFactory.INSTANCE_URN, null)});
        ClientModuleTestBase.assertFlowInfo((DataFlowInfo)this.mManager.getDataFlowInfo(flowID), (DataFlowID)flowID, (int)3, (boolean)true, (boolean)false, null, null);
        while (!this.mManager.getDataFlows(true).isEmpty()) {
            Thread.sleep(1000L);
        }
        List history = this.mManager.getDataFlowHistory();
        Assert.assertEquals((long)1L, (long)history.size());
        DataFlowInfo info = (DataFlowInfo)history.get(0);
        ClientModuleTestBase.assertFlowInfo((DataFlowInfo)info, (DataFlowID)flowID, (int)3, (boolean)true, (boolean)true, null, (ModuleURN)ClientModuleFactory.INSTANCE_URN);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[0], (ModuleURN)senderURN, (boolean)true, (int)1, (int)0, null, (boolean)false, (int)0, (int)0, null, null, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[1], (ModuleURN)ClientModuleFactory.INSTANCE_URN, (boolean)true, (int)0, (int)0, null, (boolean)true, (int)1, (int)1, (String)Messages.SEND_ORDER_FAIL_NO_CONNECT.getText((Object)ObjectUtils.toString((Object)order)), (ModuleURN)ClientModuleFactory.INSTANCE_URN, null);
        ClientModuleTestBase.assertFlowStep((DataFlowStep)info.getFlowSteps()[2], (ModuleURN)SinkModuleFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)0, (int)0, null, (ModuleURN)SinkModuleFactory.INSTANCE_URN, null);
        this.mManager.stop(senderURN);
        this.mManager.deleteModule(senderURN);
    }

    @BeforeClass
    public static void serverSetup() throws Exception {
        sServer = new MockServer();
    }

    @AfterClass
    public static void serverCleanup() throws Exception {
        if (sServer != null) {
            sServer.close();
            sServer = null;
        }
    }

    @Before
    public void clearMessageHandler() {
        if (sServer != null) {
            sServer.getHandler().clear();
        }
    }

    @After
    public void clientCleanup() throws Exception {
        if (this.mManager != null) {
            this.mManager.stop();
        }
        this.mManager = null;
        if (ClientManager.isInitialized()) {
            ClientManager.getInstance().close();
        }
    }
}

